/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"



/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.

   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it
   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.


   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/


extern rtx_insn *gen_split_1 (rtx_insn *, rtx *);
extern rtx_insn *gen_split_2 (rtx_insn *, rtx *);
extern rtx_insn *gen_split_3 (rtx_insn *, rtx *);
extern rtx_insn *gen_split_4 (rtx_insn *, rtx *);
extern rtx_insn *gen_split_5 (rtx_insn *, rtx *);




static int
pattern0 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !arith_operand (operands[1], i1)
      || !arith_operand (operands[2], i1))
    return -1;
  return 0;
}

static int
pattern1 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      return pattern0 (x3, E_DImode); /* [-1, 0] */

    case E_SImode:
      if (pattern0 (x3, E_SImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

static int
pattern2 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != UNSPEC_VOLATILE
      || XVECLEN (x3, 0) != 3
      || XINT (x3, 1) != 201
      || GET_MODE (x3) != E_SImode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != UNSPEC_VOLATILE
      || XVECLEN (x5, 0) != 1
      || XINT (x5, 1) != 202
      || GET_MODE (x5) != E_SImode)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x7) != SET)
    return -1;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != UNSPEC_VOLATILE
      || XVECLEN (x8, 0) != 1
      || XINT (x8, 1) != 203
      || GET_MODE (x8) != E_SImode)
    return -1;
  x9 = XVECEXP (x8, 0, 0);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

static int
pattern3 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !register_operand (operands[1], E_DImode))
        return -1;
      return 0;

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !register_operand (operands[1], E_SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

static int
pattern4 (rtx x1, unsigned int i1, rtx_code i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != i2)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != i1)
    return -1;
  return 0;
}

static int
pattern5 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

static int
pattern6 (machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || !ordered_comparison_operator (operands[1], i2)
      || !register_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

static int
pattern7 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!cmp_op (operands[0], i1)
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || GET_MODE (x1) != i1)
    return -1;
  return 0;
}

static int
pattern8 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], E_SImode))
    return -1;
  x4 = XEXP (x2, 1);
  x5 = XVECEXP (x4, 0, 0);
  operands[2] = x5;
  if (!nonimmediate_operand (operands[2], E_SImode))
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  operands[3] = x6;
  if (!register_operand (operands[3], E_SImode))
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  operands[4] = x7;
  if (!register_operand (operands[4], E_SImode))
    return -1;
  x8 = XVECEXP (x1, 0, 1);
  x9 = XEXP (x8, 0);
  operands[1] = x9;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  x10 = XVECEXP (x1, 0, 3);
  operands[5] = x10;
  if (!const_int_operand (operands[5], E_SImode))
    return -1;
  x11 = XVECEXP (x1, 0, 4);
  operands[6] = x11;
  if (!const_int_operand (operands[6], E_SImode))
    return -1;
  x12 = XVECEXP (x1, 0, 5);
  operands[7] = x12;
  if (!const_int_operand (operands[7], E_SImode))
    return -1;
  return 0;
}

static int
recog_1 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (pattern5 (x3, E_SFmode) != 0
          || !
#line 481 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HARD_FLOAT))
        return -1;
      return 3; /* addsf3 */

    case E_DFmode:
      if (pattern5 (x3, E_DFmode) != 0
          || !
#line 550 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_HARD_FLOAT && TARGET_FLOAT_CONVERT))
        return -1;
      return 10; /* adddf3 */

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode
          || !reg_or_0_operand (operands[1], E_SImode)
          || !arith_plus_operand (operands[2], E_SImode))
        return -1;
      return 17; /* addsi3 */

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || !register_operand (operands[1], E_DImode))
        return -1;
      if (immediate_operand (operands[2], E_DImode)
          && 
#line 661 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && ((long long)INTVAL(operands[2]) > (long long)-32768) && ((long long) INTVAL(operands[2]) < (long long)32767)))
        return 18; /* adddi3_int */
      if (arith_plus_operand (operands[2], E_DImode)
          && 
#line 673 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
        return 19; /* *adddi3_long */
      if (!arith_operand (operands[2], E_DImode)
          || !
#line 685 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_MB_64))
        return -1;
      return 20; /* *adddi3_all */

    default:
      return -1;
    }
}

static int
recog_2 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (pattern5 (x3, E_SFmode) != 0
          || !
#line 491 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HARD_FLOAT))
        return -1;
      return 4; /* subsf3 */

    case E_DFmode:
      if (pattern5 (x3, E_DFmode) != 0
          || !
#line 560 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_HARD_FLOAT && TARGET_FLOAT_CONVERT))
        return -1;
      return 11; /* subdf3 */

    case E_SImode:
      if (pattern0 (x3, E_SImode) != 0)
        return -1;
      return 21; /* subsi3 */

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || !register_operand (operands[1], E_DImode))
        return -1;
      if (arith_operand (operands[2], E_DImode))
        {
          if (
#line 738 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && ((long long)INTVAL(operands[2]) > (long long)-32768) && ((long long) INTVAL(operands[2]) < (long long)32767) && (REGNO (operands[0]) == REGNO (operands[1]))))
            return 23; /* subdi316imm */
          if (
#line 750 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return 24; /* subsidi3 */
        }
      if (!register_operand (operands[2], E_DImode)
          || !
#line 763 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_MB_64))
        return -1;
      return 25; /* subdi3_small */

    default:
      return -1;
    }
}

static int
recog_3 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
      operands[1] = x4;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SFmode:
          if (pattern5 (x3, E_SFmode) != 0
              || !
#line 501 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HARD_FLOAT))
            return -1;
          return 5; /* mulsf3 */

        case E_DFmode:
          if (pattern5 (x3, E_DFmode) != 0
              || !
#line 570 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_HARD_FLOAT && TARGET_FLOAT_CONVERT))
            return -1;
          return 12; /* muldf3 */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || !register_operand (operands[1], E_SImode)
              || !arith_operand (operands[2], E_SImode)
              || !
#line 778 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_MUL))
            return -1;
          return 26; /* mulsi3 */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      if (GET_MODE (x4) != E_DImode)
        return -1;
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != SIGN_EXTEND
          || GET_MODE (x5) != E_DImode
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      x7 = XEXP (x5, 0);
      operands[2] = x7;
      if (!register_operand (operands[2], E_SImode)
          || !
#line 792 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_MUL && TARGET_MULTIPLY_HIGH && !TARGET_MB_64))
        return -1;
      return 27; /* mulsidi3 */

    case ZERO_EXTEND:
      if (GET_MODE (x4) != E_DImode
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      x5 = XEXP (x3, 1);
      if (GET_MODE (x5) != E_DImode)
        return -1;
      switch (GET_CODE (x5))
        {
        case ZERO_EXTEND:
          x7 = XEXP (x5, 0);
          operands[2] = x7;
          if (!register_operand (operands[2], E_SImode)
              || !
#line 803 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_MUL && TARGET_MULTIPLY_HIGH && !TARGET_MB_64))
            return -1;
          return 28; /* umulsidi3 */

        case SIGN_EXTEND:
          x7 = XEXP (x5, 0);
          operands[2] = x7;
          if (!register_operand (operands[2], E_SImode)
              || !
#line 814 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_MUL && TARGET_MULTIPLY_HIGH && !TARGET_MB_64))
            return -1;
          return 29; /* usmulsidi3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

static int
recog_4 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != LSHIFTRT
      || GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != MULT
      || GET_MODE (x4) != E_DImode)
    return -1;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 32])
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  if (!register_operand (operands[0], E_SImode))
    return -1;
  x7 = XEXP (x4, 0);
  if (GET_MODE (x7) != E_DImode)
    return -1;
  x8 = XEXP (x4, 1);
  if (GET_MODE (x8) != E_DImode)
    return -1;
  switch (GET_CODE (x7))
    {
    case SIGN_EXTEND:
      if (GET_CODE (x8) != SIGN_EXTEND)
        return -1;
      x9 = XEXP (x7, 0);
      operands[1] = x9;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      x10 = XEXP (x8, 0);
      operands[2] = x10;
      if (!register_operand (operands[2], E_SImode)
          || !
#line 827 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_MUL && TARGET_MULTIPLY_HIGH))
        return -1;
      return 30; /* *smulsi3_highpart */

    case ZERO_EXTEND:
      x9 = XEXP (x7, 0);
      operands[1] = x9;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      switch (GET_CODE (x8))
        {
        case ZERO_EXTEND:
          x10 = XEXP (x8, 0);
          operands[2] = x10;
          if (!register_operand (operands[2], E_SImode)
              || !
#line 841 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_MUL && TARGET_MULTIPLY_HIGH))
            return -1;
          return 31; /* *umulsi3_highpart */

        case SIGN_EXTEND:
          x10 = XEXP (x8, 0);
          operands[2] = x10;
          if (!register_operand (operands[2], E_SImode)
              || !
#line 855 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_MUL && TARGET_MULTIPLY_HIGH))
            return -1;
          return 32; /* *usmulsi3_highpart */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

static int
recog_5 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_SImode:
          if (!register_operand (operands[1], E_SImode))
            return -1;
          return 35; /* negsi2 */

        case E_DImode:
          if (!register_operand (operands[1], E_DImode))
            return -1;
          return 36; /* negsi_long */

        default:
          return -1;
        }

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || !register_operand (operands[1], E_DImode))
        return -1;
      if (
#line 973 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
        return 37; /* negdi2_long */
      return 38; /* negdi2 */

    default:
      return -1;
    }
}

static int
recog_6 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode
          || !register_operand (operands[1], E_SImode))
        return -1;
      return 39; /* one_cmplsi2 */

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      if (arith_operand (operands[1], E_DImode)
          && 
#line 1009 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
        return 40; /* *microblaze.md:1006 */
      if (!register_operand (operands[1], E_DImode))
        return -1;
      return 41; /* *microblaze.md:1015 */

    default:
      return -1;
    }
}

static int
recog_7 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode))
            return -1;
          return 51; /* zero_extendhisi2 */

        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode))
            return -1;
          return 53; /* zero_extendqisi2 */

        default:
          return -1;
        }

    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x3) != E_HImode
          || !nonimmediate_operand (operands[1], E_QImode))
        return -1;
      return 52; /* zero_extendqihi2 */

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_HImode:
          if (!register_operand (operands[1], E_HImode)
              || !
#line 1197 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return -1;
          return 54; /* zero_extendhidi2 */

        case E_SImode:
          if (!register_operand (operands[1], E_SImode)
              || !
#line 1206 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return -1;
          return 55; /* zero_extendsidi2 */

        case E_QImode:
          if (!register_operand (operands[1], E_QImode)
              || !
#line 1215 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return -1;
          return 56; /* zero_extendqidi2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

static int
recog_8 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_QImode:
          if (!register_operand (operands[1], E_QImode))
            return -1;
          return 57; /* extendqisi2 */

        case E_HImode:
          if (!register_operand (operands[1], E_HImode))
            return -1;
          return 58; /* extendhisi2 */

        default:
          return -1;
        }

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_HImode:
          if (!register_operand (operands[1], E_HImode)
              || !
#line 1248 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return -1;
          return 59; /* extendhidi2 */

        case E_SImode:
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          if (
#line 1261 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return 60; /* extendsidi2_long */
          return 61; /* extendsidi2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

static int
recog_9 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
      operands[0] = x2;
      x3 = XEXP (x1, 1);
      operands[1] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || !register_operand (operands[1], E_DImode)
              || !
#line 1348 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(microblaze_is_interrupt_variant () && TARGET_MB_64))
            return -1;
          return 62; /* movdi_status */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || !register_operand (operands[1], E_SImode)
              || !
#line 1531 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(microblaze_is_interrupt_variant ()))
            return -1;
          return 69; /* movsi_status */

        default:
          return -1;
        }

    case PC:
      x3 = XEXP (x1, 1);
      operands[0] = x3;
      if (!register_operand (operands[0], E_VOIDmode))
        return -1;
      return 121; /* indirect_jump_internal1 */

    case ZERO_EXTRACT:
      if (GET_MODE (x2) != E_SImode)
        return -1;
      x4 = XEXP (x2, 0);
      operands[0] = x4;
      if (!register_operand (operands[0], E_SImode))
        return -1;
      x5 = XEXP (x2, 1);
      operands[1] = x5;
      if (!immediate_operand (operands[1], E_SImode))
        return -1;
      x6 = XEXP (x2, 2);
      operands[2] = x6;
      if (!immediate_operand (operands[2], E_SImode))
        return -1;
      x3 = XEXP (x1, 1);
      operands[3] = x3;
      if (!register_operand (operands[3], E_SImode)
          || !
#line 3659 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HAS_BITFIELD && UINTVAL (operands[1]) > 0
   && UINTVAL (operands[1]) + UINTVAL (operands[2]) <= 32))
        return -1;
      return 145; /* insv_32 */

    default:
      return -1;
    }
}

static int
recog_10 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
      res = recog_9 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[1] = x2;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (nonimmediate_operand (operands[0], E_DImode)
              && immediate_operand (operands[1], E_DImode)
              && 
#line 1361 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && (register_operand (operands[0], DImode) && 
           (GET_CODE (operands[1]) == CONST_INT))))
            return 63; /* *movdi_internal3 */
          break;

        case E_SImode:
          if (nonimmediate_operand (operands[0], E_SImode)
              && immediate_operand (operands[1], E_SImode)
              && 
#line 1544 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
((register_operand (operands[0], SImode) && 
           (GET_CODE (operands[1]) == CONST_INT && 
                 (INTVAL (operands[1]) <= 32767 && INTVAL (operands[1]) >= -32768)))))
            return 70; /* *movsi_internal3 */
          break;

        default:
          break;
        }
      if (GET_CODE (x2) == LABEL_REF
          && GET_CODE (x3) == PC)
        {
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          if (
#line 2904 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return 119; /* jump_64 */
          return 120; /* jump */
        }
      break;

    default:
      break;
    }
  operands[1] = x2;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      if (!nonimmediate_operand (operands[0], E_HImode)
          || !general_operand (operands[1], E_HImode))
        return -1;
      return 73; /* *movhi_internal2 */

    case E_QImode:
      if (!nonimmediate_operand (operands[0], E_QImode)
          || !general_operand (operands[1], E_QImode))
        return -1;
      return 74; /* *movqi_internal2 */

    case E_SFmode:
      if (!nonimmediate_operand (operands[0], E_SFmode)
          || !general_operand (operands[1], E_SFmode)
          || !
#line 1726 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
((register_operand (operands[0], SFmode)
       || register_operand (operands[1], SFmode)
       || operands[1] == CONST0_RTX (SFmode))))
        return -1;
      return 76; /* *movsf_internal */

    case E_DFmode:
      if (!nonimmediate_operand (operands[0], E_DFmode)
          || !general_operand (operands[1], E_DFmode))
        return -1;
      if (
#line 1778 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_BARREL_SHIFT))
        return 77; /* *movdf_internal_64_bshift */
      if (
#line 1805 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
        return 78; /* *movdf_internal_64 */
      return 79; /* *movdf_internal */

    default:
      return -1;
    }
}

static int
recog_11 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
      operands[0] = x3;
      x4 = XEXP (x1, 0);
      if (GET_CODE (x4) != PC)
        return -1;
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      if (x6 == const_int_rtx[MAX_SAVED_CONST_INT + 0])
        {
          x7 = XEXP (x2, 1);
          operands[2] = x7;
          if (pc_or_label_operand (operands[2], E_VOIDmode)
              && ordered_comparison_operator (operands[0], E_VOIDmode)
              && register_operand (operands[1], E_SImode))
            {
              x8 = XEXP (x2, 2);
              operands[3] = x8;
              if (pc_or_label_operand (operands[3], E_VOIDmode)
                  && 
#line 2682 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
                return 113; /* branch_zero_64 */
            }
          if (pc_or_label_operand (operands[2], E_DImode)
              && ordered_comparison_operator (operands[0], E_DImode)
              && register_operand (operands[1], E_DImode))
            {
              x8 = XEXP (x2, 2);
              operands[3] = x8;
              if (pc_or_label_operand (operands[3], E_DImode)
                  && 
#line 2702 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
                return 114; /* long_branch_zero */
            }
          if (pc_or_label_operand (operands[2], E_SImode)
              && ordered_comparison_operator (operands[0], E_SImode)
              && register_operand (operands[1], E_SImode))
            {
              x8 = XEXP (x2, 2);
              operands[3] = x8;
              if (pc_or_label_operand (operands[3], E_SImode))
                return 115; /* branch_zero */
            }
        }
      if (pnum_clobbers == NULL)
        return -1;
      switch (GET_CODE (operands[0]))
        {
        case GE:
        case GT:
        case LE:
        case LT:
        case GEU:
        case GTU:
        case LEU:
        case LTU:
          x7 = XEXP (x2, 1);
          if (GET_CODE (x7) != LABEL_REF)
            return -1;
          x8 = XEXP (x2, 2);
          if (GET_CODE (x8) != PC)
            return -1;
          operands[2] = x6;
          x9 = XEXP (x7, 0);
          operands[3] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!cmp_op (operands[0], E_SImode)
                  || !register_operand (operands[1], E_SImode)
                  || !register_operand (operands[2], E_SImode))
                return -1;
              if (
#line 2743 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
                {
                  *pnum_clobbers = 1;
                  return 116; /* branch_compare64 */
                }
              *pnum_clobbers = 1;
              return 118; /* branch_compare */

            case E_DImode:
              if (!cmp_op (operands[0], E_DImode)
                  || !register_operand (operands[1], E_DImode)
                  || !register_operand (operands[2], E_DImode)
                  || !
#line 2784 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
                return -1;
              *pnum_clobbers = 1;
              return 117; /* long_branch_compare */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

static int
recog_12 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case BSWAP:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (register_operand (operands[0], E_SImode)
              && GET_MODE (x2) == E_SImode
              && register_operand (operands[1], E_SImode)
              && 
#line 444 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_REORDER))
            return 1; /* bswapsi2 */
          break;

        case E_HImode:
          if (register_operand (operands[0], E_HImode)
              && GET_MODE (x2) == E_HImode
              && register_operand (operands[1], E_HImode)
              && 
#line 454 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_REORDER))
            return 2; /* bswaphi2 */
          break;

        default:
          break;
        }
      break;

    case PLUS:
      res = recog_1 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case MINUS:
      res = recog_2 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case MULT:
      res = recog_3 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case DIV:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      x5 = XEXP (x2, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SFmode:
          if (pattern5 (x2, E_SFmode) == 0
              && 
#line 511 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HARD_FLOAT))
            return 6; /* divsf3 */
          break;

        case E_DFmode:
          if (pattern5 (x2, E_DFmode) == 0
              && 
#line 580 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_HARD_FLOAT && TARGET_FLOAT_CONVERT))
            return 13; /* divdf3 */
          break;

        case E_SImode:
          if (pattern5 (x2, E_SImode) == 0
              && 
#line 891 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_DIV))
            return 33; /* divsi3_internal */
          break;

        default:
          break;
        }
      break;

    case SQRT:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_SFmode:
          if (register_operand (operands[0], E_SFmode)
              && GET_MODE (x2) == E_SFmode
              && register_operand (operands[1], E_SFmode)
              && 
#line 521 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HARD_FLOAT && TARGET_FLOAT_SQRT))
            return 7; /* sqrtsf2 */
          break;

        case E_DFmode:
          if (register_operand (operands[0], E_DFmode)
              && GET_MODE (x2) == E_DFmode
              && register_operand (operands[1], E_DFmode)
              && 
#line 590 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_HARD_FLOAT && TARGET_FLOAT_CONVERT))
            return 14; /* sqrtdf2 */
          break;

        default:
          break;
        }
      break;

    case FLOAT:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_SFmode:
          if (register_operand (operands[0], E_SFmode)
              && GET_MODE (x2) == E_SFmode
              && register_operand (operands[1], E_SImode)
              && 
#line 530 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HARD_FLOAT && TARGET_FLOAT_CONVERT))
            return 8; /* floatsisf2 */
          break;

        case E_DFmode:
          if (register_operand (operands[0], E_DFmode)
              && GET_MODE (x2) == E_DFmode
              && register_operand (operands[1], E_DImode)
              && 
#line 599 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_HARD_FLOAT && TARGET_FLOAT_CONVERT))
            return 15; /* floatdidf2 */
          break;

        default:
          break;
        }
      break;

    case FIX:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XEXP (x2, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
          operands[1] = x4;
          if (register_operand (operands[1], E_SFmode)
              && register_operand (operands[0], E_SImode)
              && GET_MODE (x2) == E_SImode
              && 
#line 539 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HARD_FLOAT && TARGET_FLOAT_CONVERT))
            return 9; /* fix_truncsfsi2 */
          break;

        case FIX:
          if (GET_MODE (x4) == E_DFmode
              && register_operand (operands[0], E_DImode)
              && GET_MODE (x2) == E_DImode)
            {
              x6 = XEXP (x4, 0);
              operands[1] = x6;
              if (register_operand (operands[1], E_DFmode)
                  && 
#line 608 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_HARD_FLOAT && TARGET_FLOAT_CONVERT))
                return 16; /* fix_truncdfdi2 */
            }
          break;

        default:
          break;
        }
      break;

    case TRUNCATE:
      res = recog_4 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case UDIV:
      if (GET_MODE (x2) == E_SImode)
        {
          x3 = XEXP (x1, 0);
          operands[0] = x3;
          if (register_operand (operands[0], E_SImode))
            {
              x4 = XEXP (x2, 0);
              operands[1] = x4;
              if (register_operand (operands[1], E_SImode))
                {
                  x5 = XEXP (x2, 1);
                  operands[2] = x5;
                  if (register_operand (operands[2], E_SImode)
                      && 
#line 903 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_DIV))
                    return 34; /* udivsi3 */
                }
            }
        }
      break;

    case NEG:
      res = recog_5 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case NOT:
      res = recog_6 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case AND:
      switch (pattern1 (x1))
        {
        case 0:
          if (
#line 1046 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && ((long long)INTVAL(operands[2]) > (long long)-32768) && ((long long) INTVAL(operands[2]) < (long long)32767)))
            return 42; /* anddi3imm16 */
          if (
#line 1057 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return 43; /* anddi3 */
          break;

        case 1:
          return 44; /* andsi3 */

        default:
          break;
        }
      break;

    case IOR:
      switch (pattern1 (x1))
        {
        case 0:
          if (
#line 1084 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && ((long long)INTVAL(operands[2]) > (long long)-32768) && ((long long) INTVAL(operands[2]) < (long long)32767)))
            return 45; /* iordi3imm16 */
          if (
#line 1095 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return 46; /* iordi3 */
          break;

        case 1:
          return 47; /* iorsi3 */

        default:
          break;
        }
      break;

    case XOR:
      switch (pattern1 (x1))
        {
        case 0:
          if (
#line 1121 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && ((long long)INTVAL(operands[2]) > (long long)-32768) && ((long long) INTVAL(operands[2]) < (long long)32767)))
            return 48; /* xordi3imm16 */
          if (
#line 1132 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return 49; /* xordi3 */
          break;

        case 1:
          return 50; /* xorsi3 */

        default:
          break;
        }
      break;

    case ZERO_EXTEND:
      res = recog_7 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case SIGN_EXTEND:
      res = recog_8 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      res = recog_10 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case IF_THEN_ELSE:
      res = recog_11 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    default:
      break;
    }
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (register_operand (operands[0], E_DImode)
          && call_insn_operand (operands[1], E_DImode)
          && 
#line 1375 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && (register_operand (operands[0], Pmode) && 
           PLT_ADDR_P (operands[1]))))
        return 64; /* *movdi_internal5_pltop */
      if (nonimmediate_operand (operands[0], E_DImode))
        {
          if (move_src_operand (operands[1], E_DImode))
            {
              if (
#line 1387 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_BARREL_SHIFT))
                return 65; /* *movdi_internal2_bshift */
              if (
#line 1415 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
                return 66; /* *movdi_internal2 */
            }
          if (general_operand (operands[1], E_DImode))
            {
              if (
#line 1453 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_MB_64))
                return 67; /* *movdi_internal */
              if (
#line 1508 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_BARREL_SHIFT))
                return 68; /* movdi_long_int */
            }
        }
      break;

    case E_SImode:
      if (register_operand (operands[0], E_SImode)
          && call_insn_operand (operands[1], E_SImode)
          && 
#line 1559 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
((register_operand (operands[0], Pmode) && 
           PLT_ADDR_P (operands[1]))))
        return 71; /* *movsi_internal5_pltop */
      if (nonimmediate_operand (operands[0], E_SImode)
          && move_src_operand (operands[1], E_SImode))
        return 72; /* *movsi_internal2 */
      break;

    default:
      break;
    }
  switch (GET_CODE (x2))
    {
    case BSWAP:
      if (GET_MODE (x2) != E_SImode
          || !reg_or_mem_operand (operands[0], E_SImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!reg_or_mem_operand (operands[1], E_SFmode)
          || !
#line 1693 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_REORDER))
        return -1;
      return 75; /* movsi4_rev */

    case ASHIFT:
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      x5 = XEXP (x2, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode
              || !register_operand (operands[1], E_SImode))
            return -1;
          if (arith_operand (operands[2], E_SImode))
            {
              if (
#line 1915 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
((operands[2] == const1_rtx)))
                return 80; /* *ashlsi3_byone */
              if (
#line 1927 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_BARREL_SHIFT))
                return 81; /* ashlsi3_bshift */
            }
          if (immediate_operand (operands[2], E_SImode))
            {
              if (
#line 2027 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_MUL 
   && ((1 << INTVAL (operands[2])) <= 32767 && (1 << INTVAL (operands[2])) >= -32768)))
                return 85; /* *ashlsi3_with_mul_delay */
              if (
#line 2043 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(!TARGET_SOFT_MUL))
                return 86; /* *ashlsi3_with_mul_nodelay */
              if (
#line 2058 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
((INTVAL (operands[2]) > 5 && optimize_size)))
                return 87; /* *ashlsi3_with_size_opt */
              if (
#line 2079 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
((INTVAL (operands[2]) > 17 && !optimize_size)))
                return 88; /* *ashlsi3_with_rotate */
              return 89; /* *ashlsi_inline */
            }
          if (!register_operand (operands[2], E_SImode))
            return -1;
          return 90; /* *ashlsi_reg */

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !register_operand (operands[1], E_DImode))
            return -1;
          if (arith_operand (operands[2], E_DImode)
              && 
#line 1968 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_BARREL_SHIFT))
            return 82; /* ashldi3_long */
          if (immediate_operand (operands[2], E_DImode)
              && 
#line 1981 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return 83; /* ashldi3_const */
          if (!register_operand (operands[2], E_DImode)
              || !
#line 2002 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return -1;
          return 84; /* ashldi3_reg */

        default:
          return -1;
        }

    case ASHIFTRT:
      switch (pattern3 (x2))
        {
        case 0:
          if (arith_operand (operands[2], E_DImode)
              && 
#line 2178 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_BARREL_SHIFT))
            return 91; /* ashrdi3_long */
          if (immediate_operand (operands[2], E_DImode)
              && 
#line 2191 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return 92; /* ashrdi3_const */
          if (!register_operand (operands[2], E_DImode)
              || !
#line 2212 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return -1;
          return 93; /* ashrdi3_reg */

        case 1:
          if (arith_operand (operands[2], E_SImode))
            {
              if (
#line 2252 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
((operands[2] == const1_rtx)))
                return 94; /* *ashrsi3_byone */
              if (
#line 2264 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_BARREL_SHIFT))
                return 95; /* *ashrsi3_bshift */
            }
          if (immediate_operand (operands[2], E_SImode))
            {
              if (
#line 2277 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
((INTVAL (operands[2]) > 5 && optimize_size)))
                return 96; /* *ashrsi3_with_size_opt */
              return 97; /* *ashrsi_inline */
            }
          if (!register_operand (operands[2], E_SImode))
            return -1;
          return 98; /* *ashrsi_reg */

        default:
          return -1;
        }

    case LSHIFTRT:
      switch (pattern3 (x2))
        {
        case 0:
          if (arith_operand (operands[2], E_DImode)
              && 
#line 2372 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_BARREL_SHIFT))
            return 99; /* lshrdi3_long */
          if (immediate_operand (operands[2], E_DImode)
              && 
#line 2385 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return 100; /* lshrdi3_const */
          if (!register_operand (operands[2], E_DImode)
              || !
#line 2406 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return -1;
          return 101; /* lshrdi3_reg */

        case 1:
          if (arith_operand (operands[2], E_SImode))
            {
              if (
#line 2446 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
((operands[2] == const1_rtx)))
                return 102; /* *lshrsi3_byone */
              if (
#line 2458 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_BARREL_SHIFT))
                return 103; /* *lshrsi3_bshift */
            }
          if (immediate_operand (operands[2], E_SImode))
            {
              if (
#line 2471 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
((INTVAL (operands[2]) > 5 && optimize_size)))
                return 104; /* *lshrsi3_with_size_opt */
              return 105; /* *lshrsi_inline */
            }
          if (!register_operand (operands[2], E_SImode))
            return -1;
          return 106; /* *lshrsi_reg */

        default:
          return -1;
        }

    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      x5 = XEXP (x2, 1);
      operands[2] = x5;
      switch (GET_CODE (x2))
        {
        case EQ:
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (pattern5 (x2, E_DImode) == 0
                  && 
#line 2551 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_PATTERN_COMPARE))
                return 107; /* seq_internal_pat_long */
              break;

            case E_SImode:
              if (pattern5 (x2, E_SImode) == 0
                  && 
#line 2575 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_PATTERN_COMPARE))
                return 109; /* seq_internal_pat */
              break;

            default:
              break;
            }
          break;

        case NE:
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (pattern5 (x2, E_DImode) == 0
                  && 
#line 2563 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && TARGET_PATTERN_COMPARE))
                return 108; /* sne_internal_pat_long */
              break;

            case E_SImode:
              if (pattern5 (x2, E_SImode) == 0
                  && 
#line 2587 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_PATTERN_COMPARE))
                return 110; /* sne_internal_pat */
              break;

            default:
              break;
            }
          break;

        default:
          break;
        }
      operands[1] = x2;
      operands[2] = x4;
      operands[3] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern6 (E_SFmode, E_SImode) != 0
              || !
#line 2604 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HARD_FLOAT))
            return -1;
          return 111; /* cstoresf4 */

        case E_DImode:
          if (pattern6 (E_DFmode, E_DImode) != 0
              || !
#line 2616 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
            return -1;
          return 112; /* cstoredf4 */

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x2, 0) != 1)
        return -1;
      x7 = XVECEXP (x2, 0, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || GET_MODE (x2) != E_SImode)
        return -1;
      switch (XINT (x2, 1))
        {
        case 101:
          if (!register_operand (operands[0], E_VOIDmode))
            return -1;
          return 141; /* set_got */

        case 107:
          if (!register_operand (operands[0], E_SImode))
            return -1;
          return 142; /* set_text */

        default:
          return -1;
        }

    case CLZ:
      if (GET_MODE (x2) != E_SImode
          || !register_operand (operands[0], E_SImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_SImode)
          || !
#line 3580 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HAS_CLZ))
        return -1;
      return 143; /* clzsi2 */

    case ZERO_EXTRACT:
      if (GET_MODE (x2) != E_SImode
          || !register_operand (operands[0], E_SImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      x5 = XEXP (x2, 1);
      operands[2] = x5;
      if (!immediate_operand (operands[2], E_SImode))
        return -1;
      x8 = XEXP (x2, 2);
      operands[3] = x8;
      if (!immediate_operand (operands[3], E_SImode)
          || !
#line 3627 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_HAS_BITFIELD && (UINTVAL (operands[2]) > 0)
   && ((UINTVAL (operands[2]) + UINTVAL (operands[3])) <= 32)))
        return -1;
      return 144; /* extv_32 */

    default:
      return -1;
    }
}

int
recog (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22;
  int res ATTRIBUTE_UNUSED;
  recog_data.insn = NULL;
  switch (GET_CODE (x1))
    {
    case SET:
      return recog_12 (x1, insn, pnum_clobbers);

    case PARALLEL:
      switch (XVECLEN (x1, 0))
        {
        case 2:
          x2 = XVECEXP (x1, 0, 0);
          switch (GET_CODE (x2))
            {
            case UNSPEC:
              if (XVECLEN (x2, 0) != 1
                  || XINT (x2, 1) != 0)
                return -1;
              x3 = XVECEXP (x1, 0, 1);
              if (GET_CODE (x3) != CLOBBER)
                return -1;
              x4 = XEXP (x3, 0);
              if (GET_CODE (x4) != MEM
                  || GET_MODE (x4) != E_BLKmode)
                return -1;
              x5 = XEXP (x4, 0);
              if (GET_CODE (x5) != SCRATCH)
                return -1;
              x6 = XVECEXP (x2, 0, 0);
              operands[0] = x6;
              if (!const_int_operand (operands[0], E_SImode)
                  || !
#line 712 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_PREFETCH && !TARGET_MB_64))
                return -1;
              return 22; /* iprefetch */

            case SET:
              x7 = XEXP (x2, 1);
              switch (GET_CODE (x7))
                {
                case IF_THEN_ELSE:
                  x8 = XEXP (x7, 0);
                  switch (GET_CODE (x8))
                    {
                    case GE:
                    case GT:
                    case LE:
                    case LT:
                    case GEU:
                    case GTU:
                    case LEU:
                    case LTU:
                      operands[0] = x8;
                      x9 = XEXP (x7, 1);
                      if (GET_CODE (x9) != LABEL_REF)
                        return -1;
                      x10 = XEXP (x7, 2);
                      if (GET_CODE (x10) != PC
                          || pattern4 (x1, 18, PC) != 0)
                        return -1;
                      x11 = XEXP (x8, 0);
                      operands[1] = x11;
                      x12 = XEXP (x8, 1);
                      operands[2] = x12;
                      x13 = XEXP (x9, 0);
                      operands[3] = x13;
                      switch (GET_MODE (operands[0]))
                        {
                        case E_SImode:
                          x3 = XVECEXP (x1, 0, 1);
                          x4 = XEXP (x3, 0);
                          if (pattern7 (x4, E_SImode) != 0)
                            return -1;
                          if (
#line 2743 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
                            return 116; /* branch_compare64 */
                          return 118; /* branch_compare */

                        case E_DImode:
                          x3 = XVECEXP (x1, 0, 1);
                          x4 = XEXP (x3, 0);
                          if (pattern7 (x4, E_DImode) != 0
                              || !
#line 2784 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
                            return -1;
                          return 117; /* long_branch_compare */

                        default:
                          return -1;
                        }

                    default:
                      return -1;
                    }

                case REG:
                case SUBREG:
                  operands[0] = x7;
                  x14 = XEXP (x2, 0);
                  if (GET_CODE (x14) != PC)
                    return -1;
                  x3 = XVECEXP (x1, 0, 1);
                  if (GET_CODE (x3) != USE)
                    return -1;
                  x4 = XEXP (x3, 0);
                  if (GET_CODE (x4) != LABEL_REF)
                    return -1;
                  x5 = XEXP (x4, 0);
                  operands[1] = x5;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_SImode:
                      if (!register_operand (operands[0], E_SImode))
                        return -1;
                      return 122; /* tablejump_internal1 */

                    case E_DImode:
                      if (!register_operand (operands[0], E_DImode)
                          || !
#line 2990 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
                        return -1;
                      return 123; /* tablejump_internal2 */

                    default:
                      return -1;
                    }

                case PLUS:
                  x9 = XEXP (x7, 1);
                  if (GET_CODE (x9) != LABEL_REF)
                    return -1;
                  x14 = XEXP (x2, 0);
                  if (GET_CODE (x14) != PC)
                    return -1;
                  x3 = XVECEXP (x1, 0, 1);
                  if (GET_CODE (x3) != USE)
                    return -1;
                  x4 = XEXP (x3, 0);
                  if (GET_CODE (x4) != LABEL_REF)
                    return -1;
                  x8 = XEXP (x7, 0);
                  operands[0] = x8;
                  x13 = XEXP (x9, 0);
                  operands[1] = x13;
                  x5 = XEXP (x4, 0);
                  if (!rtx_equal_p (x5, operands[1]))
                    return -1;
                  switch (GET_MODE (x7))
                    {
                    case E_SImode:
                      if (!register_operand (operands[0], E_SImode)
                          || GET_MODE (x9) != E_SImode
                          || GET_MODE (x4) != E_SImode
                          || !
#line 3011 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(NEXT_INSN (as_a <rtx_insn *> (operands[1])) != 0
  && GET_CODE (PATTERN (NEXT_INSN (as_a <rtx_insn *> (operands[1])))) == ADDR_DIFF_VEC
  && flag_pic))
                        return -1;
                      return 124; /* *microblaze.md:3006 */

                    case E_DImode:
                      if (!register_operand (operands[0], E_DImode)
                          || GET_MODE (x9) != E_DImode
                          || GET_MODE (x4) != E_DImode
                          || !
#line 3036 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64 && NEXT_INSN (as_a <rtx_insn *> (operands[1])) != 0
  && GET_CODE (PATTERN (NEXT_INSN (as_a <rtx_insn *> (operands[1])))) == ADDR_DIFF_VEC
  && flag_pic))
                        return -1;
                      return 125; /* *microblaze.md:3031 */

                    default:
                      return -1;
                    }

                case CALL:
                  x8 = XEXP (x7, 0);
                  if (GET_CODE (x8) != MEM)
                    return -1;
                  x3 = XVECEXP (x1, 0, 1);
                  if (GET_CODE (x3) != CLOBBER)
                    return -1;
                  x14 = XEXP (x2, 0);
                  operands[0] = x14;
                  if (!register_operand (operands[0], E_VOIDmode))
                    return -1;
                  x11 = XEXP (x8, 0);
                  operands[1] = x11;
                  if (!call_insn_operand (operands[1], E_VOIDmode))
                    return -1;
                  x9 = XEXP (x7, 1);
                  operands[2] = x9;
                  x4 = XEXP (x3, 0);
                  operands[3] = x4;
                  if (!register_operand (operands[3], E_VOIDmode))
                    return -1;
                  if (
#line 3440 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
                    return 137; /* call_value_intern_64 */
                  return 138; /* call_value_intern */

                default:
                  return -1;
                }

            case RETURN:
              x3 = XVECEXP (x1, 0, 1);
              if (GET_CODE (x3) != USE)
                return -1;
              x4 = XEXP (x3, 0);
              operands[0] = x4;
              if (!register_operand (operands[0], E_VOIDmode))
                return -1;
              return 128; /* return_internal */

            case SIMPLE_RETURN:
              x3 = XVECEXP (x1, 0, 1);
              if (GET_CODE (x3) != USE)
                return -1;
              x4 = XEXP (x3, 0);
              operands[0] = x4;
              if (!register_operand (operands[0], E_VOIDmode))
                return -1;
              return 129; /* simple_return_internal */

            case CALL:
              if (pattern4 (x1, 15, MEM) != 0)
                return -1;
              x14 = XEXP (x2, 0);
              x15 = XEXP (x14, 0);
              operands[0] = x15;
              if (!call_insn_simple_operand (operands[0], E_VOIDmode))
                return -1;
              x7 = XEXP (x2, 1);
              operands[1] = x7;
              if (
#line 3281 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
                return 133; /* call_internal1_64 */
              return 134; /* call_internal1 */

            default:
              return -1;
            }

        case 3:
          x3 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x3) != CLOBBER)
            return -1;
          x16 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x16) != USE)
            return -1;
          x2 = XVECEXP (x1, 0, 0);
          switch (GET_CODE (x2))
            {
            case CALL:
              x14 = XEXP (x2, 0);
              if (GET_CODE (x14) != MEM)
                return -1;
              x4 = XEXP (x3, 0);
              if (GET_CODE (x4) != REG
                  || REGNO (x4) != 15)
                return -1;
              x17 = XEXP (x16, 0);
              if (GET_CODE (x17) != REG
                  || REGNO (x17) != 20)
                return -1;
              x15 = XEXP (x14, 0);
              operands[0] = x15;
              if (!call_insn_plt_operand (operands[0], E_VOIDmode))
                return -1;
              x7 = XEXP (x2, 1);
              operands[1] = x7;
              if (
#line 3250 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(flag_pic && TARGET_MB_64))
                return 131; /* call_internal_plt_64 */
              if (!
#line 3266 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(flag_pic))
                return -1;
              return 132; /* call_internal_plt */

            case SET:
              x7 = XEXP (x2, 1);
              if (GET_CODE (x7) != CALL)
                return -1;
              x8 = XEXP (x7, 0);
              if (GET_CODE (x8) != MEM)
                return -1;
              x14 = XEXP (x2, 0);
              operands[0] = x14;
              if (!register_operand (operands[0], E_VOIDmode))
                return -1;
              x11 = XEXP (x8, 0);
              operands[1] = x11;
              if (!call_insn_plt_operand (operands[1], E_VOIDmode))
                return -1;
              x9 = XEXP (x7, 1);
              operands[2] = x9;
              x4 = XEXP (x3, 0);
              operands[3] = x4;
              if (!register_operand (operands[3], E_VOIDmode))
                return -1;
              x17 = XEXP (x16, 0);
              operands[4] = x17;
              if (!register_operand (operands[4], E_VOIDmode))
                return -1;
              if (
#line 3406 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(flag_pic && TARGET_MB_64))
                return 135; /* call_value_intern_plt_64 */
              if (!
#line 3423 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(flag_pic))
                return -1;
              return 136; /* call_value_intern_plt */

            default:
              return -1;
            }

        case 7:
          if (pattern2 (x1) != 0)
            return -1;
          x18 = XVECEXP (x1, 0, 6);
          if (GET_CODE (x18) != CLOBBER
              || pattern8 (x1) != 0)
            return -1;
          x19 = XEXP (x18, 0);
          operands[8] = x19;
          if (!scratch_operand (operands[8], E_SImode))
            return -1;
          x16 = XVECEXP (x1, 0, 2);
          x17 = XEXP (x16, 0);
          if (!rtx_equal_p (x17, operands[2]))
            return -1;
          return 146; /* atomic_compare_and_swapsi */

        case 6:
          if (pnum_clobbers == NULL
              || pattern2 (x1) != 0
              || pattern8 (x1) != 0)
            return -1;
          x16 = XVECEXP (x1, 0, 2);
          x17 = XEXP (x16, 0);
          if (!rtx_equal_p (x17, operands[2]))
            return -1;
          *pnum_clobbers = 1;
          return 146; /* atomic_compare_and_swapsi */

        default:
          return -1;
        }

    case RETURN:
      return 126; /* *return */

    case SIMPLE_RETURN:
      return 127; /* *simple_return */

    case UNSPEC_VOLATILE:
      if (XVECLEN (x1, 0) != 1
          || XINT (x1, 1) != 0)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      return 130; /* blockage */

    case CALL:
      if (pnum_clobbers == NULL)
        return -1;
      x20 = XEXP (x1, 0);
      if (GET_CODE (x20) != MEM)
        return -1;
      x21 = XEXP (x20, 0);
      operands[0] = x21;
      if (!call_insn_simple_operand (operands[0], E_VOIDmode))
        return -1;
      x22 = XEXP (x1, 1);
      operands[1] = x22;
      if (
#line 3281 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(TARGET_MB_64))
        {
          *pnum_clobbers = 1;
          return 133; /* call_internal1_64 */
        }
      *pnum_clobbers = 1;
      return 134; /* call_internal1 */

    case CONST_INT:
      if (XWINT (x1, 0) != 0L)
        return -1;
      return 139; /* nop */

    case TRAP_IF:
      x20 = XEXP (x1, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x22 = XEXP (x1, 1);
      if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      return 140; /* trap */

    default:
      return -1;
    }
}

rtx_insn *
split_insns (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  recog_data.insn = NULL;
  if (GET_CODE (x1) != SET)
    return NULL;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  switch (GET_CODE (x3))
    {
    case NOT:
      if (GET_MODE (x3) != E_DImode
          || !register_operand (operands[0], E_DImode))
        return NULL;
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DImode)
          || !
#line 1028 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(reload_completed 
   && GET_CODE (operands[0]) == REG && GP_REG_P (REGNO (operands[0]))
   && GET_CODE (operands[1]) == REG && GP_REG_P (REGNO (operands[1]))
   && !TARGET_MB_64))
        return NULL;
      return gen_split_1 (insn, operands);

    case REG:
    case SUBREG:
      operands[1] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || !register_operand (operands[1], E_DImode))
            return NULL;
          if (
#line 1482 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(reload_completed 
   && GET_CODE (operands[0]) == REG && GP_REG_P (REGNO (operands[0]))
   && GET_CODE (operands[1]) == REG && GP_REG_P (REGNO (operands[1])) 
   && (REGNO(operands[0]) == (REGNO(operands[1]) + 1))
   && !(TARGET_MB_64)))
            return gen_split_2 (insn, operands);
          if (!
#line 1495 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(reload_completed 
   && GET_CODE (operands[0]) == REG && GP_REG_P (REGNO (operands[0]))
   && GET_CODE (operands[1]) == REG && GP_REG_P (REGNO (operands[1])) 
   && (REGNO (operands[0]) != (REGNO (operands[1]) + 1))
   && !(TARGET_MB_64)))
            return NULL;
          return gen_split_3 (insn, operands);

        case E_DFmode:
          if (!register_operand (operands[0], E_DFmode)
              || !register_operand (operands[1], E_DFmode))
            return NULL;
          if (
#line 1866 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(reload_completed
   && GET_CODE (operands[0]) == REG && GP_REG_P (REGNO (operands[0]))
   && GET_CODE (operands[1]) == REG && GP_REG_P (REGNO (operands[1]))
   && (REGNO (operands[0]) == (REGNO (operands[1]) + 1))
   && !TARGET_MB_64))
            return gen_split_4 (insn, operands);
          if (!
#line 1878 "../../../../../../../work-shared/gcc-12.2.0-r0/gcc-12.2.0/gcc/config/microblaze/microblaze.md"
(reload_completed
   && GET_CODE (operands[0]) == REG && GP_REG_P (REGNO (operands[0]))
   && GET_CODE (operands[1]) == REG && GP_REG_P (REGNO (operands[1]))
   && (REGNO (operands[0]) != (REGNO (operands[1]) + 1))
   && !TARGET_MB_64))
            return NULL;
          return gen_split_5 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

rtx_insn *
peephole2_insns (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx_insn *res ATTRIBUTE_UNUSED;
  recog_data.insn = NULL;
  return NULL;
}
