/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * This file was generated by the dom/make_names.pl script.
 *
 * Copyright (C) 2005, 2006, 2007, 2008, 2009, 2013 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#if ENABLE(MATHML)

#include "MathMLElementFactory.h"

#include "MathMLNames.h"

#include "MathMLTextElement.h"
#include "MathMLInlineContainerElement.h"
#include "MathMLSelectElement.h"
#include "MathMLElement.h"
#include "MathMLMathElement.h"
#include "MathMLMencloseElement.h"
#include "MathMLElement.h"

#include "Document.h"
#include "RuntimeEnabledFeatures.h"
#include "Settings.h"
#include <wtf/HashMap.h>
#include <wtf/NeverDestroyed.h>

namespace WebCore {

using namespace MathMLNames;

typedef Ref<MathMLElement> (*MathMLConstructorFunction)(const QualifiedName&, Document&, bool createdByParser);

static Ref<MathMLElement> textConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLTextElement::create(tagName, document);
}

static Ref<MathMLElement> inlinecontainerConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLInlineContainerElement::create(tagName, document);
}

static Ref<MathMLElement> selectConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLSelectElement::create(tagName, document);
}

static Ref<MathMLElement> Constructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLElement::create(tagName, document);
}

static Ref<MathMLElement> mathConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLMathElement::create(tagName, document);
}

static Ref<MathMLElement> mencloseConstructor(const QualifiedName& tagName, Document& document, bool)
{
    return MathMLMencloseElement::create(tagName, document);
}

static NEVER_INLINE void populateMathMLFactoryMap(HashMap<AtomicStringImpl*, MathMLConstructorFunction>& map)
{
    struct TableEntry {
        const QualifiedName& name;
        MathMLConstructorFunction function;
    };

    static const TableEntry table[] = {
        { annotationTag, textConstructor },
        { annotation_xmlTag, inlinecontainerConstructor },
        { mactionTag, selectConstructor },
        { maligngroupTag, Constructor },
        { malignmarkTag, Constructor },
        { mathTag, mathConstructor },
        { mencloseTag, mencloseConstructor },
        { merrorTag, inlinecontainerConstructor },
        { mfencedTag, inlinecontainerConstructor },
        { mfracTag, inlinecontainerConstructor },
        { mglyphTag, Constructor },
        { miTag, textConstructor },
        { mlabeledtrTag, Constructor },
        { mlongdivTag, Constructor },
        { mmultiscriptsTag, inlinecontainerConstructor },
        { mnTag, textConstructor },
        { moTag, textConstructor },
        { moverTag, inlinecontainerConstructor },
        { mpaddedTag, Constructor },
        { mphantomTag, inlinecontainerConstructor },
        { mprescriptsTag, inlinecontainerConstructor },
        { mrootTag, inlinecontainerConstructor },
        { mrowTag, inlinecontainerConstructor },
        { msTag, textConstructor },
        { mscarriesTag, Constructor },
        { mscarryTag, Constructor },
        { msgroupTag, Constructor },
        { mslineTag, Constructor },
        { mspaceTag, textConstructor },
        { msqrtTag, inlinecontainerConstructor },
        { msrowTag, Constructor },
        { mstackTag, Constructor },
        { mstyleTag, inlinecontainerConstructor },
        { msubTag, inlinecontainerConstructor },
        { msubsupTag, inlinecontainerConstructor },
        { msupTag, inlinecontainerConstructor },
        { mtableTag, inlinecontainerConstructor },
        { mtdTag, Constructor },
        { mtextTag, textConstructor },
        { mtrTag, Constructor },
        { munderTag, inlinecontainerConstructor },
        { munderoverTag, inlinecontainerConstructor },
        { noneTag, inlinecontainerConstructor },
        { semanticsTag, selectConstructor },
    };

    for (unsigned i = 0; i < WTF_ARRAY_LENGTH(table); ++i)
        map.add(table[i].name.localName().impl(), table[i].function);
}

RefPtr<MathMLElement> MathMLElementFactory::createKnownElement(const QualifiedName& name, Document& document, bool createdByParser)
{
    static NeverDestroyed<HashMap<AtomicStringImpl*, MathMLConstructorFunction>> functions;
    if (functions.get().isEmpty())
        populateMathMLFactoryMap(functions);
    MathMLConstructorFunction function = functions.get().get(name.localName().impl());
    if (LIKELY(function))
        return function(name, document, createdByParser);
    return nullptr;
}

Ref<MathMLElement> MathMLElementFactory::createElement(const QualifiedName& name, Document& document, bool createdByParser)
{
    RefPtr<MathMLElement> element = MathMLElementFactory::createKnownElement(name, document, createdByParser);
    if (LIKELY(element))
        return element.releaseNonNull();
    return MathMLElement::create(name, document);
}

} // namespace WebCore

#endif
