/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequestEventTarget.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnloadstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestEventTargetOnloadstart(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnprogress(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestEventTargetOnprogress(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnabort(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestEventTargetOnabort(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestEventTargetOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestEventTargetOnload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOntimeout(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestEventTargetOntimeout(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetOnloadend(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestEventTargetOnloadend(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXMLHttpRequestEventTargetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSXMLHttpRequestEventTargetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXMLHttpRequestEventTargetPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSXMLHttpRequestEventTargetPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXMLHttpRequestEventTargetPrototype* ptr = new (NotNull, JSC::allocateCell<JSXMLHttpRequestEventTargetPrototype>(vm.heap)) JSXMLHttpRequestEventTargetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXMLHttpRequestEventTargetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSXMLHttpRequestEventTarget> JSXMLHttpRequestEventTargetConstructor;

template<> JSValue JSXMLHttpRequestEventTargetConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSXMLHttpRequestEventTargetConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXMLHttpRequestEventTarget::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("XMLHttpRequestEventTarget"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSXMLHttpRequestEventTargetConstructor::s_info = { "XMLHttpRequestEventTarget", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestEventTargetConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestEventTargetPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetConstructor) } },
    { "onloadstart", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnloadstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnloadstart) } },
    { "onprogress", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnprogress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnprogress) } },
    { "onabort", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnabort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnabort) } },
    { "onerror", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnerror) } },
    { "onload", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnload) } },
    { "ontimeout", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOntimeout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOntimeout) } },
    { "onloadend", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestEventTargetOnloadend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXMLHttpRequestEventTargetOnloadend) } },
};

const ClassInfo JSXMLHttpRequestEventTargetPrototype::s_info = { "XMLHttpRequestEventTargetPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestEventTargetPrototype) };

void JSXMLHttpRequestEventTargetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXMLHttpRequestEventTargetPrototypeTableValues, *this);
}

const ClassInfo JSXMLHttpRequestEventTarget::s_info = { "XMLHttpRequestEventTarget", &Base::s_info, 0, CREATE_METHOD_TABLE(JSXMLHttpRequestEventTarget) };

JSXMLHttpRequestEventTarget::JSXMLHttpRequestEventTarget(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XMLHttpRequestEventTarget>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSXMLHttpRequestEventTarget::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSXMLHttpRequestEventTargetPrototype::create(vm, globalObject, JSXMLHttpRequestEventTargetPrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSXMLHttpRequestEventTarget::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXMLHttpRequestEventTarget>(vm, globalObject);
}

EncodedJSValue jsXMLHttpRequestEventTargetOnloadstart(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequestEventTarget", "onloadstart");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadstartEvent));
}


EncodedJSValue jsXMLHttpRequestEventTargetOnprogress(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequestEventTarget", "onprogress");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().progressEvent));
}


EncodedJSValue jsXMLHttpRequestEventTargetOnabort(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequestEventTarget", "onabort");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().abortEvent));
}


EncodedJSValue jsXMLHttpRequestEventTargetOnerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequestEventTarget", "onerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().errorEvent));
}


EncodedJSValue jsXMLHttpRequestEventTargetOnload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequestEventTarget", "onload");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadEvent));
}


EncodedJSValue jsXMLHttpRequestEventTargetOntimeout(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequestEventTarget", "ontimeout");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().timeoutEvent));
}


EncodedJSValue jsXMLHttpRequestEventTargetOnloadend(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "XMLHttpRequestEventTarget", "onloadend");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().loadendEvent));
}


EncodedJSValue jsXMLHttpRequestEventTargetConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSXMLHttpRequestEventTargetPrototype* domObject = jsDynamicCast<JSXMLHttpRequestEventTargetPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSXMLHttpRequestEventTarget::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSXMLHttpRequestEventTargetConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSXMLHttpRequestEventTargetPrototype* domObject = jsDynamicCast<JSXMLHttpRequestEventTargetPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSXMLHttpRequestEventTargetOnloadstart(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequestEventTarget* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequestEventTarget", "onloadstart");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadstartEvent, value);
}


void setJSXMLHttpRequestEventTargetOnprogress(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequestEventTarget* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequestEventTarget", "onprogress");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().progressEvent, value);
}


void setJSXMLHttpRequestEventTargetOnabort(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequestEventTarget* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequestEventTarget", "onabort");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().abortEvent, value);
}


void setJSXMLHttpRequestEventTargetOnerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequestEventTarget* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequestEventTarget", "onerror");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().errorEvent, value);
}


void setJSXMLHttpRequestEventTargetOnload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequestEventTarget* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequestEventTarget", "onload");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadEvent, value);
}


void setJSXMLHttpRequestEventTargetOntimeout(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequestEventTarget* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequestEventTarget", "ontimeout");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().timeoutEvent, value);
}


void setJSXMLHttpRequestEventTargetOnloadend(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSXMLHttpRequestEventTarget* castedThis = jsDynamicCast<JSXMLHttpRequestEventTarget*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "XMLHttpRequestEventTarget", "onloadend");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadendEvent, value);
}


JSValue JSXMLHttpRequestEventTarget::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXMLHttpRequestEventTargetConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSXMLHttpRequestEventTarget::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSXMLHttpRequestEventTarget*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

XMLHttpRequestEventTarget* JSXMLHttpRequestEventTarget::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXMLHttpRequestEventTarget*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
