/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWorkerGlobalScope.h"

#include "ExceptionCode.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMURL.h"
#include "JSErrorHandler.h"
#include "JSEventListener.h"
#include "JSEventSource.h"
#include "JSFileReader.h"
#include "JSFileReaderSync.h"
#include "JSImageData.h"
#include "JSMessageEvent.h"
#include "JSWorkerGlobalScope.h"
#include "JSWorkerLocation.h"
#include "JSWorkerNavigator.h"
#include "JSXMLHttpRequest.h"
#include "JSXMLHttpRequestEventTarget.h"
#include "WorkerGlobalScope.h"
#include "WorkerGlobalScopeIndexedDatabase.h"
#include "WorkerLocation.h"
#include "WorkerNavigator.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

#if ENABLE(CHANNEL_MESSAGING)
#include "JSMessageChannel.h"
#endif

#if ENABLE(FETCH_API)
#include "JSFetchHeaders.h"
#include "JSFetchRequest.h"
#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
#include "IDBFactory.h"
#include "JSIDBCursor.h"
#include "JSIDBCursorWithValue.h"
#include "JSIDBDatabase.h"
#include "JSIDBFactory.h"
#include "JSIDBIndex.h"
#include "JSIDBKeyRange.h"
#include "JSIDBObjectStore.h"
#include "JSIDBOpenDBRequest.h"
#include "JSIDBRequest.h"
#include "JSIDBTransaction.h"
#include "JSIDBVersionChangeEvent.h"
#endif

#if ENABLE(STREAMS_API)
#include "JSByteLengthQueuingStrategy.h"
#include "JSCountQueuingStrategy.h"
#include "JSReadableStream.h"
#endif

#if ENABLE(WEB_SOCKETS)
#include "JSWebSocket.h"
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionClose(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionImportScripts(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionSetTimeout(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionClearTimeout(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionSetInterval(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionClearInterval(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsWorkerGlobalScopeSelf(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerGlobalScopeLocation(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerGlobalScopeOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeOnoffline(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeOnoffline(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeOnonline(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeOnonline(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeNavigator(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWorkerGlobalScopeWebkitURLConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWebkitURLConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(FETCH_API)
JSC::EncodedJSValue jsWorkerGlobalScopeHeadersConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeHeadersConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(FETCH_API)
JSC::EncodedJSValue jsWorkerGlobalScopeRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsWorkerGlobalScopeByteLengthQueuingStrategyConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeByteLengthQueuingStrategyConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsWorkerGlobalScopeCountQueuingStrategyConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeCountQueuingStrategyConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsWorkerGlobalScopeReadableStreamConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeReadableStreamConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_SOCKETS)
JSC::EncodedJSValue jsWorkerGlobalScopeWebSocketConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWebSocketConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CHANNEL_MESSAGING)
JSC::EncodedJSValue jsWorkerGlobalScopeMessageChannelConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeMessageChannelConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsWorkerGlobalScopeMessageEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeMessageEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeBlobConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeBlobConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeFileReaderConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeFileReaderConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeFileReaderSyncConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeFileReaderSyncConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeURLConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeURLConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeImageDataConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeImageDataConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeEventSourceConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeEventSourceConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeWorkerGlobalScopeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWorkerGlobalScopeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeWorkerLocationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWorkerLocationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeXMLHttpRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeXMLHttpRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsWorkerGlobalScopeXMLHttpRequestEventTargetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeXMLHttpRequestEventTargetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeWebkitIndexedDB(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeWebkitIDBCursorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWebkitIDBCursorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeWebkitIDBDatabaseConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWebkitIDBDatabaseConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeWebkitIDBFactoryConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWebkitIDBFactoryConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeWebkitIDBIndexConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWebkitIDBIndexConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeWebkitIDBKeyRangeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWebkitIDBKeyRangeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeWebkitIDBObjectStoreConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWebkitIDBObjectStoreConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeWebkitIDBRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWebkitIDBRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeWebkitIDBTransactionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeWebkitIDBTransactionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIndexedDB(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBCursorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBCursorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBCursorWithValueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBCursorWithValueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBDatabaseConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBDatabaseConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBFactoryConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBFactoryConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBIndexConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBIndexConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBKeyRangeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBKeyRangeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBObjectStoreConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBObjectStoreConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBOpenDBRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBOpenDBRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBRequestConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBTransactionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBTransactionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
JSC::EncodedJSValue jsWorkerGlobalScopeIDBVersionChangeEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeIDBVersionChangeEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsWorkerGlobalScopeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWorkerGlobalScopeConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

typedef JSDOMConstructorNotConstructable<JSWorkerGlobalScope> JSWorkerGlobalScopeConstructor;

/* Hash table */

static const struct CompactHashIndex JSWorkerGlobalScopeTableIndex[135] = {
    { -1, -1 },
    { 31, 134 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 40, -1 },
    { 3, -1 },
    { 32, -1 },
    { 49, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 35, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 48, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 26, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 23, -1 },
    { -1, -1 },
    { 7, -1 },
    { -1, -1 },
    { -1, -1 },
    { 43, -1 },
    { -1, -1 },
    { 0, -1 },
    { -1, -1 },
    { 39, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 14, -1 },
    { 11, -1 },
    { -1, -1 },
    { 30, -1 },
    { 1, -1 },
    { -1, -1 },
    { 17, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 47, -1 },
    { 16, -1 },
    { 9, -1 },
    { 46, -1 },
    { 29, -1 },
    { -1, -1 },
    { 51, -1 },
    { -1, -1 },
    { 18, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 33, -1 },
    { -1, -1 },
    { 44, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 19, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 42, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 13, 129 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 38, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 12, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 22, -1 },
    { -1, -1 },
    { -1, -1 },
    { 6, 128 },
    { -1, -1 },
    { -1, -1 },
    { 5, -1 },
    { 41, -1 },
    { 2, -1 },
    { -1, -1 },
    { 8, 131 },
    { -1, -1 },
    { 21, 132 },
    { -1, -1 },
    { -1, -1 },
    { 20, -1 },
    { 4, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 50, -1 },
    { 10, -1 },
    { 27, 133 },
    { 45, -1 },
    { -1, -1 },
    { -1, -1 },
    { 15, 130 },
    { 24, -1 },
    { 25, -1 },
    { 28, -1 },
    { 34, -1 },
    { 36, -1 },
    { 37, -1 },
};


static const HashTableValue JSWorkerGlobalScopeTableValues[] =
{
    { "self", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeSelf), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "location", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeLocation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onerror", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeOnerror) } },
    { "onoffline", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeOnoffline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeOnoffline) } },
    { "ononline", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeOnonline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeOnonline) } },
    { "navigator", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeNavigator), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitURL", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitURLConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWebkitURLConstructor) } },
#if ENABLE(FETCH_API)
    { "Headers", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeHeadersConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeHeadersConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FETCH_API)
    { "Request", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeRequestConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(STREAMS_API)
    { "ByteLengthQueuingStrategy", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeByteLengthQueuingStrategyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeByteLengthQueuingStrategyConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(STREAMS_API)
    { "CountQueuingStrategy", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeCountQueuingStrategyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeCountQueuingStrategyConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(STREAMS_API)
    { "ReadableStream", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeReadableStreamConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeReadableStreamConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_SOCKETS)
    { "WebSocket", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebSocketConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWebSocketConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(CHANNEL_MESSAGING)
    { "MessageChannel", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeMessageChannelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeMessageChannelConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "MessageEvent", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeMessageEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeMessageEventConstructor) } },
    { "Blob", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeBlobConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeBlobConstructor) } },
    { "FileReader", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeFileReaderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeFileReaderConstructor) } },
    { "FileReaderSync", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeFileReaderSyncConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeFileReaderSyncConstructor) } },
    { "URL", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeURLConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeURLConstructor) } },
    { "ImageData", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeImageDataConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeImageDataConstructor) } },
    { "EventSource", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeEventSourceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeEventSourceConstructor) } },
    { "WorkerGlobalScope", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWorkerGlobalScopeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWorkerGlobalScopeConstructor) } },
    { "WorkerLocation", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWorkerLocationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWorkerLocationConstructor) } },
    { "XMLHttpRequest", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeXMLHttpRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeXMLHttpRequestConstructor) } },
    { "XMLHttpRequestEventTarget", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeXMLHttpRequestEventTargetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeXMLHttpRequestEventTargetConstructor) } },
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "webkitIndexedDB", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIndexedDB), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "webkitIDBCursor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBCursorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWebkitIDBCursorConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "webkitIDBDatabase", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBDatabaseConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWebkitIDBDatabaseConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "webkitIDBFactory", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBFactoryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWebkitIDBFactoryConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "webkitIDBIndex", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBIndexConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWebkitIDBIndexConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "webkitIDBKeyRange", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBKeyRangeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWebkitIDBKeyRangeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "webkitIDBObjectStore", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBObjectStoreConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWebkitIDBObjectStoreConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "webkitIDBRequest", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWebkitIDBRequestConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "webkitIDBTransaction", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeWebkitIDBTransactionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeWebkitIDBTransactionConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "indexedDB", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIndexedDB), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBCursor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBCursorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBCursorConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBCursorWithValue", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBCursorWithValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBCursorWithValueConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBDatabase", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBDatabaseConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBDatabaseConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBFactory", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBFactoryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBFactoryConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBIndex", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBIndexConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBIndexConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBKeyRange", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBKeyRangeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBKeyRangeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBObjectStore", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBObjectStoreConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBObjectStoreConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBOpenDBRequest", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBOpenDBRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBOpenDBRequestConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBRequest", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBRequestConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBTransaction", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBTransactionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBTransactionConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
    { "IDBVersionChangeEvent", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeIDBVersionChangeEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeIDBVersionChangeEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "close", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopeInstanceFunctionClose), (intptr_t) (0) } },
    { "importScripts", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopeInstanceFunctionImportScripts), (intptr_t) (0) } },
    { "setTimeout", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopeInstanceFunctionSetTimeout), (intptr_t) (1) } },
    { "clearTimeout", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopeInstanceFunctionClearTimeout), (intptr_t) (0) } },
    { "setInterval", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopeInstanceFunctionSetInterval), (intptr_t) (1) } },
    { "clearInterval", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsWorkerGlobalScopeInstanceFunctionClearInterval), (intptr_t) (0) } },
};

static const HashTable JSWorkerGlobalScopeTable = { 52, 127, true, JSWorkerGlobalScopeTableValues, JSWorkerGlobalScopeTableIndex };
template<> JSValue JSWorkerGlobalScopeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSWorkerGlobalScopeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, globalObject.prototype(), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WorkerGlobalScope"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWorkerGlobalScopeConstructor::s_info = { "WorkerGlobalScope", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWorkerGlobalScopeConstructor) };

/* Hash table for prototype */

static const struct CompactHashIndex JSWorkerGlobalScopePrototypeTableIndex[2] = {
    { -1, -1 },
    { 0, -1 },
};


static const HashTableValue JSWorkerGlobalScopePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerGlobalScopeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWorkerGlobalScopeConstructor) } },
};

static const HashTable JSWorkerGlobalScopePrototypeTable = { 1, 1, true, JSWorkerGlobalScopePrototypeTableValues, JSWorkerGlobalScopePrototypeTableIndex };
const ClassInfo JSWorkerGlobalScopePrototype::s_info = { "WorkerGlobalScopePrototype", &Base::s_info, &JSWorkerGlobalScopePrototypeTable, CREATE_METHOD_TABLE(JSWorkerGlobalScopePrototype) };

bool JSWorkerGlobalScopePrototype::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    VM& vm = state->vm();
    UNUSED_PARAM(vm);
    auto* thisObject = jsCast<JSWorkerGlobalScopePrototype*>(object);
    return getStaticPropertySlot<JSWorkerGlobalScopePrototype, JSObject>(state, JSWorkerGlobalScopePrototypeTable, thisObject, propertyName, slot);
}

const ClassInfo JSWorkerGlobalScope::s_info = { "WorkerGlobalScope", &Base::s_info, &JSWorkerGlobalScopeTable, CREATE_METHOD_TABLE(JSWorkerGlobalScope) };

JSWorkerGlobalScope::JSWorkerGlobalScope(VM& vm, Structure* structure, Ref<WorkerGlobalScope>&& impl)
    : JSWorkerGlobalScopeBase(vm, structure, WTFMove(impl))
{
}

bool JSWorkerGlobalScope::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSWorkerGlobalScope*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (thisObject->getOwnPropertySlotDelegate(state, propertyName, slot))
        return true;
    if (getStaticPropertySlot<JSWorkerGlobalScope, Base>(state, JSWorkerGlobalScopeTable, thisObject, propertyName, slot))
        return true;
    return false;
}

bool JSWorkerGlobalScope::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSWorkerGlobalScope*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Identifier propertyName = Identifier::from(state, index);
    if (thisObject->getOwnPropertySlotDelegate(state, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsWorkerGlobalScopeSelf(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "self");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.self()));
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerGlobalScopeLocation(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "location");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.location()));
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerGlobalScopeOnerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "onerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().errorEvent));
}


EncodedJSValue jsWorkerGlobalScopeOnoffline(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "onoffline");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().offlineEvent));
}


EncodedJSValue jsWorkerGlobalScopeOnonline(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "ononline");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().onlineEvent));
}


EncodedJSValue jsWorkerGlobalScopeNavigator(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "navigator");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.navigator()));
    return JSValue::encode(result);
}


EncodedJSValue jsWorkerGlobalScopeWebkitURLConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "webkitURL");
    }
    return JSValue::encode(JSDOMURL::getConstructor(state->vm(), castedThis->globalObject()));
}


#if ENABLE(FETCH_API)
EncodedJSValue jsWorkerGlobalScopeHeadersConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "Headers");
    }
    return JSValue::encode(JSFetchHeaders::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(FETCH_API)
EncodedJSValue jsWorkerGlobalScopeRequestConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "Request");
    }
    return JSValue::encode(JSFetchRequest::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(STREAMS_API)
EncodedJSValue jsWorkerGlobalScopeByteLengthQueuingStrategyConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "ByteLengthQueuingStrategy");
    }
    return JSValue::encode(JSByteLengthQueuingStrategy::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(STREAMS_API)
EncodedJSValue jsWorkerGlobalScopeCountQueuingStrategyConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "CountQueuingStrategy");
    }
    return JSValue::encode(JSCountQueuingStrategy::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(STREAMS_API)
EncodedJSValue jsWorkerGlobalScopeReadableStreamConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "ReadableStream");
    }
    return JSValue::encode(JSReadableStream::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(WEB_SOCKETS)
EncodedJSValue jsWorkerGlobalScopeWebSocketConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "WebSocket");
    }
    return JSValue::encode(JSWebSocket::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(CHANNEL_MESSAGING)
EncodedJSValue jsWorkerGlobalScopeMessageChannelConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "MessageChannel");
    }
    return JSValue::encode(JSMessageChannel::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

EncodedJSValue jsWorkerGlobalScopeMessageEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "MessageEvent");
    }
    return JSValue::encode(JSMessageEvent::getConstructor(state->vm(), castedThis->globalObject()));
}


EncodedJSValue jsWorkerGlobalScopeBlobConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "Blob");
    }
    return JSValue::encode(JSBlob::getConstructor(state->vm(), castedThis->globalObject()));
}


EncodedJSValue jsWorkerGlobalScopeFileReaderConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "FileReader");
    }
    return JSValue::encode(JSFileReader::getConstructor(state->vm(), castedThis->globalObject()));
}


EncodedJSValue jsWorkerGlobalScopeFileReaderSyncConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "FileReaderSync");
    }
    return JSValue::encode(JSFileReaderSync::getConstructor(state->vm(), castedThis->globalObject()));
}


EncodedJSValue jsWorkerGlobalScopeURLConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "URL");
    }
    return JSValue::encode(JSDOMURL::getConstructor(state->vm(), castedThis->globalObject()));
}


EncodedJSValue jsWorkerGlobalScopeImageDataConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "ImageData");
    }
    return JSValue::encode(JSImageData::getConstructor(state->vm(), castedThis->globalObject()));
}


EncodedJSValue jsWorkerGlobalScopeEventSourceConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "EventSource");
    }
    return JSValue::encode(JSEventSource::getConstructor(state->vm(), castedThis->globalObject()));
}


EncodedJSValue jsWorkerGlobalScopeWorkerGlobalScopeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "WorkerGlobalScope");
    }
    return JSValue::encode(JSWorkerGlobalScope::getConstructor(state->vm(), castedThis->globalObject()));
}


EncodedJSValue jsWorkerGlobalScopeWorkerLocationConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "WorkerLocation");
    }
    return JSValue::encode(JSWorkerLocation::getConstructor(state->vm(), castedThis->globalObject()));
}


EncodedJSValue jsWorkerGlobalScopeXMLHttpRequestConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "XMLHttpRequest");
    }
    return JSValue::encode(JSXMLHttpRequest::getConstructor(state->vm(), castedThis->globalObject()));
}


EncodedJSValue jsWorkerGlobalScopeXMLHttpRequestEventTargetConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "XMLHttpRequestEventTarget");
    }
    return JSValue::encode(JSXMLHttpRequestEventTarget::getConstructor(state->vm(), castedThis->globalObject()));
}


#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeWebkitIndexedDB(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "webkitIndexedDB");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(WebCore::WorkerGlobalScopeIndexedDatabase::indexedDB(impl)));
    return JSValue::encode(result);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeWebkitIDBCursorConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "webkitIDBCursor");
    }
    return JSValue::encode(JSIDBCursor::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeWebkitIDBDatabaseConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "webkitIDBDatabase");
    }
    return JSValue::encode(JSIDBDatabase::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeWebkitIDBFactoryConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "webkitIDBFactory");
    }
    return JSValue::encode(JSIDBFactory::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeWebkitIDBIndexConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "webkitIDBIndex");
    }
    return JSValue::encode(JSIDBIndex::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeWebkitIDBKeyRangeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "webkitIDBKeyRange");
    }
    return JSValue::encode(JSIDBKeyRange::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeWebkitIDBObjectStoreConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "webkitIDBObjectStore");
    }
    return JSValue::encode(JSIDBObjectStore::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeWebkitIDBRequestConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "webkitIDBRequest");
    }
    return JSValue::encode(JSIDBRequest::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeWebkitIDBTransactionConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "webkitIDBTransaction");
    }
    return JSValue::encode(JSIDBTransaction::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIndexedDB(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "indexedDB");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(WebCore::WorkerGlobalScopeIndexedDatabase::indexedDB(impl)));
    return JSValue::encode(result);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBCursorConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBCursor");
    }
    return JSValue::encode(JSIDBCursor::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBCursorWithValueConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBCursorWithValue");
    }
    return JSValue::encode(JSIDBCursorWithValue::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBDatabaseConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBDatabase");
    }
    return JSValue::encode(JSIDBDatabase::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBFactoryConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBFactory");
    }
    return JSValue::encode(JSIDBFactory::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBIndexConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBIndex");
    }
    return JSValue::encode(JSIDBIndex::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBKeyRangeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBKeyRange");
    }
    return JSValue::encode(JSIDBKeyRange::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBObjectStoreConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBObjectStore");
    }
    return JSValue::encode(JSIDBObjectStore::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBOpenDBRequestConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBOpenDBRequest");
    }
    return JSValue::encode(JSIDBOpenDBRequest::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBRequestConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBRequest");
    }
    return JSValue::encode(JSIDBRequest::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBTransactionConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBTransaction");
    }
    return JSValue::encode(JSIDBTransaction::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
EncodedJSValue jsWorkerGlobalScopeIDBVersionChangeEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = toJSWorkerGlobalScope(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WorkerGlobalScope", "IDBVersionChangeEvent");
    }
    return JSValue::encode(JSIDBVersionChangeEvent::getConstructor(state->vm(), castedThis->globalObject()));
}

#endif

EncodedJSValue jsWorkerGlobalScopeConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWorkerGlobalScopePrototype* domObject = jsDynamicCast<JSWorkerGlobalScopePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWorkerGlobalScope::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWorkerGlobalScopeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWorkerGlobalScopePrototype* domObject = jsDynamicCast<JSWorkerGlobalScopePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSWorkerGlobalScopeOnerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "onerror");
        return;
    }
    castedThis->wrapped().setAttributeEventListener(eventNames().errorEvent, createJSErrorHandler(state, value, castedThis));
}


void setJSWorkerGlobalScopeOnoffline(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "onoffline");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().offlineEvent, value);
}


void setJSWorkerGlobalScopeOnonline(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "ononline");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().onlineEvent, value);
}


void setJSWorkerGlobalScopeWebkitURLConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "webkitURL");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "webkitURL"), value);
}


#if ENABLE(FETCH_API)
void setJSWorkerGlobalScopeHeadersConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "Headers");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "Headers"), value);
}

#endif

#if ENABLE(FETCH_API)
void setJSWorkerGlobalScopeRequestConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "Request");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "Request"), value);
}

#endif

#if ENABLE(STREAMS_API)
void setJSWorkerGlobalScopeByteLengthQueuingStrategyConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "ByteLengthQueuingStrategy");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "ByteLengthQueuingStrategy"), value);
}

#endif

#if ENABLE(STREAMS_API)
void setJSWorkerGlobalScopeCountQueuingStrategyConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "CountQueuingStrategy");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "CountQueuingStrategy"), value);
}

#endif

#if ENABLE(STREAMS_API)
void setJSWorkerGlobalScopeReadableStreamConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "ReadableStream");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "ReadableStream"), value);
}

#endif

#if ENABLE(WEB_SOCKETS)
void setJSWorkerGlobalScopeWebSocketConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "WebSocket");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "WebSocket"), value);
}

#endif

#if ENABLE(CHANNEL_MESSAGING)
void setJSWorkerGlobalScopeMessageChannelConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "MessageChannel");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "MessageChannel"), value);
}

#endif

void setJSWorkerGlobalScopeMessageEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "MessageEvent");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "MessageEvent"), value);
}


void setJSWorkerGlobalScopeBlobConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "Blob");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "Blob"), value);
}


void setJSWorkerGlobalScopeFileReaderConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "FileReader");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "FileReader"), value);
}


void setJSWorkerGlobalScopeFileReaderSyncConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "FileReaderSync");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "FileReaderSync"), value);
}


void setJSWorkerGlobalScopeURLConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "URL");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "URL"), value);
}


void setJSWorkerGlobalScopeImageDataConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "ImageData");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "ImageData"), value);
}


void setJSWorkerGlobalScopeEventSourceConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "EventSource");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "EventSource"), value);
}


void setJSWorkerGlobalScopeWorkerGlobalScopeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "WorkerGlobalScope");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "WorkerGlobalScope"), value);
}


void setJSWorkerGlobalScopeWorkerLocationConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "WorkerLocation");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "WorkerLocation"), value);
}


void setJSWorkerGlobalScopeXMLHttpRequestConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "XMLHttpRequest");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "XMLHttpRequest"), value);
}


void setJSWorkerGlobalScopeXMLHttpRequestEventTargetConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "XMLHttpRequestEventTarget");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "XMLHttpRequestEventTarget"), value);
}


#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeWebkitIDBCursorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "webkitIDBCursor");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "webkitIDBCursor"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeWebkitIDBDatabaseConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "webkitIDBDatabase");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "webkitIDBDatabase"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeWebkitIDBFactoryConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "webkitIDBFactory");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "webkitIDBFactory"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeWebkitIDBIndexConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "webkitIDBIndex");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "webkitIDBIndex"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeWebkitIDBKeyRangeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "webkitIDBKeyRange");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "webkitIDBKeyRange"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeWebkitIDBObjectStoreConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "webkitIDBObjectStore");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "webkitIDBObjectStore"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeWebkitIDBRequestConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "webkitIDBRequest");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "webkitIDBRequest"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeWebkitIDBTransactionConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "webkitIDBTransaction");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "webkitIDBTransaction"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBCursorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBCursor");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBCursor"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBCursorWithValueConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBCursorWithValue");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBCursorWithValue"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBDatabaseConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBDatabase");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBDatabase"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBFactoryConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBFactory");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBFactory"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBIndexConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBIndex");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBIndex"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBKeyRangeConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBKeyRange");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBKeyRange"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBObjectStoreConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBObjectStore");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBObjectStore"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBOpenDBRequestConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBOpenDBRequest");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBOpenDBRequest"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBRequestConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBRequest");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBRequest"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBTransactionConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBTransaction");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBTransaction"), value);
}

#endif

#if ENABLE(INDEXED_DATABASE_IN_WORKERS)
void setJSWorkerGlobalScopeIDBVersionChangeEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "WorkerGlobalScope", "IDBVersionChangeEvent");
        return;
    }
    // Shadowing a built-in constructor.
    castedThis->putDirect(state->vm(), Identifier::fromString(state, "IDBVersionChangeEvent"), value);
}

#endif

JSValue JSWorkerGlobalScope::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWorkerGlobalScopeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionClose(ExecState* state)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(state->thisValue().toThis(state, NotStrictMode));
    if (UNLIKELY(!castedThis))
        return throwVMTypeError(state);
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWorkerGlobalScope::info());
    auto& impl = castedThis->wrapped();
    impl.close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionImportScripts(ExecState* state)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(state->thisValue().toThis(state, NotStrictMode));
    if (UNLIKELY(!castedThis))
        return throwVMTypeError(state);
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWorkerGlobalScope::info());
    return JSValue::encode(castedThis->importScripts(*state));
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionSetTimeout(ExecState* state)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(state->thisValue().toThis(state, NotStrictMode));
    if (UNLIKELY(!castedThis))
        return throwVMTypeError(state);
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWorkerGlobalScope::info());
    return JSValue::encode(castedThis->setTimeout(*state));
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionClearTimeout(ExecState* state)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(state->thisValue().toThis(state, NotStrictMode));
    if (UNLIKELY(!castedThis))
        return throwVMTypeError(state);
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWorkerGlobalScope::info());
    auto& impl = castedThis->wrapped();
    int handle = toInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.clearTimeout(handle);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionSetInterval(ExecState* state)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(state->thisValue().toThis(state, NotStrictMode));
    if (UNLIKELY(!castedThis))
        return throwVMTypeError(state);
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWorkerGlobalScope::info());
    return JSValue::encode(castedThis->setInterval(*state));
}

EncodedJSValue JSC_HOST_CALL jsWorkerGlobalScopeInstanceFunctionClearInterval(ExecState* state)
{
    JSWorkerGlobalScope* castedThis = toJSWorkerGlobalScope(state->thisValue().toThis(state, NotStrictMode));
    if (UNLIKELY(!castedThis))
        return throwVMTypeError(state);
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSWorkerGlobalScope::info());
    auto& impl = castedThis->wrapped();
    int handle = toInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.clearInterval(handle);
    return JSValue::encode(jsUndefined());
}

void JSWorkerGlobalScope::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSWorkerGlobalScope*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
    thisObject->visitAdditionalChildren(visitor);
}

WorkerGlobalScope* JSWorkerGlobalScope::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWorkerGlobalScope*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
