/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLTexture.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebGLTextureConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLTextureConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLTexturePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLTexturePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLTexturePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLTexturePrototype>(vm.heap)) JSWebGLTexturePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLTexturePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSWebGLTexture> JSWebGLTextureConstructor;

template<> JSValue JSWebGLTextureConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLTextureConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLTexture::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebGLTexture"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebGLTextureConstructor::s_info = { "WebGLTexture", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLTextureConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLTexturePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLTextureConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLTextureConstructor) } },
};

const ClassInfo JSWebGLTexturePrototype::s_info = { "WebGLTexturePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLTexturePrototype) };

void JSWebGLTexturePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLTexturePrototypeTableValues, *this);
}

const ClassInfo JSWebGLTexture::s_info = { "WebGLTexture", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLTexture) };

JSWebGLTexture::JSWebGLTexture(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLTexture>&& impl)
    : JSDOMWrapper<WebGLTexture>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLTexture::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLTexturePrototype::create(vm, globalObject, JSWebGLTexturePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLTexture::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLTexture>(vm, globalObject);
}

void JSWebGLTexture::destroy(JSC::JSCell* cell)
{
    JSWebGLTexture* thisObject = static_cast<JSWebGLTexture*>(cell);
    thisObject->JSWebGLTexture::~JSWebGLTexture();
}

EncodedJSValue jsWebGLTextureConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebGLTexturePrototype* domObject = jsDynamicCast<JSWebGLTexturePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebGLTexture::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebGLTextureConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebGLTexturePrototype* domObject = jsDynamicCast<JSWebGLTexturePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWebGLTexture::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLTextureConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSWebGLTextureOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLTextureOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLTexture = jsCast<JSWebGLTexture*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLTexture->wrapped(), jsWebGLTexture);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLTexture@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12WebGLTextureE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLTexture* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLTexture>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLTexture* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLTexture>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLTexture@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12WebGLTextureE[2];
#if COMPILER(CLANG)
    // If this fails WebGLTexture does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLTexture), WebGLTexture_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLTexture has subclasses. If WebGLTexture has subclasses that get passed
    // to toJS() we currently require WebGLTexture you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLTexture>(globalObject, impl);
}

WebGLTexture* JSWebGLTexture::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLTexture*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
