/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSValidityState.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsValidityStateValueMissing(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateTypeMismatch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStatePatternMismatch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateTooLong(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateRangeUnderflow(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateRangeOverflow(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateStepMismatch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateBadInput(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateCustomError(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateValid(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsValidityStateConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSValidityStateConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSValidityStatePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSValidityStatePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSValidityStatePrototype* ptr = new (NotNull, JSC::allocateCell<JSValidityStatePrototype>(vm.heap)) JSValidityStatePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSValidityStatePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSValidityState> JSValidityStateConstructor;

template<> JSValue JSValidityStateConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSValidityStateConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSValidityState::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("ValidityState"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSValidityStateConstructor::s_info = { "ValidityState", &Base::s_info, 0, CREATE_METHOD_TABLE(JSValidityStateConstructor) };

/* Hash table for prototype */

static const HashTableValue JSValidityStatePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSValidityStateConstructor) } },
    { "valueMissing", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateValueMissing), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "typeMismatch", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateTypeMismatch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "patternMismatch", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStatePatternMismatch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "tooLong", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateTooLong), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rangeUnderflow", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateRangeUnderflow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rangeOverflow", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateRangeOverflow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "stepMismatch", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateStepMismatch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "badInput", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateBadInput), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "customError", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateCustomError), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "valid", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsValidityStateValid), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSValidityStatePrototype::s_info = { "ValidityStatePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSValidityStatePrototype) };

void JSValidityStatePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSValidityStatePrototypeTableValues, *this);
}

const ClassInfo JSValidityState::s_info = { "ValidityState", &Base::s_info, 0, CREATE_METHOD_TABLE(JSValidityState) };

JSValidityState::JSValidityState(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ValidityState>&& impl)
    : JSDOMWrapper<ValidityState>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSValidityState::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSValidityStatePrototype::create(vm, globalObject, JSValidityStatePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSValidityState::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSValidityState>(vm, globalObject);
}

void JSValidityState::destroy(JSC::JSCell* cell)
{
    JSValidityState* thisObject = static_cast<JSValidityState*>(cell);
    thisObject->JSValidityState::~JSValidityState();
}

EncodedJSValue jsValidityStateValueMissing(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSValidityState*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ValidityState", "valueMissing");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.valueMissing());
    return JSValue::encode(result);
}


EncodedJSValue jsValidityStateTypeMismatch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSValidityState*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ValidityState", "typeMismatch");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.typeMismatch());
    return JSValue::encode(result);
}


EncodedJSValue jsValidityStatePatternMismatch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSValidityState*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ValidityState", "patternMismatch");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.patternMismatch());
    return JSValue::encode(result);
}


EncodedJSValue jsValidityStateTooLong(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSValidityState*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ValidityState", "tooLong");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.tooLong());
    return JSValue::encode(result);
}


EncodedJSValue jsValidityStateRangeUnderflow(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSValidityState*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ValidityState", "rangeUnderflow");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.rangeUnderflow());
    return JSValue::encode(result);
}


EncodedJSValue jsValidityStateRangeOverflow(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSValidityState*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ValidityState", "rangeOverflow");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.rangeOverflow());
    return JSValue::encode(result);
}


EncodedJSValue jsValidityStateStepMismatch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSValidityState*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ValidityState", "stepMismatch");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.stepMismatch());
    return JSValue::encode(result);
}


EncodedJSValue jsValidityStateBadInput(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSValidityState*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ValidityState", "badInput");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.badInput());
    return JSValue::encode(result);
}


EncodedJSValue jsValidityStateCustomError(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSValidityState*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ValidityState", "customError");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.customError());
    return JSValue::encode(result);
}


EncodedJSValue jsValidityStateValid(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSValidityState*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "ValidityState", "valid");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.valid());
    return JSValue::encode(result);
}


EncodedJSValue jsValidityStateConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSValidityStatePrototype* domObject = jsDynamicCast<JSValidityStatePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSValidityState::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSValidityStateConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSValidityStatePrototype* domObject = jsDynamicCast<JSValidityStatePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSValidityState::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSValidityStateConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSValidityStateOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSValidityStateOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsValidityState = jsCast<JSValidityState*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsValidityState->wrapped(), jsValidityState);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, ValidityState* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSValidityState>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, ValidityState* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSValidityState>(globalObject, impl))
        return result;
    return createNewWrapper<JSValidityState>(globalObject, impl);
}

ValidityState* JSValidityState::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSValidityState*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
