/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSecurityPolicyViolationEvent.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDictionary.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSecurityPolicyViolationEventDocumentURI(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventReferrer(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventBlockedURI(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventViolatedDirective(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventEffectiveDirective(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventOriginalPolicy(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventSourceFile(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventStatusCode(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventLineNumber(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventColumnNumber(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSecurityPolicyViolationEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSecurityPolicyViolationEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSecurityPolicyViolationEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSecurityPolicyViolationEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSecurityPolicyViolationEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSSecurityPolicyViolationEventPrototype>(vm.heap)) JSSecurityPolicyViolationEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSecurityPolicyViolationEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSSecurityPolicyViolationEvent> JSSecurityPolicyViolationEventConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSSecurityPolicyViolationEventConstructor::construct(ExecState* state)
{
    auto* jsConstructor = jsCast<JSSecurityPolicyViolationEventConstructor*>(state->callee());

    if (!jsConstructor->scriptExecutionContext())
        return throwVMError(state, createReferenceError(state, "Constructor associated execution context is unavailable"));

    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));

    AtomicString eventType = state->argument(0).toString(state)->toAtomicString(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    SecurityPolicyViolationEventInit eventInit;

    JSValue initializerValue = state->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(state);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(state, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillSecurityPolicyViolationEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<SecurityPolicyViolationEvent> event = SecurityPolicyViolationEvent::createForBindings(eventType, eventInit);
    return JSValue::encode(toJS(state, jsConstructor->globalObject(), event.get()));
}

bool fillSecurityPolicyViolationEventInit(SecurityPolicyViolationEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("documentURI", eventInit.documentURI))
        return false;
    if (!dictionary.tryGetProperty("referrer", eventInit.referrer))
        return false;
    if (!dictionary.tryGetProperty("blockedURI", eventInit.blockedURI))
        return false;
    if (!dictionary.tryGetProperty("violatedDirective", eventInit.violatedDirective))
        return false;
    if (!dictionary.tryGetProperty("effectiveDirective", eventInit.effectiveDirective))
        return false;
    if (!dictionary.tryGetProperty("originalPolicy", eventInit.originalPolicy))
        return false;
    if (!dictionary.tryGetProperty("sourceFile", eventInit.sourceFile))
        return false;
    if (!dictionary.tryGetProperty("statusCode", eventInit.statusCode))
        return false;
    if (!dictionary.tryGetProperty("lineNumber", eventInit.lineNumber))
        return false;
    if (!dictionary.tryGetProperty("columnNumber", eventInit.columnNumber))
        return false;
    return true;
}

template<> JSValue JSSecurityPolicyViolationEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSSecurityPolicyViolationEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSecurityPolicyViolationEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SecurityPolicyViolationEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSecurityPolicyViolationEventConstructor::s_info = { "SecurityPolicyViolationEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSecurityPolicyViolationEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSecurityPolicyViolationEventConstructor) } },
    { "documentURI", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventDocumentURI), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "referrer", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventReferrer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "blockedURI", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventBlockedURI), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "violatedDirective", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventViolatedDirective), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "effectiveDirective", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventEffectiveDirective), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "originalPolicy", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventOriginalPolicy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sourceFile", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventSourceFile), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "statusCode", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventStatusCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lineNumber", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventLineNumber), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "columnNumber", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSecurityPolicyViolationEventColumnNumber), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSSecurityPolicyViolationEventPrototype::s_info = { "SecurityPolicyViolationEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEventPrototype) };

void JSSecurityPolicyViolationEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSecurityPolicyViolationEventPrototypeTableValues, *this);
}

const ClassInfo JSSecurityPolicyViolationEvent::s_info = { "SecurityPolicyViolationEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSecurityPolicyViolationEvent) };

JSSecurityPolicyViolationEvent::JSSecurityPolicyViolationEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SecurityPolicyViolationEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSecurityPolicyViolationEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSecurityPolicyViolationEventPrototype::create(vm, globalObject, JSSecurityPolicyViolationEventPrototype::createStructure(vm, globalObject, JSEvent::getPrototype(vm, globalObject)));
}

JSObject* JSSecurityPolicyViolationEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSecurityPolicyViolationEvent>(vm, globalObject);
}

EncodedJSValue jsSecurityPolicyViolationEventDocumentURI(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSecurityPolicyViolationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SecurityPolicyViolationEvent", "documentURI");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.documentURI());
    return JSValue::encode(result);
}


EncodedJSValue jsSecurityPolicyViolationEventReferrer(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSecurityPolicyViolationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SecurityPolicyViolationEvent", "referrer");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.referrer());
    return JSValue::encode(result);
}


EncodedJSValue jsSecurityPolicyViolationEventBlockedURI(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSecurityPolicyViolationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SecurityPolicyViolationEvent", "blockedURI");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.blockedURI());
    return JSValue::encode(result);
}


EncodedJSValue jsSecurityPolicyViolationEventViolatedDirective(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSecurityPolicyViolationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SecurityPolicyViolationEvent", "violatedDirective");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.violatedDirective());
    return JSValue::encode(result);
}


EncodedJSValue jsSecurityPolicyViolationEventEffectiveDirective(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSecurityPolicyViolationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SecurityPolicyViolationEvent", "effectiveDirective");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.effectiveDirective());
    return JSValue::encode(result);
}


EncodedJSValue jsSecurityPolicyViolationEventOriginalPolicy(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSecurityPolicyViolationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SecurityPolicyViolationEvent", "originalPolicy");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.originalPolicy());
    return JSValue::encode(result);
}


EncodedJSValue jsSecurityPolicyViolationEventSourceFile(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSecurityPolicyViolationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SecurityPolicyViolationEvent", "sourceFile");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.sourceFile());
    return JSValue::encode(result);
}


EncodedJSValue jsSecurityPolicyViolationEventStatusCode(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSecurityPolicyViolationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SecurityPolicyViolationEvent", "statusCode");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.statusCode());
    return JSValue::encode(result);
}


EncodedJSValue jsSecurityPolicyViolationEventLineNumber(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSecurityPolicyViolationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SecurityPolicyViolationEvent", "lineNumber");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.lineNumber());
    return JSValue::encode(result);
}


EncodedJSValue jsSecurityPolicyViolationEventColumnNumber(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSecurityPolicyViolationEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SecurityPolicyViolationEvent", "columnNumber");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.columnNumber());
    return JSValue::encode(result);
}


EncodedJSValue jsSecurityPolicyViolationEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSecurityPolicyViolationEventPrototype* domObject = jsDynamicCast<JSSecurityPolicyViolationEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSecurityPolicyViolationEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSecurityPolicyViolationEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSecurityPolicyViolationEventPrototype* domObject = jsDynamicCast<JSSecurityPolicyViolationEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSecurityPolicyViolationEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSecurityPolicyViolationEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}
