/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGTransform.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSSVGMatrix.h"
#include "SVGMatrix.h"
#include "SVGMatrixTearOff.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetMatrix(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetTranslate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetScale(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetRotate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetSkewX(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetSkewY(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsSVGTransformType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGTransformMatrix(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGTransformAngle(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsSVGTransformConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGTransformConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGTransformPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGTransformPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGTransformPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGTransformPrototype>(vm.heap)) JSSVGTransformPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGTransformPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGTransform> JSSVGTransformConstructor;

/* Hash table for constructor */

static const HashTableValue JSSVGTransformConstructorTableValues[] =
{
    { "SVG_TRANSFORM_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_TRANSFORM_MATRIX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_TRANSFORM_TRANSLATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_TRANSFORM_SCALE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_TRANSFORM_ROTATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_TRANSFORM_SKEWX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "SVG_TRANSFORM_SKEWY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
};


COMPILE_ASSERT(0 == SVGTransform::SVG_TRANSFORM_UNKNOWN, SVGTransformEnumSVG_TRANSFORM_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGTransform::SVG_TRANSFORM_MATRIX, SVGTransformEnumSVG_TRANSFORM_MATRIXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGTransform::SVG_TRANSFORM_TRANSLATE, SVGTransformEnumSVG_TRANSFORM_TRANSLATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == SVGTransform::SVG_TRANSFORM_SCALE, SVGTransformEnumSVG_TRANSFORM_SCALEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == SVGTransform::SVG_TRANSFORM_ROTATE, SVGTransformEnumSVG_TRANSFORM_ROTATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == SVGTransform::SVG_TRANSFORM_SKEWX, SVGTransformEnumSVG_TRANSFORM_SKEWXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == SVGTransform::SVG_TRANSFORM_SKEWY, SVGTransformEnumSVG_TRANSFORM_SKEWYIsWrongUseDoNotCheckConstants);

template<> JSValue JSSVGTransformConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGTransformConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGTransform::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGTransform"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSSVGTransformConstructorTableValues, *this);
}

template<> const ClassInfo JSSVGTransformConstructor::s_info = { "SVGTransform", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGTransformConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGTransformPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGTransformConstructor) } },
    { "type", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "matrix", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformMatrix), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "angle", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTransformAngle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "setMatrix", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetMatrix), (intptr_t) (1) } },
    { "setTranslate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetTranslate), (intptr_t) (2) } },
    { "setScale", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetScale), (intptr_t) (2) } },
    { "setRotate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetRotate), (intptr_t) (3) } },
    { "setSkewX", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetSkewX), (intptr_t) (1) } },
    { "setSkewY", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSVGTransformPrototypeFunctionSetSkewY), (intptr_t) (1) } },
    { "SVG_TRANSFORM_UNKNOWN", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SVG_TRANSFORM_MATRIX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "SVG_TRANSFORM_TRANSLATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "SVG_TRANSFORM_SCALE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "SVG_TRANSFORM_ROTATE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "SVG_TRANSFORM_SKEWX", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "SVG_TRANSFORM_SKEWY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(6) } },
};

const ClassInfo JSSVGTransformPrototype::s_info = { "SVGTransformPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGTransformPrototype) };

void JSSVGTransformPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGTransformPrototypeTableValues, *this);
}

const ClassInfo JSSVGTransform::s_info = { "SVGTransform", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGTransform) };

JSSVGTransform::JSSVGTransform(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPropertyTearOff<SVGTransform>>&& impl)
    : JSDOMWrapper<SVGPropertyTearOff<SVGTransform>>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGTransform::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGTransformPrototype::create(vm, globalObject, JSSVGTransformPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGTransform::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTransform>(vm, globalObject);
}

void JSSVGTransform::destroy(JSC::JSCell* cell)
{
    JSSVGTransform* thisObject = static_cast<JSSVGTransform*>(cell);
    thisObject->JSSVGTransform::~JSSVGTransform();
}

EncodedJSValue jsSVGTransformType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGTransform*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGTransform", "type");
    }
    SVGTransform& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.type());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGTransformMatrix(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGTransform*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGTransform", "matrix");
    }
    SVGTransform& impl = castedThis->wrapped().propertyReference();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(SVGMatrixTearOff::create(castedThis->wrapped(), impl.svgMatrix())));
    return JSValue::encode(result);
}


EncodedJSValue jsSVGTransformAngle(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGTransform*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGTransform", "angle");
    }
    SVGTransform& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.angle());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGTransformConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGTransformPrototype* domObject = jsDynamicCast<JSSVGTransformPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGTransform::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGTransformConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGTransformPrototype* domObject = jsDynamicCast<JSSVGTransformPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSSVGTransform::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTransformConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetMatrix(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGTransform*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGTransform", "setMatrix");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGTransform::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    if (!state->argument(0).isUndefinedOrNull() && !state->argument(0).inherits(JSSVGMatrix::info()))
        return throwArgumentTypeError(*state, 0, "matrix", "SVGTransform", "setMatrix", "SVGMatrix");
    SVGPropertyTearOff<SVGMatrix>* matrix = JSSVGMatrix::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (!matrix) {
        setDOMException(state, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    podImpl.setMatrix(matrix->propertyReference());
    impl.commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetTranslate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGTransform*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGTransform", "setTranslate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGTransform::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float tx = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float ty = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    podImpl.setTranslate(tx, ty);
    impl.commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetScale(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGTransform*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGTransform", "setScale");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGTransform::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float sx = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float sy = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    podImpl.setScale(sx, sy);
    impl.commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetRotate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGTransform*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGTransform", "setRotate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGTransform::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float angle = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float cx = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float cy = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    podImpl.setRotate(angle, cx, cy);
    impl.commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetSkewX(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGTransform*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGTransform", "setSkewX");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGTransform::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float angle = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    podImpl.setSkewX(angle);
    impl.commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGTransformPrototypeFunctionSetSkewY(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSVGTransform*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SVGTransform", "setSkewY");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSVGTransform::info());
    auto& impl = castedThis->wrapped();
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGTransform& podImpl = impl.propertyReference();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float angle = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    podImpl.setSkewY(angle);
    impl.commitChange();
    return JSValue::encode(jsUndefined());
}

bool JSSVGTransformOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGTransformOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGTransform = jsCast<JSSVGTransform*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGTransform->wrapped(), jsSVGTransform);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGTransform>* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGTransform, SVGPropertyTearOff<SVGTransform>>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGTransform>* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGTransform, SVGPropertyTearOff<SVGTransform>>(globalObject, impl))
        return result;
    return createNewWrapper<JSSVGTransform, SVGPropertyTearOff<SVGTransform>>(globalObject, impl);
}

SVGPropertyTearOff<SVGTransform>* JSSVGTransform::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGTransform*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
