/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNamedNodeMap.h"

#include "Element.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSNode.h"
#include "JSNodeCustom.h"
#include "Node.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionGetNamedItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionSetNamedItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionRemoveNamedItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionItem(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionGetNamedItemNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionSetNamedItemNS(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionRemoveNamedItemNS(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsNamedNodeMapLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsNamedNodeMapConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSNamedNodeMapConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSNamedNodeMapPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSNamedNodeMapPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNamedNodeMapPrototype* ptr = new (NotNull, JSC::allocateCell<JSNamedNodeMapPrototype>(vm.heap)) JSNamedNodeMapPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNamedNodeMapPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSNamedNodeMap> JSNamedNodeMapConstructor;

template<> JSValue JSNamedNodeMapConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNamedNodeMapConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSNamedNodeMap::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("NamedNodeMap"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSNamedNodeMapConstructor::s_info = { "NamedNodeMap", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNamedNodeMapConstructor) };

/* Hash table for prototype */

static const HashTableValue JSNamedNodeMapPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNamedNodeMapConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSNamedNodeMapConstructor) } },
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNamedNodeMapLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getNamedItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionGetNamedItem), (intptr_t) (0) } },
    { "setNamedItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionSetNamedItem), (intptr_t) (0) } },
    { "removeNamedItem", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionRemoveNamedItem), (intptr_t) (0) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionItem), (intptr_t) (0) } },
    { "getNamedItemNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionGetNamedItemNS), (intptr_t) (0) } },
    { "setNamedItemNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionSetNamedItemNS), (intptr_t) (0) } },
    { "removeNamedItemNS", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionRemoveNamedItemNS), (intptr_t) (0) } },
};

const ClassInfo JSNamedNodeMapPrototype::s_info = { "NamedNodeMapPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNamedNodeMapPrototype) };

void JSNamedNodeMapPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNamedNodeMapPrototypeTableValues, *this);
}

const ClassInfo JSNamedNodeMap::s_info = { "NamedNodeMap", &Base::s_info, 0, CREATE_METHOD_TABLE(JSNamedNodeMap) };

JSNamedNodeMap::JSNamedNodeMap(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NamedNodeMap>&& impl)
    : JSDOMWrapper<NamedNodeMap>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSNamedNodeMap::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSNamedNodeMapPrototype::create(vm, globalObject, JSNamedNodeMapPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSNamedNodeMap::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNamedNodeMap>(vm, globalObject);
}

void JSNamedNodeMap::destroy(JSC::JSCell* cell)
{
    JSNamedNodeMap* thisObject = static_cast<JSNamedNodeMap*>(cell);
    thisObject->JSNamedNodeMap::~JSNamedNodeMap();
}

bool JSNamedNodeMap::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSNamedNodeMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex && optionalIndex.value() < thisObject->wrapped().length()) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    JSValue proto = thisObject->prototype();
    if (proto.isObject() && jsCast<JSObject*>(proto)->hasProperty(state, propertyName))
        return false;

    if (!optionalIndex && thisObject->classInfo() == info()) {
        JSValue value;
        if (thisObject->nameGetter(state, propertyName, value)) {
            slot.setValue(thisObject, ReadOnly | DontDelete | DontEnum, value);
            return true;
        }
    }
    return false;
}

bool JSNamedNodeMap::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSNamedNodeMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index < thisObject->wrapped().length()) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsNamedNodeMapLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSNamedNodeMap*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "NamedNodeMap", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsNamedNodeMapConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSNamedNodeMapPrototype* domObject = jsDynamicCast<JSNamedNodeMapPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSNamedNodeMap::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSNamedNodeMapConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSNamedNodeMapPrototype* domObject = jsDynamicCast<JSNamedNodeMapPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSNamedNodeMap::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSNamedNodeMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    if (mode.includeDontEnumProperties()) {
        for (auto& propertyName : thisObject->wrapped().supportedPropertyNames())
            propertyNames.add(Identifier::fromString(state, propertyName));
    }
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

JSValue JSNamedNodeMap::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNamedNodeMapConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionGetNamedItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNamedNodeMap*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "NamedNodeMap", "getNamedItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNamedNodeMap::info());
    auto& impl = castedThis->wrapped();
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getNamedItem(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionSetNamedItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNamedNodeMap*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "NamedNodeMap", "setNamedItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNamedNodeMap::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    Node* node = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.setNamedItem(node, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionRemoveNamedItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNamedNodeMap*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "NamedNodeMap", "removeNamedItem");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNamedNodeMap::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String name = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.removeNamedItem(name, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNamedNodeMap*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "NamedNodeMap", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNamedNodeMap::info());
    auto& impl = castedThis->wrapped();
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionGetNamedItemNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNamedNodeMap*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "NamedNodeMap", "getNamedItemNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNamedNodeMap::info());
    auto& impl = castedThis->wrapped();
    String namespaceURI = valueToStringWithNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String localName = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getNamedItemNS(namespaceURI, localName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionSetNamedItemNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNamedNodeMap*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "NamedNodeMap", "setNamedItemNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNamedNodeMap::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    Node* node = JSNode::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.setNamedItemNS(node, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionRemoveNamedItemNS(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSNamedNodeMap*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "NamedNodeMap", "removeNamedItemNS");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSNamedNodeMap::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String namespaceURI = valueToStringWithNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String localName = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.removeNamedItemNS(namespaceURI, localName, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

bool JSNamedNodeMapOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsNamedNodeMap = jsCast<JSNamedNodeMap*>(handle.slot()->asCell());
    Element* element = WTF::getPtr(jsNamedNodeMap->wrapped().element());
    if (!element)
        return false;
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSNamedNodeMapOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNamedNodeMap = jsCast<JSNamedNodeMap*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsNamedNodeMap->wrapped(), jsNamedNodeMap);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, NamedNodeMap* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSNamedNodeMap>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, NamedNodeMap* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSNamedNodeMap>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to NamedNodeMap.
    COMPILE_ASSERT(!__is_polymorphic(NamedNodeMap), NamedNodeMap_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSNamedNodeMap>(globalObject, impl);
}

NamedNodeMap* JSNamedNodeMap::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNamedNodeMap*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
