/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMessagePort.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionPostMessage(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionStart(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionClose(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsMessagePortOnmessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMessagePortOnmessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMessagePortConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMessagePortConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMessagePortPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMessagePortPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMessagePortPrototype* ptr = new (NotNull, JSC::allocateCell<JSMessagePortPrototype>(vm.heap)) JSMessagePortPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMessagePortPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSMessagePort> JSMessagePortConstructor;

template<> JSValue JSMessagePortConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMessagePortConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMessagePort::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MessagePort"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSMessagePortConstructor::s_info = { "MessagePort", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMessagePortConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMessagePortPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessagePortConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMessagePortConstructor) } },
    { "onmessage", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessagePortOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMessagePortOnmessage) } },
    { "postMessage", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMessagePortPrototypeFunctionPostMessage), (intptr_t) (1) } },
    { "start", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMessagePortPrototypeFunctionStart), (intptr_t) (0) } },
    { "close", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsMessagePortPrototypeFunctionClose), (intptr_t) (0) } },
};

const ClassInfo JSMessagePortPrototype::s_info = { "MessagePortPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMessagePortPrototype) };

void JSMessagePortPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMessagePortPrototypeTableValues, *this);
}

const ClassInfo JSMessagePort::s_info = { "MessagePort", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMessagePort) };

JSMessagePort::JSMessagePort(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MessagePort>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMessagePort::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMessagePortPrototype::create(vm, globalObject, JSMessagePortPrototype::createStructure(vm, globalObject, JSEventTarget::getPrototype(vm, globalObject)));
}

JSObject* JSMessagePort::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMessagePort>(vm, globalObject);
}

EncodedJSValue jsMessagePortOnmessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMessagePort*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MessagePort", "onmessage");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(eventHandlerAttribute(castedThis->wrapped(), eventNames().messageEvent));
}


EncodedJSValue jsMessagePortConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSMessagePortPrototype* domObject = jsDynamicCast<JSMessagePortPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSMessagePort::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSMessagePortConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMessagePortPrototype* domObject = jsDynamicCast<JSMessagePortPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSMessagePortOnmessage(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSMessagePort* castedThis = jsDynamicCast<JSMessagePort*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "MessagePort", "onmessage");
        return;
    }
    setEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().messageEvent, value);
}


JSValue JSMessagePort::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMessagePortConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionPostMessage(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMessagePort*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MessagePort", "postMessage");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMessagePort::info());
    return JSValue::encode(castedThis->postMessage(*state));
}

EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionStart(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMessagePort*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MessagePort", "start");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMessagePort::info());
    auto& impl = castedThis->wrapped();
    impl.start();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMessagePortPrototypeFunctionClose(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSMessagePort*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "MessagePort", "close");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSMessagePort::info());
    auto& impl = castedThis->wrapped();
    impl.close();
    return JSValue::encode(jsUndefined());
}

void JSMessagePort::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSMessagePort*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSMessagePortOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsMessagePort = jsCast<JSMessagePort*>(handle.slot()->asCell());
    if (jsMessagePort->wrapped().hasPendingActivity())
        return true;
    if (jsMessagePort->wrapped().isFiringEventListeners())
        return true;
    MessagePort* root = &jsMessagePort->wrapped();
    return visitor.containsOpaqueRoot(root);
}

void JSMessagePortOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMessagePort = jsCast<JSMessagePort*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMessagePort->wrapped(), jsMessagePort);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MessagePort@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11MessagePortE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, MessagePort* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSMessagePort>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, MessagePort* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMessagePort>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7MessagePort@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11MessagePortE[2];
#if COMPILER(CLANG)
    // If this fails MessagePort does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(MessagePort), MessagePort_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // MessagePort has subclasses. If MessagePort has subclasses that get passed
    // to toJS() we currently require MessagePort you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSMessagePort>(globalObject, impl);
}

MessagePort* JSMessagePort::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMessagePort*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
