/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBCursor.h"

#include "ExceptionCode.h"
#include "IDBAny.h"
#include "IDBRequest.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSIDBAny.h"
#include "JSIDBRequest.h"
#include "URL.h"
#include <bindings/ScriptValue.h>
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionUpdate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionAdvance(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionContinue(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionDelete(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsIDBCursorSource(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBCursorDirection(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBCursorKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBCursorPrimaryKey(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBCursorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSIDBCursorConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSIDBCursorPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSIDBCursorPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBCursorPrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBCursorPrototype>(vm.heap)) JSIDBCursorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBCursorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSIDBCursor> JSIDBCursorConstructor;

template<> JSValue JSIDBCursorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBCursorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBCursor::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("IDBCursor"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSIDBCursorConstructor::s_info = { "IDBCursor", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBCursorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBCursorPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBCursorConstructor) } },
    { "source", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorSource), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "direction", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorDirection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "key", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "primaryKey", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorPrimaryKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "update", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBCursorPrototypeFunctionUpdate), (intptr_t) (1) } },
    { "advance", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBCursorPrototypeFunctionAdvance), (intptr_t) (1) } },
    { "continue", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBCursorPrototypeFunctionContinue), (intptr_t) (0) } },
    { "delete", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsIDBCursorPrototypeFunctionDelete), (intptr_t) (0) } },
};

const ClassInfo JSIDBCursorPrototype::s_info = { "IDBCursorPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBCursorPrototype) };

void JSIDBCursorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBCursorPrototypeTableValues, *this);
}

const ClassInfo JSIDBCursor::s_info = { "IDBCursor", &Base::s_info, 0, CREATE_METHOD_TABLE(JSIDBCursor) };

JSIDBCursor::JSIDBCursor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBCursor>&& impl)
    : JSDOMWrapper<IDBCursor>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSIDBCursor::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSIDBCursorPrototype::create(vm, globalObject, JSIDBCursorPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSIDBCursor::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBCursor>(vm, globalObject);
}

void JSIDBCursor::destroy(JSC::JSCell* cell)
{
    JSIDBCursor* thisObject = static_cast<JSIDBCursor*>(cell);
    thisObject->JSIDBCursor::~JSIDBCursor();
}

EncodedJSValue jsIDBCursorSource(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBCursor*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBCursor", "source");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.source()));
    return JSValue::encode(result);
}


EncodedJSValue jsIDBCursorDirection(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBCursor*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBCursor", "direction");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.direction());
    return JSValue::encode(result);
}


EncodedJSValue jsIDBCursorKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBCursor*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBCursor", "key");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = (impl.key().hasNoValue() ? jsNull() : impl.key().jsValue());
    return JSValue::encode(result);
}


EncodedJSValue jsIDBCursorPrimaryKey(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSIDBCursor*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "IDBCursor", "primaryKey");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = (impl.primaryKey().hasNoValue() ? jsNull() : impl.primaryKey().jsValue());
    return JSValue::encode(result);
}


EncodedJSValue jsIDBCursorConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSIDBCursorPrototype* domObject = jsDynamicCast<JSIDBCursorPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSIDBCursor::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSIDBCursorConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSIDBCursorPrototype* domObject = jsDynamicCast<JSIDBCursorPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSIDBCursor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBCursorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionUpdate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBCursor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBCursor", "update");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBCursor::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    Deprecated::ScriptValue value = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.update(*state, value, ec)));

    setDOMException(state, ec);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionAdvance(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBCursor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBCursor", "advance");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBCursor::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCodeWithMessage ec;
    unsigned count = toUInt32(state, state->argument(0), EnforceRange);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.advance(count, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionContinue(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBCursor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBCursor", "continue");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBCursor::info());
    auto& impl = castedThis->wrapped();
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 0) {
        impl.continueFunction(scriptContext, ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    Deprecated::ScriptValue key = { state->vm(), state->argument(0) };
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.continueFunction(scriptContext, key, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIDBCursorPrototypeFunctionDelete(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSIDBCursor*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "IDBCursor", "delete");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSIDBCursor::info());
    auto& impl = castedThis->wrapped();
    ExceptionCodeWithMessage ec;
    auto* scriptContext = jsCast<JSDOMGlobalObject*>(state->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.deleteFunction(scriptContext, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

void JSIDBCursor::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIDBCursor*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSIDBCursorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsIDBCursor = jsCast<JSIDBCursor*>(handle.slot()->asCell());
    if (jsIDBCursor->wrapped().hasPendingActivity())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSIDBCursorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBCursor = jsCast<JSIDBCursor*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBCursor->wrapped(), jsIDBCursor);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, IDBCursor* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSIDBCursor>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, IDBCursor* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSIDBCursor>(globalObject, impl))
        return result;
    return createNewWrapper<JSIDBCursor>(globalObject, impl);
}

IDBCursor* JSIDBCursor::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBCursor*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
