/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLImageElement.h"

#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLImageElementName(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementName(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementAlign(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementAlign(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementAlt(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementAlt(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementBorder(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementBorder(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementCrossOrigin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementCrossOrigin(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementHspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementHspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementIsMap(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementIsMap(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementLongDesc(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementLongDesc(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementSrc(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementSrc(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementSrcset(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementSrcset(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementSizes(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementSizes(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementCurrentSrc(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLImageElementUseMap(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementUseMap(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementVspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementVspace(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementComplete(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLImageElementLowsrc(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementLowsrc(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLImageElementNaturalHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLImageElementNaturalWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLImageElementX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLImageElementY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLImageElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLImageElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLImageElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLImageElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLImageElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLImageElementPrototype>(vm.heap)) JSHTMLImageElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLImageElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLImageElement> JSHTMLImageElementConstructor;

template<> JSValue JSHTMLImageElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLImageElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLImageElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLImageElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLImageElementConstructor::s_info = { "HTMLImageElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLImageElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLImageElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementConstructor) } },
    { "name", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementName) } },
    { "align", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementAlign), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementAlign) } },
    { "alt", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementAlt), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementAlt) } },
    { "border", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementBorder), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementBorder) } },
    { "crossOrigin", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementCrossOrigin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementCrossOrigin) } },
    { "height", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementHeight) } },
    { "hspace", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementHspace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementHspace) } },
    { "isMap", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementIsMap), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementIsMap) } },
    { "longDesc", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementLongDesc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementLongDesc) } },
    { "src", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementSrc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementSrc) } },
    { "srcset", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementSrcset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementSrcset) } },
    { "sizes", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementSizes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementSizes) } },
    { "currentSrc", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementCurrentSrc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "useMap", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementUseMap), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementUseMap) } },
    { "vspace", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementVspace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementVspace) } },
    { "width", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementWidth) } },
    { "complete", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementComplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lowsrc", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementLowsrc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLImageElementLowsrc) } },
    { "naturalHeight", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementNaturalHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "naturalWidth", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementNaturalWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "x", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "y", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLImageElementY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSHTMLImageElementPrototype::s_info = { "HTMLImageElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLImageElementPrototype) };

void JSHTMLImageElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLImageElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLImageElement::s_info = { "HTMLImageElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLImageElement) };

JSHTMLImageElement::JSHTMLImageElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLImageElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLImageElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLImageElementPrototype::create(vm, globalObject, JSHTMLImageElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLImageElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLImageElement>(vm, globalObject);
}

EncodedJSValue jsHTMLImageElementName(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "name");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getNameAttribute());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementAlign(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "align");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementAlt(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "alt");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::altAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementBorder(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "border");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::borderAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementCrossOrigin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "crossOrigin");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::crossoriginAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "height");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.height());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementHspace(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "hspace");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.getIntegralAttribute(WebCore::HTMLNames::hspaceAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementIsMap(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "isMap");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.fastHasAttribute(WebCore::HTMLNames::ismapAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementLongDesc(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "longDesc");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getURLAttribute(WebCore::HTMLNames::longdescAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementSrc(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "src");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getURLAttribute(WebCore::HTMLNames::srcAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementSrcset(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "srcset");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::srcsetAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementSizes(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "sizes");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::sizesAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementCurrentSrc(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "currentSrc");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.currentSrc());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementUseMap(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "useMap");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::usemapAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementVspace(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "vspace");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.getIntegralAttribute(WebCore::HTMLNames::vspaceAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "width");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.width());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementComplete(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "complete");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.complete());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementLowsrc(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "lowsrc");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getURLAttribute(WebCore::HTMLNames::lowsrcAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementNaturalHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "naturalHeight");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.naturalHeight());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementNaturalWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "naturalWidth");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.naturalWidth());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "x");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.x());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLImageElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLImageElement", "y");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.y());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLImageElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLImageElementPrototype* domObject = jsDynamicCast<JSHTMLImageElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLImageElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLImageElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLImageElementPrototype* domObject = jsDynamicCast<JSHTMLImageElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLImageElementName(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "name");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, nativeValue);
}


void setJSHTMLImageElementAlign(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "align");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::alignAttr, nativeValue);
}


void setJSHTMLImageElementAlt(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "alt");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::altAttr, nativeValue);
}


void setJSHTMLImageElementBorder(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "border");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::borderAttr, nativeValue);
}


void setJSHTMLImageElementCrossOrigin(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "crossOrigin");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::crossoriginAttr, nativeValue);
}


void setJSHTMLImageElementHeight(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "height");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHeight(nativeValue);
}


void setJSHTMLImageElementHspace(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "hspace");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setIntegralAttribute(WebCore::HTMLNames::hspaceAttr, nativeValue);
}


void setJSHTMLImageElementIsMap(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "isMap");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBooleanAttribute(WebCore::HTMLNames::ismapAttr, nativeValue);
}


void setJSHTMLImageElementLongDesc(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "longDesc");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::longdescAttr, nativeValue);
}


void setJSHTMLImageElementSrc(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "src");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcAttr, nativeValue);
}


void setJSHTMLImageElementSrcset(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "srcset");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcsetAttr, nativeValue);
}


void setJSHTMLImageElementSizes(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "sizes");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::sizesAttr, nativeValue);
}


void setJSHTMLImageElementUseMap(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "useMap");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::usemapAttr, nativeValue);
}


void setJSHTMLImageElementVspace(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "vspace");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setIntegralAttribute(WebCore::HTMLNames::vspaceAttr, nativeValue);
}


void setJSHTMLImageElementWidth(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "width");
        return;
    }
    auto& impl = castedThis->wrapped();
    int nativeValue = toInt32(state, value, NormalConversion);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setWidth(nativeValue);
}


void setJSHTMLImageElementLowsrc(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLImageElement* castedThis = jsDynamicCast<JSHTMLImageElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLImageElement", "lowsrc");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::lowsrcAttr, nativeValue);
}


JSValue JSHTMLImageElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLImageElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHTMLImageElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLImageElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

HTMLImageElement* JSHTMLImageElement::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLImageElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
