/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLBodyElement.h"

#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEventListener.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLBodyElementALink(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementALink(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementBackground(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementBackground(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementBgColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementBgColor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementLink(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementLink(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementText(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementVLink(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementVLink(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnblur(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnblur(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnerror(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnfocus(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnfocus(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnfocusin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnfocusin(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnfocusout(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnfocusout(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnresize(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnresize(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnscroll(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnscroll(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcechanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnwebkitmouseforcechanged(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcedown(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnwebkitmouseforcedown(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcewillbegin(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnwebkitmouseforcewillbegin(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitmouseforceup(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnwebkitmouseforceup(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitwillrevealbottom(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnwebkitwillrevealbottom(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitwillrevealleft(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnwebkitwillrevealleft(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitwillrevealright(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnwebkitwillrevealright(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnwebkitwillrevealtop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnwebkitwillrevealtop(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsHTMLBodyElementOnselectionchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnselectionchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnbeforeunload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnbeforeunload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnhashchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnhashchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnmessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnmessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnoffline(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnoffline(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnonline(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnonline(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnpagehide(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnpagehide(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnpageshow(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnpageshow(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnpopstate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnpopstate(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnstorage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnstorage(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBodyElementOnunload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnunload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(ORIENTATION_EVENTS)
JSC::EncodedJSValue jsHTMLBodyElementOnorientationchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementOnorientationchange(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsHTMLBodyElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBodyElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLBodyElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLBodyElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLBodyElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLBodyElementPrototype>(vm.heap)) JSHTMLBodyElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLBodyElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLBodyElement> JSHTMLBodyElementConstructor;

template<> JSValue JSHTMLBodyElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLBodyElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLBodyElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLBodyElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLBodyElementConstructor::s_info = { "HTMLBodyElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLBodyElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLBodyElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementConstructor) } },
    { "aLink", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementALink), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementALink) } },
    { "background", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementBackground), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementBackground) } },
    { "bgColor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementBgColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementBgColor) } },
    { "link", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementLink), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementLink) } },
    { "text", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementText) } },
    { "vLink", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementVLink), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementVLink) } },
    { "onblur", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnblur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnblur) } },
    { "onerror", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnerror) } },
    { "onfocus", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnfocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnfocus) } },
    { "onfocusin", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnfocusin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnfocusin) } },
    { "onfocusout", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnfocusout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnfocusout) } },
    { "onload", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnload) } },
    { "onresize", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnresize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnresize) } },
    { "onscroll", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnscroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnscroll) } },
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcechanged", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitmouseforcechanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitmouseforcechanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcedown", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitmouseforcedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitmouseforcedown) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcewillbegin", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitmouseforcewillbegin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitmouseforcewillbegin) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforceup", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitmouseforceup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitmouseforceup) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealbottom", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitwillrevealbottom), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitwillrevealbottom) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealleft", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitwillrevealleft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitwillrevealleft) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealright", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitwillrevealright), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitwillrevealright) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
    { "onwebkitwillrevealtop", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnwebkitwillrevealtop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnwebkitwillrevealtop) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onselectionchange", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnselectionchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnselectionchange) } },
    { "onbeforeunload", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnbeforeunload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnbeforeunload) } },
    { "onhashchange", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnhashchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnhashchange) } },
    { "onmessage", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnmessage) } },
    { "onoffline", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnoffline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnoffline) } },
    { "ononline", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnonline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnonline) } },
    { "onpagehide", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnpagehide), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnpagehide) } },
    { "onpageshow", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnpageshow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnpageshow) } },
    { "onpopstate", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnpopstate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnpopstate) } },
    { "onstorage", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnstorage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnstorage) } },
    { "onunload", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnunload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnunload) } },
#if ENABLE(ORIENTATION_EVENTS)
    { "onorientationchange", DontEnum | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBodyElementOnorientationchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBodyElementOnorientationchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
};

const ClassInfo JSHTMLBodyElementPrototype::s_info = { "HTMLBodyElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLBodyElementPrototype) };

void JSHTMLBodyElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLBodyElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLBodyElement::s_info = { "HTMLBodyElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLBodyElement) };

JSHTMLBodyElement::JSHTMLBodyElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLBodyElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLBodyElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLBodyElementPrototype::create(vm, globalObject, JSHTMLBodyElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLBodyElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLBodyElement>(vm, globalObject);
}

EncodedJSValue jsHTMLBodyElementALink(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "aLink");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::alinkAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLBodyElementBackground(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "background");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::backgroundAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLBodyElementBgColor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "bgColor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::bgcolorAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLBodyElementLink(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "link");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::linkAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLBodyElementText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "text");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::textAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLBodyElementVLink(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "vLink");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::vlinkAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLBodyElementOnblur(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onblur");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().blurEvent));
}


EncodedJSValue jsHTMLBodyElementOnerror(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onerror");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().errorEvent));
}


EncodedJSValue jsHTMLBodyElementOnfocus(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onfocus");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().focusEvent));
}


EncodedJSValue jsHTMLBodyElementOnfocusin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onfocusin");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().focusinEvent));
}


EncodedJSValue jsHTMLBodyElementOnfocusout(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onfocusout");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().focusoutEvent));
}


EncodedJSValue jsHTMLBodyElementOnload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onload");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().loadEvent));
}


EncodedJSValue jsHTMLBodyElementOnresize(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onresize");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().resizeEvent));
}


EncodedJSValue jsHTMLBodyElementOnscroll(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onscroll");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().scrollEvent));
}


#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcechanged(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onwebkitmouseforcechanged");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforcechangedEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcedown(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onwebkitmouseforcedown");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforcedownEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsHTMLBodyElementOnwebkitmouseforcewillbegin(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onwebkitmouseforcewillbegin");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforcewillbeginEvent));
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
EncodedJSValue jsHTMLBodyElementOnwebkitmouseforceup(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onwebkitmouseforceup");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitmouseforceupEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsHTMLBodyElementOnwebkitwillrevealbottom(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onwebkitwillrevealbottom");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealbottomEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsHTMLBodyElementOnwebkitwillrevealleft(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onwebkitwillrevealleft");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealleftEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsHTMLBodyElementOnwebkitwillrevealright(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onwebkitwillrevealright");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealrightEvent));
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
EncodedJSValue jsHTMLBodyElementOnwebkitwillrevealtop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onwebkitwillrevealtop");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().webkitwillrevealtopEvent));
}

#endif

EncodedJSValue jsHTMLBodyElementOnselectionchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onselectionchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(documentEventHandlerAttribute(castedThis->wrapped(), eventNames().selectionchangeEvent));
}


EncodedJSValue jsHTMLBodyElementOnbeforeunload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onbeforeunload");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().beforeunloadEvent));
}


EncodedJSValue jsHTMLBodyElementOnhashchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onhashchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().hashchangeEvent));
}


EncodedJSValue jsHTMLBodyElementOnmessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onmessage");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().messageEvent));
}


EncodedJSValue jsHTMLBodyElementOnoffline(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onoffline");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().offlineEvent));
}


EncodedJSValue jsHTMLBodyElementOnonline(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "ononline");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().onlineEvent));
}


EncodedJSValue jsHTMLBodyElementOnpagehide(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onpagehide");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().pagehideEvent));
}


EncodedJSValue jsHTMLBodyElementOnpageshow(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onpageshow");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().pageshowEvent));
}


EncodedJSValue jsHTMLBodyElementOnpopstate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onpopstate");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().popstateEvent));
}


EncodedJSValue jsHTMLBodyElementOnstorage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onstorage");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().storageEvent));
}


EncodedJSValue jsHTMLBodyElementOnunload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onunload");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().unloadEvent));
}


#if ENABLE(ORIENTATION_EVENTS)
EncodedJSValue jsHTMLBodyElementOnorientationchange(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBodyElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBodyElement", "onorientationchange");
    }
    UNUSED_PARAM(state);
    return JSValue::encode(windowEventHandlerAttribute(castedThis->wrapped(), eventNames().orientationchangeEvent));
}

#endif

EncodedJSValue jsHTMLBodyElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLBodyElementPrototype* domObject = jsDynamicCast<JSHTMLBodyElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLBodyElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLBodyElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLBodyElementPrototype* domObject = jsDynamicCast<JSHTMLBodyElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLBodyElementALink(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "aLink");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::alinkAttr, nativeValue);
}


void setJSHTMLBodyElementBackground(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "background");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::backgroundAttr, nativeValue);
}


void setJSHTMLBodyElementBgColor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "bgColor");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::bgcolorAttr, nativeValue);
}


void setJSHTMLBodyElementLink(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "link");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::linkAttr, nativeValue);
}


void setJSHTMLBodyElementText(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "text");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::textAttr, nativeValue);
}


void setJSHTMLBodyElementVLink(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "vLink");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::vlinkAttr, nativeValue);
}


void setJSHTMLBodyElementOnblur(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onblur");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().blurEvent, value);
}


void setJSHTMLBodyElementOnerror(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onerror");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().errorEvent, value);
}


void setJSHTMLBodyElementOnfocus(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onfocus");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().focusEvent, value);
}


void setJSHTMLBodyElementOnfocusin(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onfocusin");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().focusinEvent, value);
}


void setJSHTMLBodyElementOnfocusout(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onfocusout");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().focusoutEvent, value);
}


void setJSHTMLBodyElementOnload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onload");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().loadEvent, value);
}


void setJSHTMLBodyElementOnresize(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onresize");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().resizeEvent, value);
}


void setJSHTMLBodyElementOnscroll(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onscroll");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().scrollEvent, value);
}


#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSHTMLBodyElementOnwebkitmouseforcechanged(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onwebkitmouseforcechanged");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforcechangedEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSHTMLBodyElementOnwebkitmouseforcedown(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onwebkitmouseforcedown");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforcedownEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSHTMLBodyElementOnwebkitmouseforcewillbegin(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onwebkitmouseforcewillbegin");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforcewillbeginEvent, value);
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
void setJSHTMLBodyElementOnwebkitmouseforceup(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onwebkitmouseforceup");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitmouseforceupEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSHTMLBodyElementOnwebkitwillrevealbottom(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onwebkitwillrevealbottom");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealbottomEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSHTMLBodyElementOnwebkitwillrevealleft(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onwebkitwillrevealleft");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealleftEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSHTMLBodyElementOnwebkitwillrevealright(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onwebkitwillrevealright");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealrightEvent, value);
}

#endif

#if ENABLE(WILL_REVEAL_EDGE_EVENTS)
void setJSHTMLBodyElementOnwebkitwillrevealtop(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onwebkitwillrevealtop");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().webkitwillrevealtopEvent, value);
}

#endif

void setJSHTMLBodyElementOnselectionchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onselectionchange");
        return;
    }
    setDocumentEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().selectionchangeEvent, value);
}


void setJSHTMLBodyElementOnbeforeunload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onbeforeunload");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().beforeunloadEvent, value);
}


void setJSHTMLBodyElementOnhashchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onhashchange");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().hashchangeEvent, value);
}


void setJSHTMLBodyElementOnmessage(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onmessage");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().messageEvent, value);
}


void setJSHTMLBodyElementOnoffline(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onoffline");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().offlineEvent, value);
}


void setJSHTMLBodyElementOnonline(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "ononline");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().onlineEvent, value);
}


void setJSHTMLBodyElementOnpagehide(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onpagehide");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().pagehideEvent, value);
}


void setJSHTMLBodyElementOnpageshow(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onpageshow");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().pageshowEvent, value);
}


void setJSHTMLBodyElementOnpopstate(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onpopstate");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().popstateEvent, value);
}


void setJSHTMLBodyElementOnstorage(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onstorage");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().storageEvent, value);
}


void setJSHTMLBodyElementOnunload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onunload");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().unloadEvent, value);
}


#if ENABLE(ORIENTATION_EVENTS)
void setJSHTMLBodyElementOnorientationchange(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBodyElement* castedThis = jsDynamicCast<JSHTMLBodyElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBodyElement", "onorientationchange");
        return;
    }
    setWindowEventHandlerAttribute(*state, *castedThis, castedThis->wrapped(), eventNames().orientationchangeEvent, value);
}

#endif

JSValue JSHTMLBodyElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLBodyElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHTMLBodyElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLBodyElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
