/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLAudioElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLAudioElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLAudioElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLAudioElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLAudioElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLAudioElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLAudioElementPrototype>(vm.heap)) JSHTMLAudioElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLAudioElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLAudioElement> JSHTMLAudioElementConstructor;
typedef JSDOMNamedConstructor<JSHTMLAudioElement> JSHTMLAudioElementNamedConstructor;

template<> JSValue JSHTMLAudioElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLMediaElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLAudioElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLAudioElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLAudioElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLAudioElementConstructor::s_info = { "HTMLAudioElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLAudioElementConstructor) };

template<> EncodedJSValue JSC_HOST_CALL JSHTMLAudioElementNamedConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSHTMLAudioElementNamedConstructor*>(state->callee());
    String src = state->argument(0).isUndefined() ? String() : state->uncheckedArgument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<HTMLAudioElement> object = HTMLAudioElement::createForJSConstructor(*castedThis->document(), src);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSHTMLAudioElementNamedConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLMediaElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLAudioElementNamedConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLAudioElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("Audio"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLAudioElementNamedConstructor::s_info = { "Audio", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLAudioElementNamedConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLAudioElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAudioElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAudioElementConstructor) } },
};

const ClassInfo JSHTMLAudioElementPrototype::s_info = { "HTMLAudioElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLAudioElementPrototype) };

void JSHTMLAudioElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLAudioElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLAudioElement::s_info = { "HTMLAudioElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLAudioElement) };

JSHTMLAudioElement::JSHTMLAudioElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLAudioElement>&& impl)
    : JSHTMLMediaElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLAudioElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLAudioElementPrototype::create(vm, globalObject, JSHTMLAudioElementPrototype::createStructure(vm, globalObject, JSHTMLMediaElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLAudioElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLAudioElement>(vm, globalObject);
}

EncodedJSValue jsHTMLAudioElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLAudioElementPrototype* domObject = jsDynamicCast<JSHTMLAudioElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLAudioElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLAudioElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLAudioElementPrototype* domObject = jsDynamicCast<JSHTMLAudioElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSHTMLAudioElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLAudioElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSValue JSHTMLAudioElement::getNamedConstructor(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLAudioElementNamedConstructor>(vm, *jsCast<JSDOMGlobalObject*>(globalObject));
}

void JSHTMLAudioElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLAudioElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSHTMLAudioElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsHTMLAudioElement = jsCast<JSHTMLAudioElement*>(handle.slot()->asCell());
    if (jsHTMLAudioElement->wrapped().hasPendingActivity())
        return true;
    if (jsHTMLAudioElement->wrapped().isFiringEventListeners())
        return true;
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor))
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSHTMLAudioElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLAudioElement = jsCast<JSHTMLAudioElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsHTMLAudioElement->wrapped(), jsHTMLAudioElement);
}


}

#endif // ENABLE(VIDEO)
