/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEventTarget.h"

#include "DOMWindow.h"
#include "Event.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsEventTargetPrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsEventTargetPrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsEventTargetPrototypeFunctionDispatchEvent(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsEventTargetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSEventTargetConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSEventTargetPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSEventTargetPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEventTargetPrototype* ptr = new (NotNull, JSC::allocateCell<JSEventTargetPrototype>(vm.heap)) JSEventTargetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEventTargetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSEventTarget> JSEventTargetConstructor;

template<> JSValue JSEventTargetConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSEventTargetConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSEventTarget::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("EventTarget"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSEventTargetConstructor::s_info = { "EventTarget", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEventTargetConstructor) };

/* Hash table for prototype */

static const HashTableValue JSEventTargetPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventTargetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSEventTargetConstructor) } },
    { "addEventListener", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsEventTargetPrototypeFunctionAddEventListener), (intptr_t) (2) } },
    { "removeEventListener", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsEventTargetPrototypeFunctionRemoveEventListener), (intptr_t) (2) } },
    { "dispatchEvent", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsEventTargetPrototypeFunctionDispatchEvent), (intptr_t) (1) } },
};

const ClassInfo JSEventTargetPrototype::s_info = { "EventTargetPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEventTargetPrototype) };

void JSEventTargetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEventTargetPrototypeTableValues, *this);
}

const ClassInfo JSEventTarget::s_info = { "EventTarget", &Base::s_info, 0, CREATE_METHOD_TABLE(JSEventTarget) };

JSEventTarget::JSEventTarget(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EventTarget>&& impl)
    : JSDOMWrapper<EventTarget>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSEventTarget::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSEventTargetPrototype::create(vm, globalObject, JSEventTargetPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSEventTarget::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEventTarget>(vm, globalObject);
}

void JSEventTarget::destroy(JSC::JSCell* cell)
{
    JSEventTarget* thisObject = static_cast<JSEventTarget*>(cell);
    thisObject->JSEventTarget::~JSEventTarget();
}

EncodedJSValue jsEventTargetConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSEventTargetPrototype* domObject = jsDynamicCast<JSEventTargetPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSEventTarget::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSEventTargetConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSEventTargetPrototype* domObject = jsDynamicCast<JSEventTargetPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSEventTarget::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEventTargetConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsEventTargetPrototypeFunctionAddEventListener(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsEventTargetCast(thisValue.toThis(state, NotStrictMode));
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "EventTarget", "addEventListener");
    auto& impl = castedThis->wrapped();
    if (auto* window = castedThis->wrapped().toDOMWindow()) {
        if (!window->frame() || !BindingSecurity::shouldAllowAccessToDOMWindow(state, *window))
            return JSValue::encode(jsUndefined());
    }
    JSValue listener = state->argument(1);
    if (UNLIKELY(!listener.isObject()))
        return JSValue::encode(jsUndefined());
    impl.addEventListener(state->argument(0).toString(state)->toAtomicString(state), createJSEventListenerForAdd(*state, *asObject(listener), *castedThis), state->argument(2).toBoolean(state));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEventTargetPrototypeFunctionRemoveEventListener(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsEventTargetCast(thisValue.toThis(state, NotStrictMode));
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "EventTarget", "removeEventListener");
    auto& impl = castedThis->wrapped();
    if (auto* window = castedThis->wrapped().toDOMWindow()) {
        if (!window->frame() || !BindingSecurity::shouldAllowAccessToDOMWindow(state, *window))
            return JSValue::encode(jsUndefined());
    }
    JSValue listener = state->argument(1);
    if (UNLIKELY(!listener.isObject()))
        return JSValue::encode(jsUndefined());
    impl.removeEventListener(state->argument(0).toString(state)->toAtomicString(state), createJSEventListenerForRemove(*state, *asObject(listener), *castedThis).ptr(), state->argument(2).toBoolean(state));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEventTargetPrototypeFunctionDispatchEvent(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsEventTargetCast(thisValue.toThis(state, NotStrictMode));
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "EventTarget", "dispatchEvent");
    auto& impl = castedThis->wrapped();
    if (auto* window = castedThis->wrapped().toDOMWindow()) {
        if (!window->frame() || !BindingSecurity::shouldAllowAccessToDOMWindow(state, *window))
            return JSValue::encode(jsUndefined());
    }
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    Event* event = JSEvent::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.dispatchEventForBindings(event, ec));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

void JSEventTarget::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSEventTarget*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSEventTargetOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsEventTarget = jsCast<JSEventTarget*>(handle.slot()->asCell());
    if (jsEventTarget->wrapped().isFiringEventListeners())
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSEventTargetOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEventTarget = jsCast<JSEventTarget*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsEventTarget->wrapped(), jsEventTarget);
}


}
