/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSDataCue.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsDataCueData(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDataCueData(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDataCueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDataCueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDataCuePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDataCuePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDataCuePrototype* ptr = new (NotNull, JSC::allocateCell<JSDataCuePrototype>(vm.heap)) JSDataCuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDataCuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSDataCue> JSDataCueConstructor;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSDataCueConstructor::construct(JSC::ExecState* state)
{
    return constructJSDataCue(state);
}

template<> JSValue JSDataCueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSTextTrackCue::getConstructor(vm, &globalObject);
}

template<> void JSDataCueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDataCue::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("DataCue"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDataCueConstructor::s_info = { "DataCue", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDataCueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDataCuePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataCueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDataCueConstructor) } },
    { "data", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataCueData), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDataCueData) } },
};

const ClassInfo JSDataCuePrototype::s_info = { "DataCuePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDataCuePrototype) };

void JSDataCuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDataCuePrototypeTableValues, *this);
}

const ClassInfo JSDataCue::s_info = { "DataCue", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDataCue) };

JSDataCue::JSDataCue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DataCue>&& impl)
    : JSTextTrackCue(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDataCue::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDataCuePrototype::create(vm, globalObject, JSDataCuePrototype::createStructure(vm, globalObject, JSTextTrackCue::getPrototype(vm, globalObject)));
}

JSObject* JSDataCue::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDataCue>(vm, globalObject);
}

EncodedJSValue jsDataCueData(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSDataCue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "DataCue", "data");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.data()));
    return JSValue::encode(result);
}


EncodedJSValue jsDataCueConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDataCuePrototype* domObject = jsDynamicCast<JSDataCuePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDataCue::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDataCueConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDataCuePrototype* domObject = jsDynamicCast<JSDataCuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSDataCueData(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSDataCue* castedThis = jsDynamicCast<JSDataCue*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "DataCue", "data");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    ArrayBuffer* nativeValue = toArrayBuffer(value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setData(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSDataCue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDataCueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDataCue::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSDataCue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}

#endif // ENABLE(VIDEO_TRACK)
