/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSDOMWindow_h
#define JSDOMWindow_h

#include "JSDOMWindowBase.h"

namespace WebCore {

class DOMWindow;

class JSDOMWindowShell;

class WEBCORE_EXPORT JSDOMWindow : public JSDOMWindowBase {
public:
    typedef JSDOMWindowBase Base;
    static JSDOMWindow* create(JSC::VM& vm, JSC::Structure* structure, Ref<DOMWindow>&& impl, JSDOMWindowShell* windowShell)
    {
        JSDOMWindow* ptr = new (NotNull, JSC::allocateCell<JSDOMWindow>(vm.heap)) JSDOMWindow(vm, structure, WTFMove(impl), windowShell);
        ptr->finishCreation(vm, windowShell);
        vm.heap.addFinalizer(ptr, destroy);
        return ptr;
    }

    static const bool needsDestruction = false;

    static const bool hasStaticPropertyTable = true;

    static DOMWindow* toWrapped(JSC::JSValue);
    static bool getOwnPropertySlot(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertySlotByIndex(JSC::JSObject*, JSC::ExecState*, unsigned propertyName, JSC::PropertySlot&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static void putByIndex(JSC::JSCell*, JSC::ExecState*, unsigned propertyName, JSC::JSValue, bool shouldThrow);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::GlobalObjectType, StructureFlags), info());
    }

    static bool deleteProperty(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName);
    static bool deletePropertyByIndex(JSC::JSCell*, JSC::ExecState*, unsigned);
    static void getPropertyNames(JSC::JSObject*, JSC::ExecState*, JSC::PropertyNameArray&, JSC::EnumerationMode = JSC::EnumerationMode());
    static void getGenericPropertyNames(JSC::JSObject*, JSC::ExecState*, JSC::PropertyNameArray&, JSC::EnumerationMode = JSC::EnumerationMode());
    static void getStructurePropertyNames(JSC::JSObject*, JSC::ExecState*, JSC::PropertyNameArray&, JSC::EnumerationMode = JSC::EnumerationMode());
    static uint32_t getEnumerableLength(JSC::ExecState*, JSC::JSObject*);
    static void getOwnPropertyNames(JSC::JSObject*, JSC::ExecState*, JSC::PropertyNameArray&, JSC::EnumerationMode = JSC::EnumerationMode());
    static bool defineOwnProperty(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, const JSC::PropertyDescriptor&, bool shouldThrow);
    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);
    void visitAdditionalChildren(JSC::SlotVisitor&);


    // Custom attributes
    void setLocation(JSC::ExecState&, JSC::JSValue);
    JSC::JSValue event(JSC::ExecState&) const;
    JSC::JSValue image(JSC::ExecState&) const;
#if ENABLE(IOS_TOUCH_EVENTS)
    JSC::JSValue touch(JSC::ExecState&) const;
#endif
#if ENABLE(IOS_TOUCH_EVENTS)
    JSC::JSValue touchList(JSC::ExecState&) const;
#endif

    // Custom functions
    JSC::JSValue open(JSC::ExecState&);
    JSC::JSValue showModalDialog(JSC::ExecState&);
    JSC::JSValue postMessage(JSC::ExecState&);
    JSC::JSValue setTimeout(JSC::ExecState&);
    JSC::JSValue setInterval(JSC::ExecState&);
    DOMWindow& wrapped() const
    {
        return static_cast<DOMWindow&>(Base::wrapped());
    }
public:
    static const unsigned StructureFlags = JSC::ImplementsHasInstance | JSC::ImplementsDefaultHasInstance | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::OverridesGetOwnPropertySlot | JSC::OverridesGetPropertyNames | Base::StructureFlags;
protected:
    JSDOMWindow(JSC::VM&, JSC::Structure*, Ref<DOMWindow>&&, JSDOMWindowShell*);
    void finishCreation(JSC::VM&, JSDOMWindowShell*);
};


class JSDOMWindowPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDOMWindowPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMWindowPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMWindowPrototype>(vm.heap)) JSDOMWindowPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMWindowPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    static bool getOwnPropertySlot(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
public:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionFocus(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionBlur(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionClose(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionPostMessage(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDOMWindowClosed(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);

} // namespace WebCore

#endif
