/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMImplementation.h"

#include "CSSStyleSheet.h"
#include "DocumentType.h"
#include "ExceptionCode.h"
#include "HTMLDocument.h"
#include "JSCSSStyleSheet.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDocumentType.h"
#include "JSHTMLDocument.h"
#include "JSXMLDocument.h"
#include "XMLDocument.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionHasFeature(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateDocumentType(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateDocument(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateCSSStyleSheet(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateHTMLDocument(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsDOMImplementationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSDOMImplementationConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMImplementationPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDOMImplementationPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMImplementationPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMImplementationPrototype>(vm.heap)) JSDOMImplementationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMImplementationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSDOMImplementation> JSDOMImplementationConstructor;

template<> JSValue JSDOMImplementationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMImplementationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMImplementation::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("DOMImplementation"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSDOMImplementationConstructor::s_info = { "DOMImplementation", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMImplementationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMImplementationPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMImplementationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMImplementationConstructor) } },
    { "hasFeature", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMImplementationPrototypeFunctionHasFeature), (intptr_t) (0) } },
    { "createDocumentType", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMImplementationPrototypeFunctionCreateDocumentType), (intptr_t) (0) } },
    { "createDocument", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMImplementationPrototypeFunctionCreateDocument), (intptr_t) (0) } },
    { "createCSSStyleSheet", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMImplementationPrototypeFunctionCreateCSSStyleSheet), (intptr_t) (0) } },
    { "createHTMLDocument", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsDOMImplementationPrototypeFunctionCreateHTMLDocument), (intptr_t) (0) } },
};

const ClassInfo JSDOMImplementationPrototype::s_info = { "DOMImplementationPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMImplementationPrototype) };

void JSDOMImplementationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMImplementationPrototypeTableValues, *this);
}

const ClassInfo JSDOMImplementation::s_info = { "DOMImplementation", &Base::s_info, 0, CREATE_METHOD_TABLE(JSDOMImplementation) };

JSDOMImplementation::JSDOMImplementation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMImplementation>&& impl)
    : JSDOMWrapper<DOMImplementation>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSDOMImplementation::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSDOMImplementationPrototype::create(vm, globalObject, JSDOMImplementationPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSDOMImplementation::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMImplementation>(vm, globalObject);
}

void JSDOMImplementation::destroy(JSC::JSCell* cell)
{
    JSDOMImplementation* thisObject = static_cast<JSDOMImplementation*>(cell);
    thisObject->JSDOMImplementation::~JSDOMImplementation();
}

EncodedJSValue jsDOMImplementationConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSDOMImplementationPrototype* domObject = jsDynamicCast<JSDOMImplementationPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSDOMImplementation::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSDOMImplementationConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSDOMImplementationPrototype* domObject = jsDynamicCast<JSDOMImplementationPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSDOMImplementation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMImplementationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionHasFeature(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMImplementation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMImplementation", "hasFeature");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMImplementation::info());
    auto& impl = castedThis->wrapped();
    String feature = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String version = valueToStringWithNullCheck(state, state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsBoolean(impl.hasFeature(feature, version));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateDocumentType(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMImplementation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMImplementation", "createDocumentType");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMImplementation::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String qualifiedName = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String publicId = valueToStringWithUndefinedOrNullCheck(state, state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String systemId = valueToStringWithUndefinedOrNullCheck(state, state->argument(2));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createDocumentType(qualifiedName, publicId, systemId, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateDocument(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMImplementation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMImplementation", "createDocument");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMImplementation::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String namespaceURI = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String qualifiedName = valueToStringWithNullCheck(state, state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    DocumentType* doctype = JSDocumentType::toWrapped(state->argument(2));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createDocument(namespaceURI, qualifiedName, doctype, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateCSSStyleSheet(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMImplementation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMImplementation", "createCSSStyleSheet");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMImplementation::info());
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String title = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String media = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.createCSSStyleSheet(title, media, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateHTMLDocument(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSDOMImplementation*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "DOMImplementation", "createHTMLDocument");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSDOMImplementation::info());
    auto& impl = castedThis->wrapped();
    String title = state->argument(0).isUndefined() ? String() : state->uncheckedArgument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJSNewlyCreated(state, castedThis->globalObject(), WTF::getPtr(impl.createHTMLDocument(title)));
    return JSValue::encode(result);
}

bool JSDOMImplementationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsDOMImplementation = jsCast<JSDOMImplementation*>(handle.slot()->asCell());
    Document* root = WTF::getPtr(jsDOMImplementation->wrapped().document());
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSDOMImplementationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMImplementation = jsCast<JSDOMImplementation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMImplementation->wrapped(), jsDOMImplementation);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMImplementation* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSDOMImplementation>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, DOMImplementation* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMImplementation>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMImplementation.
    COMPILE_ASSERT(!__is_polymorphic(DOMImplementation), DOMImplementation_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSDOMImplementation>(globalObject, impl);
}

DOMImplementation* JSDOMImplementation::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMImplementation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
