/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasRenderingContext.h"

#include "Element.h"
#include "HTMLCanvasElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLCanvasElement.h"
#include "JSNodeCustom.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsCanvasRenderingContextCanvas(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasRenderingContextConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCanvasRenderingContextPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCanvasRenderingContextPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCanvasRenderingContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSCanvasRenderingContextPrototype>(vm.heap)) JSCanvasRenderingContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCanvasRenderingContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSCanvasRenderingContextPrototypeTableValues[] =
{
    { "canvas", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContextCanvas), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSCanvasRenderingContextPrototype::s_info = { "CanvasRenderingContextPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasRenderingContextPrototype) };

void JSCanvasRenderingContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCanvasRenderingContextPrototypeTableValues, *this);
}

const ClassInfo JSCanvasRenderingContext::s_info = { "CanvasRenderingContext", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasRenderingContext) };

JSCanvasRenderingContext::JSCanvasRenderingContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CanvasRenderingContext>&& impl)
    : JSDOMWrapper<CanvasRenderingContext>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCanvasRenderingContext::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCanvasRenderingContextPrototype::create(vm, globalObject, JSCanvasRenderingContextPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSCanvasRenderingContext::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasRenderingContext>(vm, globalObject);
}

void JSCanvasRenderingContext::destroy(JSC::JSCell* cell)
{
    JSCanvasRenderingContext* thisObject = static_cast<JSCanvasRenderingContext*>(cell);
    thisObject->JSCanvasRenderingContext::~JSCanvasRenderingContext();
}

EncodedJSValue jsCanvasRenderingContextCanvas(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCanvasRenderingContext*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CanvasRenderingContext", "canvas");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.canvas()));
    return JSValue::encode(result);
}


void setJSCanvasRenderingContextConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCanvasRenderingContextPrototype* domObject = jsDynamicCast<JSCanvasRenderingContextPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSCanvasRenderingContext::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSCanvasRenderingContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSCanvasRenderingContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsCanvasRenderingContext = jsCast<JSCanvasRenderingContext*>(handle.slot()->asCell());
    void* root = WebCore::root(jsCanvasRenderingContext->wrapped().canvas());
    return visitor.containsOpaqueRoot(root);
}

void JSCanvasRenderingContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCanvasRenderingContext = jsCast<JSCanvasRenderingContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCanvasRenderingContext->wrapped(), jsCanvasRenderingContext);
}

CanvasRenderingContext* JSCanvasRenderingContext::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCanvasRenderingContext*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
