/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSValue.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsCSSValueCssText(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSValueCssText(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCSSValueCssValueType(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSValueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCSSValueConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCSSValuePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCSSValuePrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSValuePrototype>(vm.heap)) JSCSSValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCSSValue> JSCSSValueConstructor;

/* Hash table for constructor */

static const HashTableValue JSCSSValueConstructorTableValues[] =
{
    { "CSS_INHERIT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "CSS_PRIMITIVE_VALUE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CSS_VALUE_LIST", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CSS_CUSTOM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};


COMPILE_ASSERT(0 == CSSValue::CSS_INHERIT, CSSValueEnumCSS_INHERITIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == CSSValue::CSS_PRIMITIVE_VALUE, CSSValueEnumCSS_PRIMITIVE_VALUEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == CSSValue::CSS_VALUE_LIST, CSSValueEnumCSS_VALUE_LISTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == CSSValue::CSS_CUSTOM, CSSValueEnumCSS_CUSTOMIsWrongUseDoNotCheckConstants);

template<> JSValue JSCSSValueConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCSSValueConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCSSValue::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CSSValue"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSCSSValueConstructorTableValues, *this);
}

template<> const ClassInfo JSCSSValueConstructor::s_info = { "CSSValue", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSValueConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCSSValuePrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSValueConstructor) } },
    { "cssText", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCssText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSValueCssText) } },
    { "cssValueType", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCssValueType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "CSS_INHERIT", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "CSS_PRIMITIVE_VALUE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CSS_VALUE_LIST", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "CSS_CUSTOM", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSCSSValuePrototype::s_info = { "CSSValuePrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSValuePrototype) };

void JSCSSValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSValuePrototypeTableValues, *this);
}

const ClassInfo JSCSSValue::s_info = { "CSSValue", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCSSValue) };

JSCSSValue::JSCSSValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSValue>&& impl)
    : JSDOMWrapper<CSSValue>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCSSValue::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCSSValuePrototype::create(vm, globalObject, JSCSSValuePrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSCSSValue::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSValue>(vm, globalObject);
}

void JSCSSValue::destroy(JSC::JSCell* cell)
{
    JSCSSValue* thisObject = static_cast<JSCSSValue*>(cell);
    thisObject->JSCSSValue::~JSCSSValue();
}

EncodedJSValue jsCSSValueCssText(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSValue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSValue", "cssText");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringOrNull(state, impl.cssText());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSValueCssValueType(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSCSSValue*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "CSSValue", "cssValueType");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.cssValueType());
    return JSValue::encode(result);
}


EncodedJSValue jsCSSValueConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCSSValuePrototype* domObject = jsDynamicCast<JSCSSValuePrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCSSValue::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCSSValueConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCSSValuePrototype* domObject = jsDynamicCast<JSCSSValuePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSCSSValueCssText(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSCSSValue* castedThis = jsDynamicCast<JSCSSValue*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "CSSValue", "cssText");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setCssText(nativeValue, ec);
    setDOMException(state, ec);
}


JSValue JSCSSValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSValueConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

CSSValue* JSCSSValue::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSValue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
