/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCDATASection.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsCDATASectionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCDATASectionConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCDATASectionPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCDATASectionPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCDATASectionPrototype* ptr = new (NotNull, JSC::allocateCell<JSCDATASectionPrototype>(vm.heap)) JSCDATASectionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCDATASectionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCDATASection> JSCDATASectionConstructor;

template<> JSValue JSCDATASectionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSText::getConstructor(vm, &globalObject);
}

template<> void JSCDATASectionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCDATASection::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CDATASection"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCDATASectionConstructor::s_info = { "CDATASection", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCDATASectionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCDATASectionPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCDATASectionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCDATASectionConstructor) } },
};

const ClassInfo JSCDATASectionPrototype::s_info = { "CDATASectionPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCDATASectionPrototype) };

void JSCDATASectionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCDATASectionPrototypeTableValues, *this);
}

const ClassInfo JSCDATASection::s_info = { "CDATASection", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCDATASection) };

JSCDATASection::JSCDATASection(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CDATASection>&& impl)
    : JSText(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCDATASection::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCDATASectionPrototype::create(vm, globalObject, JSCDATASectionPrototype::createStructure(vm, globalObject, JSText::getPrototype(vm, globalObject)));
}

JSObject* JSCDATASection::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCDATASection>(vm, globalObject);
}

EncodedJSValue jsCDATASectionConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCDATASectionPrototype* domObject = jsDynamicCast<JSCDATASectionPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCDATASection::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCDATASectionConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCDATASectionPrototype* domObject = jsDynamicCast<JSCDATASectionPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSCDATASection::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCDATASectionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCDATASection::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSCDATASection*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CDATASection@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12CDATASectionE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, CDATASection* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSCDATASection>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, CDATASection* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCDATASection>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7CDATASection@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12CDATASectionE[2];
#if COMPILER(CLANG)
    // If this fails CDATASection does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(CDATASection), CDATASection_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // CDATASection has subclasses. If CDATASection has subclasses that get passed
    // to toJS() we currently require CDATASection you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSCDATASection>(globalObject, impl);
}


}
