/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLTransformFeedback.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebGLTransformFeedbackConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLTransformFeedbackConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLTransformFeedbackPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLTransformFeedbackPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLTransformFeedbackPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLTransformFeedbackPrototype>(vm.heap)) JSWebGLTransformFeedbackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLTransformFeedbackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSWebGLTransformFeedback> JSWebGLTransformFeedbackConstructor;

template<> JSValue JSWebGLTransformFeedbackConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLTransformFeedbackConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLTransformFeedback::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebGLTransformFeedback"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebGLTransformFeedbackConstructor::s_info = { "WebGLTransformFeedback", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLTransformFeedbackConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLTransformFeedbackPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLTransformFeedbackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLTransformFeedbackConstructor) } },
};

const ClassInfo JSWebGLTransformFeedbackPrototype::s_info = { "WebGLTransformFeedbackPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLTransformFeedbackPrototype) };

void JSWebGLTransformFeedbackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLTransformFeedbackPrototypeTableValues, *this);
}

const ClassInfo JSWebGLTransformFeedback::s_info = { "WebGLTransformFeedback", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLTransformFeedback) };

JSWebGLTransformFeedback::JSWebGLTransformFeedback(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLTransformFeedback>&& impl)
    : JSDOMWrapper<WebGLTransformFeedback>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLTransformFeedback::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLTransformFeedbackPrototype::create(vm, globalObject, JSWebGLTransformFeedbackPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLTransformFeedback::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLTransformFeedback>(vm, globalObject);
}

void JSWebGLTransformFeedback::destroy(JSC::JSCell* cell)
{
    JSWebGLTransformFeedback* thisObject = static_cast<JSWebGLTransformFeedback*>(cell);
    thisObject->JSWebGLTransformFeedback::~JSWebGLTransformFeedback();
}

EncodedJSValue jsWebGLTransformFeedbackConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebGLTransformFeedbackPrototype* domObject = jsDynamicCast<JSWebGLTransformFeedbackPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebGLTransformFeedback::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebGLTransformFeedbackConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebGLTransformFeedbackPrototype* domObject = jsDynamicCast<JSWebGLTransformFeedbackPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWebGLTransformFeedback::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLTransformFeedbackConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSWebGLTransformFeedbackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLTransformFeedbackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLTransformFeedback = jsCast<JSWebGLTransformFeedback*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLTransformFeedback->wrapped(), jsWebGLTransformFeedback);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLTransformFeedback@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22WebGLTransformFeedbackE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLTransformFeedback* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLTransformFeedback>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLTransformFeedback* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLTransformFeedback>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLTransformFeedback@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22WebGLTransformFeedbackE[2];
#if COMPILER(CLANG)
    // If this fails WebGLTransformFeedback does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLTransformFeedback), WebGLTransformFeedback_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLTransformFeedback has subclasses. If WebGLTransformFeedback has subclasses that get passed
    // to toJS() we currently require WebGLTransformFeedback you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLTransformFeedback>(globalObject, impl);
}

WebGLTransformFeedback* JSWebGLTransformFeedback::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLTransformFeedback*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
