/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLFramebuffer.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebGLFramebufferConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLFramebufferConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLFramebufferPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLFramebufferPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLFramebufferPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLFramebufferPrototype>(vm.heap)) JSWebGLFramebufferPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLFramebufferPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSWebGLFramebuffer> JSWebGLFramebufferConstructor;

template<> JSValue JSWebGLFramebufferConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebGLFramebufferConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLFramebuffer::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebGLFramebuffer"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebGLFramebufferConstructor::s_info = { "WebGLFramebuffer", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLFramebufferConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLFramebufferPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLFramebufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLFramebufferConstructor) } },
};

const ClassInfo JSWebGLFramebufferPrototype::s_info = { "WebGLFramebufferPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLFramebufferPrototype) };

void JSWebGLFramebufferPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLFramebufferPrototypeTableValues, *this);
}

const ClassInfo JSWebGLFramebuffer::s_info = { "WebGLFramebuffer", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLFramebuffer) };

JSWebGLFramebuffer::JSWebGLFramebuffer(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLFramebuffer>&& impl)
    : JSDOMWrapper<WebGLFramebuffer>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLFramebuffer::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLFramebufferPrototype::create(vm, globalObject, JSWebGLFramebufferPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSWebGLFramebuffer::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLFramebuffer>(vm, globalObject);
}

void JSWebGLFramebuffer::destroy(JSC::JSCell* cell)
{
    JSWebGLFramebuffer* thisObject = static_cast<JSWebGLFramebuffer*>(cell);
    thisObject->JSWebGLFramebuffer::~JSWebGLFramebuffer();
}

EncodedJSValue jsWebGLFramebufferConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebGLFramebufferPrototype* domObject = jsDynamicCast<JSWebGLFramebufferPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebGLFramebuffer::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebGLFramebufferConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebGLFramebufferPrototype* domObject = jsDynamicCast<JSWebGLFramebufferPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWebGLFramebuffer::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLFramebufferConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSWebGLFramebufferOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebGLFramebufferOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLFramebuffer = jsCast<JSWebGLFramebuffer*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLFramebuffer->wrapped(), jsWebGLFramebuffer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLFramebuffer@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16WebGLFramebufferE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLFramebuffer* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSWebGLFramebuffer>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, WebGLFramebuffer* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSWebGLFramebuffer>(globalObject, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7WebGLFramebuffer@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16WebGLFramebufferE[2];
#if COMPILER(CLANG)
    // If this fails WebGLFramebuffer does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(WebGLFramebuffer), WebGLFramebuffer_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // WebGLFramebuffer has subclasses. If WebGLFramebuffer has subclasses that get passed
    // to toJS() we currently require WebGLFramebuffer you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createNewWrapper<JSWebGLFramebuffer>(globalObject, impl);
}

WebGLFramebuffer* JSWebGLFramebuffer::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLFramebuffer*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
