/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLContextEvent.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDictionary.h"
#include "URL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsWebGLContextEventStatusMessage(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsWebGLContextEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSWebGLContextEventConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSWebGLContextEventPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSWebGLContextEventPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLContextEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLContextEventPrototype>(vm.heap)) JSWebGLContextEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLContextEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSWebGLContextEvent> JSWebGLContextEventConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSWebGLContextEventConstructor::construct(ExecState* state)
{
    auto* jsConstructor = jsCast<JSWebGLContextEventConstructor*>(state->callee());

    if (!jsConstructor->scriptExecutionContext())
        return throwVMError(state, createReferenceError(state, "Constructor associated execution context is unavailable"));

    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));

    AtomicString eventType = state->argument(0).toString(state)->toAtomicString(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    WebGLContextEventInit eventInit;

    JSValue initializerValue = state->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(state);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(state, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillWebGLContextEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<WebGLContextEvent> event = WebGLContextEvent::createForBindings(eventType, eventInit);
    return JSValue::encode(toJS(state, jsConstructor->globalObject(), event.get()));
}

bool fillWebGLContextEventInit(WebGLContextEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("statusMessage", eventInit.statusMessage))
        return false;
    return true;
}

template<> JSValue JSWebGLContextEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSWebGLContextEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSWebGLContextEvent::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("WebGLContextEvent"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), ReadOnly | DontEnum);
}

template<> const ClassInfo JSWebGLContextEventConstructor::s_info = { "WebGLContextEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLContextEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSWebGLContextEventPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSWebGLContextEventConstructor) } },
    { "statusMessage", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextEventStatusMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSWebGLContextEventPrototype::s_info = { "WebGLContextEventPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLContextEventPrototype) };

void JSWebGLContextEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLContextEventPrototypeTableValues, *this);
}

const ClassInfo JSWebGLContextEvent::s_info = { "WebGLContextEvent", &Base::s_info, 0, CREATE_METHOD_TABLE(JSWebGLContextEvent) };

JSWebGLContextEvent::JSWebGLContextEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLContextEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSWebGLContextEvent::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSWebGLContextEventPrototype::create(vm, globalObject, JSWebGLContextEventPrototype::createStructure(vm, globalObject, JSEvent::getPrototype(vm, globalObject)));
}

JSObject* JSWebGLContextEvent::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLContextEvent>(vm, globalObject);
}

EncodedJSValue jsWebGLContextEventStatusMessage(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSWebGLContextEvent*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "WebGLContextEvent", "statusMessage");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.statusMessage());
    return JSValue::encode(result);
}


EncodedJSValue jsWebGLContextEventConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSWebGLContextEventPrototype* domObject = jsDynamicCast<JSWebGLContextEventPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSWebGLContextEvent::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSWebGLContextEventConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSWebGLContextEventPrototype* domObject = jsDynamicCast<JSWebGLContextEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSWebGLContextEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLContextEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(WEBGL)
