/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(TOUCH_EVENTS)

#include "JSTouchList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSTouch.h"
#include "Touch.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTouchListPrototypeFunctionItem(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsTouchListLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsTouchListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSTouchListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTouchListPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSTouchListPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTouchListPrototype* ptr = new (NotNull, JSC::allocateCell<JSTouchListPrototype>(vm.heap)) JSTouchListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTouchListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSTouchList> JSTouchListConstructor;

/* Hash table */

static const struct CompactHashIndex JSTouchListTableIndex[2] = {
    { -1, -1 },
    { 0, -1 },
};


static const HashTableValue JSTouchListTableValues[] =
{
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchListLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

static const HashTable JSTouchListTable = { 1, 1, true, JSTouchListTableValues, JSTouchListTableIndex };
template<> JSValue JSTouchListConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTouchListConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTouchList::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TouchList"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTouchListConstructor::s_info = { "TouchList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTouchListConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTouchListPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTouchListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTouchListConstructor) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTouchListPrototypeFunctionItem), (intptr_t) (1) } },
};

const ClassInfo JSTouchListPrototype::s_info = { "TouchListPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTouchListPrototype) };

void JSTouchListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTouchListPrototypeTableValues, *this);
}

const ClassInfo JSTouchList::s_info = { "TouchList", &Base::s_info, &JSTouchListTable, CREATE_METHOD_TABLE(JSTouchList) };

JSTouchList::JSTouchList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TouchList>&& impl)
    : JSDOMWrapper<TouchList>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSTouchList::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTouchListPrototype::create(vm, globalObject, JSTouchListPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSTouchList::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTouchList>(vm, globalObject);
}

void JSTouchList::destroy(JSC::JSCell* cell)
{
    JSTouchList* thisObject = static_cast<JSTouchList*>(cell);
    thisObject->JSTouchList::~JSTouchList();
}

bool JSTouchList::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSTouchList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex && optionalIndex.value() < thisObject->wrapped().length()) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    if (getStaticValueSlot<JSTouchList, Base>(state, JSTouchListTable, thisObject, propertyName, slot))
        return true;
    return false;
}

bool JSTouchList::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSTouchList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index < thisObject->wrapped().length()) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsTouchListLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSTouchList*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        JSObject* thisObject = JSValue::decode(thisValue).getObject();
        for (thisObject = thisObject ? thisObject->prototype().getObject() : nullptr; thisObject; thisObject = thisObject->prototype().getObject()) {
            if ((castedThis = jsDynamicCast<JSTouchList*>(thisObject)))
                break;
        }
        if (!castedThis)
            return throwGetterTypeError(*state, "TouchList", "length");
        reportDeprecatedGetterError(*state, "TouchList", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


EncodedJSValue jsTouchListConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSTouchListPrototype* domObject = jsDynamicCast<JSTouchListPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSTouchList::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSTouchListConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSTouchListPrototype* domObject = jsDynamicCast<JSTouchListPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSTouchList::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSTouchList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

JSValue JSTouchList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTouchListConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTouchListPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSTouchList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "TouchList", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSTouchList::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.item(index)));
    return JSValue::encode(result);
}

bool JSTouchListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSTouchListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTouchList = jsCast<JSTouchList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTouchList->wrapped(), jsTouchList);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, TouchList* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSTouchList>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, TouchList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTouchList>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TouchList.
    COMPILE_ASSERT(!__is_polymorphic(TouchList), TouchList_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSTouchList>(globalObject, impl);
}

TouchList* JSTouchList::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSTouchList*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(TOUCH_EVENTS)
