/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGRect.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsSVGRectX(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGRectX(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGRectY(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGRectY(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGRectWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGRectWidth(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGRectHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGRectHeight(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsSVGRectConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSSVGRectConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSSVGRectPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSVGRectPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGRectPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGRectPrototype>(vm.heap)) JSSVGRectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGRectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSSVGRect> JSSVGRectConstructor;

template<> JSValue JSSVGRectConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGRectConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSSVGRect::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("SVGRect"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSSVGRectConstructor::s_info = { "SVGRect", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGRectConstructor) };

/* Hash table for prototype */

static const HashTableValue JSSVGRectPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGRectConstructor) } },
    { "x", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGRectX) } },
    { "y", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGRectY) } },
    { "width", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGRectWidth) } },
    { "height", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSSVGRectHeight) } },
};

const ClassInfo JSSVGRectPrototype::s_info = { "SVGRectPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGRectPrototype) };

void JSSVGRectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGRectPrototypeTableValues, *this);
}

const ClassInfo JSSVGRect::s_info = { "SVGRect", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSVGRect) };

JSSVGRect::JSSVGRect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPropertyTearOff<FloatRect>>&& impl)
    : JSDOMWrapper<SVGPropertyTearOff<FloatRect>>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSVGRect::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSVGRectPrototype::create(vm, globalObject, JSSVGRectPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSVGRect::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGRect>(vm, globalObject);
}

void JSSVGRect::destroy(JSC::JSCell* cell)
{
    JSSVGRect* thisObject = static_cast<JSSVGRect*>(cell);
    thisObject->JSSVGRect::~JSSVGRect();
}

EncodedJSValue jsSVGRectX(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGRect", "x");
    }
    FloatRect& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.x());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGRectY(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGRect", "y");
    }
    FloatRect& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.y());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGRectWidth(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGRect", "width");
    }
    FloatRect& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.width());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGRectHeight(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSSVGRect*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "SVGRect", "height");
    }
    FloatRect& impl = castedThis->wrapped().propertyReference();
    JSValue result = jsNumber(impl.height());
    return JSValue::encode(result);
}


EncodedJSValue jsSVGRectConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSSVGRectPrototype* domObject = jsDynamicCast<JSSVGRectPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSSVGRect::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSSVGRectConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSSVGRectPrototype* domObject = jsDynamicCast<JSSVGRectPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSSVGRectX(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGRect* castedThis = jsDynamicCast<JSSVGRect*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGRect", "x");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    FloatRect& podImpl = impl.propertyReference();
    podImpl.setX(nativeValue);
    impl.commitChange();
}


void setJSSVGRectY(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGRect* castedThis = jsDynamicCast<JSSVGRect*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGRect", "y");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    FloatRect& podImpl = impl.propertyReference();
    podImpl.setY(nativeValue);
    impl.commitChange();
}


void setJSSVGRectWidth(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGRect* castedThis = jsDynamicCast<JSSVGRect*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGRect", "width");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    FloatRect& podImpl = impl.propertyReference();
    podImpl.setWidth(nativeValue);
    impl.commitChange();
}


void setJSSVGRectHeight(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSSVGRect* castedThis = jsDynamicCast<JSSVGRect*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "SVGRect", "height");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    if (impl.isReadOnly()) {
        setDOMException(state, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    FloatRect& podImpl = impl.propertyReference();
    podImpl.setHeight(nativeValue);
    impl.commitChange();
}


JSValue JSSVGRect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGRectConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSSVGRectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGRectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGRect = jsCast<JSSVGRect*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGRect->wrapped(), jsSVGRect);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<FloatRect>* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSVGRect, SVGPropertyTearOff<FloatRect>>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<FloatRect>* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGRect, SVGPropertyTearOff<FloatRect>>(globalObject, impl))
        return result;
    return createNewWrapper<JSSVGRect, SVGPropertyTearOff<FloatRect>>(globalObject, impl);
}

SVGPropertyTearOff<FloatRect>* JSSVGRect::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGRect*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
