/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLTransaction.h"

#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsSQLTransactionPrototypeFunctionExecuteSql(JSC::ExecState*);

class JSSQLTransactionPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSSQLTransactionPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLTransactionPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLTransactionPrototype>(vm.heap)) JSSQLTransactionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLTransactionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSSQLTransactionPrototypeTableValues[] =
{
    { "executeSql", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsSQLTransactionPrototypeFunctionExecuteSql), (intptr_t) (2) } },
};

const ClassInfo JSSQLTransactionPrototype::s_info = { "SQLTransactionPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSQLTransactionPrototype) };

void JSSQLTransactionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLTransactionPrototypeTableValues, *this);
}

const ClassInfo JSSQLTransaction::s_info = { "SQLTransaction", &Base::s_info, 0, CREATE_METHOD_TABLE(JSSQLTransaction) };

JSSQLTransaction::JSSQLTransaction(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLTransaction>&& impl)
    : JSDOMWrapper<SQLTransaction>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSSQLTransaction::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSSQLTransactionPrototype::create(vm, globalObject, JSSQLTransactionPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSSQLTransaction::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSQLTransaction>(vm, globalObject);
}

void JSSQLTransaction::destroy(JSC::JSCell* cell)
{
    JSSQLTransaction* thisObject = static_cast<JSSQLTransaction*>(cell);
    thisObject->JSSQLTransaction::~JSSQLTransaction();
}

EncodedJSValue JSC_HOST_CALL jsSQLTransactionPrototypeFunctionExecuteSql(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSSQLTransaction*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "SQLTransaction", "executeSql");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSSQLTransaction::info());
    return JSValue::encode(castedThis->executeSql(*state));
}

bool JSSQLTransactionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSSQLTransactionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLTransaction = jsCast<JSSQLTransaction*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSQLTransaction->wrapped(), jsSQLTransaction);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, SQLTransaction* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSSQLTransaction>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, SQLTransaction* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSQLTransaction>(globalObject, impl))
        return result;
    return createNewWrapper<JSSQLTransaction>(globalObject, impl);
}

SQLTransaction* JSSQLTransaction::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLTransaction*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
