/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CHANNEL_MESSAGING)

#include "JSMessageChannel.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSMessagePort.h"
#include "MessagePort.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsMessageChannelPort1(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMessageChannelPort2(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMessageChannelConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSMessageChannelConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMessageChannelPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSMessageChannelPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMessageChannelPrototype* ptr = new (NotNull, JSC::allocateCell<JSMessageChannelPrototype>(vm.heap)) JSMessageChannelPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMessageChannelPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructor<JSMessageChannel> JSMessageChannelConstructor;

template<> EncodedJSValue JSC_HOST_CALL JSMessageChannelConstructor::construct(ExecState* state)
{
    auto* castedThis = jsCast<JSMessageChannelConstructor*>(state->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwConstructorDocumentUnavailableError(*state, "MessageChannel");
    RefPtr<MessageChannel> object = MessageChannel::create(*context);
    return JSValue::encode(asObject(toJS(state, castedThis->globalObject(), object.get())));
}

template<> JSValue JSMessageChannelConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMessageChannelConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMessageChannel::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("MessageChannel"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSMessageChannelConstructor::s_info = { "MessageChannel", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMessageChannelConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMessageChannelPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageChannelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMessageChannelConstructor) } },
    { "port1", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageChannelPort1), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "port2", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageChannelPort2), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSMessageChannelPrototype::s_info = { "MessageChannelPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMessageChannelPrototype) };

void JSMessageChannelPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMessageChannelPrototypeTableValues, *this);
}

const ClassInfo JSMessageChannel::s_info = { "MessageChannel", &Base::s_info, 0, CREATE_METHOD_TABLE(JSMessageChannel) };

JSMessageChannel::JSMessageChannel(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MessageChannel>&& impl)
    : JSDOMWrapper<MessageChannel>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSMessageChannel::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSMessageChannelPrototype::create(vm, globalObject, JSMessageChannelPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSMessageChannel::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMessageChannel>(vm, globalObject);
}

void JSMessageChannel::destroy(JSC::JSCell* cell)
{
    JSMessageChannel* thisObject = static_cast<JSMessageChannel*>(cell);
    thisObject->JSMessageChannel::~JSMessageChannel();
}

EncodedJSValue jsMessageChannelPort1(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMessageChannel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MessageChannel", "port1");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.port1()));
    return JSValue::encode(result);
}


EncodedJSValue jsMessageChannelPort2(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSMessageChannel*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "MessageChannel", "port2");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.port2()));
    return JSValue::encode(result);
}


EncodedJSValue jsMessageChannelConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSMessageChannelPrototype* domObject = jsDynamicCast<JSMessageChannelPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSMessageChannel::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSMessageChannelConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSMessageChannelPrototype* domObject = jsDynamicCast<JSMessageChannelPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSMessageChannel::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMessageChannelConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMessageChannel::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSMessageChannel*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

bool JSMessageChannelOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSMessageChannelOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMessageChannel = jsCast<JSMessageChannel*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMessageChannel->wrapped(), jsMessageChannel);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, MessageChannel* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSMessageChannel>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, MessageChannel* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSMessageChannel>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MessageChannel.
    COMPILE_ASSERT(!__is_polymorphic(MessageChannel), MessageChannel_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSMessageChannel>(globalObject, impl);
}

MessageChannel* JSMessageChannel::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMessageChannel*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(CHANNEL_MESSAGING)
