/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLMediaElement.h"

#include "ExceptionCode.h"
#include "HTMLMediaElementMediaSession.h"
#include "HTMLMediaElementMediaStream.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSMediaController.h"
#include "JSMediaError.h"
#include "JSTimeRanges.h"
#include "MediaController.h"
#include "MediaError.h"
#include "TextTrack.h"
#include "TimeRanges.h"
#include "URL.h"
#include "VideoPlaybackQuality.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(ENCRYPTED_MEDIA_V2)
#include "JSMediaKeys.h"
#include "MediaKeys.h"
#endif

#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
#include "JSMediaSession.h"
#include "MediaSession.h"
#endif

#if ENABLE(MEDIA_SOURCE)
#include "JSVideoPlaybackQuality.h"
#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
#include "JSMediaStream.h"
#include "MediaStream.h"
#endif

#if ENABLE(VIDEO_TRACK)
#include "AudioTrackList.h"
#include "JSAudioTrackList.h"
#include "JSTextTrack.h"
#include "JSTextTrackList.h"
#include "JSVideoTrackList.h"
#include "TextTrackList.h"
#include "VideoTrackList.h"
#endif

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionLoad(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionCanPlayType(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionGetStartDate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionPlay(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionPause(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionFastSeek(JSC::ExecState*);
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitGenerateKeyRequest(JSC::ExecState*);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitAddKey(JSC::ExecState*);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitCancelKeyRequest(JSC::ExecState*);
#endif
#if ENABLE(ENCRYPTED_MEDIA_V2)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitSetMediaKeys(JSC::ExecState*);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionAddTextTrack(JSC::ExecState*);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionGetVideoPlaybackQuality(JSC::ExecState*);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitShowPlaybackTargetPicker(JSC::ExecState*);
#endif

// Attributes

JSC::EncodedJSValue jsHTMLMediaElementError(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementSrc(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementSrc(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementCurrentSrc(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementNetworkState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementPreload(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementPreload(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementBuffered(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementReadyState(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementSeeking(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementCurrentTime(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementCurrentTime(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementDuration(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementPaused(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementDefaultPlaybackRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementDefaultPlaybackRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementPlaybackRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementPlaybackRate(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementPlayed(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementSeekable(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementEnded(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementAutoplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementAutoplay(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementLoop(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementLoop(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementControls(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementControls(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementVolume(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementVolume(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementMuted(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementMuted(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementDefaultMuted(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementDefaultMuted(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementWebkitPreservesPitch(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementWebkitPreservesPitch(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementWebkitHasClosedCaptions(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementWebkitClosedCaptionsVisible(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementWebkitClosedCaptionsVisible(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(MEDIA_STATISTICS)
JSC::EncodedJSValue jsHTMLMediaElementWebkitAudioDecodedByteCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(MEDIA_STATISTICS)
JSC::EncodedJSValue jsHTMLMediaElementWebkitVideoDecodedByteCount(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(ENCRYPTED_MEDIA_V2)
JSC::EncodedJSValue jsHTMLMediaElementWebkitKeys(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsHTMLMediaElementAudioTracks(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsHTMLMediaElementTextTracks(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsHTMLMediaElementVideoTracks(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsHTMLMediaElementMediaGroup(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementMediaGroup(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementController(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementController(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue jsHTMLMediaElementWebkitCurrentPlaybackTargetIsWireless(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
JSC::EncodedJSValue jsHTMLMediaElementKind(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementKind(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
JSC::EncodedJSValue jsHTMLMediaElementSession(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementSession(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
JSC::EncodedJSValue jsHTMLMediaElementSrcObject(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementSrcObject(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsHTMLMediaElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLMediaElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLMediaElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLMediaElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLMediaElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLMediaElementPrototype>(vm.heap)) JSHTMLMediaElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLMediaElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLMediaElement> JSHTMLMediaElementConstructor;

/* Hash table for constructor */

static const HashTableValue JSHTMLMediaElementConstructorTableValues[] =
{
    { "NETWORK_EMPTY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "NETWORK_IDLE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "NETWORK_LOADING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "NETWORK_NO_SOURCE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "HAVE_NOTHING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "HAVE_METADATA", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "HAVE_CURRENT_DATA", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "HAVE_FUTURE_DATA", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "HAVE_ENOUGH_DATA", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
};


COMPILE_ASSERT(0 == HTMLMediaElement::NETWORK_EMPTY, HTMLMediaElementEnumNETWORK_EMPTYIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == HTMLMediaElement::NETWORK_IDLE, HTMLMediaElementEnumNETWORK_IDLEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == HTMLMediaElement::NETWORK_LOADING, HTMLMediaElementEnumNETWORK_LOADINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == HTMLMediaElement::NETWORK_NO_SOURCE, HTMLMediaElementEnumNETWORK_NO_SOURCEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0 == HTMLMediaElement::HAVE_NOTHING, HTMLMediaElementEnumHAVE_NOTHINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == HTMLMediaElement::HAVE_METADATA, HTMLMediaElementEnumHAVE_METADATAIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == HTMLMediaElement::HAVE_CURRENT_DATA, HTMLMediaElementEnumHAVE_CURRENT_DATAIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == HTMLMediaElement::HAVE_FUTURE_DATA, HTMLMediaElementEnumHAVE_FUTURE_DATAIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == HTMLMediaElement::HAVE_ENOUGH_DATA, HTMLMediaElementEnumHAVE_ENOUGH_DATAIsWrongUseDoNotCheckConstants);

template<> JSValue JSHTMLMediaElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLMediaElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLMediaElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLMediaElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
    reifyStaticProperties(vm, JSHTMLMediaElementConstructorTableValues, *this);
}

template<> const ClassInfo JSHTMLMediaElementConstructor::s_info = { "HTMLMediaElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMediaElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLMediaElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementConstructor) } },
    { "error", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementError), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "src", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSrc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementSrc) } },
    { "currentSrc", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementCurrentSrc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "networkState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNetworkState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "preload", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPreload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementPreload) } },
    { "buffered", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementBuffered), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "readyState", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "seeking", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSeeking), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentTime", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementCurrentTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementCurrentTime) } },
    { "duration", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementDuration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "paused", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPaused), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "defaultPlaybackRate", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementDefaultPlaybackRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementDefaultPlaybackRate) } },
    { "playbackRate", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPlaybackRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementPlaybackRate) } },
    { "played", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPlayed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "seekable", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSeekable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ended", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementEnded), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "autoplay", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementAutoplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementAutoplay) } },
    { "loop", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementLoop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementLoop) } },
    { "controls", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementControls), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementControls) } },
    { "volume", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementVolume), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementVolume) } },
    { "muted", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementMuted), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementMuted) } },
    { "defaultMuted", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementDefaultMuted), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementDefaultMuted) } },
    { "webkitPreservesPitch", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitPreservesPitch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementWebkitPreservesPitch) } },
    { "webkitHasClosedCaptions", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitHasClosedCaptions), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitClosedCaptionsVisible", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitClosedCaptionsVisible), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementWebkitClosedCaptionsVisible) } },
#if ENABLE(MEDIA_STATISTICS)
    { "webkitAudioDecodedByteCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitAudioDecodedByteCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STATISTICS)
    { "webkitVideoDecodedByteCount", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitVideoDecodedByteCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA_V2)
    { "webkitKeys", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitKeys), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "audioTracks", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementAudioTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "textTracks", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementTextTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "videoTracks", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementVideoTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "mediaGroup", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementMediaGroup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementMediaGroup) } },
    { "controller", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementController), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementController) } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "webkitCurrentPlaybackTargetIsWireless", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitCurrentPlaybackTargetIsWireless), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
    { "kind", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementKind) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
    { "session", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSession), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementSession) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
    { "srcObject", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSrcObject), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementSrcObject) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "load", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionLoad), (intptr_t) (0) } },
    { "canPlayType", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionCanPlayType), (intptr_t) (0) } },
    { "getStartDate", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionGetStartDate), (intptr_t) (0) } },
    { "play", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionPlay), (intptr_t) (0) } },
    { "pause", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionPause), (intptr_t) (0) } },
    { "fastSeek", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionFastSeek), (intptr_t) (1) } },
#if ENABLE(ENCRYPTED_MEDIA)
    { "webkitGenerateKeyRequest", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionWebkitGenerateKeyRequest), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "webkitAddKey", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionWebkitAddKey), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "webkitCancelKeyRequest", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionWebkitCancelKeyRequest), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA_V2)
    { "webkitSetMediaKeys", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionWebkitSetMediaKeys), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "addTextTrack", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionAddTextTrack), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SOURCE)
    { "getVideoPlaybackQuality", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionGetVideoPlaybackQuality), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "webkitShowPlaybackTargetPicker", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionWebkitShowPlaybackTargetPicker), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "NETWORK_EMPTY", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "NETWORK_IDLE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "NETWORK_LOADING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "NETWORK_NO_SOURCE", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "HAVE_NOTHING", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "HAVE_METADATA", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "HAVE_CURRENT_DATA", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "HAVE_FUTURE_DATA", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "HAVE_ENOUGH_DATA", DontDelete | ReadOnly | ConstantInteger, NoIntrinsic, { (long long)(4) } },
};

const ClassInfo JSHTMLMediaElementPrototype::s_info = { "HTMLMediaElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMediaElementPrototype) };

void JSHTMLMediaElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLMediaElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLMediaElement::s_info = { "HTMLMediaElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLMediaElement) };

JSHTMLMediaElement::JSHTMLMediaElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLMediaElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLMediaElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLMediaElementPrototype::create(vm, globalObject, JSHTMLMediaElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLMediaElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLMediaElement>(vm, globalObject);
}

EncodedJSValue jsHTMLMediaElementError(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "error");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.error()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementSrc(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "src");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.getURLAttribute(WebCore::HTMLNames::srcAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementCurrentSrc(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "currentSrc");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.currentSrc());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementNetworkState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "networkState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.networkState());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementPreload(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "preload");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.preload());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementBuffered(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "buffered");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.buffered()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementReadyState(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "readyState");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.readyState());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementSeeking(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "seeking");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.seeking());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementCurrentTime(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "currentTime");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.currentTime());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementDuration(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "duration");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.duration());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementPaused(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "paused");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.paused());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementDefaultPlaybackRate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "defaultPlaybackRate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.defaultPlaybackRate());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementPlaybackRate(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "playbackRate");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.playbackRate());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementPlayed(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "played");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.played()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementSeekable(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "seekable");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.seekable()));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementEnded(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "ended");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.ended());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementAutoplay(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "autoplay");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.fastHasAttribute(WebCore::HTMLNames::autoplayAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementLoop(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "loop");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.fastHasAttribute(WebCore::HTMLNames::loopAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementControls(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "controls");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.controls());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementVolume(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "volume");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.volume());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementMuted(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "muted");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.muted());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementDefaultMuted(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "defaultMuted");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.fastHasAttribute(WebCore::HTMLNames::mutedAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementWebkitPreservesPitch(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "webkitPreservesPitch");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitPreservesPitch());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementWebkitHasClosedCaptions(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "webkitHasClosedCaptions");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitHasClosedCaptions());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementWebkitClosedCaptionsVisible(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "webkitClosedCaptionsVisible");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitClosedCaptionsVisible());
    return JSValue::encode(result);
}


#if ENABLE(MEDIA_STATISTICS)
EncodedJSValue jsHTMLMediaElementWebkitAudioDecodedByteCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "webkitAudioDecodedByteCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.webkitAudioDecodedByteCount());
    return JSValue::encode(result);
}

#endif

#if ENABLE(MEDIA_STATISTICS)
EncodedJSValue jsHTMLMediaElementWebkitVideoDecodedByteCount(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "webkitVideoDecodedByteCount");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.webkitVideoDecodedByteCount());
    return JSValue::encode(result);
}

#endif

#if ENABLE(ENCRYPTED_MEDIA_V2)
EncodedJSValue jsHTMLMediaElementWebkitKeys(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "webkitKeys");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.keys()));
    return JSValue::encode(result);
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue jsHTMLMediaElementAudioTracks(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "audioTracks");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.audioTracks()));
    return JSValue::encode(result);
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue jsHTMLMediaElementTextTracks(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "textTracks");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.textTracks()));
    return JSValue::encode(result);
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue jsHTMLMediaElementVideoTracks(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "videoTracks");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.videoTracks()));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsHTMLMediaElementMediaGroup(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "mediaGroup");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::mediagroupAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLMediaElementController(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "controller");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.controller()));
    return JSValue::encode(result);
}


#if ENABLE(WIRELESS_PLAYBACK_TARGET)
EncodedJSValue jsHTMLMediaElementWebkitCurrentPlaybackTargetIsWireless(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "webkitCurrentPlaybackTargetIsWireless");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsBoolean(impl.webkitCurrentPlaybackTargetIsWireless());
    return JSValue::encode(result);
}

#endif

#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
EncodedJSValue jsHTMLMediaElementKind(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "kind");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, WebCore::HTMLMediaElementMediaSession::kind(impl));
    return JSValue::encode(result);
}

#endif

#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
EncodedJSValue jsHTMLMediaElementSession(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "session");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(WebCore::HTMLMediaElementMediaSession::session(impl)));
    return JSValue::encode(result);
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
EncodedJSValue jsHTMLMediaElementSrcObject(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLMediaElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLMediaElement", "srcObject");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(WebCore::HTMLMediaElementMediaStream::srcObject(impl)));
    return JSValue::encode(result);
}

#endif

EncodedJSValue jsHTMLMediaElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLMediaElementPrototype* domObject = jsDynamicCast<JSHTMLMediaElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLMediaElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLMediaElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLMediaElementPrototype* domObject = jsDynamicCast<JSHTMLMediaElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLMediaElementSrc(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "src");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcAttr, nativeValue);
}


void setJSHTMLMediaElementPreload(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "preload");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPreload(nativeValue);
}


void setJSHTMLMediaElementCurrentTime(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "currentTime");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setCurrentTime(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLMediaElementDefaultPlaybackRate(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "defaultPlaybackRate");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDefaultPlaybackRate(nativeValue);
}


void setJSHTMLMediaElementPlaybackRate(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "playbackRate");
        return;
    }
    auto& impl = castedThis->wrapped();
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setPlaybackRate(nativeValue);
}


void setJSHTMLMediaElementAutoplay(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "autoplay");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBooleanAttribute(WebCore::HTMLNames::autoplayAttr, nativeValue);
}


void setJSHTMLMediaElementLoop(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "loop");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBooleanAttribute(WebCore::HTMLNames::loopAttr, nativeValue);
}


void setJSHTMLMediaElementControls(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "controls");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setControls(nativeValue);
}


void setJSHTMLMediaElementVolume(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "volume");
        return;
    }
    auto& impl = castedThis->wrapped();
    ExceptionCode ec = 0;
    double nativeValue = value.toNumber(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setVolume(nativeValue, ec);
    setDOMException(state, ec);
}


void setJSHTMLMediaElementMuted(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "muted");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setMuted(nativeValue);
}


void setJSHTMLMediaElementDefaultMuted(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "defaultMuted");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setBooleanAttribute(WebCore::HTMLNames::mutedAttr, nativeValue);
}


void setJSHTMLMediaElementWebkitPreservesPitch(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "webkitPreservesPitch");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setWebkitPreservesPitch(nativeValue);
}


void setJSHTMLMediaElementWebkitClosedCaptionsVisible(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "webkitClosedCaptionsVisible");
        return;
    }
    auto& impl = castedThis->wrapped();
    bool nativeValue = value.toBoolean(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setWebkitClosedCaptionsVisible(nativeValue);
}


void setJSHTMLMediaElementMediaGroup(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "mediaGroup");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::mediagroupAttr, nativeValue);
}


void setJSHTMLMediaElementController(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "controller");
        return;
    }
    castedThis->setController(*state, value);
}


#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
void setJSHTMLMediaElementKind(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "kind");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    WebCore::HTMLMediaElementMediaSession::setKind(impl, nativeValue);
}

#endif

#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
void setJSHTMLMediaElementSession(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "session");
        return;
    }
    auto& impl = castedThis->wrapped();
    MediaSession* nativeValue = JSMediaSession::toWrapped(value);
    if (UNLIKELY(state->hadException()))
        return;
    WebCore::HTMLMediaElementMediaSession::setSession(impl, nativeValue);
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(VIDEO)
void setJSHTMLMediaElementSrcObject(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLMediaElement* castedThis = jsDynamicCast<JSHTMLMediaElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLMediaElement", "srcObject");
        return;
    }
    auto& impl = castedThis->wrapped();
    MediaStream* nativeValue = JSMediaStream::toWrapped(value);
    if (UNLIKELY(state->hadException()))
        return;
    WebCore::HTMLMediaElementMediaStream::setSrcObject(impl, nativeValue);
}

#endif

JSValue JSHTMLMediaElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMediaElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionLoad(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "load");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    impl.load();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionCanPlayType(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "canPlayType");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    String type = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = jsStringWithCache(state, impl.canPlayType(type));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionGetStartDate(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "getStartDate");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    JSValue result = jsDateOrNaN(state, impl.getStartDate());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionPlay(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "play");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    impl.play();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionPause(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "pause");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    impl.pause();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionFastSeek(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "fastSeek");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    double time = state->argument(0).toNumber(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.fastSeek(time);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(ENCRYPTED_MEDIA)
EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitGenerateKeyRequest(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "webkitGenerateKeyRequest");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String keySystem = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        impl.webkitGenerateKeyRequest(keySystem, ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    RefPtr<Uint8Array> initData = toUint8Array(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.webkitGenerateKeyRequest(keySystem, initData.get(), ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitAddKey(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "webkitAddKey");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 2))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String keySystem = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    RefPtr<Uint8Array> key = toUint8Array(state->argument(1));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 2) {
        impl.webkitAddKey(keySystem, key.get(), ec);
        setDOMException(state, ec);
        return JSValue::encode(jsUndefined());
    }

    RefPtr<Uint8Array> initData = toUint8Array(state->argument(2));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String sessionId = state->argument(3).isUndefined() ? String() : state->uncheckedArgument(3).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.webkitAddKey(keySystem, key.get(), initData.get(), sessionId, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitCancelKeyRequest(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "webkitCancelKeyRequest");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String keySystem = valueToStringWithUndefinedOrNullCheck(state, state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    String sessionId = state->argument(1).isUndefined() ? String() : state->uncheckedArgument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.webkitCancelKeyRequest(keySystem, sessionId, ec);
    setDOMException(state, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(ENCRYPTED_MEDIA_V2)
EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitSetMediaKeys(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "webkitSetMediaKeys");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    MediaKeys* mediaKeys = JSMediaKeys::toWrapped(state->argument(0));
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setMediaKeys(mediaKeys);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionAddTextTrack(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "addTextTrack");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 1))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    ExceptionCode ec = 0;
    String kind = state->argument(0).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());

    size_t argsCount = state->argumentCount();
    if (argsCount <= 1) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.addTextTrack(kind, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    String label = state->argument(1).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    if (argsCount <= 2) {
        JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.addTextTrack(kind, label, ec)));

        setDOMException(state, ec);
        return JSValue::encode(result);
    }

    String language = state->argument(2).toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.addTextTrack(kind, label, language, ec)));

    setDOMException(state, ec);
    return JSValue::encode(result);
}

#endif

#if ENABLE(MEDIA_SOURCE)
EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionGetVideoPlaybackQuality(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "getVideoPlaybackQuality");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.getVideoPlaybackQuality()));
    return JSValue::encode(result);
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitShowPlaybackTargetPicker(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSHTMLMediaElement*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "HTMLMediaElement", "webkitShowPlaybackTargetPicker");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSHTMLMediaElement::info());
    auto& impl = castedThis->wrapped();
    impl.webkitShowPlaybackTargetPicker();
    return JSValue::encode(jsUndefined());
}

#endif

void JSHTMLMediaElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLMediaElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}

bool JSHTMLMediaElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    auto* jsHTMLMediaElement = jsCast<JSHTMLMediaElement*>(handle.slot()->asCell());
    if (jsHTMLMediaElement->wrapped().hasPendingActivity())
        return true;
    if (jsHTMLMediaElement->wrapped().isFiringEventListeners())
        return true;
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor))
        return true;
    UNUSED_PARAM(visitor);
    return false;
}

void JSHTMLMediaElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLMediaElement = jsCast<JSHTMLMediaElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsHTMLMediaElement->wrapped(), jsHTMLMediaElement);
}

HTMLMediaElement* JSHTMLMediaElement::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLMediaElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
