/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLBaseElement.h"

#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "URL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsHTMLBaseElementHref(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBaseElementHref(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBaseElementTarget(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBaseElementTarget(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLBaseElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSHTMLBaseElementConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLBaseElementPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSHTMLBaseElementPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLBaseElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLBaseElementPrototype>(vm.heap)) JSHTMLBaseElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLBaseElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSHTMLBaseElement> JSHTMLBaseElementConstructor;

template<> JSValue JSHTMLBaseElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLBaseElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLBaseElement::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("HTMLBaseElement"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSHTMLBaseElementConstructor::s_info = { "HTMLBaseElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLBaseElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLBaseElementPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBaseElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBaseElementConstructor) } },
    { "href", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBaseElementHref), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBaseElementHref) } },
    { "target", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLBaseElementTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLBaseElementTarget) } },
};

const ClassInfo JSHTMLBaseElementPrototype::s_info = { "HTMLBaseElementPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLBaseElementPrototype) };

void JSHTMLBaseElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLBaseElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLBaseElement::s_info = { "HTMLBaseElement", &Base::s_info, 0, CREATE_METHOD_TABLE(JSHTMLBaseElement) };

JSHTMLBaseElement::JSHTMLBaseElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLBaseElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSHTMLBaseElement::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSHTMLBaseElementPrototype::create(vm, globalObject, JSHTMLBaseElementPrototype::createStructure(vm, globalObject, JSHTMLElement::getPrototype(vm, globalObject)));
}

JSObject* JSHTMLBaseElement::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLBaseElement>(vm, globalObject);
}

EncodedJSValue jsHTMLBaseElementHref(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBaseElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBaseElement", "href");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.href());
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLBaseElementTarget(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSHTMLBaseElement*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "HTMLBaseElement", "target");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsStringWithCache(state, impl.fastGetAttribute(WebCore::HTMLNames::targetAttr));
    return JSValue::encode(result);
}


EncodedJSValue jsHTMLBaseElementConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSHTMLBaseElementPrototype* domObject = jsDynamicCast<JSHTMLBaseElementPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSHTMLBaseElement::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSHTMLBaseElementConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSHTMLBaseElementPrototype* domObject = jsDynamicCast<JSHTMLBaseElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSHTMLBaseElementHref(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBaseElement* castedThis = jsDynamicCast<JSHTMLBaseElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBaseElement", "href");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = valueToStringWithNullCheck(state, value);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setHref(nativeValue);
}


void setJSHTMLBaseElementTarget(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSHTMLBaseElement* castedThis = jsDynamicCast<JSHTMLBaseElement*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "HTMLBaseElement", "target");
        return;
    }
    auto& impl = castedThis->wrapped();
    String nativeValue = value.toString(state)->value(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::targetAttr, nativeValue);
}


JSValue JSHTMLBaseElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLBaseElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSHTMLBaseElement::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSHTMLBaseElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->wrapped().visitJSEventListeners(visitor);
}


}
