/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GAMEPAD_DEPRECATED)

#include "JSGamepadList.h"

#include "ExceptionCode.h"
#include "Gamepad.h"
#include "JSDOMBinding.h"
#include "JSGamepad.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsGamepadListPrototypeFunctionItem(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsGamepadListLength(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSGamepadListConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSGamepadListPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSGamepadListPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGamepadListPrototype* ptr = new (NotNull, JSC::allocateCell<JSGamepadListPrototype>(vm.heap)) JSGamepadListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGamepadListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

/* Hash table for prototype */

static const HashTableValue JSGamepadListPrototypeTableValues[] =
{
    { "length", ReadOnly | CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGamepadListLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "item", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsGamepadListPrototypeFunctionItem), (intptr_t) (0) } },
};

const ClassInfo JSGamepadListPrototype::s_info = { "GamepadListPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSGamepadListPrototype) };

void JSGamepadListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGamepadListPrototypeTableValues, *this);
}

const ClassInfo JSGamepadList::s_info = { "GamepadList", &Base::s_info, 0, CREATE_METHOD_TABLE(JSGamepadList) };

JSGamepadList::JSGamepadList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GamepadList>&& impl)
    : JSDOMWrapper<GamepadList>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSGamepadList::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSGamepadListPrototype::create(vm, globalObject, JSGamepadListPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSGamepadList::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSGamepadList>(vm, globalObject);
}

void JSGamepadList::destroy(JSC::JSCell* cell)
{
    JSGamepadList* thisObject = static_cast<JSGamepadList*>(cell);
    thisObject->JSGamepadList::~JSGamepadList();
}

bool JSGamepadList::getOwnPropertySlot(JSObject* object, ExecState* state, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSGamepadList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Optional<uint32_t> optionalIndex = parseIndex(propertyName);
    if (optionalIndex && optionalIndex.value() < thisObject->wrapped().length()) {
        unsigned index = optionalIndex.value();
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    if (Base::getOwnPropertySlot(thisObject, state, propertyName, slot))
        return true;
    return false;
}

bool JSGamepadList::getOwnPropertySlotByIndex(JSObject* object, ExecState* state, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSGamepadList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (index < thisObject->wrapped().length()) {
        unsigned attributes = DontDelete | ReadOnly;
        slot.setValue(thisObject, attributes, toJS(state, thisObject->globalObject(), thisObject->wrapped().item(index)));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, state, index, slot);
}

EncodedJSValue jsGamepadListLength(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSGamepadList*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "GamepadList", "length");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.length());
    return JSValue::encode(result);
}


void setJSGamepadListConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSGamepadListPrototype* domObject = jsDynamicCast<JSGamepadListPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void JSGamepadList::getOwnPropertyNames(JSObject* object, ExecState* state, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    auto* thisObject = jsCast<JSGamepadList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(state, i));
    Base::getOwnPropertyNames(thisObject, state, propertyNames, mode);
}

EncodedJSValue JSC_HOST_CALL jsGamepadListPrototypeFunctionItem(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSGamepadList*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "GamepadList", "item");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSGamepadList::info());
    auto& impl = castedThis->wrapped();
    unsigned index = toUInt32(state, state->argument(0), NormalConversion);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    JSValue result = toJS(state, castedThis->globalObject(), WTF::getPtr(impl.item(index)));
    return JSValue::encode(result);
}

bool JSGamepadListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSGamepadListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGamepadList = jsCast<JSGamepadList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGamepadList->wrapped(), jsGamepadList);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, GamepadList* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSGamepadList>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, GamepadList* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSGamepadList>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to GamepadList.
    COMPILE_ASSERT(!__is_polymorphic(GamepadList), GamepadList_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSGamepadList>(globalObject, impl);
}

GamepadList* JSGamepadList::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGamepadList*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GAMEPAD_DEPRECATED)
