/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasPattern.h"

#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Attributes

JSC::EncodedJSValue jsCanvasPatternConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSCanvasPatternConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCanvasPatternPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSCanvasPatternPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCanvasPatternPrototype* ptr = new (NotNull, JSC::allocateCell<JSCanvasPatternPrototype>(vm.heap)) JSCanvasPatternPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCanvasPatternPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSCanvasPattern> JSCanvasPatternConstructor;

template<> JSValue JSCanvasPatternConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCanvasPatternConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCanvasPattern::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("CanvasPattern"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSCanvasPatternConstructor::s_info = { "CanvasPattern", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasPatternConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCanvasPatternPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasPatternConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasPatternConstructor) } },
};

const ClassInfo JSCanvasPatternPrototype::s_info = { "CanvasPatternPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasPatternPrototype) };

void JSCanvasPatternPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCanvasPatternPrototypeTableValues, *this);
}

const ClassInfo JSCanvasPattern::s_info = { "CanvasPattern", &Base::s_info, 0, CREATE_METHOD_TABLE(JSCanvasPattern) };

JSCanvasPattern::JSCanvasPattern(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CanvasPattern>&& impl)
    : JSDOMWrapper<CanvasPattern>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSCanvasPattern::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSCanvasPatternPrototype::create(vm, globalObject, JSCanvasPatternPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSCanvasPattern::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasPattern>(vm, globalObject);
}

void JSCanvasPattern::destroy(JSC::JSCell* cell)
{
    JSCanvasPattern* thisObject = static_cast<JSCanvasPattern*>(cell);
    thisObject->JSCanvasPattern::~JSCanvasPattern();
}

EncodedJSValue jsCanvasPatternConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSCanvasPatternPrototype* domObject = jsDynamicCast<JSCanvasPatternPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSCanvasPattern::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSCanvasPatternConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSCanvasPatternPrototype* domObject = jsDynamicCast<JSCanvasPatternPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

JSValue JSCanvasPattern::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasPatternConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSCanvasPatternOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSCanvasPatternOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCanvasPattern = jsCast<JSCanvasPattern*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCanvasPattern->wrapped(), jsCanvasPattern);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, CanvasPattern* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSCanvasPattern>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, CanvasPattern* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCanvasPattern>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to CanvasPattern.
    COMPILE_ASSERT(!__is_polymorphic(CanvasPattern), CanvasPattern_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSCanvasPattern>(globalObject, impl);
}

CanvasPattern* JSCanvasPattern::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCanvasPattern*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
