/* Generated by wayland-scanner 1.21.0 */

#ifndef IVI_CONTROLLER_CLIENT_PROTOCOL_H
#define IVI_CONTROLLER_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ivi_controller The ivi_controller protocol
 * @section page_ifaces_ivi_controller Interfaces
 * - @subpage page_iface_ivi_controller_surface - controller interface to surface in ivi compositor
 * - @subpage page_iface_ivi_controller_layer - controller interface to layer in ivi compositor
 * - @subpage page_iface_ivi_controller_screen - controller interface to screen in ivi compositor
 * - @subpage page_iface_ivi_controller - interface for ivi controllers to use ivi compositor features
 * @section page_copyright_ivi_controller Copyright
 * <pre>
 *
 * Copyright (C) 2013 DENSO CORPORATION
 * Copyright (c) 2013 BMW Car IT GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * </pre>
 */
struct ivi_controller;
struct ivi_controller_layer;
struct ivi_controller_screen;
struct ivi_controller_surface;
struct wl_output;

#ifndef IVI_CONTROLLER_SURFACE_INTERFACE
#define IVI_CONTROLLER_SURFACE_INTERFACE
/**
 * @page page_iface_ivi_controller_surface ivi_controller_surface
 * @section page_iface_ivi_controller_surface_desc Description
 * @section page_iface_ivi_controller_surface_api API
 * See @ref iface_ivi_controller_surface.
 */
/**
 * @defgroup iface_ivi_controller_surface The ivi_controller_surface interface
 */
extern const struct wl_interface ivi_controller_surface_interface;
#endif
#ifndef IVI_CONTROLLER_LAYER_INTERFACE
#define IVI_CONTROLLER_LAYER_INTERFACE
/**
 * @page page_iface_ivi_controller_layer ivi_controller_layer
 * @section page_iface_ivi_controller_layer_desc Description
 * @section page_iface_ivi_controller_layer_api API
 * See @ref iface_ivi_controller_layer.
 */
/**
 * @defgroup iface_ivi_controller_layer The ivi_controller_layer interface
 */
extern const struct wl_interface ivi_controller_layer_interface;
#endif
#ifndef IVI_CONTROLLER_SCREEN_INTERFACE
#define IVI_CONTROLLER_SCREEN_INTERFACE
/**
 * @page page_iface_ivi_controller_screen ivi_controller_screen
 * @section page_iface_ivi_controller_screen_desc Description
 * @section page_iface_ivi_controller_screen_api API
 * See @ref iface_ivi_controller_screen.
 */
/**
 * @defgroup iface_ivi_controller_screen The ivi_controller_screen interface
 */
extern const struct wl_interface ivi_controller_screen_interface;
#endif
#ifndef IVI_CONTROLLER_INTERFACE
#define IVI_CONTROLLER_INTERFACE
/**
 * @page page_iface_ivi_controller ivi_controller
 * @section page_iface_ivi_controller_desc Description
 * @section page_iface_ivi_controller_api API
 * See @ref iface_ivi_controller.
 */
/**
 * @defgroup iface_ivi_controller The ivi_controller interface
 */
extern const struct wl_interface ivi_controller_interface;
#endif

#ifndef IVI_CONTROLLER_SURFACE_ORIENTATION_ENUM
#define IVI_CONTROLLER_SURFACE_ORIENTATION_ENUM
/**
 * @ingroup iface_ivi_controller_surface
 * orientation presets in degrees
 *
 * The surfaces in ivi controller can be rotated in 90 degrees steps.
 * This enum defines all valid orientations for surfaces.
 */
enum ivi_controller_surface_orientation {
	/**
	 * not rotated
	 */
	IVI_CONTROLLER_SURFACE_ORIENTATION_0_DEGREES = 0,
	/**
	 * rotated 90 degrees clockwise
	 */
	IVI_CONTROLLER_SURFACE_ORIENTATION_90_DEGREES = 1,
	/**
	 * rotated 180 degrees clockwise
	 */
	IVI_CONTROLLER_SURFACE_ORIENTATION_180_DEGREES = 2,
	/**
	 * rotated 270 degrees clockwise
	 */
	IVI_CONTROLLER_SURFACE_ORIENTATION_270_DEGREES = 3,
};
#endif /* IVI_CONTROLLER_SURFACE_ORIENTATION_ENUM */

#ifndef IVI_CONTROLLER_SURFACE_PIXELFORMAT_ENUM
#define IVI_CONTROLLER_SURFACE_PIXELFORMAT_ENUM
/**
 * @ingroup iface_ivi_controller_surface
 * pixel format values
 *
 * Applications can provide buffers as surface content with differernt buffer
 * properties. This enum defines all supported buffer configurations.
 */
enum ivi_controller_surface_pixelformat {
	/**
	 * 8 bit luminance surface
	 */
	IVI_CONTROLLER_SURFACE_PIXELFORMAT_R_8 = 0,
	/**
	 * 24 bit rgb surface
	 */
	IVI_CONTROLLER_SURFACE_PIXELFORMAT_RGB_888 = 1,
	/**
	 * 24 bit rgb surface with 8 bit alpha
	 */
	IVI_CONTROLLER_SURFACE_PIXELFORMAT_RGBA_8888 = 2,
	/**
	 * 16 bit rgb surface
	 */
	IVI_CONTROLLER_SURFACE_PIXELFORMAT_RGB_565 = 3,
	/**
	 * 16 bit rgb surface with binary mask
	 */
	IVI_CONTROLLER_SURFACE_PIXELFORMAT_RGBA_5551 = 4,
	/**
	 * 18 bit rgb surface with binary mask
	 */
	IVI_CONTROLLER_SURFACE_PIXELFORMAT_RGBA_6661 = 5,
	/**
	 * 12 bit rgb surface with 4 bit alpha
	 */
	IVI_CONTROLLER_SURFACE_PIXELFORMAT_RGBA_4444 = 6,
	/**
	 * unknown
	 */
	IVI_CONTROLLER_SURFACE_PIXELFORMAT_UNKNOWN = 7,
};
#endif /* IVI_CONTROLLER_SURFACE_PIXELFORMAT_ENUM */

#ifndef IVI_CONTROLLER_SURFACE_CONTENT_STATE_ENUM
#define IVI_CONTROLLER_SURFACE_CONTENT_STATE_ENUM
/**
 * @ingroup iface_ivi_controller_surface
 * all possible states of content for a surface
 *
 * This enum defines all possible content states of a surface. This is
 * required, since surfaces in ivi compositor can exist without applications
 * providing content for them.
 */
enum ivi_controller_surface_content_state {
	/**
	 * application provided wl_surface for this surface
	 */
	IVI_CONTROLLER_SURFACE_CONTENT_STATE_CONTENT_AVAILABLE = 1,
	/**
	 * wl_surface was removed for this surface
	 */
	IVI_CONTROLLER_SURFACE_CONTENT_STATE_CONTENT_REMOVED = 2,
};
#endif /* IVI_CONTROLLER_SURFACE_CONTENT_STATE_ENUM */

/**
 * @ingroup iface_ivi_controller_surface
 * @struct ivi_controller_surface_listener
 */
struct ivi_controller_surface_listener {
	/**
	 * the visibility of the surface in ivi compositor has changed
	 *
	 * The new visibility state is provided in argument visibility.
	 * If visibility is 0, the surface has become invisible. If
	 * visibility is not 0, the surface has become visible.
	 */
	void (*visibility)(void *data,
			   struct ivi_controller_surface *ivi_controller_surface,
			   int32_t visibility);
	/**
	 * the opacity of surface in ivi compositor has changed
	 *
	 * The new opacity state is provided in argument opacity. The
	 * valid range for opactiy is 0.0 (fully transparent) to 1.0 (fully
	 * opaque).
	 */
	void (*opacity)(void *data,
			struct ivi_controller_surface *ivi_controller_surface,
			wl_fixed_t opacity);
	/**
	 * the source rectangle of surface in ivi compositor has changed
	 *
	 * The scanout region of the surface content has changed. The new
	 * values for source rectangle are provided by x: new horizontal
	 * start position of scanout area within the surface y: new
	 * vertical start position of scanout area within the surface
	 * width: new width of scanout area within the surface height: new
	 * height of scanout area within the surface
	 */
	void (*source_rectangle)(void *data,
				 struct ivi_controller_surface *ivi_controller_surface,
				 int32_t x,
				 int32_t y,
				 int32_t width,
				 int32_t height);
	/**
	 * the destination rectangle of surface in ivi compositor has changed
	 *
	 * The new values for source rectangle are provided by x: new
	 * horizontal start position of surface within the layer y: new
	 * vertical start position of surface within the layer width : new
	 * width of surface within the layer height: new height of surface
	 * within the layer
	 */
	void (*destination_rectangle)(void *data,
				      struct ivi_controller_surface *ivi_controller_surface,
				      int32_t x,
				      int32_t y,
				      int32_t width,
				      int32_t height);
	/**
	 * the configuration of surface in ivi compositor has changed
	 *
	 * The client providing content for this surface was requested to
	 * resize the buffer provided as surface content. The requested
	 * buffer size is provided by arguments width and height.
	 */
	void (*configuration)(void *data,
			      struct ivi_controller_surface *ivi_controller_surface,
			      int32_t width,
			      int32_t height);
	/**
	 * the orientation of surface in ivi compositor has changed
	 *
	 * The new orientation status is provided by argument
	 * orientation.
	 */
	void (*orientation)(void *data,
			    struct ivi_controller_surface *ivi_controller_surface,
			    int32_t orientation);
	/**
	 * pixelformat for surface in ivi compositor has changed
	 *
	 * When client attach buffers as surface content, these buffers
	 * have a pixelformat configuration. If the pixelformat of a newly
	 * attached buffer is different from the previous buffer
	 * configuration, this event is raised. This is also done, when the
	 * first buffer is provided by application.
	 */
	void (*pixelformat)(void *data,
			    struct ivi_controller_surface *ivi_controller_surface,
			    int32_t pixelformat);
	/**
	 * surface in ivi compositor was added to a layer
	 *
	 * This surface was added to the render order of the layer
	 * defined by argument layer. This is essential for a surface to
	 * become visible on screen, since ivi compositors will only render
	 * layers (or more precise all surfaces in the render order of a
	 * layer).
	 */
	void (*layer)(void *data,
		      struct ivi_controller_surface *ivi_controller_surface,
		      struct ivi_controller_layer *layer);
	/**
	 * receive updated statistics for surface in ivi compositor
	 *
	 * The information contained in this event is essential for
	 * monitoring, debugging, logging and tracing support in IVI
	 * systems.
	 */
	void (*stats)(void *data,
		      struct ivi_controller_surface *ivi_controller_surface,
		      uint32_t redraw_count,
		      uint32_t frame_count,
		      uint32_t update_count,
		      uint32_t pid,
		      const char *process_name);
	/**
	 * ivi_controller_surface was destroyed
	 *
	 * 
	 */
	void (*destroyed)(void *data,
			  struct ivi_controller_surface *ivi_controller_surface);
	/**
	 * content state for surface has changed
	 *
	 * Surfaces in ivi compositor can exist without any application
	 * or controller referencing it. All surfaces initially have no
	 * content. This event indicates when content state has changed.
	 * All possible content states are defined in enum content_state.
	 */
	void (*content)(void *data,
			struct ivi_controller_surface *ivi_controller_surface,
			int32_t content_state);
};

/**
 * @ingroup iface_ivi_controller_surface
 */
static inline int
ivi_controller_surface_add_listener(struct ivi_controller_surface *ivi_controller_surface,
				    const struct ivi_controller_surface_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ivi_controller_surface,
				     (void (**)(void)) listener, data);
}

#define IVI_CONTROLLER_SURFACE_SET_VISIBILITY 0
#define IVI_CONTROLLER_SURFACE_SET_OPACITY 1
#define IVI_CONTROLLER_SURFACE_SET_SOURCE_RECTANGLE 2
#define IVI_CONTROLLER_SURFACE_SET_DESTINATION_RECTANGLE 3
#define IVI_CONTROLLER_SURFACE_SET_CONFIGURATION 4
#define IVI_CONTROLLER_SURFACE_SET_ORIENTATION 5
#define IVI_CONTROLLER_SURFACE_SCREENSHOT 6
#define IVI_CONTROLLER_SURFACE_SEND_STATS 7
#define IVI_CONTROLLER_SURFACE_DESTROY 8

/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_SOURCE_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_DESTINATION_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_CONFIGURATION_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_ORIENTATION_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_PIXELFORMAT_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_LAYER_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_STATS_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_DESTROYED_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_CONTENT_SINCE_VERSION 1

/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_SET_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_SET_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_SET_SOURCE_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_SET_DESTINATION_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_SET_CONFIGURATION_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_SET_ORIENTATION_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_SCREENSHOT_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_SEND_STATS_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_surface
 */
#define IVI_CONTROLLER_SURFACE_DESTROY_SINCE_VERSION 1

/** @ingroup iface_ivi_controller_surface */
static inline void
ivi_controller_surface_set_user_data(struct ivi_controller_surface *ivi_controller_surface, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ivi_controller_surface, user_data);
}

/** @ingroup iface_ivi_controller_surface */
static inline void *
ivi_controller_surface_get_user_data(struct ivi_controller_surface *ivi_controller_surface)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ivi_controller_surface);
}

static inline uint32_t
ivi_controller_surface_get_version(struct ivi_controller_surface *ivi_controller_surface)
{
	return wl_proxy_get_version((struct wl_proxy *) ivi_controller_surface);
}

/**
 * @ingroup iface_ivi_controller_surface
 *
 * If visibility argument is 0, the surface in the ivi compositor is set to invisible.
 * If visibility argument is not 0, the surface in the ivi compositor is set to visible.
 */
static inline void
ivi_controller_surface_set_visibility(struct ivi_controller_surface *ivi_controller_surface, uint32_t visibility)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_surface,
			 IVI_CONTROLLER_SURFACE_SET_VISIBILITY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_surface), 0, visibility);
}

/**
 * @ingroup iface_ivi_controller_surface
 *
 * The valid range for opacity is 0.0 (fully transparent) to 1.0 (fully opaque).
 */
static inline void
ivi_controller_surface_set_opacity(struct ivi_controller_surface *ivi_controller_surface, wl_fixed_t opacity)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_surface,
			 IVI_CONTROLLER_SURFACE_SET_OPACITY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_surface), 0, opacity);
}

/**
 * @ingroup iface_ivi_controller_surface
 *
 * The source rectangle defines the part of the surface content, that is used for
 * compositing the surface. It can be used, if valid content of the surface is smaller
 * than the surface. Effectively it can be used to zoom the content of the surface.
 * x:      horizontal start position of scanout area within the surface
 * y:      vertical start position of scanout area within the surface
 * width:  width of scanout area within the surface
 * height: height of scanout area within the surface
 */
static inline void
ivi_controller_surface_set_source_rectangle(struct ivi_controller_surface *ivi_controller_surface, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_surface,
			 IVI_CONTROLLER_SURFACE_SET_SOURCE_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_surface), 0, x, y, width, height);
}

/**
 * @ingroup iface_ivi_controller_surface
 *
 * The destination rectangle defines the position and size of a surface on a layer.
 * The surface will be scaled to this rectangle for rendering.
 * x:      horizontal start position of surface within the layer
 * y:      vertical start position of surface within the layer
 * width : width of surface within the layer
 * height: height of surface within the layer
 */
static inline void
ivi_controller_surface_set_destination_rectangle(struct ivi_controller_surface *ivi_controller_surface, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_surface,
			 IVI_CONTROLLER_SURFACE_SET_DESTINATION_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_surface), 0, x, y, width, height);
}

/**
 * @ingroup iface_ivi_controller_surface
 *
 * Request the client providing content for this surface, to resize of the buffers
 * provided as surface content.
 */
static inline void
ivi_controller_surface_set_configuration(struct ivi_controller_surface *ivi_controller_surface, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_surface,
			 IVI_CONTROLLER_SURFACE_SET_CONFIGURATION, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_surface), 0, width, height);
}

/**
 * @ingroup iface_ivi_controller_surface
 *
 * The orientation of a surface in ivi compositor can be rotated in 90 degree steps,
 * as defined in orientation enum.
 */
static inline void
ivi_controller_surface_set_orientation(struct ivi_controller_surface *ivi_controller_surface, int32_t orientation)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_surface,
			 IVI_CONTROLLER_SURFACE_SET_ORIENTATION, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_surface), 0, orientation);
}

/**
 * @ingroup iface_ivi_controller_surface
 *
 * Store a screenshot of the surface content in the file provided by argument filename.
 */
static inline void
ivi_controller_surface_screenshot(struct ivi_controller_surface *ivi_controller_surface, const char *filename)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_surface,
			 IVI_CONTROLLER_SURFACE_SCREENSHOT, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_surface), 0, filename);
}

/**
 * @ingroup iface_ivi_controller_surface
 *
 * These stats contain information required for monitoring, debugging, logging
 * and tracing.
 */
static inline void
ivi_controller_surface_send_stats(struct ivi_controller_surface *ivi_controller_surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_surface,
			 IVI_CONTROLLER_SURFACE_SEND_STATS, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_surface), 0);
}

/**
 * @ingroup iface_ivi_controller_surface
 *
 * Request to destroy the ivi_controller_surface. If argument
 * destroy_scene_object id not 0, the surface will be destroyed in
 * ivi compositor. If argument is 0, only the proxy object is destroyed.
 */
static inline void
ivi_controller_surface_destroy(struct ivi_controller_surface *ivi_controller_surface, int32_t destroy_scene_object)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_surface,
			 IVI_CONTROLLER_SURFACE_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_surface), WL_MARSHAL_FLAG_DESTROY, destroy_scene_object);
}

/**
 * @ingroup iface_ivi_controller_layer
 * @struct ivi_controller_layer_listener
 */
struct ivi_controller_layer_listener {
	/**
	 * the visibility of the layer in ivi compositor has changed
	 *
	 * The new visibility state is provided in argument visibility.
	 * If visibility is 0, the layer has become invisible. If
	 * visibility is not 0, the layer has become visible.
	 */
	void (*visibility)(void *data,
			   struct ivi_controller_layer *ivi_controller_layer,
			   int32_t visibility);
	/**
	 * the opacity of layer in ivi compositor has changed
	 *
	 * The new opacity state is provided in argument opacity. The
	 * valid range for opactiy is 0.0 (fully transparent) to 1.0 (fully
	 * opaque).
	 */
	void (*opacity)(void *data,
			struct ivi_controller_layer *ivi_controller_layer,
			wl_fixed_t opacity);
	/**
	 * the source rectangle of layer in ivi compositor has changed
	 *
	 * The scanout region of the layer content has changed. The new
	 * values for source rectangle are provided by x: new horizontal
	 * start position of scanout area within the layer y: new vertical
	 * start position of scanout area within the layer width: new width
	 * of scanout area within the layer height: new height of scanout
	 * area within the layer
	 */
	void (*source_rectangle)(void *data,
				 struct ivi_controller_layer *ivi_controller_layer,
				 int32_t x,
				 int32_t y,
				 int32_t width,
				 int32_t height);
	/**
	 * the destination rectangle of layer in ivi compositor has changed
	 *
	 * The new values for source rectangle are provided by x: new
	 * horizontal start position of layer within the screen y: new
	 * vertical start position of layer within the screen width : new
	 * width of layer within the screen height: new height of layer
	 * within the screen
	 */
	void (*destination_rectangle)(void *data,
				      struct ivi_controller_layer *ivi_controller_layer,
				      int32_t x,
				      int32_t y,
				      int32_t width,
				      int32_t height);
	/**
	 * the configuration of layer in ivi compositor has changed
	 *
	 * The layer was resized. The new layer size is provided by
	 * arguments width and height.
	 */
	void (*configuration)(void *data,
			      struct ivi_controller_layer *ivi_controller_layer,
			      int32_t width,
			      int32_t height);
	/**
	 * the orientation of layer in ivi compositor has changed
	 *
	 * The new orientation status is provided by argument
	 * orientation.
	 */
	void (*orientation)(void *data,
			    struct ivi_controller_layer *ivi_controller_layer,
			    int32_t orientation);
	/**
	 * layer in ivi compositor was added to a screen
	 *
	 * This layer was added to the render order of the screen defined
	 * by argument screen. This is essential for a layer to become
	 * visible on screen, since ivi compositors will only render
	 * screens (or more precise all layers in the render order of a
	 * screen).
	 */
	void (*screen)(void *data,
		       struct ivi_controller_layer *ivi_controller_layer,
		       struct wl_output *screen);
	/**
	 * destroyed layer event
	 *
	 * 
	 */
	void (*destroyed)(void *data,
			  struct ivi_controller_layer *ivi_controller_layer);
};

/**
 * @ingroup iface_ivi_controller_layer
 */
static inline int
ivi_controller_layer_add_listener(struct ivi_controller_layer *ivi_controller_layer,
				  const struct ivi_controller_layer_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ivi_controller_layer,
				     (void (**)(void)) listener, data);
}

#define IVI_CONTROLLER_LAYER_SET_VISIBILITY 0
#define IVI_CONTROLLER_LAYER_SET_OPACITY 1
#define IVI_CONTROLLER_LAYER_SET_SOURCE_RECTANGLE 2
#define IVI_CONTROLLER_LAYER_SET_DESTINATION_RECTANGLE 3
#define IVI_CONTROLLER_LAYER_SET_CONFIGURATION 4
#define IVI_CONTROLLER_LAYER_SET_ORIENTATION 5
#define IVI_CONTROLLER_LAYER_SCREENSHOT 6
#define IVI_CONTROLLER_LAYER_CLEAR_SURFACES 7
#define IVI_CONTROLLER_LAYER_ADD_SURFACE 8
#define IVI_CONTROLLER_LAYER_REMOVE_SURFACE 9
#define IVI_CONTROLLER_LAYER_SET_RENDER_ORDER 10
#define IVI_CONTROLLER_LAYER_DESTROY 11

/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_SOURCE_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_DESTINATION_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_CONFIGURATION_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_ORIENTATION_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_SCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_DESTROYED_SINCE_VERSION 1

/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_SET_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_SET_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_SET_SOURCE_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_SET_DESTINATION_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_SET_CONFIGURATION_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_SET_ORIENTATION_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_SCREENSHOT_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_CLEAR_SURFACES_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_ADD_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_REMOVE_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_SET_RENDER_ORDER_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_layer
 */
#define IVI_CONTROLLER_LAYER_DESTROY_SINCE_VERSION 1

/** @ingroup iface_ivi_controller_layer */
static inline void
ivi_controller_layer_set_user_data(struct ivi_controller_layer *ivi_controller_layer, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ivi_controller_layer, user_data);
}

/** @ingroup iface_ivi_controller_layer */
static inline void *
ivi_controller_layer_get_user_data(struct ivi_controller_layer *ivi_controller_layer)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ivi_controller_layer);
}

static inline uint32_t
ivi_controller_layer_get_version(struct ivi_controller_layer *ivi_controller_layer)
{
	return wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * If visibility argument is 0, the layer in the ivi compositor is set to invisible.
 * If visibility argument is not 0, the layer in the ivi compositor is set to visible.
 */
static inline void
ivi_controller_layer_set_visibility(struct ivi_controller_layer *ivi_controller_layer, uint32_t visibility)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_SET_VISIBILITY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0, visibility);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * The valid range for opacity is 0.0 (fully transparent) to 1.0 (fully opaque).
 */
static inline void
ivi_controller_layer_set_opacity(struct ivi_controller_layer *ivi_controller_layer, wl_fixed_t opacity)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_SET_OPACITY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0, opacity);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * The source rectangle defines the part of the layer content, that is used for
 * compositing the screen. It can be used, if valid content of the layer is smaller
 * than the layer. Effectively it can be used to zoom the content of the layer.
 * x:      horizontal start position of scanout area within the layer
 * y:      vertical start position of scanout area within the layer
 * width:  width of scanout area within the layer
 * height: height of scanout area within the layer
 */
static inline void
ivi_controller_layer_set_source_rectangle(struct ivi_controller_layer *ivi_controller_layer, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_SET_SOURCE_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0, x, y, width, height);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * The destination rectangle defines the position and size of a layer on a screen.
 * The layer will be scaled to this rectangle for rendering.
 * x:      horizontal start position of layer within the screen
 * y:      vertical start position of layer within the screen
 * width : width of surface within the screen
 * height: height of surface within the screen
 */
static inline void
ivi_controller_layer_set_destination_rectangle(struct ivi_controller_layer *ivi_controller_layer, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_SET_DESTINATION_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0, x, y, width, height);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * Layers are created with an initial size, but they can be resized at runtime.
 * This request changes the widht and height of a layer.
 */
static inline void
ivi_controller_layer_set_configuration(struct ivi_controller_layer *ivi_controller_layer, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_SET_CONFIGURATION, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0, width, height);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * The orientation of a layer in ivi compositor can be rotated in 90 degree steps,
 * as defined in orientation enum.
 */
static inline void
ivi_controller_layer_set_orientation(struct ivi_controller_layer *ivi_controller_layer, int32_t orientation)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_SET_ORIENTATION, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0, orientation);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * Store a screenshot of the layer content in the file provided by argument filename.
 */
static inline void
ivi_controller_layer_screenshot(struct ivi_controller_layer *ivi_controller_layer, const char *filename)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_SCREENSHOT, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0, filename);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * A layer has no content assigned to itself, it is a container for surfaces.
 * This request removes all surfaces from the layer render order.
 * Note: the surfaces are not destroyed, they are just no longer contained by
 * the layer.
 */
static inline void
ivi_controller_layer_clear_surfaces(struct ivi_controller_layer *ivi_controller_layer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_CLEAR_SURFACES, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * A layer has no content assigned to itself, it is a container for surfaces.
 * This request adds a surface to the topmost position of the layer render order.
 * The added surface will cover all other surfaces of the layer.
 */
static inline void
ivi_controller_layer_add_surface(struct ivi_controller_layer *ivi_controller_layer, struct ivi_controller_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_ADD_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0, surface);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * A layer has no content assigned to itself, it is a container for surfaces.
 * This request removes one surfaces from the layer render order.
 * Note: the surface is not destroyed, it is just no longer contained by
 * the layer.
 */
static inline void
ivi_controller_layer_remove_surface(struct ivi_controller_layer *ivi_controller_layer, struct ivi_controller_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_REMOVE_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0, surface);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * A layer has no content assigned to itself, it is a container for surfaces.
 * This request removes all surfaces from the layer render order and set a
 * completely new render order.
 */
static inline void
ivi_controller_layer_set_render_order(struct ivi_controller_layer *ivi_controller_layer, struct wl_array *id_surfaces)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_SET_RENDER_ORDER, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), 0, id_surfaces);
}

/**
 * @ingroup iface_ivi_controller_layer
 *
 * Request to destroy the ivi_controller_layer. If argument
 * destroy_scene_object id not 0, the layer will be destroyed in
 * ivi compositor. If argument is 0, only the proxy object is destroyed.
 */
static inline void
ivi_controller_layer_destroy(struct ivi_controller_layer *ivi_controller_layer, int32_t destroy_scene_object)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_layer,
			 IVI_CONTROLLER_LAYER_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_layer), WL_MARSHAL_FLAG_DESTROY, destroy_scene_object);
}

#define IVI_CONTROLLER_SCREEN_DESTROY 0
#define IVI_CONTROLLER_SCREEN_CLEAR 1
#define IVI_CONTROLLER_SCREEN_ADD_LAYER 2
#define IVI_CONTROLLER_SCREEN_SCREENSHOT 3
#define IVI_CONTROLLER_SCREEN_SET_RENDER_ORDER 4


/**
 * @ingroup iface_ivi_controller_screen
 */
#define IVI_CONTROLLER_SCREEN_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_screen
 */
#define IVI_CONTROLLER_SCREEN_CLEAR_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_screen
 */
#define IVI_CONTROLLER_SCREEN_ADD_LAYER_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_screen
 */
#define IVI_CONTROLLER_SCREEN_SCREENSHOT_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller_screen
 */
#define IVI_CONTROLLER_SCREEN_SET_RENDER_ORDER_SINCE_VERSION 1

/** @ingroup iface_ivi_controller_screen */
static inline void
ivi_controller_screen_set_user_data(struct ivi_controller_screen *ivi_controller_screen, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ivi_controller_screen, user_data);
}

/** @ingroup iface_ivi_controller_screen */
static inline void *
ivi_controller_screen_get_user_data(struct ivi_controller_screen *ivi_controller_screen)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ivi_controller_screen);
}

static inline uint32_t
ivi_controller_screen_get_version(struct ivi_controller_screen *ivi_controller_screen)
{
	return wl_proxy_get_version((struct wl_proxy *) ivi_controller_screen);
}

/**
 * @ingroup iface_ivi_controller_screen
 */
static inline void
ivi_controller_screen_destroy(struct ivi_controller_screen *ivi_controller_screen)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_screen,
			 IVI_CONTROLLER_SCREEN_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_screen), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ivi_controller_screen
 *
 * A screen has no content assigned to itself, it is a container for layers.
 * This request removes all layers from the screen render order.
 * Note: the layers are not destroyed, they are just no longer contained by
 * the screen.
 */
static inline void
ivi_controller_screen_clear(struct ivi_controller_screen *ivi_controller_screen)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_screen,
			 IVI_CONTROLLER_SCREEN_CLEAR, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_screen), 0);
}

/**
 * @ingroup iface_ivi_controller_screen
 *
 * A screen has no content assigned to itself, it is a container for layers.
 * This request adds a layers to the topmost position of the screen render order.
 * The added layer will cover all other layers of the screen.
 */
static inline void
ivi_controller_screen_add_layer(struct ivi_controller_screen *ivi_controller_screen, struct ivi_controller_layer *layer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_screen,
			 IVI_CONTROLLER_SCREEN_ADD_LAYER, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_screen), 0, layer);
}

/**
 * @ingroup iface_ivi_controller_screen
 *
 * Store a screenshot of the screen content in the file provided by argument filename.
 */
static inline void
ivi_controller_screen_screenshot(struct ivi_controller_screen *ivi_controller_screen, const char *filename)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_screen,
			 IVI_CONTROLLER_SCREEN_SCREENSHOT, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_screen), 0, filename);
}

/**
 * @ingroup iface_ivi_controller_screen
 *
 * A screen has no content assigned to itself, it is a container for layers.
 * This request removes all layers from the screen render order and set a
 * completely new render order.
 */
static inline void
ivi_controller_screen_set_render_order(struct ivi_controller_screen *ivi_controller_screen, struct wl_array *id_layers)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller_screen,
			 IVI_CONTROLLER_SCREEN_SET_RENDER_ORDER, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller_screen), 0, id_layers);
}

#ifndef IVI_CONTROLLER_OBJECT_TYPE_ENUM
#define IVI_CONTROLLER_OBJECT_TYPE_ENUM
/**
 * @ingroup iface_ivi_controller
 * available object types in ivi compositor scene
 *
 * This enum defines all scene object available in ivi compositor.
 */
enum ivi_controller_object_type {
	/**
	 * surface object type
	 */
	IVI_CONTROLLER_OBJECT_TYPE_SURFACE = 1,
	/**
	 * layer object type
	 */
	IVI_CONTROLLER_OBJECT_TYPE_LAYER = 2,
	/**
	 * screen object type
	 */
	IVI_CONTROLLER_OBJECT_TYPE_SCREEN = 3,
};
#endif /* IVI_CONTROLLER_OBJECT_TYPE_ENUM */

#ifndef IVI_CONTROLLER_ERROR_CODE_ENUM
#define IVI_CONTROLLER_ERROR_CODE_ENUM
/**
 * @ingroup iface_ivi_controller
 * possible error codes returned in error event
 *
 * These error codes define all possible error codes returned by ivi compositor
 * on server-side errors.
 */
enum ivi_controller_error_code {
	/**
	 * unknown error encountered
	 */
	IVI_CONTROLLER_ERROR_CODE_UNKNOWN_ERROR = 1,
	/**
	 * file i/o error encountered
	 */
	IVI_CONTROLLER_ERROR_CODE_FILE_ERROR = 2,
};
#endif /* IVI_CONTROLLER_ERROR_CODE_ENUM */

/**
 * @ingroup iface_ivi_controller
 * @struct ivi_controller_listener
 */
struct ivi_controller_listener {
	/**
	 * new screen is available
	 *
	 * A new screen is announced to the controller. This is typically
	 * the case in two cases: 1. controller was just started, ivi
	 * compositor announces existing screen 2. a new screen was added
	 * to the system at runtime
	 */
	void (*screen)(void *data,
		       struct ivi_controller *ivi_controller,
		       uint32_t id_screen,
		       struct ivi_controller_screen *screen);
	/**
	 * new layer is available
	 *
	 * A new layer is announced to the controller.
	 */
	void (*layer)(void *data,
		      struct ivi_controller *ivi_controller,
		      uint32_t id_layer);
	/**
	 * new surface is available
	 *
	 * A new surface is announced to the controller.
	 */
	void (*surface)(void *data,
			struct ivi_controller *ivi_controller,
			uint32_t id_surface);
	/**
	 * server-side error detected
	 *
	 * The ivi compositor encountered error while processing a
	 * request by this controller. The error is defined by argument
	 * error_code and optional error_text. Additionally the object type
	 * and id is contained in the error event to provide some detailes
	 * to handle the error. If the controller requires to associate
	 * this error event to a request, it can 1. send request 2. force
	 * display roundtrip 3. check, if error event was received but this
	 * restricts the controller to have only one open request at a
	 * time.
	 */
	void (*error)(void *data,
		      struct ivi_controller *ivi_controller,
		      int32_t object_id,
		      int32_t object_type,
		      int32_t error_code,
		      const char *error_text);
};

/**
 * @ingroup iface_ivi_controller
 */
static inline int
ivi_controller_add_listener(struct ivi_controller *ivi_controller,
			    const struct ivi_controller_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ivi_controller,
				     (void (**)(void)) listener, data);
}

#define IVI_CONTROLLER_COMMIT_CHANGES 0
#define IVI_CONTROLLER_LAYER_CREATE 1
#define IVI_CONTROLLER_SURFACE_CREATE 2

/**
 * @ingroup iface_ivi_controller
 */
#define IVI_CONTROLLER_SCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller
 */
#define IVI_CONTROLLER_LAYER_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller
 */
#define IVI_CONTROLLER_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller
 */
#define IVI_CONTROLLER_ERROR_SINCE_VERSION 1

/**
 * @ingroup iface_ivi_controller
 */
#define IVI_CONTROLLER_COMMIT_CHANGES_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller
 */
#define IVI_CONTROLLER_LAYER_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_ivi_controller
 */
#define IVI_CONTROLLER_SURFACE_CREATE_SINCE_VERSION 1

/** @ingroup iface_ivi_controller */
static inline void
ivi_controller_set_user_data(struct ivi_controller *ivi_controller, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ivi_controller, user_data);
}

/** @ingroup iface_ivi_controller */
static inline void *
ivi_controller_get_user_data(struct ivi_controller *ivi_controller)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ivi_controller);
}

static inline uint32_t
ivi_controller_get_version(struct ivi_controller *ivi_controller)
{
	return wl_proxy_get_version((struct wl_proxy *) ivi_controller);
}

/** @ingroup iface_ivi_controller */
static inline void
ivi_controller_destroy(struct ivi_controller *ivi_controller)
{
	wl_proxy_destroy((struct wl_proxy *) ivi_controller);
}

/**
 * @ingroup iface_ivi_controller
 *
 * All requests are not applied directly to scene object, so a controller
 * can set different properties and apply the changes all at once.
 * Note: there's an exception to this. Creation and destruction of
 * scene objects is executed immediately.
 */
static inline void
ivi_controller_commit_changes(struct ivi_controller *ivi_controller)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller,
			 IVI_CONTROLLER_COMMIT_CHANGES, NULL, wl_proxy_get_version((struct wl_proxy *) ivi_controller), 0);
}

/**
 * @ingroup iface_ivi_controller
 *
 * layer_create will create a new layer with id_layer in ivi compositor,
 * if it does not yet exists. If the layer with id_layer already exists in
 * ivi compositor, a handle to the existing layer is returned and width and
 * height properties are ignored.
 */
static inline struct ivi_controller_layer *
ivi_controller_layer_create(struct ivi_controller *ivi_controller, uint32_t id_layer, int32_t width, int32_t height)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller,
			 IVI_CONTROLLER_LAYER_CREATE, &ivi_controller_layer_interface, wl_proxy_get_version((struct wl_proxy *) ivi_controller), 0, id_layer, width, height, NULL);

	return (struct ivi_controller_layer *) id;
}

/**
 * @ingroup iface_ivi_controller
 *
 * surface_create will create a new surface with id_surface in ivi compositor,
 * if it does not yet exists. If the surface with id_surface already exists in
 * ivi compositor, a handle to the existing surface is returned.
 */
static inline struct ivi_controller_surface *
ivi_controller_surface_create(struct ivi_controller *ivi_controller, uint32_t id_surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) ivi_controller,
			 IVI_CONTROLLER_SURFACE_CREATE, &ivi_controller_surface_interface, wl_proxy_get_version((struct wl_proxy *) ivi_controller), 0, id_surface, NULL);

	return (struct ivi_controller_surface *) id;
}

#ifdef  __cplusplus
}
#endif

#endif
