/* Generated by wayland-scanner 1.21.0 */

#ifndef TABLET_UNSTABLE_V2_CLIENT_PROTOCOL_H
#define TABLET_UNSTABLE_V2_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_tablet_unstable_v2 The tablet_unstable_v2 protocol
 * Wayland protocol for graphics tablets
 *
 * @section page_desc_tablet_unstable_v2 Description
 *
 * This description provides a high-level overview of the interplay between
 * the interfaces defined this protocol. For details, see the protocol
 * specification.
 *
 * More than one tablet may exist, and device-specifics matter. Tablets are
 * not represented by a single virtual device like wl_pointer. A client
 * binds to the tablet manager object which is just a proxy object. From
 * that, the client requests wp_tablet_manager.get_tablet_seat(wl_seat)
 * and that returns the actual interface that has all the tablets. With
 * this indirection, we can avoid merging wp_tablet into the actual Wayland
 * protocol, a long-term benefit.
 *
 * The wp_tablet_seat sends a "tablet added" event for each tablet
 * connected. That event is followed by descriptive events about the
 * hardware; currently that includes events for name, vid/pid and
 * a wp_tablet.path event that describes a local path. This path can be
 * used to uniquely identify a tablet or get more information through
 * libwacom. Emulated or nested tablets can skip any of those, e.g. a
 * virtual tablet may not have a vid/pid. The sequence of descriptive
 * events is terminated by a wp_tablet.done event to signal that a client
 * may now finalize any initialization for that tablet.
 *
 * Events from tablets require a tool in proximity. Tools are also managed
 * by the tablet seat; a "tool added" event is sent whenever a tool is new
 * to the compositor. That event is followed by a number of descriptive
 * events about the hardware; currently that includes capabilities,
 * hardware id and serial number, and tool type. Similar to the tablet
 * interface, a wp_tablet_tool.done event is sent to terminate that initial
 * sequence.
 *
 * Any event from a tool happens on the wp_tablet_tool interface. When the
 * tool gets into proximity of the tablet, a proximity_in event is sent on
 * the wp_tablet_tool interface, listing the tablet and the surface. That
 * event is followed by a motion event with the coordinates. After that,
 * it's the usual motion, axis, button, etc. events. The protocol's
 * serialisation means events are grouped by wp_tablet_tool.frame events.
 *
 * Two special events (that don't exist in X) are down and up. They signal
 * "tip touching the surface". For tablets without real proximity
 * detection, the sequence is: proximity_in, motion, down, frame.
 *
 * When the tool leaves proximity, a proximity_out event is sent. If any
 * button is still down, a button release event is sent before this
 * proximity event. These button events are sent in the same frame as the
 * proximity event to signal to the client that the buttons were held when
 * the tool left proximity.
 *
 * If the tool moves out of the surface but stays in proximity (i.e.
 * between windows), compositor-specific grab policies apply. This usually
 * means that the proximity-out is delayed until all buttons are released.
 *
 * Moving a tool physically from one tablet to the other has no real effect
 * on the protocol, since we already have the tool object from the "tool
 * added" event. All the information is already there and the proximity
 * events on both tablets are all a client needs to reconstruct what
 * happened.
 *
 * Some extra axes are normalized, i.e. the client knows the range as
 * specified in the protocol (e.g. [0, 65535]), the granularity however is
 * unknown. The current normalized axes are pressure, distance, and slider.
 *
 * Other extra axes are in physical units as specified in the protocol.
 * The current extra axes with physical units are tilt, rotation and
 * wheel rotation.
 *
 * Since tablets work independently of the pointer controlled by the mouse,
 * the focus handling is independent too and controlled by proximity.
 * The wp_tablet_tool.set_cursor request sets a tool-specific cursor.
 * This cursor surface may be the same as the mouse cursor, and it may be
 * the same across tools but it is possible to be more fine-grained. For
 * example, a client may set different cursors for the pen and eraser.
 *
 * Tools are generally independent of tablets and it is
 * compositor-specific policy when a tool can be removed. Common approaches
 * will likely include some form of removing a tool when all tablets the
 * tool was used on are removed.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * @section page_ifaces_tablet_unstable_v2 Interfaces
 * - @subpage page_iface_zwp_tablet_manager_v2 - controller object for graphic tablet devices
 * - @subpage page_iface_zwp_tablet_seat_v2 - controller object for graphic tablet devices of a seat
 * - @subpage page_iface_zwp_tablet_tool_v2 - a physical tablet tool
 * - @subpage page_iface_zwp_tablet_v2 - graphics tablet device
 * - @subpage page_iface_zwp_tablet_pad_ring_v2 - pad ring
 * - @subpage page_iface_zwp_tablet_pad_strip_v2 - pad strip
 * - @subpage page_iface_zwp_tablet_pad_group_v2 - a set of buttons, rings and strips
 * - @subpage page_iface_zwp_tablet_pad_v2 - a set of buttons, rings and strips
 * @section page_copyright_tablet_unstable_v2 Copyright
 * <pre>
 *
 * Copyright 2014 © Stephen "Lyude" Chandler Paul
 * Copyright 2015-2016 © Red Hat, Inc.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * </pre>
 */
struct wl_seat;
struct wl_surface;
struct zwp_tablet_manager_v2;
struct zwp_tablet_pad_group_v2;
struct zwp_tablet_pad_ring_v2;
struct zwp_tablet_pad_strip_v2;
struct zwp_tablet_pad_v2;
struct zwp_tablet_seat_v2;
struct zwp_tablet_tool_v2;
struct zwp_tablet_v2;

#ifndef ZWP_TABLET_MANAGER_V2_INTERFACE
#define ZWP_TABLET_MANAGER_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_manager_v2 zwp_tablet_manager_v2
 * @section page_iface_zwp_tablet_manager_v2_desc Description
 *
 * An object that provides access to the graphics tablets available on this
 * system. All tablets are associated with a seat, to get access to the
 * actual tablets, use wp_tablet_manager.get_tablet_seat.
 * @section page_iface_zwp_tablet_manager_v2_api API
 * See @ref iface_zwp_tablet_manager_v2.
 */
/**
 * @defgroup iface_zwp_tablet_manager_v2 The zwp_tablet_manager_v2 interface
 *
 * An object that provides access to the graphics tablets available on this
 * system. All tablets are associated with a seat, to get access to the
 * actual tablets, use wp_tablet_manager.get_tablet_seat.
 */
extern const struct wl_interface zwp_tablet_manager_v2_interface;
#endif
#ifndef ZWP_TABLET_SEAT_V2_INTERFACE
#define ZWP_TABLET_SEAT_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_seat_v2 zwp_tablet_seat_v2
 * @section page_iface_zwp_tablet_seat_v2_desc Description
 *
 * An object that provides access to the graphics tablets available on this
 * seat. After binding to this interface, the compositor sends a set of
 * wp_tablet_seat.tablet_added and wp_tablet_seat.tool_added events.
 * @section page_iface_zwp_tablet_seat_v2_api API
 * See @ref iface_zwp_tablet_seat_v2.
 */
/**
 * @defgroup iface_zwp_tablet_seat_v2 The zwp_tablet_seat_v2 interface
 *
 * An object that provides access to the graphics tablets available on this
 * seat. After binding to this interface, the compositor sends a set of
 * wp_tablet_seat.tablet_added and wp_tablet_seat.tool_added events.
 */
extern const struct wl_interface zwp_tablet_seat_v2_interface;
#endif
#ifndef ZWP_TABLET_TOOL_V2_INTERFACE
#define ZWP_TABLET_TOOL_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_tool_v2 zwp_tablet_tool_v2
 * @section page_iface_zwp_tablet_tool_v2_desc Description
 *
 * An object that represents a physical tool that has been, or is
 * currently in use with a tablet in this seat. Each wp_tablet_tool
 * object stays valid until the client destroys it; the compositor
 * reuses the wp_tablet_tool object to indicate that the object's
 * respective physical tool has come into proximity of a tablet again.
 *
 * A wp_tablet_tool object's relation to a physical tool depends on the
 * tablet's ability to report serial numbers. If the tablet supports
 * this capability, then the object represents a specific physical tool
 * and can be identified even when used on multiple tablets.
 *
 * A tablet tool has a number of static characteristics, e.g. tool type,
 * hardware_serial and capabilities. These capabilities are sent in an
 * event sequence after the wp_tablet_seat.tool_added event before any
 * actual events from this tool. This initial event sequence is
 * terminated by a wp_tablet_tool.done event.
 *
 * Tablet tool events are grouped by wp_tablet_tool.frame events.
 * Any events received before a wp_tablet_tool.frame event should be
 * considered part of the same hardware state change.
 * @section page_iface_zwp_tablet_tool_v2_api API
 * See @ref iface_zwp_tablet_tool_v2.
 */
/**
 * @defgroup iface_zwp_tablet_tool_v2 The zwp_tablet_tool_v2 interface
 *
 * An object that represents a physical tool that has been, or is
 * currently in use with a tablet in this seat. Each wp_tablet_tool
 * object stays valid until the client destroys it; the compositor
 * reuses the wp_tablet_tool object to indicate that the object's
 * respective physical tool has come into proximity of a tablet again.
 *
 * A wp_tablet_tool object's relation to a physical tool depends on the
 * tablet's ability to report serial numbers. If the tablet supports
 * this capability, then the object represents a specific physical tool
 * and can be identified even when used on multiple tablets.
 *
 * A tablet tool has a number of static characteristics, e.g. tool type,
 * hardware_serial and capabilities. These capabilities are sent in an
 * event sequence after the wp_tablet_seat.tool_added event before any
 * actual events from this tool. This initial event sequence is
 * terminated by a wp_tablet_tool.done event.
 *
 * Tablet tool events are grouped by wp_tablet_tool.frame events.
 * Any events received before a wp_tablet_tool.frame event should be
 * considered part of the same hardware state change.
 */
extern const struct wl_interface zwp_tablet_tool_v2_interface;
#endif
#ifndef ZWP_TABLET_V2_INTERFACE
#define ZWP_TABLET_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_v2 zwp_tablet_v2
 * @section page_iface_zwp_tablet_v2_desc Description
 *
 * The wp_tablet interface represents one graphics tablet device. The
 * tablet interface itself does not generate events; all events are
 * generated by wp_tablet_tool objects when in proximity above a tablet.
 *
 * A tablet has a number of static characteristics, e.g. device name and
 * pid/vid. These capabilities are sent in an event sequence after the
 * wp_tablet_seat.tablet_added event. This initial event sequence is
 * terminated by a wp_tablet.done event.
 * @section page_iface_zwp_tablet_v2_api API
 * See @ref iface_zwp_tablet_v2.
 */
/**
 * @defgroup iface_zwp_tablet_v2 The zwp_tablet_v2 interface
 *
 * The wp_tablet interface represents one graphics tablet device. The
 * tablet interface itself does not generate events; all events are
 * generated by wp_tablet_tool objects when in proximity above a tablet.
 *
 * A tablet has a number of static characteristics, e.g. device name and
 * pid/vid. These capabilities are sent in an event sequence after the
 * wp_tablet_seat.tablet_added event. This initial event sequence is
 * terminated by a wp_tablet.done event.
 */
extern const struct wl_interface zwp_tablet_v2_interface;
#endif
#ifndef ZWP_TABLET_PAD_RING_V2_INTERFACE
#define ZWP_TABLET_PAD_RING_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_pad_ring_v2 zwp_tablet_pad_ring_v2
 * @section page_iface_zwp_tablet_pad_ring_v2_desc Description
 *
 * A circular interaction area, such as the touch ring on the Wacom Intuos
 * Pro series tablets.
 *
 * Events on a ring are logically grouped by the wl_tablet_pad_ring.frame
 * event.
 * @section page_iface_zwp_tablet_pad_ring_v2_api API
 * See @ref iface_zwp_tablet_pad_ring_v2.
 */
/**
 * @defgroup iface_zwp_tablet_pad_ring_v2 The zwp_tablet_pad_ring_v2 interface
 *
 * A circular interaction area, such as the touch ring on the Wacom Intuos
 * Pro series tablets.
 *
 * Events on a ring are logically grouped by the wl_tablet_pad_ring.frame
 * event.
 */
extern const struct wl_interface zwp_tablet_pad_ring_v2_interface;
#endif
#ifndef ZWP_TABLET_PAD_STRIP_V2_INTERFACE
#define ZWP_TABLET_PAD_STRIP_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_pad_strip_v2 zwp_tablet_pad_strip_v2
 * @section page_iface_zwp_tablet_pad_strip_v2_desc Description
 *
 * A linear interaction area, such as the strips found in Wacom Cintiq
 * models.
 *
 * Events on a strip are logically grouped by the wl_tablet_pad_strip.frame
 * event.
 * @section page_iface_zwp_tablet_pad_strip_v2_api API
 * See @ref iface_zwp_tablet_pad_strip_v2.
 */
/**
 * @defgroup iface_zwp_tablet_pad_strip_v2 The zwp_tablet_pad_strip_v2 interface
 *
 * A linear interaction area, such as the strips found in Wacom Cintiq
 * models.
 *
 * Events on a strip are logically grouped by the wl_tablet_pad_strip.frame
 * event.
 */
extern const struct wl_interface zwp_tablet_pad_strip_v2_interface;
#endif
#ifndef ZWP_TABLET_PAD_GROUP_V2_INTERFACE
#define ZWP_TABLET_PAD_GROUP_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_pad_group_v2 zwp_tablet_pad_group_v2
 * @section page_iface_zwp_tablet_pad_group_v2_desc Description
 *
 * A pad group describes a distinct (sub)set of buttons, rings and strips
 * present in the tablet. The criteria of this grouping is usually positional,
 * eg. if a tablet has buttons on the left and right side, 2 groups will be
 * presented. The physical arrangement of groups is undisclosed and may
 * change on the fly.
 *
 * Pad groups will announce their features during pad initialization. Between
 * the corresponding wp_tablet_pad.group event and wp_tablet_pad_group.done, the
 * pad group will announce the buttons, rings and strips contained in it,
 * plus the number of supported modes.
 *
 * Modes are a mechanism to allow multiple groups of actions for every element
 * in the pad group. The number of groups and available modes in each is
 * persistent across device plugs. The current mode is user-switchable, it
 * will be announced through the wp_tablet_pad_group.mode_switch event both
 * whenever it is switched, and after wp_tablet_pad.enter.
 *
 * The current mode logically applies to all elements in the pad group,
 * although it is at clients' discretion whether to actually perform different
 * actions, and/or issue the respective .set_feedback requests to notify the
 * compositor. See the wp_tablet_pad_group.mode_switch event for more details.
 * @section page_iface_zwp_tablet_pad_group_v2_api API
 * See @ref iface_zwp_tablet_pad_group_v2.
 */
/**
 * @defgroup iface_zwp_tablet_pad_group_v2 The zwp_tablet_pad_group_v2 interface
 *
 * A pad group describes a distinct (sub)set of buttons, rings and strips
 * present in the tablet. The criteria of this grouping is usually positional,
 * eg. if a tablet has buttons on the left and right side, 2 groups will be
 * presented. The physical arrangement of groups is undisclosed and may
 * change on the fly.
 *
 * Pad groups will announce their features during pad initialization. Between
 * the corresponding wp_tablet_pad.group event and wp_tablet_pad_group.done, the
 * pad group will announce the buttons, rings and strips contained in it,
 * plus the number of supported modes.
 *
 * Modes are a mechanism to allow multiple groups of actions for every element
 * in the pad group. The number of groups and available modes in each is
 * persistent across device plugs. The current mode is user-switchable, it
 * will be announced through the wp_tablet_pad_group.mode_switch event both
 * whenever it is switched, and after wp_tablet_pad.enter.
 *
 * The current mode logically applies to all elements in the pad group,
 * although it is at clients' discretion whether to actually perform different
 * actions, and/or issue the respective .set_feedback requests to notify the
 * compositor. See the wp_tablet_pad_group.mode_switch event for more details.
 */
extern const struct wl_interface zwp_tablet_pad_group_v2_interface;
#endif
#ifndef ZWP_TABLET_PAD_V2_INTERFACE
#define ZWP_TABLET_PAD_V2_INTERFACE
/**
 * @page page_iface_zwp_tablet_pad_v2 zwp_tablet_pad_v2
 * @section page_iface_zwp_tablet_pad_v2_desc Description
 *
 * A pad device is a set of buttons, rings and strips
 * usually physically present on the tablet device itself. Some
 * exceptions exist where the pad device is physically detached, e.g. the
 * Wacom ExpressKey Remote.
 *
 * Pad devices have no axes that control the cursor and are generally
 * auxiliary devices to the tool devices used on the tablet surface.
 *
 * A pad device has a number of static characteristics, e.g. the number
 * of rings. These capabilities are sent in an event sequence after the
 * wp_tablet_seat.pad_added event before any actual events from this pad.
 * This initial event sequence is terminated by a wp_tablet_pad.done
 * event.
 *
 * All pad features (buttons, rings and strips) are logically divided into
 * groups and all pads have at least one group. The available groups are
 * notified through the wp_tablet_pad.group event; the compositor will
 * emit one event per group before emitting wp_tablet_pad.done.
 *
 * Groups may have multiple modes. Modes allow clients to map multiple
 * actions to a single pad feature. Only one mode can be active per group,
 * although different groups may have different active modes.
 * @section page_iface_zwp_tablet_pad_v2_api API
 * See @ref iface_zwp_tablet_pad_v2.
 */
/**
 * @defgroup iface_zwp_tablet_pad_v2 The zwp_tablet_pad_v2 interface
 *
 * A pad device is a set of buttons, rings and strips
 * usually physically present on the tablet device itself. Some
 * exceptions exist where the pad device is physically detached, e.g. the
 * Wacom ExpressKey Remote.
 *
 * Pad devices have no axes that control the cursor and are generally
 * auxiliary devices to the tool devices used on the tablet surface.
 *
 * A pad device has a number of static characteristics, e.g. the number
 * of rings. These capabilities are sent in an event sequence after the
 * wp_tablet_seat.pad_added event before any actual events from this pad.
 * This initial event sequence is terminated by a wp_tablet_pad.done
 * event.
 *
 * All pad features (buttons, rings and strips) are logically divided into
 * groups and all pads have at least one group. The available groups are
 * notified through the wp_tablet_pad.group event; the compositor will
 * emit one event per group before emitting wp_tablet_pad.done.
 *
 * Groups may have multiple modes. Modes allow clients to map multiple
 * actions to a single pad feature. Only one mode can be active per group,
 * although different groups may have different active modes.
 */
extern const struct wl_interface zwp_tablet_pad_v2_interface;
#endif

#define ZWP_TABLET_MANAGER_V2_GET_TABLET_SEAT 0
#define ZWP_TABLET_MANAGER_V2_DESTROY 1


/**
 * @ingroup iface_zwp_tablet_manager_v2
 */
#define ZWP_TABLET_MANAGER_V2_GET_TABLET_SEAT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_manager_v2
 */
#define ZWP_TABLET_MANAGER_V2_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwp_tablet_manager_v2 */
static inline void
zwp_tablet_manager_v2_set_user_data(struct zwp_tablet_manager_v2 *zwp_tablet_manager_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_tablet_manager_v2, user_data);
}

/** @ingroup iface_zwp_tablet_manager_v2 */
static inline void *
zwp_tablet_manager_v2_get_user_data(struct zwp_tablet_manager_v2 *zwp_tablet_manager_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_tablet_manager_v2);
}

static inline uint32_t
zwp_tablet_manager_v2_get_version(struct zwp_tablet_manager_v2 *zwp_tablet_manager_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_tablet_manager_v2);
}

/**
 * @ingroup iface_zwp_tablet_manager_v2
 *
 * Get the wp_tablet_seat object for the given seat. This object
 * provides access to all graphics tablets in this seat.
 */
static inline struct zwp_tablet_seat_v2 *
zwp_tablet_manager_v2_get_tablet_seat(struct zwp_tablet_manager_v2 *zwp_tablet_manager_v2, struct wl_seat *seat)
{
	struct wl_proxy *tablet_seat;

	tablet_seat = wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_manager_v2,
			 ZWP_TABLET_MANAGER_V2_GET_TABLET_SEAT, &zwp_tablet_seat_v2_interface, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_manager_v2), 0, NULL, seat);

	return (struct zwp_tablet_seat_v2 *) tablet_seat;
}

/**
 * @ingroup iface_zwp_tablet_manager_v2
 *
 * Destroy the wp_tablet_manager object. Objects created from this
 * object are unaffected and should be destroyed separately.
 */
static inline void
zwp_tablet_manager_v2_destroy(struct zwp_tablet_manager_v2 *zwp_tablet_manager_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_manager_v2,
			 ZWP_TABLET_MANAGER_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_manager_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zwp_tablet_seat_v2
 * @struct zwp_tablet_seat_v2_listener
 */
struct zwp_tablet_seat_v2_listener {
	/**
	 * new device notification
	 *
	 * This event is sent whenever a new tablet becomes available on
	 * this seat. This event only provides the object id of the tablet,
	 * any static information about the tablet (device name, vid/pid,
	 * etc.) is sent through the wp_tablet interface.
	 * @param id the newly added graphics tablet
	 */
	void (*tablet_added)(void *data,
			     struct zwp_tablet_seat_v2 *zwp_tablet_seat_v2,
			     struct zwp_tablet_v2 *id);
	/**
	 * a new tool has been used with a tablet
	 *
	 * This event is sent whenever a tool that has not previously
	 * been used with a tablet comes into use. This event only provides
	 * the object id of the tool; any static information about the tool
	 * (capabilities, type, etc.) is sent through the wp_tablet_tool
	 * interface.
	 * @param id the newly added tablet tool
	 */
	void (*tool_added)(void *data,
			   struct zwp_tablet_seat_v2 *zwp_tablet_seat_v2,
			   struct zwp_tablet_tool_v2 *id);
	/**
	 * new pad notification
	 *
	 * This event is sent whenever a new pad is known to the system.
	 * Typically, pads are physically attached to tablets and a
	 * pad_added event is sent immediately after the
	 * wp_tablet_seat.tablet_added. However, some standalone pad
	 * devices logically attach to tablets at runtime, and the client
	 * must wait for wp_tablet_pad.enter to know the tablet a pad is
	 * attached to.
	 *
	 * This event only provides the object id of the pad. All further
	 * features (buttons, strips, rings) are sent through the
	 * wp_tablet_pad interface.
	 * @param id the newly added pad
	 */
	void (*pad_added)(void *data,
			  struct zwp_tablet_seat_v2 *zwp_tablet_seat_v2,
			  struct zwp_tablet_pad_v2 *id);
};

/**
 * @ingroup iface_zwp_tablet_seat_v2
 */
static inline int
zwp_tablet_seat_v2_add_listener(struct zwp_tablet_seat_v2 *zwp_tablet_seat_v2,
				const struct zwp_tablet_seat_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_tablet_seat_v2,
				     (void (**)(void)) listener, data);
}

#define ZWP_TABLET_SEAT_V2_DESTROY 0

/**
 * @ingroup iface_zwp_tablet_seat_v2
 */
#define ZWP_TABLET_SEAT_V2_TABLET_ADDED_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_seat_v2
 */
#define ZWP_TABLET_SEAT_V2_TOOL_ADDED_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_seat_v2
 */
#define ZWP_TABLET_SEAT_V2_PAD_ADDED_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_seat_v2
 */
#define ZWP_TABLET_SEAT_V2_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwp_tablet_seat_v2 */
static inline void
zwp_tablet_seat_v2_set_user_data(struct zwp_tablet_seat_v2 *zwp_tablet_seat_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_tablet_seat_v2, user_data);
}

/** @ingroup iface_zwp_tablet_seat_v2 */
static inline void *
zwp_tablet_seat_v2_get_user_data(struct zwp_tablet_seat_v2 *zwp_tablet_seat_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_tablet_seat_v2);
}

static inline uint32_t
zwp_tablet_seat_v2_get_version(struct zwp_tablet_seat_v2 *zwp_tablet_seat_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_tablet_seat_v2);
}

/**
 * @ingroup iface_zwp_tablet_seat_v2
 *
 * Destroy the wp_tablet_seat object. Objects created from this
 * object are unaffected and should be destroyed separately.
 */
static inline void
zwp_tablet_seat_v2_destroy(struct zwp_tablet_seat_v2 *zwp_tablet_seat_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_seat_v2,
			 ZWP_TABLET_SEAT_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_seat_v2), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef ZWP_TABLET_TOOL_V2_TYPE_ENUM
#define ZWP_TABLET_TOOL_V2_TYPE_ENUM
/**
 * @ingroup iface_zwp_tablet_tool_v2
 * a physical tool type
 *
 * Describes the physical type of a tool. The physical type of a tool
 * generally defines its base usage.
 *
 * The mouse tool represents a mouse-shaped tool that is not a relative
 * device but bound to the tablet's surface, providing absolute
 * coordinates.
 *
 * The lens tool is a mouse-shaped tool with an attached lens to
 * provide precision focus.
 */
enum zwp_tablet_tool_v2_type {
	/**
	 * Pen
	 */
	ZWP_TABLET_TOOL_V2_TYPE_PEN = 0x140,
	/**
	 * Eraser
	 */
	ZWP_TABLET_TOOL_V2_TYPE_ERASER = 0x141,
	/**
	 * Brush
	 */
	ZWP_TABLET_TOOL_V2_TYPE_BRUSH = 0x142,
	/**
	 * Pencil
	 */
	ZWP_TABLET_TOOL_V2_TYPE_PENCIL = 0x143,
	/**
	 * Airbrush
	 */
	ZWP_TABLET_TOOL_V2_TYPE_AIRBRUSH = 0x144,
	/**
	 * Finger
	 */
	ZWP_TABLET_TOOL_V2_TYPE_FINGER = 0x145,
	/**
	 * Mouse
	 */
	ZWP_TABLET_TOOL_V2_TYPE_MOUSE = 0x146,
	/**
	 * Lens
	 */
	ZWP_TABLET_TOOL_V2_TYPE_LENS = 0x147,
};
#endif /* ZWP_TABLET_TOOL_V2_TYPE_ENUM */

#ifndef ZWP_TABLET_TOOL_V2_CAPABILITY_ENUM
#define ZWP_TABLET_TOOL_V2_CAPABILITY_ENUM
/**
 * @ingroup iface_zwp_tablet_tool_v2
 * capability flags for a tool
 *
 * Describes extra capabilities on a tablet.
 *
 * Any tool must provide x and y values, extra axes are
 * device-specific.
 */
enum zwp_tablet_tool_v2_capability {
	/**
	 * Tilt axes
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_TILT = 1,
	/**
	 * Pressure axis
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_PRESSURE = 2,
	/**
	 * Distance axis
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_DISTANCE = 3,
	/**
	 * Z-rotation axis
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_ROTATION = 4,
	/**
	 * Slider axis
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_SLIDER = 5,
	/**
	 * Wheel axis
	 */
	ZWP_TABLET_TOOL_V2_CAPABILITY_WHEEL = 6,
};
#endif /* ZWP_TABLET_TOOL_V2_CAPABILITY_ENUM */

#ifndef ZWP_TABLET_TOOL_V2_BUTTON_STATE_ENUM
#define ZWP_TABLET_TOOL_V2_BUTTON_STATE_ENUM
/**
 * @ingroup iface_zwp_tablet_tool_v2
 * physical button state
 *
 * Describes the physical state of a button that produced the button event.
 */
enum zwp_tablet_tool_v2_button_state {
	/**
	 * button is not pressed
	 */
	ZWP_TABLET_TOOL_V2_BUTTON_STATE_RELEASED = 0,
	/**
	 * button is pressed
	 */
	ZWP_TABLET_TOOL_V2_BUTTON_STATE_PRESSED = 1,
};
#endif /* ZWP_TABLET_TOOL_V2_BUTTON_STATE_ENUM */

#ifndef ZWP_TABLET_TOOL_V2_ERROR_ENUM
#define ZWP_TABLET_TOOL_V2_ERROR_ENUM
enum zwp_tablet_tool_v2_error {
	/**
	 * given wl_surface has another role
	 */
	ZWP_TABLET_TOOL_V2_ERROR_ROLE = 0,
};
#endif /* ZWP_TABLET_TOOL_V2_ERROR_ENUM */

/**
 * @ingroup iface_zwp_tablet_tool_v2
 * @struct zwp_tablet_tool_v2_listener
 */
struct zwp_tablet_tool_v2_listener {
	/**
	 * tool type
	 *
	 * The tool type is the high-level type of the tool and usually
	 * decides the interaction expected from this tool.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet_tool.done event.
	 * @param tool_type the physical tool type
	 */
	void (*type)(void *data,
		     struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
		     uint32_t tool_type);
	/**
	 * unique hardware serial number of the tool
	 *
	 * If the physical tool can be identified by a unique 64-bit
	 * serial number, this event notifies the client of this serial
	 * number.
	 *
	 * If multiple tablets are available in the same seat and the tool
	 * is uniquely identifiable by the serial number, that tool may
	 * move between tablets.
	 *
	 * Otherwise, if the tool has no serial number and this event is
	 * missing, the tool is tied to the tablet it first comes into
	 * proximity with. Even if the physical tool is used on multiple
	 * tablets, separate wp_tablet_tool objects will be created, one
	 * per tablet.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet_tool.done event.
	 * @param hardware_serial_hi the unique serial number of the tool, most significant bits
	 * @param hardware_serial_lo the unique serial number of the tool, least significant bits
	 */
	void (*hardware_serial)(void *data,
				struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
				uint32_t hardware_serial_hi,
				uint32_t hardware_serial_lo);
	/**
	 * hardware id notification in Wacom's format
	 *
	 * This event notifies the client of a hardware id available on
	 * this tool.
	 *
	 * The hardware id is a device-specific 64-bit id that provides
	 * extra information about the tool in use, beyond the wl_tool.type
	 * enumeration. The format of the id is specific to tablets made by
	 * Wacom Inc. For example, the hardware id of a Wacom Grip Pen (a
	 * stylus) is 0x802.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet_tool.done event.
	 * @param hardware_id_hi the hardware id, most significant bits
	 * @param hardware_id_lo the hardware id, least significant bits
	 */
	void (*hardware_id_wacom)(void *data,
				  struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
				  uint32_t hardware_id_hi,
				  uint32_t hardware_id_lo);
	/**
	 * tool capability notification
	 *
	 * This event notifies the client of any capabilities of this
	 * tool, beyond the main set of x/y axes and tip up/down detection.
	 *
	 * One event is sent for each extra capability available on this
	 * tool.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet_tool.done event.
	 * @param capability the capability
	 */
	void (*capability)(void *data,
			   struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
			   uint32_t capability);
	/**
	 * tool description events sequence complete
	 *
	 * This event signals the end of the initial burst of descriptive
	 * events. A client may consider the static description of the tool
	 * to be complete and finalize initialization of the tool.
	 */
	void (*done)(void *data,
		     struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2);
	/**
	 * tool removed
	 *
	 * This event is sent when the tool is removed from the system
	 * and will send no further events. Should the physical tool come
	 * back into proximity later, a new wp_tablet_tool object will be
	 * created.
	 *
	 * It is compositor-dependent when a tool is removed. A compositor
	 * may remove a tool on proximity out, tablet removal or any other
	 * reason. A compositor may also keep a tool alive until shutdown.
	 *
	 * If the tool is currently in proximity, a proximity_out event
	 * will be sent before the removed event. See
	 * wp_tablet_tool.proximity_out for the handling of any buttons
	 * logically down.
	 *
	 * When this event is received, the client must
	 * wp_tablet_tool.destroy the object.
	 */
	void (*removed)(void *data,
			struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2);
	/**
	 * proximity in event
	 *
	 * Notification that this tool is focused on a certain surface.
	 *
	 * This event can be received when the tool has moved from one
	 * surface to another, or when the tool has come back into
	 * proximity above the surface.
	 *
	 * If any button is logically down when the tool comes into
	 * proximity, the respective button event is sent after the
	 * proximity_in event but within the same frame as the proximity_in
	 * event.
	 * @param tablet The tablet the tool is in proximity of
	 * @param surface The current surface the tablet tool is over
	 */
	void (*proximity_in)(void *data,
			     struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
			     uint32_t serial,
			     struct zwp_tablet_v2 *tablet,
			     struct wl_surface *surface);
	/**
	 * proximity out event
	 *
	 * Notification that this tool has either left proximity, or is
	 * no longer focused on a certain surface.
	 *
	 * When the tablet tool leaves proximity of the tablet, button
	 * release events are sent for each button that was held down at
	 * the time of leaving proximity. These events are sent before the
	 * proximity_out event but within the same wp_tablet.frame.
	 *
	 * If the tool stays within proximity of the tablet, but the focus
	 * changes from one surface to another, a button release event may
	 * not be sent until the button is actually released or the tool
	 * leaves the proximity of the tablet.
	 */
	void (*proximity_out)(void *data,
			      struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2);
	/**
	 * tablet tool is making contact
	 *
	 * Sent whenever the tablet tool comes in contact with the
	 * surface of the tablet.
	 *
	 * If the tool is already in contact with the tablet when entering
	 * the input region, the client owning said region will receive a
	 * wp_tablet.proximity_in event, followed by a wp_tablet.down event
	 * and a wp_tablet.frame event.
	 *
	 * Note that this event describes logical contact, not physical
	 * contact. On some devices, a compositor may not consider a tool
	 * in logical contact until a minimum physical pressure threshold
	 * is exceeded.
	 */
	void (*down)(void *data,
		     struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
		     uint32_t serial);
	/**
	 * tablet tool is no longer making contact
	 *
	 * Sent whenever the tablet tool stops making contact with the
	 * surface of the tablet, or when the tablet tool moves out of the
	 * input region and the compositor grab (if any) is dismissed.
	 *
	 * If the tablet tool moves out of the input region while in
	 * contact with the surface of the tablet and the compositor does
	 * not have an ongoing grab on the surface, the client owning said
	 * region will receive a wp_tablet.up event, followed by a
	 * wp_tablet.proximity_out event and a wp_tablet.frame event. If
	 * the compositor has an ongoing grab on this device, this event
	 * sequence is sent whenever the grab is dismissed in the future.
	 *
	 * Note that this event describes logical contact, not physical
	 * contact. On some devices, a compositor may not consider a tool
	 * out of logical contact until physical pressure falls below a
	 * specific threshold.
	 */
	void (*up)(void *data,
		   struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2);
	/**
	 * motion event
	 *
	 * Sent whenever a tablet tool moves.
	 * @param x surface-local x coordinate
	 * @param y surface-local y coordinate
	 */
	void (*motion)(void *data,
		       struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
		       wl_fixed_t x,
		       wl_fixed_t y);
	/**
	 * pressure change event
	 *
	 * Sent whenever the pressure axis on a tool changes. The value
	 * of this event is normalized to a value between 0 and 65535.
	 *
	 * Note that pressure may be nonzero even when a tool is not in
	 * logical contact. See the down and up events for more details.
	 * @param pressure The current pressure value
	 */
	void (*pressure)(void *data,
			 struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
			 uint32_t pressure);
	/**
	 * distance change event
	 *
	 * Sent whenever the distance axis on a tool changes. The value
	 * of this event is normalized to a value between 0 and 65535.
	 *
	 * Note that distance may be nonzero even when a tool is not in
	 * logical contact. See the down and up events for more details.
	 * @param distance The current distance value
	 */
	void (*distance)(void *data,
			 struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
			 uint32_t distance);
	/**
	 * tilt change event
	 *
	 * Sent whenever one or both of the tilt axes on a tool change.
	 * Each tilt value is in degrees, relative to the z-axis of the
	 * tablet. The angle is positive when the top of a tool tilts along
	 * the positive x or y axis.
	 * @param tilt_x The current value of the X tilt axis
	 * @param tilt_y The current value of the Y tilt axis
	 */
	void (*tilt)(void *data,
		     struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
		     wl_fixed_t tilt_x,
		     wl_fixed_t tilt_y);
	/**
	 * z-rotation change event
	 *
	 * Sent whenever the z-rotation axis on the tool changes. The
	 * rotation value is in degrees clockwise from the tool's logical
	 * neutral position.
	 * @param degrees The current rotation of the Z axis
	 */
	void (*rotation)(void *data,
			 struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
			 wl_fixed_t degrees);
	/**
	 * Slider position change event
	 *
	 * Sent whenever the slider position on the tool changes. The
	 * value is normalized between -65535 and 65535, with 0 as the
	 * logical neutral position of the slider.
	 *
	 * The slider is available on e.g. the Wacom Airbrush tool.
	 * @param position The current position of slider
	 */
	void (*slider)(void *data,
		       struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
		       int32_t position);
	/**
	 * Wheel delta event
	 *
	 * Sent whenever the wheel on the tool emits an event. This event
	 * contains two values for the same axis change. The degrees value
	 * is in the same orientation as the wl_pointer.vertical_scroll
	 * axis. The clicks value is in discrete logical clicks of the
	 * mouse wheel. This value may be zero if the movement of the wheel
	 * was less than one logical click.
	 *
	 * Clients should choose either value and avoid mixing degrees and
	 * clicks. The compositor may accumulate values smaller than a
	 * logical click and emulate click events when a certain threshold
	 * is met. Thus, wl_tablet_tool.wheel events with non-zero clicks
	 * values may have different degrees values.
	 * @param degrees The wheel delta in degrees
	 * @param clicks The wheel delta in discrete clicks
	 */
	void (*wheel)(void *data,
		      struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
		      wl_fixed_t degrees,
		      int32_t clicks);
	/**
	 * button event
	 *
	 * Sent whenever a button on the tool is pressed or released.
	 *
	 * If a button is held down when the tool moves in or out of
	 * proximity, button events are generated by the compositor. See
	 * wp_tablet_tool.proximity_in and wp_tablet_tool.proximity_out for
	 * details.
	 * @param button The button whose state has changed
	 * @param state Whether the button was pressed or released
	 */
	void (*button)(void *data,
		       struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
		       uint32_t serial,
		       uint32_t button,
		       uint32_t state);
	/**
	 * frame event
	 *
	 * Marks the end of a series of axis and/or button updates from
	 * the tablet. The Wayland protocol requires axis updates to be
	 * sent sequentially, however all events within a frame should be
	 * considered one hardware event.
	 * @param time The time of the event with millisecond granularity
	 */
	void (*frame)(void *data,
		      struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
		      uint32_t time);
};

/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
static inline int
zwp_tablet_tool_v2_add_listener(struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2,
				const struct zwp_tablet_tool_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_tablet_tool_v2,
				     (void (**)(void)) listener, data);
}

#define ZWP_TABLET_TOOL_V2_SET_CURSOR 0
#define ZWP_TABLET_TOOL_V2_DESTROY 1

/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_HARDWARE_SERIAL_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_HARDWARE_ID_WACOM_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_CAPABILITY_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_REMOVED_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_PROXIMITY_IN_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_PROXIMITY_OUT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_DOWN_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_UP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_MOTION_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_PRESSURE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_DISTANCE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_TILT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_ROTATION_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_SLIDER_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_WHEEL_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_BUTTON_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_FRAME_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_SET_CURSOR_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_tool_v2
 */
#define ZWP_TABLET_TOOL_V2_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwp_tablet_tool_v2 */
static inline void
zwp_tablet_tool_v2_set_user_data(struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_tablet_tool_v2, user_data);
}

/** @ingroup iface_zwp_tablet_tool_v2 */
static inline void *
zwp_tablet_tool_v2_get_user_data(struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_tablet_tool_v2);
}

static inline uint32_t
zwp_tablet_tool_v2_get_version(struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_tablet_tool_v2);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 *
 * Sets the surface of the cursor used for this tool on the given
 * tablet. This request only takes effect if the tool is in proximity
 * of one of the requesting client's surfaces or the surface parameter
 * is the current pointer surface. If there was a previous surface set
 * with this request it is replaced. If surface is NULL, the cursor
 * image is hidden.
 *
 * The parameters hotspot_x and hotspot_y define the position of the
 * pointer surface relative to the pointer location. Its top-left corner
 * is always at (x, y) - (hotspot_x, hotspot_y), where (x, y) are the
 * coordinates of the pointer location, in surface-local coordinates.
 *
 * On surface.attach requests to the pointer surface, hotspot_x and
 * hotspot_y are decremented by the x and y parameters passed to the
 * request. Attach must be confirmed by wl_surface.commit as usual.
 *
 * The hotspot can also be updated by passing the currently set pointer
 * surface to this request with new values for hotspot_x and hotspot_y.
 *
 * The current and pending input regions of the wl_surface are cleared,
 * and wl_surface.set_input_region is ignored until the wl_surface is no
 * longer used as the cursor. When the use as a cursor ends, the current
 * and pending input regions become undefined, and the wl_surface is
 * unmapped.
 *
 * This request gives the surface the role of a wp_tablet_tool cursor. A
 * surface may only ever be used as the cursor surface for one
 * wp_tablet_tool. If the surface already has another role or has
 * previously been used as cursor surface for a different tool, a
 * protocol error is raised.
 */
static inline void
zwp_tablet_tool_v2_set_cursor(struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2, uint32_t serial, struct wl_surface *surface, int32_t hotspot_x, int32_t hotspot_y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_tool_v2,
			 ZWP_TABLET_TOOL_V2_SET_CURSOR, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_tool_v2), 0, serial, surface, hotspot_x, hotspot_y);
}

/**
 * @ingroup iface_zwp_tablet_tool_v2
 *
 * This destroys the client's resource for this tool object.
 */
static inline void
zwp_tablet_tool_v2_destroy(struct zwp_tablet_tool_v2 *zwp_tablet_tool_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_tool_v2,
			 ZWP_TABLET_TOOL_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_tool_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zwp_tablet_v2
 * @struct zwp_tablet_v2_listener
 */
struct zwp_tablet_v2_listener {
	/**
	 * tablet device name
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet.done event.
	 * @param name the device name
	 */
	void (*name)(void *data,
		     struct zwp_tablet_v2 *zwp_tablet_v2,
		     const char *name);
	/**
	 * tablet device USB vendor/product id
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet.done event.
	 * @param vid USB vendor id
	 * @param pid USB product id
	 */
	void (*id)(void *data,
		   struct zwp_tablet_v2 *zwp_tablet_v2,
		   uint32_t vid,
		   uint32_t pid);
	/**
	 * path to the device
	 *
	 * A system-specific device path that indicates which device is
	 * behind this wp_tablet. This information may be used to gather
	 * additional information about the device, e.g. through libwacom.
	 *
	 * A device may have more than one device path. If so, multiple
	 * wp_tablet.path events are sent. A device may be emulated and not
	 * have a device path, and in that case this event will not be
	 * sent.
	 *
	 * The format of the path is unspecified, it may be a device node,
	 * a sysfs path, or some other identifier. It is up to the client
	 * to identify the string provided.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet.done event.
	 * @param path path to local device
	 */
	void (*path)(void *data,
		     struct zwp_tablet_v2 *zwp_tablet_v2,
		     const char *path);
	/**
	 * tablet description events sequence complete
	 *
	 * This event is sent immediately to signal the end of the
	 * initial burst of descriptive events. A client may consider the
	 * static description of the tablet to be complete and finalize
	 * initialization of the tablet.
	 */
	void (*done)(void *data,
		     struct zwp_tablet_v2 *zwp_tablet_v2);
	/**
	 * tablet removed event
	 *
	 * Sent when the tablet has been removed from the system. When a
	 * tablet is removed, some tools may be removed.
	 *
	 * When this event is received, the client must wp_tablet.destroy
	 * the object.
	 */
	void (*removed)(void *data,
			struct zwp_tablet_v2 *zwp_tablet_v2);
};

/**
 * @ingroup iface_zwp_tablet_v2
 */
static inline int
zwp_tablet_v2_add_listener(struct zwp_tablet_v2 *zwp_tablet_v2,
			   const struct zwp_tablet_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_tablet_v2,
				     (void (**)(void)) listener, data);
}

#define ZWP_TABLET_V2_DESTROY 0

/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_ID_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_PATH_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_REMOVED_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_v2
 */
#define ZWP_TABLET_V2_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwp_tablet_v2 */
static inline void
zwp_tablet_v2_set_user_data(struct zwp_tablet_v2 *zwp_tablet_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_tablet_v2, user_data);
}

/** @ingroup iface_zwp_tablet_v2 */
static inline void *
zwp_tablet_v2_get_user_data(struct zwp_tablet_v2 *zwp_tablet_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_tablet_v2);
}

static inline uint32_t
zwp_tablet_v2_get_version(struct zwp_tablet_v2 *zwp_tablet_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_tablet_v2);
}

/**
 * @ingroup iface_zwp_tablet_v2
 *
 * This destroys the client's resource for this tablet object.
 */
static inline void
zwp_tablet_v2_destroy(struct zwp_tablet_v2 *zwp_tablet_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_v2,
			 ZWP_TABLET_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_v2), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef ZWP_TABLET_PAD_RING_V2_SOURCE_ENUM
#define ZWP_TABLET_PAD_RING_V2_SOURCE_ENUM
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 * ring axis source
 *
 * Describes the source types for ring events. This indicates to the
 * client how a ring event was physically generated; a client may
 * adjust the user interface accordingly. For example, events
 * from a "finger" source may trigger kinetic scrolling.
 */
enum zwp_tablet_pad_ring_v2_source {
	/**
	 * finger
	 */
	ZWP_TABLET_PAD_RING_V2_SOURCE_FINGER = 1,
};
#endif /* ZWP_TABLET_PAD_RING_V2_SOURCE_ENUM */

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 * @struct zwp_tablet_pad_ring_v2_listener
 */
struct zwp_tablet_pad_ring_v2_listener {
	/**
	 * ring event source
	 *
	 * Source information for ring events.
	 *
	 * This event does not occur on its own. It is sent before a
	 * wp_tablet_pad_ring.frame event and carries the source
	 * information for all events within that frame.
	 *
	 * The source specifies how this event was generated. If the source
	 * is wp_tablet_pad_ring.source.finger, a wp_tablet_pad_ring.stop
	 * event will be sent when the user lifts the finger off the
	 * device.
	 *
	 * This event is optional. If the source is unknown for an
	 * interaction, no event is sent.
	 * @param source the event source
	 */
	void (*source)(void *data,
		       struct zwp_tablet_pad_ring_v2 *zwp_tablet_pad_ring_v2,
		       uint32_t source);
	/**
	 * angle changed
	 *
	 * Sent whenever the angle on a ring changes.
	 *
	 * The angle is provided in degrees clockwise from the logical
	 * north of the ring in the pad's current rotation.
	 * @param degrees the current angle in degrees
	 */
	void (*angle)(void *data,
		      struct zwp_tablet_pad_ring_v2 *zwp_tablet_pad_ring_v2,
		      wl_fixed_t degrees);
	/**
	 * interaction stopped
	 *
	 * Stop notification for ring events.
	 *
	 * For some wp_tablet_pad_ring.source types, a
	 * wp_tablet_pad_ring.stop event is sent to notify a client that
	 * the interaction with the ring has terminated. This enables the
	 * client to implement kinetic scrolling. See the
	 * wp_tablet_pad_ring.source documentation for information on when
	 * this event may be generated.
	 *
	 * Any wp_tablet_pad_ring.angle events with the same source after
	 * this event should be considered as the start of a new
	 * interaction.
	 */
	void (*stop)(void *data,
		     struct zwp_tablet_pad_ring_v2 *zwp_tablet_pad_ring_v2);
	/**
	 * end of a ring event sequence
	 *
	 * Indicates the end of a set of ring events that logically
	 * belong together. A client is expected to accumulate the data in
	 * all events within the frame before proceeding.
	 *
	 * All wp_tablet_pad_ring events before a wp_tablet_pad_ring.frame
	 * event belong logically together. For example, on termination of
	 * a finger interaction on a ring the compositor will send a
	 * wp_tablet_pad_ring.source event, a wp_tablet_pad_ring.stop event
	 * and a wp_tablet_pad_ring.frame event.
	 *
	 * A wp_tablet_pad_ring.frame event is sent for every logical event
	 * group, even if the group only contains a single
	 * wp_tablet_pad_ring event. Specifically, a client may get a
	 * sequence: angle, frame, angle, frame, etc.
	 * @param time timestamp with millisecond granularity
	 */
	void (*frame)(void *data,
		      struct zwp_tablet_pad_ring_v2 *zwp_tablet_pad_ring_v2,
		      uint32_t time);
};

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
static inline int
zwp_tablet_pad_ring_v2_add_listener(struct zwp_tablet_pad_ring_v2 *zwp_tablet_pad_ring_v2,
				    const struct zwp_tablet_pad_ring_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_tablet_pad_ring_v2,
				     (void (**)(void)) listener, data);
}

#define ZWP_TABLET_PAD_RING_V2_SET_FEEDBACK 0
#define ZWP_TABLET_PAD_RING_V2_DESTROY 1

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_ANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_STOP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_FRAME_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_SET_FEEDBACK_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 */
#define ZWP_TABLET_PAD_RING_V2_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwp_tablet_pad_ring_v2 */
static inline void
zwp_tablet_pad_ring_v2_set_user_data(struct zwp_tablet_pad_ring_v2 *zwp_tablet_pad_ring_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_tablet_pad_ring_v2, user_data);
}

/** @ingroup iface_zwp_tablet_pad_ring_v2 */
static inline void *
zwp_tablet_pad_ring_v2_get_user_data(struct zwp_tablet_pad_ring_v2 *zwp_tablet_pad_ring_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_tablet_pad_ring_v2);
}

static inline uint32_t
zwp_tablet_pad_ring_v2_get_version(struct zwp_tablet_pad_ring_v2 *zwp_tablet_pad_ring_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_ring_v2);
}

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 *
 * Request that the compositor use the provided feedback string
 * associated with this ring. This request should be issued immediately
 * after a wp_tablet_pad_group.mode_switch event from the corresponding
 * group is received, or whenever the ring is mapped to a different
 * action. See wp_tablet_pad_group.mode_switch for more details.
 *
 * Clients are encouraged to provide context-aware descriptions for
 * the actions associated with the ring; compositors may use this
 * information to offer visual feedback about the button layout
 * (eg. on-screen displays).
 *
 * The provided string 'description' is a UTF-8 encoded string to be
 * associated with this ring, and is considered user-visible; general
 * internationalization rules apply.
 *
 * The serial argument will be that of the last
 * wp_tablet_pad_group.mode_switch event received for the group of this
 * ring. Requests providing other serials than the most recent one will be
 * ignored.
 */
static inline void
zwp_tablet_pad_ring_v2_set_feedback(struct zwp_tablet_pad_ring_v2 *zwp_tablet_pad_ring_v2, const char *description, uint32_t serial)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_pad_ring_v2,
			 ZWP_TABLET_PAD_RING_V2_SET_FEEDBACK, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_ring_v2), 0, description, serial);
}

/**
 * @ingroup iface_zwp_tablet_pad_ring_v2
 *
 * This destroys the client's resource for this ring object.
 */
static inline void
zwp_tablet_pad_ring_v2_destroy(struct zwp_tablet_pad_ring_v2 *zwp_tablet_pad_ring_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_pad_ring_v2,
			 ZWP_TABLET_PAD_RING_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_ring_v2), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef ZWP_TABLET_PAD_STRIP_V2_SOURCE_ENUM
#define ZWP_TABLET_PAD_STRIP_V2_SOURCE_ENUM
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 * strip axis source
 *
 * Describes the source types for strip events. This indicates to the
 * client how a strip event was physically generated; a client may
 * adjust the user interface accordingly. For example, events
 * from a "finger" source may trigger kinetic scrolling.
 */
enum zwp_tablet_pad_strip_v2_source {
	/**
	 * finger
	 */
	ZWP_TABLET_PAD_STRIP_V2_SOURCE_FINGER = 1,
};
#endif /* ZWP_TABLET_PAD_STRIP_V2_SOURCE_ENUM */

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 * @struct zwp_tablet_pad_strip_v2_listener
 */
struct zwp_tablet_pad_strip_v2_listener {
	/**
	 * strip event source
	 *
	 * Source information for strip events.
	 *
	 * This event does not occur on its own. It is sent before a
	 * wp_tablet_pad_strip.frame event and carries the source
	 * information for all events within that frame.
	 *
	 * The source specifies how this event was generated. If the source
	 * is wp_tablet_pad_strip.source.finger, a wp_tablet_pad_strip.stop
	 * event will be sent when the user lifts their finger off the
	 * device.
	 *
	 * This event is optional. If the source is unknown for an
	 * interaction, no event is sent.
	 * @param source the event source
	 */
	void (*source)(void *data,
		       struct zwp_tablet_pad_strip_v2 *zwp_tablet_pad_strip_v2,
		       uint32_t source);
	/**
	 * position changed
	 *
	 * Sent whenever the position on a strip changes.
	 *
	 * The position is normalized to a range of [0, 65535], the 0-value
	 * represents the top-most and/or left-most position of the strip
	 * in the pad's current rotation.
	 * @param position the current position
	 */
	void (*position)(void *data,
			 struct zwp_tablet_pad_strip_v2 *zwp_tablet_pad_strip_v2,
			 uint32_t position);
	/**
	 * interaction stopped
	 *
	 * Stop notification for strip events.
	 *
	 * For some wp_tablet_pad_strip.source types, a
	 * wp_tablet_pad_strip.stop event is sent to notify a client that
	 * the interaction with the strip has terminated. This enables the
	 * client to implement kinetic scrolling. See the
	 * wp_tablet_pad_strip.source documentation for information on when
	 * this event may be generated.
	 *
	 * Any wp_tablet_pad_strip.position events with the same source
	 * after this event should be considered as the start of a new
	 * interaction.
	 */
	void (*stop)(void *data,
		     struct zwp_tablet_pad_strip_v2 *zwp_tablet_pad_strip_v2);
	/**
	 * end of a strip event sequence
	 *
	 * Indicates the end of a set of events that represent one
	 * logical hardware strip event. A client is expected to accumulate
	 * the data in all events within the frame before proceeding.
	 *
	 * All wp_tablet_pad_strip events before a
	 * wp_tablet_pad_strip.frame event belong logically together. For
	 * example, on termination of a finger interaction on a strip the
	 * compositor will send a wp_tablet_pad_strip.source event, a
	 * wp_tablet_pad_strip.stop event and a wp_tablet_pad_strip.frame
	 * event.
	 *
	 * A wp_tablet_pad_strip.frame event is sent for every logical
	 * event group, even if the group only contains a single
	 * wp_tablet_pad_strip event. Specifically, a client may get a
	 * sequence: position, frame, position, frame, etc.
	 * @param time timestamp with millisecond granularity
	 */
	void (*frame)(void *data,
		      struct zwp_tablet_pad_strip_v2 *zwp_tablet_pad_strip_v2,
		      uint32_t time);
};

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
static inline int
zwp_tablet_pad_strip_v2_add_listener(struct zwp_tablet_pad_strip_v2 *zwp_tablet_pad_strip_v2,
				     const struct zwp_tablet_pad_strip_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_tablet_pad_strip_v2,
				     (void (**)(void)) listener, data);
}

#define ZWP_TABLET_PAD_STRIP_V2_SET_FEEDBACK 0
#define ZWP_TABLET_PAD_STRIP_V2_DESTROY 1

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_STOP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_FRAME_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_SET_FEEDBACK_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 */
#define ZWP_TABLET_PAD_STRIP_V2_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwp_tablet_pad_strip_v2 */
static inline void
zwp_tablet_pad_strip_v2_set_user_data(struct zwp_tablet_pad_strip_v2 *zwp_tablet_pad_strip_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_tablet_pad_strip_v2, user_data);
}

/** @ingroup iface_zwp_tablet_pad_strip_v2 */
static inline void *
zwp_tablet_pad_strip_v2_get_user_data(struct zwp_tablet_pad_strip_v2 *zwp_tablet_pad_strip_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_tablet_pad_strip_v2);
}

static inline uint32_t
zwp_tablet_pad_strip_v2_get_version(struct zwp_tablet_pad_strip_v2 *zwp_tablet_pad_strip_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_strip_v2);
}

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 *
 * Requests the compositor to use the provided feedback string
 * associated with this strip. This request should be issued immediately
 * after a wp_tablet_pad_group.mode_switch event from the corresponding
 * group is received, or whenever the strip is mapped to a different
 * action. See wp_tablet_pad_group.mode_switch for more details.
 *
 * Clients are encouraged to provide context-aware descriptions for
 * the actions associated with the strip, and compositors may use this
 * information to offer visual feedback about the button layout
 * (eg. on-screen displays).
 *
 * The provided string 'description' is a UTF-8 encoded string to be
 * associated with this ring, and is considered user-visible; general
 * internationalization rules apply.
 *
 * The serial argument will be that of the last
 * wp_tablet_pad_group.mode_switch event received for the group of this
 * strip. Requests providing other serials than the most recent one will be
 * ignored.
 */
static inline void
zwp_tablet_pad_strip_v2_set_feedback(struct zwp_tablet_pad_strip_v2 *zwp_tablet_pad_strip_v2, const char *description, uint32_t serial)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_pad_strip_v2,
			 ZWP_TABLET_PAD_STRIP_V2_SET_FEEDBACK, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_strip_v2), 0, description, serial);
}

/**
 * @ingroup iface_zwp_tablet_pad_strip_v2
 *
 * This destroys the client's resource for this strip object.
 */
static inline void
zwp_tablet_pad_strip_v2_destroy(struct zwp_tablet_pad_strip_v2 *zwp_tablet_pad_strip_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_pad_strip_v2,
			 ZWP_TABLET_PAD_STRIP_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_strip_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 * @struct zwp_tablet_pad_group_v2_listener
 */
struct zwp_tablet_pad_group_v2_listener {
	/**
	 * buttons announced
	 *
	 * Sent on wp_tablet_pad_group initialization to announce the
	 * available buttons in the group. Button indices start at 0, a
	 * button may only be in one group at a time.
	 *
	 * This event is first sent in the initial burst of events before
	 * the wp_tablet_pad_group.done event.
	 *
	 * Some buttons are reserved by the compositor. These buttons may
	 * not be assigned to any wp_tablet_pad_group. Compositors may
	 * broadcast this event in the case of changes to the mapping of
	 * these reserved buttons. If the compositor happens to reserve all
	 * buttons in a group, this event will be sent with an empty array.
	 * @param buttons buttons in this group
	 */
	void (*buttons)(void *data,
			struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2,
			struct wl_array *buttons);
	/**
	 * ring announced
	 *
	 * Sent on wp_tablet_pad_group initialization to announce
	 * available rings. One event is sent for each ring available on
	 * this pad group.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet_pad_group.done event.
	 */
	void (*ring)(void *data,
		     struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2,
		     struct zwp_tablet_pad_ring_v2 *ring);
	/**
	 * strip announced
	 *
	 * Sent on wp_tablet_pad initialization to announce available
	 * strips. One event is sent for each strip available on this pad
	 * group.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet_pad_group.done event.
	 */
	void (*strip)(void *data,
		      struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2,
		      struct zwp_tablet_pad_strip_v2 *strip);
	/**
	 * mode-switch ability announced
	 *
	 * Sent on wp_tablet_pad_group initialization to announce that
	 * the pad group may switch between modes. A client may use a mode
	 * to store a specific configuration for buttons, rings and strips
	 * and use the wl_tablet_pad_group.mode_switch event to toggle
	 * between these configurations. Mode indices start at 0.
	 *
	 * Switching modes is compositor-dependent. See the
	 * wp_tablet_pad_group.mode_switch event for more details.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet_pad_group.done event. This event is only sent when
	 * more than more than one mode is available.
	 * @param modes the number of modes
	 */
	void (*modes)(void *data,
		      struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2,
		      uint32_t modes);
	/**
	 * tablet group description events sequence complete
	 *
	 * This event is sent immediately to signal the end of the
	 * initial burst of descriptive events. A client may consider the
	 * static description of the tablet to be complete and finalize
	 * initialization of the tablet group.
	 */
	void (*done)(void *data,
		     struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2);
	/**
	 * mode switch event
	 *
	 * Notification that the mode was switched.
	 *
	 * A mode applies to all buttons, rings and strips in a group
	 * simultaneously, but a client is not required to assign different
	 * actions for each mode. For example, a client may have
	 * mode-specific button mappings but map the ring to vertical
	 * scrolling in all modes. Mode indices start at 0.
	 *
	 * Switching modes is compositor-dependent. The compositor may
	 * provide visual cues to the client about the mode, e.g. by
	 * toggling LEDs on the tablet device. Mode-switching may be
	 * software-controlled or controlled by one or more physical
	 * buttons. For example, on a Wacom Intuos Pro, the button inside
	 * the ring may be assigned to switch between modes.
	 *
	 * The compositor will also send this event after
	 * wp_tablet_pad.enter on each group in order to notify of the
	 * current mode. Groups that only feature one mode will use mode=0
	 * when emitting this event.
	 *
	 * If a button action in the new mode differs from the action in
	 * the previous mode, the client should immediately issue a
	 * wp_tablet_pad.set_feedback request for each changed button.
	 *
	 * If a ring or strip action in the new mode differs from the
	 * action in the previous mode, the client should immediately issue
	 * a wp_tablet_ring.set_feedback or wp_tablet_strip.set_feedback
	 * request for each changed ring or strip.
	 * @param time the time of the event with millisecond granularity
	 * @param mode the new mode of the pad
	 */
	void (*mode_switch)(void *data,
			    struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2,
			    uint32_t time,
			    uint32_t serial,
			    uint32_t mode);
};

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
static inline int
zwp_tablet_pad_group_v2_add_listener(struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2,
				     const struct zwp_tablet_pad_group_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_tablet_pad_group_v2,
				     (void (**)(void)) listener, data);
}

#define ZWP_TABLET_PAD_GROUP_V2_DESTROY 0

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_BUTTONS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_RING_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_STRIP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_MODES_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_MODE_SWITCH_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 */
#define ZWP_TABLET_PAD_GROUP_V2_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwp_tablet_pad_group_v2 */
static inline void
zwp_tablet_pad_group_v2_set_user_data(struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_tablet_pad_group_v2, user_data);
}

/** @ingroup iface_zwp_tablet_pad_group_v2 */
static inline void *
zwp_tablet_pad_group_v2_get_user_data(struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_tablet_pad_group_v2);
}

static inline uint32_t
zwp_tablet_pad_group_v2_get_version(struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_group_v2);
}

/**
 * @ingroup iface_zwp_tablet_pad_group_v2
 *
 * Destroy the wp_tablet_pad_group object. Objects created from this object
 * are unaffected and should be destroyed separately.
 */
static inline void
zwp_tablet_pad_group_v2_destroy(struct zwp_tablet_pad_group_v2 *zwp_tablet_pad_group_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_pad_group_v2,
			 ZWP_TABLET_PAD_GROUP_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_group_v2), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef ZWP_TABLET_PAD_V2_BUTTON_STATE_ENUM
#define ZWP_TABLET_PAD_V2_BUTTON_STATE_ENUM
/**
 * @ingroup iface_zwp_tablet_pad_v2
 * physical button state
 *
 * Describes the physical state of a button that caused the button
 * event.
 */
enum zwp_tablet_pad_v2_button_state {
	/**
	 * the button is not pressed
	 */
	ZWP_TABLET_PAD_V2_BUTTON_STATE_RELEASED = 0,
	/**
	 * the button is pressed
	 */
	ZWP_TABLET_PAD_V2_BUTTON_STATE_PRESSED = 1,
};
#endif /* ZWP_TABLET_PAD_V2_BUTTON_STATE_ENUM */

/**
 * @ingroup iface_zwp_tablet_pad_v2
 * @struct zwp_tablet_pad_v2_listener
 */
struct zwp_tablet_pad_v2_listener {
	/**
	 * group announced
	 *
	 * Sent on wp_tablet_pad initialization to announce available
	 * groups. One event is sent for each pad group available.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet_pad.done event. At least one group will be announced.
	 */
	void (*group)(void *data,
		      struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2,
		      struct zwp_tablet_pad_group_v2 *pad_group);
	/**
	 * path to the device
	 *
	 * A system-specific device path that indicates which device is
	 * behind this wp_tablet_pad. This information may be used to
	 * gather additional information about the device, e.g. through
	 * libwacom.
	 *
	 * The format of the path is unspecified, it may be a device node,
	 * a sysfs path, or some other identifier. It is up to the client
	 * to identify the string provided.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet_pad.done event.
	 * @param path path to local device
	 */
	void (*path)(void *data,
		     struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2,
		     const char *path);
	/**
	 * buttons announced
	 *
	 * Sent on wp_tablet_pad initialization to announce the available
	 * buttons.
	 *
	 * This event is sent in the initial burst of events before the
	 * wp_tablet_pad.done event. This event is only sent when at least
	 * one button is available.
	 * @param buttons the number of buttons
	 */
	void (*buttons)(void *data,
			struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2,
			uint32_t buttons);
	/**
	 * pad description event sequence complete
	 *
	 * This event signals the end of the initial burst of descriptive
	 * events. A client may consider the static description of the pad
	 * to be complete and finalize initialization of the pad.
	 */
	void (*done)(void *data,
		     struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2);
	/**
	 * physical button state
	 *
	 * Sent whenever the physical state of a button changes.
	 * @param time the time of the event with millisecond granularity
	 * @param button the index of the button that changed state
	 */
	void (*button)(void *data,
		       struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2,
		       uint32_t time,
		       uint32_t button,
		       uint32_t state);
	/**
	 * enter event
	 *
	 * Notification that this pad is focused on the specified
	 * surface.
	 * @param serial serial number of the enter event
	 * @param tablet the tablet the pad is attached to
	 * @param surface surface the pad is focused on
	 */
	void (*enter)(void *data,
		      struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2,
		      uint32_t serial,
		      struct zwp_tablet_v2 *tablet,
		      struct wl_surface *surface);
	/**
	 * leave event
	 *
	 * Notification that this pad is no longer focused on the
	 * specified surface.
	 * @param serial serial number of the leave event
	 * @param surface surface the pad is no longer focused on
	 */
	void (*leave)(void *data,
		      struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2,
		      uint32_t serial,
		      struct wl_surface *surface);
	/**
	 * pad removed event
	 *
	 * Sent when the pad has been removed from the system. When a
	 * tablet is removed its pad(s) will be removed too.
	 *
	 * When this event is received, the client must destroy all rings,
	 * strips and groups that were offered by this pad, and issue
	 * wp_tablet_pad.destroy the pad itself.
	 */
	void (*removed)(void *data,
			struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2);
};

/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
static inline int
zwp_tablet_pad_v2_add_listener(struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2,
			       const struct zwp_tablet_pad_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_tablet_pad_v2,
				     (void (**)(void)) listener, data);
}

#define ZWP_TABLET_PAD_V2_SET_FEEDBACK 0
#define ZWP_TABLET_PAD_V2_DESTROY 1

/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_GROUP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_PATH_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_BUTTONS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_BUTTON_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_REMOVED_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_SET_FEEDBACK_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_tablet_pad_v2
 */
#define ZWP_TABLET_PAD_V2_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwp_tablet_pad_v2 */
static inline void
zwp_tablet_pad_v2_set_user_data(struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_tablet_pad_v2, user_data);
}

/** @ingroup iface_zwp_tablet_pad_v2 */
static inline void *
zwp_tablet_pad_v2_get_user_data(struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_tablet_pad_v2);
}

static inline uint32_t
zwp_tablet_pad_v2_get_version(struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_v2);
}

/**
 * @ingroup iface_zwp_tablet_pad_v2
 *
 * Requests the compositor to use the provided feedback string
 * associated with this button. This request should be issued immediately
 * after a wp_tablet_pad_group.mode_switch event from the corresponding
 * group is received, or whenever a button is mapped to a different
 * action. See wp_tablet_pad_group.mode_switch for more details.
 *
 * Clients are encouraged to provide context-aware descriptions for
 * the actions associated with each button, and compositors may use
 * this information to offer visual feedback on the button layout
 * (e.g. on-screen displays).
 *
 * Button indices start at 0. Setting the feedback string on a button
 * that is reserved by the compositor (i.e. not belonging to any
 * wp_tablet_pad_group) does not generate an error but the compositor
 * is free to ignore the request.
 *
 * The provided string 'description' is a UTF-8 encoded string to be
 * associated with this ring, and is considered user-visible; general
 * internationalization rules apply.
 *
 * The serial argument will be that of the last
 * wp_tablet_pad_group.mode_switch event received for the group of this
 * button. Requests providing other serials than the most recent one will
 * be ignored.
 */
static inline void
zwp_tablet_pad_v2_set_feedback(struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2, uint32_t button, const char *description, uint32_t serial)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_pad_v2,
			 ZWP_TABLET_PAD_V2_SET_FEEDBACK, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_v2), 0, button, description, serial);
}

/**
 * @ingroup iface_zwp_tablet_pad_v2
 *
 * Destroy the wp_tablet_pad object. Objects created from this object
 * are unaffected and should be destroyed separately.
 */
static inline void
zwp_tablet_pad_v2_destroy(struct zwp_tablet_pad_v2 *zwp_tablet_pad_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_tablet_pad_v2,
			 ZWP_TABLET_PAD_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_tablet_pad_v2), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
