#ifndef XPARAMETERS_H   /* prevent circular inclusions */
#define XPARAMETERS_H   /* by using protection macros */

#define XPAR_XAXIPMON_NUM_INSTANCES 4

/* Definitions for peripheral PERF_MONITOR_DDR */
#define XPAR_PERF_MONITOR_DDR_COMPATIBLE xlnx,axi-perf-monitor
#define XPAR_PERF_MONITOR_DDR_BASEADDR 0xfd0b0000
#define XPAR_PERF_MONITOR_DDR_HIGHADDR 0xfd0bffff
#define XPAR_PERF_MONITOR_DDR_GLOBAL_COUNT_WIDTH 0x20
#define XPAR_PERF_MONITOR_DDR_METRICS_SAMPLE_COUNT_WIDTH 0x20
#define XPAR_PERF_MONITOR_DDR_ENABLE_EVENT_COUNT 0x1
#define XPAR_PERF_MONITOR_DDR_NUM_MONITOR_SLOTS 0x6
#define XPAR_PERF_MONITOR_DDR_NUM_OF_COUNTERS 0xa
#define XPAR_PERF_MONITOR_DDR_HAVE_SAMPLED_METRIC_CNT 0x1
#define XPAR_PERF_MONITOR_DDR_ENABLE_EVENT_LOG 0x0
#define XPAR_PERF_MONITOR_DDR_FIFO_AXIS_DEPTH 0x20
#define XPAR_PERF_MONITOR_DDR_FIFO_AXIS_TDATA_WIDTH 0x38
#define XPAR_PERF_MONITOR_DDR_FIFO_AXIS_TID_WIDTH 0x1
#define XPAR_PERF_MONITOR_DDR_METRIC_COUNT_SCALE 0x1
#define XPAR_PERF_MONITOR_DDR_ENABLE_ADVANCED 0x1
#define XPAR_PERF_MONITOR_DDR_ENABLE_PROFILE 0x0
#define XPAR_PERF_MONITOR_DDR_ENABLE_TRACE 0x0
#define XPAR_PERF_MONITOR_DDR_ENABLE_32_BIT_FILTER_ID 0x0
#define XPAR_PERF_MONITOR_DDR_INTERRUPTS 0x407b

/* Canonical definitions for peripheral PERF_MONITOR_DDR */
#define XPAR_XAXIPMON_0_BASEADDR 0xfd0b0000
#define XPAR_XAXIPMON_0_HIGHADDR 0xfd0bffff
#define XPAR_XAXIPMON_0_COMPATIBLE xlnx,axi-perf-monitor
#define XPAR_XAXIPMON_0_ENABLE_EVENT_COUNT 0x1
#define XPAR_XAXIPMON_0_ENABLE_EVENT_LOG 0x0
#define XPAR_XAXIPMON_0_ENABLE_ADVANCED 0x1
#define XPAR_XAXIPMON_0_ENABLE_PROFILE 0x0
#define XPAR_XAXIPMON_0_ENABLE_TRACE 0x0
#define XPAR_XAXIPMON_0_ENABLE_32_BIT_FILTER_ID 0x0
#define XPAR_XAXIPMON_0_FIFO_AXIS_DEPTH 0x20
#define XPAR_XAXIPMON_0_FIFO_AXIS_TDATA_WIDTH 0x38
#define XPAR_XAXIPMON_0_FIFO_AXIS_TID_WIDTH 0x1
#define XPAR_XAXIPMON_0_GLOBAL_COUNT_WIDTH 0x20
#define XPAR_XAXIPMON_0_HAVE_SAMPLED_METRIC_CNT 0x1
#define XPAR_XAXIPMON_0_INTERRUPTS 0x407b
#define XPAR_XAXIPMON_0_METRICS_SAMPLE_COUNT_WIDTH 0x20
#define XPAR_XAXIPMON_0_METRIC_COUNT_SCALE 0x1
#define XPAR_XAXIPMON_0_NUM_MONITOR_SLOTS 0x6
#define XPAR_XAXIPMON_0_NUM_OF_COUNTERS 0xa

/* Definitions for peripheral PERF_MONITOR_CCI */
#define XPAR_PERF_MONITOR_CCI_COMPATIBLE xlnx,axi-perf-monitor
#define XPAR_PERF_MONITOR_CCI_BASEADDR 0xfd490000
#define XPAR_PERF_MONITOR_CCI_HIGHADDR 0xfd49ffff
#define XPAR_PERF_MONITOR_CCI_GLOBAL_COUNT_WIDTH 0x20
#define XPAR_PERF_MONITOR_CCI_METRICS_SAMPLE_COUNT_WIDTH 0x20
#define XPAR_PERF_MONITOR_CCI_ENABLE_EVENT_COUNT 0x1
#define XPAR_PERF_MONITOR_CCI_NUM_MONITOR_SLOTS 0x1
#define XPAR_PERF_MONITOR_CCI_NUM_OF_COUNTERS 0x3
#define XPAR_PERF_MONITOR_CCI_HAVE_SAMPLED_METRIC_CNT 0x1
#define XPAR_PERF_MONITOR_CCI_ENABLE_EVENT_LOG 0x0
#define XPAR_PERF_MONITOR_CCI_FIFO_AXIS_DEPTH 0x20
#define XPAR_PERF_MONITOR_CCI_FIFO_AXIS_TDATA_WIDTH 0x38
#define XPAR_PERF_MONITOR_CCI_FIFO_AXIS_TID_WIDTH 0x1
#define XPAR_PERF_MONITOR_CCI_METRIC_COUNT_SCALE 0x1
#define XPAR_PERF_MONITOR_CCI_ENABLE_ADVANCED 0x1
#define XPAR_PERF_MONITOR_CCI_ENABLE_PROFILE 0x0
#define XPAR_PERF_MONITOR_CCI_ENABLE_TRACE 0x0
#define XPAR_PERF_MONITOR_CCI_ENABLE_32_BIT_FILTER_ID 0x0
#define XPAR_PERF_MONITOR_CCI_INTERRUPTS 0x407b

/* Canonical definitions for peripheral PERF_MONITOR_CCI */
#define XPAR_XAXIPMON_1_BASEADDR 0xfd490000
#define XPAR_XAXIPMON_1_HIGHADDR 0xfd49ffff
#define XPAR_XAXIPMON_1_COMPATIBLE xlnx,axi-perf-monitor
#define XPAR_XAXIPMON_1_ENABLE_EVENT_COUNT 0x1
#define XPAR_XAXIPMON_1_ENABLE_EVENT_LOG 0x0
#define XPAR_XAXIPMON_1_ENABLE_ADVANCED 0x1
#define XPAR_XAXIPMON_1_ENABLE_PROFILE 0x0
#define XPAR_XAXIPMON_1_ENABLE_TRACE 0x0
#define XPAR_XAXIPMON_1_ENABLE_32_BIT_FILTER_ID 0x0
#define XPAR_XAXIPMON_1_FIFO_AXIS_DEPTH 0x20
#define XPAR_XAXIPMON_1_FIFO_AXIS_TDATA_WIDTH 0x38
#define XPAR_XAXIPMON_1_FIFO_AXIS_TID_WIDTH 0x1
#define XPAR_XAXIPMON_1_GLOBAL_COUNT_WIDTH 0x20
#define XPAR_XAXIPMON_1_HAVE_SAMPLED_METRIC_CNT 0x1
#define XPAR_XAXIPMON_1_INTERRUPTS 0x407b
#define XPAR_XAXIPMON_1_METRICS_SAMPLE_COUNT_WIDTH 0x20
#define XPAR_XAXIPMON_1_METRIC_COUNT_SCALE 0x1
#define XPAR_XAXIPMON_1_NUM_MONITOR_SLOTS 0x1
#define XPAR_XAXIPMON_1_NUM_OF_COUNTERS 0x3

/* Definitions for peripheral PERF_MONITOR_OCM */
#define XPAR_PERF_MONITOR_OCM_COMPATIBLE xlnx,axi-perf-monitor
#define XPAR_PERF_MONITOR_OCM_BASEADDR 0xffa00000
#define XPAR_PERF_MONITOR_OCM_HIGHADDR 0xffa0ffff
#define XPAR_PERF_MONITOR_OCM_GLOBAL_COUNT_WIDTH 0x20
#define XPAR_PERF_MONITOR_OCM_METRICS_SAMPLE_COUNT_WIDTH 0x20
#define XPAR_PERF_MONITOR_OCM_ENABLE_EVENT_COUNT 0x1
#define XPAR_PERF_MONITOR_OCM_NUM_MONITOR_SLOTS 0x1
#define XPAR_PERF_MONITOR_OCM_NUM_OF_COUNTERS 0x3
#define XPAR_PERF_MONITOR_OCM_HAVE_SAMPLED_METRIC_CNT 0x1
#define XPAR_PERF_MONITOR_OCM_ENABLE_EVENT_LOG 0x0
#define XPAR_PERF_MONITOR_OCM_FIFO_AXIS_DEPTH 0x20
#define XPAR_PERF_MONITOR_OCM_FIFO_AXIS_TDATA_WIDTH 0x38
#define XPAR_PERF_MONITOR_OCM_FIFO_AXIS_TID_WIDTH 0x1
#define XPAR_PERF_MONITOR_OCM_METRIC_COUNT_SCALE 0x1
#define XPAR_PERF_MONITOR_OCM_ENABLE_ADVANCED 0x1
#define XPAR_PERF_MONITOR_OCM_ENABLE_PROFILE 0x0
#define XPAR_PERF_MONITOR_OCM_ENABLE_TRACE 0x0
#define XPAR_PERF_MONITOR_OCM_ENABLE_32_BIT_FILTER_ID 0x0
#define XPAR_PERF_MONITOR_OCM_INTERRUPTS 0x4019

/* Canonical definitions for peripheral PERF_MONITOR_OCM */
#define XPAR_XAXIPMON_2_BASEADDR 0xffa00000
#define XPAR_XAXIPMON_2_HIGHADDR 0xffa0ffff
#define XPAR_XAXIPMON_2_COMPATIBLE xlnx,axi-perf-monitor
#define XPAR_XAXIPMON_2_ENABLE_EVENT_COUNT 0x1
#define XPAR_XAXIPMON_2_ENABLE_EVENT_LOG 0x0
#define XPAR_XAXIPMON_2_ENABLE_ADVANCED 0x1
#define XPAR_XAXIPMON_2_ENABLE_PROFILE 0x0
#define XPAR_XAXIPMON_2_ENABLE_TRACE 0x0
#define XPAR_XAXIPMON_2_ENABLE_32_BIT_FILTER_ID 0x0
#define XPAR_XAXIPMON_2_FIFO_AXIS_DEPTH 0x20
#define XPAR_XAXIPMON_2_FIFO_AXIS_TDATA_WIDTH 0x38
#define XPAR_XAXIPMON_2_FIFO_AXIS_TID_WIDTH 0x1
#define XPAR_XAXIPMON_2_GLOBAL_COUNT_WIDTH 0x20
#define XPAR_XAXIPMON_2_HAVE_SAMPLED_METRIC_CNT 0x1
#define XPAR_XAXIPMON_2_INTERRUPTS 0x4019
#define XPAR_XAXIPMON_2_METRICS_SAMPLE_COUNT_WIDTH 0x20
#define XPAR_XAXIPMON_2_METRIC_COUNT_SCALE 0x1
#define XPAR_XAXIPMON_2_NUM_MONITOR_SLOTS 0x1
#define XPAR_XAXIPMON_2_NUM_OF_COUNTERS 0x3

/* Definitions for peripheral PERF_MONITOR_LPD */
#define XPAR_PERF_MONITOR_LPD_COMPATIBLE xlnx,axi-perf-monitor
#define XPAR_PERF_MONITOR_LPD_BASEADDR 0xffa10000
#define XPAR_PERF_MONITOR_LPD_HIGHADDR 0xffa1ffff
#define XPAR_PERF_MONITOR_LPD_GLOBAL_COUNT_WIDTH 0x20
#define XPAR_PERF_MONITOR_LPD_METRICS_SAMPLE_COUNT_WIDTH 0x20
#define XPAR_PERF_MONITOR_LPD_ENABLE_EVENT_COUNT 0x1
#define XPAR_PERF_MONITOR_LPD_NUM_MONITOR_SLOTS 0x1
#define XPAR_PERF_MONITOR_LPD_NUM_OF_COUNTERS 0x3
#define XPAR_PERF_MONITOR_LPD_HAVE_SAMPLED_METRIC_CNT 0x1
#define XPAR_PERF_MONITOR_LPD_ENABLE_EVENT_LOG 0x0
#define XPAR_PERF_MONITOR_LPD_FIFO_AXIS_DEPTH 0x20
#define XPAR_PERF_MONITOR_LPD_FIFO_AXIS_TDATA_WIDTH 0x38
#define XPAR_PERF_MONITOR_LPD_FIFO_AXIS_TID_WIDTH 0x1
#define XPAR_PERF_MONITOR_LPD_METRIC_COUNT_SCALE 0x1
#define XPAR_PERF_MONITOR_LPD_ENABLE_ADVANCED 0x1
#define XPAR_PERF_MONITOR_LPD_ENABLE_PROFILE 0x0
#define XPAR_PERF_MONITOR_LPD_ENABLE_TRACE 0x0
#define XPAR_PERF_MONITOR_LPD_ENABLE_32_BIT_FILTER_ID 0x0
#define XPAR_PERF_MONITOR_LPD_INTERRUPTS 0x4019

/* Canonical definitions for peripheral PERF_MONITOR_LPD */
#define XPAR_XAXIPMON_3_BASEADDR 0xffa10000
#define XPAR_XAXIPMON_3_HIGHADDR 0xffa1ffff
#define XPAR_XAXIPMON_3_COMPATIBLE xlnx,axi-perf-monitor
#define XPAR_XAXIPMON_3_ENABLE_EVENT_COUNT 0x1
#define XPAR_XAXIPMON_3_ENABLE_EVENT_LOG 0x0
#define XPAR_XAXIPMON_3_ENABLE_ADVANCED 0x1
#define XPAR_XAXIPMON_3_ENABLE_PROFILE 0x0
#define XPAR_XAXIPMON_3_ENABLE_TRACE 0x0
#define XPAR_XAXIPMON_3_ENABLE_32_BIT_FILTER_ID 0x0
#define XPAR_XAXIPMON_3_FIFO_AXIS_DEPTH 0x20
#define XPAR_XAXIPMON_3_FIFO_AXIS_TDATA_WIDTH 0x38
#define XPAR_XAXIPMON_3_FIFO_AXIS_TID_WIDTH 0x1
#define XPAR_XAXIPMON_3_GLOBAL_COUNT_WIDTH 0x20
#define XPAR_XAXIPMON_3_HAVE_SAMPLED_METRIC_CNT 0x1
#define XPAR_XAXIPMON_3_INTERRUPTS 0x4019
#define XPAR_XAXIPMON_3_METRICS_SAMPLE_COUNT_WIDTH 0x20
#define XPAR_XAXIPMON_3_METRIC_COUNT_SCALE 0x1
#define XPAR_XAXIPMON_3_NUM_MONITOR_SLOTS 0x1
#define XPAR_XAXIPMON_3_NUM_OF_COUNTERS 0x3

#define XPAR_XCANPS_NUM_INSTANCES 1

/* Definitions for peripheral CAN1 */
#define XPAR_CAN1_COMPATIBLE xlnx,zynq-can-1.0
#define XPAR_CAN1_BASEADDR 0xff070000
#define XPAR_CAN1_HIGHADDR 0xff070fff
#define XPAR_CAN1_INTERRUPTS 0x4018

/* Canonical definitions for peripheral CAN1 */
#define XPAR_XCANPS_0_BASEADDR 0xff070000
#define XPAR_XCANPS_0_HIGHADDR 0xff070fff
#define XPAR_XCANPS_0_COMPATIBLE xlnx,zynq-can-1.0
#define XPAR_XCANPS_0_INTERRUPTS 0x4018

#define XPAR_XCSUDMA_NUM_INSTANCES 1

/* Definitions for peripheral CSUDMA_0 */
#define XPAR_CSUDMA_0_COMPATIBLE xlnx,zynqmp-csudma-1.0
#define XPAR_CSUDMA_0_BASEADDR 0xffc80000
#define XPAR_CSUDMA_0_HIGHADDR 0xffcbffff
#define XPAR_CSUDMA_0_DMA_TYPE 0x0
#define XPAR_CSUDMA_0_INTERRUPTS 0x4056

/* Canonical definitions for peripheral CSUDMA_0 */
#define XPAR_XCSUDMA_0_BASEADDR 0xffc80000
#define XPAR_XCSUDMA_0_HIGHADDR 0xffcbffff
#define XPAR_XCSUDMA_0_COMPATIBLE xlnx,zynqmp-csudma-1.0
#define XPAR_XCSUDMA_0_DMA_TYPE 0x0
#define XPAR_XCSUDMA_0_INTERRUPTS 0x4056

#define XPAR_XDDRCPSU_NUM_INSTANCES 1

/* Definitions for peripheral MC */
#define XPAR_MC_COMPATIBLE xlnx,zynqmp-ddrc-2.40a
#define XPAR_MC_BASEADDR 0xfd070000
#define XPAR_MC_HIGHADDR 0xfd09ffff
#define XPAR_MC_HAS_ECC 0x0
#define XPAR_MC_DDRC_CLK_FREQ_HZ 0x1fc9351d
#define XPAR_MC_ADDR_MAPPING 0x0
#define XPAR_MC_DDR_FREQ 0x3f926a3a
#define XPAR_MC_VIDEO_BUF_SIZE 0x0
#define XPAR_MC_BRC_MAPPING 0x0
#define XPAR_MC_DDRC_DYNAMIC_DDR_CONFIG_ENABLED 0x1
#define XPAR_MC_DDRC_MEMORY_TYPE 0x4
#define XPAR_MC_DDRC_MEMORY_ADDRESS_MAP 0x0
#define XPAR_MC_DDRC_DATA_MASK_AND_DBI 0x7
#define XPAR_MC_DDRC_ADDRESS_MIRRORING 0x0
#define XPAR_MC_DDRC_2ND_CLOCK 0x0
#define XPAR_MC_DDRC_PARITY 0x0
#define XPAR_MC_DDRC_POWER_DOWN_ENABLE 0x0
#define XPAR_MC_DDRC_CLOCK_STOP 0x0
#define XPAR_MC_DDRC_LOW_POWER_AUTO_SELF_REFRESH 0x0
#define XPAR_MC_DDRC_TEMP_CONTROLLED_REFRESH 0x0
#define XPAR_MC_DDRC_FINE_GRANULARITY_REFRESH_MODE 0x0
#define XPAR_MC_DDRC_SELF_REFRESH_ABORT 0x0
#define XPAR_MC_DDRC_MAX_OPERATING_TEMPARATURE 0x0

/* Canonical definitions for peripheral MC */
#define XPAR_XDDRCPSU_0_BASEADDR 0xfd070000
#define XPAR_XDDRCPSU_0_HIGHADDR 0xfd09ffff
#define XPAR_XDDRCPSU_0_ADDR_MAPPING 0x0
#define XPAR_XDDRCPSU_0_BRC_MAPPING 0x0
#define XPAR_XDDRCPSU_0_COMPATIBLE xlnx,zynqmp-ddrc-2.40a
#define XPAR_XDDRCPSU_0_DDRC_CLK_FREQ_HZ 0x1fc9351d
#define XPAR_XDDRCPSU_0_DDR_FREQ 0x3f926a3a
#define XPAR_XDDRCPSU_0_DDRC_DYNAMIC_DDR_CONFIG_ENABLED 0x1
#define XPAR_XDDRCPSU_0_DDRC_MEMORY_TYPE 0x4
#define XPAR_XDDRCPSU_0_DDRC_MEMORY_ADDRESS_MAP 0x0
#define XPAR_XDDRCPSU_0_DDRC_DATA_MASK_AND_DBI 0x7
#define XPAR_XDDRCPSU_0_DDRC_ADDRESS_MIRRORING 0x0
#define XPAR_XDDRCPSU_0_DDRC_2ND_CLOCK 0x0
#define XPAR_XDDRCPSU_0_DDRC_PARITY 0x0
#define XPAR_XDDRCPSU_0_DDRC_POWER_DOWN_ENABLE 0x0
#define XPAR_XDDRCPSU_0_DDRC_CLOCK_STOP 0x0
#define XPAR_XDDRCPSU_0_DDRC_LOW_POWER_AUTO_SELF_REFRESH 0x0
#define XPAR_XDDRCPSU_0_DDRC_TEMP_CONTROLLED_REFRESH 0x0
#define XPAR_XDDRCPSU_0_DDRC_FINE_GRANULARITY_REFRESH_MODE 0x0
#define XPAR_XDDRCPSU_0_DDRC_SELF_REFRESH_ABORT 0x0
#define XPAR_XDDRCPSU_0_DDRC_MAX_OPERATING_TEMPARATURE 0x0
#define XPAR_XDDRCPSU_0_HAS_ECC 0x0
#define XPAR_XDDRCPSU_0_VIDEO_BUF_SIZE 0x0

#define XPAR_XDPPSU_NUM_INSTANCES 1

/* Definitions for peripheral ZYNQMP_DPSUB */
#define XPAR_ZYNQMP_DPSUB_COMPATIBLE xlnx,zynqmp-dpsub-1.7
#define XPAR_ZYNQMP_DPSUB_BASEADDR 0xfd4a0000
#define XPAR_ZYNQMP_DPSUB_HIGHADDR 0xfd4a0fff
#define XPAR_ZYNQMP_DPSUB_CLOCK_FREQ 0x0

/* Canonical definitions for peripheral ZYNQMP_DPSUB */
#define XPAR_XDPPSU_0_BASEADDR 0xfd4a0000
#define XPAR_XDPPSU_0_HIGHADDR 0xfd4a0fff
#define XPAR_XDPPSU_0_COMPATIBLE xlnx,zynqmp-dpsub-1.7
#define XPAR_XDPPSU_0_CLOCK_FREQ 0x0

#define XPAR_XEMACPS_NUM_INSTANCES 1

/* Definitions for peripheral GEM3 */
#define XPAR_GEM3_COMPATIBLE xlnx,zynqmp-gem
#define XPAR_GEM3_BASEADDR 0xff0e0000
#define XPAR_GEM3_HIGHADDR 0xff0e0fff
#define XPAR_GEM3_DMA_COHERENT 0x0
#define XPAR_GEM3_INTERRUPTS 0x403f
#define XPAR_GEM3_REF_CLK 0x0

/* Canonical definitions for peripheral GEM3 */
#define XPAR_XEMACPS_0_BASEADDR 0xff0e0000
#define XPAR_XEMACPS_0_HIGHADDR 0xff0e0fff
#define XPAR_XEMACPS_0_COMPATIBLE xlnx,zynqmp-gem
#define XPAR_XEMACPS_0_DMA_COHERENT 0x0
#define XPAR_XEMACPS_0_INTERRUPTS 0x403f
#define XPAR_XEMACPS_0_REF_CLK 0x0

#define XPAR_XGPIOPS_NUM_INSTANCES 1

/* Definitions for peripheral GPIO */
#define XPAR_GPIO_COMPATIBLE xlnx,zynqmp-gpio-1.0
#define XPAR_GPIO_BASEADDR 0xff0a0000
#define XPAR_GPIO_HIGHADDR 0xff0a0fff
#define XPAR_GPIO_INTERRUPTS 0x4010

/* Canonical definitions for peripheral GPIO */
#define XPAR_XGPIOPS_0_BASEADDR 0xff0a0000
#define XPAR_XGPIOPS_0_HIGHADDR 0xff0a0fff
#define XPAR_XGPIOPS_0_COMPATIBLE xlnx,zynqmp-gpio-1.0
#define XPAR_XGPIOPS_0_INTERRUPTS 0x4010

#define XPAR_XIICPS_NUM_INSTANCES 2

/* Definitions for peripheral I2C0 */
#define XPAR_I2C0_COMPATIBLE cdns,i2c-r1p14
#define XPAR_I2C0_BASEADDR 0xff020000
#define XPAR_I2C0_HIGHADDR 0xff020fff
#define XPAR_I2C0_CLOCK_FREQ 0x5f5b9f5
#define XPAR_I2C0_INTERRUPTS 0x4011
#define XPAR_I2C0_REF_CLK 0x0

/* Canonical definitions for peripheral I2C0 */
#define XPAR_XIICPS_0_BASEADDR 0xff020000
#define XPAR_XIICPS_0_HIGHADDR 0xff020fff
#define XPAR_XIICPS_0_COMPATIBLE cdns,i2c-r1p14
#define XPAR_XIICPS_0_CLOCK_FREQ 0x5f5b9f5
#define XPAR_XIICPS_0_INTERRUPTS 0x4011
#define XPAR_XIICPS_0_REF_CLK 0x0

/* Definitions for peripheral I2C1 */
#define XPAR_I2C1_COMPATIBLE cdns,i2c-r1p14
#define XPAR_I2C1_BASEADDR 0xff030000
#define XPAR_I2C1_HIGHADDR 0xff030fff
#define XPAR_I2C1_CLOCK_FREQ 0x5f5b9f5
#define XPAR_I2C1_INTERRUPTS 0x4012
#define XPAR_I2C1_REF_CLK 0x0

/* Canonical definitions for peripheral I2C1 */
#define XPAR_XIICPS_1_BASEADDR 0xff030000
#define XPAR_XIICPS_1_HIGHADDR 0xff030fff
#define XPAR_XIICPS_1_COMPATIBLE cdns,i2c-r1p14
#define XPAR_XIICPS_1_CLOCK_FREQ 0x5f5b9f5
#define XPAR_XIICPS_1_INTERRUPTS 0x4012
#define XPAR_XIICPS_1_REF_CLK 0x0

#define XPAR_XINTC_NUM_INSTANCES 1

/* Definitions for peripheral AXI_INTC_0 */
#define XPAR_AXI_INTC_0_COMPATIBLE xlnx,axi-intc-4.1
#define XPAR_AXI_INTC_0_BASEADDR 0x80020000
#define XPAR_AXI_INTC_0_HIGHADDR 0x80020fff
#define XPAR_AXI_INTC_0_KIND_OF_INTR 0x1
#define XPAR_AXI_INTC_0_IS_FAST 0x0
#define XPAR_AXI_INTC_0_IVAR_RST_VAL 0x10
#define XPAR_AXI_INTC_0_NUM_INTR_INPUTS 0x1
#define XPAR_AXI_INTC_0_ADDR_WIDTH 0x20
#define XPAR_AXI_INTC_0_OPTIONS 0x0
#define XPAR_AXI_INTC_0_INTCTYPE 0x0
#define XPAR_AXI_INTC_0_INTERRUPTS 0x4059
#define XPAR_AXI_INTC_0_HANDLER_TABLE 0x0

/* Canonical definitions for peripheral AXI_INTC_0 */
#define XPAR_XINTC_0_BASEADDR 0x80020000
#define XPAR_XINTC_0_HIGHADDR 0x80020fff
#define XPAR_XINTC_0_HANDLER_TABLE 0x0
#define XPAR_XINTC_0_ADDR_WIDTH 0x20
#define XPAR_XINTC_0_COMPATIBLE xlnx,axi-intc-4.1
#define XPAR_XINTC_0_IS_FAST 0x0
#define XPAR_XINTC_0_IVAR_RST_VAL 0x10
#define XPAR_XINTC_0_INTCTYPE 0x0
#define XPAR_XINTC_0_INTERRUPTS 0x4059
#define XPAR_XINTC_0_KIND_OF_INTR 0x1
#define XPAR_XINTC_0_NUM_INTR_INPUTS 0x1
#define XPAR_XINTC_0_OPTIONS 0x0

#define XPAR_XIPIPSU_NUM_INSTANCES 4

/* Definitions for peripheral IPI3 */
#define XPAR_IPI3_COMPATIBLE xlnx,zynqmp-ipi-mailbox
#define XPAR_IPI3_BASEADDR 0xff330000
#define XPAR_IPI3_HIGHADDR 0xff33001f
#define XPAR_IPI3_IPI_BITMASK 0x10000
#define XPAR_IPI3_IPI_BUF_INDEX 0x7
#define XPAR_IPI3_IPI_TARGET_COUNT 0x7
#define XPAR_IPI3_0_IPI_BITMASK 0x1
#define XPAR_IPI3_0_IPI_BUF_INDEX 0x2
#define XPAR_IPI3_1_IPI_BITMASK 0x100
#define XPAR_IPI3_1_IPI_BUF_INDEX 0x0
#define XPAR_IPI3_2_IPI_BITMASK 0x200
#define XPAR_IPI3_2_IPI_BUF_INDEX 0x1
#define XPAR_IPI3_3_IPI_BITMASK 0x10000
#define XPAR_IPI3_3_IPI_BUF_INDEX 0x7
#define XPAR_IPI3_4_IPI_BITMASK 0x20000
#define XPAR_IPI3_4_IPI_BUF_INDEX 0x7
#define XPAR_IPI3_5_IPI_BITMASK 0x40000
#define XPAR_IPI3_5_IPI_BUF_INDEX 0x7
#define XPAR_IPI3_6_IPI_BITMASK 0x80000
#define XPAR_IPI3_6_IPI_BUF_INDEX 0x7
#define XPAR_IPI3_7_IPI_BITMASK 0x1000000
#define XPAR_IPI3_7_IPI_BUF_INDEX 0x3
#define XPAR_IPI3_8_IPI_BITMASK 0x2000000
#define XPAR_IPI3_8_IPI_BUF_INDEX 0x4
#define XPAR_IPI3_9_IPI_BITMASK 0x4000000
#define XPAR_IPI3_9_IPI_BUF_INDEX 0x5
#define XPAR_IPI3_10_IPI_BITMASK 0x8000000
#define XPAR_IPI3_10_IPI_BUF_INDEX 0x6

/* Canonical definitions for peripheral IPI3 */
#define XPAR_XIPIPSU_0_BASEADDR 0xff330000
#define XPAR_XIPIPSU_0_HIGHADDR 0xff33001f
#define XPAR_XIPIPSU_0_COMPATIBLE xlnx,zynqmp-ipi-mailbox
#define XPAR_XIPIPSU_0_IPI_BITMASK 0x10000
#define XPAR_XIPIPSU_0_IPI_BUF_INDEX 0x7
#define XPAR_XIPIPSU_0_IPI_TARGET_COUNT 0x7

/* Definitions for peripheral IPI4 */
#define XPAR_IPI4_COMPATIBLE xlnx,zynqmp-ipi-mailbox
#define XPAR_IPI4_BASEADDR 0xff331000
#define XPAR_IPI4_HIGHADDR 0xff33101f
#define XPAR_IPI4_IPI_BITMASK 0x20000
#define XPAR_IPI4_IPI_BUF_INDEX 0x7
#define XPAR_IPI4_IPI_TARGET_COUNT 0x7
#define XPAR_IPI4_0_IPI_BITMASK 0x1
#define XPAR_IPI4_0_IPI_BUF_INDEX 0x2
#define XPAR_IPI4_1_IPI_BITMASK 0x100
#define XPAR_IPI4_1_IPI_BUF_INDEX 0x0
#define XPAR_IPI4_2_IPI_BITMASK 0x200
#define XPAR_IPI4_2_IPI_BUF_INDEX 0x1
#define XPAR_IPI4_3_IPI_BITMASK 0x10000
#define XPAR_IPI4_3_IPI_BUF_INDEX 0x7
#define XPAR_IPI4_4_IPI_BITMASK 0x20000
#define XPAR_IPI4_4_IPI_BUF_INDEX 0x7
#define XPAR_IPI4_5_IPI_BITMASK 0x40000
#define XPAR_IPI4_5_IPI_BUF_INDEX 0x7
#define XPAR_IPI4_6_IPI_BITMASK 0x80000
#define XPAR_IPI4_6_IPI_BUF_INDEX 0x7
#define XPAR_IPI4_7_IPI_BITMASK 0x1000000
#define XPAR_IPI4_7_IPI_BUF_INDEX 0x3
#define XPAR_IPI4_8_IPI_BITMASK 0x2000000
#define XPAR_IPI4_8_IPI_BUF_INDEX 0x4
#define XPAR_IPI4_9_IPI_BITMASK 0x4000000
#define XPAR_IPI4_9_IPI_BUF_INDEX 0x5
#define XPAR_IPI4_10_IPI_BITMASK 0x8000000
#define XPAR_IPI4_10_IPI_BUF_INDEX 0x6

/* Canonical definitions for peripheral IPI4 */
#define XPAR_XIPIPSU_1_BASEADDR 0xff331000
#define XPAR_XIPIPSU_1_HIGHADDR 0xff33101f
#define XPAR_XIPIPSU_1_COMPATIBLE xlnx,zynqmp-ipi-mailbox
#define XPAR_XIPIPSU_1_IPI_BITMASK 0x20000
#define XPAR_XIPIPSU_1_IPI_BUF_INDEX 0x7
#define XPAR_XIPIPSU_1_IPI_TARGET_COUNT 0x7

/* Definitions for peripheral IPI5 */
#define XPAR_IPI5_COMPATIBLE xlnx,zynqmp-ipi-mailbox
#define XPAR_IPI5_BASEADDR 0xff332000
#define XPAR_IPI5_HIGHADDR 0xff33201f
#define XPAR_IPI5_IPI_BITMASK 0x40000
#define XPAR_IPI5_IPI_BUF_INDEX 0x7
#define XPAR_IPI5_IPI_TARGET_COUNT 0x7
#define XPAR_IPI5_0_IPI_BITMASK 0x1
#define XPAR_IPI5_0_IPI_BUF_INDEX 0x2
#define XPAR_IPI5_1_IPI_BITMASK 0x100
#define XPAR_IPI5_1_IPI_BUF_INDEX 0x0
#define XPAR_IPI5_2_IPI_BITMASK 0x200
#define XPAR_IPI5_2_IPI_BUF_INDEX 0x1
#define XPAR_IPI5_3_IPI_BITMASK 0x10000
#define XPAR_IPI5_3_IPI_BUF_INDEX 0x7
#define XPAR_IPI5_4_IPI_BITMASK 0x20000
#define XPAR_IPI5_4_IPI_BUF_INDEX 0x7
#define XPAR_IPI5_5_IPI_BITMASK 0x40000
#define XPAR_IPI5_5_IPI_BUF_INDEX 0x7
#define XPAR_IPI5_6_IPI_BITMASK 0x80000
#define XPAR_IPI5_6_IPI_BUF_INDEX 0x7
#define XPAR_IPI5_7_IPI_BITMASK 0x1000000
#define XPAR_IPI5_7_IPI_BUF_INDEX 0x3
#define XPAR_IPI5_8_IPI_BITMASK 0x2000000
#define XPAR_IPI5_8_IPI_BUF_INDEX 0x4
#define XPAR_IPI5_9_IPI_BITMASK 0x4000000
#define XPAR_IPI5_9_IPI_BUF_INDEX 0x5
#define XPAR_IPI5_10_IPI_BITMASK 0x8000000
#define XPAR_IPI5_10_IPI_BUF_INDEX 0x6

/* Canonical definitions for peripheral IPI5 */
#define XPAR_XIPIPSU_2_BASEADDR 0xff332000
#define XPAR_XIPIPSU_2_HIGHADDR 0xff33201f
#define XPAR_XIPIPSU_2_COMPATIBLE xlnx,zynqmp-ipi-mailbox
#define XPAR_XIPIPSU_2_IPI_BITMASK 0x40000
#define XPAR_XIPIPSU_2_IPI_BUF_INDEX 0x7
#define XPAR_XIPIPSU_2_IPI_TARGET_COUNT 0x7

/* Definitions for peripheral IPI6 */
#define XPAR_IPI6_COMPATIBLE xlnx,zynqmp-ipi-mailbox
#define XPAR_IPI6_BASEADDR 0xff333000
#define XPAR_IPI6_HIGHADDR 0xff33301f
#define XPAR_IPI6_IPI_BITMASK 0x80000
#define XPAR_IPI6_IPI_BUF_INDEX 0x7
#define XPAR_IPI6_IPI_TARGET_COUNT 0x7
#define XPAR_IPI6_0_IPI_BITMASK 0x1
#define XPAR_IPI6_0_IPI_BUF_INDEX 0x2
#define XPAR_IPI6_1_IPI_BITMASK 0x100
#define XPAR_IPI6_1_IPI_BUF_INDEX 0x0
#define XPAR_IPI6_2_IPI_BITMASK 0x200
#define XPAR_IPI6_2_IPI_BUF_INDEX 0x1
#define XPAR_IPI6_3_IPI_BITMASK 0x10000
#define XPAR_IPI6_3_IPI_BUF_INDEX 0x7
#define XPAR_IPI6_4_IPI_BITMASK 0x20000
#define XPAR_IPI6_4_IPI_BUF_INDEX 0x7
#define XPAR_IPI6_5_IPI_BITMASK 0x40000
#define XPAR_IPI6_5_IPI_BUF_INDEX 0x7
#define XPAR_IPI6_6_IPI_BITMASK 0x80000
#define XPAR_IPI6_6_IPI_BUF_INDEX 0x7
#define XPAR_IPI6_7_IPI_BITMASK 0x1000000
#define XPAR_IPI6_7_IPI_BUF_INDEX 0x3
#define XPAR_IPI6_8_IPI_BITMASK 0x2000000
#define XPAR_IPI6_8_IPI_BUF_INDEX 0x4
#define XPAR_IPI6_9_IPI_BITMASK 0x4000000
#define XPAR_IPI6_9_IPI_BUF_INDEX 0x5
#define XPAR_IPI6_10_IPI_BITMASK 0x8000000
#define XPAR_IPI6_10_IPI_BUF_INDEX 0x6

/* Canonical definitions for peripheral IPI6 */
#define XPAR_XIPIPSU_3_BASEADDR 0xff333000
#define XPAR_XIPIPSU_3_HIGHADDR 0xff33301f
#define XPAR_XIPIPSU_3_COMPATIBLE xlnx,zynqmp-ipi-mailbox
#define XPAR_XIPIPSU_3_IPI_BITMASK 0x80000
#define XPAR_XIPIPSU_3_IPI_BUF_INDEX 0x7
#define XPAR_XIPIPSU_3_IPI_TARGET_COUNT 0x7

#define XPAR_XPCIEPSU_NUM_INSTANCES 1

/* Definitions for peripheral PCIE */
#define XPAR_PCIE_COMPATIBLE xlnx,nwl-pcie-2.11
#define XPAR_PCIE_BASEADDR 0xfd0e0000
#define XPAR_PCIE_HIGHADDR 0xfd0e0fff
#define XPAR_PCIE_BASEADDR_1 0xfd480000
#define XPAR_PCIE_BASEADDR_2 0x8000000000
#define XPAR_PCIE_RANGES_BASEADDR_0 0xe0000000
#define XPAR_PCIE_RANGES_HIGHADDR_0 0xefffffff
#define XPAR_PCIE_RANGES_BASEADDR_1 0x600000000
#define XPAR_PCIE_RANGES_HIGHADDR_1 0x7ffffffff

/* Canonical definitions for peripheral PCIE */
#define XPAR_XPCIEPSU_0_BASEADDR 0xfd0e0000
#define XPAR_XPCIEPSU_0_HIGHADDR 0xfd0e0fff
#define XPAR_XPCIEPSU_0_COMPATIBLE xlnx,nwl-pcie-2.11
#define XPAR_XPCIEPSU_0_RANGES_BASEADDR_0 0xe0000000
#define XPAR_XPCIEPSU_0_RANGES_HIGHADDR_0 0xefffffff
#define XPAR_XPCIEPSU_0_RANGES_BASEADDR_1 0x600000000
#define XPAR_XPCIEPSU_0_RANGES_HIGHADDR_1 0x7ffffffff

#define XPAR_XQSPIPSU_NUM_INSTANCES 1

/* Definitions for peripheral QSPI */
#define XPAR_QSPI_COMPATIBLE xlnx,zynqmp-qspi-1.0
#define XPAR_QSPI_BASEADDR 0xff0f0000
#define XPAR_QSPI_HIGHADDR 0xff0f0fff
#define XPAR_QSPI_CLOCK_FREQ 0x7732877
#define XPAR_QSPI_CONNECTION_MODE 0x2
#define XPAR_QSPI_BUS_WIDTH 0x2
#define XPAR_QSPI_DMA_COHERENT 0x0
#define XPAR_QSPI_INTERRUPTS 0x400f
#define XPAR_QSPI_REF_CLK 0x0

/* Canonical definitions for peripheral QSPI */
#define XPAR_XQSPIPSU_0_BASEADDR 0xff0f0000
#define XPAR_XQSPIPSU_0_HIGHADDR 0xff0f0fff
#define XPAR_XQSPIPSU_0_BUS_WIDTH 0x2
#define XPAR_XQSPIPSU_0_COMPATIBLE xlnx,zynqmp-qspi-1.0
#define XPAR_XQSPIPSU_0_CLOCK_FREQ 0x7732877
#define XPAR_XQSPIPSU_0_CONNECTION_MODE 0x2
#define XPAR_XQSPIPSU_0_DMA_COHERENT 0x0
#define XPAR_XQSPIPSU_0_INTERRUPTS 0x400f
#define XPAR_XQSPIPSU_0_REF_CLK 0x0

#define XPAR_XRESETPS_NUM_INSTANCES 1

/* Definitions for peripheral PSU_CRF_APB */
#define XPAR_PSU_CRF_APB_COMPATIBLE xlnx,psu-crf-apb-1.0
#define XPAR_PSU_CRF_APB_BASEADDR 0xfd1a0000
#define XPAR_PSU_CRF_APB_HIGHADDR 0xfd2dffff

/* Canonical definitions for peripheral PSU_CRF_APB */
#define XPAR_XRESETPS_0_BASEADDR 0xfd1a0000
#define XPAR_XRESETPS_0_HIGHADDR 0xfd2dffff
#define XPAR_XRESETPS_0_COMPATIBLE xlnx,psu-crf-apb-1.0

#define XPAR_XRTCPSU_NUM_INSTANCES 1

/* Definitions for peripheral RTC */
#define XPAR_RTC_COMPATIBLE xlnx,zynqmp-rtc
#define XPAR_RTC_BASEADDR 0xffa60000
#define XPAR_RTC_HIGHADDR 0xffa600ff
#define XPAR_RTC_INTERRUPTS 0x401a
#define XPAR_RTC_INTERRUPTS_1 0x401b

/* Canonical definitions for peripheral RTC */
#define XPAR_XRTCPSU_0_BASEADDR 0xffa60000
#define XPAR_XRTCPSU_0_HIGHADDR 0xffa600ff
#define XPAR_XRTCPSU_0_COMPATIBLE xlnx,zynqmp-rtc
#define XPAR_XRTCPSU_0_INTERRUPTS 0x401a

#define XPAR_XSDPS_NUM_INSTANCES 1

/* Definitions for peripheral SDHCI1 */
#define XPAR_SDHCI1_COMPATIBLE xlnx,zynqmp-8.9a
#define XPAR_SDHCI1_BASEADDR 0xff170000
#define XPAR_SDHCI1_HIGHADDR 0xff170fff
#define XPAR_SDHCI1_SDIO_CLK_FREQ_HZ 0xb2cbcae
#define XPAR_SDHCI1_HAS_CD 0x1
#define XPAR_SDHCI1_HAS_WP 0x1
#define XPAR_SDHCI1_BUS_WIDTH 0x8
#define XPAR_SDHCI1_MIO_BANK 0x1
#define XPAR_SDHCI1_HAS_EMIO 0x0
#define XPAR_SDHCI1_SLOT_TYPE 0x3
#define XPAR_SDHCI1_IS_CACHE_COHERENT 0x0
#define XPAR_SDHCI1_CLOCKS 0x37

/* Canonical definitions for peripheral SDHCI1 */
#define XPAR_XSDPS_0_BASEADDR 0xff170000
#define XPAR_XSDPS_0_HIGHADDR 0xff170fff
#define XPAR_XSDPS_0_BUS_WIDTH 0x8
#define XPAR_XSDPS_0_COMPATIBLE xlnx,zynqmp-8.9a
#define XPAR_XSDPS_0_CLOCKS 0x37
#define XPAR_XSDPS_0_HAS_CD 0x1
#define XPAR_XSDPS_0_HAS_WP 0x1
#define XPAR_XSDPS_0_HAS_EMIO 0x0
#define XPAR_XSDPS_0_IS_CACHE_COHERENT 0x0
#define XPAR_XSDPS_0_MIO_BANK 0x1
#define XPAR_XSDPS_0_SDIO_CLK_FREQ_HZ 0xb2cbcae
#define XPAR_XSDPS_0_SLOT_TYPE 0x3

#define XPAR_XSYSMONPSU_NUM_INSTANCES 1

/* Definitions for peripheral XILINX_AMS */
#define XPAR_XILINX_AMS_COMPATIBLE xlnx,zynqmp-ams
#define XPAR_XILINX_AMS_BASEADDR 0xffa50000
#define XPAR_XILINX_AMS_HIGHADDR 0xffa507ff
#define XPAR_XILINX_AMS_CLOCK_FREQ 0x0

/* Canonical definitions for peripheral XILINX_AMS */
#define XPAR_XSYSMONPSU_0_BASEADDR 0xffa50000
#define XPAR_XSYSMONPSU_0_HIGHADDR 0xffa507ff
#define XPAR_XSYSMONPSU_0_COMPATIBLE xlnx,zynqmp-ams
#define XPAR_XSYSMONPSU_0_CLOCK_FREQ 0x0

#define XPAR_XTTCPS_NUM_INSTANCES 4

/* Definitions for peripheral TTC0 */
#define XPAR_TTC0_COMPATIBLE cdns,ttc
#define XPAR_TTC0_BASEADDR 0xff110000
#define XPAR_TTC0_HIGHADDR 0xff110fff
#define XPAR_TTC0_CLOCK_FREQ 0x5f5e100
#define XPAR_TTC0_INTERRUPTS 0x4024
#define XPAR_TTC0_INTERRUPTS_1 0x4025
#define XPAR_TTC0_INTERRUPTS_2 0x4026

/* Canonical definitions for peripheral TTC0 */
#define XPAR_XTTCPS_0_BASEADDR 0xff110000
#define XPAR_XTTCPS_0_HIGHADDR 0xff110fff
#define XPAR_XTTCPS_0_COMPATIBLE cdns,ttc
#define XPAR_XTTCPS_0_CLOCK_FREQ 0x5f5e100
#define XPAR_XTTCPS_0_INTERRUPTS 0x4024

/* Definitions for peripheral TTC1 */
#define XPAR_TTC1_COMPATIBLE cdns,ttc
#define XPAR_TTC1_BASEADDR 0xff120000
#define XPAR_TTC1_HIGHADDR 0xff120fff
#define XPAR_TTC1_CLOCK_FREQ 0x5f5e100
#define XPAR_TTC1_INTERRUPTS 0x4027
#define XPAR_TTC1_INTERRUPTS_1 0x4028
#define XPAR_TTC1_INTERRUPTS_2 0x4029

/* Canonical definitions for peripheral TTC1 */
#define XPAR_XTTCPS_1_BASEADDR 0xff120000
#define XPAR_XTTCPS_1_HIGHADDR 0xff120fff
#define XPAR_XTTCPS_1_COMPATIBLE cdns,ttc
#define XPAR_XTTCPS_1_CLOCK_FREQ 0x5f5e100
#define XPAR_XTTCPS_1_INTERRUPTS 0x4027

/* Definitions for peripheral TTC2 */
#define XPAR_TTC2_COMPATIBLE cdns,ttc
#define XPAR_TTC2_BASEADDR 0xff130000
#define XPAR_TTC2_HIGHADDR 0xff130fff
#define XPAR_TTC2_CLOCK_FREQ 0x5f5e100
#define XPAR_TTC2_INTERRUPTS 0x402a
#define XPAR_TTC2_INTERRUPTS_1 0x402b
#define XPAR_TTC2_INTERRUPTS_2 0x402c

/* Canonical definitions for peripheral TTC2 */
#define XPAR_XTTCPS_2_BASEADDR 0xff130000
#define XPAR_XTTCPS_2_HIGHADDR 0xff130fff
#define XPAR_XTTCPS_2_COMPATIBLE cdns,ttc
#define XPAR_XTTCPS_2_CLOCK_FREQ 0x5f5e100
#define XPAR_XTTCPS_2_INTERRUPTS 0x402a

/* Definitions for peripheral TTC3 */
#define XPAR_TTC3_COMPATIBLE cdns,ttc
#define XPAR_TTC3_BASEADDR 0xff140000
#define XPAR_TTC3_HIGHADDR 0xff140fff
#define XPAR_TTC3_CLOCK_FREQ 0x5f5e100
#define XPAR_TTC3_INTERRUPTS 0x402d
#define XPAR_TTC3_INTERRUPTS_1 0x402e
#define XPAR_TTC3_INTERRUPTS_2 0x402f

/* Canonical definitions for peripheral TTC3 */
#define XPAR_XTTCPS_3_BASEADDR 0xff140000
#define XPAR_XTTCPS_3_HIGHADDR 0xff140fff
#define XPAR_XTTCPS_3_COMPATIBLE cdns,ttc
#define XPAR_XTTCPS_3_CLOCK_FREQ 0x5f5e100
#define XPAR_XTTCPS_3_INTERRUPTS 0x402d

#define XPAR_XUARTPS_NUM_INSTANCES 2

/* Definitions for peripheral UART0 */
#define XPAR_UART0_COMPATIBLE xlnx,zynqmp-uart
#define XPAR_UART0_BASEADDR 0xff000000
#define XPAR_UART0_HIGHADDR 0xff000fff
#define XPAR_UART0_CLOCK_FREQ 0x5f5b9f5
#define XPAR_UART0_CTS_OVERRIDE 0x1
#define XPAR_UART0_REF_CLK 0x0
#define XPAR_UART0_INTERRUPTS 0x4015

/* Canonical definitions for peripheral UART0 */
#define XPAR_XUARTPS_0_BASEADDR 0xff000000
#define XPAR_XUARTPS_0_HIGHADDR 0xff000fff
#define XPAR_XUARTPS_0_COMPATIBLE xlnx,zynqmp-uart
#define XPAR_XUARTPS_0_CLOCK_FREQ 0x5f5b9f5
#define XPAR_XUARTPS_0_CTS_OVERRIDE 0x1
#define XPAR_XUARTPS_0_INTERRUPTS 0x4015
#define XPAR_XUARTPS_0_REF_CLK 0x0

/* Definitions for peripheral UART1 */
#define XPAR_UART1_COMPATIBLE xlnx,zynqmp-uart
#define XPAR_UART1_BASEADDR 0xff010000
#define XPAR_UART1_HIGHADDR 0xff010fff
#define XPAR_UART1_CLOCK_FREQ 0x5f5b9f5
#define XPAR_UART1_CTS_OVERRIDE 0x1
#define XPAR_UART1_REF_CLK 0x0
#define XPAR_UART1_INTERRUPTS 0x4016

/* Canonical definitions for peripheral UART1 */
#define XPAR_XUARTPS_1_BASEADDR 0xff010000
#define XPAR_XUARTPS_1_HIGHADDR 0xff010fff
#define XPAR_XUARTPS_1_COMPATIBLE xlnx,zynqmp-uart
#define XPAR_XUARTPS_1_CLOCK_FREQ 0x5f5b9f5
#define XPAR_XUARTPS_1_CTS_OVERRIDE 0x1
#define XPAR_XUARTPS_1_INTERRUPTS 0x4016
#define XPAR_XUARTPS_1_REF_CLK 0x0

#define XPAR_XUSBPSU_NUM_INSTANCES 1

/* Definitions for peripheral DWC3_0 */
#define XPAR_DWC3_0_COMPATIBLE snps,dwc3
#define XPAR_DWC3_0_BASEADDR 0xfe200000
#define XPAR_DWC3_0_HIGHADDR 0xfe23ffff
#define XPAR_DWC3_0_DMA_COHERENT 0x0
#define XPAR_DWC3_0_ENABLE_SUPERSPEED 0x0
#define XPAR_DWC3_0_INTERRUPTS 0x4041
#define XPAR_DWC3_0_INTERRUPTS_1 0x4045
#define XPAR_DWC3_0_INTERRUPTS_2 0x404b

/* Canonical definitions for peripheral DWC3_0 */
#define XPAR_XUSBPSU_0_BASEADDR 0xfe200000
#define XPAR_XUSBPSU_0_HIGHADDR 0xfe23ffff
#define XPAR_XUSBPSU_0_COMPATIBLE snps,dwc3
#define XPAR_XUSBPSU_0_DMA_COHERENT 0x0
#define XPAR_XUSBPSU_0_ENABLE_SUPERSPEED 0x0
#define XPAR_XUSBPSU_0_INTERRUPTS 0x4041

#define XPAR_XWDTPS_NUM_INSTANCES 3

/* Definitions for peripheral WATCHDOG0 */
#define XPAR_WATCHDOG0_COMPATIBLE cdns,wdt-r1p2
#define XPAR_WATCHDOG0_BASEADDR 0xfd4d0000
#define XPAR_WATCHDOG0_HIGHADDR 0xfd4d0fff
#define XPAR_WATCHDOG0_WDT_CLK_FREQ_HZ 0x5f5b9f5
#define XPAR_WATCHDOG0_INTERRUPTS 0x1071

/* Canonical definitions for peripheral WATCHDOG0 */
#define XPAR_XWDTPS_0_BASEADDR 0xfd4d0000
#define XPAR_XWDTPS_0_HIGHADDR 0xfd4d0fff
#define XPAR_XWDTPS_0_COMPATIBLE cdns,wdt-r1p2
#define XPAR_XWDTPS_0_INTERRUPTS 0x1071
#define XPAR_XWDTPS_0_WDT_CLK_FREQ_HZ 0x5f5b9f5

/* Definitions for peripheral LPD_WATCHDOG */
#define XPAR_LPD_WATCHDOG_COMPATIBLE cdns,wdt-r1p2
#define XPAR_LPD_WATCHDOG_BASEADDR 0xff150000
#define XPAR_LPD_WATCHDOG_HIGHADDR 0xff150fff
#define XPAR_LPD_WATCHDOG_WDT_CLK_FREQ_HZ 0x5f5b9f5
#define XPAR_LPD_WATCHDOG_INTERRUPTS 0x1034

/* Canonical definitions for peripheral LPD_WATCHDOG */
#define XPAR_XWDTPS_1_BASEADDR 0xff150000
#define XPAR_XWDTPS_1_HIGHADDR 0xff150fff
#define XPAR_XWDTPS_1_COMPATIBLE cdns,wdt-r1p2
#define XPAR_XWDTPS_1_INTERRUPTS 0x1034
#define XPAR_XWDTPS_1_WDT_CLK_FREQ_HZ 0x5f5b9f5

/* Definitions for peripheral CSUWDT_0 */
#define XPAR_CSUWDT_0_COMPATIBLE cdns,wdt-r1p2
#define XPAR_CSUWDT_0_BASEADDR 0xffcb0000
#define XPAR_CSUWDT_0_HIGHADDR 0xffcb0fff
#define XPAR_CSUWDT_0_WDT_CLK_FREQ_HZ 0x5f5e100
#define XPAR_CSUWDT_0_INTERRUPTS 0x1035

/* Canonical definitions for peripheral CSUWDT_0 */
#define XPAR_XWDTPS_2_BASEADDR 0xffcb0000
#define XPAR_XWDTPS_2_HIGHADDR 0xffcb0fff
#define XPAR_XWDTPS_2_COMPATIBLE cdns,wdt-r1p2
#define XPAR_XWDTPS_2_INTERRUPTS 0x1035
#define XPAR_XWDTPS_2_WDT_CLK_FREQ_HZ 0x5f5e100

#define XPAR_XZDMA_NUM_INSTANCES 16

/* Definitions for peripheral FPD_DMA_CHAN1 */
#define XPAR_FPD_DMA_CHAN1_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_FPD_DMA_CHAN1_BASEADDR 0xfd500000
#define XPAR_FPD_DMA_CHAN1_HIGHADDR 0xfd500fff
#define XPAR_FPD_DMA_CHAN1_DMA_TYPE 0x0
#define XPAR_FPD_DMA_CHAN1_DMA_COHERENT 0x0
#define XPAR_FPD_DMA_CHAN1_INTERRUPTS 0x407c

/* Canonical definitions for peripheral FPD_DMA_CHAN1 */
#define XPAR_XZDMA_0_BASEADDR 0xfd500000
#define XPAR_XZDMA_0_HIGHADDR 0xfd500fff
#define XPAR_XZDMA_0_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_0_DMA_TYPE 0x0
#define XPAR_XZDMA_0_DMA_COHERENT 0x0
#define XPAR_XZDMA_0_INTERRUPTS 0x407c

/* Definitions for peripheral FPD_DMA_CHAN2 */
#define XPAR_FPD_DMA_CHAN2_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_FPD_DMA_CHAN2_BASEADDR 0xfd510000
#define XPAR_FPD_DMA_CHAN2_HIGHADDR 0xfd510fff
#define XPAR_FPD_DMA_CHAN2_DMA_TYPE 0x0
#define XPAR_FPD_DMA_CHAN2_DMA_COHERENT 0x0
#define XPAR_FPD_DMA_CHAN2_INTERRUPTS 0x407d

/* Canonical definitions for peripheral FPD_DMA_CHAN2 */
#define XPAR_XZDMA_1_BASEADDR 0xfd510000
#define XPAR_XZDMA_1_HIGHADDR 0xfd510fff
#define XPAR_XZDMA_1_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_1_DMA_TYPE 0x0
#define XPAR_XZDMA_1_DMA_COHERENT 0x0
#define XPAR_XZDMA_1_INTERRUPTS 0x407d

/* Definitions for peripheral FPD_DMA_CHAN3 */
#define XPAR_FPD_DMA_CHAN3_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_FPD_DMA_CHAN3_BASEADDR 0xfd520000
#define XPAR_FPD_DMA_CHAN3_HIGHADDR 0xfd520fff
#define XPAR_FPD_DMA_CHAN3_DMA_TYPE 0x0
#define XPAR_FPD_DMA_CHAN3_DMA_COHERENT 0x0
#define XPAR_FPD_DMA_CHAN3_INTERRUPTS 0x407e

/* Canonical definitions for peripheral FPD_DMA_CHAN3 */
#define XPAR_XZDMA_2_BASEADDR 0xfd520000
#define XPAR_XZDMA_2_HIGHADDR 0xfd520fff
#define XPAR_XZDMA_2_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_2_DMA_TYPE 0x0
#define XPAR_XZDMA_2_DMA_COHERENT 0x0
#define XPAR_XZDMA_2_INTERRUPTS 0x407e

/* Definitions for peripheral FPD_DMA_CHAN4 */
#define XPAR_FPD_DMA_CHAN4_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_FPD_DMA_CHAN4_BASEADDR 0xfd530000
#define XPAR_FPD_DMA_CHAN4_HIGHADDR 0xfd530fff
#define XPAR_FPD_DMA_CHAN4_DMA_TYPE 0x0
#define XPAR_FPD_DMA_CHAN4_DMA_COHERENT 0x0
#define XPAR_FPD_DMA_CHAN4_INTERRUPTS 0x407f

/* Canonical definitions for peripheral FPD_DMA_CHAN4 */
#define XPAR_XZDMA_3_BASEADDR 0xfd530000
#define XPAR_XZDMA_3_HIGHADDR 0xfd530fff
#define XPAR_XZDMA_3_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_3_DMA_TYPE 0x0
#define XPAR_XZDMA_3_DMA_COHERENT 0x0
#define XPAR_XZDMA_3_INTERRUPTS 0x407f

/* Definitions for peripheral FPD_DMA_CHAN5 */
#define XPAR_FPD_DMA_CHAN5_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_FPD_DMA_CHAN5_BASEADDR 0xfd540000
#define XPAR_FPD_DMA_CHAN5_HIGHADDR 0xfd540fff
#define XPAR_FPD_DMA_CHAN5_DMA_TYPE 0x0
#define XPAR_FPD_DMA_CHAN5_DMA_COHERENT 0x0
#define XPAR_FPD_DMA_CHAN5_INTERRUPTS 0x4080

/* Canonical definitions for peripheral FPD_DMA_CHAN5 */
#define XPAR_XZDMA_4_BASEADDR 0xfd540000
#define XPAR_XZDMA_4_HIGHADDR 0xfd540fff
#define XPAR_XZDMA_4_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_4_DMA_TYPE 0x0
#define XPAR_XZDMA_4_DMA_COHERENT 0x0
#define XPAR_XZDMA_4_INTERRUPTS 0x4080

/* Definitions for peripheral FPD_DMA_CHAN6 */
#define XPAR_FPD_DMA_CHAN6_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_FPD_DMA_CHAN6_BASEADDR 0xfd550000
#define XPAR_FPD_DMA_CHAN6_HIGHADDR 0xfd550fff
#define XPAR_FPD_DMA_CHAN6_DMA_TYPE 0x0
#define XPAR_FPD_DMA_CHAN6_DMA_COHERENT 0x0
#define XPAR_FPD_DMA_CHAN6_INTERRUPTS 0x4081

/* Canonical definitions for peripheral FPD_DMA_CHAN6 */
#define XPAR_XZDMA_5_BASEADDR 0xfd550000
#define XPAR_XZDMA_5_HIGHADDR 0xfd550fff
#define XPAR_XZDMA_5_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_5_DMA_TYPE 0x0
#define XPAR_XZDMA_5_DMA_COHERENT 0x0
#define XPAR_XZDMA_5_INTERRUPTS 0x4081

/* Definitions for peripheral FPD_DMA_CHAN7 */
#define XPAR_FPD_DMA_CHAN7_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_FPD_DMA_CHAN7_BASEADDR 0xfd560000
#define XPAR_FPD_DMA_CHAN7_HIGHADDR 0xfd560fff
#define XPAR_FPD_DMA_CHAN7_DMA_TYPE 0x0
#define XPAR_FPD_DMA_CHAN7_DMA_COHERENT 0x0
#define XPAR_FPD_DMA_CHAN7_INTERRUPTS 0x4082

/* Canonical definitions for peripheral FPD_DMA_CHAN7 */
#define XPAR_XZDMA_6_BASEADDR 0xfd560000
#define XPAR_XZDMA_6_HIGHADDR 0xfd560fff
#define XPAR_XZDMA_6_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_6_DMA_TYPE 0x0
#define XPAR_XZDMA_6_DMA_COHERENT 0x0
#define XPAR_XZDMA_6_INTERRUPTS 0x4082

/* Definitions for peripheral FPD_DMA_CHAN8 */
#define XPAR_FPD_DMA_CHAN8_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_FPD_DMA_CHAN8_BASEADDR 0xfd570000
#define XPAR_FPD_DMA_CHAN8_HIGHADDR 0xfd570fff
#define XPAR_FPD_DMA_CHAN8_DMA_TYPE 0x0
#define XPAR_FPD_DMA_CHAN8_DMA_COHERENT 0x0
#define XPAR_FPD_DMA_CHAN8_INTERRUPTS 0x4083

/* Canonical definitions for peripheral FPD_DMA_CHAN8 */
#define XPAR_XZDMA_7_BASEADDR 0xfd570000
#define XPAR_XZDMA_7_HIGHADDR 0xfd570fff
#define XPAR_XZDMA_7_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_7_DMA_TYPE 0x0
#define XPAR_XZDMA_7_DMA_COHERENT 0x0
#define XPAR_XZDMA_7_INTERRUPTS 0x4083

/* Definitions for peripheral LPD_DMA_CHAN1 */
#define XPAR_LPD_DMA_CHAN1_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_LPD_DMA_CHAN1_BASEADDR 0xffa80000
#define XPAR_LPD_DMA_CHAN1_HIGHADDR 0xffa80fff
#define XPAR_LPD_DMA_CHAN1_DMA_TYPE 0x1
#define XPAR_LPD_DMA_CHAN1_DMA_COHERENT 0x0
#define XPAR_LPD_DMA_CHAN1_INTERRUPTS 0x404d

/* Canonical definitions for peripheral LPD_DMA_CHAN1 */
#define XPAR_XZDMA_8_BASEADDR 0xffa80000
#define XPAR_XZDMA_8_HIGHADDR 0xffa80fff
#define XPAR_XZDMA_8_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_8_DMA_TYPE 0x1
#define XPAR_XZDMA_8_DMA_COHERENT 0x0
#define XPAR_XZDMA_8_INTERRUPTS 0x404d

/* Definitions for peripheral LPD_DMA_CHAN2 */
#define XPAR_LPD_DMA_CHAN2_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_LPD_DMA_CHAN2_BASEADDR 0xffa90000
#define XPAR_LPD_DMA_CHAN2_HIGHADDR 0xffa90fff
#define XPAR_LPD_DMA_CHAN2_DMA_TYPE 0x1
#define XPAR_LPD_DMA_CHAN2_DMA_COHERENT 0x0
#define XPAR_LPD_DMA_CHAN2_INTERRUPTS 0x404e

/* Canonical definitions for peripheral LPD_DMA_CHAN2 */
#define XPAR_XZDMA_9_BASEADDR 0xffa90000
#define XPAR_XZDMA_9_HIGHADDR 0xffa90fff
#define XPAR_XZDMA_9_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_9_DMA_TYPE 0x1
#define XPAR_XZDMA_9_DMA_COHERENT 0x0
#define XPAR_XZDMA_9_INTERRUPTS 0x404e

/* Definitions for peripheral LPD_DMA_CHAN3 */
#define XPAR_LPD_DMA_CHAN3_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_LPD_DMA_CHAN3_BASEADDR 0xffaa0000
#define XPAR_LPD_DMA_CHAN3_HIGHADDR 0xffaa0fff
#define XPAR_LPD_DMA_CHAN3_DMA_TYPE 0x1
#define XPAR_LPD_DMA_CHAN3_DMA_COHERENT 0x0
#define XPAR_LPD_DMA_CHAN3_INTERRUPTS 0x404f

/* Canonical definitions for peripheral LPD_DMA_CHAN3 */
#define XPAR_XZDMA_10_BASEADDR 0xffaa0000
#define XPAR_XZDMA_10_HIGHADDR 0xffaa0fff
#define XPAR_XZDMA_10_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_10_DMA_TYPE 0x1
#define XPAR_XZDMA_10_DMA_COHERENT 0x0
#define XPAR_XZDMA_10_INTERRUPTS 0x404f

/* Definitions for peripheral LPD_DMA_CHAN4 */
#define XPAR_LPD_DMA_CHAN4_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_LPD_DMA_CHAN4_BASEADDR 0xffab0000
#define XPAR_LPD_DMA_CHAN4_HIGHADDR 0xffab0fff
#define XPAR_LPD_DMA_CHAN4_DMA_TYPE 0x1
#define XPAR_LPD_DMA_CHAN4_DMA_COHERENT 0x0
#define XPAR_LPD_DMA_CHAN4_INTERRUPTS 0x4050

/* Canonical definitions for peripheral LPD_DMA_CHAN4 */
#define XPAR_XZDMA_11_BASEADDR 0xffab0000
#define XPAR_XZDMA_11_HIGHADDR 0xffab0fff
#define XPAR_XZDMA_11_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_11_DMA_TYPE 0x1
#define XPAR_XZDMA_11_DMA_COHERENT 0x0
#define XPAR_XZDMA_11_INTERRUPTS 0x4050

/* Definitions for peripheral LPD_DMA_CHAN5 */
#define XPAR_LPD_DMA_CHAN5_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_LPD_DMA_CHAN5_BASEADDR 0xffac0000
#define XPAR_LPD_DMA_CHAN5_HIGHADDR 0xffac0fff
#define XPAR_LPD_DMA_CHAN5_DMA_TYPE 0x1
#define XPAR_LPD_DMA_CHAN5_DMA_COHERENT 0x0
#define XPAR_LPD_DMA_CHAN5_INTERRUPTS 0x4051

/* Canonical definitions for peripheral LPD_DMA_CHAN5 */
#define XPAR_XZDMA_12_BASEADDR 0xffac0000
#define XPAR_XZDMA_12_HIGHADDR 0xffac0fff
#define XPAR_XZDMA_12_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_12_DMA_TYPE 0x1
#define XPAR_XZDMA_12_DMA_COHERENT 0x0
#define XPAR_XZDMA_12_INTERRUPTS 0x4051

/* Definitions for peripheral LPD_DMA_CHAN6 */
#define XPAR_LPD_DMA_CHAN6_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_LPD_DMA_CHAN6_BASEADDR 0xffad0000
#define XPAR_LPD_DMA_CHAN6_HIGHADDR 0xffad0fff
#define XPAR_LPD_DMA_CHAN6_DMA_TYPE 0x1
#define XPAR_LPD_DMA_CHAN6_DMA_COHERENT 0x0
#define XPAR_LPD_DMA_CHAN6_INTERRUPTS 0x4052

/* Canonical definitions for peripheral LPD_DMA_CHAN6 */
#define XPAR_XZDMA_13_BASEADDR 0xffad0000
#define XPAR_XZDMA_13_HIGHADDR 0xffad0fff
#define XPAR_XZDMA_13_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_13_DMA_TYPE 0x1
#define XPAR_XZDMA_13_DMA_COHERENT 0x0
#define XPAR_XZDMA_13_INTERRUPTS 0x4052

/* Definitions for peripheral LPD_DMA_CHAN7 */
#define XPAR_LPD_DMA_CHAN7_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_LPD_DMA_CHAN7_BASEADDR 0xffae0000
#define XPAR_LPD_DMA_CHAN7_HIGHADDR 0xffae0fff
#define XPAR_LPD_DMA_CHAN7_DMA_TYPE 0x1
#define XPAR_LPD_DMA_CHAN7_DMA_COHERENT 0x0
#define XPAR_LPD_DMA_CHAN7_INTERRUPTS 0x4053

/* Canonical definitions for peripheral LPD_DMA_CHAN7 */
#define XPAR_XZDMA_14_BASEADDR 0xffae0000
#define XPAR_XZDMA_14_HIGHADDR 0xffae0fff
#define XPAR_XZDMA_14_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_14_DMA_TYPE 0x1
#define XPAR_XZDMA_14_DMA_COHERENT 0x0
#define XPAR_XZDMA_14_INTERRUPTS 0x4053

/* Definitions for peripheral LPD_DMA_CHAN8 */
#define XPAR_LPD_DMA_CHAN8_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_LPD_DMA_CHAN8_BASEADDR 0xffaf0000
#define XPAR_LPD_DMA_CHAN8_HIGHADDR 0xffaf0fff
#define XPAR_LPD_DMA_CHAN8_DMA_TYPE 0x1
#define XPAR_LPD_DMA_CHAN8_DMA_COHERENT 0x0
#define XPAR_LPD_DMA_CHAN8_INTERRUPTS 0x4054

/* Canonical definitions for peripheral LPD_DMA_CHAN8 */
#define XPAR_XZDMA_15_BASEADDR 0xffaf0000
#define XPAR_XZDMA_15_HIGHADDR 0xffaf0fff
#define XPAR_XZDMA_15_COMPATIBLE xlnx,zynqmp-dma-1.0
#define XPAR_XZDMA_15_DMA_TYPE 0x1
#define XPAR_XZDMA_15_DMA_COHERENT 0x0
#define XPAR_XZDMA_15_INTERRUPTS 0x4054

/* Definitions for peripheral GPU */
#define XPAR_GPU_BASEADDR 0xfd4b0000
#define XPAR_GPU_HIGHADDR 0xfd4bffff

/* Definitions for peripheral OCM */
#define XPAR_OCM_BASEADDR 0xff960000
#define XPAR_OCM_HIGHADDR 0xff960fff

/* Canonical definitions for peripheral OCM */
#define XPAR_MEMORY_CONTROLLER_0_BASEADDR 0xff960000
#define XPAR_MEMORY_CONTROLLER_0_HIGHADDR 0xff960fff

/* Definitions for peripheral PSGTR */
#define XPAR_PSGTR_BASEADDR 0xfd400000
#define XPAR_PSGTR_HIGHADDR 0xfd43ffff

/* Canonical definitions for peripheral PSGTR */
#define XPAR_PHY_0_BASEADDR 0xfd400000
#define XPAR_PHY_0_HIGHADDR 0xfd43ffff

/* Definitions for peripheral SATA */
#define XPAR_SATA_BASEADDR 0xfd0c0000
#define XPAR_SATA_HIGHADDR 0xfd0c1fff

/* Canonical definitions for peripheral SATA */
#define XPAR_AHCI_0_BASEADDR 0xfd0c0000
#define XPAR_AHCI_0_HIGHADDR 0xfd0c1fff

/* Definitions for peripheral SMMU */
#define XPAR_SMMU_BASEADDR 0xfd800000
#define XPAR_SMMU_HIGHADDR 0xfd81ffff

/* Definitions for peripheral USB0 */
#define XPAR_USB0_BASEADDR 0xff9d0000
#define XPAR_USB0_HIGHADDR 0xff9d00ff

/* Definitions for peripheral ZYNQMP_DPDMA */
#define XPAR_ZYNQMP_DPDMA_BASEADDR 0xfd4c0000
#define XPAR_ZYNQMP_DPDMA_HIGHADDR 0xfd4c0fff

/* Canonical definitions for peripheral ZYNQMP_DPDMA */
#define XPAR_DMA_CONTROLLER_0_BASEADDR 0xfd4c0000
#define XPAR_DMA_CONTROLLER_0_HIGHADDR 0xfd4c0fff

/* Definitions for peripheral PSU_R5_TCM_RAM_GLOBAL */
#define XPAR_PSU_R5_TCM_RAM_GLOBAL_BASEADDR 0xffe00000
#define XPAR_PSU_R5_TCM_RAM_GLOBAL_HIGHADDR 0xffe3ffff

/* Definitions for peripheral PSU_R5_1_BTCM_GLOBAL */
#define XPAR_PSU_R5_1_BTCM_GLOBAL_BASEADDR 0xffeb0000
#define XPAR_PSU_R5_1_BTCM_GLOBAL_HIGHADDR 0xffebffff

/* Canonical definitions for peripheral PSU_R5_1_BTCM_GLOBAL */
#define XPAR_PSU_R5_1_BTCM_GLOBAL_0_BASEADDR 0xffeb0000
#define XPAR_PSU_R5_1_BTCM_GLOBAL_0_HIGHADDR 0xffebffff

/* Definitions for peripheral PSU_R5_1_ATCM_GLOBAL */
#define XPAR_PSU_R5_1_ATCM_GLOBAL_BASEADDR 0xffe90000
#define XPAR_PSU_R5_1_ATCM_GLOBAL_HIGHADDR 0xffe9ffff

/* Canonical definitions for peripheral PSU_R5_1_ATCM_GLOBAL */
#define XPAR_PSU_R5_1_ATCM_GLOBAL_0_BASEADDR 0xffe90000
#define XPAR_PSU_R5_1_ATCM_GLOBAL_0_HIGHADDR 0xffe9ffff

/* Definitions for peripheral PSU_R5_0_BTCM_GLOBAL */
#define XPAR_PSU_R5_0_BTCM_GLOBAL_BASEADDR 0xffe20000
#define XPAR_PSU_R5_0_BTCM_GLOBAL_HIGHADDR 0xffe2ffff

/* Canonical definitions for peripheral PSU_R5_0_BTCM_GLOBAL */
#define XPAR_PSU_R5_0_BTCM_GLOBAL_0_BASEADDR 0xffe20000
#define XPAR_PSU_R5_0_BTCM_GLOBAL_0_HIGHADDR 0xffe2ffff

/* Definitions for peripheral PSU_R5_0_ATCM_GLOBAL */
#define XPAR_PSU_R5_0_ATCM_GLOBAL_BASEADDR 0xffe00000
#define XPAR_PSU_R5_0_ATCM_GLOBAL_HIGHADDR 0xffe0ffff

/* Canonical definitions for peripheral PSU_R5_0_ATCM_GLOBAL */
#define XPAR_PSU_R5_0_ATCM_GLOBAL_0_BASEADDR 0xffe00000
#define XPAR_PSU_R5_0_ATCM_GLOBAL_0_HIGHADDR 0xffe0ffff

/* Definitions for peripheral PSU_BBRAM_0 */
#define XPAR_PSU_BBRAM_0_BASEADDR 0xffcd0000
#define XPAR_PSU_BBRAM_0_HIGHADDR 0xffcdffff

/* Canonical definitions for peripheral PSU_BBRAM_0 */
#define XPAR_PSU_BBRAM_0_0_BASEADDR 0xffcd0000
#define XPAR_PSU_BBRAM_0_0_HIGHADDR 0xffcdffff

/* Definitions for peripheral PSU_PMU_RAM */
#define XPAR_PSU_PMU_RAM_BASEADDR 0xffdc0000
#define XPAR_PSU_PMU_RAM_HIGHADDR 0xffddffff

/* Canonical definitions for peripheral PSU_PMU_RAM */
#define XPAR_PSU_PMU_RAM_0_BASEADDR 0xffdc0000
#define XPAR_PSU_PMU_RAM_0_HIGHADDR 0xffddffff

/* Definitions for peripheral PSU_PMU_IOMODULE */
#define XPAR_PSU_PMU_IOMODULE_BASEADDR 0xffd40000
#define XPAR_PSU_PMU_IOMODULE_HIGHADDR 0xffd5ffff

/* Canonical definitions for peripheral PSU_PMU_IOMODULE */
#define XPAR_PSU_PMU_IOMODULE_0_BASEADDR 0xffd40000
#define XPAR_PSU_PMU_IOMODULE_0_HIGHADDR 0xffd5ffff

/* Definitions for peripheral PSU_PMU_GLOBAL_0 */
#define XPAR_PSU_PMU_GLOBAL_0_BASEADDR 0xffd80000
#define XPAR_PSU_PMU_GLOBAL_0_HIGHADDR 0xffdbffff

/* Canonical definitions for peripheral PSU_PMU_GLOBAL_0 */
#define XPAR_PSU_PMU_GLOBAL_0_0_BASEADDR 0xffd80000
#define XPAR_PSU_PMU_GLOBAL_0_0_HIGHADDR 0xffdbffff

/* Definitions for peripheral PSU_MBISTJTAG */
#define XPAR_PSU_MBISTJTAG_BASEADDR 0xffcf0000
#define XPAR_PSU_MBISTJTAG_HIGHADDR 0xffcfffff

/* Canonical definitions for peripheral PSU_MBISTJTAG */
#define XPAR_PSU_MBISTJTAG_0_BASEADDR 0xffcf0000
#define XPAR_PSU_MBISTJTAG_0_HIGHADDR 0xffcfffff

/* Definitions for peripheral PSU_RSA */
#define XPAR_PSU_RSA_BASEADDR 0xffce0000
#define XPAR_PSU_RSA_HIGHADDR 0xffceffff

/* Canonical definitions for peripheral PSU_RSA */
#define XPAR_PSU_RSA_0_BASEADDR 0xffce0000
#define XPAR_PSU_RSA_0_HIGHADDR 0xffceffff

/* Definitions for peripheral PSU_EFUSE */
#define XPAR_PSU_EFUSE_BASEADDR 0xffcc0000
#define XPAR_PSU_EFUSE_HIGHADDR 0xffccffff

/* Canonical definitions for peripheral PSU_EFUSE */
#define XPAR_PSU_EFUSE_0_BASEADDR 0xffcc0000
#define XPAR_PSU_EFUSE_0_HIGHADDR 0xffccffff

/* Definitions for peripheral PSU_CSU_0 */
#define XPAR_PSU_CSU_0_BASEADDR 0xffca0000
#define XPAR_PSU_CSU_0_HIGHADDR 0xffcaffff

/* Definitions for peripheral PSU_FPD_GPV */
#define XPAR_PSU_FPD_GPV_BASEADDR 0xfd700000
#define XPAR_PSU_FPD_GPV_HIGHADDR 0xfd7fffff

/* Canonical definitions for peripheral PSU_FPD_GPV */
#define XPAR_PSU_FPD_GPV_0_BASEADDR 0xfd700000
#define XPAR_PSU_FPD_GPV_0_HIGHADDR 0xfd7fffff

/* Definitions for peripheral PSU_CCI_GPV */
#define XPAR_PSU_CCI_GPV_BASEADDR 0xfd6e0000
#define XPAR_PSU_CCI_GPV_HIGHADDR 0xfd6effff

/* Canonical definitions for peripheral PSU_CCI_GPV */
#define XPAR_PSU_CCI_GPV_0_BASEADDR 0xfd6e0000
#define XPAR_PSU_CCI_GPV_0_HIGHADDR 0xfd6effff

/* Definitions for peripheral PSU_FPD_SLCR_SECURE */
#define XPAR_PSU_FPD_SLCR_SECURE_BASEADDR 0xfd690000
#define XPAR_PSU_FPD_SLCR_SECURE_HIGHADDR 0xfd6cffff

/* Canonical definitions for peripheral PSU_FPD_SLCR_SECURE */
#define XPAR_PSU_FPD_SLCR_SECURE_0_BASEADDR 0xfd690000
#define XPAR_PSU_FPD_SLCR_SECURE_0_HIGHADDR 0xfd6cffff

/* Definitions for peripheral PSU_FPD_SLCR */
#define XPAR_PSU_FPD_SLCR_BASEADDR 0xfd610000
#define XPAR_PSU_FPD_SLCR_HIGHADDR 0xfd68ffff

/* Canonical definitions for peripheral PSU_FPD_SLCR */
#define XPAR_PSU_FPD_SLCR_0_BASEADDR 0xfd610000
#define XPAR_PSU_FPD_SLCR_0_HIGHADDR 0xfd68ffff

/* Definitions for peripheral PSU_SMMU_REG */
#define XPAR_PSU_SMMU_REG_BASEADDR 0xfd5f0000
#define XPAR_PSU_SMMU_REG_HIGHADDR 0xfd5fffff

/* Canonical definitions for peripheral PSU_SMMU_REG */
#define XPAR_PSU_SMMU_REG_0_BASEADDR 0xfd5f0000
#define XPAR_PSU_SMMU_REG_0_HIGHADDR 0xfd5fffff

/* Definitions for peripheral PSU_CCI_REG */
#define XPAR_PSU_CCI_REG_BASEADDR 0xfd5e0000
#define XPAR_PSU_CCI_REG_HIGHADDR 0xfd5effff

/* Canonical definitions for peripheral PSU_CCI_REG */
#define XPAR_PSU_CCI_REG_0_BASEADDR 0xfd5e0000
#define XPAR_PSU_CCI_REG_0_HIGHADDR 0xfd5effff

/* Definitions for peripheral PSU_FPD_XMPU_CFG */
#define XPAR_PSU_FPD_XMPU_CFG_BASEADDR 0xfd5d0000
#define XPAR_PSU_FPD_XMPU_CFG_HIGHADDR 0xfd5dffff

/* Canonical definitions for peripheral PSU_FPD_XMPU_CFG */
#define XPAR_PSU_FPD_XMPU_CFG_0_BASEADDR 0xfd5d0000
#define XPAR_PSU_FPD_XMPU_CFG_0_HIGHADDR 0xfd5dffff

/* Definitions for peripheral PSU_APU */
#define XPAR_PSU_APU_BASEADDR 0xfd5c0000
#define XPAR_PSU_APU_HIGHADDR 0xfd5cffff

/* Canonical definitions for peripheral PSU_APU */
#define XPAR_PSU_APU_0_BASEADDR 0xfd5c0000
#define XPAR_PSU_APU_0_HIGHADDR 0xfd5cffff

/* Definitions for peripheral PSU_FPD_XMPU_SINK */
#define XPAR_PSU_FPD_XMPU_SINK_BASEADDR 0xfd4f0000
#define XPAR_PSU_FPD_XMPU_SINK_HIGHADDR 0xfd4fffff

/* Canonical definitions for peripheral PSU_FPD_XMPU_SINK */
#define XPAR_PSU_FPD_XMPU_SINK_0_BASEADDR 0xfd4f0000
#define XPAR_PSU_FPD_XMPU_SINK_0_HIGHADDR 0xfd4fffff

/* Definitions for peripheral PSU_SIOU */
#define XPAR_PSU_SIOU_BASEADDR 0xfd3d0000
#define XPAR_PSU_SIOU_HIGHADDR 0xfd3dffff

/* Canonical definitions for peripheral PSU_SIOU */
#define XPAR_PSU_SIOU_0_BASEADDR 0xfd3d0000
#define XPAR_PSU_SIOU_0_HIGHADDR 0xfd3dffff

/* Definitions for peripheral PSU_AFI_5 */
#define XPAR_PSU_AFI_5_BASEADDR 0xfd3b0000
#define XPAR_PSU_AFI_5_HIGHADDR 0xfd3bffff

/* Definitions for peripheral PSU_AFI_4 */
#define XPAR_PSU_AFI_4_BASEADDR 0xfd3a0000
#define XPAR_PSU_AFI_4_HIGHADDR 0xfd3affff

/* Definitions for peripheral PSU_AFI_3 */
#define XPAR_PSU_AFI_3_BASEADDR 0xfd390000
#define XPAR_PSU_AFI_3_HIGHADDR 0xfd39ffff

/* Definitions for peripheral PSU_AFI_2 */
#define XPAR_PSU_AFI_2_BASEADDR 0xfd380000
#define XPAR_PSU_AFI_2_HIGHADDR 0xfd38ffff

/* Definitions for peripheral PSU_AFI_1 */
#define XPAR_PSU_AFI_1_BASEADDR 0xfd370000
#define XPAR_PSU_AFI_1_HIGHADDR 0xfd37ffff

/* Definitions for peripheral PSU_AFI_0 */
#define XPAR_PSU_AFI_0_BASEADDR 0xfd360000
#define XPAR_PSU_AFI_0_HIGHADDR 0xfd36ffff

/* Definitions for peripheral PSU_PCIE_DMA */
#define XPAR_PSU_PCIE_DMA_BASEADDR 0xfd0f0000
#define XPAR_PSU_PCIE_DMA_HIGHADDR 0xfd0fffff

/* Canonical definitions for peripheral PSU_PCIE_DMA */
#define XPAR_PSU_PCIE_DMA_0_BASEADDR 0xfd0f0000
#define XPAR_PSU_PCIE_DMA_0_HIGHADDR 0xfd0fffff

/* Definitions for peripheral PSU_PCIE_LOW */
#define XPAR_PSU_PCIE_LOW_BASEADDR 0xe0000000
#define XPAR_PSU_PCIE_LOW_HIGHADDR 0xefffffff

/* Definitions for peripheral PSU_PCIE_HIGH1 */
#define XPAR_PSU_PCIE_HIGH1_BASEADDR 0x600000000
#define XPAR_PSU_PCIE_HIGH1_HIGHADDR 0x7ffffffff

/* Definitions for peripheral PSU_PCIE_HIGH2 */
#define XPAR_PSU_PCIE_HIGH2_BASEADDR 0x8000000000
#define XPAR_PSU_PCIE_HIGH2_HIGHADDR 0xbfffffffff

/* Definitions for peripheral PSU_PCIE_ATTRIB_0 */
#define XPAR_PSU_PCIE_ATTRIB_0_BASEADDR 0xfd480000
#define XPAR_PSU_PCIE_ATTRIB_0_HIGHADDR 0xfd48ffff

/* Canonical definitions for peripheral PSU_PCIE_ATTRIB_0 */
#define XPAR_PSU_PCIE_ATTRIB_0_0_BASEADDR 0xfd480000
#define XPAR_PSU_PCIE_ATTRIB_0_0_HIGHADDR 0xfd48ffff

/* Definitions for peripheral PSU_DDR_QOS_CTRL */
#define XPAR_PSU_DDR_QOS_CTRL_BASEADDR 0xfd090000
#define XPAR_PSU_DDR_QOS_CTRL_HIGHADDR 0xfd09ffff

/* Canonical definitions for peripheral PSU_DDR_QOS_CTRL */
#define XPAR_PSU_DDR_QOS_CTRL_0_BASEADDR 0xfd090000
#define XPAR_PSU_DDR_QOS_CTRL_0_HIGHADDR 0xfd09ffff

/* Definitions for peripheral PSU_DDR_PHY */
#define XPAR_PSU_DDR_PHY_BASEADDR 0xfd080000
#define XPAR_PSU_DDR_PHY_HIGHADDR 0xfd08ffff

/* Canonical definitions for peripheral PSU_DDR_PHY */
#define XPAR_PSU_DDR_PHY_0_BASEADDR 0xfd080000
#define XPAR_PSU_DDR_PHY_0_HIGHADDR 0xfd08ffff

/* Definitions for peripheral PSU_DDR_XMPU5_CFG */
#define XPAR_PSU_DDR_XMPU5_CFG_BASEADDR 0xfd050000
#define XPAR_PSU_DDR_XMPU5_CFG_HIGHADDR 0xfd05ffff

/* Canonical definitions for peripheral PSU_DDR_XMPU5_CFG */
#define XPAR_PSU_DDR_XMPU5_CFG_0_BASEADDR 0xfd050000
#define XPAR_PSU_DDR_XMPU5_CFG_0_HIGHADDR 0xfd05ffff

/* Definitions for peripheral PSU_DDR_XMPU4_CFG */
#define XPAR_PSU_DDR_XMPU4_CFG_BASEADDR 0xfd040000
#define XPAR_PSU_DDR_XMPU4_CFG_HIGHADDR 0xfd04ffff

/* Canonical definitions for peripheral PSU_DDR_XMPU4_CFG */
#define XPAR_PSU_DDR_XMPU4_CFG_0_BASEADDR 0xfd040000
#define XPAR_PSU_DDR_XMPU4_CFG_0_HIGHADDR 0xfd04ffff

/* Definitions for peripheral PSU_DDR_XMPU3_CFG */
#define XPAR_PSU_DDR_XMPU3_CFG_BASEADDR 0xfd030000
#define XPAR_PSU_DDR_XMPU3_CFG_HIGHADDR 0xfd03ffff

/* Canonical definitions for peripheral PSU_DDR_XMPU3_CFG */
#define XPAR_PSU_DDR_XMPU3_CFG_0_BASEADDR 0xfd030000
#define XPAR_PSU_DDR_XMPU3_CFG_0_HIGHADDR 0xfd03ffff

/* Definitions for peripheral PSU_DDR_XMPU2_CFG */
#define XPAR_PSU_DDR_XMPU2_CFG_BASEADDR 0xfd020000
#define XPAR_PSU_DDR_XMPU2_CFG_HIGHADDR 0xfd02ffff

/* Canonical definitions for peripheral PSU_DDR_XMPU2_CFG */
#define XPAR_PSU_DDR_XMPU2_CFG_0_BASEADDR 0xfd020000
#define XPAR_PSU_DDR_XMPU2_CFG_0_HIGHADDR 0xfd02ffff

/* Definitions for peripheral PSU_DDR_XMPU1_CFG */
#define XPAR_PSU_DDR_XMPU1_CFG_BASEADDR 0xfd010000
#define XPAR_PSU_DDR_XMPU1_CFG_HIGHADDR 0xfd01ffff

/* Canonical definitions for peripheral PSU_DDR_XMPU1_CFG */
#define XPAR_PSU_DDR_XMPU1_CFG_0_BASEADDR 0xfd010000
#define XPAR_PSU_DDR_XMPU1_CFG_0_HIGHADDR 0xfd01ffff

/* Definitions for peripheral PSU_DDR_XMPU0_CFG */
#define XPAR_PSU_DDR_XMPU0_CFG_BASEADDR 0xfd000000
#define XPAR_PSU_DDR_XMPU0_CFG_HIGHADDR 0xfd00ffff

/* Canonical definitions for peripheral PSU_DDR_XMPU0_CFG */
#define XPAR_PSU_DDR_XMPU0_CFG_0_BASEADDR 0xfd000000
#define XPAR_PSU_DDR_XMPU0_CFG_0_HIGHADDR 0xfd00ffff

/* Definitions for peripheral PSU_OCM_XMPU_CFG */
#define XPAR_PSU_OCM_XMPU_CFG_BASEADDR 0xffa70000
#define XPAR_PSU_OCM_XMPU_CFG_HIGHADDR 0xffa7ffff

/* Canonical definitions for peripheral PSU_OCM_XMPU_CFG */
#define XPAR_PSU_OCM_XMPU_CFG_0_BASEADDR 0xffa70000
#define XPAR_PSU_OCM_XMPU_CFG_0_HIGHADDR 0xffa7ffff

/* Definitions for peripheral PSU_LPD_XPPU_SINK */
#define XPAR_PSU_LPD_XPPU_SINK_BASEADDR 0xff9c0000
#define XPAR_PSU_LPD_XPPU_SINK_HIGHADDR 0xff9cffff

/* Canonical definitions for peripheral PSU_LPD_XPPU_SINK */
#define XPAR_PSU_LPD_XPPU_SINK_0_BASEADDR 0xff9c0000
#define XPAR_PSU_LPD_XPPU_SINK_0_HIGHADDR 0xff9cffff

/* Definitions for peripheral PSU_AFI_6 */
#define XPAR_PSU_AFI_6_BASEADDR 0xff9b0000
#define XPAR_PSU_AFI_6_HIGHADDR 0xff9bffff

/* Definitions for peripheral PSU_RPU */
#define XPAR_PSU_RPU_BASEADDR 0xff9a0000
#define XPAR_PSU_RPU_HIGHADDR 0xff9affff

/* Canonical definitions for peripheral PSU_RPU */
#define XPAR_PSU_RPU_0_BASEADDR 0xff9a0000
#define XPAR_PSU_RPU_0_HIGHADDR 0xff9affff

/* Definitions for peripheral PSU_CRL_APB */
#define XPAR_PSU_CRL_APB_BASEADDR 0xff5e0000
#define XPAR_PSU_CRL_APB_HIGHADDR 0xff85ffff

/* Canonical definitions for peripheral PSU_CRL_APB */
#define XPAR_PSU_CRL_APB_0_BASEADDR 0xff5e0000
#define XPAR_PSU_CRL_APB_0_HIGHADDR 0xff85ffff

/* Definitions for peripheral PSU_LPD_SLCR_SECURE */
#define XPAR_PSU_LPD_SLCR_SECURE_BASEADDR 0xff4b0000
#define XPAR_PSU_LPD_SLCR_SECURE_HIGHADDR 0xff4dffff

/* Canonical definitions for peripheral PSU_LPD_SLCR_SECURE */
#define XPAR_PSU_LPD_SLCR_SECURE_0_BASEADDR 0xff4b0000
#define XPAR_PSU_LPD_SLCR_SECURE_0_HIGHADDR 0xff4dffff

/* Definitions for peripheral PSU_LPD_SLCR */
#define XPAR_PSU_LPD_SLCR_BASEADDR 0xff410000
#define XPAR_PSU_LPD_SLCR_HIGHADDR 0xff4affff

/* Canonical definitions for peripheral PSU_LPD_SLCR */
#define XPAR_PSU_LPD_SLCR_0_BASEADDR 0xff410000
#define XPAR_PSU_LPD_SLCR_0_HIGHADDR 0xff4affff

/* Definitions for peripheral PSU_IOU_SCNTRS */
#define XPAR_PSU_IOU_SCNTRS_BASEADDR 0xff260000
#define XPAR_PSU_IOU_SCNTRS_HIGHADDR 0xff26ffff

/* Canonical definitions for peripheral PSU_IOU_SCNTRS */
#define XPAR_PSU_IOU_SCNTRS_0_BASEADDR 0xff260000
#define XPAR_PSU_IOU_SCNTRS_0_HIGHADDR 0xff26ffff

/* Definitions for peripheral PSU_IOU_SCNTR */
#define XPAR_PSU_IOU_SCNTR_BASEADDR 0xff250000
#define XPAR_PSU_IOU_SCNTR_HIGHADDR 0xff25ffff

/* Canonical definitions for peripheral PSU_IOU_SCNTR */
#define XPAR_PSU_IOU_SCNTR_0_BASEADDR 0xff250000
#define XPAR_PSU_IOU_SCNTR_0_HIGHADDR 0xff25ffff

/* Definitions for peripheral PSU_IOUSECURE_SLCR */
#define XPAR_PSU_IOUSECURE_SLCR_BASEADDR 0xff240000
#define XPAR_PSU_IOUSECURE_SLCR_HIGHADDR 0xff24ffff

/* Canonical definitions for peripheral PSU_IOUSECURE_SLCR */
#define XPAR_PSU_IOUSECURE_SLCR_0_BASEADDR 0xff240000
#define XPAR_PSU_IOUSECURE_SLCR_0_HIGHADDR 0xff24ffff

/* Definitions for peripheral PSU_IOUSLCR_0 */
#define XPAR_PSU_IOUSLCR_0_BASEADDR 0xff180000
#define XPAR_PSU_IOUSLCR_0_HIGHADDR 0xff23ffff

/* Definitions for peripheral PSU_QSPI_LINEAR_0 */
#define XPAR_PSU_QSPI_LINEAR_0_BASEADDR 0xc0000000
#define XPAR_PSU_QSPI_LINEAR_0_HIGHADDR 0xdfffffff

/* Definitions for peripheral LPD_XPPU */
#define XPAR_LPD_XPPU_BASEADDR 0xff980000
#define XPAR_LPD_XPPU_HIGHADDR 0xff980fff

/* Canonical definitions for peripheral LPD_XPPU */
#define XPAR_XPPU_0_BASEADDR 0xff980000
#define XPAR_XPPU_0_HIGHADDR 0xff980fff


#define XPS_BOARD_ZCU102

#define XPAR_PSU_DDR_0_BASEADDRESS 0x0
#define XPAR_PSU_DDR_0_HIGHADDRESS 0x7ff00000
#define XPAR_PSU_DDR_1_BASEADDRESS 0x7ff00000
#define XPAR_PSU_DDR_1_HIGHADDRESS 0x80000000
#define XPAR_PSU_OCM_0_BASEADDRESS 0xfffc0000
#define XPAR_PSU_OCM_0_HIGHADDRESS 0x100000000
#define XPAR_CPU_CORE_CLOCK_FREQ_HZ 180000000

#define STDOUT_BASEADDRESS 0xff000000
#define STDIN_BASEADDRESS 0xff000000

/* Number of SLRs */
#define NUMBER_OF_SLRS 0x1

#endif  /* end of protection macro */