/* Generated by wayland-scanner 1.21.0 */

#ifndef GTK_PRIMARY_SELECTION_CLIENT_PROTOCOL_H
#define GTK_PRIMARY_SELECTION_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_gtk_primary_selection The gtk_primary_selection protocol
 * Primary selection protocol
 *
 * @section page_desc_gtk_primary_selection Description
 *
 * This protocol provides the ability to have a primary selection device to
 * match that of the X server. This primary selection is a shortcut to the
 * common clipboard selection, where text just needs to be selected in order
 * to allow copying it elsewhere. The de facto way to perform this action
 * is the middle mouse button, although it is not limited to this one.
 *
 * Clients wishing to honor primary selection should create a primary
 * selection source and set it as the selection through
 * wp_primary_selection_device.set_selection whenever the text selection
 * changes. In order to minimize calls in pointer-driven text selection,
 * it should happen only once after the operation finished. Similarly,
 * a NULL source should be set when text is unselected.
 *
 * wp_primary_selection_offer objects are first announced through the
 * wp_primary_selection_device.data_offer event. Immediately after this event,
 * the primary data offer will emit wp_primary_selection_offer.offer events
 * to let know of the mime types being offered.
 *
 * When the primary selection changes, the client with the keyboard focus
 * will receive wp_primary_selection_device.selection events. Only the client
 * with the keyboard focus will receive such events with a non-NULL
 * wp_primary_selection_offer. Across keyboard focus changes, previously
 * focused clients will receive wp_primary_selection_device.events with a
 * NULL wp_primary_selection_offer.
 *
 * In order to request the primary selection data, the client must pass
 * a recent serial pertaining to the press event that is triggering the
 * operation, if the compositor deems the serial valid and recent, the
 * wp_primary_selection_source.send event will happen in the other end
 * to let the transfer begin. The client owning the primary selection
 * should write the requested data, and close the file descriptor
 * immediately.
 *
 * If the primary selection owner client disappeared during the transfer,
 * the client reading the data will receive a
 * wp_primary_selection_device.selection event with a NULL
 * wp_primary_selection_offer, the client should take this as a hint
 * to finish the reads related to the no longer existing offer.
 *
 * The primary selection owner should be checking for errors during
 * writes, merely cancelling the ongoing transfer if any happened.
 *
 * @section page_ifaces_gtk_primary_selection Interfaces
 * - @subpage page_iface_gtk_primary_selection_device_manager - X primary selection emulation
 * - @subpage page_iface_gtk_primary_selection_device - 
 * - @subpage page_iface_gtk_primary_selection_offer - offer to transfer primary selection contents
 * - @subpage page_iface_gtk_primary_selection_source - offer to replace the contents of the primary selection
 * @section page_copyright_gtk_primary_selection Copyright
 * <pre>
 *
 * Copyright © 2015, 2016 Red Hat
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct gtk_primary_selection_device;
struct gtk_primary_selection_device_manager;
struct gtk_primary_selection_offer;
struct gtk_primary_selection_source;
struct wl_seat;

#ifndef GTK_PRIMARY_SELECTION_DEVICE_MANAGER_INTERFACE
#define GTK_PRIMARY_SELECTION_DEVICE_MANAGER_INTERFACE
/**
 * @page page_iface_gtk_primary_selection_device_manager gtk_primary_selection_device_manager
 * @section page_iface_gtk_primary_selection_device_manager_desc Description
 *
 * The primary selection device manager is a singleton global object that
 * provides access to the primary selection. It allows to create
 * wp_primary_selection_source objects, as well as retrieving the per-seat
 * wp_primary_selection_device objects.
 * @section page_iface_gtk_primary_selection_device_manager_api API
 * See @ref iface_gtk_primary_selection_device_manager.
 */
/**
 * @defgroup iface_gtk_primary_selection_device_manager The gtk_primary_selection_device_manager interface
 *
 * The primary selection device manager is a singleton global object that
 * provides access to the primary selection. It allows to create
 * wp_primary_selection_source objects, as well as retrieving the per-seat
 * wp_primary_selection_device objects.
 */
extern const struct wl_interface gtk_primary_selection_device_manager_interface;
#endif
#ifndef GTK_PRIMARY_SELECTION_DEVICE_INTERFACE
#define GTK_PRIMARY_SELECTION_DEVICE_INTERFACE
/**
 * @page page_iface_gtk_primary_selection_device gtk_primary_selection_device
 * @section page_iface_gtk_primary_selection_device_api API
 * See @ref iface_gtk_primary_selection_device.
 */
/**
 * @defgroup iface_gtk_primary_selection_device The gtk_primary_selection_device interface
 */
extern const struct wl_interface gtk_primary_selection_device_interface;
#endif
#ifndef GTK_PRIMARY_SELECTION_OFFER_INTERFACE
#define GTK_PRIMARY_SELECTION_OFFER_INTERFACE
/**
 * @page page_iface_gtk_primary_selection_offer gtk_primary_selection_offer
 * @section page_iface_gtk_primary_selection_offer_desc Description
 *
 * A wp_primary_selection_offer represents an offer to transfer the contents
 * of the primary selection clipboard to the client. Similar to
 * wl_data_offer, the offer also describes the mime types that the source
 * will transferthat the
 * data can be converted to and provides the mechanisms for transferring the
 * data directly to the client.
 * @section page_iface_gtk_primary_selection_offer_api API
 * See @ref iface_gtk_primary_selection_offer.
 */
/**
 * @defgroup iface_gtk_primary_selection_offer The gtk_primary_selection_offer interface
 *
 * A wp_primary_selection_offer represents an offer to transfer the contents
 * of the primary selection clipboard to the client. Similar to
 * wl_data_offer, the offer also describes the mime types that the source
 * will transferthat the
 * data can be converted to and provides the mechanisms for transferring the
 * data directly to the client.
 */
extern const struct wl_interface gtk_primary_selection_offer_interface;
#endif
#ifndef GTK_PRIMARY_SELECTION_SOURCE_INTERFACE
#define GTK_PRIMARY_SELECTION_SOURCE_INTERFACE
/**
 * @page page_iface_gtk_primary_selection_source gtk_primary_selection_source
 * @section page_iface_gtk_primary_selection_source_desc Description
 *
 * The source side of a wp_primary_selection_offer, it provides a way to
 * describe the offered data and respond to requests to transfer the
 * requested contents of the primary selection clipboard.
 * @section page_iface_gtk_primary_selection_source_api API
 * See @ref iface_gtk_primary_selection_source.
 */
/**
 * @defgroup iface_gtk_primary_selection_source The gtk_primary_selection_source interface
 *
 * The source side of a wp_primary_selection_offer, it provides a way to
 * describe the offered data and respond to requests to transfer the
 * requested contents of the primary selection clipboard.
 */
extern const struct wl_interface gtk_primary_selection_source_interface;
#endif

#define GTK_PRIMARY_SELECTION_DEVICE_MANAGER_CREATE_SOURCE 0
#define GTK_PRIMARY_SELECTION_DEVICE_MANAGER_GET_DEVICE 1
#define GTK_PRIMARY_SELECTION_DEVICE_MANAGER_DESTROY 2


/**
 * @ingroup iface_gtk_primary_selection_device_manager
 */
#define GTK_PRIMARY_SELECTION_DEVICE_MANAGER_CREATE_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_gtk_primary_selection_device_manager
 */
#define GTK_PRIMARY_SELECTION_DEVICE_MANAGER_GET_DEVICE_SINCE_VERSION 1
/**
 * @ingroup iface_gtk_primary_selection_device_manager
 */
#define GTK_PRIMARY_SELECTION_DEVICE_MANAGER_DESTROY_SINCE_VERSION 1

/** @ingroup iface_gtk_primary_selection_device_manager */
static inline void
gtk_primary_selection_device_manager_set_user_data(struct gtk_primary_selection_device_manager *gtk_primary_selection_device_manager, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gtk_primary_selection_device_manager, user_data);
}

/** @ingroup iface_gtk_primary_selection_device_manager */
static inline void *
gtk_primary_selection_device_manager_get_user_data(struct gtk_primary_selection_device_manager *gtk_primary_selection_device_manager)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gtk_primary_selection_device_manager);
}

static inline uint32_t
gtk_primary_selection_device_manager_get_version(struct gtk_primary_selection_device_manager *gtk_primary_selection_device_manager)
{
	return wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_device_manager);
}

/**
 * @ingroup iface_gtk_primary_selection_device_manager
 *
 * Create a new primary selection source.
 */
static inline struct gtk_primary_selection_source *
gtk_primary_selection_device_manager_create_source(struct gtk_primary_selection_device_manager *gtk_primary_selection_device_manager)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) gtk_primary_selection_device_manager,
			 GTK_PRIMARY_SELECTION_DEVICE_MANAGER_CREATE_SOURCE, &gtk_primary_selection_source_interface, wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_device_manager), 0, NULL);

	return (struct gtk_primary_selection_source *) id;
}

/**
 * @ingroup iface_gtk_primary_selection_device_manager
 *
 * Create a new data device for a given seat.
 */
static inline struct gtk_primary_selection_device *
gtk_primary_selection_device_manager_get_device(struct gtk_primary_selection_device_manager *gtk_primary_selection_device_manager, struct wl_seat *seat)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) gtk_primary_selection_device_manager,
			 GTK_PRIMARY_SELECTION_DEVICE_MANAGER_GET_DEVICE, &gtk_primary_selection_device_interface, wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_device_manager), 0, NULL, seat);

	return (struct gtk_primary_selection_device *) id;
}

/**
 * @ingroup iface_gtk_primary_selection_device_manager
 *
 * Destroy the primary selection device manager.
 */
static inline void
gtk_primary_selection_device_manager_destroy(struct gtk_primary_selection_device_manager *gtk_primary_selection_device_manager)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gtk_primary_selection_device_manager,
			 GTK_PRIMARY_SELECTION_DEVICE_MANAGER_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_device_manager), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_gtk_primary_selection_device
 * @struct gtk_primary_selection_device_listener
 */
struct gtk_primary_selection_device_listener {
	/**
	 * introduce a new wp_primary_selection_offer
	 *
	 * Introduces a new wp_primary_selection_offer object that may be
	 * used to receive the current primary selection. Immediately
	 * following this event, the new wp_primary_selection_offer object
	 * will send wp_primary_selection_offer.offer events to describe
	 * the offered mime types.
	 */
	void (*data_offer)(void *data,
			   struct gtk_primary_selection_device *gtk_primary_selection_device,
			   struct gtk_primary_selection_offer *offer);
	/**
	 * advertise a new primary selection
	 *
	 * The wp_primary_selection_device.selection event is sent to
	 * notify the client of a new primary selection. This event is sent
	 * after the wp_primary_selection.data_offer event introducing this
	 * object, and after the offer has announced its mimetypes through
	 * wp_primary_selection_offer.offer.
	 *
	 * The data_offer is valid until a new offer or NULL is received or
	 * until the client loses keyboard focus. The client must destroy
	 * the previous selection data_offer, if any, upon receiving this
	 * event.
	 */
	void (*selection)(void *data,
			  struct gtk_primary_selection_device *gtk_primary_selection_device,
			  struct gtk_primary_selection_offer *id);
};

/**
 * @ingroup iface_gtk_primary_selection_device
 */
static inline int
gtk_primary_selection_device_add_listener(struct gtk_primary_selection_device *gtk_primary_selection_device,
					  const struct gtk_primary_selection_device_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) gtk_primary_selection_device,
				     (void (**)(void)) listener, data);
}

#define GTK_PRIMARY_SELECTION_DEVICE_SET_SELECTION 0
#define GTK_PRIMARY_SELECTION_DEVICE_DESTROY 1

/**
 * @ingroup iface_gtk_primary_selection_device
 */
#define GTK_PRIMARY_SELECTION_DEVICE_DATA_OFFER_SINCE_VERSION 1
/**
 * @ingroup iface_gtk_primary_selection_device
 */
#define GTK_PRIMARY_SELECTION_DEVICE_SELECTION_SINCE_VERSION 1

/**
 * @ingroup iface_gtk_primary_selection_device
 */
#define GTK_PRIMARY_SELECTION_DEVICE_SET_SELECTION_SINCE_VERSION 1
/**
 * @ingroup iface_gtk_primary_selection_device
 */
#define GTK_PRIMARY_SELECTION_DEVICE_DESTROY_SINCE_VERSION 1

/** @ingroup iface_gtk_primary_selection_device */
static inline void
gtk_primary_selection_device_set_user_data(struct gtk_primary_selection_device *gtk_primary_selection_device, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gtk_primary_selection_device, user_data);
}

/** @ingroup iface_gtk_primary_selection_device */
static inline void *
gtk_primary_selection_device_get_user_data(struct gtk_primary_selection_device *gtk_primary_selection_device)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gtk_primary_selection_device);
}

static inline uint32_t
gtk_primary_selection_device_get_version(struct gtk_primary_selection_device *gtk_primary_selection_device)
{
	return wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_device);
}

/**
 * @ingroup iface_gtk_primary_selection_device
 *
 * Replaces the current selection. The previous owner of the primary selection
 * will receive a wp_primary_selection_source.cancelled event.
 *
 * To unset the selection, set the source to NULL.
 */
static inline void
gtk_primary_selection_device_set_selection(struct gtk_primary_selection_device *gtk_primary_selection_device, struct gtk_primary_selection_source *source, uint32_t serial)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gtk_primary_selection_device,
			 GTK_PRIMARY_SELECTION_DEVICE_SET_SELECTION, NULL, wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_device), 0, source, serial);
}

/**
 * @ingroup iface_gtk_primary_selection_device
 *
 * Destroy the primary selection device.
 */
static inline void
gtk_primary_selection_device_destroy(struct gtk_primary_selection_device *gtk_primary_selection_device)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gtk_primary_selection_device,
			 GTK_PRIMARY_SELECTION_DEVICE_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_device), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_gtk_primary_selection_offer
 * @struct gtk_primary_selection_offer_listener
 */
struct gtk_primary_selection_offer_listener {
	/**
	 * advertise offered mime type
	 *
	 * Sent immediately after creating announcing the
	 * wp_primary_selection_offer through
	 * wp_primary_selection_device.data_offer. One event is sent per
	 * offered mime type.
	 */
	void (*offer)(void *data,
		      struct gtk_primary_selection_offer *gtk_primary_selection_offer,
		      const char *mime_type);
};

/**
 * @ingroup iface_gtk_primary_selection_offer
 */
static inline int
gtk_primary_selection_offer_add_listener(struct gtk_primary_selection_offer *gtk_primary_selection_offer,
					 const struct gtk_primary_selection_offer_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) gtk_primary_selection_offer,
				     (void (**)(void)) listener, data);
}

#define GTK_PRIMARY_SELECTION_OFFER_RECEIVE 0
#define GTK_PRIMARY_SELECTION_OFFER_DESTROY 1

/**
 * @ingroup iface_gtk_primary_selection_offer
 */
#define GTK_PRIMARY_SELECTION_OFFER_OFFER_SINCE_VERSION 1

/**
 * @ingroup iface_gtk_primary_selection_offer
 */
#define GTK_PRIMARY_SELECTION_OFFER_RECEIVE_SINCE_VERSION 1
/**
 * @ingroup iface_gtk_primary_selection_offer
 */
#define GTK_PRIMARY_SELECTION_OFFER_DESTROY_SINCE_VERSION 1

/** @ingroup iface_gtk_primary_selection_offer */
static inline void
gtk_primary_selection_offer_set_user_data(struct gtk_primary_selection_offer *gtk_primary_selection_offer, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gtk_primary_selection_offer, user_data);
}

/** @ingroup iface_gtk_primary_selection_offer */
static inline void *
gtk_primary_selection_offer_get_user_data(struct gtk_primary_selection_offer *gtk_primary_selection_offer)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gtk_primary_selection_offer);
}

static inline uint32_t
gtk_primary_selection_offer_get_version(struct gtk_primary_selection_offer *gtk_primary_selection_offer)
{
	return wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_offer);
}

/**
 * @ingroup iface_gtk_primary_selection_offer
 *
 * To transfer the contents of the primary selection clipboard, the client
 * issues this request and indicates the mime type that it wants to
 * receive. The transfer happens through the passed file descriptor
 * (typically created with the pipe system call). The source client writes
 * the data in the mime type representation requested and then closes the
 * file descriptor.
 *
 * The receiving client reads from the read end of the pipe until EOF and
 * closes its end, at which point the transfer is complete.
 */
static inline void
gtk_primary_selection_offer_receive(struct gtk_primary_selection_offer *gtk_primary_selection_offer, const char *mime_type, int32_t fd)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gtk_primary_selection_offer,
			 GTK_PRIMARY_SELECTION_OFFER_RECEIVE, NULL, wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_offer), 0, mime_type, fd);
}

/**
 * @ingroup iface_gtk_primary_selection_offer
 *
 * Destroy the primary selection offer.
 */
static inline void
gtk_primary_selection_offer_destroy(struct gtk_primary_selection_offer *gtk_primary_selection_offer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gtk_primary_selection_offer,
			 GTK_PRIMARY_SELECTION_OFFER_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_offer), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_gtk_primary_selection_source
 * @struct gtk_primary_selection_source_listener
 */
struct gtk_primary_selection_source_listener {
	/**
	 * send the primary selection contents
	 *
	 * Request for the current primary selection contents from the
	 * client. Send the specified mime type over the passed file
	 * descriptor, then close it.
	 */
	void (*send)(void *data,
		     struct gtk_primary_selection_source *gtk_primary_selection_source,
		     const char *mime_type,
		     int32_t fd);
	/**
	 * request for primary selection contents was canceled
	 *
	 * This primary selection source is no longer valid. The client
	 * should clean up and destroy this primary selection source.
	 */
	void (*cancelled)(void *data,
			  struct gtk_primary_selection_source *gtk_primary_selection_source);
};

/**
 * @ingroup iface_gtk_primary_selection_source
 */
static inline int
gtk_primary_selection_source_add_listener(struct gtk_primary_selection_source *gtk_primary_selection_source,
					  const struct gtk_primary_selection_source_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) gtk_primary_selection_source,
				     (void (**)(void)) listener, data);
}

#define GTK_PRIMARY_SELECTION_SOURCE_OFFER 0
#define GTK_PRIMARY_SELECTION_SOURCE_DESTROY 1

/**
 * @ingroup iface_gtk_primary_selection_source
 */
#define GTK_PRIMARY_SELECTION_SOURCE_SEND_SINCE_VERSION 1
/**
 * @ingroup iface_gtk_primary_selection_source
 */
#define GTK_PRIMARY_SELECTION_SOURCE_CANCELLED_SINCE_VERSION 1

/**
 * @ingroup iface_gtk_primary_selection_source
 */
#define GTK_PRIMARY_SELECTION_SOURCE_OFFER_SINCE_VERSION 1
/**
 * @ingroup iface_gtk_primary_selection_source
 */
#define GTK_PRIMARY_SELECTION_SOURCE_DESTROY_SINCE_VERSION 1

/** @ingroup iface_gtk_primary_selection_source */
static inline void
gtk_primary_selection_source_set_user_data(struct gtk_primary_selection_source *gtk_primary_selection_source, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gtk_primary_selection_source, user_data);
}

/** @ingroup iface_gtk_primary_selection_source */
static inline void *
gtk_primary_selection_source_get_user_data(struct gtk_primary_selection_source *gtk_primary_selection_source)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gtk_primary_selection_source);
}

static inline uint32_t
gtk_primary_selection_source_get_version(struct gtk_primary_selection_source *gtk_primary_selection_source)
{
	return wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_source);
}

/**
 * @ingroup iface_gtk_primary_selection_source
 *
 * This request adds a mime type to the set of mime types advertised to
 * targets. Can be called several times to offer multiple types.
 */
static inline void
gtk_primary_selection_source_offer(struct gtk_primary_selection_source *gtk_primary_selection_source, const char *mime_type)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gtk_primary_selection_source,
			 GTK_PRIMARY_SELECTION_SOURCE_OFFER, NULL, wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_source), 0, mime_type);
}

/**
 * @ingroup iface_gtk_primary_selection_source
 *
 * Destroy the primary selection source.
 */
static inline void
gtk_primary_selection_source_destroy(struct gtk_primary_selection_source *gtk_primary_selection_source)
{
	wl_proxy_marshal_flags((struct wl_proxy *) gtk_primary_selection_source,
			 GTK_PRIMARY_SELECTION_SOURCE_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) gtk_primary_selection_source), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
