/* Generated by wayland-scanner 1.19.0 */

#ifndef INPUT_METHOD_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define INPUT_METHOD_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_input_method_unstable_v1 The input_method_unstable_v1 protocol
 * @section page_ifaces_input_method_unstable_v1 Interfaces
 * - @subpage page_iface_zwp_input_method_context_v1 - input method context
 * - @subpage page_iface_zwp_input_method_v1 - input method
 * - @subpage page_iface_zwp_input_panel_v1 - interface for implementing keyboards
 * - @subpage page_iface_zwp_input_panel_surface_v1 - 
 * @section page_copyright_input_method_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2012, 2013 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_keyboard;
struct wl_output;
struct wl_surface;
struct zwp_input_method_context_v1;
struct zwp_input_method_v1;
struct zwp_input_panel_surface_v1;
struct zwp_input_panel_v1;

#ifndef ZWP_INPUT_METHOD_CONTEXT_V1_INTERFACE
#define ZWP_INPUT_METHOD_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_zwp_input_method_context_v1 zwp_input_method_context_v1
 * @section page_iface_zwp_input_method_context_v1_desc Description
 *
 * Corresponds to a text input on the input method side. An input method context
 * is created on text input activation on the input method side. It allows
 * receiving information about the text input from the application via events.
 * Input method contexts do not keep state after deactivation and should be
 * destroyed after deactivation is handled.
 *
 * Text is generally UTF-8 encoded, indices and lengths are in bytes.
 *
 * Serials are used to synchronize the state between the text input and
 * an input method. New serials are sent by the text input in the
 * commit_state request and are used by the input method to indicate
 * the known text input state in events like preedit_string, commit_string,
 * and keysym. The text input can then ignore events from the input method
 * which are based on an outdated state (for example after a reset).
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 * @section page_iface_zwp_input_method_context_v1_api API
 * See @ref iface_zwp_input_method_context_v1.
 */
/**
 * @defgroup iface_zwp_input_method_context_v1 The zwp_input_method_context_v1 interface
 *
 * Corresponds to a text input on the input method side. An input method context
 * is created on text input activation on the input method side. It allows
 * receiving information about the text input from the application via events.
 * Input method contexts do not keep state after deactivation and should be
 * destroyed after deactivation is handled.
 *
 * Text is generally UTF-8 encoded, indices and lengths are in bytes.
 *
 * Serials are used to synchronize the state between the text input and
 * an input method. New serials are sent by the text input in the
 * commit_state request and are used by the input method to indicate
 * the known text input state in events like preedit_string, commit_string,
 * and keysym. The text input can then ignore events from the input method
 * which are based on an outdated state (for example after a reset).
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 */
extern const struct wl_interface zwp_input_method_context_v1_interface;
#endif
#ifndef ZWP_INPUT_METHOD_V1_INTERFACE
#define ZWP_INPUT_METHOD_V1_INTERFACE
/**
 * @page page_iface_zwp_input_method_v1 zwp_input_method_v1
 * @section page_iface_zwp_input_method_v1_desc Description
 *
 * An input method object is responsible for composing text in response to
 * input from hardware or virtual keyboards. There is one input method
 * object per seat. On activate there is a new input method context object
 * created which allows the input method to communicate with the text input.
 * @section page_iface_zwp_input_method_v1_api API
 * See @ref iface_zwp_input_method_v1.
 */
/**
 * @defgroup iface_zwp_input_method_v1 The zwp_input_method_v1 interface
 *
 * An input method object is responsible for composing text in response to
 * input from hardware or virtual keyboards. There is one input method
 * object per seat. On activate there is a new input method context object
 * created which allows the input method to communicate with the text input.
 */
extern const struct wl_interface zwp_input_method_v1_interface;
#endif
#ifndef ZWP_INPUT_PANEL_V1_INTERFACE
#define ZWP_INPUT_PANEL_V1_INTERFACE
/**
 * @page page_iface_zwp_input_panel_v1 zwp_input_panel_v1
 * @section page_iface_zwp_input_panel_v1_desc Description
 *
 * Only one client can bind this interface at a time.
 * @section page_iface_zwp_input_panel_v1_api API
 * See @ref iface_zwp_input_panel_v1.
 */
/**
 * @defgroup iface_zwp_input_panel_v1 The zwp_input_panel_v1 interface
 *
 * Only one client can bind this interface at a time.
 */
extern const struct wl_interface zwp_input_panel_v1_interface;
#endif
#ifndef ZWP_INPUT_PANEL_SURFACE_V1_INTERFACE
#define ZWP_INPUT_PANEL_SURFACE_V1_INTERFACE
/**
 * @page page_iface_zwp_input_panel_surface_v1 zwp_input_panel_surface_v1
 * @section page_iface_zwp_input_panel_surface_v1_api API
 * See @ref iface_zwp_input_panel_surface_v1.
 */
/**
 * @defgroup iface_zwp_input_panel_surface_v1 The zwp_input_panel_surface_v1 interface
 */
extern const struct wl_interface zwp_input_panel_surface_v1_interface;
#endif

/**
 * @ingroup iface_zwp_input_method_context_v1
 * @struct zwp_input_method_context_v1_listener
 */
struct zwp_input_method_context_v1_listener {
	/**
	 * surrounding text event
	 *
	 * The plain surrounding text around the input position. Cursor
	 * is the position in bytes within the surrounding text relative to
	 * the beginning of the text. Anchor is the position in bytes of
	 * the selection anchor within the surrounding text relative to the
	 * beginning of the text. If there is no selected text then anchor
	 * is the same as cursor.
	 */
	void (*surrounding_text)(void *data,
				 struct zwp_input_method_context_v1 *zwp_input_method_context_v1,
				 const char *text,
				 uint32_t cursor,
				 uint32_t anchor);
	/**
	 */
	void (*reset)(void *data,
		      struct zwp_input_method_context_v1 *zwp_input_method_context_v1);
	/**
	 */
	void (*content_type)(void *data,
			     struct zwp_input_method_context_v1 *zwp_input_method_context_v1,
			     uint32_t hint,
			     uint32_t purpose);
	/**
	 */
	void (*invoke_action)(void *data,
			      struct zwp_input_method_context_v1 *zwp_input_method_context_v1,
			      uint32_t button,
			      uint32_t index);
	/**
	 * @param serial serial of text input state
	 */
	void (*commit_state)(void *data,
			     struct zwp_input_method_context_v1 *zwp_input_method_context_v1,
			     uint32_t serial);
	/**
	 */
	void (*preferred_language)(void *data,
				   struct zwp_input_method_context_v1 *zwp_input_method_context_v1,
				   const char *language);
};

/**
 * @ingroup iface_zwp_input_method_context_v1
 */
static inline int
zwp_input_method_context_v1_add_listener(struct zwp_input_method_context_v1 *zwp_input_method_context_v1,
					 const struct zwp_input_method_context_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_input_method_context_v1,
				     (void (**)(void)) listener, data);
}

#define ZWP_INPUT_METHOD_CONTEXT_V1_DESTROY 0
#define ZWP_INPUT_METHOD_CONTEXT_V1_COMMIT_STRING 1
#define ZWP_INPUT_METHOD_CONTEXT_V1_PREEDIT_STRING 2
#define ZWP_INPUT_METHOD_CONTEXT_V1_PREEDIT_STYLING 3
#define ZWP_INPUT_METHOD_CONTEXT_V1_PREEDIT_CURSOR 4
#define ZWP_INPUT_METHOD_CONTEXT_V1_DELETE_SURROUNDING_TEXT 5
#define ZWP_INPUT_METHOD_CONTEXT_V1_CURSOR_POSITION 6
#define ZWP_INPUT_METHOD_CONTEXT_V1_MODIFIERS_MAP 7
#define ZWP_INPUT_METHOD_CONTEXT_V1_KEYSYM 8
#define ZWP_INPUT_METHOD_CONTEXT_V1_GRAB_KEYBOARD 9
#define ZWP_INPUT_METHOD_CONTEXT_V1_KEY 10
#define ZWP_INPUT_METHOD_CONTEXT_V1_MODIFIERS 11
#define ZWP_INPUT_METHOD_CONTEXT_V1_LANGUAGE 12
#define ZWP_INPUT_METHOD_CONTEXT_V1_TEXT_DIRECTION 13

/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_SURROUNDING_TEXT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_RESET_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_CONTENT_TYPE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_INVOKE_ACTION_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_COMMIT_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_PREFERRED_LANGUAGE_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_COMMIT_STRING_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_PREEDIT_STRING_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_PREEDIT_STYLING_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_PREEDIT_CURSOR_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_DELETE_SURROUNDING_TEXT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_CURSOR_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_MODIFIERS_MAP_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_KEYSYM_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_GRAB_KEYBOARD_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_KEY_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_MODIFIERS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_LANGUAGE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_context_v1
 */
#define ZWP_INPUT_METHOD_CONTEXT_V1_TEXT_DIRECTION_SINCE_VERSION 1

/** @ingroup iface_zwp_input_method_context_v1 */
static inline void
zwp_input_method_context_v1_set_user_data(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_input_method_context_v1, user_data);
}

/** @ingroup iface_zwp_input_method_context_v1 */
static inline void *
zwp_input_method_context_v1_get_user_data(struct zwp_input_method_context_v1 *zwp_input_method_context_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_input_method_context_v1);
}

static inline uint32_t
zwp_input_method_context_v1_get_version(struct zwp_input_method_context_v1 *zwp_input_method_context_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_input_method_context_v1);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 */
static inline void
zwp_input_method_context_v1_destroy(struct zwp_input_method_context_v1 *zwp_input_method_context_v1)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_DESTROY);

	wl_proxy_destroy((struct wl_proxy *) zwp_input_method_context_v1);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 *
 * Send the commit string text for insertion to the application.
 *
 * The text to commit could be either just a single character after a key
 * press or the result of some composing (pre-edit). It could be also an
 * empty text when some text should be removed (see
 * delete_surrounding_text) or when the input cursor should be moved (see
 * cursor_position).
 *
 * Any previously set composing text will be removed.
 */
static inline void
zwp_input_method_context_v1_commit_string(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, uint32_t serial, const char *text)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_COMMIT_STRING, serial, text);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 *
 * Send the pre-edit string text to the application text input.
 *
 * The commit text can be used to replace the pre-edit text on reset (for
 * example on unfocus).
 *
 * Previously sent preedit_style and preedit_cursor requests are also
 * processed by the text_input.
 */
static inline void
zwp_input_method_context_v1_preedit_string(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, uint32_t serial, const char *text, const char *commit)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_PREEDIT_STRING, serial, text, commit);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 *
 * Set the styling information on composing text. The style is applied for
 * length in bytes from index relative to the beginning of
 * the composing text (as byte offset). Multiple styles can
 * be applied to a composing text.
 *
 * This request should be sent before sending a preedit_string request.
 */
static inline void
zwp_input_method_context_v1_preedit_styling(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, uint32_t index, uint32_t length, uint32_t style)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_PREEDIT_STYLING, index, length, style);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 *
 * Set the cursor position inside the composing text (as byte offset)
 * relative to the start of the composing text.
 *
 * When index is negative no cursor should be displayed.
 *
 * This request should be sent before sending a preedit_string request.
 */
static inline void
zwp_input_method_context_v1_preedit_cursor(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, int32_t index)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_PREEDIT_CURSOR, index);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 *
 * Remove the surrounding text.
 *
 * This request will be handled on the text_input side directly following
 * a commit_string request.
 */
static inline void
zwp_input_method_context_v1_delete_surrounding_text(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, int32_t index, uint32_t length)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_DELETE_SURROUNDING_TEXT, index, length);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 *
 * Set the cursor and anchor to a new position. Index is the new cursor
 * position in bytes (when >= 0 this is relative to the end of the inserted text,
 * otherwise it is relative to the beginning of the inserted text). Anchor is
 * the new anchor position in bytes (when >= 0 this is relative to the end of the
 * inserted text, otherwise it is relative to the beginning of the inserted
 * text). When there should be no selected text, anchor should be the same
 * as index.
 *
 * This request will be handled on the text_input side directly following
 * a commit_string request.
 */
static inline void
zwp_input_method_context_v1_cursor_position(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, int32_t index, int32_t anchor)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_CURSOR_POSITION, index, anchor);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 */
static inline void
zwp_input_method_context_v1_modifiers_map(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, struct wl_array *map)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_MODIFIERS_MAP, map);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 *
 * Notify when a key event was sent. Key events should not be used for
 * normal text input operations, which should be done with commit_string,
 * delete_surrounding_text, etc. The key event follows the wl_keyboard key
 * event convention. Sym is an XKB keysym, state is a wl_keyboard key_state.
 */
static inline void
zwp_input_method_context_v1_keysym(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, uint32_t serial, uint32_t time, uint32_t sym, uint32_t state, uint32_t modifiers)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_KEYSYM, serial, time, sym, state, modifiers);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 *
 * Allow an input method to receive hardware keyboard input and process
 * key events to generate text events (with pre-edit) over the wire. This
 * allows input methods which compose multiple key events for inputting
 * text like it is done for CJK languages.
 */
static inline struct wl_keyboard *
zwp_input_method_context_v1_grab_keyboard(struct zwp_input_method_context_v1 *zwp_input_method_context_v1)
{
	struct wl_proxy *keyboard;

	keyboard = wl_proxy_marshal_constructor((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_GRAB_KEYBOARD, &wl_keyboard_interface, NULL);

	return (struct wl_keyboard *) keyboard;
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 *
 * Forward a wl_keyboard::key event to the client that was not processed
 * by the input method itself. Should be used when filtering key events
 * with grab_keyboard.  The arguments should be the ones from the
 * wl_keyboard::key event.
 *
 * For generating custom key events use the keysym request instead.
 */
static inline void
zwp_input_method_context_v1_key(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, uint32_t serial, uint32_t time, uint32_t key, uint32_t state)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_KEY, serial, time, key, state);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 *
 * Forward a wl_keyboard::modifiers event to the client that was not
 * processed by the input method itself.  Should be used when filtering
 * key events with grab_keyboard. The arguments should be the ones
 * from the wl_keyboard::modifiers event.
 */
static inline void
zwp_input_method_context_v1_modifiers(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_MODIFIERS, serial, mods_depressed, mods_latched, mods_locked, group);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 */
static inline void
zwp_input_method_context_v1_language(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, uint32_t serial, const char *language)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_LANGUAGE, serial, language);
}

/**
 * @ingroup iface_zwp_input_method_context_v1
 */
static inline void
zwp_input_method_context_v1_text_direction(struct zwp_input_method_context_v1 *zwp_input_method_context_v1, uint32_t serial, uint32_t direction)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_method_context_v1,
			 ZWP_INPUT_METHOD_CONTEXT_V1_TEXT_DIRECTION, serial, direction);
}

/**
 * @ingroup iface_zwp_input_method_v1
 * @struct zwp_input_method_v1_listener
 */
struct zwp_input_method_v1_listener {
	/**
	 * activate event
	 *
	 * A text input was activated. Creates an input method context
	 * object which allows communication with the text input.
	 */
	void (*activate)(void *data,
			 struct zwp_input_method_v1 *zwp_input_method_v1,
			 struct zwp_input_method_context_v1 *id);
	/**
	 * deactivate event
	 *
	 * The text input corresponding to the context argument was
	 * deactivated. The input method context should be destroyed after
	 * deactivation is handled.
	 */
	void (*deactivate)(void *data,
			   struct zwp_input_method_v1 *zwp_input_method_v1,
			   struct zwp_input_method_context_v1 *context);
};

/**
 * @ingroup iface_zwp_input_method_v1
 */
static inline int
zwp_input_method_v1_add_listener(struct zwp_input_method_v1 *zwp_input_method_v1,
				 const struct zwp_input_method_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_input_method_v1,
				     (void (**)(void)) listener, data);
}

/**
 * @ingroup iface_zwp_input_method_v1
 */
#define ZWP_INPUT_METHOD_V1_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_method_v1
 */
#define ZWP_INPUT_METHOD_V1_DEACTIVATE_SINCE_VERSION 1


/** @ingroup iface_zwp_input_method_v1 */
static inline void
zwp_input_method_v1_set_user_data(struct zwp_input_method_v1 *zwp_input_method_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_input_method_v1, user_data);
}

/** @ingroup iface_zwp_input_method_v1 */
static inline void *
zwp_input_method_v1_get_user_data(struct zwp_input_method_v1 *zwp_input_method_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_input_method_v1);
}

static inline uint32_t
zwp_input_method_v1_get_version(struct zwp_input_method_v1 *zwp_input_method_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_input_method_v1);
}

/** @ingroup iface_zwp_input_method_v1 */
static inline void
zwp_input_method_v1_destroy(struct zwp_input_method_v1 *zwp_input_method_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwp_input_method_v1);
}

#define ZWP_INPUT_PANEL_V1_GET_INPUT_PANEL_SURFACE 0


/**
 * @ingroup iface_zwp_input_panel_v1
 */
#define ZWP_INPUT_PANEL_V1_GET_INPUT_PANEL_SURFACE_SINCE_VERSION 1

/** @ingroup iface_zwp_input_panel_v1 */
static inline void
zwp_input_panel_v1_set_user_data(struct zwp_input_panel_v1 *zwp_input_panel_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_input_panel_v1, user_data);
}

/** @ingroup iface_zwp_input_panel_v1 */
static inline void *
zwp_input_panel_v1_get_user_data(struct zwp_input_panel_v1 *zwp_input_panel_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_input_panel_v1);
}

static inline uint32_t
zwp_input_panel_v1_get_version(struct zwp_input_panel_v1 *zwp_input_panel_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_input_panel_v1);
}

/** @ingroup iface_zwp_input_panel_v1 */
static inline void
zwp_input_panel_v1_destroy(struct zwp_input_panel_v1 *zwp_input_panel_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwp_input_panel_v1);
}

/**
 * @ingroup iface_zwp_input_panel_v1
 */
static inline struct zwp_input_panel_surface_v1 *
zwp_input_panel_v1_get_input_panel_surface(struct zwp_input_panel_v1 *zwp_input_panel_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_constructor((struct wl_proxy *) zwp_input_panel_v1,
			 ZWP_INPUT_PANEL_V1_GET_INPUT_PANEL_SURFACE, &zwp_input_panel_surface_v1_interface, NULL, surface);

	return (struct zwp_input_panel_surface_v1 *) id;
}

#ifndef ZWP_INPUT_PANEL_SURFACE_V1_POSITION_ENUM
#define ZWP_INPUT_PANEL_SURFACE_V1_POSITION_ENUM
enum zwp_input_panel_surface_v1_position {
	ZWP_INPUT_PANEL_SURFACE_V1_POSITION_CENTER_BOTTOM = 0,
};
#endif /* ZWP_INPUT_PANEL_SURFACE_V1_POSITION_ENUM */

#define ZWP_INPUT_PANEL_SURFACE_V1_SET_TOPLEVEL 0
#define ZWP_INPUT_PANEL_SURFACE_V1_SET_OVERLAY_PANEL 1


/**
 * @ingroup iface_zwp_input_panel_surface_v1
 */
#define ZWP_INPUT_PANEL_SURFACE_V1_SET_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_input_panel_surface_v1
 */
#define ZWP_INPUT_PANEL_SURFACE_V1_SET_OVERLAY_PANEL_SINCE_VERSION 1

/** @ingroup iface_zwp_input_panel_surface_v1 */
static inline void
zwp_input_panel_surface_v1_set_user_data(struct zwp_input_panel_surface_v1 *zwp_input_panel_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_input_panel_surface_v1, user_data);
}

/** @ingroup iface_zwp_input_panel_surface_v1 */
static inline void *
zwp_input_panel_surface_v1_get_user_data(struct zwp_input_panel_surface_v1 *zwp_input_panel_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_input_panel_surface_v1);
}

static inline uint32_t
zwp_input_panel_surface_v1_get_version(struct zwp_input_panel_surface_v1 *zwp_input_panel_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_input_panel_surface_v1);
}

/** @ingroup iface_zwp_input_panel_surface_v1 */
static inline void
zwp_input_panel_surface_v1_destroy(struct zwp_input_panel_surface_v1 *zwp_input_panel_surface_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zwp_input_panel_surface_v1);
}

/**
 * @ingroup iface_zwp_input_panel_surface_v1
 *
 * Set the input_panel_surface type to keyboard.
 *
 * A keyboard surface is only shown when a text input is active.
 */
static inline void
zwp_input_panel_surface_v1_set_toplevel(struct zwp_input_panel_surface_v1 *zwp_input_panel_surface_v1, struct wl_output *output, uint32_t position)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_panel_surface_v1,
			 ZWP_INPUT_PANEL_SURFACE_V1_SET_TOPLEVEL, output, position);
}

/**
 * @ingroup iface_zwp_input_panel_surface_v1
 *
 * Set the input_panel_surface to be an overlay panel.
 *
 * This is shown near the input cursor above the application window when
 * a text input is active.
 */
static inline void
zwp_input_panel_surface_v1_set_overlay_panel(struct zwp_input_panel_surface_v1 *zwp_input_panel_surface_v1)
{
	wl_proxy_marshal((struct wl_proxy *) zwp_input_panel_surface_v1,
			 ZWP_INPUT_PANEL_SURFACE_V1_SET_OVERLAY_PANEL);
}

#ifdef  __cplusplus
}
#endif

#endif
