/******************************************************************************
*
* Copyright (C) 2008-2022 Allegro DVT2.  All rights reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* Use of the Software is limited solely to applications:
* (a) running on a Xilinx device, or
* (b) that interact with a Xilinx device through a bus or interconnect.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* XILINX OR ALLEGRO DVT2 BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
* OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*
* Except as contained in this notice, the name of  Xilinx shall not be used
* in advertising or otherwise to promote the sale, use or other dealings in
* this Software without prior written authorization from Xilinx.
*
*
* Except as contained in this notice, the name of Allegro DVT2 shall not be used
* in advertising or otherwise to promote the sale, use or other dealings in
* this Software without prior written authorization from Allegro DVT2.
*
******************************************************************************/

/**************************************************************************//*!
   \addtogroup FourCC
   @{
   \file
 *****************************************************************************/

#pragma once
#include "lib_common/FourCC.h"

/*************************************************************************//*!
   \brief Returns the FOURCC identifier of the framebuffer the encoder is expecting
   according to the chosen encoding chroma mode, bitdepth and storage mode.
   \param[in] picFmt source picture format
   \return Returns the corresponding TFourCC format
*****************************************************************************/
TFourCC AL_EncGetSrcFourCC(AL_TPicFormat const picFmt);

/*************************************************************************//*!
   \brief Returns the TPicFormat of the framebuffer the encoder is expecting
   according to the chosen encoding chroma mode, bitdepth, storage and compression mode.
   \param[in] eChromaMode source picture chroma mode
   \param[in] uBitDepth source picture bit depth
   \param[in] eStorageMode source picture storage mode
   \param[in] bIsCompressed true if source picture is compressed, false otherwise
   \return Returns the corresponding TPicFormat
*****************************************************************************/
AL_TPicFormat AL_EncGetSrcPicFormat(AL_EChromaMode eChromaMode, uint8_t uBitDepth, AL_EFbStorageMode eStorageMode, bool bIsCompressed);

/*************************************************************************//*!
   \brief Returns the FOURCC identifier of the reconstructed frame buffer
   generated by the encoder according to the chosen decoded chroma mode, bitdepth
   and storage mode.
   \param[in] picFmt reconstructed picture format
   \return Returns the corresponding TFourCC format
*****************************************************************************/
TFourCC AL_GetRecFourCC(AL_TPicFormat const picFmt);

/*************************************************************************//*!
   \brief Returns the TPicFormat of the reconstructed frame buffer
   according to the chosen encoding chroma mode, bitdepth, and compression mode.
   \param[in] eChromaMode reconstructed picture chroma mode
   \param[in] uBitDepth reconstructed picture bit depth
   \param[in] bIsCompressed true if reconstructed picture is compressed, false otherwise
   \return Returns the corresponding TPicFormat
*****************************************************************************/
AL_TPicFormat AL_EncGetRecPicFormat(AL_EChromaMode eChromaMode, uint8_t uBitDepth, bool bIsCompressed);

/*@}*/

