/* This file is autogenerated by tracetool, do not edit. */

#ifndef TRACE__GENERATED_TRACERS_H
#define TRACE__GENERATED_TRACERS_H

#include "qemu-common.h"
#include "trace/control.h"

#include "trace/control.h"
#include "qemu/log.h"


static inline void trace_thread_pool_submit(void * pool, void * req, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_THREAD_POOL_SUBMIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:thread_pool_submit " "pool %p req %p opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pool, req, opaque);
        }
    }
}

static inline void trace_thread_pool_complete(void * pool, void * req, void * opaque, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_THREAD_POOL_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:thread_pool_complete " "pool %p req %p opaque %p ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pool, req, opaque, ret);
        }
    }
}

static inline void trace_thread_pool_cancel(void * req, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_THREAD_POOL_CANCEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:thread_pool_cancel " "req %p opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, opaque);
        }
    }
}

static inline void trace_cpu_in(unsigned int addr, char size, unsigned int val)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_IN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_in " "addr %#x(%c) value %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, size, val);
        }
    }
}

static inline void trace_cpu_out(unsigned int addr, char size, unsigned int val)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_OUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_out " "addr %#x(%c) value %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, size, val);
        }
    }
}

static inline void trace_balloon_event(void * opaque, unsigned long addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_BALLOON_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:balloon_event " "opaque %p addr %lu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr);
        }
    }
}

static inline void trace_virtio_balloon_handle_output(const char * name, uint64_t gpa)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BALLOON_HANDLE_OUTPUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_balloon_handle_output " "section name: %s gpa: %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, gpa);
        }
    }
}

static inline void trace_virtio_balloon_get_config(uint32_t num_pages, uint32_t actual)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BALLOON_GET_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_balloon_get_config " "num_pages: %d actual: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , num_pages, actual);
        }
    }
}

static inline void trace_virtio_balloon_set_config(uint32_t actual, uint32_t oldactual)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BALLOON_SET_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_balloon_set_config " "actual: %d oldactual: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , actual, oldactual);
        }
    }
}

static inline void trace_virtio_balloon_to_target(uint64_t target, uint32_t num_pages)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BALLOON_TO_TARGET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_balloon_to_target " "balloon target: %"PRIx64" num_pages: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, num_pages);
        }
    }
}

static inline void trace_vm_state_notify(int running, int reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_VM_STATE_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vm_state_notify " "running %d reason %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , running, reason);
        }
    }
}

static inline void trace_load_file(const char * name, const char * path)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOAD_FILE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:load_file " "name %s location %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, path);
        }
    }
}

static inline void trace_runstate_set(int new_state)
{
    if (true) {
        if (trace_event_get_state(TRACE_RUNSTATE_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:runstate_set " "new state %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , new_state);
        }
    }
}

static inline void trace_system_wakeup_request(int reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_SYSTEM_WAKEUP_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:system_wakeup_request " "reason=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reason);
        }
    }
}

static inline void trace_qemu_system_shutdown_request(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SYSTEM_SHUTDOWN_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_system_shutdown_request " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_system_powerdown_request(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SYSTEM_POWERDOWN_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_system_powerdown_request " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_spice_vmc_write(ssize_t out, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPICE_VMC_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spice_vmc_write " "spice wrottn %zd of requested %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , out, len);
        }
    }
}

static inline void trace_spice_vmc_read(int bytes, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPICE_VMC_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spice_vmc_read " "spice read %d of requested %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bytes, len);
        }
    }
}

static inline void trace_spice_vmc_register_interface(void * scd)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPICE_VMC_REGISTER_INTERFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spice_vmc_register_interface " "spice vmc registered interface %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , scd);
        }
    }
}

static inline void trace_spice_vmc_unregister_interface(void * scd)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPICE_VMC_UNREGISTER_INTERFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spice_vmc_unregister_interface " "spice vmc unregistered interface %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , scd);
        }
    }
}

static inline void trace_spice_vmc_event(int event)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPICE_VMC_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spice_vmc_event " "spice vmc event %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event);
        }
    }
}

static inline void trace_xen_ram_alloc(unsigned long ram_addr, unsigned long size)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_RAM_ALLOC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_ram_alloc " "requested: %#lx, size %#lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ram_addr, size);
        }
    }
}

static inline void trace_xen_client_set_memory(uint64_t start_addr, unsigned long size, bool log_dirty)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_CLIENT_SET_MEMORY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_client_set_memory " "%#"PRIx64" size %#lx, log_dirty %i" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start_addr, size, log_dirty);
        }
    }
}

static inline void trace_xen_default_ioreq_server(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_DEFAULT_IOREQ_SERVER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_default_ioreq_server " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_xen_ioreq_server_create(uint32_t id)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_IOREQ_SERVER_CREATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_ioreq_server_create " "id: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id);
        }
    }
}

static inline void trace_xen_ioreq_server_destroy(uint32_t id)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_IOREQ_SERVER_DESTROY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_ioreq_server_destroy " "id: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id);
        }
    }
}

static inline void trace_xen_ioreq_server_state(uint32_t id, bool enable)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_IOREQ_SERVER_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_ioreq_server_state " "id: %u: enable: %i" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, enable);
        }
    }
}

static inline void trace_xen_map_mmio_range(uint32_t id, uint64_t start_addr, uint64_t end_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_MAP_MMIO_RANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_map_mmio_range " "id: %u start: %#"PRIx64" end: %#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, start_addr, end_addr);
        }
    }
}

static inline void trace_xen_unmap_mmio_range(uint32_t id, uint64_t start_addr, uint64_t end_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_UNMAP_MMIO_RANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_unmap_mmio_range " "id: %u start: %#"PRIx64" end: %#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, start_addr, end_addr);
        }
    }
}

static inline void trace_xen_map_portio_range(uint32_t id, uint64_t start_addr, uint64_t end_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_MAP_PORTIO_RANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_map_portio_range " "id: %u start: %#"PRIx64" end: %#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, start_addr, end_addr);
        }
    }
}

static inline void trace_xen_unmap_portio_range(uint32_t id, uint64_t start_addr, uint64_t end_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_UNMAP_PORTIO_RANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_unmap_portio_range " "id: %u start: %#"PRIx64" end: %#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, start_addr, end_addr);
        }
    }
}

static inline void trace_xen_map_pcidev(uint32_t id, uint8_t bus, uint8_t dev, uint8_t func)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_MAP_PCIDEV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_map_pcidev " "id: %u bdf: %02x.%02x.%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, bus, dev, func);
        }
    }
}

static inline void trace_xen_unmap_pcidev(uint32_t id, uint8_t bus, uint8_t dev, uint8_t func)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_UNMAP_PCIDEV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_unmap_pcidev " "id: %u bdf: %02x.%02x.%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, bus, dev, func);
        }
    }
}

static inline void trace_handle_ioreq(void * req, uint32_t type, uint32_t dir, uint32_t df, uint32_t data_is_ptr, uint64_t addr, uint64_t data, uint32_t count, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_HANDLE_IOREQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:handle_ioreq " "I/O=%p type=%d dir=%d df=%d ptr=%d port=%#"PRIx64" data=%#"PRIx64" count=%d size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, type, dir, df, data_is_ptr, addr, data, count, size);
        }
    }
}

static inline void trace_handle_ioreq_read(void * req, uint32_t type, uint32_t df, uint32_t data_is_ptr, uint64_t addr, uint64_t data, uint32_t count, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_HANDLE_IOREQ_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:handle_ioreq_read " "I/O=%p read type=%d df=%d ptr=%d port=%#"PRIx64" data=%#"PRIx64" count=%d size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, type, df, data_is_ptr, addr, data, count, size);
        }
    }
}

static inline void trace_handle_ioreq_write(void * req, uint32_t type, uint32_t df, uint32_t data_is_ptr, uint64_t addr, uint64_t data, uint32_t count, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_HANDLE_IOREQ_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:handle_ioreq_write " "I/O=%p write type=%d df=%d ptr=%d port=%#"PRIx64" data=%#"PRIx64" count=%d size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, type, df, data_is_ptr, addr, data, count, size);
        }
    }
}

static inline void trace_cpu_ioreq_pio(void * req, uint32_t dir, uint32_t df, uint32_t data_is_ptr, uint64_t addr, uint64_t data, uint32_t count, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_IOREQ_PIO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_ioreq_pio " "I/O=%p pio dir=%d df=%d ptr=%d port=%#"PRIx64" data=%#"PRIx64" count=%d size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, dir, df, data_is_ptr, addr, data, count, size);
        }
    }
}

static inline void trace_cpu_ioreq_pio_read_reg(void * req, uint64_t data, uint64_t addr, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_IOREQ_PIO_READ_REG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_ioreq_pio_read_reg " "I/O=%p pio read reg data=%#"PRIx64" port=%#"PRIx64" size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, data, addr, size);
        }
    }
}

static inline void trace_cpu_ioreq_pio_write_reg(void * req, uint64_t data, uint64_t addr, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_IOREQ_PIO_WRITE_REG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_ioreq_pio_write_reg " "I/O=%p pio write reg data=%#"PRIx64" port=%#"PRIx64" size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, data, addr, size);
        }
    }
}

static inline void trace_cpu_ioreq_move(void * req, uint32_t dir, uint32_t df, uint32_t data_is_ptr, uint64_t addr, uint64_t data, uint32_t count, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_IOREQ_MOVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_ioreq_move " "I/O=%p copy dir=%d df=%d ptr=%d port=%#"PRIx64" data=%#"PRIx64" count=%d size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, dir, df, data_is_ptr, addr, data, count, size);
        }
    }
}

static inline void trace_xen_map_cache(uint64_t phys_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_MAP_CACHE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_map_cache " "want %#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , phys_addr);
        }
    }
}

static inline void trace_xen_remap_bucket(uint64_t index)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_REMAP_BUCKET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_remap_bucket " "index %#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_xen_map_cache_return(void* ptr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_MAP_CACHE_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_map_cache_return " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ptr);
        }
    }
}

static inline void trace_qemu_coroutine_enter(void * from, void * to, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_COROUTINE_ENTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_coroutine_enter " "from %p to %p opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , from, to, opaque);
        }
    }
}

static inline void trace_qemu_coroutine_yield(void * from, void * to)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_COROUTINE_YIELD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_coroutine_yield " "from %p to %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , from, to);
        }
    }
}

static inline void trace_qemu_coroutine_terminate(void * co)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_COROUTINE_TERMINATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_coroutine_terminate " "self %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co);
        }
    }
}

static inline void trace_qemu_co_queue_run_restart(void * co)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_CO_QUEUE_RUN_RESTART)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_co_queue_run_restart " "co %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co);
        }
    }
}

static inline void trace_qemu_co_queue_next(void * nxt)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_CO_QUEUE_NEXT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_co_queue_next " "next %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nxt);
        }
    }
}

static inline void trace_qemu_co_mutex_lock_entry(void * mutex, void * self)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_CO_MUTEX_LOCK_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_co_mutex_lock_entry " "mutex %p self %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , mutex, self);
        }
    }
}

static inline void trace_qemu_co_mutex_lock_return(void * mutex, void * self)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_CO_MUTEX_LOCK_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_co_mutex_lock_return " "mutex %p self %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , mutex, self);
        }
    }
}

static inline void trace_qemu_co_mutex_unlock_entry(void * mutex, void * self)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_CO_MUTEX_UNLOCK_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_co_mutex_unlock_entry " "mutex %p self %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , mutex, self);
        }
    }
}

static inline void trace_qemu_co_mutex_unlock_return(void * mutex, void * self)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_CO_MUTEX_UNLOCK_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_co_mutex_unlock_return " "mutex %p self %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , mutex, self);
        }
    }
}

static inline void trace_handle_qmp_command(void * mon, const char * cmd_name)
{
    if (true) {
        if (trace_event_get_state(TRACE_HANDLE_QMP_COMMAND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:handle_qmp_command " "mon %p cmd_name \"%s\"" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , mon, cmd_name);
        }
    }
}

static inline void trace_monitor_protocol_emitter(void * mon)
{
    if (true) {
        if (trace_event_get_state(TRACE_MONITOR_PROTOCOL_EMITTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:monitor_protocol_emitter " "mon %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , mon);
        }
    }
}

static inline void trace_monitor_protocol_event_handler(uint32_t event, void * qdict)
{
    if (true) {
        if (trace_event_get_state(TRACE_MONITOR_PROTOCOL_EVENT_HANDLER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:monitor_protocol_event_handler " "event=%d data=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event, qdict);
        }
    }
}

static inline void trace_monitor_protocol_event_emit(uint32_t event, void * data)
{
    if (true) {
        if (trace_event_get_state(TRACE_MONITOR_PROTOCOL_EVENT_EMIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:monitor_protocol_event_emit " "event=%d data=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event, data);
        }
    }
}

static inline void trace_monitor_protocol_event_queue(uint32_t event, void * qdict, uint64_t rate)
{
    if (true) {
        if (trace_event_get_state(TRACE_MONITOR_PROTOCOL_EVENT_QUEUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:monitor_protocol_event_queue " "event=%d data=%p rate=%" PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event, qdict, rate);
        }
    }
}

static inline void trace_monitor_protocol_event_throttle(uint32_t event, uint64_t rate)
{
    if (true) {
        if (trace_event_get_state(TRACE_MONITOR_PROTOCOL_EVENT_THROTTLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:monitor_protocol_event_throttle " "event=%d rate=%" PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event, rate);
        }
    }
}

static inline void trace_dma_blk_io(void * dbs, void * bs, int64_t offset, bool to_dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_DMA_BLK_IO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:dma_blk_io " "dbs=%p bs=%p offset=%" PRId64 " to_dev=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dbs, bs, offset, to_dev);
        }
    }
}

static inline void trace_dma_aio_cancel(void * dbs)
{
    if (true) {
        if (trace_event_get_state(TRACE_DMA_AIO_CANCEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:dma_aio_cancel " "dbs=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dbs);
        }
    }
}

static inline void trace_dma_complete(void * dbs, int ret, void * cb)
{
    if (true) {
        if (trace_event_get_state(TRACE_DMA_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:dma_complete " "dbs=%p ret=%d cb=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dbs, ret, cb);
        }
    }
}

static inline void trace_dma_blk_cb(void * dbs, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_DMA_BLK_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:dma_blk_cb " "dbs=%p ret=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dbs, ret);
        }
    }
}

static inline void trace_dma_map_wait(void * dbs)
{
    if (true) {
        if (trace_event_get_state(TRACE_DMA_MAP_WAIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:dma_map_wait " "dbs=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dbs);
        }
    }
}

static inline void trace_kvm_ioctl(int type, void * arg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_IOCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_ioctl " "type 0x%x, arg %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , type, arg);
        }
    }
}

static inline void trace_kvm_vm_ioctl(int type, void * arg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_VM_IOCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_vm_ioctl " "type 0x%x, arg %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , type, arg);
        }
    }
}

static inline void trace_kvm_vcpu_ioctl(int cpu_index, int type, void * arg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_VCPU_IOCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_vcpu_ioctl " "cpu_index %d, type 0x%x, arg %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, type, arg);
        }
    }
}

static inline void trace_kvm_run_exit(int cpu_index, uint32_t reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_RUN_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_run_exit " "cpu_index %d, reason %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, reason);
        }
    }
}

static inline void trace_kvm_device_ioctl(int fd, int type, void * arg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_DEVICE_IOCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_device_ioctl " "dev fd %d, type 0x%x, arg %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fd, type, arg);
        }
    }
}

static inline void trace_kvm_failed_reg_get(uint64_t id, const char * msg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_FAILED_REG_GET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_failed_reg_get " "Warning: Unable to retrieve ONEREG %" PRIu64 " from KVM: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, msg);
        }
    }
}

static inline void trace_kvm_failed_reg_set(uint64_t id, const char * msg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_FAILED_REG_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_failed_reg_set " "Warning: Unable to set ONEREG %" PRIu64 " to KVM: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, msg);
        }
    }
}

static inline void trace_kvm_irqchip_commit_routes(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_IRQCHIP_COMMIT_ROUTES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_irqchip_commit_routes " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_kvm_irqchip_add_msi_route(int virq)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_IRQCHIP_ADD_MSI_ROUTE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_irqchip_add_msi_route " "Adding MSI route virq=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , virq);
        }
    }
}

static inline void trace_kvm_irqchip_update_msi_route(int virq)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_IRQCHIP_UPDATE_MSI_ROUTE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_irqchip_update_msi_route " "Updating MSI route virq=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , virq);
        }
    }
}

static inline void trace_exec_tb(void * tb, uintptr_t pc)
{
    if (true) {
    }
}

static inline void trace_exec_tb_nocache(void * tb, uintptr_t pc)
{
    if (true) {
    }
}

static inline void trace_exec_tb_exit(void * last_tb, unsigned int flags)
{
    if (true) {
    }
}

static inline void trace_translate_block(void * tb, uintptr_t pc, uint8_t * tb_code)
{
    if (true) {
        if (trace_event_get_state(TRACE_TRANSLATE_BLOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:translate_block " "tb:%p, pc:0x%"PRIxPTR", tb_code:%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tb, pc, tb_code);
        }
    }
}

static inline void trace_memory_region_ops_read(int cpu_index, void * mr, uint64_t addr, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_OPS_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_ops_read " "cpu %d mr %p addr %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, mr, addr, value, size);
        }
    }
}

static inline void trace_memory_region_ops_write(int cpu_index, void * mr, uint64_t addr, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_OPS_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_ops_write " "cpu %d mr %p addr %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, mr, addr, value, size);
        }
    }
}

static inline void trace_memory_region_subpage_read(int cpu_index, void * mr, uint64_t offset, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_SUBPAGE_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_subpage_read " "cpu %d mr %p offset %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, mr, offset, value, size);
        }
    }
}

static inline void trace_memory_region_subpage_write(int cpu_index, void * mr, uint64_t offset, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_SUBPAGE_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_subpage_write " "cpu %d mr %p offset %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, mr, offset, value, size);
        }
    }
}

static inline void trace_memory_region_tb_read(int cpu_index, uint64_t addr, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_TB_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_tb_read " "cpu %d addr %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, addr, value, size);
        }
    }
}

static inline void trace_memory_region_tb_write(int cpu_index, uint64_t addr, uint64_t value, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEMORY_REGION_TB_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:memory_region_tb_write " "cpu %d addr %#"PRIx64" value %#"PRIx64" size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, addr, value, size);
        }
    }
}

static inline void trace_guest_mem_before_trans(CPUState * __cpu, uint8_t info)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_MEM_BEFORE_TRANS, TRACE_VCPU_GUEST_MEM_BEFORE_TRANS)) {
    }
}

static inline void trace_guest_mem_before_exec(CPUState * __cpu, uint64_t vaddr, uint8_t info)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_MEM_BEFORE_EXEC, TRACE_VCPU_GUEST_MEM_BEFORE_EXEC)) {
    }
}

static inline void trace_guest_user_syscall(CPUState * __cpu, uint64_t num, uint64_t arg1, uint64_t arg2, uint64_t arg3, uint64_t arg4, uint64_t arg5, uint64_t arg6, uint64_t arg7, uint64_t arg8)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_USER_SYSCALL, TRACE_VCPU_GUEST_USER_SYSCALL)) {
    }
}

static inline void trace_guest_user_syscall_ret(CPUState * __cpu, uint64_t num, uint64_t ret)
{
    if (trace_event_get_vcpu_state(__cpu, TRACE_GUEST_USER_SYSCALL_RET, TRACE_VCPU_GUEST_USER_SYSCALL_RET)) {
    }
}

static inline void trace_qemu_memalign(size_t alignment, size_t size, void * ptr)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_MEMALIGN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_memalign " "alignment %zu size %zu ptr %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , alignment, size, ptr);
        }
    }
}

static inline void trace_qemu_anon_ram_alloc(size_t size, void * ptr)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_ANON_RAM_ALLOC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_anon_ram_alloc " "size %zu ptr %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , size, ptr);
        }
    }
}

static inline void trace_qemu_vfree(void * ptr)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_VFREE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_vfree " "ptr %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ptr);
        }
    }
}

static inline void trace_qemu_anon_ram_free(void * ptr, size_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_ANON_RAM_FREE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_anon_ram_free " "ptr %p size %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ptr, size);
        }
    }
}

static inline void trace_hbitmap_iter_skip_words(const void * hb, void * hbi, uint64_t pos, unsigned long cur)
{
    if (true) {
        if (trace_event_get_state(TRACE_HBITMAP_ITER_SKIP_WORDS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:hbitmap_iter_skip_words " "hb %p hbi %p pos %"PRId64" cur 0x%lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hb, hbi, pos, cur);
        }
    }
}

static inline void trace_hbitmap_reset(void * hb, uint64_t start, uint64_t count, uint64_t sbit, uint64_t ebit)
{
    if (true) {
        if (trace_event_get_state(TRACE_HBITMAP_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:hbitmap_reset " "hb %p items %"PRIu64",%"PRIu64" bits %"PRIu64"..%"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hb, start, count, sbit, ebit);
        }
    }
}

static inline void trace_hbitmap_set(void * hb, uint64_t start, uint64_t count, uint64_t sbit, uint64_t ebit)
{
    if (true) {
        if (trace_event_get_state(TRACE_HBITMAP_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:hbitmap_set " "hb %p items %"PRIu64",%"PRIu64" bits %"PRIu64"..%"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hb, start, count, sbit, ebit);
        }
    }
}

static inline void trace_qcrypto_tls_creds_load_dh(void * creds, const char * filename)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCRYPTO_TLS_CREDS_LOAD_DH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcrypto_tls_creds_load_dh " "TLS creds load DH creds=%p filename=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , creds, filename);
        }
    }
}

static inline void trace_qcrypto_tls_creds_get_path(void * creds, const char * filename, const char * path)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCRYPTO_TLS_CREDS_GET_PATH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcrypto_tls_creds_get_path " "TLS creds path creds=%p filename=%s path=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , creds, filename, path);
        }
    }
}

static inline void trace_qcrypto_tls_creds_anon_load(void * creds, const char * dir)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCRYPTO_TLS_CREDS_ANON_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcrypto_tls_creds_anon_load " "TLS creds anon load creds=%p dir=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , creds, dir);
        }
    }
}

static inline void trace_qcrypto_tls_creds_x509_load(void * creds, const char * dir)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCRYPTO_TLS_CREDS_X509_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcrypto_tls_creds_x509_load " "TLS creds x509 load creds=%p dir=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , creds, dir);
        }
    }
}

static inline void trace_qcrypto_tls_creds_x509_check_basic_constraints(void * creds, const char * file, int status)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCRYPTO_TLS_CREDS_X509_CHECK_BASIC_CONSTRAINTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcrypto_tls_creds_x509_check_basic_constraints " "TLS creds x509 check basic constraints creds=%p file=%s status=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , creds, file, status);
        }
    }
}

static inline void trace_qcrypto_tls_creds_x509_check_key_usage(void * creds, const char * file, int status, int usage, int critical)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCRYPTO_TLS_CREDS_X509_CHECK_KEY_USAGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcrypto_tls_creds_x509_check_key_usage " "TLS creds x509 check key usage creds=%p file=%s status=%d usage=%d critical=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , creds, file, status, usage, critical);
        }
    }
}

static inline void trace_qcrypto_tls_creds_x509_check_key_purpose(void * creds, const char * file, int status, const char * usage, int critical)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCRYPTO_TLS_CREDS_X509_CHECK_KEY_PURPOSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcrypto_tls_creds_x509_check_key_purpose " "TLS creds x509 check key usage creds=%p file=%s status=%d usage=%s critical=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , creds, file, status, usage, critical);
        }
    }
}

static inline void trace_qcrypto_tls_creds_x509_load_cert(void * creds, int isServer, const char * file)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCRYPTO_TLS_CREDS_X509_LOAD_CERT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcrypto_tls_creds_x509_load_cert " "TLS creds x509 load cert creds=%p isServer=%d file=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , creds, isServer, file);
        }
    }
}

static inline void trace_qcrypto_tls_creds_x509_load_cert_list(void * creds, const char * file)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCRYPTO_TLS_CREDS_X509_LOAD_CERT_LIST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcrypto_tls_creds_x509_load_cert_list " "TLS creds x509 load cert list creds=%p file=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , creds, file);
        }
    }
}

static inline void trace_qcrypto_tls_session_new(void * session, void * creds, const char * hostname, const char * aclname, int endpoint)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCRYPTO_TLS_SESSION_NEW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcrypto_tls_session_new " "TLS session new session=%p creds=%p hostname=%s aclname=%s endpoint=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , session, creds, hostname, aclname, endpoint);
        }
    }
}

static inline void trace_buffer_resize(const char * buf, size_t olen, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_BUFFER_RESIZE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:buffer_resize " "%s: old %zd, new %zd" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , buf, olen, len);
        }
    }
}

static inline void trace_buffer_move_empty(const char * buf, size_t len, const char * from)
{
    if (true) {
        if (trace_event_get_state(TRACE_BUFFER_MOVE_EMPTY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:buffer_move_empty " "%s: %zd bytes from %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , buf, len, from);
        }
    }
}

static inline void trace_buffer_move(const char * buf, size_t len, const char * from)
{
    if (true) {
        if (trace_event_get_state(TRACE_BUFFER_MOVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:buffer_move " "%s: %zd bytes from %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , buf, len, from);
        }
    }
}

static inline void trace_buffer_free(const char * buf, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_BUFFER_FREE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:buffer_free " "%s: capacity %zd" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , buf, len);
        }
    }
}

static inline void trace_qio_task_new(void * task, void * source, void * func, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_TASK_NEW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_task_new " "Task new task=%p source=%p func=%p opaque=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , task, source, func, opaque);
        }
    }
}

static inline void trace_qio_task_complete(void * task)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_TASK_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_task_complete " "Task complete task=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , task);
        }
    }
}

static inline void trace_qio_task_abort(void * task)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_TASK_ABORT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_task_abort " "Task abort task=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , task);
        }
    }
}

static inline void trace_qio_task_thread_start(void * task, void * worker, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_TASK_THREAD_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_task_thread_start " "Task thread start task=%p worker=%p opaque=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , task, worker, opaque);
        }
    }
}

static inline void trace_qio_task_thread_run(void * task)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_TASK_THREAD_RUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_task_thread_run " "Task thread run task=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , task);
        }
    }
}

static inline void trace_qio_task_thread_exit(void * task)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_TASK_THREAD_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_task_thread_exit " "Task thread exit task=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , task);
        }
    }
}

static inline void trace_qio_task_thread_result(void * task)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_TASK_THREAD_RESULT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_task_thread_result " "Task thread result task=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , task);
        }
    }
}

static inline void trace_qio_channel_socket_new(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_NEW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_new " "Socket new ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_socket_new_fd(void * ioc, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_NEW_FD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_new_fd " "Socket new ioc=%p fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, fd);
        }
    }
}

static inline void trace_qio_channel_socket_connect_sync(void * ioc, void * addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_CONNECT_SYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_connect_sync " "Socket connect sync ioc=%p addr=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, addr);
        }
    }
}

static inline void trace_qio_channel_socket_connect_async(void * ioc, void * addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_CONNECT_ASYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_connect_async " "Socket connect async ioc=%p addr=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, addr);
        }
    }
}

static inline void trace_qio_channel_socket_connect_fail(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_CONNECT_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_connect_fail " "Socket connect fail ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_socket_connect_complete(void * ioc, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_CONNECT_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_connect_complete " "Socket connect complete ioc=%p fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, fd);
        }
    }
}

static inline void trace_qio_channel_socket_listen_sync(void * ioc, void * addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_LISTEN_SYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_listen_sync " "Socket listen sync ioc=%p addr=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, addr);
        }
    }
}

static inline void trace_qio_channel_socket_listen_async(void * ioc, void * addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_LISTEN_ASYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_listen_async " "Socket listen async ioc=%p addr=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, addr);
        }
    }
}

static inline void trace_qio_channel_socket_listen_fail(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_LISTEN_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_listen_fail " "Socket listen fail ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_socket_listen_complete(void * ioc, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_LISTEN_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_listen_complete " "Socket listen complete ioc=%p fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, fd);
        }
    }
}

static inline void trace_qio_channel_socket_dgram_sync(void * ioc, void * localAddr, void * remoteAddr)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_DGRAM_SYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_dgram_sync " "Socket dgram sync ioc=%p localAddr=%p remoteAddr=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, localAddr, remoteAddr);
        }
    }
}

static inline void trace_qio_channel_socket_dgram_async(void * ioc, void * localAddr, void * remoteAddr)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_DGRAM_ASYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_dgram_async " "Socket dgram async ioc=%p localAddr=%p remoteAddr=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, localAddr, remoteAddr);
        }
    }
}

static inline void trace_qio_channel_socket_dgram_fail(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_DGRAM_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_dgram_fail " "Socket dgram fail ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_socket_dgram_complete(void * ioc, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_DGRAM_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_dgram_complete " "Socket dgram complete ioc=%p fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, fd);
        }
    }
}

static inline void trace_qio_channel_socket_accept(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_ACCEPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_accept " "Socket accept start ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_socket_accept_fail(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_ACCEPT_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_accept_fail " "Socket accept fail ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_socket_accept_complete(void * ioc, void * cioc, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_SOCKET_ACCEPT_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_socket_accept_complete " "Socket accept complete ioc=%p cioc=%p fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, cioc, fd);
        }
    }
}

static inline void trace_qio_channel_file_new_fd(void * ioc, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_FILE_NEW_FD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_file_new_fd " "File new fd ioc=%p fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, fd);
        }
    }
}

static inline void trace_qio_channel_file_new_path(void * ioc, const char * path, int flags, int mode, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_FILE_NEW_PATH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_file_new_path " "File new fd ioc=%p path=%s flags=%d mode=%d fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, path, flags, mode, fd);
        }
    }
}

static inline void trace_qio_channel_tls_new_client(void * ioc, void * master, void * creds, const char * hostname)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_TLS_NEW_CLIENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_tls_new_client " "TLS new client ioc=%p master=%p creds=%p hostname=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, master, creds, hostname);
        }
    }
}

static inline void trace_qio_channel_tls_new_server(void * ioc, void * master, void * creds, const char * aclname)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_TLS_NEW_SERVER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_tls_new_server " "TLS new client ioc=%p master=%p creds=%p acltname=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, master, creds, aclname);
        }
    }
}

static inline void trace_qio_channel_tls_handshake_start(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_TLS_HANDSHAKE_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_tls_handshake_start " "TLS handshake start ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_tls_handshake_pending(void * ioc, int status)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_TLS_HANDSHAKE_PENDING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_tls_handshake_pending " "TLS handshake pending ioc=%p status=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, status);
        }
    }
}

static inline void trace_qio_channel_tls_handshake_fail(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_TLS_HANDSHAKE_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_tls_handshake_fail " "TLS handshake fail ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_tls_handshake_complete(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_TLS_HANDSHAKE_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_tls_handshake_complete " "TLS handshake complete ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_tls_credentials_allow(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_TLS_CREDENTIALS_ALLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_tls_credentials_allow " "TLS credentials allow ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_tls_credentials_deny(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_TLS_CREDENTIALS_DENY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_tls_credentials_deny " "TLS credentials deny ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_websock_new_server(void * ioc, void * master)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_WEBSOCK_NEW_SERVER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_websock_new_server " "Websock new client ioc=%p master=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, master);
        }
    }
}

static inline void trace_qio_channel_websock_handshake_start(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_WEBSOCK_HANDSHAKE_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_websock_handshake_start " "Websock handshake start ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_websock_handshake_pending(void * ioc, int status)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_WEBSOCK_HANDSHAKE_PENDING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_websock_handshake_pending " "Websock handshake pending ioc=%p status=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, status);
        }
    }
}

static inline void trace_qio_channel_websock_handshake_reply(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_WEBSOCK_HANDSHAKE_REPLY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_websock_handshake_reply " "Websock handshake reply ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_websock_handshake_fail(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_WEBSOCK_HANDSHAKE_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_websock_handshake_fail " "Websock handshake fail ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_websock_handshake_complete(void * ioc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_WEBSOCK_HANDSHAKE_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_websock_handshake_complete " "Websock handshake complete ioc=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc);
        }
    }
}

static inline void trace_qio_channel_command_new_pid(void * ioc, int writefd, int readfd, int pid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_COMMAND_NEW_PID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_command_new_pid " "Command new pid ioc=%p writefd=%d readfd=%d pid=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, writefd, readfd, pid);
        }
    }
}

static inline void trace_qio_channel_command_new_spawn(void * ioc, const char * binary, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_COMMAND_NEW_SPAWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_command_new_spawn " "Command new spawn ioc=%p binary=%s flags=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, binary, flags);
        }
    }
}

static inline void trace_qio_channel_command_abort(void * ioc, int pid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_COMMAND_ABORT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_command_abort " "Command abort ioc=%p pid=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, pid);
        }
    }
}

static inline void trace_qio_channel_command_wait(void * ioc, int pid, int ret, int status)
{
    if (true) {
        if (trace_event_get_state(TRACE_QIO_CHANNEL_COMMAND_WAIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qio_channel_command_wait " "Command abort ioc=%p pid=%d ret=%d status=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, pid, ret, status);
        }
    }
}

static inline void trace_qemu_loadvm_state_section(unsigned int section_type)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_LOADVM_STATE_SECTION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_loadvm_state_section " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , section_type);
        }
    }
}

static inline void trace_qemu_loadvm_state_section_command(int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_LOADVM_STATE_SECTION_COMMAND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_loadvm_state_section_command " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_qemu_loadvm_state_section_partend(uint32_t section_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_LOADVM_STATE_SECTION_PARTEND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_loadvm_state_section_partend " "%u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , section_id);
        }
    }
}

static inline void trace_qemu_loadvm_state_main(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_LOADVM_STATE_MAIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_loadvm_state_main " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_loadvm_state_main_quit_parent(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_LOADVM_STATE_MAIN_QUIT_PARENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_loadvm_state_main_quit_parent " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_loadvm_state_post_main(int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_LOADVM_STATE_POST_MAIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_loadvm_state_post_main " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_qemu_loadvm_state_section_startfull(uint32_t section_id, const char * idstr, uint32_t instance_id, uint32_t version_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_LOADVM_STATE_SECTION_STARTFULL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_loadvm_state_section_startfull " "%u(%s) %u %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , section_id, idstr, instance_id, version_id);
        }
    }
}

static inline void trace_qemu_savevm_send_packaged(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SAVEVM_SEND_PACKAGED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_savevm_send_packaged " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_loadvm_handle_cmd_packaged(unsigned int length)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_HANDLE_CMD_PACKAGED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_handle_cmd_packaged " "%u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , length);
        }
    }
}

static inline void trace_loadvm_handle_cmd_packaged_main(int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_HANDLE_CMD_PACKAGED_MAIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_handle_cmd_packaged_main " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_loadvm_handle_cmd_packaged_received(int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_HANDLE_CMD_PACKAGED_RECEIVED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_handle_cmd_packaged_received " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_loadvm_postcopy_handle_advise(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_POSTCOPY_HANDLE_ADVISE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_postcopy_handle_advise " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_loadvm_postcopy_handle_listen(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_POSTCOPY_HANDLE_LISTEN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_postcopy_handle_listen " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_loadvm_postcopy_handle_run(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_POSTCOPY_HANDLE_RUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_postcopy_handle_run " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_loadvm_postcopy_handle_run_cpu_sync(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_POSTCOPY_HANDLE_RUN_CPU_SYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_postcopy_handle_run_cpu_sync " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_loadvm_postcopy_handle_run_vmstart(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_POSTCOPY_HANDLE_RUN_VMSTART)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_postcopy_handle_run_vmstart " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_loadvm_postcopy_ram_handle_discard(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_POSTCOPY_RAM_HANDLE_DISCARD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_postcopy_ram_handle_discard " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_loadvm_postcopy_ram_handle_discard_end(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_POSTCOPY_RAM_HANDLE_DISCARD_END)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_postcopy_ram_handle_discard_end " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_loadvm_postcopy_ram_handle_discard_header(const char * ramid, uint16_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_POSTCOPY_RAM_HANDLE_DISCARD_HEADER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_postcopy_ram_handle_discard_header " "%s: %ud" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ramid, len);
        }
    }
}

static inline void trace_loadvm_process_command(uint16_t com, uint16_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_PROCESS_COMMAND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_process_command " "com=0x%x len=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , com, len);
        }
    }
}

static inline void trace_loadvm_process_command_ping(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_LOADVM_PROCESS_COMMAND_PING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:loadvm_process_command_ping " "%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_postcopy_ram_listen_thread_exit(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_LISTEN_THREAD_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_listen_thread_exit " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_ram_listen_thread_start(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_LISTEN_THREAD_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_listen_thread_start " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_savevm_send_postcopy_advise(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SAVEVM_SEND_POSTCOPY_ADVISE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_savevm_send_postcopy_advise " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_savevm_send_postcopy_ram_discard(const char * id, uint16_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SAVEVM_SEND_POSTCOPY_RAM_DISCARD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_savevm_send_postcopy_ram_discard " "%s: %ud" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, len);
        }
    }
}

static inline void trace_savevm_command_send(uint16_t command, uint16_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_COMMAND_SEND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_command_send " "com=0x%x len=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , command, len);
        }
    }
}

static inline void trace_savevm_section_start(const char * id, unsigned int section_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_SECTION_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_section_start " "%s, section_id %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, section_id);
        }
    }
}

static inline void trace_savevm_section_end(const char * id, unsigned int section_id, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_SECTION_END)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_section_end " "%s, section_id %u -> %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, section_id, ret);
        }
    }
}

static inline void trace_savevm_section_skip(const char * id, unsigned int section_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_SECTION_SKIP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_section_skip " "%s, section_id %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, section_id);
        }
    }
}

static inline void trace_savevm_send_open_return_path(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_SEND_OPEN_RETURN_PATH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_send_open_return_path " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_savevm_send_ping(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_SEND_PING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_send_ping " "%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_savevm_send_postcopy_listen(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_SEND_POSTCOPY_LISTEN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_send_postcopy_listen " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_savevm_send_postcopy_run(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_SEND_POSTCOPY_RUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_send_postcopy_run " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_savevm_state_begin(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_STATE_BEGIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_state_begin " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_savevm_state_header(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_STATE_HEADER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_state_header " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_savevm_state_iterate(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_STATE_ITERATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_state_iterate " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_savevm_state_cleanup(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_STATE_CLEANUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_state_cleanup " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_savevm_state_complete_precopy(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SAVEVM_STATE_COMPLETE_PRECOPY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:savevm_state_complete_precopy " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_vmstate_save(const char * idstr, const char * vmsd_name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMSTATE_SAVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmstate_save " "%s, %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idstr, vmsd_name);
        }
    }
}

static inline void trace_vmstate_load(const char * idstr, const char * vmsd_name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMSTATE_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmstate_load " "%s, %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idstr, vmsd_name);
        }
    }
}

static inline void trace_qemu_announce_self_iter(const char * mac)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_ANNOUNCE_SELF_ITER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_announce_self_iter " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , mac);
        }
    }
}

static inline void trace_vmstate_load_field_error(const char * field, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMSTATE_LOAD_FIELD_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmstate_load_field_error " "field \"%s\" load failed, ret = %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , field, ret);
        }
    }
}

static inline void trace_vmstate_load_state(const char * name, int version_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMSTATE_LOAD_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmstate_load_state " "%s v%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, version_id);
        }
    }
}

static inline void trace_vmstate_load_state_end(const char * name, const char * reason, int val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMSTATE_LOAD_STATE_END)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmstate_load_state_end " "%s %s/%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, reason, val);
        }
    }
}

static inline void trace_vmstate_load_state_field(const char * name, const char * field)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMSTATE_LOAD_STATE_FIELD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmstate_load_state_field " "%s:%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, field);
        }
    }
}

static inline void trace_vmstate_n_elems(const char * name, int n_elems)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMSTATE_N_ELEMS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmstate_n_elems " "%s: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, n_elems);
        }
    }
}

static inline void trace_vmstate_subsection_load(const char * parent)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMSTATE_SUBSECTION_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmstate_subsection_load " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , parent);
        }
    }
}

static inline void trace_vmstate_subsection_load_bad(const char * parent, const char * sub, const char * sub2)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMSTATE_SUBSECTION_LOAD_BAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmstate_subsection_load_bad " "%s: %s/%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , parent, sub, sub2);
        }
    }
}

static inline void trace_vmstate_subsection_load_good(const char * parent)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMSTATE_SUBSECTION_LOAD_GOOD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmstate_subsection_load_good " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , parent);
        }
    }
}

static inline void trace_qemu_file_fclose(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_FILE_FCLOSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_file_fclose " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_get_queued_page(const char * block_name, uint64_t tmp_offset, uint64_t ram_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_GET_QUEUED_PAGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:get_queued_page " "%s/%" PRIx64 " ram_addr=%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , block_name, tmp_offset, ram_addr);
        }
    }
}

static inline void trace_get_queued_page_not_dirty(const char * block_name, uint64_t tmp_offset, uint64_t ram_addr, int sent)
{
    if (true) {
        if (trace_event_get_state(TRACE_GET_QUEUED_PAGE_NOT_DIRTY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:get_queued_page_not_dirty " "%s/%" PRIx64 " ram_addr=%" PRIx64 " (sent=%d)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , block_name, tmp_offset, ram_addr, sent);
        }
    }
}

static inline void trace_migration_bitmap_sync_start(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_BITMAP_SYNC_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_bitmap_sync_start " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_bitmap_sync_end(uint64_t dirty_pages)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_BITMAP_SYNC_END)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_bitmap_sync_end " "dirty_pages %" PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dirty_pages);
        }
    }
}

static inline void trace_migration_throttle(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_THROTTLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_throttle " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_ram_load_postcopy_loop(uint64_t addr, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_RAM_LOAD_POSTCOPY_LOOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ram_load_postcopy_loop " "@%" PRIx64 " %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, flags);
        }
    }
}

static inline void trace_ram_postcopy_send_discard_bitmap(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_RAM_POSTCOPY_SEND_DISCARD_BITMAP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ram_postcopy_send_discard_bitmap " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_ram_save_queue_pages(const char * rbname, size_t start, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_RAM_SAVE_QUEUE_PAGES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ram_save_queue_pages " "%s: start: %zx len: %zx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rbname, start, len);
        }
    }
}

static inline void trace_await_return_path_close_on_source_close(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_AWAIT_RETURN_PATH_CLOSE_ON_SOURCE_CLOSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:await_return_path_close_on_source_close " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_await_return_path_close_on_source_joining(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_AWAIT_RETURN_PATH_CLOSE_ON_SOURCE_JOINING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:await_return_path_close_on_source_joining " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migrate_set_state(int new_state)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_SET_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_set_state " "new state %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , new_state);
        }
    }
}

static inline void trace_migrate_fd_cleanup(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_FD_CLEANUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_fd_cleanup " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migrate_fd_error(const char * error_desc)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_FD_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_fd_error " "error=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , error_desc);
        }
    }
}

static inline void trace_migrate_fd_cancel(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_FD_CANCEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_fd_cancel " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migrate_handle_rp_req_pages(const char * rbname, size_t start, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_HANDLE_RP_REQ_PAGES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_handle_rp_req_pages " "in %s at %zx len %zx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rbname, start, len);
        }
    }
}

static inline void trace_migrate_pending(uint64_t size, uint64_t max, uint64_t post, uint64_t nonpost)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_PENDING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_pending " "pending size %" PRIu64 " max %" PRIu64 " (post=%" PRIu64 " nonpost=%" PRIu64 ")" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , size, max, post, nonpost);
        }
    }
}

static inline void trace_migrate_send_rp_message(int msg_type, uint16_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_SEND_RP_MESSAGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_send_rp_message " "%d: len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , msg_type, len);
        }
    }
}

static inline void trace_migration_completion_file_err(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_COMPLETION_FILE_ERR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_completion_file_err " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_completion_postcopy_end(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_COMPLETION_POSTCOPY_END)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_completion_postcopy_end " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_completion_postcopy_end_after_complete(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_COMPLETION_POSTCOPY_END_AFTER_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_completion_postcopy_end_after_complete " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_completion_postcopy_end_before_rp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_COMPLETION_POSTCOPY_END_BEFORE_RP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_completion_postcopy_end_before_rp " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_completion_postcopy_end_after_rp(int rp_error)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_COMPLETION_POSTCOPY_END_AFTER_RP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_completion_postcopy_end_after_rp " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rp_error);
        }
    }
}

static inline void trace_migration_thread_after_loop(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_THREAD_AFTER_LOOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_thread_after_loop " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_thread_file_err(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_THREAD_FILE_ERR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_thread_file_err " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_thread_setup_complete(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_THREAD_SETUP_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_thread_setup_complete " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_open_return_path_on_source(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_RETURN_PATH_ON_SOURCE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_return_path_on_source " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_open_return_path_on_source_continue(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_RETURN_PATH_ON_SOURCE_CONTINUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_return_path_on_source_continue " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_start(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_start " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_start_set_run(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_START_SET_RUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_start_set_run " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_source_return_path_thread_bad_end(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SOURCE_RETURN_PATH_THREAD_BAD_END)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:source_return_path_thread_bad_end " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_source_return_path_thread_end(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SOURCE_RETURN_PATH_THREAD_END)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:source_return_path_thread_end " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_source_return_path_thread_entry(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SOURCE_RETURN_PATH_THREAD_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:source_return_path_thread_entry " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_source_return_path_thread_loop_top(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SOURCE_RETURN_PATH_THREAD_LOOP_TOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:source_return_path_thread_loop_top " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_source_return_path_thread_pong(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SOURCE_RETURN_PATH_THREAD_PONG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:source_return_path_thread_pong " "%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_source_return_path_thread_shut(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SOURCE_RETURN_PATH_THREAD_SHUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:source_return_path_thread_shut " "%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_migrate_global_state_post_load(const char * state)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_GLOBAL_STATE_POST_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_global_state_post_load " "loaded state: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , state);
        }
    }
}

static inline void trace_migrate_global_state_pre_save(const char * state)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_GLOBAL_STATE_PRE_SAVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_global_state_pre_save " "saved state: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , state);
        }
    }
}

static inline void trace_migration_thread_low_pending(uint64_t pending)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_THREAD_LOW_PENDING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_thread_low_pending " "%" PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pending);
        }
    }
}

static inline void trace_migrate_state_too_big(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_STATE_TOO_BIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_state_too_big " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migrate_transferred(uint64_t tranferred, uint64_t time_spent, double bandwidth, uint64_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATE_TRANSFERRED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migrate_transferred " "transferred %" PRIu64 " time_spent %" PRIu64 " bandwidth %g max_size %" PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tranferred, time_spent, bandwidth, size);
        }
    }
}

static inline void trace_process_incoming_migration_co_end(int ret, int ps)
{
    if (true) {
        if (trace_event_get_state(TRACE_PROCESS_INCOMING_MIGRATION_CO_END)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:process_incoming_migration_co_end " "ret=%d postcopy-state=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret, ps);
        }
    }
}

static inline void trace_process_incoming_migration_co_postcopy_end_main(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_PROCESS_INCOMING_MIGRATION_CO_POSTCOPY_END_MAIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:process_incoming_migration_co_postcopy_end_main " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_set_incoming_channel(void * ioc, const char * ioctype)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_SET_INCOMING_CHANNEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_set_incoming_channel " "ioc=%p ioctype=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, ioctype);
        }
    }
}

static inline void trace_migration_set_outgoing_channel(void * ioc, const char * ioctype, const char * hostname)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_SET_OUTGOING_CHANNEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_set_outgoing_channel " "ioc=%p ioctype=%s hostname=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioc, ioctype, hostname);
        }
    }
}

static inline void trace_qemu_rdma_accept_incoming_migration(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_ACCEPT_INCOMING_MIGRATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_accept_incoming_migration " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_accept_incoming_migration_accepted(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_ACCEPT_INCOMING_MIGRATION_ACCEPTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_accept_incoming_migration_accepted " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_accept_pin_state(bool pin)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_ACCEPT_PIN_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_accept_pin_state " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pin);
        }
    }
}

static inline void trace_qemu_rdma_accept_pin_verbsc(void * verbs)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_ACCEPT_PIN_VERBSC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_accept_pin_verbsc " "Verbs context after listen: %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , verbs);
        }
    }
}

static inline void trace_qemu_rdma_block_for_wrid_miss(const char * wcompstr, int wcomp, const char * gcompstr, uint64_t req)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_BLOCK_FOR_WRID_MISS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_block_for_wrid_miss " "A Wanted wrid %s (%d) but got %s (%" PRIu64 ")" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , wcompstr, wcomp, gcompstr, req);
        }
    }
}

static inline void trace_qemu_rdma_block_for_wrid_miss_b(const char * wcompstr, int wcomp, const char * gcompstr, uint64_t req)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_BLOCK_FOR_WRID_MISS_B)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_block_for_wrid_miss_b " "B Wanted wrid %s (%d) but got %s (%" PRIu64 ")" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , wcompstr, wcomp, gcompstr, req);
        }
    }
}

static inline void trace_qemu_rdma_cleanup_disconnect(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_CLEANUP_DISCONNECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_cleanup_disconnect " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_cleanup_waiting_for_disconnect(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_CLEANUP_WAITING_FOR_DISCONNECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_cleanup_waiting_for_disconnect " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_close(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_CLOSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_close " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_connect_pin_all_requested(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_CONNECT_PIN_ALL_REQUESTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_connect_pin_all_requested " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_connect_pin_all_outcome(bool pin)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_CONNECT_PIN_ALL_OUTCOME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_connect_pin_all_outcome " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pin);
        }
    }
}

static inline void trace_qemu_rdma_dest_init_trying(const char * host, const char * ip)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_DEST_INIT_TRYING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_dest_init_trying " "%s => %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , host, ip);
        }
    }
}

static inline void trace_qemu_rdma_dump_gid(const char * who, const char * src, const char * dst)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_DUMP_GID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_dump_gid " "%s Source GID: %s, Dest GID: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , who, src, dst);
        }
    }
}

static inline void trace_qemu_rdma_exchange_get_response_start(const char * desc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_EXCHANGE_GET_RESPONSE_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_exchange_get_response_start " "CONTROL: %s receiving..." "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , desc);
        }
    }
}

static inline void trace_qemu_rdma_exchange_get_response_none(const char * desc, int type)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_EXCHANGE_GET_RESPONSE_NONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_exchange_get_response_none " "Surprise: got %s (%d)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , desc, type);
        }
    }
}

static inline void trace_qemu_rdma_exchange_send_issue_callback(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_EXCHANGE_SEND_ISSUE_CALLBACK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_exchange_send_issue_callback " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_exchange_send_waiting(const char * desc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_EXCHANGE_SEND_WAITING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_exchange_send_waiting " "Waiting for response %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , desc);
        }
    }
}

static inline void trace_qemu_rdma_exchange_send_received(const char * desc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_EXCHANGE_SEND_RECEIVED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_exchange_send_received " "Response %s received." "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , desc);
        }
    }
}

static inline void trace_qemu_rdma_fill(size_t control_len, size_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_FILL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_fill " "RDMA %zd of %zd bytes already in buffer" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , control_len, size);
        }
    }
}

static inline void trace_qemu_rdma_init_ram_blocks(int blocks)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_INIT_RAM_BLOCKS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_init_ram_blocks " "Allocated %d local ram block structures" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , blocks);
        }
    }
}

static inline void trace_qemu_rdma_poll_recv(const char * compstr, int64_t comp, int64_t id, int sent)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_POLL_RECV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_poll_recv " "completion %s #%" PRId64 " received (%" PRId64 ") left %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , compstr, comp, id, sent);
        }
    }
}

static inline void trace_qemu_rdma_poll_write(const char * compstr, int64_t comp, int left, uint64_t block, uint64_t chunk, void * local, void * remote)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_POLL_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_poll_write " "completions %s (%" PRId64 ") left %d, block %" PRIu64 ", chunk: %" PRIu64 " %p %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , compstr, comp, left, block, chunk, local, remote);
        }
    }
}

static inline void trace_qemu_rdma_poll_other(const char * compstr, int64_t comp, int left)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_POLL_OTHER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_poll_other " "other completion %s (%" PRId64 ") received left %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , compstr, comp, left);
        }
    }
}

static inline void trace_qemu_rdma_post_send_control(const char * desc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_POST_SEND_CONTROL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_post_send_control " "CONTROL: sending %s.." "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , desc);
        }
    }
}

static inline void trace_qemu_rdma_register_and_get_keys(uint64_t len, void * start)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTER_AND_GET_KEYS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_register_and_get_keys " "Registering %" PRIu64 " bytes @ %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , len, start);
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_compress(int64_t length, int index, int64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_COMPRESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_compress " "Zapping zero chunk: %" PRId64 " bytes, index %d, offset %" PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , length, index, offset);
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_finished(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_FINISHED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_finished " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_ram_blocks(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_RAM_BLOCKS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_ram_blocks " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_ram_blocks_loop(const char * name, uint64_t offset, uint64_t length, void * local_host_addr, unsigned int src_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_RAM_BLOCKS_LOOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_ram_blocks_loop " "%s: @%" PRIx64 "/%" PRIu64 " host:@%p src_index: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, offset, length, local_host_addr, src_index);
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_register(int requests)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_REGISTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_register " "%d requests" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , requests);
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_register_loop(int req, int index, uint64_t addr, uint64_t chunks)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_REGISTER_LOOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_register_loop " "Registration request (%d): index %d, current_addr %" PRIu64 " chunks: %" PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, index, addr, chunks);
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_register_rkey(int rkey)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_REGISTER_RKEY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_register_rkey " "%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rkey);
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_unregister(int requests)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_UNREGISTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_unregister " "%d requests" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , requests);
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_unregister_loop(int count, int index, uint64_t chunk)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_UNREGISTER_LOOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_unregister_loop " "Unregistration request (%d): index %d, chunk %" PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , count, index, chunk);
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_unregister_success(uint64_t chunk)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_UNREGISTER_SUCCESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_unregister_success " "%" PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunk);
        }
    }
}

static inline void trace_qemu_rdma_registration_handle_wait(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_HANDLE_WAIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_handle_wait " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_registration_start(uint64_t flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_start " "%" PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , flags);
        }
    }
}

static inline void trace_qemu_rdma_registration_stop(uint64_t flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_STOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_stop " "%" PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , flags);
        }
    }
}

static inline void trace_qemu_rdma_registration_stop_ram(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_REGISTRATION_STOP_RAM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_registration_stop_ram " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_resolve_host_trying(const char * host, const char * ip)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_RESOLVE_HOST_TRYING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_resolve_host_trying " "Trying %s => %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , host, ip);
        }
    }
}

static inline void trace_qemu_rdma_signal_unregister_append(uint64_t chunk, int pos)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_SIGNAL_UNREGISTER_APPEND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_signal_unregister_append " "Appending unregister chunk %" PRIu64 " at position %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunk, pos);
        }
    }
}

static inline void trace_qemu_rdma_signal_unregister_already(uint64_t chunk)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_SIGNAL_UNREGISTER_ALREADY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_signal_unregister_already " "Unregister chunk %" PRIu64 " already in queue" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunk);
        }
    }
}

static inline void trace_qemu_rdma_unregister_waiting_inflight(uint64_t chunk)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_UNREGISTER_WAITING_INFLIGHT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_unregister_waiting_inflight " "Cannot unregister inflight chunk: %" PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunk);
        }
    }
}

static inline void trace_qemu_rdma_unregister_waiting_proc(uint64_t chunk, int pos)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_UNREGISTER_WAITING_PROC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_unregister_waiting_proc " "Processing unregister for chunk: %" PRIu64 " at position %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunk, pos);
        }
    }
}

static inline void trace_qemu_rdma_unregister_waiting_send(uint64_t chunk)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_UNREGISTER_WAITING_SEND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_unregister_waiting_send " "Sending unregister for chunk: %" PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunk);
        }
    }
}

static inline void trace_qemu_rdma_unregister_waiting_complete(uint64_t chunk)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_UNREGISTER_WAITING_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_unregister_waiting_complete " "Unregister for chunk: %" PRIu64 " complete." "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunk);
        }
    }
}

static inline void trace_qemu_rdma_write_flush(int sent)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_WRITE_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_write_flush " "sent total: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , sent);
        }
    }
}

static inline void trace_qemu_rdma_write_one_block(int count, int block, uint64_t chunk, uint64_t current, uint64_t len, int nb_sent, int nb_chunks)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_WRITE_ONE_BLOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_write_one_block " "(%d) Not clobbering: block: %d chunk %" PRIu64 " current %" PRIu64 " len %" PRIu64 " %d %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , count, block, chunk, current, len, nb_sent, nb_chunks);
        }
    }
}

static inline void trace_qemu_rdma_write_one_post(uint64_t chunk, long addr, long remote, uint32_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_WRITE_ONE_POST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_write_one_post " "Posting chunk: %" PRIu64 ", addr: %lx remote: %lx, bytes %" PRIu32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunk, addr, remote, len);
        }
    }
}

static inline void trace_qemu_rdma_write_one_queue_full(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_WRITE_ONE_QUEUE_FULL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_write_one_queue_full " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_qemu_rdma_write_one_recvregres(int mykey, int theirkey, uint64_t chunk)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_WRITE_ONE_RECVREGRES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_write_one_recvregres " "Received registration result: my key: %x their key %x, chunk %" PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , mykey, theirkey, chunk);
        }
    }
}

static inline void trace_qemu_rdma_write_one_sendreg(uint64_t chunk, int len, int index, int64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_WRITE_ONE_SENDREG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_write_one_sendreg " "Sending registration request chunk %" PRIu64 " for %d bytes, index: %d, offset: %" PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunk, len, index, offset);
        }
    }
}

static inline void trace_qemu_rdma_write_one_top(uint64_t chunks, uint64_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_WRITE_ONE_TOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_write_one_top " "Writing %" PRIu64 " chunks, (%" PRIu64 " MB)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunks, size);
        }
    }
}

static inline void trace_qemu_rdma_write_one_zero(uint64_t chunk, int len, int index, int64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_RDMA_WRITE_ONE_ZERO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_rdma_write_one_zero " "Entire chunk is zero, sending compress: %" PRIu64 " for %d bytes, index: %d, offset: %" PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chunk, len, index, offset);
        }
    }
}

static inline void trace_rdma_add_block(const char * block_name, int block, uint64_t addr, uint64_t offset, uint64_t len, uint64_t end, uint64_t bits, int chunks)
{
    if (true) {
        if (trace_event_get_state(TRACE_RDMA_ADD_BLOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:rdma_add_block " "Added Block: '%s':%d, addr: %" PRIu64 ", offset: %" PRIu64 " length: %" PRIu64 " end: %" PRIu64 " bits %" PRIu64 " chunks %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , block_name, block, addr, offset, len, end, bits, chunks);
        }
    }
}

static inline void trace_rdma_block_notification_handle(const char * name, int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_RDMA_BLOCK_NOTIFICATION_HANDLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:rdma_block_notification_handle " "%s at %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index);
        }
    }
}

static inline void trace_rdma_delete_block(void * block, uint64_t addr, uint64_t offset, uint64_t len, uint64_t end, uint64_t bits, int chunks)
{
    if (true) {
        if (trace_event_get_state(TRACE_RDMA_DELETE_BLOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:rdma_delete_block " "Deleted Block: %p, addr: %" PRIu64 ", offset: %" PRIu64 " length: %" PRIu64 " end: %" PRIu64 " bits %" PRIu64 " chunks %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , block, addr, offset, len, end, bits, chunks);
        }
    }
}

static inline void trace_rdma_start_incoming_migration(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_RDMA_START_INCOMING_MIGRATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:rdma_start_incoming_migration " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_rdma_start_incoming_migration_after_dest_init(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_RDMA_START_INCOMING_MIGRATION_AFTER_DEST_INIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:rdma_start_incoming_migration_after_dest_init " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_rdma_start_incoming_migration_after_rdma_listen(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_RDMA_START_INCOMING_MIGRATION_AFTER_RDMA_LISTEN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:rdma_start_incoming_migration_after_rdma_listen " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_rdma_start_outgoing_migration_after_rdma_connect(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_RDMA_START_OUTGOING_MIGRATION_AFTER_RDMA_CONNECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:rdma_start_outgoing_migration_after_rdma_connect " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_rdma_start_outgoing_migration_after_rdma_source_init(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_RDMA_START_OUTGOING_MIGRATION_AFTER_RDMA_SOURCE_INIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:rdma_start_outgoing_migration_after_rdma_source_init " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_discard_send_finish(const char * ramblock, int nwords, int ncmds)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_DISCARD_SEND_FINISH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_discard_send_finish " "%s mask words sent=%d in %d commands" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ramblock, nwords, ncmds);
        }
    }
}

static inline void trace_postcopy_discard_send_range(const char * ramblock, unsigned long start, unsigned long length)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_DISCARD_SEND_RANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_discard_send_range " "%s:%lx/%lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ramblock, start, length);
        }
    }
}

static inline void trace_postcopy_ram_discard_range(void * start, size_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_DISCARD_RANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_discard_range " "%p,+%zx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start, length);
        }
    }
}

static inline void trace_postcopy_cleanup_range(const char * ramblock, void * host_addr, size_t offset, size_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_CLEANUP_RANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_cleanup_range " "%s: %p offset=%zx length=%zx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ramblock, host_addr, offset, length);
        }
    }
}

static inline void trace_postcopy_init_range(const char * ramblock, void * host_addr, size_t offset, size_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_INIT_RANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_init_range " "%s: %p offset=%zx length=%zx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ramblock, host_addr, offset, length);
        }
    }
}

static inline void trace_postcopy_nhp_range(const char * ramblock, void * host_addr, size_t offset, size_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_NHP_RANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_nhp_range " "%s: %p offset=%zx length=%zx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ramblock, host_addr, offset, length);
        }
    }
}

static inline void trace_postcopy_place_page(void * host_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_PLACE_PAGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_place_page " "host=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , host_addr);
        }
    }
}

static inline void trace_postcopy_place_page_zero(void * host_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_PLACE_PAGE_ZERO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_place_page_zero " "host=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , host_addr);
        }
    }
}

static inline void trace_postcopy_ram_enable_notify(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_ENABLE_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_enable_notify " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_ram_fault_thread_entry(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_FAULT_THREAD_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_fault_thread_entry " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_ram_fault_thread_exit(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_FAULT_THREAD_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_fault_thread_exit " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_ram_fault_thread_quit(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_FAULT_THREAD_QUIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_fault_thread_quit " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_ram_fault_thread_request(uint64_t hostaddr, const char * ramblock, size_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_FAULT_THREAD_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_fault_thread_request " "Request for HVA=%" PRIx64 " rb=%s offset=%zx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hostaddr, ramblock, offset);
        }
    }
}

static inline void trace_postcopy_ram_incoming_cleanup_closeuf(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_INCOMING_CLEANUP_CLOSEUF)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_incoming_cleanup_closeuf " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_ram_incoming_cleanup_entry(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_INCOMING_CLEANUP_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_incoming_cleanup_entry " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_ram_incoming_cleanup_exit(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_INCOMING_CLEANUP_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_incoming_cleanup_exit " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_postcopy_ram_incoming_cleanup_join(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_POSTCOPY_RAM_INCOMING_CLEANUP_JOIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:postcopy_ram_incoming_cleanup_join " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_exec_outgoing(const char * cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_EXEC_OUTGOING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_exec_outgoing " "cmd=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd);
        }
    }
}

static inline void trace_migration_exec_incoming(const char * cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_EXEC_INCOMING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_exec_incoming " "cmd=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd);
        }
    }
}

static inline void trace_migration_fd_outgoing(int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_FD_OUTGOING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_fd_outgoing " "fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fd);
        }
    }
}

static inline void trace_migration_fd_incoming(int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_FD_INCOMING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_fd_incoming " "fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fd);
        }
    }
}

static inline void trace_migration_socket_incoming_accepted(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_SOCKET_INCOMING_ACCEPTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_socket_incoming_accepted " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_socket_outgoing_connected(const char * hostname)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_SOCKET_OUTGOING_CONNECTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_socket_outgoing_connected " "hostname=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hostname);
        }
    }
}

static inline void trace_migration_socket_outgoing_error(const char * err)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_SOCKET_OUTGOING_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_socket_outgoing_error " "error=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , err);
        }
    }
}

static inline void trace_migration_tls_outgoing_handshake_start(const char * hostname)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_TLS_OUTGOING_HANDSHAKE_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_tls_outgoing_handshake_start " "hostname=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , hostname);
        }
    }
}

static inline void trace_migration_tls_outgoing_handshake_error(const char * err)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_TLS_OUTGOING_HANDSHAKE_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_tls_outgoing_handshake_error " "err=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , err);
        }
    }
}

static inline void trace_migration_tls_outgoing_handshake_complete(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_TLS_OUTGOING_HANDSHAKE_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_tls_outgoing_handshake_complete " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_tls_incoming_handshake_start(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_TLS_INCOMING_HANDSHAKE_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_tls_incoming_handshake_start " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_migration_tls_incoming_handshake_error(const char * err)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_TLS_INCOMING_HANDSHAKE_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_tls_incoming_handshake_error " "err=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , err);
        }
    }
}

static inline void trace_migration_tls_incoming_handshake_complete(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIGRATION_TLS_INCOMING_HANDSHAKE_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:migration_tls_incoming_handshake_complete " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_bdrv_open_common(void * bs, const char * filename, int flags, const char * format_name)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_OPEN_COMMON)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_open_common " "bs %p filename \"%s\" flags %#x format_name \"%s\"" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, filename, flags, format_name);
        }
    }
}

static inline void trace_bdrv_lock_medium(void * bs, bool locked)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_LOCK_MEDIUM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_lock_medium " "bs %p locked %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, locked);
        }
    }
}

static inline void trace_blk_co_preadv(void * blk, void * bs, int64_t offset, unsigned int bytes, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_BLK_CO_PREADV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:blk_co_preadv " "blk %p bs %p offset %"PRId64" bytes %u flags %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , blk, bs, offset, bytes, flags);
        }
    }
}

static inline void trace_blk_co_pwritev(void * blk, void * bs, int64_t offset, unsigned int bytes, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_BLK_CO_PWRITEV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:blk_co_pwritev " "blk %p bs %p offset %"PRId64" bytes %u flags %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , blk, bs, offset, bytes, flags);
        }
    }
}

static inline void trace_bdrv_aio_pdiscard(void * bs, int64_t offset, int count, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_AIO_PDISCARD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_aio_pdiscard " "bs %p offset %"PRId64" count %d opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, offset, count, opaque);
        }
    }
}

static inline void trace_bdrv_aio_flush(void * bs, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_AIO_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_aio_flush " "bs %p opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, opaque);
        }
    }
}

static inline void trace_bdrv_aio_readv(void * bs, int64_t sector_num, int nb_sectors, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_AIO_READV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_aio_readv " "bs %p sector_num %"PRId64" nb_sectors %d opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, sector_num, nb_sectors, opaque);
        }
    }
}

static inline void trace_bdrv_aio_writev(void * bs, int64_t sector_num, int nb_sectors, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_AIO_WRITEV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_aio_writev " "bs %p sector_num %"PRId64" nb_sectors %d opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, sector_num, nb_sectors, opaque);
        }
    }
}

static inline void trace_bdrv_co_readv(void * bs, int64_t sector_num, int nb_sector)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_CO_READV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_co_readv " "bs %p sector_num %"PRId64" nb_sectors %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, sector_num, nb_sector);
        }
    }
}

static inline void trace_bdrv_co_writev(void * bs, int64_t sector_num, int nb_sector)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_CO_WRITEV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_co_writev " "bs %p sector_num %"PRId64" nb_sectors %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, sector_num, nb_sector);
        }
    }
}

static inline void trace_bdrv_co_pwrite_zeroes(void * bs, int64_t offset, int count, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_CO_PWRITE_ZEROES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_co_pwrite_zeroes " "bs %p offset %"PRId64" count %d flags %#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, offset, count, flags);
        }
    }
}

static inline void trace_bdrv_co_do_copy_on_readv(void * bs, int64_t offset, unsigned int bytes, int64_t cluster_offset, unsigned int cluster_bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_BDRV_CO_DO_COPY_ON_READV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:bdrv_co_do_copy_on_readv " "bs %p offset %"PRId64" bytes %u cluster_offset %"PRId64" cluster_bytes %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, offset, bytes, cluster_offset, cluster_bytes);
        }
    }
}

static inline void trace_stream_one_iteration(void * s, int64_t sector_num, int nb_sectors, int is_allocated)
{
    if (true) {
        if (trace_event_get_state(TRACE_STREAM_ONE_ITERATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:stream_one_iteration " "s %p sector_num %"PRId64" nb_sectors %d is_allocated %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, sector_num, nb_sectors, is_allocated);
        }
    }
}

static inline void trace_stream_start(void * bs, void * base, void * s, void * co, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_STREAM_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:stream_start " "bs %p base %p s %p co %p opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, base, s, co, opaque);
        }
    }
}

static inline void trace_commit_one_iteration(void * s, int64_t sector_num, int nb_sectors, int is_allocated)
{
    if (true) {
        if (trace_event_get_state(TRACE_COMMIT_ONE_ITERATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:commit_one_iteration " "s %p sector_num %"PRId64" nb_sectors %d is_allocated %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, sector_num, nb_sectors, is_allocated);
        }
    }
}

static inline void trace_commit_start(void * bs, void * base, void * top, void * s, void * co, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_COMMIT_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:commit_start " "bs %p base %p top %p s %p co %p opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, base, top, s, co, opaque);
        }
    }
}

static inline void trace_mirror_start(void * bs, void * s, void * co, void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_start " "bs %p s %p co %p opaque %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, s, co, opaque);
        }
    }
}

static inline void trace_mirror_restart_iter(void * s, int64_t cnt)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_RESTART_ITER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_restart_iter " "s %p dirty count %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, cnt);
        }
    }
}

static inline void trace_mirror_before_flush(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_BEFORE_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_before_flush " "s %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_mirror_before_drain(void * s, int64_t cnt)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_BEFORE_DRAIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_before_drain " "s %p dirty count %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, cnt);
        }
    }
}

static inline void trace_mirror_before_sleep(void * s, int64_t cnt, int synced, uint64_t delay_ns)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_BEFORE_SLEEP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_before_sleep " "s %p dirty count %"PRId64" synced %d delay %"PRIu64"ns" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, cnt, synced, delay_ns);
        }
    }
}

static inline void trace_mirror_one_iteration(void * s, int64_t sector_num, int nb_sectors)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_ONE_ITERATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_one_iteration " "s %p sector_num %"PRId64" nb_sectors %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, sector_num, nb_sectors);
        }
    }
}

static inline void trace_mirror_iteration_done(void * s, int64_t sector_num, int nb_sectors, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_ITERATION_DONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_iteration_done " "s %p sector_num %"PRId64" nb_sectors %d ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, sector_num, nb_sectors, ret);
        }
    }
}

static inline void trace_mirror_yield(void * s, int64_t cnt, int buf_free_count, int in_flight)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_YIELD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_yield " "s %p dirty count %"PRId64" free buffers %d in_flight %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, cnt, buf_free_count, in_flight);
        }
    }
}

static inline void trace_mirror_yield_in_flight(void * s, int64_t sector_num, int in_flight)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_YIELD_IN_FLIGHT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_yield_in_flight " "s %p sector_num %"PRId64" in_flight %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, sector_num, in_flight);
        }
    }
}

static inline void trace_mirror_yield_buf_busy(void * s, int nb_chunks, int in_flight)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_YIELD_BUF_BUSY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_yield_buf_busy " "s %p requested chunks %d in_flight %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, nb_chunks, in_flight);
        }
    }
}

static inline void trace_mirror_break_buf_busy(void * s, int nb_chunks, int in_flight)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIRROR_BREAK_BUF_BUSY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mirror_break_buf_busy " "s %p requested chunks %d in_flight %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, nb_chunks, in_flight);
        }
    }
}

static inline void trace_backup_do_cow_enter(void * job, int64_t start, int64_t sector_num, int nb_sectors)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_ENTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_enter " "job %p start %"PRId64" sector_num %"PRId64" nb_sectors %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, start, sector_num, nb_sectors);
        }
    }
}

static inline void trace_backup_do_cow_return(void * job, int64_t sector_num, int nb_sectors, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_return " "job %p sector_num %"PRId64" nb_sectors %d ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, sector_num, nb_sectors, ret);
        }
    }
}

static inline void trace_backup_do_cow_skip(void * job, int64_t start)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_SKIP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_skip " "job %p start %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, start);
        }
    }
}

static inline void trace_backup_do_cow_process(void * job, int64_t start)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_PROCESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_process " "job %p start %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, start);
        }
    }
}

static inline void trace_backup_do_cow_read_fail(void * job, int64_t start, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_READ_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_read_fail " "job %p start %"PRId64" ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, start, ret);
        }
    }
}

static inline void trace_backup_do_cow_write_fail(void * job, int64_t start, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_BACKUP_DO_COW_WRITE_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:backup_do_cow_write_fail " "job %p start %"PRId64" ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job, start, ret);
        }
    }
}

static inline void trace_qmp_block_job_cancel(void * job)
{
    if (true) {
        if (trace_event_get_state(TRACE_QMP_BLOCK_JOB_CANCEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qmp_block_job_cancel " "job %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job);
        }
    }
}

static inline void trace_qmp_block_job_pause(void * job)
{
    if (true) {
        if (trace_event_get_state(TRACE_QMP_BLOCK_JOB_PAUSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qmp_block_job_pause " "job %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job);
        }
    }
}

static inline void trace_qmp_block_job_resume(void * job)
{
    if (true) {
        if (trace_event_get_state(TRACE_QMP_BLOCK_JOB_RESUME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qmp_block_job_resume " "job %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job);
        }
    }
}

static inline void trace_qmp_block_job_complete(void * job)
{
    if (true) {
        if (trace_event_get_state(TRACE_QMP_BLOCK_JOB_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qmp_block_job_complete " "job %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , job);
        }
    }
}

static inline void trace_block_job_cb(void * bs, void * job, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_BLOCK_JOB_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:block_job_cb " "bs %p job %p ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, job, ret);
        }
    }
}

static inline void trace_qmp_block_stream(void * bs, void * job)
{
    if (true) {
        if (trace_event_get_state(TRACE_QMP_BLOCK_STREAM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qmp_block_stream " "bs %p job %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, job);
        }
    }
}

static inline void trace_paio_submit_co(int64_t offset, int count, int type)
{
    if (true) {
        if (trace_event_get_state(TRACE_PAIO_SUBMIT_CO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:paio_submit_co " "offset %"PRId64" count %d type %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offset, count, type);
        }
    }
}

static inline void trace_paio_submit(void * acb, void * opaque, int64_t offset, int count, int type)
{
    if (true) {
        if (trace_event_get_state(TRACE_PAIO_SUBMIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:paio_submit " "acb %p opaque %p offset %"PRId64" count %d type %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , acb, opaque, offset, count, type);
        }
    }
}

static inline void trace_qcow2_writev_start_req(void * co, int64_t offset, int bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_WRITEV_START_REQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_writev_start_req " "co %p offset %" PRIx64 " bytes %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, offset, bytes);
        }
    }
}

static inline void trace_qcow2_writev_done_req(void * co, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_WRITEV_DONE_REQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_writev_done_req " "co %p ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, ret);
        }
    }
}

static inline void trace_qcow2_writev_start_part(void * co)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_WRITEV_START_PART)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_writev_start_part " "co %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co);
        }
    }
}

static inline void trace_qcow2_writev_done_part(void * co, int cur_bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_WRITEV_DONE_PART)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_writev_done_part " "co %p cur_bytes %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, cur_bytes);
        }
    }
}

static inline void trace_qcow2_writev_data(void * co, uint64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_WRITEV_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_writev_data " "co %p offset %" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, offset);
        }
    }
}

static inline void trace_qcow2_pwrite_zeroes_start_req(void * co, int64_t offset, int count)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_PWRITE_ZEROES_START_REQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_pwrite_zeroes_start_req " "co %p offset %" PRIx64 " count %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, offset, count);
        }
    }
}

static inline void trace_qcow2_pwrite_zeroes(void * co, int64_t offset, int count)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_PWRITE_ZEROES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_pwrite_zeroes " "co %p offset %" PRIx64 " count %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, offset, count);
        }
    }
}

static inline void trace_qcow2_alloc_clusters_offset(void * co, uint64_t offset, int bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_ALLOC_CLUSTERS_OFFSET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_alloc_clusters_offset " "co %p offset %" PRIx64 " bytes %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, offset, bytes);
        }
    }
}

static inline void trace_qcow2_handle_copied(void * co, uint64_t guest_offset, uint64_t host_offset, uint64_t bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_HANDLE_COPIED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_handle_copied " "co %p guest_offset %" PRIx64 " host_offset %" PRIx64 " bytes %" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, guest_offset, host_offset, bytes);
        }
    }
}

static inline void trace_qcow2_handle_alloc(void * co, uint64_t guest_offset, uint64_t host_offset, uint64_t bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_HANDLE_ALLOC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_handle_alloc " "co %p guest_offset %" PRIx64 " host_offset %" PRIx64 " bytes %" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, guest_offset, host_offset, bytes);
        }
    }
}

static inline void trace_qcow2_do_alloc_clusters_offset(void * co, uint64_t guest_offset, uint64_t host_offset, int nb_clusters)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_DO_ALLOC_CLUSTERS_OFFSET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_do_alloc_clusters_offset " "co %p guest_offset %" PRIx64 " host_offset %" PRIx64 " nb_clusters %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, guest_offset, host_offset, nb_clusters);
        }
    }
}

static inline void trace_qcow2_cluster_alloc_phys(void * co)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CLUSTER_ALLOC_PHYS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cluster_alloc_phys " "co %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co);
        }
    }
}

static inline void trace_qcow2_cluster_link_l2(void * co, int nb_clusters)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CLUSTER_LINK_L2)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cluster_link_l2 " "co %p nb_clusters %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, nb_clusters);
        }
    }
}

static inline void trace_qcow2_l2_allocate(void * bs, int l1_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_L2_ALLOCATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_l2_allocate " "bs %p l1_index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, l1_index);
        }
    }
}

static inline void trace_qcow2_l2_allocate_get_empty(void * bs, int l1_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_L2_ALLOCATE_GET_EMPTY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_l2_allocate_get_empty " "bs %p l1_index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, l1_index);
        }
    }
}

static inline void trace_qcow2_l2_allocate_write_l2(void * bs, int l1_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_L2_ALLOCATE_WRITE_L2)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_l2_allocate_write_l2 " "bs %p l1_index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, l1_index);
        }
    }
}

static inline void trace_qcow2_l2_allocate_write_l1(void * bs, int l1_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_L2_ALLOCATE_WRITE_L1)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_l2_allocate_write_l1 " "bs %p l1_index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, l1_index);
        }
    }
}

static inline void trace_qcow2_l2_allocate_done(void * bs, int l1_index, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_L2_ALLOCATE_DONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_l2_allocate_done " "bs %p l1_index %d ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bs, l1_index, ret);
        }
    }
}

static inline void trace_qcow2_cache_get(void * co, int c, uint64_t offset, bool read_from_disk)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_GET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_get " "co %p is_l2_cache %d offset %" PRIx64 " read_from_disk %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c, offset, read_from_disk);
        }
    }
}

static inline void trace_qcow2_cache_get_replace_entry(void * co, int c, int i)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_GET_REPLACE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_get_replace_entry " "co %p is_l2_cache %d index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c, i);
        }
    }
}

static inline void trace_qcow2_cache_get_read(void * co, int c, int i)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_GET_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_get_read " "co %p is_l2_cache %d index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c, i);
        }
    }
}

static inline void trace_qcow2_cache_get_done(void * co, int c, int i)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_GET_DONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_get_done " "co %p is_l2_cache %d index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c, i);
        }
    }
}

static inline void trace_qcow2_cache_flush(void * co, int c)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_flush " "co %p is_l2_cache %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c);
        }
    }
}

static inline void trace_qcow2_cache_entry_flush(void * co, int c, int i)
{
    if (true) {
        if (trace_event_get_state(TRACE_QCOW2_CACHE_ENTRY_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qcow2_cache_entry_flush " "co %p is_l2_cache %d index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , co, c, i);
        }
    }
}

static inline void trace_qed_alloc_l2_cache_entry(void * l2_cache, void * entry)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_ALLOC_L2_CACHE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_alloc_l2_cache_entry " "l2_cache %p entry %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , l2_cache, entry);
        }
    }
}

static inline void trace_qed_unref_l2_cache_entry(void * entry, int ref)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_UNREF_L2_CACHE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_unref_l2_cache_entry " "entry %p ref %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , entry, ref);
        }
    }
}

static inline void trace_qed_find_l2_cache_entry(void * l2_cache, void * entry, uint64_t offset, int ref)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_FIND_L2_CACHE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_find_l2_cache_entry " "l2_cache %p entry %p offset %"PRIu64" ref %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , l2_cache, entry, offset, ref);
        }
    }
}

static inline void trace_qed_read_table(void * s, uint64_t offset, void * table)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_READ_TABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_read_table " "s %p offset %"PRIu64" table %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, offset, table);
        }
    }
}

static inline void trace_qed_read_table_cb(void * s, void * table, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_READ_TABLE_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_read_table_cb " "s %p table %p ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, table, ret);
        }
    }
}

static inline void trace_qed_write_table(void * s, uint64_t offset, void * table, unsigned int index, unsigned int n)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_WRITE_TABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_write_table " "s %p offset %"PRIu64" table %p index %u n %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, offset, table, index, n);
        }
    }
}

static inline void trace_qed_write_table_cb(void * s, void * table, int flush, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_WRITE_TABLE_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_write_table_cb " "s %p table %p flush %d ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, table, flush, ret);
        }
    }
}

static inline void trace_qed_need_check_timer_cb(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_NEED_CHECK_TIMER_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_need_check_timer_cb " "s %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_qed_start_need_check_timer(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_START_NEED_CHECK_TIMER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_start_need_check_timer " "s %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_qed_cancel_need_check_timer(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_CANCEL_NEED_CHECK_TIMER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_cancel_need_check_timer " "s %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_qed_aio_complete(void * s, void * acb, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_complete " "s %p acb %p ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, ret);
        }
    }
}

static inline void trace_qed_aio_setup(void * s, void * acb, int64_t sector_num, int nb_sectors, void * opaque, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_SETUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_setup " "s %p acb %p sector_num %"PRId64" nb_sectors %d opaque %p flags %#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, sector_num, nb_sectors, opaque, flags);
        }
    }
}

static inline void trace_qed_aio_next_io(void * s, void * acb, int ret, uint64_t cur_pos)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_NEXT_IO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_next_io " "s %p acb %p ret %d cur_pos %"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, ret, cur_pos);
        }
    }
}

static inline void trace_qed_aio_read_data(void * s, void * acb, int ret, uint64_t offset, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_READ_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_read_data " "s %p acb %p ret %d offset %"PRIu64" len %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, ret, offset, len);
        }
    }
}

static inline void trace_qed_aio_write_data(void * s, void * acb, int ret, uint64_t offset, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_WRITE_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_write_data " "s %p acb %p ret %d offset %"PRIu64" len %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, ret, offset, len);
        }
    }
}

static inline void trace_qed_aio_write_prefill(void * s, void * acb, uint64_t start, size_t len, uint64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_WRITE_PREFILL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_write_prefill " "s %p acb %p start %"PRIu64" len %zu offset %"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, start, len, offset);
        }
    }
}

static inline void trace_qed_aio_write_postfill(void * s, void * acb, uint64_t start, size_t len, uint64_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_WRITE_POSTFILL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_write_postfill " "s %p acb %p start %"PRIu64" len %zu offset %"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, start, len, offset);
        }
    }
}

static inline void trace_qed_aio_write_main(void * s, void * acb, int ret, uint64_t offset, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_QED_AIO_WRITE_MAIN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qed_aio_write_main " "s %p acb %p ret %d offset %"PRIu64" len %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, acb, ret, offset, len);
        }
    }
}

static inline void trace_virtio_blk_req_complete(void * req, int status)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BLK_REQ_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_blk_req_complete " "req %p status %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, status);
        }
    }
}

static inline void trace_virtio_blk_rw_complete(void * req, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BLK_RW_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_blk_rw_complete " "req %p ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, ret);
        }
    }
}

static inline void trace_virtio_blk_handle_write(void * req, uint64_t sector, size_t nsectors)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BLK_HANDLE_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_blk_handle_write " "req %p sector %"PRIu64" nsectors %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, sector, nsectors);
        }
    }
}

static inline void trace_virtio_blk_handle_read(void * req, uint64_t sector, size_t nsectors)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BLK_HANDLE_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_blk_handle_read " "req %p sector %"PRIu64" nsectors %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , req, sector, nsectors);
        }
    }
}

static inline void trace_virtio_blk_submit_multireq(void * mrb, int start, int num_reqs, uint64_t offset, size_t size, bool is_write)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BLK_SUBMIT_MULTIREQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_blk_submit_multireq " "mrb %p start %d num_reqs %d offset %"PRIu64" size %zu is_write %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , mrb, start, num_reqs, offset, size, is_write);
        }
    }
}

static inline void trace_virtio_blk_data_plane_start(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BLK_DATA_PLANE_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_blk_data_plane_start " "dataplane %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_virtio_blk_data_plane_stop(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BLK_DATA_PLANE_STOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_blk_data_plane_stop " "dataplane %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_virtio_blk_data_plane_process_request(void * s, unsigned int out_num, unsigned int in_num, unsigned int head)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_BLK_DATA_PLANE_PROCESS_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_blk_data_plane_process_request " "dataplane %p out_num %u in_num %u head %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, out_num, in_num, head);
        }
    }
}

static inline void trace_hd_geometry_lchs_guess(void * blk, int cyls, int heads, int secs)
{
    if (true) {
        if (trace_event_get_state(TRACE_HD_GEOMETRY_LCHS_GUESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:hd_geometry_lchs_guess " "blk %p LCHS %d %d %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , blk, cyls, heads, secs);
        }
    }
}

static inline void trace_hd_geometry_guess(void * blk, uint32_t cyls, uint32_t heads, uint32_t secs, int trans)
{
    if (true) {
        if (trace_event_get_state(TRACE_HD_GEOMETRY_GUESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:hd_geometry_guess " "blk %p CHS %u %u %u trans %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , blk, cyls, heads, secs, trans);
        }
    }
}

static inline void trace_virtio_serial_send_control_event(unsigned int port, uint16_t event, uint16_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_SERIAL_SEND_CONTROL_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_serial_send_control_event " "port %u, event %u, value %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, event, value);
        }
    }
}

static inline void trace_virtio_serial_throttle_port(unsigned int port, bool throttle)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_SERIAL_THROTTLE_PORT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_serial_throttle_port " "port %u, throttle %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, throttle);
        }
    }
}

static inline void trace_virtio_serial_handle_control_message(uint16_t event, uint16_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_SERIAL_HANDLE_CONTROL_MESSAGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_serial_handle_control_message " "event %u, value %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event, value);
        }
    }
}

static inline void trace_virtio_serial_handle_control_message_port(unsigned int port)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_SERIAL_HANDLE_CONTROL_MESSAGE_PORT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_serial_handle_control_message_port " "port %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port);
        }
    }
}

static inline void trace_virtio_console_flush_buf(unsigned int port, size_t len, ssize_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_CONSOLE_FLUSH_BUF)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_console_flush_buf " "port %u, in_len %zu, out_len %zd" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, len, ret);
        }
    }
}

static inline void trace_virtio_console_chr_read(unsigned int port, int size)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_CONSOLE_CHR_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_console_chr_read " "port %u, size %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, size);
        }
    }
}

static inline void trace_virtio_console_chr_event(unsigned int port, int event)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_CONSOLE_CHR_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_console_chr_event " "port %u, event %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, event);
        }
    }
}

static inline void trace_grlib_apbuart_event(int event)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_APBUART_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_apbuart_event " "event:%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , event);
        }
    }
}

static inline void trace_grlib_apbuart_writel_unknown(uint64_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_APBUART_WRITEL_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_apbuart_writel_unknown " "addr 0x%"PRIx64" value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_grlib_apbuart_readl_unknown(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_APBUART_READL_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_apbuart_readl_unknown " "addr 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_lm32_juart_get_jtx(uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_JUART_GET_JTX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_juart_get_jtx " "jtx 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , value);
        }
    }
}

static inline void trace_lm32_juart_set_jtx(uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_JUART_SET_JTX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_juart_set_jtx " "jtx 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , value);
        }
    }
}

static inline void trace_lm32_juart_get_jrx(uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_JUART_GET_JRX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_juart_get_jrx " "jrx 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , value);
        }
    }
}

static inline void trace_lm32_juart_set_jrx(uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_JUART_SET_JRX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_juart_set_jrx " "jrx 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , value);
        }
    }
}

static inline void trace_lm32_uart_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_UART_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_uart_memory_write " "addr 0x%08x value 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_lm32_uart_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_UART_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_uart_memory_read " "addr 0x%08x value 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_lm32_uart_irq_state(int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_UART_IRQ_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_uart_irq_state " "irq state %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , level);
        }
    }
}

static inline void trace_milkymist_uart_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_UART_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_uart_memory_read " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_uart_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_UART_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_uart_memory_write " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_uart_raise_irq(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_UART_RAISE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_uart_raise_irq " "Raise IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_uart_lower_irq(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_UART_LOWER_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_uart_lower_irq " "Lower IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_escc_put_queue(char channel, int b)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_PUT_QUEUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_put_queue " "channel %c put: 0x%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , channel, b);
        }
    }
}

static inline void trace_escc_get_queue(char channel, int val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_GET_QUEUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_get_queue " "channel %c get 0x%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , channel, val);
        }
    }
}

static inline void trace_escc_update_irq(int irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_UPDATE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_update_irq " "IRQ = %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , irq);
        }
    }
}

static inline void trace_escc_update_parameters(char channel, int speed, int parity, int data_bits, int stop_bits)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_UPDATE_PARAMETERS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_update_parameters " "channel %c: speed=%d parity=%c data=%d stop=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , channel, speed, parity, data_bits, stop_bits);
        }
    }
}

static inline void trace_escc_mem_writeb_ctrl(char channel, uint32_t reg, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_MEM_WRITEB_CTRL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_mem_writeb_ctrl " "Write channel %c, reg[%d] = %2.2x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , channel, reg, val);
        }
    }
}

static inline void trace_escc_mem_writeb_data(char channel, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_MEM_WRITEB_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_mem_writeb_data " "Write channel %c, ch %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , channel, val);
        }
    }
}

static inline void trace_escc_mem_readb_ctrl(char channel, uint32_t reg, uint8_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_MEM_READB_CTRL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_mem_readb_ctrl " "Read channel %c, reg[%d] = %2.2x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , channel, reg, val);
        }
    }
}

static inline void trace_escc_mem_readb_data(char channel, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_MEM_READB_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_mem_readb_data " "Read channel %c, ch %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , channel, ret);
        }
    }
}

static inline void trace_escc_serial_receive_byte(char channel, int ch)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_SERIAL_RECEIVE_BYTE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_serial_receive_byte " "channel %c put ch %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , channel, ch);
        }
    }
}

static inline void trace_escc_sunkbd_event_in(int ch, const char * name, int down)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_SUNKBD_EVENT_IN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_sunkbd_event_in " "QKeyCode 0x%2.2x [%s], down %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ch, name, down);
        }
    }
}

static inline void trace_escc_sunkbd_event_out(int ch)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_SUNKBD_EVENT_OUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_sunkbd_event_out " "Translated keycode 0x%2.2x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ch);
        }
    }
}

static inline void trace_escc_kbd_command(int val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_KBD_COMMAND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_kbd_command " "Command %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_escc_sunmouse_event(int dx, int dy, int buttons_state)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESCC_SUNMOUSE_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:escc_sunmouse_event " "dx=%d dy=%d buttons=%01x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dx, dy, buttons_state);
        }
    }
}

static inline void trace_cpu_set_apic_base(uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_SET_APIC_BASE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_set_apic_base " "%016"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_cpu_get_apic_base(uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_GET_APIC_BASE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_get_apic_base " "%016"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_apic_report_irq_delivered(int apic_irq_delivered)
{
    if (true) {
        if (trace_event_get_state(TRACE_APIC_REPORT_IRQ_DELIVERED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:apic_report_irq_delivered " "coalescing %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , apic_irq_delivered);
        }
    }
}

static inline void trace_apic_reset_irq_delivered(int apic_irq_delivered)
{
    if (true) {
        if (trace_event_get_state(TRACE_APIC_RESET_IRQ_DELIVERED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:apic_reset_irq_delivered " "old coalescing %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , apic_irq_delivered);
        }
    }
}

static inline void trace_apic_get_irq_delivered(int apic_irq_delivered)
{
    if (true) {
        if (trace_event_get_state(TRACE_APIC_GET_IRQ_DELIVERED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:apic_get_irq_delivered " "returning coalescing %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , apic_irq_delivered);
        }
    }
}

static inline void trace_apic_local_deliver(int vector, uint32_t lvt)
{
    if (true) {
        if (trace_event_get_state(TRACE_APIC_LOCAL_DELIVER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:apic_local_deliver " "vector %d delivery mode %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vector, lvt);
        }
    }
}

static inline void trace_apic_deliver_irq(uint8_t dest, uint8_t dest_mode, uint8_t delivery_mode, uint8_t vector_num, uint8_t trigger_mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_APIC_DELIVER_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:apic_deliver_irq " "dest %d dest_mode %d delivery_mode %d vector %d trigger_mode %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dest, dest_mode, delivery_mode, vector_num, trigger_mode);
        }
    }
}

static inline void trace_apic_mem_readl(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_APIC_MEM_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:apic_mem_readl " "%"PRIx64" = %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_apic_mem_writel(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_APIC_MEM_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:apic_mem_writel " "%"PRIx64" = %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_slavio_intctl_mem_readl(uint32_t cpu, uint64_t addr, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_INTCTL_MEM_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_intctl_mem_readl " "read cpu %d reg 0x%"PRIx64" = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, addr, ret);
        }
    }
}

static inline void trace_slavio_intctl_mem_writel(uint32_t cpu, uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_INTCTL_MEM_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_intctl_mem_writel " "write cpu %d reg 0x%"PRIx64" = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, addr, val);
        }
    }
}

static inline void trace_slavio_intctl_mem_writel_clear(uint32_t cpu, uint32_t val, uint32_t intreg_pending)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_INTCTL_MEM_WRITEL_CLEAR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_intctl_mem_writel_clear " "Cleared cpu %d irq mask %x, curmask %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val, intreg_pending);
        }
    }
}

static inline void trace_slavio_intctl_mem_writel_set(uint32_t cpu, uint32_t val, uint32_t intreg_pending)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_INTCTL_MEM_WRITEL_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_intctl_mem_writel_set " "Set cpu %d irq mask %x, curmask %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val, intreg_pending);
        }
    }
}

static inline void trace_slavio_intctlm_mem_readl(uint64_t addr, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_INTCTLM_MEM_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_intctlm_mem_readl " "read system reg 0x%"PRIx64" = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, ret);
        }
    }
}

static inline void trace_slavio_intctlm_mem_writel(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_INTCTLM_MEM_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_intctlm_mem_writel " "write system reg 0x%"PRIx64" = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_slavio_intctlm_mem_writel_enable(uint32_t val, uint32_t intregm_disabled)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_INTCTLM_MEM_WRITEL_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_intctlm_mem_writel_enable " "Enabled master irq mask %x, curmask %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val, intregm_disabled);
        }
    }
}

static inline void trace_slavio_intctlm_mem_writel_disable(uint32_t val, uint32_t intregm_disabled)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_INTCTLM_MEM_WRITEL_DISABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_intctlm_mem_writel_disable " "Disabled master irq mask %x, curmask %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val, intregm_disabled);
        }
    }
}

static inline void trace_slavio_intctlm_mem_writel_target(uint32_t cpu)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_INTCTLM_MEM_WRITEL_TARGET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_intctlm_mem_writel_target " "Set master irq cpu %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu);
        }
    }
}

static inline void trace_slavio_check_interrupts(uint32_t pending, uint32_t intregm_disabled)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_CHECK_INTERRUPTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_check_interrupts " "pending %x disabled %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pending, intregm_disabled);
        }
    }
}

static inline void trace_slavio_set_irq(uint32_t target_cpu, int irq, uint32_t pil, int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_SET_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_set_irq " "Set cpu %d irq %d -> pil %d level %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target_cpu, irq, pil, level);
        }
    }
}

static inline void trace_slavio_set_timer_irq_cpu(int cpu, int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_SET_TIMER_IRQ_CPU)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_set_timer_irq_cpu " "Set cpu %d local timer level %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, level);
        }
    }
}

static inline void trace_grlib_irqmp_check_irqs(uint32_t pend, uint32_t force, uint32_t mask, uint32_t lvl1, uint32_t lvl2)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_IRQMP_CHECK_IRQS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_irqmp_check_irqs " "pend:0x%04x force:0x%04x mask:0x%04x lvl1:0x%04x lvl0:0x%04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pend, force, mask, lvl1, lvl2);
        }
    }
}

static inline void trace_grlib_irqmp_ack(int intno)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_IRQMP_ACK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_irqmp_ack " "interrupt:%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , intno);
        }
    }
}

static inline void trace_grlib_irqmp_set_irq(int irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_IRQMP_SET_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_irqmp_set_irq " "Raise CPU IRQ %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , irq);
        }
    }
}

static inline void trace_grlib_irqmp_readl_unknown(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_IRQMP_READL_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_irqmp_readl_unknown " "addr 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_grlib_irqmp_writel_unknown(uint64_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_IRQMP_WRITEL_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_irqmp_writel_unknown " "addr 0x%"PRIx64" value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_lm32_pic_raise_irq(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_PIC_RAISE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_pic_raise_irq " "Raise CPU interrupt" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_lm32_pic_lower_irq(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_PIC_LOWER_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_pic_lower_irq " "Lower CPU interrupt" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_lm32_pic_interrupt(int irq, int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_PIC_INTERRUPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_pic_interrupt " "Set IRQ%d %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , irq, level);
        }
    }
}

static inline void trace_lm32_pic_set_im(uint32_t im)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_PIC_SET_IM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_pic_set_im " "im 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , im);
        }
    }
}

static inline void trace_lm32_pic_set_ip(uint32_t ip)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_PIC_SET_IP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_pic_set_ip " "ip 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ip);
        }
    }
}

static inline void trace_lm32_pic_get_im(uint32_t im)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_PIC_GET_IM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_pic_get_im " "im 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , im);
        }
    }
}

static inline void trace_lm32_pic_get_ip(uint32_t ip)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_PIC_GET_IP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_pic_get_ip " "ip 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ip);
        }
    }
}

static inline void trace_xics_icp_check_ipi(int server, uint8_t mfrr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ICP_CHECK_IPI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_icp_check_ipi " "CPU %d can take IPI mfrr=%#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , server, mfrr);
        }
    }
}

static inline void trace_xics_icp_accept(uint32_t old_xirr, uint32_t new_xirr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ICP_ACCEPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_icp_accept " "icp_accept: XIRR %#"PRIx32"->%#"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , old_xirr, new_xirr);
        }
    }
}

static inline void trace_xics_icp_eoi(int server, uint32_t xirr, uint32_t new_xirr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ICP_EOI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_icp_eoi " "icp_eoi: server %d given XIRR %#"PRIx32" new XIRR %#"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , server, xirr, new_xirr);
        }
    }
}

static inline void trace_xics_icp_irq(int server, int nr, uint8_t priority)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ICP_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_icp_irq " "cpu %d trying to deliver irq %#"PRIx32" priority %#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , server, nr, priority);
        }
    }
}

static inline void trace_xics_icp_raise(uint32_t xirr, uint8_t pending_priority)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ICP_RAISE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_icp_raise " "raising IRQ new XIRR=%#x new pending priority=%#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , xirr, pending_priority);
        }
    }
}

static inline void trace_xics_set_irq_msi(int srcno, int nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_SET_IRQ_MSI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_set_irq_msi " "set_irq_msi: srcno %d [irq %#x]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , srcno, nr);
        }
    }
}

static inline void trace_xics_masked_pending(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_MASKED_PENDING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_masked_pending " "set_irq_msi: masked pending" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_xics_set_irq_lsi(int srcno, int nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_SET_IRQ_LSI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_set_irq_lsi " "set_irq_lsi: srcno %d [irq %#x]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , srcno, nr);
        }
    }
}

static inline void trace_xics_ics_write_xive(int nr, int srcno, int server, uint8_t priority)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ICS_WRITE_XIVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_ics_write_xive " "ics_write_xive: irq %#x [src %d] server %#x prio %#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nr, srcno, server, priority);
        }
    }
}

static inline void trace_xics_ics_reject(int nr, int srcno)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ICS_REJECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_ics_reject " "reject irq %#x [src %d]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nr, srcno);
        }
    }
}

static inline void trace_xics_ics_eoi(int nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ICS_EOI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_ics_eoi " "ics_eoi: irq %#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nr);
        }
    }
}

static inline void trace_xics_alloc(int src, int irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ALLOC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_alloc " "source#%d, irq %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , src, irq);
        }
    }
}

static inline void trace_xics_alloc_block(int src, int first, int num, bool lsi, int align)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ALLOC_BLOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_alloc_block " "source#%d, first irq %d, %d irqs, lsi=%d, alignnum %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , src, first, num, lsi, align);
        }
    }
}

static inline void trace_xics_ics_free(int src, int irq, int num)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ICS_FREE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_ics_free " "Source#%d, first irq %d, %d irqs" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , src, irq, num);
        }
    }
}

static inline void trace_xics_ics_free_warn(int src, int irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_XICS_ICS_FREE_WARN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xics_ics_free_warn " "Source#%d, irq %d is already free" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , src, irq);
        }
    }
}

static inline void trace_flic_create_device(int err)
{
    if (true) {
        if (trace_event_get_state(TRACE_FLIC_CREATE_DEVICE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:flic_create_device " "flic: create device failed %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , err);
        }
    }
}

static inline void trace_flic_no_device_api(int err)
{
    if (true) {
        if (trace_event_get_state(TRACE_FLIC_NO_DEVICE_API)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:flic_no_device_api " "flic: no Device Contral API support %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , err);
        }
    }
}

static inline void trace_flic_reset_failed(int err)
{
    if (true) {
        if (trace_event_get_state(TRACE_FLIC_RESET_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:flic_reset_failed " "flic: reset failed %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , err);
        }
    }
}

static inline void trace_aspeed_vic_set_irq(int irq, int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_VIC_SET_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_vic_set_irq " "Enabling IRQ %d: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , irq, level);
        }
    }
}

static inline void trace_aspeed_vic_update_fiq(int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_VIC_UPDATE_FIQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_vic_update_fiq " "Raising FIQ: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , flags);
        }
    }
}

static inline void trace_aspeed_vic_update_irq(int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_VIC_UPDATE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_vic_update_irq " "Raising IRQ: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , flags);
        }
    }
}

static inline void trace_aspeed_vic_read(uint64_t offset, unsigned size, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_VIC_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_vic_read " "From 0x%" PRIx64 " of size %u: 0x%" PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offset, size, value);
        }
    }
}

static inline void trace_aspeed_vic_write(uint64_t offset, unsigned size, uint32_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_VIC_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_vic_write " "To 0x%" PRIx64 " of size %u: 0x%" PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offset, size, data);
        }
    }
}

static inline void trace_gic_enable_irq(int irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_GIC_ENABLE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gic_enable_irq " "irq %d enabled" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , irq);
        }
    }
}

static inline void trace_gic_disable_irq(int irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_GIC_DISABLE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gic_disable_irq " "irq %d disabled" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , irq);
        }
    }
}

static inline void trace_gic_set_irq(int irq, int level, int cpumask, int target)
{
    if (true) {
        if (trace_event_get_state(TRACE_GIC_SET_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gic_set_irq " "irq %d level %d cpumask 0x%x target 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , irq, level, cpumask, target);
        }
    }
}

static inline void trace_gic_update_bestirq(int cpu, int irq, int prio, int priority_mask, int running_priority)
{
    if (true) {
        if (trace_event_get_state(TRACE_GIC_UPDATE_BESTIRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gic_update_bestirq " "cpu %d irq %d priority %d cpu priority mask %d cpu running priority %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, irq, prio, priority_mask, running_priority);
        }
    }
}

static inline void trace_gic_update_set_irq(int cpu, const char * name, int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_GIC_UPDATE_SET_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gic_update_set_irq " "cpu[%d]: %s = %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, name, level);
        }
    }
}

static inline void trace_gic_acknowledge_irq(int cpu, int irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_GIC_ACKNOWLEDGE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gic_acknowledge_irq " "cpu %d acknowledged irq %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, irq);
        }
    }
}

static inline void trace_gicv3_icc_pmr_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_PMR_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_pmr_read " "GICv3 ICC_PMR read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_pmr_write(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_PMR_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_pmr_write " "GICv3 ICC_PMR write cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_bpr_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_BPR_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_bpr_read " "GICv3 ICC_BPR read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_bpr_write(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_BPR_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_bpr_write " "GICv3 ICC_BPR write cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_ap_read(int regno, uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_AP_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_ap_read " "GICv3 ICC_AP%dR read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , regno, cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_ap_write(int regno, uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_AP_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_ap_write " "GICv3 ICC_AP%dR write cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , regno, cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_igrpen_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_IGRPEN_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_igrpen_read " "GICv3 ICC_IGRPEN read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_igrpen_write(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_IGRPEN_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_igrpen_write " "GICv3 ICC_IGRPEN write cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_igrpen1_el3_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_IGRPEN1_EL3_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_igrpen1_el3_read " "GICv3 ICC_IGRPEN1_EL3 read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_igrpen1_el3_write(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_IGRPEN1_EL3_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_igrpen1_el3_write " "GICv3 ICC_IGRPEN1_EL3 write cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_ctlr_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_CTLR_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_ctlr_read " "GICv3 ICC_CTLR read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_ctlr_write(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_CTLR_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_ctlr_write " "GICv3 ICC_CTLR write cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_ctlr_el3_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_CTLR_EL3_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_ctlr_el3_read " "GICv3 ICC_CTLR_EL3 read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_ctlr_el3_write(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_CTLR_EL3_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_ctlr_el3_write " "GICv3 ICC_CTLR_EL3 write cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_cpuif_update(uint32_t cpuid, int irq, int grp, int prio)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_CPUIF_UPDATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_cpuif_update " "GICv3 CPU i/f %x HPPI update: irq %d group %d prio %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpuid, irq, grp, prio);
        }
    }
}

static inline void trace_gicv3_cpuif_set_irqs(uint32_t cpuid, int fiqlevel, int irqlevel)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_CPUIF_SET_IRQS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_cpuif_set_irqs " "GICv3 CPU i/f %x HPPI update: setting FIQ %d IRQ %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpuid, fiqlevel, irqlevel);
        }
    }
}

static inline void trace_gicv3_icc_generate_sgi(uint32_t cpuid, int irq, int irm, uint32_t aff, uint32_t targetlist)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_GENERATE_SGI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_generate_sgi " "GICv3 CPU i/f %x generating SGI %d IRM %d target affinity 0x%xxx targetlist 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpuid, irq, irm, aff, targetlist);
        }
    }
}

static inline void trace_gicv3_icc_iar0_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_IAR0_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_iar0_read " "GICv3 ICC_IAR0 read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_iar1_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_IAR1_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_iar1_read " "GICv3 ICC_IAR1 read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_eoir_write(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_EOIR_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_eoir_write " "GICv3 ICC_EOIR write cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_hppir0_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_HPPIR0_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_hppir0_read " "GICv3 ICC_HPPIR0 read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_hppir1_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_HPPIR1_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_hppir1_read " "GICv3 ICC_HPPIR1 read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_dir_write(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_DIR_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_dir_write " "GICv3 ICC_DIR write cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_icc_rpr_read(uint32_t cpu, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_ICC_RPR_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_icc_rpr_read " "GICv3 ICC_RPR read cpu %x value 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, val);
        }
    }
}

static inline void trace_gicv3_dist_read(uint64_t offset, uint64_t data, unsigned size, bool secure)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_DIST_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_dist_read " "GICv3 distributor read: offset 0x%" PRIx64 " data 0x%" PRIx64 " size %u secure %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offset, data, size, secure);
        }
    }
}

static inline void trace_gicv3_dist_badread(uint64_t offset, unsigned size, bool secure)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_DIST_BADREAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_dist_badread " "GICv3 distributor read: offset 0x%" PRIx64 " size %u secure %d: error" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offset, size, secure);
        }
    }
}

static inline void trace_gicv3_dist_write(uint64_t offset, uint64_t data, unsigned size, bool secure)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_DIST_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_dist_write " "GICv3 distributor write: offset 0x%" PRIx64 " data 0x%" PRIx64 " size %u secure %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offset, data, size, secure);
        }
    }
}

static inline void trace_gicv3_dist_badwrite(uint64_t offset, uint64_t data, unsigned size, bool secure)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_DIST_BADWRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_dist_badwrite " "GICv3 distributor write: offset 0x%" PRIx64 " data 0x%" PRIx64 " size %u secure %d: error" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offset, data, size, secure);
        }
    }
}

static inline void trace_gicv3_dist_set_irq(int irq, int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_DIST_SET_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_dist_set_irq " "GICv3 distributor interrupt %d level changed to %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , irq, level);
        }
    }
}

static inline void trace_gicv3_redist_read(uint32_t cpu, uint64_t offset, uint64_t data, unsigned size, bool secure)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_REDIST_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_redist_read " "GICv3 redistributor %x read: offset 0x%" PRIx64 " data 0x%" PRIx64 " size %u secure %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, offset, data, size, secure);
        }
    }
}

static inline void trace_gicv3_redist_badread(uint32_t cpu, uint64_t offset, unsigned size, bool secure)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_REDIST_BADREAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_redist_badread " "GICv3 redistributor %x read: offset 0x%" PRIx64 " size %u secure %d: error" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, offset, size, secure);
        }
    }
}

static inline void trace_gicv3_redist_write(uint32_t cpu, uint64_t offset, uint64_t data, unsigned size, bool secure)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_REDIST_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_redist_write " "GICv3 redistributor %x write: offset 0x%" PRIx64 " data 0x%" PRIx64 " size %u secure %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, offset, data, size, secure);
        }
    }
}

static inline void trace_gicv3_redist_badwrite(uint32_t cpu, uint64_t offset, uint64_t data, unsigned size, bool secure)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_REDIST_BADWRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_redist_badwrite " "GICv3 redistributor %x write: offset 0x%" PRIx64 " data 0x%" PRIx64 " size %u secure %d: error" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, offset, data, size, secure);
        }
    }
}

static inline void trace_gicv3_redist_set_irq(uint32_t cpu, int irq, int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_REDIST_SET_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_redist_set_irq " "GICv3 redistributor %x interrupt %d level changed to %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, irq, level);
        }
    }
}

static inline void trace_gicv3_redist_send_sgi(uint32_t cpu, int irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_GICV3_REDIST_SEND_SGI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gicv3_redist_send_sgi " "GICv3 redistributor %x pending SGI %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu, irq);
        }
    }
}

static inline void trace_lance_mem_readw(uint64_t addr, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_LANCE_MEM_READW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lance_mem_readw " "addr=%"PRIx64"val=0x%04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, ret);
        }
    }
}

static inline void trace_lance_mem_writew(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_LANCE_MEM_WRITEW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lance_mem_writew " "addr=%"PRIx64"val=0x%04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_milkymist_minimac2_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MINIMAC2_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_minimac2_memory_read " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_minimac2_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MINIMAC2_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_minimac2_memory_write " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_minimac2_mdio_write(uint8_t phy_addr, uint8_t addr, uint16_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MINIMAC2_MDIO_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_minimac2_mdio_write " "phy_addr %02x addr %02x value %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , phy_addr, addr, value);
        }
    }
}

static inline void trace_milkymist_minimac2_mdio_read(uint8_t phy_addr, uint8_t addr, uint16_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MINIMAC2_MDIO_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_minimac2_mdio_read " "phy_addr %02x addr %02x value %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , phy_addr, addr, value);
        }
    }
}

static inline void trace_milkymist_minimac2_tx_frame(uint32_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MINIMAC2_TX_FRAME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_minimac2_tx_frame " "length %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , length);
        }
    }
}

static inline void trace_milkymist_minimac2_rx_frame(const void * buf, uint32_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MINIMAC2_RX_FRAME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_minimac2_rx_frame " "buf %p length %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , buf, length);
        }
    }
}

static inline void trace_milkymist_minimac2_rx_transfer(const void * buf, uint32_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MINIMAC2_RX_TRANSFER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_minimac2_rx_transfer " "buf %p length %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , buf, length);
        }
    }
}

static inline void trace_milkymist_minimac2_raise_irq_rx(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MINIMAC2_RAISE_IRQ_RX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_minimac2_raise_irq_rx " "Raise IRQ RX" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_minimac2_lower_irq_rx(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MINIMAC2_LOWER_IRQ_RX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_minimac2_lower_irq_rx " "Lower IRQ RX" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_minimac2_pulse_irq_tx(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MINIMAC2_PULSE_IRQ_TX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_minimac2_pulse_irq_tx " "Pulse IRQ TX" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_mipsnet_send(uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIPSNET_SEND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mipsnet_send " "sending len=%u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , size);
        }
    }
}

static inline void trace_mipsnet_receive(uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIPSNET_RECEIVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mipsnet_receive " "receiving len=%u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , size);
        }
    }
}

static inline void trace_mipsnet_read(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIPSNET_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mipsnet_read " "read addr=0x%" PRIx64 " val=0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_mipsnet_write(uint64_t addr, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIPSNET_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mipsnet_write " "write addr=0x%" PRIx64 " val=0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_mipsnet_irq(uint32_t isr, uint32_t intctl)
{
    if (true) {
        if (trace_event_get_state(TRACE_MIPSNET_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mipsnet_irq " "set irq to %d (%02x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , isr, intctl);
        }
    }
}

static inline void trace_open_eth_mii_write(unsigned idx, uint16_t v)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_MII_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_mii_write " "MII[%02x] <- %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx, v);
        }
    }
}

static inline void trace_open_eth_mii_read(unsigned idx, uint16_t v)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_MII_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_mii_read " "MII[%02x] -> %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx, v);
        }
    }
}

static inline void trace_open_eth_update_irq(uint32_t v)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_UPDATE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_update_irq " "IRQ <- %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , v);
        }
    }
}

static inline void trace_open_eth_receive(unsigned len)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_RECEIVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_receive " "RX: len: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , len);
        }
    }
}

static inline void trace_open_eth_receive_mcast(unsigned idx, uint32_t h0, uint32_t h1)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_RECEIVE_MCAST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_receive_mcast " "MCAST: idx = %u, hash: %08x:%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx, h0, h1);
        }
    }
}

static inline void trace_open_eth_receive_reject(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_RECEIVE_REJECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_receive_reject " "RX: rejected" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_open_eth_receive_desc(uint32_t addr, uint32_t len_flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_RECEIVE_DESC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_receive_desc " "RX: %08x, len_flags: %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, len_flags);
        }
    }
}

static inline void trace_open_eth_start_xmit(uint32_t addr, unsigned len, unsigned tx_len)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_START_XMIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_start_xmit " "TX: %08x, len: %u, tx_len: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, len, tx_len);
        }
    }
}

static inline void trace_open_eth_reg_read(uint32_t addr, uint32_t v)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_REG_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_reg_read " "MAC[%02x] -> %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, v);
        }
    }
}

static inline void trace_open_eth_reg_write(uint32_t addr, uint32_t v)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_REG_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_reg_write " "MAC[%02x] <- %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, v);
        }
    }
}

static inline void trace_open_eth_desc_read(uint32_t addr, uint32_t v)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_DESC_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_desc_read " "DESC[%04x] -> %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, v);
        }
    }
}

static inline void trace_open_eth_desc_write(uint32_t addr, uint32_t v)
{
    if (true) {
        if (trace_event_get_state(TRACE_OPEN_ETH_DESC_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:open_eth_desc_write " "DESC[%04x] <- %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, v);
        }
    }
}

static inline void trace_pcnet_s_reset(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_S_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_s_reset " "s=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_pcnet_user_int(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_USER_INT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_user_int " "s=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_pcnet_isr_change(void * s, uint32_t isr, uint32_t isr_old)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_ISR_CHANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_isr_change " "s=%p INTA=%d<=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, isr, isr_old);
        }
    }
}

static inline void trace_pcnet_init(void * s, uint64_t init_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_INIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_init " "s=%p init_addr=%#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, init_addr);
        }
    }
}

static inline void trace_pcnet_rlen_tlen(void * s, uint32_t rlen, uint32_t tlen)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_RLEN_TLEN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_rlen_tlen " "s=%p rlen=%d tlen=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, rlen, tlen);
        }
    }
}

static inline void trace_pcnet_ss32_rdra_tdra(void * s, uint32_t ss32, uint32_t rdra, uint32_t rcvrl, uint32_t tdra, uint32_t xmtrl)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_SS32_RDRA_TDRA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_ss32_rdra_tdra " "s=%p ss32=%d rdra=0x%08x[%d] tdra=0x%08x[%d]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, ss32, rdra, rcvrl, tdra, xmtrl);
        }
    }
}

static inline void trace_pcnet_aprom_writeb(void * opaque, uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_APROM_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_aprom_writeb " "opaque=%p addr=0x%08x val=0x%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr, val);
        }
    }
}

static inline void trace_pcnet_aprom_readb(void * opaque, uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_APROM_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_aprom_readb " "opaque=%p addr=0x%08x val=0x%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr, val);
        }
    }
}

static inline void trace_pcnet_ioport_read(void * opaque, uint64_t addr, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_IOPORT_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_ioport_read " "opaque=%p addr=%#"PRIx64" size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr, size);
        }
    }
}

static inline void trace_pcnet_ioport_write(void * opaque, uint64_t addr, uint64_t data, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_IOPORT_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_ioport_write " "opaque=%p addr=%#"PRIx64" data=%#"PRIx64" size=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr, data, size);
        }
    }
}

static inline void trace_pcnet_mmio_writeb(void * opaque, uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_MMIO_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_mmio_writeb " "opaque=%p addr=%#"PRIx64" val=0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr, val);
        }
    }
}

static inline void trace_pcnet_mmio_writew(void * opaque, uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_MMIO_WRITEW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_mmio_writew " "opaque=%p addr=%#"PRIx64" val=0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr, val);
        }
    }
}

static inline void trace_pcnet_mmio_writel(void * opaque, uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_MMIO_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_mmio_writel " "opaque=%p addr=%#"PRIx64" val=0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr, val);
        }
    }
}

static inline void trace_pcnet_mmio_readb(void * opaque, uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_MMIO_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_mmio_readb " "opaque=%p addr=%#"PRIx64" val=0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr, val);
        }
    }
}

static inline void trace_pcnet_mmio_readw(void * opaque, uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_MMIO_READW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_mmio_readw " "opaque=%p addr=%#"PRIx64" val=0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr, val);
        }
    }
}

static inline void trace_pcnet_mmio_readl(void * opaque, uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCNET_MMIO_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pcnet_mmio_readl " "opaque=%p addr=%#"PRIx64" val=0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, addr, val);
        }
    }
}

static inline void trace_net_rx_pkt_parsed(bool ip4, bool ip6, bool udp, bool tcp, size_t l3o, size_t l4o, size_t l5o)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_PARSED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_parsed " "RX packet parsed: ip4: %d, ip6: %d, udp: %d, tcp: %d, l3 offset: %zu, l4 offset: %zu, l5 offset: %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ip4, ip6, udp, tcp, l3o, l4o, l5o);
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_validate_entry(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_VALIDATE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_validate_entry " "Starting L4 checksum validation" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_validate_not_xxp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_VALIDATE_NOT_XXP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_validate_not_xxp " "Not a TCP/UDP packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_validate_udp_with_no_checksum(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_VALIDATE_UDP_WITH_NO_CHECKSUM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_validate_udp_with_no_checksum " "UDP packet without checksum" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_validate_ip4_fragment(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_VALIDATE_IP4_FRAGMENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_validate_ip4_fragment " "IP4 fragment" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_validate_ip4_udp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_VALIDATE_IP4_UDP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_validate_ip4_udp " "IP4/UDP packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_validate_ip4_tcp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_VALIDATE_IP4_TCP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_validate_ip4_tcp " "IP4/TCP packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_validate_ip6_udp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_VALIDATE_IP6_UDP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_validate_ip6_udp " "IP6/UDP packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_validate_ip6_tcp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_VALIDATE_IP6_TCP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_validate_ip6_tcp " "IP6/TCP packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_validate_csum(bool csum_valid)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_VALIDATE_CSUM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_validate_csum " "Checksum valid: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , csum_valid);
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_calc_entry(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_CALC_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_calc_entry " "Starting L4 checksum calculation" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_calc_ip4_udp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_CALC_IP4_UDP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_calc_ip4_udp " "IP4/UDP packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_calc_ip4_tcp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_CALC_IP4_TCP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_calc_ip4_tcp " "IP4/TCP packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_calc_ip6_udp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_CALC_IP6_UDP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_calc_ip6_udp " "IP6/UDP packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_calc_ip6_tcp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_CALC_IP6_TCP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_calc_ip6_tcp " "IP6/TCP packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_calc_ph_csum(uint32_t cntr, uint16_t csl)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_CALC_PH_CSUM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_calc_ph_csum " "Pseudo-header: checksum counter %u, length %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cntr, csl);
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_calc_csum(size_t l4hdr_off, uint16_t csl, uint32_t cntr, uint16_t csum)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_CALC_CSUM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_calc_csum " "L4 Checksum: L4 header offset: %zu, length: %u, counter: 0x%X, final checksum: 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , l4hdr_off, csl, cntr, csum);
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_fix_entry(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_FIX_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_fix_entry " "Starting L4 checksum correction" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_fix_tcp(uint32_t l4_cso)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_FIX_TCP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_fix_tcp " "TCP packet, L4 cso: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , l4_cso);
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_fix_udp(uint32_t l4_cso)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_FIX_UDP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_fix_udp " "UDP packet, L4 cso: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , l4_cso);
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_fix_not_xxp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_FIX_NOT_XXP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_fix_not_xxp " "Not an IP4 packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_fix_ip4_fragment(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_FIX_IP4_FRAGMENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_fix_ip4_fragment " "IP4 fragment" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_fix_udp_with_no_checksum(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_FIX_UDP_WITH_NO_CHECKSUM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_fix_udp_with_no_checksum " "UDP packet without checksum" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l4_csum_fix_csum(uint32_t cso, uint16_t csum)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L4_CSUM_FIX_CSUM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l4_csum_fix_csum " "L4 Checksum: Offset: %u, value 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cso, csum);
        }
    }
}

static inline void trace_net_rx_pkt_l3_csum_validate_entry(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L3_CSUM_VALIDATE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l3_csum_validate_entry " "Starting L3 checksum validation" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l3_csum_validate_not_ip4(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L3_CSUM_VALIDATE_NOT_IP4)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l3_csum_validate_not_ip4 " "Not an IP4 packet" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_l3_csum_validate_csum(size_t l3hdr_off, uint32_t csl, uint32_t cntr, uint16_t csum, bool csum_valid)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_L3_CSUM_VALIDATE_CSUM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_l3_csum_validate_csum " "L3 Checksum: L3 header offset: %zu, length: %u, counter: 0x%X, final checksum: 0x%X, valid: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , l3hdr_off, csl, cntr, csum, csum_valid);
        }
    }
}

static inline void trace_net_rx_pkt_rss_ip4(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_RSS_IP4)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_rss_ip4 " "Calculating IPv4 RSS  hash" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_rss_ip4_tcp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_RSS_IP4_TCP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_rss_ip4_tcp " "Calculating IPv4/TCP RSS  hash" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_rss_ip6_tcp(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_RSS_IP6_TCP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_rss_ip6_tcp " "Calculating IPv6/TCP RSS  hash" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_rss_ip6(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_RSS_IP6)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_rss_ip6 " "Calculating IPv6 RSS  hash" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_rss_ip6_ex(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_RSS_IP6_EX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_rss_ip6_ex " "Calculating IPv6/EX RSS  hash" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_net_rx_pkt_rss_hash(size_t rss_length, uint32_t rss_hash)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_RSS_HASH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_rss_hash " "RSS hash for %zu bytes: 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rss_length, rss_hash);
        }
    }
}

static inline void trace_net_rx_pkt_rss_add_chunk(void* ptr, size_t size, size_t input_offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_NET_RX_PKT_RSS_ADD_CHUNK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:net_rx_pkt_rss_add_chunk " "Add RSS chunk %p, %zu bytes, RSS input offset %zu bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ptr, size, input_offset);
        }
    }
}

static inline void trace_e1000x_rx_can_recv_disabled(bool link_up, bool rx_enabled, bool pci_master)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_RX_CAN_RECV_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_rx_can_recv_disabled " "link_up: %d, rx_enabled %d, pci_master %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , link_up, rx_enabled, pci_master);
        }
    }
}

static inline void trace_e1000x_vlan_is_vlan_pkt(bool is_vlan_pkt, uint16_t eth_proto, uint16_t vet)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_VLAN_IS_VLAN_PKT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_vlan_is_vlan_pkt " "Is VLAN packet: %d, ETH proto: 0x%X, VET: 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , is_vlan_pkt, eth_proto, vet);
        }
    }
}

static inline void trace_e1000x_rx_flt_ucast_match(uint32_t idx, uint8_t b0, uint8_t b1, uint8_t b2, uint8_t b3, uint8_t b4, uint8_t b5)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_RX_FLT_UCAST_MATCH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_rx_flt_ucast_match " "unicast match[%d]: %02x:%02x:%02x:%02x:%02x:%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx, b0, b1, b2, b3, b4, b5);
        }
    }
}

static inline void trace_e1000x_rx_flt_ucast_mismatch(uint8_t b0, uint8_t b1, uint8_t b2, uint8_t b3, uint8_t b4, uint8_t b5)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_RX_FLT_UCAST_MISMATCH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_rx_flt_ucast_mismatch " "unicast mismatch: %02x:%02x:%02x:%02x:%02x:%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , b0, b1, b2, b3, b4, b5);
        }
    }
}

static inline void trace_e1000x_rx_flt_inexact_mismatch(uint8_t b0, uint8_t b1, uint8_t b2, uint8_t b3, uint8_t b4, uint8_t b5, uint32_t mo, uint32_t mta, uint32_t mta_val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_RX_FLT_INEXACT_MISMATCH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_rx_flt_inexact_mismatch " "inexact mismatch: %02x:%02x:%02x:%02x:%02x:%02x MO %d MTA[%d] %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , b0, b1, b2, b3, b4, b5, mo, mta, mta_val);
        }
    }
}

static inline void trace_e1000x_rx_link_down(uint32_t status_reg)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_RX_LINK_DOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_rx_link_down " "Received packet dropped because the link is down STATUS = %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , status_reg);
        }
    }
}

static inline void trace_e1000x_rx_disabled(uint32_t rctl_reg)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_RX_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_rx_disabled " "Received packet dropped because receive is disabled RCTL = %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rctl_reg);
        }
    }
}

static inline void trace_e1000x_rx_oversized(size_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_RX_OVERSIZED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_rx_oversized " "Received packet dropped because it was oversized (%zu bytes)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , size);
        }
    }
}

static inline void trace_e1000x_mac_indicate(uint8_t b0, uint8_t b1, uint8_t b2, uint8_t b3, uint8_t b4, uint8_t b5)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_MAC_INDICATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_mac_indicate " "Indicating MAC to guest: %02x:%02x:%02x:%02x:%02x:%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , b0, b1, b2, b3, b4, b5);
        }
    }
}

static inline void trace_e1000x_link_negotiation_start(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_LINK_NEGOTIATION_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_link_negotiation_start " "Start link auto negotiation" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000x_link_negotiation_done(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000X_LINK_NEGOTIATION_DONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000x_link_negotiation_done " "Auto negotiation is completed" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_core_write(uint64_t index, uint32_t size, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CORE_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_core_write " "Write to register 0x%"PRIx64", %d byte(s), value: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, size, val);
        }
    }
}

static inline void trace_e1000e_core_read(uint64_t index, uint32_t size, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CORE_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_core_read " "Read from register 0x%"PRIx64", %d byte(s), value: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, size, val);
        }
    }
}

static inline void trace_e1000e_core_mdic_read(uint8_t page, uint32_t addr, uint32_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CORE_MDIC_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_core_mdic_read " "MDIC READ: PHY[%u][%u] = 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , page, addr, data);
        }
    }
}

static inline void trace_e1000e_core_mdic_read_unhandled(uint8_t page, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CORE_MDIC_READ_UNHANDLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_core_mdic_read_unhandled " "MDIC READ: PHY[%u][%u] UNHANDLED" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , page, addr);
        }
    }
}

static inline void trace_e1000e_core_mdic_write(uint8_t page, uint32_t addr, uint32_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CORE_MDIC_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_core_mdic_write " "MDIC WRITE: PHY[%u][%u] = 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , page, addr, data);
        }
    }
}

static inline void trace_e1000e_core_mdic_write_unhandled(uint8_t page, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CORE_MDIC_WRITE_UNHANDLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_core_mdic_write_unhandled " "MDIC WRITE: PHY[%u][%u] UNHANDLED" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , page, addr);
        }
    }
}

static inline void trace_e1000e_core_eeeprom_write(uint16_t bit_in, uint16_t bit_out, uint16_t reading)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CORE_EEEPROM_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_core_eeeprom_write " "eeprom bitnum in %d out %d, reading %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bit_in, bit_out, reading);
        }
    }
}

static inline void trace_e1000e_core_ctrl_write(uint64_t index, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CORE_CTRL_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_core_ctrl_write " "Write CTRL register 0x%"PRIx64", value: 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, val);
        }
    }
}

static inline void trace_e1000e_core_ctrl_sw_reset(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CORE_CTRL_SW_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_core_ctrl_sw_reset " "Doing SW reset" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_core_ctrl_phy_reset(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CORE_CTRL_PHY_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_core_ctrl_phy_reset " "Doing PHY reset" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_link_autoneg_flowctl(bool enabled)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_LINK_AUTONEG_FLOWCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_link_autoneg_flowctl " "Auto-negotiated flow control state is %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , enabled);
        }
    }
}

static inline void trace_e1000e_link_set_params(bool autodetect, uint32_t speed, bool force_spd, bool force_dplx, bool rx_fctl, bool tx_fctl)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_LINK_SET_PARAMS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_link_set_params " "Set link params: Autodetect: %d, Speed: %d, Force speed: %d, Force duplex: %d, RX flow control %d, TX flow control %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , autodetect, speed, force_spd, force_dplx, rx_fctl, tx_fctl);
        }
    }
}

static inline void trace_e1000e_link_read_params(bool autodetect, uint32_t speed, bool force_spd, bool force_dplx, bool rx_fctl, bool tx_fctl)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_LINK_READ_PARAMS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_link_read_params " "Get link params: Autodetect: %d, Speed: %d, Force speed: %d, Force duplex: %d, RX flow control %d, TX flow control %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , autodetect, speed, force_spd, force_dplx, rx_fctl, tx_fctl);
        }
    }
}

static inline void trace_e1000e_link_set_ext_params(bool asd_check, bool speed_select_bypass)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_LINK_SET_EXT_PARAMS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_link_set_ext_params " "Set extended link params: ASD check: %d, Speed select bypass: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , asd_check, speed_select_bypass);
        }
    }
}

static inline void trace_e1000e_link_status(bool link_up, bool full_dplx, uint32_t speed, uint32_t asdv)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_LINK_STATUS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_link_status " "Link up: %d, Duplex: %d, Speed: %d, ASDV: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , link_up, full_dplx, speed, asdv);
        }
    }
}

static inline void trace_e1000e_link_status_changed(bool status)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_LINK_STATUS_CHANGED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_link_status_changed " "New link status: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , status);
        }
    }
}

static inline void trace_e1000e_wrn_regs_write_ro(uint64_t index, uint32_t size, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_REGS_WRITE_RO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_regs_write_ro " "WARNING: Write to RO register 0x%"PRIx64", %d byte(s), value: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, size, val);
        }
    }
}

static inline void trace_e1000e_wrn_regs_write_unknown(uint64_t index, uint32_t size, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_REGS_WRITE_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_regs_write_unknown " "WARNING: Write to unknown register 0x%"PRIx64", %d byte(s), value: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, size, val);
        }
    }
}

static inline void trace_e1000e_wrn_regs_read_unknown(uint64_t index, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_REGS_READ_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_regs_read_unknown " "WARNING: Read from unknown register 0x%"PRIx64", %d byte(s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, size);
        }
    }
}

static inline void trace_e1000e_wrn_regs_read_trivial(uint32_t index)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_REGS_READ_TRIVIAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_regs_read_trivial " "WARNING: Reading register at offset: 0x%05x. It is not fully implemented." "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_e1000e_wrn_regs_write_trivial(uint32_t index)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_REGS_WRITE_TRIVIAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_regs_write_trivial " "WARNING: Writing to register at offset: 0x%05x. It is not fully implemented." "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_e1000e_wrn_no_ts_support(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_NO_TS_SUPPORT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_no_ts_support " "WARNING: Guest requested TX timestamping which is not supported" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_wrn_no_snap_support(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_NO_SNAP_SUPPORT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_no_snap_support " "WARNING: Guest requested TX SNAP header update which is not supported" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_wrn_iscsi_filtering_not_supported(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_ISCSI_FILTERING_NOT_SUPPORTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_iscsi_filtering_not_supported " "WARNING: Guest requested iSCSI filtering  which is not supported" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_wrn_nfsw_filtering_not_supported(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_NFSW_FILTERING_NOT_SUPPORTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_nfsw_filtering_not_supported " "WARNING: Guest requested NFS write filtering  which is not supported" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_wrn_nfsr_filtering_not_supported(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_NFSR_FILTERING_NOT_SUPPORTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_nfsr_filtering_not_supported " "WARNING: Guest requested NFS read filtering  which is not supported" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_tx_disabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_TX_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_tx_disabled " "TX Disabled" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_tx_descr(void * addr, uint32_t lower, uint32_t upper)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_TX_DESCR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_tx_descr " "%p : %x %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, lower, upper);
        }
    }
}

static inline void trace_e1000e_ring_free_space(int ridx, uint32_t rdlen, uint32_t rdh, uint32_t rdt)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RING_FREE_SPACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_ring_free_space " "ring #%d: LEN: %u, DH: %u, DT: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ridx, rdlen, rdh, rdt);
        }
    }
}

static inline void trace_e1000e_rx_can_recv_rings_full(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_CAN_RECV_RINGS_FULL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_can_recv_rings_full " "Cannot receive: all rings are full" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_can_recv(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_CAN_RECV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_can_recv " "Can receive" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_has_buffers(int ridx, uint32_t free_desc, size_t total_size, uint32_t desc_buf_size)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_HAS_BUFFERS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_has_buffers " "ring #%d: free descr: %u, packet size %zu, descr buffer size %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ridx, free_desc, total_size, desc_buf_size);
        }
    }
}

static inline void trace_e1000e_rx_null_descriptor(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_NULL_DESCRIPTOR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_null_descriptor " "Null RX descriptor!!" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_flt_vlan_mismatch(uint16_t vid)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_FLT_VLAN_MISMATCH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_flt_vlan_mismatch " "VID mismatch: 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vid);
        }
    }
}

static inline void trace_e1000e_rx_flt_vlan_match(uint16_t vid)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_FLT_VLAN_MATCH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_flt_vlan_match " "VID match: 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vid);
        }
    }
}

static inline void trace_e1000e_rx_desc_ps_read(uint64_t a0, uint64_t a1, uint64_t a2, uint64_t a3)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_DESC_PS_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_desc_ps_read " "buffers: [0x%"PRIx64", 0x%"PRIx64", 0x%"PRIx64", 0x%"PRIx64"]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , a0, a1, a2, a3);
        }
    }
}

static inline void trace_e1000e_rx_desc_ps_write(uint16_t a0, uint16_t a1, uint16_t a2, uint16_t a3)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_DESC_PS_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_desc_ps_write " "bytes written: [%u, %u, %u, %u]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , a0, a1, a2, a3);
        }
    }
}

static inline void trace_e1000e_rx_desc_buff_sizes(uint32_t b0, uint32_t b1, uint32_t b2, uint32_t b3)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_DESC_BUFF_SIZES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_desc_buff_sizes " "buffer sizes: [%u, %u, %u, %u]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , b0, b1, b2, b3);
        }
    }
}

static inline void trace_e1000e_rx_desc_len(uint8_t rx_desc_len)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_DESC_LEN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_desc_len " "RX descriptor length: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rx_desc_len);
        }
    }
}

static inline void trace_e1000e_rx_desc_buff_write(uint8_t idx, uint64_t addr, uint16_t offset, const void* source, uint32_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_DESC_BUFF_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_desc_buff_write " "buffer #%u, addr: 0x%"PRIx64", offset: %u, from: %p, length: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx, addr, offset, source, len);
        }
    }
}

static inline void trace_e1000e_rx_descr(int ridx, uint64_t base, uint8_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_DESCR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_descr " "Next RX descriptor: ring #%d, PA: 0x%"PRIx64", length: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ridx, base, len);
        }
    }
}

static inline void trace_e1000e_rx_set_rctl(uint32_t rctl)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_SET_RCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_set_rctl " "RCTL = 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rctl);
        }
    }
}

static inline void trace_e1000e_rx_receive_iov(int iovcnt)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_RECEIVE_IOV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_receive_iov " "Received vector of %d fragments" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , iovcnt);
        }
    }
}

static inline void trace_e1000e_rx_packet_size(size_t full, size_t vhdr, size_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_PACKET_SIZE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_packet_size " "Received packet of %zu bytes total, %zu virt header, %zu data" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , full, vhdr, data);
        }
    }
}

static inline void trace_e1000e_rx_flt_dropped(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_FLT_DROPPED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_flt_dropped " "Received packet dropped by RX filter" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_written_to_guest(uint32_t causes)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_WRITTEN_TO_GUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_written_to_guest " "Received packet written to guest (ICR causes %u)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , causes);
        }
    }
}

static inline void trace_e1000e_rx_not_written_to_guest(uint32_t causes)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_NOT_WRITTEN_TO_GUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_not_written_to_guest " "Received packet NOT written to guest (ICR causes %u)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , causes);
        }
    }
}

static inline void trace_e1000e_rx_interrupt_set(uint32_t causes)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_INTERRUPT_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_interrupt_set " "Receive interrupt set (ICR causes %u)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , causes);
        }
    }
}

static inline void trace_e1000e_rx_interrupt_delayed(uint32_t causes)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_INTERRUPT_DELAYED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_interrupt_delayed " "Receive interrupt delayed (ICR causes %u)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , causes);
        }
    }
}

static inline void trace_e1000e_rx_set_cso(int cso_state)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_SET_CSO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_set_cso " "RX CSO state set to %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cso_state);
        }
    }
}

static inline void trace_e1000e_rx_set_rdt(int queue_idx, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_SET_RDT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_set_rdt " "Setting RDT[%d] = %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , queue_idx, val);
        }
    }
}

static inline void trace_e1000e_rx_set_rfctl(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_SET_RFCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_set_rfctl " "Setting RFCTL = 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_e1000e_rx_start_recv(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_START_RECV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_start_recv "  "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_rss_started(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_RSS_STARTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_rss_started " "Starting RSS processing" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_rss_disabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_RSS_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_rss_disabled " "RSS is disabled" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_rss_type(uint32_t type)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_RSS_TYPE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_rss_type " "RSS type is %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , type);
        }
    }
}

static inline void trace_e1000e_rx_rss_ip4(bool isfragment, bool istcp, uint32_t mrqc, bool tcpipv4_enabled, bool ipv4_enabled)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_RSS_IP4)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_rss_ip4 " "RSS IPv4: fragment %d, tcp %d, mrqc 0x%X, tcpipv4 enabled %d, ipv4 enabled %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , isfragment, istcp, mrqc, tcpipv4_enabled, ipv4_enabled);
        }
    }
}

static inline void trace_e1000e_rx_rss_ip6_rfctl(uint32_t rfctl)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_RSS_IP6_RFCTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_rss_ip6_rfctl " "RSS IPv6: rfctl 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rfctl);
        }
    }
}

static inline void trace_e1000e_rx_rss_ip6(bool ex_dis, bool new_ex_dis, bool istcp, bool has_ext_headers, bool ex_dst_valid, bool ex_src_valid, uint32_t mrqc, bool tcpipv6_enabled, bool ipv6ex_enabled, bool ipv6_enabled)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_RSS_IP6)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_rss_ip6 " "RSS IPv6: ex_dis: %d, new_ex_dis: %d, tcp %d, has_ext_headers %d, ex_dst_valid %d, ex_src_valid %d, mrqc 0x%X, tcpipv6 enabled %d, ipv6ex enabled %d, ipv6 enabled %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ex_dis, new_ex_dis, istcp, has_ext_headers, ex_dst_valid, ex_src_valid, mrqc, tcpipv6_enabled, ipv6ex_enabled, ipv6_enabled);
        }
    }
}

static inline void trace_e1000e_rx_rss_dispatched_to_queue(int queue_idx)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_RSS_DISPATCHED_TO_QUEUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_rss_dispatched_to_queue " "Packet being dispatched to queue %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , queue_idx);
        }
    }
}

static inline void trace_e1000e_rx_metadata_protocols(bool isip4, bool isip6, bool isudp, bool istcp)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_PROTOCOLS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_protocols " "protocols: ip4: %d, ip6: %d, udp: %d, tcp: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , isip4, isip6, isudp, istcp);
        }
    }
}

static inline void trace_e1000e_rx_metadata_vlan(uint16_t vlan_tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_VLAN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_vlan " "VLAN tag is 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vlan_tag);
        }
    }
}

static inline void trace_e1000e_rx_metadata_rss(uint32_t rss, uint32_t mrq)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_RSS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_rss " "RSS data: rss: 0x%X, mrq: 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rss, mrq);
        }
    }
}

static inline void trace_e1000e_rx_metadata_ip_id(uint16_t ip_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_IP_ID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_ip_id " "the IPv4 ID is 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ip_id);
        }
    }
}

static inline void trace_e1000e_rx_metadata_ack(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_ACK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_ack " "the packet is TCP ACK" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_metadata_pkt_type(uint32_t pkt_type)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_PKT_TYPE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_pkt_type " "the packet type is %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pkt_type);
        }
    }
}

static inline void trace_e1000e_rx_metadata_no_virthdr(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_NO_VIRTHDR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_no_virthdr " "the packet has no virt-header" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_metadata_virthdr_no_csum_info(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_VIRTHDR_NO_CSUM_INFO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_virthdr_no_csum_info " "virt-header does not contain checksum info" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_metadata_l3_cso_disabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_L3_CSO_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_l3_cso_disabled " "IP4 CSO is disabled" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_metadata_l4_cso_disabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_L4_CSO_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_l4_cso_disabled " "TCP/UDP CSO is disabled" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_metadata_l3_csum_validation_failed(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_L3_CSUM_VALIDATION_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_l3_csum_validation_failed " "Cannot validate L3 checksum" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_metadata_l4_csum_validation_failed(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_L4_CSUM_VALIDATION_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_l4_csum_validation_failed " "Cannot validate L4 checksum" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_metadata_status_flags(uint32_t status_flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_STATUS_FLAGS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_status_flags " "status_flags is 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , status_flags);
        }
    }
}

static inline void trace_e1000e_rx_metadata_ipv6_sum_disabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_IPV6_SUM_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_ipv6_sum_disabled " "IPv6 RX checksummimg disabled by RFCTL" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_rx_metadata_ipv6_filtering_disabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_RX_METADATA_IPV6_FILTERING_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_rx_metadata_ipv6_filtering_disabled " "IPv6 RX filtering disabled by RFCTL" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_vlan_vet(uint16_t vet)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_VLAN_VET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_vlan_vet " "Setting VLAN ethernet type 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vet);
        }
    }
}

static inline void trace_e1000e_irq_set_cause(uint32_t cause)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_SET_CAUSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_set_cause " "IRQ cause set 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cause);
        }
    }
}

static inline void trace_e1000e_irq_msi_notify(uint32_t cause)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_MSI_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_msi_notify " "MSI notify 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cause);
        }
    }
}

static inline void trace_e1000e_irq_throttling_no_pending_interrupts(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_THROTTLING_NO_PENDING_INTERRUPTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_throttling_no_pending_interrupts " "No pending interrupts to notify" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_msi_notify_postponed(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_MSI_NOTIFY_POSTPONED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_msi_notify_postponed " "Sending MSI postponed by ITR" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_legacy_notify_postponed(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_LEGACY_NOTIFY_POSTPONED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_legacy_notify_postponed " "Raising legacy IRQ postponed by ITR" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_throttling_no_pending_vec(int idx)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_THROTTLING_NO_PENDING_VEC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_throttling_no_pending_vec " "No pending interrupts for vector %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx);
        }
    }
}

static inline void trace_e1000e_irq_msix_notify_postponed_vec(int idx)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_MSIX_NOTIFY_POSTPONED_VEC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_msix_notify_postponed_vec " "Sending MSI-X postponed by EITR[%d]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx);
        }
    }
}

static inline void trace_e1000e_irq_msix_notify(uint32_t cause)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_MSIX_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_msix_notify " "MSI-X notify 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cause);
        }
    }
}

static inline void trace_e1000e_irq_legacy_notify(bool level)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_LEGACY_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_legacy_notify " "IRQ line state: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , level);
        }
    }
}

static inline void trace_e1000e_irq_msix_notify_vec(uint32_t vector)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_MSIX_NOTIFY_VEC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_msix_notify_vec " "MSI-X notify vector 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vector);
        }
    }
}

static inline void trace_e1000e_irq_postponed_by_xitr(uint32_t reg)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_POSTPONED_BY_XITR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_postponed_by_xitr " "Interrupt postponed by [E]ITR register 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg);
        }
    }
}

static inline void trace_e1000e_irq_clear_ims(uint32_t bits, uint32_t old_ims, uint32_t new_ims)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_CLEAR_IMS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_clear_ims " "Clearing IMS bits 0x%x: 0x%x --> 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bits, old_ims, new_ims);
        }
    }
}

static inline void trace_e1000e_irq_set_ims(uint32_t bits, uint32_t old_ims, uint32_t new_ims)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_SET_IMS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_set_ims " "Setting IMS bits 0x%x: 0x%x --> 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bits, old_ims, new_ims);
        }
    }
}

static inline void trace_e1000e_irq_fix_icr_asserted(uint32_t new_val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_FIX_ICR_ASSERTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_fix_icr_asserted " "ICR_ASSERTED bit fixed: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , new_val);
        }
    }
}

static inline void trace_e1000e_irq_add_msi_other(uint32_t new_val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_ADD_MSI_OTHER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_add_msi_other " "ICR_OTHER bit added: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , new_val);
        }
    }
}

static inline void trace_e1000e_irq_pending_interrupts(uint32_t pending, uint32_t icr, uint32_t ims)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_PENDING_INTERRUPTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_pending_interrupts " "ICR PENDING: 0x%x (ICR: 0x%x, IMS: 0x%x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pending, icr, ims);
        }
    }
}

static inline void trace_e1000e_irq_set_cause_entry(uint32_t val, uint32_t icr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_SET_CAUSE_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_set_cause_entry " "Going to set IRQ cause 0x%x, ICR: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val, icr);
        }
    }
}

static inline void trace_e1000e_irq_set_cause_exit(uint32_t val, uint32_t icr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_SET_CAUSE_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_set_cause_exit " "Set IRQ cause 0x%x, ICR: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val, icr);
        }
    }
}

static inline void trace_e1000e_irq_icr_write(uint32_t bits, uint32_t old_icr, uint32_t new_icr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_ICR_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_icr_write " "Clearing ICR bits 0x%x: 0x%x --> 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bits, old_icr, new_icr);
        }
    }
}

static inline void trace_e1000e_irq_write_ics(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_WRITE_ICS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_write_ics " "Adding ICR bits 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_e1000e_irq_icr_process_iame(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_ICR_PROCESS_IAME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_icr_process_iame " "Clearing IMS bits due to IAME" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_read_ics(uint32_t ics)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_READ_ICS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_read_ics " "Current ICS: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ics);
        }
    }
}

static inline void trace_e1000e_irq_read_ims(uint32_t ims)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_READ_IMS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_read_ims " "Current IMS: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ims);
        }
    }
}

static inline void trace_e1000e_irq_icr_read_entry(uint32_t icr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_ICR_READ_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_icr_read_entry " "Starting ICR read. Current ICR: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , icr);
        }
    }
}

static inline void trace_e1000e_irq_icr_read_exit(uint32_t icr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_ICR_READ_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_icr_read_exit " "Ending ICR read. Current ICR: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , icr);
        }
    }
}

static inline void trace_e1000e_irq_icr_clear_zero_ims(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_ICR_CLEAR_ZERO_IMS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_icr_clear_zero_ims " "Clearing ICR on read due to zero IMS" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_icr_clear_iame(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_ICR_CLEAR_IAME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_icr_clear_iame " "Clearing ICR on read due to IAME" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_ims_clear_eiame(uint32_t iam, uint32_t cause)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_IMS_CLEAR_EIAME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_ims_clear_eiame " "Clearing IMS due to EIAME, IAM: 0x%X, cause: 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , iam, cause);
        }
    }
}

static inline void trace_e1000e_irq_icr_clear_eiac(uint32_t icr, uint32_t eiac)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_ICR_CLEAR_EIAC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_icr_clear_eiac " "Clearing ICR bits due to EIAC, ICR: 0x%X, EIAC: 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , icr, eiac);
        }
    }
}

static inline void trace_e1000e_irq_ims_clear_set_imc(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_IMS_CLEAR_SET_IMC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_ims_clear_set_imc " "Clearing IMS bits due to IMC write 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_e1000e_irq_fire_delayed_interrupts(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_FIRE_DELAYED_INTERRUPTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_fire_delayed_interrupts " "Firing delayed interrupts" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_rearm_timer(uint32_t reg, int64_t delay_ns)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_REARM_TIMER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_rearm_timer " "Mitigation timer armed for register 0x%X, delay %"PRId64" ns" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg, delay_ns);
        }
    }
}

static inline void trace_e1000e_irq_throttling_timer(uint32_t reg)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_THROTTLING_TIMER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_throttling_timer " "Mitigation timer shot for register 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg);
        }
    }
}

static inline void trace_e1000e_irq_rdtr_fpd_running(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_RDTR_FPD_RUNNING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_rdtr_fpd_running " "FPD written while RDTR was running" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_rdtr_fpd_not_running(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_RDTR_FPD_NOT_RUNNING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_rdtr_fpd_not_running " "FPD written while RDTR was not running" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_tidv_fpd_running(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_TIDV_FPD_RUNNING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_tidv_fpd_running " "FPD written while TIDV was running" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_tidv_fpd_not_running(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_TIDV_FPD_NOT_RUNNING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_tidv_fpd_not_running " "FPD written while TIDV was not running" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_irq_eitr_set(uint32_t eitr_num, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_EITR_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_eitr_set " "EITR[%u] = %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , eitr_num, val);
        }
    }
}

static inline void trace_e1000e_irq_itr_set(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_ITR_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_itr_set " "ITR = %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_e1000e_irq_fire_all_timers(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_FIRE_ALL_TIMERS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_fire_all_timers " "Firing all delay/throttling timers on all interrupts enable (0x%X written to IMS)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_e1000e_irq_adding_delayed_causes(uint32_t val, uint32_t icr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_ADDING_DELAYED_CAUSES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_adding_delayed_causes " "Merging delayed causes 0x%X to ICR 0x%X" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val, icr);
        }
    }
}

static inline void trace_e1000e_irq_msix_pending_clearing(uint32_t cause, uint32_t int_cfg, uint32_t vec)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IRQ_MSIX_PENDING_CLEARING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_irq_msix_pending_clearing " "Clearing MSI-X pending bit for cause 0x%x, IVAR config 0x%x, vector %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cause, int_cfg, vec);
        }
    }
}

static inline void trace_e1000e_wrn_msix_vec_wrong(uint32_t cause, uint32_t cfg)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_MSIX_VEC_WRONG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_msix_vec_wrong " "Invalid configuration for cause 0x%x: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cause, cfg);
        }
    }
}

static inline void trace_e1000e_wrn_msix_invalid(uint32_t cause, uint32_t cfg)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_MSIX_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_msix_invalid " "Invalid entry for cause 0x%x: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cause, cfg);
        }
    }
}

static inline void trace_e1000e_mac_set_permanent(uint8_t b0, uint8_t b1, uint8_t b2, uint8_t b3, uint8_t b4, uint8_t b5)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_MAC_SET_PERMANENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_mac_set_permanent " "Set permanent MAC: %02x:%02x:%02x:%02x:%02x:%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , b0, b1, b2, b3, b4, b5);
        }
    }
}

static inline void trace_e1000e_mac_set_sw(uint8_t b0, uint8_t b1, uint8_t b2, uint8_t b3, uint8_t b4, uint8_t b5)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_MAC_SET_SW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_mac_set_sw " "Set SW MAC: %02x:%02x:%02x:%02x:%02x:%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , b0, b1, b2, b3, b4, b5);
        }
    }
}

static inline void trace_e1000e_cb_pci_realize(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CB_PCI_REALIZE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_cb_pci_realize " "E1000E PCI realize entry" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_cb_pci_uninit(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CB_PCI_UNINIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_cb_pci_uninit " "E1000E PCI unit entry" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_cb_qdev_reset(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CB_QDEV_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_cb_qdev_reset " "E1000E qdev reset entry" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_cb_pre_save(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CB_PRE_SAVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_cb_pre_save " "E1000E pre save entry" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_cb_post_load(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CB_POST_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_cb_post_load " "E1000E post load entry" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_io_write_addr(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IO_WRITE_ADDR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_io_write_addr " "IOADDR write 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_e1000e_io_write_data(uint64_t addr, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IO_WRITE_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_io_write_data " "IODATA write 0x%"PRIx64", value: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_e1000e_io_read_addr(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IO_READ_ADDR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_io_read_addr " "IOADDR read 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_e1000e_io_read_data(uint64_t addr, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_IO_READ_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_io_read_data " "IODATA read 0x%"PRIx64", value: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_e1000e_wrn_io_write_unknown(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_IO_WRITE_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_io_write_unknown " "IO write unknown address 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_e1000e_wrn_io_read_unknown(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_IO_READ_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_io_read_unknown " "IO read unknown address 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_e1000e_wrn_io_addr_undefined(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_IO_ADDR_UNDEFINED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_io_addr_undefined " "IO undefined register 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_e1000e_wrn_io_addr_flash(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_IO_ADDR_FLASH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_io_addr_flash " "IO flash access (0x%"PRIx64") not implemented" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_e1000e_wrn_io_addr_unknown(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_WRN_IO_ADDR_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_wrn_io_addr_unknown " "IO unknown register 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_e1000e_msi_init_fail(int32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_MSI_INIT_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_msi_init_fail " "Failed to initialize MSI, error %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res);
        }
    }
}

static inline void trace_e1000e_msix_init_fail(int32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_MSIX_INIT_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_msix_init_fail " "Failed to initialize MSI-X, error %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res);
        }
    }
}

static inline void trace_e1000e_msix_use_vector_fail(uint32_t vec, int32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_MSIX_USE_VECTOR_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_msix_use_vector_fail " "Failed to use MSI-X vector %d, error %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vec, res);
        }
    }
}

static inline void trace_e1000e_cfg_support_virtio(bool support)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_CFG_SUPPORT_VIRTIO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_cfg_support_virtio " "Virtio header supported: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , support);
        }
    }
}

static inline void trace_e1000e_vm_state_running(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_VM_STATE_RUNNING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_vm_state_running " "VM state is running" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_e1000e_vm_state_stopped(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_E1000E_VM_STATE_STOPPED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:e1000e_vm_state_stopped " "VM state is stopped" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_virtqueue_fill(void * vq, const void * elem, unsigned int len, unsigned int idx)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTQUEUE_FILL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtqueue_fill " "vq %p elem %p len %u idx %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vq, elem, len, idx);
        }
    }
}

static inline void trace_virtqueue_flush(void * vq, unsigned int count)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTQUEUE_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtqueue_flush " "vq %p count %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vq, count);
        }
    }
}

static inline void trace_virtqueue_pop(void * vq, void * elem, unsigned int in_num, unsigned int out_num)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTQUEUE_POP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtqueue_pop " "vq %p elem %p in_num %u out_num %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vq, elem, in_num, out_num);
        }
    }
}

static inline void trace_virtio_queue_notify(void * vdev, int n, void * vq)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_QUEUE_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_queue_notify " "vdev %p n %d vq %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vdev, n, vq);
        }
    }
}

static inline void trace_virtio_irq(void * vq)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_irq " "vq %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vq);
        }
    }
}

static inline void trace_virtio_notify(void * vdev, void * vq)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_notify " "vdev %p vq %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vdev, vq);
        }
    }
}

static inline void trace_virtio_set_status(void * vdev, uint8_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_SET_STATUS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_set_status " "vdev %p val %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vdev, val);
        }
    }
}

static inline void trace_virtio_rng_guest_not_ready(void * rng)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_RNG_GUEST_NOT_READY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_rng_guest_not_ready " "rng %p: guest not ready" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rng);
        }
    }
}

static inline void trace_virtio_rng_pushed(void * rng, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_RNG_PUSHED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_rng_pushed " "rng %p: %zd bytes pushed" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rng, len);
        }
    }
}

static inline void trace_virtio_rng_request(void * rng, size_t size, unsigned quota)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_RNG_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_rng_request " "rng %p: %zd bytes requested, %u bytes quota left" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rng, size, quota);
        }
    }
}

static inline void trace_cs4231_mem_readl_dreg(uint32_t reg, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_CS4231_MEM_READL_DREG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cs4231_mem_readl_dreg " "read dreg %d: 0x%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg, ret);
        }
    }
}

static inline void trace_cs4231_mem_readl_reg(uint32_t reg, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_CS4231_MEM_READL_REG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cs4231_mem_readl_reg " "read reg %d: 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg, ret);
        }
    }
}

static inline void trace_cs4231_mem_writel_reg(uint32_t reg, uint32_t old, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_CS4231_MEM_WRITEL_REG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cs4231_mem_writel_reg " "write reg %d: 0x%08x -> 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg, old, val);
        }
    }
}

static inline void trace_cs4231_mem_writel_dreg(uint32_t reg, uint32_t old, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_CS4231_MEM_WRITEL_DREG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cs4231_mem_writel_dreg " "write dreg %d: 0x%02x -> 0x%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg, old, val);
        }
    }
}

static inline void trace_milkymist_ac97_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_AC97_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_ac97_memory_read " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_ac97_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_AC97_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_ac97_memory_write " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_ac97_pulse_irq_crrequest(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_AC97_PULSE_IRQ_CRREQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_ac97_pulse_irq_crrequest " "Pulse IRQ CR request" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_ac97_pulse_irq_crreply(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_AC97_PULSE_IRQ_CRREPLY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_ac97_pulse_irq_crreply " "Pulse IRQ CR reply" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_ac97_pulse_irq_dmaw(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_AC97_PULSE_IRQ_DMAW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_ac97_pulse_irq_dmaw " "Pulse IRQ DMA write" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_ac97_pulse_irq_dmar(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_AC97_PULSE_IRQ_DMAR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_ac97_pulse_irq_dmar " "Pulse IRQ DMA read" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_ac97_in_cb(int avail, uint32_t remaining)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_AC97_IN_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_ac97_in_cb " "avail %d remaining %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , avail, remaining);
        }
    }
}

static inline void trace_milkymist_ac97_in_cb_transferred(int transferred)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_AC97_IN_CB_TRANSFERRED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_ac97_in_cb_transferred " "transferred %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , transferred);
        }
    }
}

static inline void trace_milkymist_ac97_out_cb(int free, uint32_t remaining)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_AC97_OUT_CB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_ac97_out_cb " "free %d remaining %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , free, remaining);
        }
    }
}

static inline void trace_milkymist_ac97_out_cb_transferred(int transferred)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_AC97_OUT_CB_TRANSFERRED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_ac97_out_cb_transferred " "transferred %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , transferred);
        }
    }
}

static inline void trace_ecc_mem_writel_mer(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_WRITEL_MER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_writel_mer " "Write memory enable %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_ecc_mem_writel_mdr(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_WRITEL_MDR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_writel_mdr " "Write memory delay %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_ecc_mem_writel_mfsr(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_WRITEL_MFSR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_writel_mfsr " "Write memory fault status %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_ecc_mem_writel_vcr(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_WRITEL_VCR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_writel_vcr " "Write slot configuration %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_ecc_mem_writel_dr(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_WRITEL_DR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_writel_dr " "Write diagnostic %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_ecc_mem_writel_ecr0(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_WRITEL_ECR0)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_writel_ecr0 " "Write event count 1 %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_ecc_mem_writel_ecr1(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_WRITEL_ECR1)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_writel_ecr1 " "Write event count 2 %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_ecc_mem_readl_mer(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_READL_MER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_readl_mer " "Read memory enable %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_ecc_mem_readl_mdr(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_READL_MDR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_readl_mdr " "Read memory delay %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_ecc_mem_readl_mfsr(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_READL_MFSR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_readl_mfsr " "Read memory fault status %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_ecc_mem_readl_vcr(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_READL_VCR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_readl_vcr " "Read slot configuration %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_ecc_mem_readl_mfar0(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_READL_MFAR0)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_readl_mfar0 " "Read memory fault address 0 %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_ecc_mem_readl_mfar1(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_READL_MFAR1)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_readl_mfar1 " "Read memory fault address 1 %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_ecc_mem_readl_dr(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_READL_DR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_readl_dr " "Read diagnostic %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_ecc_mem_readl_ecr0(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_READL_ECR0)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_readl_ecr0 " "Read event count 1 %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_ecc_mem_readl_ecr1(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_MEM_READL_ECR1)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_mem_readl_ecr1 " "Read event count 2 %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_ecc_diag_mem_writeb(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_DIAG_MEM_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_diag_mem_writeb " "Write diagnostic %"PRId64" = %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_ecc_diag_mem_readb(uint64_t addr, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_ECC_DIAG_MEM_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ecc_diag_mem_readb " "Read diagnostic %"PRId64"= %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, ret);
        }
    }
}

static inline void trace_slavio_misc_update_irq_raise(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_MISC_UPDATE_IRQ_RAISE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_misc_update_irq_raise " "Raise IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_slavio_misc_update_irq_lower(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_MISC_UPDATE_IRQ_LOWER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_misc_update_irq_lower " "Lower IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_slavio_set_power_fail(int power_failing, uint8_t config)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_SET_POWER_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_set_power_fail " "Power fail: %d, config: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , power_failing, config);
        }
    }
}

static inline void trace_slavio_cfg_mem_writeb(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_CFG_MEM_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_cfg_mem_writeb " "Write config %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_slavio_cfg_mem_readb(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_CFG_MEM_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_cfg_mem_readb " "Read config %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_slavio_diag_mem_writeb(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_DIAG_MEM_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_diag_mem_writeb " "Write diag %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_slavio_diag_mem_readb(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_DIAG_MEM_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_diag_mem_readb " "Read diag %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_slavio_mdm_mem_writeb(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_MDM_MEM_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_mdm_mem_writeb " "Write modem control %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_slavio_mdm_mem_readb(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_MDM_MEM_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_mdm_mem_readb " "Read modem control %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_slavio_aux1_mem_writeb(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_AUX1_MEM_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_aux1_mem_writeb " "Write aux1 %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_slavio_aux1_mem_readb(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_AUX1_MEM_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_aux1_mem_readb " "Read aux1 %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_slavio_aux2_mem_writeb(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_AUX2_MEM_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_aux2_mem_writeb " "Write aux2 %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_slavio_aux2_mem_readb(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_AUX2_MEM_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_aux2_mem_readb " "Read aux2 %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_apc_mem_writeb(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_APC_MEM_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:apc_mem_writeb " "Write power management %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_apc_mem_readb(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_APC_MEM_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:apc_mem_readb " "Read power management %02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_slavio_sysctrl_mem_writel(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_SYSCTRL_MEM_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_sysctrl_mem_writel " "Write system control %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_slavio_sysctrl_mem_readl(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_SYSCTRL_MEM_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_sysctrl_mem_readl " "Read system control %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_slavio_led_mem_writew(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_LED_MEM_WRITEW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_led_mem_writew " "Write diagnostic LED %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_slavio_led_mem_readw(uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_LED_MEM_READW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_led_mem_readw " "Read diagnostic LED %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_milkymist_hpdmc_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_HPDMC_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_hpdmc_memory_read " "addr=%08x value=%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_hpdmc_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_HPDMC_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_hpdmc_memory_write " "addr=%08x value=%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_pfpu_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_PFPU_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_pfpu_memory_read " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_pfpu_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_PFPU_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_pfpu_memory_write " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_pfpu_vectout(uint32_t a, uint32_t b, uint32_t dma_ptr)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_PFPU_VECTOUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_pfpu_vectout " "a %08x b %08x dma_ptr %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , a, b, dma_ptr);
        }
    }
}

static inline void trace_milkymist_pfpu_pulse_irq(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_PFPU_PULSE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_pfpu_pulse_irq " "Pulse IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_aspeed_scu_write(uint64_t offset, unsigned size, uint32_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_SCU_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_scu_write " "To 0x%" PRIx64 " of size %u: 0x%" PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offset, size, data);
        }
    }
}

static inline void trace_usb_packet_state_change(int bus, const char * port, int ep, void * p, const char * o, const char * n)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_PACKET_STATE_CHANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_packet_state_change " "bus %d, port %s, ep %d, packet %p, state %s -> %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, port, ep, p, o, n);
        }
    }
}

static inline void trace_usb_packet_state_fault(int bus, const char * port, int ep, void * p, const char * o, const char * n)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_PACKET_STATE_FAULT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_packet_state_fault " "bus %d, port %s, ep %d, packet %p, state %s, expected %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, port, ep, p, o, n);
        }
    }
}

static inline void trace_usb_port_claim(int bus, const char * port)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_PORT_CLAIM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_port_claim " "bus %d, port %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, port);
        }
    }
}

static inline void trace_usb_port_attach(int bus, const char * port, const char * devspeed, const char * portspeed)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_PORT_ATTACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_port_attach " "bus %d, port %s, devspeed %s, portspeed %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, port, devspeed, portspeed);
        }
    }
}

static inline void trace_usb_port_detach(int bus, const char * port)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_PORT_DETACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_port_detach " "bus %d, port %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, port);
        }
    }
}

static inline void trace_usb_port_release(int bus, const char * port)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_PORT_RELEASE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_port_release " "bus %d, port %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, port);
        }
    }
}

static inline void trace_usb_ohci_iso_td_read_failed(uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_READ_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_read_failed " "ISO_TD read error at %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_ohci_iso_td_head(uint32_t head, uint32_t tail, uint32_t flags, uint32_t bp, uint32_t next, uint32_t be, uint32_t framenum, uint32_t startframe, uint32_t framecount, int rel_frame_num)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_HEAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_head " "ISO_TD ED head 0x%.8x tailp 0x%.8x\n0x%.8x 0x%.8x 0x%.8x 0x%.8x\nframe_number 0x%.8x starting_frame 0x%.8x\nframe_count  0x%.8x relative %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , head, tail, flags, bp, next, be, framenum, startframe, framecount, rel_frame_num);
        }
    }
}

static inline void trace_usb_ohci_iso_td_head_offset(uint32_t o0, uint32_t o1, uint32_t o2, uint32_t o3, uint32_t o4, uint32_t o5, uint32_t o6, uint32_t o7)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_HEAD_OFFSET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_head_offset " "0x%.8x 0x%.8x 0x%.8x 0x%.8x 0x%.8x 0x%.8x 0x%.8x 0x%.8x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , o0, o1, o2, o3, o4, o5, o6, o7);
        }
    }
}

static inline void trace_usb_ohci_iso_td_relative_frame_number_neg(int rel)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_RELATIVE_FRAME_NUMBER_NEG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_relative_frame_number_neg " "ISO_TD R=%d < 0" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rel);
        }
    }
}

static inline void trace_usb_ohci_iso_td_relative_frame_number_big(int rel, int count)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_RELATIVE_FRAME_NUMBER_BIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_relative_frame_number_big " "ISO_TD R=%d > FC=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rel, count);
        }
    }
}

static inline void trace_usb_ohci_iso_td_bad_direction(int dir)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_BAD_DIRECTION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_bad_direction " "Bad direction %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dir);
        }
    }
}

static inline void trace_usb_ohci_iso_td_bad_bp_be(uint32_t bp, uint32_t be)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_BAD_BP_BE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_bad_bp_be " "ISO_TD bp 0x%.8x be 0x%.8x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bp, be);
        }
    }
}

static inline void trace_usb_ohci_iso_td_bad_cc_not_accessed(uint32_t start, uint32_t next)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_BAD_CC_NOT_ACCESSED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_bad_cc_not_accessed " "ISO_TD cc != not accessed 0x%.8x 0x%.8x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start, next);
        }
    }
}

static inline void trace_usb_ohci_iso_td_bad_cc_overrun(uint32_t start, uint32_t next)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_BAD_CC_OVERRUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_bad_cc_overrun " "ISO_TD start_offset=0x%.8x > next_offset=0x%.8x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start, next);
        }
    }
}

static inline void trace_usb_ohci_iso_td_so(uint32_t so, uint32_t eo, uint32_t s, uint32_t e, const char * str, ssize_t len, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_SO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_so " "0x%.8x eo 0x%.8x\nsa 0x%.8x ea 0x%.8x\ndir %s len %zu ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , so, eo, s, e, str, len, ret);
        }
    }
}

static inline void trace_usb_ohci_iso_td_data_overrun(int ret, ssize_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_DATA_OVERRUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_data_overrun " "DataOverrun %d > %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret, len);
        }
    }
}

static inline void trace_usb_ohci_iso_td_data_underrun(int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_DATA_UNDERRUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_data_underrun " "DataUnderrun %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_usb_ohci_iso_td_nak(int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_NAK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_nak " "got NAK/STALL %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_usb_ohci_iso_td_bad_response(int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ISO_TD_BAD_RESPONSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_iso_td_bad_response " "Bad device response %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ret);
        }
    }
}

static inline void trace_usb_ohci_port_attach(int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_PORT_ATTACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_port_attach " "port #%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_usb_ohci_port_detach(int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_PORT_DETACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_port_detach " "port #%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_usb_ohci_port_wakeup(int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_PORT_WAKEUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_port_wakeup " "port #%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_usb_ohci_port_suspend(int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_PORT_SUSPEND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_port_suspend " "port #%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_usb_ohci_port_reset(int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_PORT_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_port_reset " "port #%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_usb_ohci_remote_wakeup(const char * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_REMOTE_WAKEUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_remote_wakeup " "%s: SUSPEND->RESUME" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_usb_ohci_reset(const char * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_reset " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_usb_ohci_start(const char * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_start " "%s: USB Operational" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_usb_ohci_resume(const char * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_RESUME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_resume " "%s: USB Resume" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_usb_ohci_stop(const char * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_STOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_stop " "%s: USB Suspended" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_usb_ohci_exit(const char * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_exit " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_usb_ohci_set_ctl(const char * s, uint32_t new_state)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_SET_CTL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_set_ctl " "%s: new state 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, new_state);
        }
    }
}

static inline void trace_usb_ohci_td_underrun(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_UNDERRUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_underrun " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ohci_td_dev_error(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_DEV_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_dev_error " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ohci_td_nak(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_NAK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_nak " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ohci_td_stall(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_STALL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_stall " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ohci_td_babble(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_BABBLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_babble " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ohci_td_bad_device_response(int rc)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_BAD_DEVICE_RESPONSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_bad_device_response " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rc);
        }
    }
}

static inline void trace_usb_ohci_td_read_error(uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_READ_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_read_error " "TD read error at %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_ohci_td_bad_direction(int dir)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_BAD_DIRECTION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_bad_direction " "Bad direction %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dir);
        }
    }
}

static inline void trace_usb_ohci_td_skip_async(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_SKIP_ASYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_skip_async " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ohci_td_pkt_hdr(uint32_t addr, int64_t pktlen, int64_t len, const char * s, int flag_r, uint32_t cbp, uint32_t be)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_PKT_HDR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_pkt_hdr " " TD @ 0x%.8x %" PRId64 " of %" PRId64 " bytes %s r=%d cbp=0x%.8x be=0x%.8x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, pktlen, len, s, flag_r, cbp, be);
        }
    }
}

static inline void trace_usb_ohci_td_pkt_short(const char * dir, const char * buf)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_PKT_SHORT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_pkt_short " "%s data: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dir, buf);
        }
    }
}

static inline void trace_usb_ohci_td_pkt_full(const char * dir, const char * buf)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_PKT_FULL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_pkt_full " "%s data: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dir, buf);
        }
    }
}

static inline void trace_usb_ohci_td_too_many_pending(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_TOO_MANY_PENDING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_too_many_pending " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ohci_td_packet_status(int status)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_TD_PACKET_STATUS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_td_packet_status " "status=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , status);
        }
    }
}

static inline void trace_usb_ohci_ed_read_error(uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ED_READ_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_ed_read_error " "ED read error at %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_ohci_ed_pkt(uint32_t cur, int h, int c, uint32_t head, uint32_t tail, uint32_t next)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ED_PKT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_ed_pkt " "ED @ 0x%.8x h=%u c=%u\n  head=0x%.8x tailp=0x%.8x next=0x%.8x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cur, h, c, head, tail, next);
        }
    }
}

static inline void trace_usb_ohci_ed_pkt_flags(uint32_t fa, uint32_t en, uint32_t d, int s, int k, int f, uint32_t mps)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ED_PKT_FLAGS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_ed_pkt_flags " "fa=%u en=%u d=%u s=%u k=%u f=%u mps=%u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fa, en, d, s, k, f, mps);
        }
    }
}

static inline void trace_usb_ohci_hcca_read_error(uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_HCCA_READ_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_hcca_read_error " "HCCA read error at %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_ohci_mem_read_unaligned(uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_MEM_READ_UNALIGNED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_mem_read_unaligned " "at %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_ohci_mem_read_bad_offset(uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_MEM_READ_BAD_OFFSET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_mem_read_bad_offset " "%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_ohci_mem_write_unaligned(uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_MEM_WRITE_UNALIGNED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_mem_write_unaligned " "at %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_ohci_mem_write_bad_offset(uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_MEM_WRITE_BAD_OFFSET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_mem_write_bad_offset " "%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_ohci_process_lists(uint32_t head, uint32_t cur)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_PROCESS_LISTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_process_lists " "head %x, cur %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , head, cur);
        }
    }
}

static inline void trace_usb_ohci_bus_eof_timer_failed(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_BUS_EOF_TIMER_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_bus_eof_timer_failed " "%s: timer_new_ns failed" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_usb_ohci_set_frame_interval(const char * name, uint16_t fi_x, uint16_t fi_u)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_SET_FRAME_INTERVAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_set_frame_interval " "%s: FrameInterval = 0x%x (%u)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, fi_x, fi_u);
        }
    }
}

static inline void trace_usb_ohci_hub_power_up(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_HUB_POWER_UP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_hub_power_up " "powered up all ports" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ohci_hub_power_down(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_HUB_POWER_DOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_hub_power_down " "powered down all ports" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ohci_init_time(int64_t frametime, int64_t bittime)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_INIT_TIME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_init_time " "usb_bit_time=%" PRId64 " usb_frame_time=%" PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , frametime, bittime);
        }
    }
}

static inline void trace_usb_ohci_die(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_DIE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_die " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ohci_async_complete(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_OHCI_ASYNC_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ohci_async_complete " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ehci_reset(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_reset " "=== RESET ===" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ehci_unrealize(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_UNREALIZE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_unrealize " "=== UNREALIZE ===" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ehci_opreg_read(uint32_t addr, const char * str, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_OPREG_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_opreg_read " "rd mmio %04x [%s] = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, str, val);
        }
    }
}

static inline void trace_usb_ehci_opreg_write(uint32_t addr, const char * str, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_OPREG_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_opreg_write " "wr mmio %04x [%s] = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, str, val);
        }
    }
}

static inline void trace_usb_ehci_opreg_change(uint32_t addr, const char * str, uint32_t new, uint32_t old)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_OPREG_CHANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_opreg_change " "ch mmio %04x [%s] = %x (old: %x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, str, new, old);
        }
    }
}

static inline void trace_usb_ehci_portsc_read(uint32_t addr, uint32_t port, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_PORTSC_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_portsc_read " "rd mmio %04x [port %d] = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, port, val);
        }
    }
}

static inline void trace_usb_ehci_portsc_write(uint32_t addr, uint32_t port, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_PORTSC_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_portsc_write " "wr mmio %04x [port %d] = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, port, val);
        }
    }
}

static inline void trace_usb_ehci_portsc_change(uint32_t addr, uint32_t port, uint32_t new, uint32_t old)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_PORTSC_CHANGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_portsc_change " "ch mmio %04x [port %d] = %x (old: %x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, port, new, old);
        }
    }
}

static inline void trace_usb_ehci_usbsts(const char * sts, int state)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_USBSTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_usbsts " "usbsts %s %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , sts, state);
        }
    }
}

static inline void trace_usb_ehci_state(const char * schedule, const char * state)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_state " "%s schedule %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , schedule, state);
        }
    }
}

static inline void trace_usb_ehci_qh_ptrs(void * q, uint32_t addr, uint32_t nxt, uint32_t c_qtd, uint32_t n_qtd, uint32_t a_qtd)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_QH_PTRS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_qh_ptrs " "q %p - QH @ %08x: next %08x qtds %08x,%08x,%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , q, addr, nxt, c_qtd, n_qtd, a_qtd);
        }
    }
}

static inline void trace_usb_ehci_qh_fields(uint32_t addr, int rl, int mplen, int eps, int ep, int devaddr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_QH_FIELDS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_qh_fields " "QH @ %08x - rl %d, mplen %d, eps %d, ep %d, dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, rl, mplen, eps, ep, devaddr);
        }
    }
}

static inline void trace_usb_ehci_qh_bits(uint32_t addr, int c, int h, int dtc, int i)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_QH_BITS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_qh_bits " "QH @ %08x - c %d, h %d, dtc %d, i %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, c, h, dtc, i);
        }
    }
}

static inline void trace_usb_ehci_qtd_ptrs(void * q, uint32_t addr, uint32_t nxt, uint32_t altnext)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_QTD_PTRS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_qtd_ptrs " "q %p - QTD @ %08x: next %08x altnext %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , q, addr, nxt, altnext);
        }
    }
}

static inline void trace_usb_ehci_qtd_fields(uint32_t addr, int tbytes, int cpage, int cerr, int pid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_QTD_FIELDS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_qtd_fields " "QTD @ %08x - tbytes %d, cpage %d, cerr %d, pid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tbytes, cpage, cerr, pid);
        }
    }
}

static inline void trace_usb_ehci_qtd_bits(uint32_t addr, int ioc, int active, int halt, int babble, int xacterr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_QTD_BITS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_qtd_bits " "QTD @ %08x - ioc %d, active %d, halt %d, babble %d, xacterr %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, ioc, active, halt, babble, xacterr);
        }
    }
}

static inline void trace_usb_ehci_itd(uint32_t addr, uint32_t nxt, uint32_t mplen, uint32_t mult, uint32_t ep, uint32_t devaddr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_ITD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_itd " "ITD @ %08x: next %08x - mplen %d, mult %d, ep %d, dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, nxt, mplen, mult, ep, devaddr);
        }
    }
}

static inline void trace_usb_ehci_sitd(uint32_t addr, uint32_t nxt, uint32_t active)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_SITD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_sitd " "ITD @ %08x: next %08x - active %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, nxt, active);
        }
    }
}

static inline void trace_usb_ehci_port_attach(uint32_t port, const char * owner, const char * device)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_PORT_ATTACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_port_attach " "attach port #%d, owner %s, device %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, owner, device);
        }
    }
}

static inline void trace_usb_ehci_port_detach(uint32_t port, const char * owner)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_PORT_DETACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_port_detach " "detach port #%d, owner %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, owner);
        }
    }
}

static inline void trace_usb_ehci_port_reset(uint32_t port, int enable)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_PORT_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_port_reset " "reset port #%d - %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, enable);
        }
    }
}

static inline void trace_usb_ehci_port_suspend(uint32_t port)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_PORT_SUSPEND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_port_suspend " "port #%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port);
        }
    }
}

static inline void trace_usb_ehci_port_wakeup(uint32_t port)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_PORT_WAKEUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_port_wakeup " "port #%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port);
        }
    }
}

static inline void trace_usb_ehci_port_resume(uint32_t port)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_PORT_RESUME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_port_resume " "port #%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port);
        }
    }
}

static inline void trace_usb_ehci_queue_action(void * q, const char * action)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_QUEUE_ACTION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_queue_action " "q %p: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , q, action);
        }
    }
}

static inline void trace_usb_ehci_packet_action(void * q, void * p, const char * action)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_PACKET_ACTION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_packet_action " "q %p p %p: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , q, p, action);
        }
    }
}

static inline void trace_usb_ehci_irq(uint32_t level, uint32_t frindex, uint32_t sts, uint32_t mask)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_irq " "level %d, frindex 0x%04x, sts 0x%x, mask 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , level, frindex, sts, mask);
        }
    }
}

static inline void trace_usb_ehci_guest_bug(const char * reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_GUEST_BUG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_guest_bug " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reason);
        }
    }
}

static inline void trace_usb_ehci_doorbell_ring(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_DOORBELL_RING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_doorbell_ring " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ehci_doorbell_ack(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_DOORBELL_ACK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_doorbell_ack " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_ehci_dma_error(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_EHCI_DMA_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_ehci_dma_error " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_uhci_reset(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_reset " "=== RESET ===" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_uhci_exit(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_exit " "=== EXIT ===" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_uhci_schedule_start(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_SCHEDULE_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_schedule_start " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_uhci_schedule_stop(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_SCHEDULE_STOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_schedule_stop " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_uhci_frame_start(uint32_t num)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_FRAME_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_frame_start " "nr %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , num);
        }
    }
}

static inline void trace_usb_uhci_frame_stop_bandwidth(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_FRAME_STOP_BANDWIDTH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_frame_stop_bandwidth " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_uhci_frame_loop_stop_idle(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_FRAME_LOOP_STOP_IDLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_frame_loop_stop_idle " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_uhci_frame_loop_continue(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_FRAME_LOOP_CONTINUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_frame_loop_continue " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_uhci_mmio_readw(uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_MMIO_READW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_mmio_readw " "addr 0x%04x, ret 0x%04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_usb_uhci_mmio_writew(uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_MMIO_WRITEW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_mmio_writew " "addr 0x%04x, val 0x%04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_usb_uhci_queue_add(uint32_t token)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_QUEUE_ADD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_queue_add " "token 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token);
        }
    }
}

static inline void trace_usb_uhci_queue_del(uint32_t token, const char * reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_QUEUE_DEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_queue_del " "token 0x%x: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, reason);
        }
    }
}

static inline void trace_usb_uhci_packet_add(uint32_t token, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_PACKET_ADD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_packet_add " "token 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, addr);
        }
    }
}

static inline void trace_usb_uhci_packet_link_async(uint32_t token, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_PACKET_LINK_ASYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_packet_link_async " "token 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, addr);
        }
    }
}

static inline void trace_usb_uhci_packet_unlink_async(uint32_t token, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_PACKET_UNLINK_ASYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_packet_unlink_async " "token 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, addr);
        }
    }
}

static inline void trace_usb_uhci_packet_cancel(uint32_t token, uint32_t addr, int done)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_PACKET_CANCEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_packet_cancel " "token 0x%x, td 0x%x, done %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, addr, done);
        }
    }
}

static inline void trace_usb_uhci_packet_complete_success(uint32_t token, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_PACKET_COMPLETE_SUCCESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_packet_complete_success " "token 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, addr);
        }
    }
}

static inline void trace_usb_uhci_packet_complete_shortxfer(uint32_t token, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_PACKET_COMPLETE_SHORTXFER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_packet_complete_shortxfer " "token 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, addr);
        }
    }
}

static inline void trace_usb_uhci_packet_complete_stall(uint32_t token, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_PACKET_COMPLETE_STALL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_packet_complete_stall " "token 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, addr);
        }
    }
}

static inline void trace_usb_uhci_packet_complete_babble(uint32_t token, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_PACKET_COMPLETE_BABBLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_packet_complete_babble " "token 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, addr);
        }
    }
}

static inline void trace_usb_uhci_packet_complete_error(uint32_t token, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_PACKET_COMPLETE_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_packet_complete_error " "token 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, addr);
        }
    }
}

static inline void trace_usb_uhci_packet_del(uint32_t token, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_PACKET_DEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_packet_del " "token 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , token, addr);
        }
    }
}

static inline void trace_usb_uhci_qh_load(uint32_t qh)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_QH_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_qh_load " "qh 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qh);
        }
    }
}

static inline void trace_usb_uhci_td_load(uint32_t qh, uint32_t td, uint32_t ctrl, uint32_t token)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_TD_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_td_load " "qh 0x%x, td 0x%x, ctrl 0x%x, token 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qh, td, ctrl, token);
        }
    }
}

static inline void trace_usb_uhci_td_queue(uint32_t td, uint32_t ctrl, uint32_t token)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_TD_QUEUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_td_queue " "td 0x%x, ctrl 0x%x, token 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , td, ctrl, token);
        }
    }
}

static inline void trace_usb_uhci_td_nextqh(uint32_t qh, uint32_t td)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_TD_NEXTQH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_td_nextqh " "qh 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qh, td);
        }
    }
}

static inline void trace_usb_uhci_td_async(uint32_t qh, uint32_t td)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_TD_ASYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_td_async " "qh 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qh, td);
        }
    }
}

static inline void trace_usb_uhci_td_complete(uint32_t qh, uint32_t td)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UHCI_TD_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uhci_td_complete " "qh 0x%x, td 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qh, td);
        }
    }
}

static inline void trace_usb_xhci_reset(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_reset " "=== RESET ===" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_xhci_exit(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_exit " "=== EXIT ===" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_xhci_run(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_RUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_run " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_xhci_stop(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_STOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_stop " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_xhci_cap_read(uint32_t off, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_CAP_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_cap_read " "off 0x%04x, ret 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , off, val);
        }
    }
}

static inline void trace_usb_xhci_oper_read(uint32_t off, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_OPER_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_oper_read " "off 0x%04x, ret 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , off, val);
        }
    }
}

static inline void trace_usb_xhci_port_read(uint32_t port, uint32_t off, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_PORT_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_port_read " "port %d, off 0x%04x, ret 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, off, val);
        }
    }
}

static inline void trace_usb_xhci_runtime_read(uint32_t off, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_RUNTIME_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_runtime_read " "off 0x%04x, ret 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , off, val);
        }
    }
}

static inline void trace_usb_xhci_doorbell_read(uint32_t off, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_DOORBELL_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_doorbell_read " "off 0x%04x, ret 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , off, val);
        }
    }
}

static inline void trace_usb_xhci_oper_write(uint32_t off, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_OPER_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_oper_write " "off 0x%04x, val 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , off, val);
        }
    }
}

static inline void trace_usb_xhci_port_write(uint32_t port, uint32_t off, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_PORT_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_port_write " "port %d, off 0x%04x, val 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, off, val);
        }
    }
}

static inline void trace_usb_xhci_runtime_write(uint32_t off, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_RUNTIME_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_runtime_write " "off 0x%04x, val 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , off, val);
        }
    }
}

static inline void trace_usb_xhci_doorbell_write(uint32_t off, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_DOORBELL_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_doorbell_write " "off 0x%04x, val 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , off, val);
        }
    }
}

static inline void trace_usb_xhci_irq_intx(uint32_t level)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_IRQ_INTX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_irq_intx " "level %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , level);
        }
    }
}

static inline void trace_usb_xhci_irq_msi(uint32_t nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_IRQ_MSI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_irq_msi " "nr %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nr);
        }
    }
}

static inline void trace_usb_xhci_irq_msix(uint32_t nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_IRQ_MSIX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_irq_msix " "nr %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nr);
        }
    }
}

static inline void trace_usb_xhci_irq_msix_use(uint32_t nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_IRQ_MSIX_USE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_irq_msix_use " "nr %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nr);
        }
    }
}

static inline void trace_usb_xhci_irq_msix_unuse(uint32_t nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_IRQ_MSIX_UNUSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_irq_msix_unuse " "nr %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nr);
        }
    }
}

static inline void trace_usb_xhci_queue_event(uint32_t vector, uint32_t idx, const char * trb, const char * evt, uint64_t param, uint32_t status, uint32_t control)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_QUEUE_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_queue_event " "v %d, idx %d, %s, %s, p %016" PRIx64 ", s %08x, c 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vector, idx, trb, evt, param, status, control);
        }
    }
}

static inline void trace_usb_xhci_fetch_trb(uint64_t addr, const char * name, uint64_t param, uint32_t status, uint32_t control)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_FETCH_TRB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_fetch_trb " "addr %016" PRIx64 ", %s, p %016" PRIx64 ", s %08x, c 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, name, param, status, control);
        }
    }
}

static inline void trace_usb_xhci_port_reset(uint32_t port, bool warm)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_PORT_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_port_reset " "port %d, warm %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, warm);
        }
    }
}

static inline void trace_usb_xhci_port_link(uint32_t port, uint32_t pls)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_PORT_LINK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_port_link " "port %d, pls %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, pls);
        }
    }
}

static inline void trace_usb_xhci_port_notify(uint32_t port, uint32_t pls)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_PORT_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_port_notify " "port %d, bits %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , port, pls);
        }
    }
}

static inline void trace_usb_xhci_slot_enable(uint32_t slotid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_SLOT_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_slot_enable " "slotid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid);
        }
    }
}

static inline void trace_usb_xhci_slot_disable(uint32_t slotid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_SLOT_DISABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_slot_disable " "slotid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid);
        }
    }
}

static inline void trace_usb_xhci_slot_address(uint32_t slotid, const char * port)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_SLOT_ADDRESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_slot_address " "slotid %d, port %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid, port);
        }
    }
}

static inline void trace_usb_xhci_slot_configure(uint32_t slotid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_SLOT_CONFIGURE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_slot_configure " "slotid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid);
        }
    }
}

static inline void trace_usb_xhci_slot_evaluate(uint32_t slotid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_SLOT_EVALUATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_slot_evaluate " "slotid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid);
        }
    }
}

static inline void trace_usb_xhci_slot_reset(uint32_t slotid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_SLOT_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_slot_reset " "slotid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid);
        }
    }
}

static inline void trace_usb_xhci_ep_enable(uint32_t slotid, uint32_t epid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_EP_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_ep_enable " "slotid %d, epid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid, epid);
        }
    }
}

static inline void trace_usb_xhci_ep_disable(uint32_t slotid, uint32_t epid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_EP_DISABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_ep_disable " "slotid %d, epid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid, epid);
        }
    }
}

static inline void trace_usb_xhci_ep_set_dequeue(uint32_t slotid, uint32_t epid, uint32_t streamid, uint64_t param)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_EP_SET_DEQUEUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_ep_set_dequeue " "slotid %d, epid %d, streamid %d, ptr %016" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid, epid, streamid, param);
        }
    }
}

static inline void trace_usb_xhci_ep_kick(uint32_t slotid, uint32_t epid, uint32_t streamid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_EP_KICK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_ep_kick " "slotid %d, epid %d, streamid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid, epid, streamid);
        }
    }
}

static inline void trace_usb_xhci_ep_stop(uint32_t slotid, uint32_t epid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_EP_STOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_ep_stop " "slotid %d, epid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid, epid);
        }
    }
}

static inline void trace_usb_xhci_ep_reset(uint32_t slotid, uint32_t epid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_EP_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_ep_reset " "slotid %d, epid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid, epid);
        }
    }
}

static inline void trace_usb_xhci_ep_state(uint32_t slotid, uint32_t epid, const char * os, const char * ns)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_EP_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_ep_state " "slotid %d, epid %d, %s -> %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slotid, epid, os, ns);
        }
    }
}

static inline void trace_usb_xhci_xfer_start(void * xfer, uint32_t slotid, uint32_t epid, uint32_t streamid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_XFER_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_xfer_start " "%p: slotid %d, epid %d, streamid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , xfer, slotid, epid, streamid);
        }
    }
}

static inline void trace_usb_xhci_xfer_async(void * xfer)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_XFER_ASYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_xfer_async " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , xfer);
        }
    }
}

static inline void trace_usb_xhci_xfer_nak(void * xfer)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_XFER_NAK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_xfer_nak " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , xfer);
        }
    }
}

static inline void trace_usb_xhci_xfer_retry(void * xfer)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_XFER_RETRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_xfer_retry " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , xfer);
        }
    }
}

static inline void trace_usb_xhci_xfer_success(void * xfer, uint32_t bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_XFER_SUCCESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_xfer_success " "%p: len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , xfer, bytes);
        }
    }
}

static inline void trace_usb_xhci_xfer_error(void * xfer, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_XFER_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_xfer_error " "%p: ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , xfer, ret);
        }
    }
}

static inline void trace_usb_xhci_unimplemented(const char * item, int nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_XHCI_UNIMPLEMENTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_xhci_unimplemented " "%s (0x%x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , item, nr);
        }
    }
}

static inline void trace_usb_desc_device(int addr, int len, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_DESC_DEVICE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_desc_device " "dev %d query device, len %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, len, ret);
        }
    }
}

static inline void trace_usb_desc_device_qualifier(int addr, int len, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_DESC_DEVICE_QUALIFIER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_desc_device_qualifier " "dev %d query device qualifier, len %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, len, ret);
        }
    }
}

static inline void trace_usb_desc_config(int addr, int index, int len, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_DESC_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_desc_config " "dev %d query config %d, len %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, index, len, ret);
        }
    }
}

static inline void trace_usb_desc_other_speed_config(int addr, int index, int len, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_DESC_OTHER_SPEED_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_desc_other_speed_config " "dev %d query config %d, len %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, index, len, ret);
        }
    }
}

static inline void trace_usb_desc_string(int addr, int index, int len, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_DESC_STRING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_desc_string " "dev %d query string %d, len %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, index, len, ret);
        }
    }
}

static inline void trace_usb_desc_bos(int addr, int len, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_DESC_BOS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_desc_bos " "dev %d bos, len %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, len, ret);
        }
    }
}

static inline void trace_usb_desc_msos(int addr, int index, int len, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_DESC_MSOS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_desc_msos " "dev %d msos, index 0x%x, len %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, index, len, ret);
        }
    }
}

static inline void trace_usb_set_addr(int addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_SET_ADDR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_set_addr " "dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_set_config(int addr, int config, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_SET_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_set_config " "dev %d, config %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, config, ret);
        }
    }
}

static inline void trace_usb_set_interface(int addr, int iface, int alt, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_SET_INTERFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_set_interface " "dev %d, interface %d, altsetting %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, iface, alt, ret);
        }
    }
}

static inline void trace_usb_clear_device_feature(int addr, int feature, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_CLEAR_DEVICE_FEATURE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_clear_device_feature " "dev %d, feature %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, feature, ret);
        }
    }
}

static inline void trace_usb_set_device_feature(int addr, int feature, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_SET_DEVICE_FEATURE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_set_device_feature " "dev %d, feature %d, ret %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, feature, ret);
        }
    }
}

static inline void trace_usb_hub_reset(int addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HUB_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_hub_reset " "dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_hub_control(int addr, int request, int value, int index, int length)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HUB_CONTROL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_hub_control " "dev %d, req 0x%x, value %d, index %d, langth %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, request, value, index, length);
        }
    }
}

static inline void trace_usb_hub_get_port_status(int addr, int nr, int status, int changed)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HUB_GET_PORT_STATUS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_hub_get_port_status " "dev %d, port %d, status 0x%x, changed 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, nr, status, changed);
        }
    }
}

static inline void trace_usb_hub_set_port_feature(int addr, int nr, const char * f)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HUB_SET_PORT_FEATURE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_hub_set_port_feature " "dev %d, port %d, feature %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, nr, f);
        }
    }
}

static inline void trace_usb_hub_clear_port_feature(int addr, int nr, const char * f)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HUB_CLEAR_PORT_FEATURE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_hub_clear_port_feature " "dev %d, port %d, feature %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, nr, f);
        }
    }
}

static inline void trace_usb_hub_attach(int addr, int nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HUB_ATTACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_hub_attach " "dev %d, port %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, nr);
        }
    }
}

static inline void trace_usb_hub_detach(int addr, int nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HUB_DETACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_hub_detach " "dev %d, port %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, nr);
        }
    }
}

static inline void trace_usb_hub_status_report(int addr, int status)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HUB_STATUS_REPORT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_hub_status_report " "dev %d, status 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, status);
        }
    }
}

static inline void trace_usb_uas_reset(int addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_reset " "dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_uas_command(int addr, uint16_t tag, int lun, uint32_t lun64_1, uint32_t lun64_2)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_COMMAND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_command " "dev %d, tag 0x%x, lun %d, lun64 %08x-%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag, lun, lun64_1, lun64_2);
        }
    }
}

static inline void trace_usb_uas_response(int addr, uint16_t tag, uint8_t code)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_RESPONSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_response " "dev %d, tag 0x%x, code 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag, code);
        }
    }
}

static inline void trace_usb_uas_sense(int addr, uint16_t tag, uint8_t status)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_SENSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_sense " "dev %d, tag 0x%x, status 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag, status);
        }
    }
}

static inline void trace_usb_uas_read_ready(int addr, uint16_t tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_READ_READY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_read_ready " "dev %d, tag 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag);
        }
    }
}

static inline void trace_usb_uas_write_ready(int addr, uint16_t tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_WRITE_READY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_write_ready " "dev %d, tag 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag);
        }
    }
}

static inline void trace_usb_uas_xfer_data(int addr, uint16_t tag, uint32_t copy, uint32_t uoff, uint32_t usize, uint32_t soff, uint32_t ssize)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_XFER_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_xfer_data " "dev %d, tag 0x%x, copy %d, usb-pkt %d/%d, scsi-buf %d/%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag, copy, uoff, usize, soff, ssize);
        }
    }
}

static inline void trace_usb_uas_scsi_data(int addr, uint16_t tag, uint32_t bytes)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_SCSI_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_scsi_data " "dev %d, tag 0x%x, bytes %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag, bytes);
        }
    }
}

static inline void trace_usb_uas_scsi_complete(int addr, uint16_t tag, uint32_t status, uint32_t resid)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_SCSI_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_scsi_complete " "dev %d, tag 0x%x, status 0x%x, residue %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag, status, resid);
        }
    }
}

static inline void trace_usb_uas_tmf_abort_task(int addr, uint16_t tag, uint16_t task_tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_TMF_ABORT_TASK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_tmf_abort_task " "dev %d, tag 0x%x, task-tag 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag, task_tag);
        }
    }
}

static inline void trace_usb_uas_tmf_logical_unit_reset(int addr, uint16_t tag, int lun)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_TMF_LOGICAL_UNIT_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_tmf_logical_unit_reset " "dev %d, tag 0x%x, lun %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag, lun);
        }
    }
}

static inline void trace_usb_uas_tmf_unsupported(int addr, uint16_t tag, uint32_t function)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_UAS_TMF_UNSUPPORTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_uas_tmf_unsupported " "dev %d, tag 0x%x, function 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, tag, function);
        }
    }
}

static inline void trace_usb_mtp_reset(int addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_reset " "dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_usb_mtp_command(int dev, uint16_t code, uint32_t trans, uint32_t arg0, uint32_t arg1, uint32_t arg2, uint32_t arg3, uint32_t arg4)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_COMMAND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_command " "dev %d, code 0x%x, trans 0x%x, args 0x%x, 0x%x, 0x%x, 0x%x, 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, code, trans, arg0, arg1, arg2, arg3, arg4);
        }
    }
}

static inline void trace_usb_mtp_success(int dev, uint32_t trans, uint32_t arg0, uint32_t arg1)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_SUCCESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_success " "dev %d, trans 0x%x, args 0x%x, 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, trans, arg0, arg1);
        }
    }
}

static inline void trace_usb_mtp_error(int dev, uint16_t code, uint32_t trans, uint32_t arg0, uint32_t arg1)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_error " "dev %d, code 0x%x, trans 0x%x, args 0x%x, 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, code, trans, arg0, arg1);
        }
    }
}

static inline void trace_usb_mtp_data_in(int dev, uint32_t trans, uint32_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_DATA_IN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_data_in " "dev %d, trans 0x%x, len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, trans, len);
        }
    }
}

static inline void trace_usb_mtp_xfer(int dev, uint32_t ep, uint32_t dlen, uint32_t plen)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_XFER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_xfer " "dev %d, ep %d, %d/%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, ep, dlen, plen);
        }
    }
}

static inline void trace_usb_mtp_nak(int dev, uint32_t ep)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_NAK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_nak " "dev %d, ep %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, ep);
        }
    }
}

static inline void trace_usb_mtp_stall(int dev, const char * reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_STALL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_stall " "dev %d, reason: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, reason);
        }
    }
}

static inline void trace_usb_mtp_op_get_device_info(int dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_GET_DEVICE_INFO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_get_device_info " "dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev);
        }
    }
}

static inline void trace_usb_mtp_op_open_session(int dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_OPEN_SESSION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_open_session " "dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev);
        }
    }
}

static inline void trace_usb_mtp_op_close_session(int dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_CLOSE_SESSION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_close_session " "dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev);
        }
    }
}

static inline void trace_usb_mtp_op_get_storage_ids(int dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_GET_STORAGE_IDS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_get_storage_ids " "dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev);
        }
    }
}

static inline void trace_usb_mtp_op_get_storage_info(int dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_GET_STORAGE_INFO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_get_storage_info " "dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev);
        }
    }
}

static inline void trace_usb_mtp_op_get_num_objects(int dev, uint32_t handle, const char * path)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_GET_NUM_OBJECTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_get_num_objects " "dev %d, handle 0x%x, path %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, handle, path);
        }
    }
}

static inline void trace_usb_mtp_op_get_object_handles(int dev, uint32_t handle, const char * path)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_GET_OBJECT_HANDLES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_get_object_handles " "dev %d, handle 0x%x, path %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, handle, path);
        }
    }
}

static inline void trace_usb_mtp_op_get_object_info(int dev, uint32_t handle, const char * path)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_GET_OBJECT_INFO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_get_object_info " "dev %d, handle 0x%x, path %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, handle, path);
        }
    }
}

static inline void trace_usb_mtp_op_get_object(int dev, uint32_t handle, const char * path)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_GET_OBJECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_get_object " "dev %d, handle 0x%x, path %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, handle, path);
        }
    }
}

static inline void trace_usb_mtp_op_get_partial_object(int dev, uint32_t handle, const char * path, uint32_t offset, uint32_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_GET_PARTIAL_OBJECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_get_partial_object " "dev %d, handle 0x%x, path %s, off %d, len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, handle, path, offset, length);
        }
    }
}

static inline void trace_usb_mtp_op_unknown(int dev, uint32_t code)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OP_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_op_unknown " "dev %d, command code 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, code);
        }
    }
}

static inline void trace_usb_mtp_object_alloc(int dev, uint32_t handle, const char * path)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OBJECT_ALLOC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_object_alloc " "dev %d, handle 0x%x, path %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, handle, path);
        }
    }
}

static inline void trace_usb_mtp_object_free(int dev, uint32_t handle, const char * path)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_OBJECT_FREE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_object_free " "dev %d, handle 0x%x, path %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, handle, path);
        }
    }
}

static inline void trace_usb_mtp_add_child(int dev, uint32_t handle, const char * path)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_ADD_CHILD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_add_child " "dev %d, handle 0x%x, path %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, handle, path);
        }
    }
}

static inline void trace_usb_mtp_inotify_event(int dev, const char * path, uint32_t mask, const char * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_MTP_INOTIFY_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_mtp_inotify_event " "dev %d, path %s mask 0x%x event %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, path, mask, s);
        }
    }
}

static inline void trace_usb_host_open_started(int bus, int addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_OPEN_STARTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_open_started " "dev %d:%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr);
        }
    }
}

static inline void trace_usb_host_open_success(int bus, int addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_OPEN_SUCCESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_open_success " "dev %d:%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr);
        }
    }
}

static inline void trace_usb_host_open_failure(int bus, int addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_OPEN_FAILURE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_open_failure " "dev %d:%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr);
        }
    }
}

static inline void trace_usb_host_close(int bus, int addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_CLOSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_close " "dev %d:%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr);
        }
    }
}

static inline void trace_usb_host_attach_kernel(int bus, int addr, int interface)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_ATTACH_KERNEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_attach_kernel " "dev %d:%d, if %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, interface);
        }
    }
}

static inline void trace_usb_host_detach_kernel(int bus, int addr, int interface)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_DETACH_KERNEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_detach_kernel " "dev %d:%d, if %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, interface);
        }
    }
}

static inline void trace_usb_host_set_address(int bus, int addr, int config)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_SET_ADDRESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_set_address " "dev %d:%d, address %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, config);
        }
    }
}

static inline void trace_usb_host_set_config(int bus, int addr, int config)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_SET_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_set_config " "dev %d:%d, config %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, config);
        }
    }
}

static inline void trace_usb_host_set_interface(int bus, int addr, int interface, int alt)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_SET_INTERFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_set_interface " "dev %d:%d, interface %d, alt %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, interface, alt);
        }
    }
}

static inline void trace_usb_host_claim_interface(int bus, int addr, int config, int interface)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_CLAIM_INTERFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_claim_interface " "dev %d:%d, config %d, if %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, config, interface);
        }
    }
}

static inline void trace_usb_host_release_interface(int bus, int addr, int interface)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_RELEASE_INTERFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_release_interface " "dev %d:%d, if %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, interface);
        }
    }
}

static inline void trace_usb_host_req_control(int bus, int addr, void * p, int req, int value, int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_REQ_CONTROL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_req_control " "dev %d:%d, packet %p, req 0x%x, value %d, index %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, p, req, value, index);
        }
    }
}

static inline void trace_usb_host_req_data(int bus, int addr, void * p, int in, int ep, int size)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_REQ_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_req_data " "dev %d:%d, packet %p, in %d, ep %d, size %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, p, in, ep, size);
        }
    }
}

static inline void trace_usb_host_req_complete(int bus, int addr, void * p, int status, int length)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_REQ_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_req_complete " "dev %d:%d, packet %p, status %d, length %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, p, status, length);
        }
    }
}

static inline void trace_usb_host_req_emulated(int bus, int addr, void * p, int status)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_REQ_EMULATED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_req_emulated " "dev %d:%d, packet %p, status %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, p, status);
        }
    }
}

static inline void trace_usb_host_req_canceled(int bus, int addr, void * p)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_REQ_CANCELED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_req_canceled " "dev %d:%d, packet %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, p);
        }
    }
}

static inline void trace_usb_host_iso_start(int bus, int addr, int ep)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_ISO_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_iso_start " "dev %d:%d, ep %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, ep);
        }
    }
}

static inline void trace_usb_host_iso_stop(int bus, int addr, int ep)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_ISO_STOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_iso_stop " "dev %d:%d, ep %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, ep);
        }
    }
}

static inline void trace_usb_host_iso_out_of_bufs(int bus, int addr, int ep)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_ISO_OUT_OF_BUFS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_iso_out_of_bufs " "dev %d:%d, ep %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, ep);
        }
    }
}

static inline void trace_usb_host_reset(int bus, int addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_reset " "dev %d:%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr);
        }
    }
}

static inline void trace_usb_host_auto_scan_enabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_AUTO_SCAN_ENABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_auto_scan_enabled "  "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_host_auto_scan_disabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_AUTO_SCAN_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_auto_scan_disabled "  "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_usb_host_parse_config(int bus, int addr, int value, int active)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_PARSE_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_parse_config " "dev %d:%d, value %d, active %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, value, active);
        }
    }
}

static inline void trace_usb_host_parse_interface(int bus, int addr, int num, int alt, int active)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_PARSE_INTERFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_parse_interface " "dev %d:%d, num %d, alt %d, active %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, num, alt, active);
        }
    }
}

static inline void trace_usb_host_parse_endpoint(int bus, int addr, int ep, const char * dir, const char * type, int active)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_PARSE_ENDPOINT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_parse_endpoint " "dev %d:%d, ep %d, %s, %s, active %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, ep, dir, type, active);
        }
    }
}

static inline void trace_usb_host_parse_error(int bus, int addr, const char * errmsg)
{
    if (true) {
        if (trace_event_get_state(TRACE_USB_HOST_PARSE_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:usb_host_parse_error " "dev %d:%d, msg %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , bus, addr, errmsg);
        }
    }
}

static inline void trace_scsi_req_alloc(int target, int lun, int tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_ALLOC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_alloc " "target %d lun %d tag %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag);
        }
    }
}

static inline void trace_scsi_req_cancel(int target, int lun, int tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_CANCEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_cancel " "target %d lun %d tag %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag);
        }
    }
}

static inline void trace_scsi_req_data(int target, int lun, int tag, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_data " "target %d lun %d tag %d len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag, len);
        }
    }
}

static inline void trace_scsi_req_data_canceled(int target, int lun, int tag, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_DATA_CANCELED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_data_canceled " "target %d lun %d tag %d len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag, len);
        }
    }
}

static inline void trace_scsi_req_dequeue(int target, int lun, int tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_DEQUEUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_dequeue " "target %d lun %d tag %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag);
        }
    }
}

static inline void trace_scsi_req_continue(int target, int lun, int tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_CONTINUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_continue " "target %d lun %d tag %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag);
        }
    }
}

static inline void trace_scsi_req_continue_canceled(int target, int lun, int tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_CONTINUE_CANCELED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_continue_canceled " "target %d lun %d tag %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag);
        }
    }
}

static inline void trace_scsi_req_parsed(int target, int lun, int tag, int cmd, int mode, int xfer)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_PARSED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_parsed " "target %d lun %d tag %d command %d dir %d length %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag, cmd, mode, xfer);
        }
    }
}

static inline void trace_scsi_req_parsed_lba(int target, int lun, int tag, int cmd, uint64_t lba)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_PARSED_LBA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_parsed_lba " "target %d lun %d tag %d command %d lba %"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag, cmd, lba);
        }
    }
}

static inline void trace_scsi_req_parse_bad(int target, int lun, int tag, int cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_PARSE_BAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_parse_bad " "target %d lun %d tag %d command %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag, cmd);
        }
    }
}

static inline void trace_scsi_req_build_sense(int target, int lun, int tag, int key, int asc, int ascq)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQ_BUILD_SENSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_req_build_sense " "target %d lun %d tag %d key %#02x asc %#02x ascq %#02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag, key, asc, ascq);
        }
    }
}

static inline void trace_scsi_device_set_ua(int target, int lun, int key, int asc, int ascq)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_DEVICE_SET_UA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_device_set_ua " "target %d lun %d key %#02x asc %#02x ascq %#02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, key, asc, ascq);
        }
    }
}

static inline void trace_scsi_report_luns(int target, int lun, int tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REPORT_LUNS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_report_luns " "target %d lun %d tag %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag);
        }
    }
}

static inline void trace_scsi_inquiry(int target, int lun, int tag, int cdb1, int cdb2)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_INQUIRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_inquiry " "target %d lun %d tag %d page %#02x/%#02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag, cdb1, cdb2);
        }
    }
}

static inline void trace_scsi_test_unit_ready(int target, int lun, int tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_TEST_UNIT_READY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_test_unit_ready " "target %d lun %d tag %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag);
        }
    }
}

static inline void trace_scsi_request_sense(int target, int lun, int tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_SCSI_REQUEST_SENSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:scsi_request_sense " "target %d lun %d tag %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , target, lun, tag);
        }
    }
}

static inline void trace_mptsas_command_complete(void * dev, uint32_t ctx, uint32_t status, uint32_t resid)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_COMMAND_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_command_complete " "dev %p context 0x%08x status %x resid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, ctx, status, resid);
        }
    }
}

static inline void trace_mptsas_diag_read(void * dev, uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_DIAG_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_diag_read " "dev %p addr 0x%08x value 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, addr, val);
        }
    }
}

static inline void trace_mptsas_diag_write(void * dev, uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_DIAG_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_diag_write " "dev %p addr 0x%08x value 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, addr, val);
        }
    }
}

static inline void trace_mptsas_irq_intx(void * dev, int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_IRQ_INTX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_irq_intx " "dev %p level %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, level);
        }
    }
}

static inline void trace_mptsas_irq_msi(void * dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_IRQ_MSI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_irq_msi " "dev %p " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev);
        }
    }
}

static inline void trace_mptsas_mmio_read(void * dev, uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_MMIO_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_mmio_read " "dev %p addr 0x%08x value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, addr, val);
        }
    }
}

static inline void trace_mptsas_mmio_unhandled_read(void * dev, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_MMIO_UNHANDLED_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_mmio_unhandled_read " "dev %p addr 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, addr);
        }
    }
}

static inline void trace_mptsas_mmio_unhandled_write(void * dev, uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_MMIO_UNHANDLED_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_mmio_unhandled_write " "dev %p addr 0x%08x value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, addr, val);
        }
    }
}

static inline void trace_mptsas_mmio_write(void * dev, uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_MMIO_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_mmio_write " "dev %p addr 0x%08x value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, addr, val);
        }
    }
}

static inline void trace_mptsas_process_message(void * dev, int msg, uint32_t ctx)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_PROCESS_MESSAGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_process_message " "dev %p cmd %d context 0x%08x\n" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, msg, ctx);
        }
    }
}

static inline void trace_mptsas_process_scsi_io_request(void * dev, int bus, int target, int lun, uint64_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_PROCESS_SCSI_IO_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_process_scsi_io_request " "dev %p dev %d:%d:%d length %"PRIu64"" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, bus, target, lun, len);
        }
    }
}

static inline void trace_mptsas_reset(void * dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_reset " "dev %p " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev);
        }
    }
}

static inline void trace_mptsas_scsi_overflow(void * dev, uint32_t ctx, uint64_t req, uint64_t found)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_SCSI_OVERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_scsi_overflow " "dev %p context 0x%08x: %"PRIu64"/%"PRIu64"" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, ctx, req, found);
        }
    }
}

static inline void trace_mptsas_sgl_overflow(void * dev, uint32_t ctx, uint64_t req, uint64_t found)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_SGL_OVERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_sgl_overflow " "dev %p context 0x%08x: %"PRIu64"/%"PRIu64"" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, ctx, req, found);
        }
    }
}

static inline void trace_mptsas_unhandled_cmd(void * dev, uint32_t ctx, uint8_t msg_cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_UNHANDLED_CMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_unhandled_cmd " "dev %p context 0x%08x: Unhandled cmd %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, ctx, msg_cmd);
        }
    }
}

static inline void trace_mptsas_unhandled_doorbell_cmd(void * dev, int cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_UNHANDLED_DOORBELL_CMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_unhandled_doorbell_cmd " "dev %p value 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, cmd);
        }
    }
}

static inline void trace_mptsas_config_sas_device(void * dev, int address, int port, int phy_handle, int dev_handle, int page)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_CONFIG_SAS_DEVICE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_config_sas_device " "dev %p address %d (port %d, handles: phy %d dev %d) page %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, address, port, phy_handle, dev_handle, page);
        }
    }
}

static inline void trace_mptsas_config_sas_phy(void * dev, int address, int port, int phy_handle, int dev_handle, int page)
{
    if (true) {
        if (trace_event_get_state(TRACE_MPTSAS_CONFIG_SAS_PHY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mptsas_config_sas_phy " "dev %p address %d (port %d, handles: phy %d dev %d) page %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, address, port, phy_handle, dev_handle, page);
        }
    }
}

static inline void trace_megasas_init_firmware(uint64_t pa)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_INIT_FIRMWARE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_init_firmware " "pa %" PRIx64 " " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pa);
        }
    }
}

static inline void trace_megasas_init_queue(uint64_t queue_pa, int queue_len, uint64_t head, uint64_t tail, uint32_t flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_INIT_QUEUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_init_queue " "queue at %" PRIx64 " len %d head %" PRIx64 " tail %" PRIx64 " flags %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , queue_pa, queue_len, head, tail, flags);
        }
    }
}

static inline void trace_megasas_initq_map_failed(int frame)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_INITQ_MAP_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_initq_map_failed " "scmd %d: failed to map queue" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , frame);
        }
    }
}

static inline void trace_megasas_initq_mapped(uint64_t pa)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_INITQ_MAPPED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_initq_mapped " "queue already mapped at %" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pa);
        }
    }
}

static inline void trace_megasas_initq_mismatch(int queue_len, int fw_cmds)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_INITQ_MISMATCH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_initq_mismatch " "queue size %d max fw cmds %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , queue_len, fw_cmds);
        }
    }
}

static inline void trace_megasas_qf_mapped(unsigned int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_QF_MAPPED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_qf_mapped " "skip mapped frame %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_megasas_qf_new(unsigned int index, uint64_t frame)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_QF_NEW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_qf_new " "frame %x addr %" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, frame);
        }
    }
}

static inline void trace_megasas_qf_busy(unsigned long pa)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_QF_BUSY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_qf_busy " "all frames busy for frame %lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pa);
        }
    }
}

static inline void trace_megasas_qf_enqueue(unsigned int index, unsigned int count, uint64_t context, unsigned int head, unsigned int tail, int busy)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_QF_ENQUEUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_qf_enqueue " "frame %x count %d context %" PRIx64 " head %x tail %x busy %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, count, context, head, tail, busy);
        }
    }
}

static inline void trace_megasas_qf_update(unsigned int head, unsigned int tail, unsigned int busy)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_QF_UPDATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_qf_update " "head %x tail %x busy %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , head, tail, busy);
        }
    }
}

static inline void trace_megasas_qf_map_failed(int cmd, unsigned long frame)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_QF_MAP_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_qf_map_failed " "scmd %d: frame %lu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, frame);
        }
    }
}

static inline void trace_megasas_qf_complete_noirq(uint64_t context)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_QF_COMPLETE_NOIRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_qf_complete_noirq " "context %" PRIx64 " " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , context);
        }
    }
}

static inline void trace_megasas_qf_complete(uint64_t context, unsigned int head, unsigned int tail, int busy)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_QF_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_qf_complete " "context %" PRIx64 " head %x tail %x busy %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , context, head, tail, busy);
        }
    }
}

static inline void trace_megasas_frame_busy(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_FRAME_BUSY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_frame_busy " "frame %" PRIx64 " busy" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_megasas_unhandled_frame_cmd(int cmd, uint8_t frame_cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_UNHANDLED_FRAME_CMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_unhandled_frame_cmd " "scmd %d: MFI cmd %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, frame_cmd);
        }
    }
}

static inline void trace_megasas_handle_scsi(const char * frame, int bus, int dev, int lun, void * sdev, unsigned long size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_HANDLE_SCSI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_handle_scsi " "%s dev %x/%x/%x sdev %p xfer %lu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , frame, bus, dev, lun, sdev, size);
        }
    }
}

static inline void trace_megasas_scsi_target_not_present(const char * frame, int bus, int dev, int lun)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_SCSI_TARGET_NOT_PRESENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_scsi_target_not_present " "%s dev %x/%x/%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , frame, bus, dev, lun);
        }
    }
}

static inline void trace_megasas_scsi_invalid_cdb_len(const char * frame, int bus, int dev, int lun, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_SCSI_INVALID_CDB_LEN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_scsi_invalid_cdb_len " "%s dev %x/%x/%x invalid cdb len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , frame, bus, dev, lun, len);
        }
    }
}

static inline void trace_megasas_iov_read_overflow(int cmd, int bytes, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IOV_READ_OVERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_iov_read_overflow " "scmd %d: %d/%d bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, bytes, len);
        }
    }
}

static inline void trace_megasas_iov_write_overflow(int cmd, int bytes, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IOV_WRITE_OVERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_iov_write_overflow " "scmd %d: %d/%d bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, bytes, len);
        }
    }
}

static inline void trace_megasas_iov_read_underflow(int cmd, int bytes, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IOV_READ_UNDERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_iov_read_underflow " "scmd %d: %d/%d bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, bytes, len);
        }
    }
}

static inline void trace_megasas_iov_write_underflow(int cmd, int bytes, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IOV_WRITE_UNDERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_iov_write_underflow " "scmd %d: %d/%d bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, bytes, len);
        }
    }
}

static inline void trace_megasas_scsi_req_alloc_failed(const char * frame, int dev, int lun)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_SCSI_REQ_ALLOC_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_scsi_req_alloc_failed " "%s dev %x/%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , frame, dev, lun);
        }
    }
}

static inline void trace_megasas_scsi_read_start(int cmd, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_SCSI_READ_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_scsi_read_start " "scmd %d: transfer %d bytes of data" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, len);
        }
    }
}

static inline void trace_megasas_scsi_write_start(int cmd, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_SCSI_WRITE_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_scsi_write_start " "scmd %d: transfer %d bytes of data" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, len);
        }
    }
}

static inline void trace_megasas_scsi_nodata(int cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_SCSI_NODATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_scsi_nodata " "scmd %d: no data to be transferred" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd);
        }
    }
}

static inline void trace_megasas_scsi_complete(int cmd, uint32_t status, int len, int xfer)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_SCSI_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_scsi_complete " "scmd %d: status %x, len %u/%u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, status, len, xfer);
        }
    }
}

static inline void trace_megasas_command_complete(int cmd, uint32_t status, uint32_t resid)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_COMMAND_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_command_complete " "scmd %d: status %x, residual %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, status, resid);
        }
    }
}

static inline void trace_megasas_handle_io(int cmd, const char * frame, int dev, int lun, unsigned long lba, unsigned long count)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_HANDLE_IO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_handle_io " "scmd %d: %s dev %x/%x lba %lx count %lu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, frame, dev, lun, lba, count);
        }
    }
}

static inline void trace_megasas_io_target_not_present(int cmd, const char * frame, int dev, int lun)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IO_TARGET_NOT_PRESENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_io_target_not_present " "scmd %d: %s dev 1/%x/%x LUN not present" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, frame, dev, lun);
        }
    }
}

static inline void trace_megasas_io_read_start(int cmd, unsigned long lba, unsigned long count, unsigned long len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IO_READ_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_io_read_start " "scmd %d: start LBA %lx %lu blocks (%lu bytes)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, lba, count, len);
        }
    }
}

static inline void trace_megasas_io_write_start(int cmd, unsigned long lba, unsigned long count, unsigned long len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IO_WRITE_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_io_write_start " "scmd %d: start LBA %lx %lu blocks (%lu bytes)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, lba, count, len);
        }
    }
}

static inline void trace_megasas_io_complete(int cmd, uint32_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IO_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_io_complete " "scmd %d: %d bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, len);
        }
    }
}

static inline void trace_megasas_iovec_sgl_overflow(int cmd, int index, int limit)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IOVEC_SGL_OVERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_iovec_sgl_overflow " "scmd %d: iovec count %d limit %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, index, limit);
        }
    }
}

static inline void trace_megasas_iovec_sgl_underflow(int cmd, int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IOVEC_SGL_UNDERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_iovec_sgl_underflow " "scmd %d: iovec count %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, index);
        }
    }
}

static inline void trace_megasas_iovec_sgl_invalid(int cmd, int index, uint64_t pa, uint32_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IOVEC_SGL_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_iovec_sgl_invalid " "scmd %d: element %d pa %" PRIx64 " len %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, index, pa, len);
        }
    }
}

static inline void trace_megasas_iovec_overflow(int cmd, int len, int limit)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IOVEC_OVERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_iovec_overflow " "scmd %d: len %d limit %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, len, limit);
        }
    }
}

static inline void trace_megasas_iovec_underflow(int cmd, int len, int limit)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IOVEC_UNDERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_iovec_underflow " "scmd %d: len %d limit %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, len, limit);
        }
    }
}

static inline void trace_megasas_handle_dcmd(int cmd, int opcode)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_HANDLE_DCMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_handle_dcmd " "scmd %d: MFI DCMD opcode %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, opcode);
        }
    }
}

static inline void trace_megasas_finish_dcmd(int cmd, int size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_FINISH_DCMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_finish_dcmd " "scmd %d: MFI DCMD wrote %d bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, size);
        }
    }
}

static inline void trace_megasas_dcmd_req_alloc_failed(int cmd, const char * desc)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_REQ_ALLOC_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_req_alloc_failed " "scmd %d: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, desc);
        }
    }
}

static inline void trace_megasas_dcmd_internal_submit(int cmd, const char * desc, int dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_INTERNAL_SUBMIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_internal_submit " "scmd %d: %s to dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, desc, dev);
        }
    }
}

static inline void trace_megasas_dcmd_internal_finish(int cmd, int opcode, int lun)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_INTERNAL_FINISH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_internal_finish " "scmd %d: cmd %x lun %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, opcode, lun);
        }
    }
}

static inline void trace_megasas_dcmd_internal_invalid(int cmd, int opcode)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_INTERNAL_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_internal_invalid " "scmd %d: DCMD %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, opcode);
        }
    }
}

static inline void trace_megasas_dcmd_unhandled(int cmd, int opcode, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_UNHANDLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_unhandled " "scmd %d: opcode %x, len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, opcode, len);
        }
    }
}

static inline void trace_megasas_dcmd_zero_sge(int cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_ZERO_SGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_zero_sge " "scmd %d: zero DCMD sge count" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd);
        }
    }
}

static inline void trace_megasas_dcmd_invalid_sge(int cmd, int count)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_INVALID_SGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_invalid_sge " "scmd %d: DCMD sge count %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, count);
        }
    }
}

static inline void trace_megasas_dcmd_invalid_xfer_len(int cmd, unsigned long size, unsigned long max)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_INVALID_XFER_LEN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_invalid_xfer_len " "scmd %d: xfer len %ld, max %ld" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, size, max);
        }
    }
}

static inline void trace_megasas_dcmd_enter(int cmd, const char * dcmd, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_ENTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_enter " "scmd %d: DCMD %s len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, dcmd, len);
        }
    }
}

static inline void trace_megasas_dcmd_dummy(int cmd, unsigned long size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_DUMMY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_dummy " "scmd %d: xfer len %ld" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, size);
        }
    }
}

static inline void trace_megasas_dcmd_set_fw_time(int cmd, unsigned long time)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_SET_FW_TIME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_set_fw_time " "scmd %d: Set FW time %lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, time);
        }
    }
}

static inline void trace_megasas_dcmd_pd_get_list(int cmd, int num, int max, int offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_PD_GET_LIST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_pd_get_list " "scmd %d: DCMD PD get list: %d / %d PDs, size %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, num, max, offset);
        }
    }
}

static inline void trace_megasas_dcmd_ld_get_list(int cmd, int num, int max)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_LD_GET_LIST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_ld_get_list " "scmd %d: DCMD LD get list: found %d / %d LDs" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, num, max);
        }
    }
}

static inline void trace_megasas_dcmd_ld_get_info(int cmd, int ld_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_LD_GET_INFO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_ld_get_info " "scmd %d: dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, ld_id);
        }
    }
}

static inline void trace_megasas_dcmd_ld_list_query(int cmd, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_LD_LIST_QUERY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_ld_list_query " "scmd %d: query flags %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, flags);
        }
    }
}

static inline void trace_megasas_dcmd_pd_get_info(int cmd, int pd_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_PD_GET_INFO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_pd_get_info " "scmd %d: dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, pd_id);
        }
    }
}

static inline void trace_megasas_dcmd_pd_list_query(int cmd, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_PD_LIST_QUERY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_pd_list_query " "scmd %d: query flags %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, flags);
        }
    }
}

static inline void trace_megasas_dcmd_reset_ld(int cmd, int target_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_RESET_LD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_reset_ld " "scmd %d: dev %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, target_id);
        }
    }
}

static inline void trace_megasas_dcmd_unsupported(int cmd, unsigned long size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_DCMD_UNSUPPORTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_dcmd_unsupported " "scmd %d: set properties len %ld" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, size);
        }
    }
}

static inline void trace_megasas_abort_frame(int cmd, int abort_cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_ABORT_FRAME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_abort_frame " "scmd %d: frame %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, abort_cmd);
        }
    }
}

static inline void trace_megasas_abort_no_cmd(int cmd, uint64_t context)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_ABORT_NO_CMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_abort_no_cmd " "scmd %d: no active command for frame context %" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, context);
        }
    }
}

static inline void trace_megasas_abort_invalid_context(int cmd, uint64_t context, int abort_cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_ABORT_INVALID_CONTEXT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_abort_invalid_context " "scmd %d: invalid frame context %" PRIx64 " for abort frame %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, context, abort_cmd);
        }
    }
}

static inline void trace_megasas_reset(int fw_state)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_reset " "firmware state %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fw_state);
        }
    }
}

static inline void trace_megasas_init(int sges, int cmds, const char * mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_INIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_init " "Using %d sges, %d cmds, %s mode" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , sges, cmds, mode);
        }
    }
}

static inline void trace_megasas_msix_raise(int vector)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_MSIX_RAISE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_msix_raise " "vector %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vector);
        }
    }
}

static inline void trace_megasas_msi_raise(int vector)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_MSI_RAISE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_msi_raise " "vector %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vector);
        }
    }
}

static inline void trace_megasas_irq_lower(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IRQ_LOWER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_irq_lower " "INTx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_megasas_irq_raise(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_IRQ_RAISE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_irq_raise " "INTx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_megasas_intr_enabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_INTR_ENABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_intr_enabled " "Interrupts enabled" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_megasas_intr_disabled(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_INTR_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_intr_disabled " "Interrupts disabled" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_megasas_msix_enabled(int vector)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_MSIX_ENABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_msix_enabled " "vector %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vector);
        }
    }
}

static inline void trace_megasas_msi_enabled(int vector)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_MSI_ENABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_msi_enabled " "vector %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , vector);
        }
    }
}

static inline void trace_megasas_mmio_readl(const char * reg, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_MMIO_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_mmio_readl " "reg %s: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg, val);
        }
    }
}

static inline void trace_megasas_mmio_invalid_readl(unsigned long addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_MMIO_INVALID_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_mmio_invalid_readl " "addr 0x%lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_megasas_mmio_writel(const char * reg, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_MMIO_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_mmio_writel " "reg %s: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg, val);
        }
    }
}

static inline void trace_megasas_mmio_invalid_writel(uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_MEGASAS_MMIO_INVALID_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:megasas_mmio_invalid_writel " "addr 0x%x: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_pvscsi_ring_init_data(uint32_t txr_len_log2, uint32_t rxr_len_log2)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_RING_INIT_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_ring_init_data " "TX/RX rings logarithms set to %d/%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , txr_len_log2, rxr_len_log2);
        }
    }
}

static inline void trace_pvscsi_ring_init_msg(uint32_t len_log2)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_RING_INIT_MSG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_ring_init_msg " "MSG ring logarithm set to %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , len_log2);
        }
    }
}

static inline void trace_pvscsi_ring_flush_cmp(uint64_t filled_cmp_ptr)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_RING_FLUSH_CMP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_ring_flush_cmp " "new production counter of completion ring is 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , filled_cmp_ptr);
        }
    }
}

static inline void trace_pvscsi_ring_flush_msg(uint64_t filled_cmp_ptr)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_RING_FLUSH_MSG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_ring_flush_msg " "new production counter of message ring is 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , filled_cmp_ptr);
        }
    }
}

static inline void trace_pvscsi_update_irq_level(bool raise, uint64_t mask, uint64_t status)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_UPDATE_IRQ_LEVEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_update_irq_level " "interrupt level set to %d (MASK: 0x%"PRIx64", STATUS: 0x%"PRIx64")" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , raise, mask, status);
        }
    }
}

static inline void trace_pvscsi_update_irq_msi(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_UPDATE_IRQ_MSI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_update_irq_msi " "sending MSI notification" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_pvscsi_cmp_ring_put(unsigned long addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_CMP_RING_PUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_cmp_ring_put " "got completion descriptor 0x%lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_pvscsi_msg_ring_put(unsigned long addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_MSG_RING_PUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_msg_ring_put " "got message descriptor 0x%lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_pvscsi_complete_request(uint64_t context, uint64_t len, uint8_t sense_key)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_COMPLETE_REQUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_complete_request " "completion: ctx: 0x%"PRIx64", len: 0x%"PRIx64", sense key: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , context, len, sense_key);
        }
    }
}

static inline void trace_pvscsi_get_sg_list(int nsg, size_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_GET_SG_LIST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_get_sg_list " "get SG list: depth: %u, size: %zu" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nsg, size);
        }
    }
}

static inline void trace_pvscsi_get_next_sg_elem(uint32_t flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_GET_NEXT_SG_ELEM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_get_next_sg_elem " "unknown flags in SG element (val: 0x%x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , flags);
        }
    }
}

static inline void trace_pvscsi_command_complete_not_found(uint32_t tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_COMMAND_COMPLETE_NOT_FOUND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_command_complete_not_found " "can't find request for tag 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag);
        }
    }
}

static inline void trace_pvscsi_command_complete_data_run(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_COMMAND_COMPLETE_DATA_RUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_command_complete_data_run " "not all data required for command transferred" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_pvscsi_command_complete_sense_len(int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_COMMAND_COMPLETE_SENSE_LEN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_command_complete_sense_len " "sense information length is %d bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , len);
        }
    }
}

static inline void trace_pvscsi_convert_sglist(uint64_t context, unsigned long addr, uint32_t resid)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_CONVERT_SGLIST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_convert_sglist " "element: ctx: 0x%"PRIx64" addr: 0x%lx, len: %ul" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , context, addr, resid);
        }
    }
}

static inline void trace_pvscsi_process_req_descr(uint8_t cmd, uint64_t ctx)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_PROCESS_REQ_DESCR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_process_req_descr " "SCSI cmd 0x%x, ctx: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, ctx);
        }
    }
}

static inline void trace_pvscsi_process_req_descr_unknown_device(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_PROCESS_REQ_DESCR_UNKNOWN_DEVICE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_process_req_descr_unknown_device " "command directed to unknown device rejected" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_pvscsi_process_req_descr_invalid_dir(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_PROCESS_REQ_DESCR_INVALID_DIR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_process_req_descr_invalid_dir " "command with invalid transfer direction rejected" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_pvscsi_process_io(unsigned long addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_PROCESS_IO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_process_io " "got descriptor 0x%lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_pvscsi_on_cmd_noimpl(const char* cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_ON_CMD_NOIMPL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_on_cmd_noimpl " "unimplemented command %s ignored" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd);
        }
    }
}

static inline void trace_pvscsi_on_cmd_reset_dev(uint32_t tgt, int lun, void* dev)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_ON_CMD_RESET_DEV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_on_cmd_reset_dev " "PVSCSI_CMD_RESET_DEVICE[target %u lun %d (dev 0x%p)]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tgt, lun, dev);
        }
    }
}

static inline void trace_pvscsi_on_cmd_arrived(const char* cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_ON_CMD_ARRIVED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_on_cmd_arrived " "command %s arrived" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd);
        }
    }
}

static inline void trace_pvscsi_on_cmd_abort(uint64_t ctx, uint32_t tgt)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_ON_CMD_ABORT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_on_cmd_abort " "command PVSCSI_CMD_ABORT_CMD for ctx 0x%"PRIx64", target %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ctx, tgt);
        }
    }
}

static inline void trace_pvscsi_on_cmd_unknown(uint64_t cmd_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_ON_CMD_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_on_cmd_unknown " "unknown command %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd_id);
        }
    }
}

static inline void trace_pvscsi_on_cmd_unknown_data(uint32_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_ON_CMD_UNKNOWN_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_on_cmd_unknown_data " "data for unknown command 0x:%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , data);
        }
    }
}

static inline void trace_pvscsi_io_write(const char* cmd, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_IO_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_io_write " "%s write: %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, val);
        }
    }
}

static inline void trace_pvscsi_io_write_unknown(unsigned long addr, unsigned sz, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_IO_WRITE_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_io_write_unknown " "unknown write address: 0x%lx size: %u bytes value: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, sz, val);
        }
    }
}

static inline void trace_pvscsi_io_read(const char* cmd, uint64_t status)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_IO_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_io_read " "%s read: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, status);
        }
    }
}

static inline void trace_pvscsi_io_read_unknown(unsigned long addr, unsigned sz)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_IO_READ_UNKNOWN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_io_read_unknown " "unknown read address: 0x%lx size: %u bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, sz);
        }
    }
}

static inline void trace_pvscsi_init_msi_fail(int res)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_INIT_MSI_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_init_msi_fail " "failed to initialize MSI, error %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res);
        }
    }
}

static inline void trace_pvscsi_state(const char* state)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_state " "starting %s ..." "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , state);
        }
    }
}

static inline void trace_pvscsi_tx_rings_ppn(const char* label, uint64_t ppn)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_TX_RINGS_PPN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_tx_rings_ppn " "%s page: %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , label, ppn);
        }
    }
}

static inline void trace_pvscsi_tx_rings_num_pages(const char* label, uint32_t num)
{
    if (true) {
        if (trace_event_get_state(TRACE_PVSCSI_TX_RINGS_NUM_PAGES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pvscsi_tx_rings_num_pages " "Number of %s pages: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , label, num);
        }
    }
}

static inline void trace_esp_error_fifo_overrun(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_ERROR_FIFO_OVERRUN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_error_fifo_overrun " "FIFO overrun" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_esp_error_unhandled_command(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_ERROR_UNHANDLED_COMMAND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_error_unhandled_command " "unhandled command (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_error_invalid_write(uint32_t val, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_ERROR_INVALID_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_error_invalid_write " "invalid write of 0x%02x at [0x%x]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val, addr);
        }
    }
}

static inline void trace_esp_raise_irq(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_RAISE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_raise_irq " "Raise IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_esp_lower_irq(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_LOWER_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_lower_irq " "Lower IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_esp_dma_enable(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_DMA_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_dma_enable " "Raise enable" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_esp_dma_disable(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_DMA_DISABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_dma_disable " "Lower enable" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_esp_get_cmd(uint32_t dmalen, int target)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_GET_CMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_get_cmd " "len %d target %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dmalen, target);
        }
    }
}

static inline void trace_esp_do_busid_cmd(uint8_t busid)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_DO_BUSID_CMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_do_busid_cmd " "busid 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , busid);
        }
    }
}

static inline void trace_esp_handle_satn_stop(uint32_t cmdlen)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_HANDLE_SATN_STOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_handle_satn_stop " "cmdlen %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmdlen);
        }
    }
}

static inline void trace_esp_write_response(uint32_t status)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_WRITE_RESPONSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_write_response " "Transfer status (status=%d)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , status);
        }
    }
}

static inline void trace_esp_do_dma(uint32_t cmdlen, uint32_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_DO_DMA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_do_dma " "command len %d + %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmdlen, len);
        }
    }
}

static inline void trace_esp_command_complete(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_COMMAND_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_command_complete " "SCSI Command complete" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_esp_command_complete_unexpected(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_COMMAND_COMPLETE_UNEXPECTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_command_complete_unexpected " "SCSI command completed unexpectedly" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_esp_command_complete_fail(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_COMMAND_COMPLETE_FAIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_command_complete_fail " "Command failed" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_esp_transfer_data(uint32_t dma_left, int32_t ti_size)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_TRANSFER_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_transfer_data " "transfer %d/%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dma_left, ti_size);
        }
    }
}

static inline void trace_esp_handle_ti(uint32_t minlen)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_HANDLE_TI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_handle_ti " "Transfer Information len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , minlen);
        }
    }
}

static inline void trace_esp_handle_ti_cmd(uint32_t cmdlen)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_HANDLE_TI_CMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_handle_ti_cmd " "command len %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmdlen);
        }
    }
}

static inline void trace_esp_mem_readb(uint32_t saddr, uint8_t reg)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_readb " "reg[%d]: 0x%2.2x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , saddr, reg);
        }
    }
}

static inline void trace_esp_mem_writeb(uint32_t saddr, uint8_t reg, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb " "reg[%d]: 0x%2.2x -> 0x%2.2x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , saddr, reg, val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_nop(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_NOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_nop " "NOP (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_flush(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_flush " "Flush FIFO (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_reset(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_reset " "Chip reset (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_bus_reset(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_BUS_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_bus_reset " "Bus reset (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_iccs(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_ICCS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_iccs " "Initiator Command Complete Sequence (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_msgacc(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_MSGACC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_msgacc " "Message Accepted (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_pad(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_PAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_pad " "Transfer padding (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_satn(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_SATN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_satn " "Set ATN (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_rstatn(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_RSTATN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_rstatn " "Reset ATN (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_sel(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_SEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_sel " "Select without ATN (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_selatn(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_SELATN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_selatn " "Select with ATN (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_selatns(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_SELATNS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_selatns " "Select with ATN & stop (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_ensel(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_ENSEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_ensel " "Enable selection (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_mem_writeb_cmd_dissel(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_MEM_WRITEB_CMD_DISSEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_mem_writeb_cmd_dissel " "Disable selection (%2.2x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_pci_error_invalid_dma_direction(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_ERROR_INVALID_DMA_DIRECTION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_error_invalid_dma_direction " "invalid DMA transfer direction" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_esp_pci_error_invalid_read(uint32_t reg)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_ERROR_INVALID_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_error_invalid_read " "read access outside bounds (reg 0x%x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg);
        }
    }
}

static inline void trace_esp_pci_error_invalid_write(uint32_t reg)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_ERROR_INVALID_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_error_invalid_write " "write access outside bounds (reg 0x%x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg);
        }
    }
}

static inline void trace_esp_pci_error_invalid_write_dma(uint32_t val, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_ERROR_INVALID_WRITE_DMA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_error_invalid_write_dma " "invalid write of 0x%02x at [0x%x]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val, addr);
        }
    }
}

static inline void trace_esp_pci_dma_read(uint32_t saddr, uint32_t reg)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_DMA_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_dma_read " "reg[%d]: 0x%8.8x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , saddr, reg);
        }
    }
}

static inline void trace_esp_pci_dma_write(uint32_t saddr, uint32_t reg, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_DMA_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_dma_write " "reg[%d]: 0x%8.8x -> 0x%8.8x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , saddr, reg, val);
        }
    }
}

static inline void trace_esp_pci_dma_idle(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_DMA_IDLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_dma_idle " "IDLE (%.8x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_pci_dma_blast(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_DMA_BLAST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_dma_blast " "BLAST (%.8x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_pci_dma_abort(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_DMA_ABORT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_dma_abort " "ABORT (%.8x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_pci_dma_start(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_DMA_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_dma_start " "START (%.8x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_esp_pci_sbac_read(uint32_t reg)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_SBAC_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_sbac_read " "sbac: 0x%8.8x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg);
        }
    }
}

static inline void trace_esp_pci_sbac_write(uint32_t reg, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESP_PCI_SBAC_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:esp_pci_sbac_write " "sbac: 0x%8.8x -> 0x%8.8x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , reg, val);
        }
    }
}

static inline void trace_nvram_read(uint32_t addr, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_NVRAM_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:nvram_read " "read addr %d: 0x%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, ret);
        }
    }
}

static inline void trace_nvram_write(uint32_t addr, uint32_t old, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_NVRAM_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:nvram_write " "write addr %d: 0x%02x -> 0x%02x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, old, val);
        }
    }
}

static inline void trace_fw_cfg_select(void * s, uint16_t key, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_FW_CFG_SELECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:fw_cfg_select " "%p key %d = %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, key, ret);
        }
    }
}

static inline void trace_fw_cfg_read(void * s, uint64_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_FW_CFG_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:fw_cfg_read " "%p = %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, ret);
        }
    }
}

static inline void trace_fw_cfg_add_file(void * s, int index, char * name, size_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_FW_CFG_ADD_FILE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:fw_cfg_add_file " "%p #%d: %s (%zd bytes)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, index, name, len);
        }
    }
}

static inline void trace_jazz_led_read(uint64_t addr, uint8_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_JAZZ_LED_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:jazz_led_read " "read addr=0x%"PRIx64": 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_jazz_led_write(uint64_t addr, uint8_t new)
{
    if (true) {
        if (trace_event_get_state(TRACE_JAZZ_LED_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:jazz_led_write " "write addr=0x%"PRIx64": 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, new);
        }
    }
}

static inline void trace_xenfb_mouse_event(void * opaque, int dx, int dy, int dz, int button_state, int abs_pointer_wanted)
{
    if (true) {
        if (trace_event_get_state(TRACE_XENFB_MOUSE_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xenfb_mouse_event " "%p x %d y %d z %d bs %#x abs %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, dx, dy, dz, button_state, abs_pointer_wanted);
        }
    }
}

static inline void trace_xenfb_input_connected(void * xendev, int abs_pointer_wanted)
{
    if (true) {
        if (trace_event_get_state(TRACE_XENFB_INPUT_CONNECTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xenfb_input_connected " "%p abs %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , xendev, abs_pointer_wanted);
        }
    }
}

static inline void trace_g364fb_read(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_G364FB_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:g364fb_read " "read addr=0x%"PRIx64": 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_g364fb_write(uint64_t addr, uint32_t new)
{
    if (true) {
        if (trace_event_get_state(TRACE_G364FB_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:g364fb_write " "write addr=0x%"PRIx64": 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, new);
        }
    }
}

static inline void trace_milkymist_tmu2_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_TMU2_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_tmu2_memory_read " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_tmu2_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_TMU2_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_tmu2_memory_write " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_tmu2_start(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_TMU2_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_tmu2_start " "Start TMU" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_tmu2_pulse_irq(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_TMU2_PULSE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_tmu2_pulse_irq " "Pulse IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_vgafb_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_VGAFB_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_vgafb_memory_read " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_vgafb_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_VGAFB_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_vgafb_memory_write " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_vmware_value_read(uint32_t index, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMWARE_VALUE_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmware_value_read " "index %d, value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, value);
        }
    }
}

static inline void trace_vmware_value_write(uint32_t index, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMWARE_VALUE_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmware_value_write " "index %d, value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, value);
        }
    }
}

static inline void trace_vmware_palette_read(uint32_t index, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMWARE_PALETTE_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmware_palette_read " "index %d, value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, value);
        }
    }
}

static inline void trace_vmware_palette_write(uint32_t index, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMWARE_PALETTE_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmware_palette_write " "index %d, value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, value);
        }
    }
}

static inline void trace_vmware_scratch_read(uint32_t index, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMWARE_SCRATCH_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmware_scratch_read " "index %d, value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, value);
        }
    }
}

static inline void trace_vmware_scratch_write(uint32_t index, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMWARE_SCRATCH_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmware_scratch_write " "index %d, value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, value);
        }
    }
}

static inline void trace_vmware_setmode(uint32_t w, uint32_t h, uint32_t bpp)
{
    if (true) {
        if (trace_event_get_state(TRACE_VMWARE_SETMODE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vmware_setmode " "%dx%d @ %d bpp" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , w, h, bpp);
        }
    }
}

static inline void trace_virtio_gpu_features(bool virgl)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_FEATURES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_features " "virgl %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , virgl);
        }
    }
}

static inline void trace_virtio_gpu_cmd_get_display_info(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_GET_DISPLAY_INFO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_get_display_info " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_virtio_gpu_cmd_get_caps(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_GET_CAPS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_get_caps " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_virtio_gpu_cmd_set_scanout(uint32_t id, uint32_t res, uint32_t w, uint32_t h, uint32_t x, uint32_t y)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_SET_SCANOUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_set_scanout " "id %d, res 0x%x, w %d, h %d, x %d, y %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, res, w, h, x, y);
        }
    }
}

static inline void trace_virtio_gpu_cmd_res_create_2d(uint32_t res, uint32_t fmt, uint32_t w, uint32_t h)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_RES_CREATE_2D)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_res_create_2d " "res 0x%x, fmt 0x%x, w %d, h %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res, fmt, w, h);
        }
    }
}

static inline void trace_virtio_gpu_cmd_res_create_3d(uint32_t res, uint32_t fmt, uint32_t w, uint32_t h, uint32_t d)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_RES_CREATE_3D)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_res_create_3d " "res 0x%x, fmt 0x%x, w %d, h %d, d %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res, fmt, w, h, d);
        }
    }
}

static inline void trace_virtio_gpu_cmd_res_unref(uint32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_RES_UNREF)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_res_unref " "res 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res);
        }
    }
}

static inline void trace_virtio_gpu_cmd_res_back_attach(uint32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_RES_BACK_ATTACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_res_back_attach " "res 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res);
        }
    }
}

static inline void trace_virtio_gpu_cmd_res_back_detach(uint32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_RES_BACK_DETACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_res_back_detach " "res 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res);
        }
    }
}

static inline void trace_virtio_gpu_cmd_res_xfer_toh_2d(uint32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_RES_XFER_TOH_2D)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_res_xfer_toh_2d " "res 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res);
        }
    }
}

static inline void trace_virtio_gpu_cmd_res_xfer_toh_3d(uint32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_RES_XFER_TOH_3D)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_res_xfer_toh_3d " "res 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res);
        }
    }
}

static inline void trace_virtio_gpu_cmd_res_xfer_fromh_3d(uint32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_RES_XFER_FROMH_3D)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_res_xfer_fromh_3d " "res 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res);
        }
    }
}

static inline void trace_virtio_gpu_cmd_res_flush(uint32_t res, uint32_t w, uint32_t h, uint32_t x, uint32_t y)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_RES_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_res_flush " "res 0x%x, w %d, h %d, x %d, y %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , res, w, h, x, y);
        }
    }
}

static inline void trace_virtio_gpu_cmd_ctx_create(uint32_t ctx, const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_CTX_CREATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_ctx_create " "ctx 0x%x, name %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ctx, name);
        }
    }
}

static inline void trace_virtio_gpu_cmd_ctx_destroy(uint32_t ctx)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_CTX_DESTROY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_ctx_destroy " "ctx 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ctx);
        }
    }
}

static inline void trace_virtio_gpu_cmd_ctx_res_attach(uint32_t ctx, uint32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_CTX_RES_ATTACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_ctx_res_attach " "ctx 0x%x, res 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ctx, res);
        }
    }
}

static inline void trace_virtio_gpu_cmd_ctx_res_detach(uint32_t ctx, uint32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_CTX_RES_DETACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_ctx_res_detach " "ctx 0x%x, res 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ctx, res);
        }
    }
}

static inline void trace_virtio_gpu_cmd_ctx_submit(uint32_t ctx, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_CMD_CTX_SUBMIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_cmd_ctx_submit " "ctx 0x%x, size %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ctx, size);
        }
    }
}

static inline void trace_virtio_gpu_update_cursor(uint32_t scanout, uint32_t x, uint32_t y, const char * type, uint32_t res)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_UPDATE_CURSOR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_update_cursor " "scanout %d, x %d, y %d, %s, res 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , scanout, x, y, type, res);
        }
    }
}

static inline void trace_virtio_gpu_fence_ctrl(uint64_t fence, uint32_t type)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_FENCE_CTRL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_fence_ctrl " "fence 0x%" PRIx64 ", type 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fence, type);
        }
    }
}

static inline void trace_virtio_gpu_fence_resp(uint64_t fence)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_GPU_FENCE_RESP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_gpu_fence_resp " "fence 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fence);
        }
    }
}

static inline void trace_qxl_interface_set_mm_time(int qid, uint32_t mm_time)
{
    if (true) {
    }
}

static inline void trace_qxl_io_write_vga(int qid, const char * mode, uint32_t addr, uint32_t val)
{
    if (true) {
    }
}

static inline void trace_qxl_create_guest_primary(int qid, uint32_t width, uint32_t height, uint64_t mem, uint32_t format, uint32_t position)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_CREATE_GUEST_PRIMARY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_create_guest_primary " "%d %ux%u mem=%" PRIx64 " %u,%u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, width, height, mem, format, position);
        }
    }
}

static inline void trace_qxl_create_guest_primary_rest(int qid, int32_t stride, uint32_t type, uint32_t flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_CREATE_GUEST_PRIMARY_REST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_create_guest_primary_rest " "%d %d,%d,%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, stride, type, flags);
        }
    }
}

static inline void trace_qxl_destroy_primary(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_DESTROY_PRIMARY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_destroy_primary " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_enter_vga_mode(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_ENTER_VGA_MODE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_enter_vga_mode " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_exit_vga_mode(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_EXIT_VGA_MODE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_exit_vga_mode " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_hard_reset(int qid, int64_t loadvm)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_HARD_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_hard_reset " "%d loadvm=%"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, loadvm);
        }
    }
}

static inline void trace_qxl_interface_async_complete_io(int qid, uint32_t current_async, void * cookie)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_INTERFACE_ASYNC_COMPLETE_IO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_interface_async_complete_io " "%d current=%d cookie=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, current_async, cookie);
        }
    }
}

static inline void trace_qxl_interface_attach_worker(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_INTERFACE_ATTACH_WORKER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_interface_attach_worker " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_interface_get_init_info(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_INTERFACE_GET_INIT_INFO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_interface_get_init_info " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_interface_set_compression_level(int qid, int64_t level)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_INTERFACE_SET_COMPRESSION_LEVEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_interface_set_compression_level " "%d %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, level);
        }
    }
}

static inline void trace_qxl_interface_update_area_complete(int qid, uint32_t surface_id, uint32_t dirty_left, uint32_t dirty_right, uint32_t dirty_top, uint32_t dirty_bottom)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_INTERFACE_UPDATE_AREA_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_interface_update_area_complete " "%d surface=%d [%d,%d,%d,%d]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, surface_id, dirty_left, dirty_right, dirty_top, dirty_bottom);
        }
    }
}

static inline void trace_qxl_interface_update_area_complete_rest(int qid, uint32_t num_updated_rects)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_INTERFACE_UPDATE_AREA_COMPLETE_REST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_interface_update_area_complete_rest " "%d #=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, num_updated_rects);
        }
    }
}

static inline void trace_qxl_interface_update_area_complete_overflow(int qid, int max)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_INTERFACE_UPDATE_AREA_COMPLETE_OVERFLOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_interface_update_area_complete_overflow " "%d max=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, max);
        }
    }
}

static inline void trace_qxl_interface_update_area_complete_schedule_bh(int qid, uint32_t num_dirty)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_INTERFACE_UPDATE_AREA_COMPLETE_SCHEDULE_BH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_interface_update_area_complete_schedule_bh " "%d #dirty=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, num_dirty);
        }
    }
}

static inline void trace_qxl_io_destroy_primary_ignored(int qid, const char * mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_IO_DESTROY_PRIMARY_IGNORED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_io_destroy_primary_ignored " "%d %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, mode);
        }
    }
}

static inline void trace_qxl_io_log(int qid, const uint8_t * log_buf)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_IO_LOG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_io_log " "%d %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, log_buf);
        }
    }
}

static inline void trace_qxl_io_read_unexpected(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_IO_READ_UNEXPECTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_io_read_unexpected " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_io_unexpected_vga_mode(int qid, uint64_t addr, uint64_t val, const char * desc)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_IO_UNEXPECTED_VGA_MODE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_io_unexpected_vga_mode " "%d 0x%"PRIx64"=%"PRIu64" (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, addr, val, desc);
        }
    }
}

static inline void trace_qxl_io_write(int qid, const char * mode, uint64_t addr, const char * aname, uint64_t val, unsigned size, int async)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_IO_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_io_write " "%d %s addr=%"PRIu64 " (%s) val=%"PRIu64" size=%u async=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, mode, addr, aname, val, size, async);
        }
    }
}

static inline void trace_qxl_memslot_add_guest(int qid, uint32_t slot_id, uint64_t guest_start, uint64_t guest_end)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_MEMSLOT_ADD_GUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_memslot_add_guest " "%d %u: guest phys 0x%"PRIx64 " - 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, slot_id, guest_start, guest_end);
        }
    }
}

static inline void trace_qxl_post_load(int qid, const char * mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_POST_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_post_load " "%d %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, mode);
        }
    }
}

static inline void trace_qxl_pre_load(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_PRE_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_pre_load " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_pre_save(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_PRE_SAVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_pre_save " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_reset_surfaces(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RESET_SURFACES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_reset_surfaces " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_ring_command_check(int qid, const char * mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RING_COMMAND_CHECK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_ring_command_check " "%d %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, mode);
        }
    }
}

static inline void trace_qxl_ring_command_get(int qid, const char * mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RING_COMMAND_GET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_ring_command_get " "%d %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, mode);
        }
    }
}

static inline void trace_qxl_ring_command_req_notification(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RING_COMMAND_REQ_NOTIFICATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_ring_command_req_notification " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_ring_cursor_check(int qid, const char * mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RING_CURSOR_CHECK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_ring_cursor_check " "%d %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, mode);
        }
    }
}

static inline void trace_qxl_ring_cursor_get(int qid, const char * mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RING_CURSOR_GET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_ring_cursor_get " "%d %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, mode);
        }
    }
}

static inline void trace_qxl_ring_cursor_req_notification(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RING_CURSOR_REQ_NOTIFICATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_ring_cursor_req_notification " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_ring_res_push(int qid, const char * mode, uint32_t surface_count, uint32_t free_res, void * last_release, const char * notify)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RING_RES_PUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_ring_res_push " "%d %s s#=%d res#=%d last=%p notify=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, mode, surface_count, free_res, last_release, notify);
        }
    }
}

static inline void trace_qxl_ring_res_push_rest(int qid, uint32_t ring_has, uint32_t ring_size, uint32_t prod, uint32_t cons)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RING_RES_PUSH_REST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_ring_res_push_rest " "%d ring %d/%d [%d,%d]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, ring_has, ring_size, prod, cons);
        }
    }
}

static inline void trace_qxl_ring_res_put(int qid, uint32_t free_res)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RING_RES_PUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_ring_res_put " "%d #res=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, free_res);
        }
    }
}

static inline void trace_qxl_set_mode(int qid, int modenr, uint32_t x_res, uint32_t y_res, uint32_t bits, uint64_t devmem)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SET_MODE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_set_mode " "%d mode=%d [ x=%d y=%d @ bpp=%d devmem=0x%" PRIx64 " ]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, modenr, x_res, y_res, bits, devmem);
        }
    }
}

static inline void trace_qxl_soft_reset(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SOFT_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_soft_reset " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_spice_destroy_surfaces_complete(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_DESTROY_SURFACES_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_destroy_surfaces_complete " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_spice_destroy_surfaces(int qid, int async)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_DESTROY_SURFACES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_destroy_surfaces " "%d async=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, async);
        }
    }
}

static inline void trace_qxl_spice_destroy_surface_wait_complete(int qid, uint32_t id)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_DESTROY_SURFACE_WAIT_COMPLETE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_destroy_surface_wait_complete " "%d sid=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, id);
        }
    }
}

static inline void trace_qxl_spice_destroy_surface_wait(int qid, uint32_t id, int async)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_DESTROY_SURFACE_WAIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_destroy_surface_wait " "%d sid=%d async=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, id, async);
        }
    }
}

static inline void trace_qxl_spice_flush_surfaces_async(int qid, uint32_t surface_count, uint32_t num_free_res)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_FLUSH_SURFACES_ASYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_flush_surfaces_async " "%d s#=%d, res#=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, surface_count, num_free_res);
        }
    }
}

static inline void trace_qxl_spice_monitors_config(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_MONITORS_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_monitors_config " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_spice_loadvm_commands(int qid, void * ext, uint32_t count)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_LOADVM_COMMANDS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_loadvm_commands " "%d ext=%p count=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, ext, count);
        }
    }
}

static inline void trace_qxl_spice_oom(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_OOM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_oom " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_spice_reset_cursor(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_RESET_CURSOR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_reset_cursor " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_spice_reset_image_cache(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_RESET_IMAGE_CACHE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_reset_image_cache " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_spice_reset_memslots(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_RESET_MEMSLOTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_reset_memslots " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_spice_update_area(int qid, uint32_t surface_id, uint32_t left, uint32_t right, uint32_t top, uint32_t bottom)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_UPDATE_AREA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_update_area " "%d sid=%d [%d,%d,%d,%d]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, surface_id, left, right, top, bottom);
        }
    }
}

static inline void trace_qxl_spice_update_area_rest(int qid, uint32_t num_dirty_rects, uint32_t clear_dirty_region)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SPICE_UPDATE_AREA_REST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_spice_update_area_rest " "%d #d=%d clear=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, num_dirty_rects, clear_dirty_region);
        }
    }
}

static inline void trace_qxl_surfaces_dirty(int qid, uint64_t offset, uint64_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SURFACES_DIRTY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_surfaces_dirty " "%d offset=0x%"PRIx64" size=0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, offset, size);
        }
    }
}

static inline void trace_qxl_send_events(int qid, uint32_t events)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SEND_EVENTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_send_events " "%d %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, events);
        }
    }
}

static inline void trace_qxl_send_events_vm_stopped(int qid, uint32_t events)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SEND_EVENTS_VM_STOPPED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_send_events_vm_stopped " "%d %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, events);
        }
    }
}

static inline void trace_qxl_set_guest_bug(int qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SET_GUEST_BUG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_set_guest_bug " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qxl_interrupt_client_monitors_config(int qid, int num_heads, void * heads)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_INTERRUPT_CLIENT_MONITORS_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_interrupt_client_monitors_config " "%d %d %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, num_heads, heads);
        }
    }
}

static inline void trace_qxl_client_monitors_config_unsupported_by_guest(int qid, uint32_t int_mask, void * client_monitors_config)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_CLIENT_MONITORS_CONFIG_UNSUPPORTED_BY_GUEST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_client_monitors_config_unsupported_by_guest " "%d %X %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, int_mask, client_monitors_config);
        }
    }
}

static inline void trace_qxl_client_monitors_config_unsupported_by_device(int qid, int revision)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_CLIENT_MONITORS_CONFIG_UNSUPPORTED_BY_DEVICE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_client_monitors_config_unsupported_by_device " "%d revision=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, revision);
        }
    }
}

static inline void trace_qxl_client_monitors_config_capped(int qid, int requested, int limit)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_CLIENT_MONITORS_CONFIG_CAPPED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_client_monitors_config_capped " "%d %d %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, requested, limit);
        }
    }
}

static inline void trace_qxl_client_monitors_config_crc(int qid, unsigned size, uint32_t crc32)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_CLIENT_MONITORS_CONFIG_CRC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_client_monitors_config_crc " "%d %u %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, size, crc32);
        }
    }
}

static inline void trace_qxl_set_client_capabilities_unsupported_by_revision(int qid, int revision)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_SET_CLIENT_CAPABILITIES_UNSUPPORTED_BY_REVISION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_set_client_capabilities_unsupported_by_revision " "%d revision=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, revision);
        }
    }
}

static inline void trace_qxl_render_blit(int32_t stride, int32_t left, int32_t right, int32_t top, int32_t bottom)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RENDER_BLIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_render_blit " "stride=%d [%d, %d, %d, %d]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , stride, left, right, top, bottom);
        }
    }
}

static inline void trace_qxl_render_guest_primary_resized(int32_t width, int32_t height, int32_t stride, int32_t bytes_pp, int32_t bits_pp)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RENDER_GUEST_PRIMARY_RESIZED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_render_guest_primary_resized " "%dx%d, stride %d, bpp %d, depth %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , width, height, stride, bytes_pp, bits_pp);
        }
    }
}

static inline void trace_qxl_render_update_area_done(void * cookie)
{
    if (true) {
        if (trace_event_get_state(TRACE_QXL_RENDER_UPDATE_AREA_DONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qxl_render_update_area_done " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cookie);
        }
    }
}

static inline void trace_ps2_put_keycode(void * opaque, int keycode)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_PUT_KEYCODE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_put_keycode " "%p keycode %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, keycode);
        }
    }
}

static inline void trace_ps2_read_data(void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_READ_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_read_data " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque);
        }
    }
}

static inline void trace_ps2_set_ledstate(void * s, int ledstate)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_SET_LEDSTATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_set_ledstate " "%p ledstate %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, ledstate);
        }
    }
}

static inline void trace_ps2_reset_keyboard(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_RESET_KEYBOARD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_reset_keyboard " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_ps2_write_keyboard(void * opaque, int val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_WRITE_KEYBOARD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_write_keyboard " "%p val %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, val);
        }
    }
}

static inline void trace_ps2_keyboard_set_translation(void * opaque, int mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_KEYBOARD_SET_TRANSLATION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_keyboard_set_translation " "%p mode %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, mode);
        }
    }
}

static inline void trace_ps2_mouse_send_packet(void * s, int dx1, int dy1, int dz1, int b)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_MOUSE_SEND_PACKET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_mouse_send_packet " "%p x %d y %d z %d bs %#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s, dx1, dy1, dz1, b);
        }
    }
}

static inline void trace_ps2_mouse_event_disabled(void * opaque, int dx, int dy, int dz, int buttons_state, int mouse_dx, int mouse_dy, int mouse_dz)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_MOUSE_EVENT_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_mouse_event_disabled " "%p x %d y %d z %d bs %#x mx %d my %d mz %d " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, dx, dy, dz, buttons_state, mouse_dx, mouse_dy, mouse_dz);
        }
    }
}

static inline void trace_ps2_mouse_event(void * opaque, int dx, int dy, int dz, int buttons_state, int mouse_dx, int mouse_dy, int mouse_dz)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_MOUSE_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_mouse_event " "%p x %d y %d z %d bs %#x mx %d my %d mz %d " "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, dx, dy, dz, buttons_state, mouse_dx, mouse_dy, mouse_dz);
        }
    }
}

static inline void trace_ps2_mouse_fake_event(void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_MOUSE_FAKE_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_mouse_fake_event " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque);
        }
    }
}

static inline void trace_ps2_write_mouse(void * opaque, int val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_WRITE_MOUSE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_write_mouse " "%p val %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque, val);
        }
    }
}

static inline void trace_ps2_kbd_reset(void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_KBD_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_kbd_reset " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque);
        }
    }
}

static inline void trace_ps2_mouse_reset(void * opaque)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_MOUSE_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_mouse_reset " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , opaque);
        }
    }
}

static inline void trace_ps2_kbd_init(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_KBD_INIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_kbd_init " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_ps2_mouse_init(void * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_PS2_MOUSE_INIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ps2_mouse_init " "%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_milkymist_softusb_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SOFTUSB_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_softusb_memory_read " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_softusb_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SOFTUSB_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_softusb_memory_write " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_softusb_mevt(uint8_t m)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SOFTUSB_MEVT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_softusb_mevt " "m %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , m);
        }
    }
}

static inline void trace_milkymist_softusb_kevt(uint8_t m)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SOFTUSB_KEVT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_softusb_kevt " "m %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , m);
        }
    }
}

static inline void trace_milkymist_softusb_pulse_irq(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SOFTUSB_PULSE_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_softusb_pulse_irq " "Pulse IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_hid_kbd_queue_full(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_HID_KBD_QUEUE_FULL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:hid_kbd_queue_full " "queue full" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_virtio_input_queue_full(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_INPUT_QUEUE_FULL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_input_queue_full " "queue full" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_slavio_timer_get_out(uint64_t limit, uint32_t counthigh, uint32_t count)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_GET_OUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_get_out " "limit %"PRIx64" count %x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , limit, counthigh, count);
        }
    }
}

static inline void trace_slavio_timer_irq(uint32_t counthigh, uint32_t count)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_irq " "callback: count %x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , counthigh, count);
        }
    }
}

static inline void trace_slavio_timer_mem_readl_invalid(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_READL_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_readl_invalid " "invalid read address %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_slavio_timer_mem_readl(uint64_t addr, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_readl " "read %"PRIx64" = %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, ret);
        }
    }
}

static inline void trace_slavio_timer_mem_writel(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_writel " "write %"PRIx64" = %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_slavio_timer_mem_writel_limit(unsigned int timer_index, uint64_t count)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_WRITEL_LIMIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_writel_limit " "processor %d user timer set to %016"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , timer_index, count);
        }
    }
}

static inline void trace_slavio_timer_mem_writel_counter_invalid(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_WRITEL_COUNTER_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_writel_counter_invalid " "not user timer" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_slavio_timer_mem_writel_status_start(unsigned int timer_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_WRITEL_STATUS_START)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_writel_status_start " "processor %d user timer started" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , timer_index);
        }
    }
}

static inline void trace_slavio_timer_mem_writel_status_stop(unsigned int timer_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_WRITEL_STATUS_STOP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_writel_status_stop " "processor %d user timer stopped" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , timer_index);
        }
    }
}

static inline void trace_slavio_timer_mem_writel_mode_user(unsigned int timer_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_WRITEL_MODE_USER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_writel_mode_user " "processor %d changed from counter to user timer" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , timer_index);
        }
    }
}

static inline void trace_slavio_timer_mem_writel_mode_counter(unsigned int timer_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_WRITEL_MODE_COUNTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_writel_mode_counter " "processor %d changed from user timer to counter" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , timer_index);
        }
    }
}

static inline void trace_slavio_timer_mem_writel_mode_invalid(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_WRITEL_MODE_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_writel_mode_invalid " "not system timer" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_slavio_timer_mem_writel_invalid(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_SLAVIO_TIMER_MEM_WRITEL_INVALID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:slavio_timer_mem_writel_invalid " "invalid write address %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_grlib_gptimer_enable(int id, uint32_t count)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_GPTIMER_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_gptimer_enable " "timer:%d set count 0x%x and run" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, count);
        }
    }
}

static inline void trace_grlib_gptimer_disabled(int id, uint32_t config)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_GPTIMER_DISABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_gptimer_disabled " "timer:%d Timer disable config 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, config);
        }
    }
}

static inline void trace_grlib_gptimer_restart(int id, uint32_t reload)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_GPTIMER_RESTART)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_gptimer_restart " "timer:%d reload val: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, reload);
        }
    }
}

static inline void trace_grlib_gptimer_set_scaler(uint32_t scaler, uint32_t freq)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_GPTIMER_SET_SCALER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_gptimer_set_scaler " "scaler:0x%x freq: 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , scaler, freq);
        }
    }
}

static inline void trace_grlib_gptimer_hit(int id)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_GPTIMER_HIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_gptimer_hit " "timer:%d HIT" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id);
        }
    }
}

static inline void trace_grlib_gptimer_readl(int id, uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_GPTIMER_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_gptimer_readl " "timer:%d addr 0x%"PRIx64" 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, addr, val);
        }
    }
}

static inline void trace_grlib_gptimer_writel(int id, uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_GRLIB_GPTIMER_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:grlib_gptimer_writel " "timer:%d addr 0x%"PRIx64" 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , id, addr, val);
        }
    }
}

static inline void trace_lm32_timer_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_TIMER_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_timer_memory_write " "addr 0x%08x value 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_lm32_timer_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_TIMER_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_timer_memory_read " "addr 0x%08x value 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_lm32_timer_hit(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_TIMER_HIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_timer_hit " "timer hit" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_lm32_timer_irq_state(int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_LM32_TIMER_IRQ_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:lm32_timer_irq_state " "irq state %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , level);
        }
    }
}

static inline void trace_milkymist_sysctl_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SYSCTL_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_sysctl_memory_read " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_sysctl_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SYSCTL_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_sysctl_memory_write " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_sysctl_icap_write(uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SYSCTL_ICAP_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_sysctl_icap_write " "value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , value);
        }
    }
}

static inline void trace_milkymist_sysctl_start_timer0(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SYSCTL_START_TIMER0)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_sysctl_start_timer0 " "Start timer0" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_sysctl_stop_timer0(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SYSCTL_STOP_TIMER0)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_sysctl_stop_timer0 " "Stop timer0" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_sysctl_start_timer1(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SYSCTL_START_TIMER1)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_sysctl_start_timer1 " "Start timer1" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_sysctl_stop_timer1(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SYSCTL_STOP_TIMER1)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_sysctl_stop_timer1 " "Stop timer1" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_sysctl_pulse_irq_timer0(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SYSCTL_PULSE_IRQ_TIMER0)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_sysctl_pulse_irq_timer0 " "Pulse IRQ Timer0" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_milkymist_sysctl_pulse_irq_timer1(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_SYSCTL_PULSE_IRQ_TIMER1)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_sysctl_pulse_irq_timer1 " "Pulse IRQ Timer1" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_aspeed_timer_ctrl_enable(uint8_t i, bool enable)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_TIMER_CTRL_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_timer_ctrl_enable " "Timer %" PRIu8 ": %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , i, enable);
        }
    }
}

static inline void trace_aspeed_timer_ctrl_external_clock(uint8_t i, bool enable)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_TIMER_CTRL_EXTERNAL_CLOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_timer_ctrl_external_clock " "Timer %" PRIu8 ": %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , i, enable);
        }
    }
}

static inline void trace_aspeed_timer_ctrl_overflow_interrupt(uint8_t i, bool enable)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_TIMER_CTRL_OVERFLOW_INTERRUPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_timer_ctrl_overflow_interrupt " "Timer %" PRIu8 ": %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , i, enable);
        }
    }
}

static inline void trace_aspeed_timer_ctrl_pulse_enable(uint8_t i, bool enable)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_TIMER_CTRL_PULSE_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_timer_ctrl_pulse_enable " "Timer %" PRIu8 ": %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , i, enable);
        }
    }
}

static inline void trace_aspeed_timer_set_ctrl2(uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_TIMER_SET_CTRL2)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_timer_set_ctrl2 " "Value: 0x%" PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , value);
        }
    }
}

static inline void trace_aspeed_timer_set_value(int timer, int reg, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_TIMER_SET_VALUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_timer_set_value " "Timer %d register %d: 0x%" PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , timer, reg, value);
        }
    }
}

static inline void trace_aspeed_timer_read(uint64_t offset, unsigned size, uint64_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_ASPEED_TIMER_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:aspeed_timer_read " "From 0x%" PRIx64 ": of size %u: 0x%" PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offset, size, value);
        }
    }
}

static inline void trace_jazzio_read(uint64_t addr, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_JAZZIO_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:jazzio_read " "read reg[0x%"PRIx64"] = 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, ret);
        }
    }
}

static inline void trace_jazzio_write(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_JAZZIO_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:jazzio_write " "write reg[0x%"PRIx64"] = 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_rc4030_read(uint64_t addr, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_RC4030_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:rc4030_read " "read reg[0x%"PRIx64"] = 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, ret);
        }
    }
}

static inline void trace_rc4030_write(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_RC4030_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:rc4030_write " "write reg[0x%"PRIx64"] = 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_ledma_memory_read(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_LEDMA_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ledma_memory_read " "DMA read addr 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_ledma_memory_write(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_LEDMA_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ledma_memory_write " "DMA write addr 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_sparc32_dma_set_irq_raise(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPARC32_DMA_SET_IRQ_RAISE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sparc32_dma_set_irq_raise " "Raise IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_sparc32_dma_set_irq_lower(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPARC32_DMA_SET_IRQ_LOWER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sparc32_dma_set_irq_lower " "Lower IRQ" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_espdma_memory_read(uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESPDMA_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:espdma_memory_read " "DMA read addr 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_espdma_memory_write(uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_ESPDMA_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:espdma_memory_write " "DMA write addr 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_sparc32_dma_mem_readl(uint64_t addr, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPARC32_DMA_MEM_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sparc32_dma_mem_readl " "read dmareg %"PRIx64": 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, ret);
        }
    }
}

static inline void trace_sparc32_dma_mem_writel(uint64_t addr, uint32_t old, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPARC32_DMA_MEM_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sparc32_dma_mem_writel " "write dmareg %"PRIx64": 0x%08x -> 0x%08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, old, val);
        }
    }
}

static inline void trace_sparc32_dma_enable_raise(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPARC32_DMA_ENABLE_RAISE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sparc32_dma_enable_raise " "Raise DMA enable" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_sparc32_dma_enable_lower(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPARC32_DMA_ENABLE_LOWER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sparc32_dma_enable_lower " "Lower DMA enable" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_sun4m_iommu_mem_readl(uint64_t addr, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_IOMMU_MEM_READL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_iommu_mem_readl " "read reg[%"PRIx64"] = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, ret);
        }
    }
}

static inline void trace_sun4m_iommu_mem_writel(uint64_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_IOMMU_MEM_WRITEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_iommu_mem_writel " "write reg[%"PRIx64"] = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_sun4m_iommu_mem_writel_ctrl(uint64_t iostart)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_IOMMU_MEM_WRITEL_CTRL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_iommu_mem_writel_ctrl " "iostart = %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , iostart);
        }
    }
}

static inline void trace_sun4m_iommu_mem_writel_tlbflush(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_IOMMU_MEM_WRITEL_TLBFLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_iommu_mem_writel_tlbflush " "tlb flush %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_sun4m_iommu_mem_writel_pgflush(uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_IOMMU_MEM_WRITEL_PGFLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_iommu_mem_writel_pgflush " "page flush %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , val);
        }
    }
}

static inline void trace_sun4m_iommu_page_get_flags(uint64_t pa, uint64_t iopte, uint32_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_IOMMU_PAGE_GET_FLAGS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_iommu_page_get_flags " "get flags addr %"PRIx64" => pte %"PRIx64", *pte = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pa, iopte, ret);
        }
    }
}

static inline void trace_sun4m_iommu_translate_pa(uint64_t addr, uint64_t pa, uint32_t iopte)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_IOMMU_TRANSLATE_PA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_iommu_translate_pa " "xlate dva %"PRIx64" => pa %"PRIx64" iopte = %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, pa, iopte);
        }
    }
}

static inline void trace_sun4m_iommu_bad_addr(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_IOMMU_BAD_ADDR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_iommu_bad_addr " "bad addr %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_i8257_unregistered_dma(int nchan, int dma_pos, int dma_len)
{
    if (true) {
        if (trace_event_get_state(TRACE_I8257_UNREGISTERED_DMA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:i8257_unregistered_dma " "unregistered DMA channel used nchan=%d dma_pos=%d dma_len=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nchan, dma_pos, dma_len);
        }
    }
}

static inline void trace_sun4m_cpu_interrupt(unsigned int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_CPU_INTERRUPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_cpu_interrupt " "Set CPU IRQ %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , level);
        }
    }
}

static inline void trace_sun4m_cpu_reset_interrupt(unsigned int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_CPU_RESET_INTERRUPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_cpu_reset_interrupt " "Reset CPU IRQ %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , level);
        }
    }
}

static inline void trace_sun4m_cpu_set_irq_raise(int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_CPU_SET_IRQ_RAISE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_cpu_set_irq_raise " "Raise CPU IRQ %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , level);
        }
    }
}

static inline void trace_sun4m_cpu_set_irq_lower(int level)
{
    if (true) {
        if (trace_event_get_state(TRACE_SUN4M_CPU_SET_IRQ_LOWER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:sun4m_cpu_set_irq_lower " "Lower CPU IRQ %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , level);
        }
    }
}

static inline void trace_leon3_set_irq(int intno)
{
    if (true) {
        if (trace_event_get_state(TRACE_LEON3_SET_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:leon3_set_irq " "Set CPU IRQ %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , intno);
        }
    }
}

static inline void trace_leon3_reset_irq(int intno)
{
    if (true) {
        if (trace_event_get_state(TRACE_LEON3_RESET_IRQ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:leon3_reset_irq " "Reset CPU IRQ %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , intno);
        }
    }
}

static inline void trace_milkymist_memcard_memory_read(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MEMCARD_MEMORY_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_memcard_memory_read " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_milkymist_memcard_memory_write(uint32_t addr, uint32_t value)
{
    if (true) {
        if (trace_event_get_state(TRACE_MILKYMIST_MEMCARD_MEMORY_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:milkymist_memcard_memory_write " "addr %08x value %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, value);
        }
    }
}

static inline void trace_pc87312_io_read(uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PC87312_IO_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pc87312_io_read " "read addr=%x val=%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_pc87312_io_write(uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PC87312_IO_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pc87312_io_write " "write addr=%x val=%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_pc87312_info_floppy(uint32_t base)
{
    if (true) {
        if (trace_event_get_state(TRACE_PC87312_INFO_FLOPPY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pc87312_info_floppy " "base 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , base);
        }
    }
}

static inline void trace_pc87312_info_ide(uint32_t base)
{
    if (true) {
        if (trace_event_get_state(TRACE_PC87312_INFO_IDE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pc87312_info_ide " "base 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , base);
        }
    }
}

static inline void trace_pc87312_info_parallel(uint32_t base, uint32_t irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_PC87312_INFO_PARALLEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pc87312_info_parallel " "base 0x%x, irq %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , base, irq);
        }
    }
}

static inline void trace_pc87312_info_serial(int n, uint32_t base, uint32_t irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_PC87312_INFO_SERIAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pc87312_info_serial " "id=%d, base 0x%x, irq %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , n, base, irq);
        }
    }
}

static inline void trace_xen_platform_log(char * s)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_PLATFORM_LOG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_platform_log " "xen platform: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , s);
        }
    }
}

static inline void trace_xen_pv_mmio_read(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_PV_MMIO_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_pv_mmio_read " "WARNING: read from Xen PV Device MMIO space (address %"PRIx64")" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_xen_pv_mmio_write(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_XEN_PV_MMIO_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:xen_pv_mmio_write " "WARNING: write to Xen PV Device MMIO space (address %"PRIx64")" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_mhp_pc_dimm_assigned_slot(int slot)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_PC_DIMM_ASSIGNED_SLOT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_pc_dimm_assigned_slot " "0x%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot);
        }
    }
}

static inline void trace_mhp_pc_dimm_assigned_address(uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_PC_DIMM_ASSIGNED_ADDRESS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_pc_dimm_assigned_address " "0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr);
        }
    }
}

static inline void trace_x86_iommu_iec_notify(bool global, uint32_t index, uint32_t mask)
{
    if (true) {
        if (trace_event_get_state(TRACE_X86_IOMMU_IEC_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:x86_iommu_iec_notify " "Notify IEC invalidation: global=%d index=%" PRIu32 " mask=%" PRIu32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , global, index, mask);
        }
    }
}

static inline void trace_v9fs_rerror(uint16_t tag, uint8_t id, int err)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_RERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_rerror " "tag %d id %d err %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, err);
        }
    }
}

static inline void trace_v9fs_version(uint16_t tag, uint8_t id, int32_t msize, char* version)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_VERSION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_version " "tag %d id %d msize %d version %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, msize, version);
        }
    }
}

static inline void trace_v9fs_version_return(uint16_t tag, uint8_t id, int32_t msize, char* version)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_VERSION_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_version_return " "tag %d id %d msize %d version %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, msize, version);
        }
    }
}

static inline void trace_v9fs_attach(uint16_t tag, uint8_t id, int32_t fid, int32_t afid, char* uname, char* aname)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_ATTACH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_attach " "tag %u id %u fid %d afid %d uname %s aname %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, afid, uname, aname);
        }
    }
}

static inline void trace_v9fs_attach_return(uint16_t tag, uint8_t id, int8_t type, int32_t version, int64_t path)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_ATTACH_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_attach_return " "tag %d id %d type %d version %d path %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, type, version, path);
        }
    }
}

static inline void trace_v9fs_stat(uint16_t tag, uint8_t id, int32_t fid)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_STAT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_stat " "tag %d id %d fid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid);
        }
    }
}

static inline void trace_v9fs_stat_return(uint16_t tag, uint8_t id, int32_t mode, int32_t atime, int32_t mtime, int64_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_STAT_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_stat_return " "tag %d id %d stat={mode %d atime %d mtime %d length %"PRId64"}" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, mode, atime, mtime, length);
        }
    }
}

static inline void trace_v9fs_getattr(uint16_t tag, uint8_t id, int32_t fid, uint64_t request_mask)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_GETATTR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_getattr " "tag %d id %d fid %d request_mask %"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, request_mask);
        }
    }
}

static inline void trace_v9fs_getattr_return(uint16_t tag, uint8_t id, uint64_t result_mask, uint32_t mode, uint32_t uid, uint32_t gid)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_GETATTR_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_getattr_return " "tag %d id %d getattr={result_mask %"PRId64" mode %u uid %u gid %u}" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, result_mask, mode, uid, gid);
        }
    }
}

static inline void trace_v9fs_walk(uint16_t tag, uint8_t id, int32_t fid, int32_t newfid, uint16_t nwnames)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_WALK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_walk " "tag %d id %d fid %d newfid %d nwnames %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, newfid, nwnames);
        }
    }
}

static inline void trace_v9fs_walk_return(uint16_t tag, uint8_t id, uint16_t nwnames, void* qids)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_WALK_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_walk_return " "tag %d id %d nwnames %d qids %p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, nwnames, qids);
        }
    }
}

static inline void trace_v9fs_open(uint16_t tag, uint8_t id, int32_t fid, int32_t mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_OPEN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_open " "tag %d id %d fid %d mode %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, mode);
        }
    }
}

static inline void trace_v9fs_open_return(uint16_t tag, uint8_t id, int8_t type, int32_t version, int64_t path, int iounit)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_OPEN_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_open_return " "tag %d id %d qid={type %d version %d path %"PRId64"} iounit %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, type, version, path, iounit);
        }
    }
}

static inline void trace_v9fs_lcreate(uint16_t tag, uint8_t id, int32_t dfid, int32_t flags, int32_t mode, uint32_t gid)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_LCREATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_lcreate " "tag %d id %d dfid %d flags %d mode %d gid %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, dfid, flags, mode, gid);
        }
    }
}

static inline void trace_v9fs_lcreate_return(uint16_t tag, uint8_t id, int8_t type, int32_t version, int64_t path, int32_t iounit)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_LCREATE_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_lcreate_return " "tag %d id %d qid={type %d version %d path %"PRId64"} iounit %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, type, version, path, iounit);
        }
    }
}

static inline void trace_v9fs_fsync(uint16_t tag, uint8_t id, int32_t fid, int datasync)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_FSYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_fsync " "tag %d id %d fid %d datasync %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, datasync);
        }
    }
}

static inline void trace_v9fs_clunk(uint16_t tag, uint8_t id, int32_t fid)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_CLUNK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_clunk " "tag %d id %d fid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid);
        }
    }
}

static inline void trace_v9fs_read(uint16_t tag, uint8_t id, int32_t fid, uint64_t off, uint32_t max_count)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_read " "tag %d id %d fid %d off %"PRIu64" max_count %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, off, max_count);
        }
    }
}

static inline void trace_v9fs_read_return(uint16_t tag, uint8_t id, int32_t count, ssize_t err)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_READ_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_read_return " "tag %d id %d count %d err %zd" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, count, err);
        }
    }
}

static inline void trace_v9fs_readdir(uint16_t tag, uint8_t id, int32_t fid, uint64_t offset, uint32_t max_count)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_READDIR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_readdir " "tag %d id %d fid %d offset %"PRIu64" max_count %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, offset, max_count);
        }
    }
}

static inline void trace_v9fs_readdir_return(uint16_t tag, uint8_t id, uint32_t count, ssize_t retval)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_READDIR_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_readdir_return " "tag %d id %d count %u retval %zd" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, count, retval);
        }
    }
}

static inline void trace_v9fs_write(uint16_t tag, uint8_t id, int32_t fid, uint64_t off, uint32_t count, int cnt)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_write " "tag %d id %d fid %d off %"PRIu64" count %u cnt %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, off, count, cnt);
        }
    }
}

static inline void trace_v9fs_write_return(uint16_t tag, uint8_t id, int32_t total, ssize_t err)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_WRITE_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_write_return " "tag %d id %d total %d err %zd" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, total, err);
        }
    }
}

static inline void trace_v9fs_create(uint16_t tag, uint8_t id, int32_t fid, char* name, int32_t perm, int8_t mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_CREATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_create " "tag %d id %d fid %d name %s perm %d mode %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, name, perm, mode);
        }
    }
}

static inline void trace_v9fs_create_return(uint16_t tag, uint8_t id, int8_t type, int32_t version, int64_t path, int iounit)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_CREATE_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_create_return " "tag %d id %d qid={type %d version %d path %"PRId64"} iounit %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, type, version, path, iounit);
        }
    }
}

static inline void trace_v9fs_symlink(uint16_t tag, uint8_t id, int32_t fid, char* name, char* symname, uint32_t gid)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_SYMLINK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_symlink " "tag %d id %d fid %d name %s symname %s gid %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, name, symname, gid);
        }
    }
}

static inline void trace_v9fs_symlink_return(uint16_t tag, uint8_t id, int8_t type, int32_t version, int64_t path)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_SYMLINK_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_symlink_return " "tag %d id %d qid={type %d version %d path %"PRId64"}" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, type, version, path);
        }
    }
}

static inline void trace_v9fs_flush(uint16_t tag, uint8_t id, int16_t flush_tag)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_FLUSH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_flush " "tag %d id %d flush_tag %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, flush_tag);
        }
    }
}

static inline void trace_v9fs_link(uint16_t tag, uint8_t id, int32_t dfid, int32_t oldfid, char* name)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_LINK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_link " "tag %d id %d dfid %d oldfid %d name %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, dfid, oldfid, name);
        }
    }
}

static inline void trace_v9fs_remove(uint16_t tag, uint8_t id, int32_t fid)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_REMOVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_remove " "tag %d id %d fid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid);
        }
    }
}

static inline void trace_v9fs_wstat(uint16_t tag, uint8_t id, int32_t fid, int32_t mode, int32_t atime, int32_t mtime)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_WSTAT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_wstat " "tag %u id %u fid %d stat={mode %d atime %d mtime %d}" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, mode, atime, mtime);
        }
    }
}

static inline void trace_v9fs_mknod(uint16_t tag, uint8_t id, int32_t fid, int mode, int major, int minor)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_MKNOD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_mknod " "tag %d id %d fid %d mode %d major %d minor %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, mode, major, minor);
        }
    }
}

static inline void trace_v9fs_mknod_return(uint16_t tag, uint8_t id, int8_t type, int32_t version, int64_t path)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_MKNOD_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_mknod_return " "tag %d id %d qid={type %d version %d path %"PRId64"}" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, type, version, path);
        }
    }
}

static inline void trace_v9fs_lock(uint16_t tag, uint8_t id, int32_t fid, uint8_t type, uint64_t start, uint64_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_LOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_lock " "tag %d id %d fid %d type %d start %"PRIu64" length %"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, type, start, length);
        }
    }
}

static inline void trace_v9fs_lock_return(uint16_t tag, uint8_t id, int8_t status)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_LOCK_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_lock_return " "tag %d id %d status %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, status);
        }
    }
}

static inline void trace_v9fs_getlock(uint16_t tag, uint8_t id, int32_t fid, uint8_t type, uint64_t start, uint64_t length)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_GETLOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_getlock " "tag %d id %d fid %d type %d start %"PRIu64" length %"PRIu64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, type, start, length);
        }
    }
}

static inline void trace_v9fs_getlock_return(uint16_t tag, uint8_t id, uint8_t type, uint64_t start, uint64_t length, uint32_t proc_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_GETLOCK_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_getlock_return " "tag %d id %d type %d start %"PRIu64" length %"PRIu64" proc_id %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, type, start, length, proc_id);
        }
    }
}

static inline void trace_v9fs_mkdir(uint16_t tag, uint8_t id, int32_t fid, char* name, int mode, uint32_t gid)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_MKDIR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_mkdir " "tag %u id %u fid %d name %s mode %d gid %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, name, mode, gid);
        }
    }
}

static inline void trace_v9fs_mkdir_return(uint16_t tag, uint8_t id, int8_t type, int32_t version, int64_t path, int err)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_MKDIR_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_mkdir_return " "tag %u id %u qid={type %d version %d path %"PRId64"} err %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, type, version, path, err);
        }
    }
}

static inline void trace_v9fs_xattrwalk(uint16_t tag, uint8_t id, int32_t fid, int32_t newfid, char* name)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_XATTRWALK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_xattrwalk " "tag %d id %d fid %d newfid %d name %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, newfid, name);
        }
    }
}

static inline void trace_v9fs_xattrwalk_return(uint16_t tag, uint8_t id, int64_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_XATTRWALK_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_xattrwalk_return " "tag %d id %d size %"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, size);
        }
    }
}

static inline void trace_v9fs_xattrcreate(uint16_t tag, uint8_t id, int32_t fid, char* name, int64_t size, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_XATTRCREATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_xattrcreate " "tag %d id %d fid %d name %s size %"PRId64" flags %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid, name, size, flags);
        }
    }
}

static inline void trace_v9fs_readlink(uint16_t tag, uint8_t id, int32_t fid)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_READLINK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_readlink " "tag %d id %d fid %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, fid);
        }
    }
}

static inline void trace_v9fs_readlink_return(uint16_t tag, uint8_t id, char* target)
{
    if (true) {
        if (trace_event_get_state(TRACE_V9FS_READLINK_RETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:v9fs_readlink_return " "tag %d id %d name %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tag, id, target);
        }
    }
}

static inline void trace_spapr_pci_msi(const char * msg, uint32_t ca)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_PCI_MSI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_pci_msi " "%s (cfg=%x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , msg, ca);
        }
    }
}

static inline void trace_spapr_pci_msi_setup(const char * name, unsigned vector, uint64_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_PCI_MSI_SETUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_pci_msi_setup " "dev\"%s\" vector %u, addr=%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, vector, addr);
        }
    }
}

static inline void trace_spapr_pci_rtas_ibm_change_msi(unsigned cfg, unsigned func, unsigned req, unsigned first)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_PCI_RTAS_IBM_CHANGE_MSI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_pci_rtas_ibm_change_msi " "cfgaddr %x func %u, requested %u, first irq %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cfg, func, req, first);
        }
    }
}

static inline void trace_spapr_pci_rtas_ibm_query_interrupt_source_number(unsigned ioa, unsigned intr)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_PCI_RTAS_IBM_QUERY_INTERRUPT_SOURCE_NUMBER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_pci_rtas_ibm_query_interrupt_source_number " "queries for #%u, IRQ%u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ioa, intr);
        }
    }
}

static inline void trace_spapr_pci_msi_write(uint64_t addr, uint64_t data, uint32_t dt_irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_PCI_MSI_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_pci_msi_write " "@%"PRIx64"<=%"PRIx64" IRQ %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, data, dt_irq);
        }
    }
}

static inline void trace_spapr_pci_lsi_set(const char * busname, int pin, uint32_t irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_PCI_LSI_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_pci_lsi_set " "%s PIN%d IRQ %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , busname, pin, irq);
        }
    }
}

static inline void trace_spapr_pci_msi_retry(unsigned config_addr, unsigned req_num, unsigned max_irqs)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_PCI_MSI_RETRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_pci_msi_retry " "Guest device at %x asked %u, have only %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , config_addr, req_num, max_irqs);
        }
    }
}

static inline void trace_spapr_cas_failed(unsigned long n)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_CAS_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_cas_failed " "DT diff buffer is too small: %ld bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , n);
        }
    }
}

static inline void trace_spapr_cas_continue(unsigned long n)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_CAS_CONTINUE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_cas_continue " "Copy changes to the guest: %ld bytes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , n);
        }
    }
}

static inline void trace_spapr_cas_pvr_try(uint32_t pvr)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_CAS_PVR_TRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_cas_pvr_try " "%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pvr);
        }
    }
}

static inline void trace_spapr_cas_pvr(uint32_t cur_pvr, bool cpu_match, uint32_t new_pvr, uint64_t pcr)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_CAS_PVR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_cas_pvr " "current=%x, cpu_match=%u, new=%x, compat flags=%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cur_pvr, cpu_match, new_pvr, pcr);
        }
    }
}

static inline void trace_spapr_iommu_put(uint64_t liobn, uint64_t ioba, uint64_t tce, uint64_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_PUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_put " "liobn=%"PRIx64" ioba=0x%"PRIx64" tce=0x%"PRIx64" ret=%"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, ioba, tce, ret);
        }
    }
}

static inline void trace_spapr_iommu_get(uint64_t liobn, uint64_t ioba, uint64_t ret, uint64_t tce)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_GET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_get " "liobn=%"PRIx64" ioba=0x%"PRIx64" ret=%"PRId64" tce=0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, ioba, ret, tce);
        }
    }
}

static inline void trace_spapr_iommu_indirect(uint64_t liobn, uint64_t ioba, uint64_t tce, uint64_t iobaN, uint64_t tceN, uint64_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_INDIRECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_indirect " "liobn=%"PRIx64" ioba=0x%"PRIx64" tcelist=0x%"PRIx64" iobaN=0x%"PRIx64" tceN=0x%"PRIx64" ret=%"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, ioba, tce, iobaN, tceN, ret);
        }
    }
}

static inline void trace_spapr_iommu_stuff(uint64_t liobn, uint64_t ioba, uint64_t tce_value, uint64_t npages, uint64_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_STUFF)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_stuff " "liobn=%"PRIx64" ioba=0x%"PRIx64" tcevalue=0x%"PRIx64" npages=%"PRId64" ret=%"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, ioba, tce_value, npages, ret);
        }
    }
}

static inline void trace_spapr_iommu_pci_put(uint64_t liobn, uint64_t ioba, uint64_t tce, uint64_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_PCI_PUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_pci_put " "liobn=%"PRIx64" ioba=0x%"PRIx64" tce=0x%"PRIx64" ret=%"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, ioba, tce, ret);
        }
    }
}

static inline void trace_spapr_iommu_pci_get(uint64_t liobn, uint64_t ioba, uint64_t ret, uint64_t tce)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_PCI_GET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_pci_get " "liobn=%"PRIx64" ioba=0x%"PRIx64" ret=%"PRId64" tce=0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, ioba, ret, tce);
        }
    }
}

static inline void trace_spapr_iommu_pci_indirect(uint64_t liobn, uint64_t ioba, uint64_t tce, uint64_t iobaN, uint64_t tceN, uint64_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_PCI_INDIRECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_pci_indirect " "liobn=%"PRIx64" ioba=0x%"PRIx64" tcelist=0x%"PRIx64" iobaN=0x%"PRIx64" tceN=0x%"PRIx64" ret=%"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, ioba, tce, iobaN, tceN, ret);
        }
    }
}

static inline void trace_spapr_iommu_pci_stuff(uint64_t liobn, uint64_t ioba, uint64_t tce_value, uint64_t npages, uint64_t ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_PCI_STUFF)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_pci_stuff " "liobn=%"PRIx64" ioba=0x%"PRIx64" tcevalue=0x%"PRIx64" npages=%"PRId64" ret=%"PRId64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, ioba, tce_value, npages, ret);
        }
    }
}

static inline void trace_spapr_iommu_xlate(uint64_t liobn, uint64_t ioba, uint64_t tce, unsigned perm, unsigned pgsize)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_XLATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_xlate " "liobn=%"PRIx64" 0x%"PRIx64" -> 0x%"PRIx64" perm=%u mask=%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, ioba, tce, perm, pgsize);
        }
    }
}

static inline void trace_spapr_iommu_new_table(uint64_t liobn, void * table, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_NEW_TABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_new_table " "liobn=%"PRIx64" table=%p fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, table, fd);
        }
    }
}

static inline void trace_spapr_iommu_pre_save(uint64_t liobn, uint32_t nb, uint64_t offs, uint32_t ps)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_PRE_SAVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_pre_save " "liobn=%"PRIx64" %"PRIx32" bus_offset=%"PRIx64" ps=%"PRIu32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, nb, offs, ps);
        }
    }
}

static inline void trace_spapr_iommu_post_load(uint64_t liobn, uint32_t pre_nb, uint32_t post_nb, uint64_t offs, uint32_t ps)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_POST_LOAD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_post_load " "liobn=%"PRIx64" %"PRIx32" => %"PRIx32" bus_offset=%"PRIx64" ps=%"PRIu32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn, pre_nb, post_nb, offs, ps);
        }
    }
}

static inline void trace_spapr_iommu_ddw_query(uint64_t buid, uint32_t cfgaddr, unsigned wa, uint64_t win_size, uint32_t pgmask)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_DDW_QUERY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_ddw_query " "buid=%"PRIx64" addr=%"PRIx32", %u windows available, max window size=%"PRIx64", mask=%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , buid, cfgaddr, wa, win_size, pgmask);
        }
    }
}

static inline void trace_spapr_iommu_ddw_create(uint64_t buid, uint32_t cfgaddr, uint64_t pg_size, uint64_t req_size, uint64_t start, uint32_t liobn)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_DDW_CREATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_ddw_create " "buid=%"PRIx64" addr=%"PRIx32", page size=0x%"PRIx64", requested=0x%"PRIx64", start addr=%"PRIx64", liobn=%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , buid, cfgaddr, pg_size, req_size, start, liobn);
        }
    }
}

static inline void trace_spapr_iommu_ddw_remove(uint32_t liobn)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_DDW_REMOVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_ddw_remove " "liobn=%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , liobn);
        }
    }
}

static inline void trace_spapr_iommu_ddw_reset(uint64_t buid, uint32_t cfgaddr)
{
    if (true) {
        if (trace_event_get_state(TRACE_SPAPR_IOMMU_DDW_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:spapr_iommu_ddw_reset " "buid=%"PRIx64" addr=%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , buid, cfgaddr);
        }
    }
}

static inline void trace_ppc_tb_adjust(uint64_t offs1, uint64_t offs2, int64_t diff, int64_t seconds)
{
    if (true) {
        if (trace_event_get_state(TRACE_PPC_TB_ADJUST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ppc_tb_adjust " "adjusted from 0x%"PRIx64" to 0x%"PRIx64", diff %"PRId64" (%"PRId64"s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , offs1, offs2, diff, seconds);
        }
    }
}

static inline void trace_prep_io_800_writeb(uint32_t addr, uint32_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PREP_IO_800_WRITEB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:prep_io_800_writeb " "0x%08" PRIx32 " => 0x%02" PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, val);
        }
    }
}

static inline void trace_prep_io_800_readb(uint32_t addr, uint32_t retval)
{
    if (true) {
        if (trace_event_get_state(TRACE_PREP_IO_800_READB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:prep_io_800_readb " "0x%08" PRIx32 " <= 0x%02" PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, retval);
        }
    }
}

static inline void trace_pci_update_mappings_del(void * d, uint32_t bus, uint32_t slot, uint32_t func, int bar, uint64_t addr, uint64_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCI_UPDATE_MAPPINGS_DEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pci_update_mappings_del " "d=%p %02x:%02x.%x %d,%#"PRIx64"+%#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , d, bus, slot, func, bar, addr, size);
        }
    }
}

static inline void trace_pci_update_mappings_add(void * d, uint32_t bus, uint32_t slot, uint32_t func, int bar, uint64_t addr, uint64_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCI_UPDATE_MAPPINGS_ADD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pci_update_mappings_add " "d=%p %02x:%02x.%x %d,%#"PRIx64"+%#"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , d, bus, slot, func, bar, addr, size);
        }
    }
}

static inline void trace_pci_cfg_read(const char * dev, unsigned devid, unsigned fnid, unsigned offs, unsigned val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCI_CFG_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pci_cfg_read " "%s %02u:%u @0x%x -> 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, devid, fnid, offs, val);
        }
    }
}

static inline void trace_pci_cfg_write(const char * dev, unsigned devid, unsigned fnid, unsigned offs, unsigned val)
{
    if (true) {
        if (trace_event_get_state(TRACE_PCI_CFG_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:pci_cfg_write " "%s %02u:%u @0x%x <- 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, devid, fnid, offs, val);
        }
    }
}

static inline void trace_css_enable_facility(const char * facility)
{
    if (true) {
        if (trace_event_get_state(TRACE_CSS_ENABLE_FACILITY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:css_enable_facility " "CSS: enable %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , facility);
        }
    }
}

static inline void trace_css_crw(uint8_t rsc, uint8_t erc, uint16_t rsid, const char * chained)
{
    if (true) {
        if (trace_event_get_state(TRACE_CSS_CRW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:css_crw " "CSS: queueing crw: rsc=%x, erc=%x, rsid=%x %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rsc, erc, rsid, chained);
        }
    }
}

static inline void trace_css_chpid_add(uint8_t cssid, uint8_t chpid, uint8_t type)
{
    if (true) {
        if (trace_event_get_state(TRACE_CSS_CHPID_ADD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:css_chpid_add " "CSS: add chpid %x.%02x (type %02x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cssid, chpid, type);
        }
    }
}

static inline void trace_css_new_image(uint8_t cssid, const char * default_cssid)
{
    if (true) {
        if (trace_event_get_state(TRACE_CSS_NEW_IMAGE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:css_new_image " "CSS: add css image %02x %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cssid, default_cssid);
        }
    }
}

static inline void trace_css_assign_subch(const char * do_assign, uint8_t cssid, uint8_t ssid, uint16_t schid, uint16_t devno)
{
    if (true) {
        if (trace_event_get_state(TRACE_CSS_ASSIGN_SUBCH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:css_assign_subch " "CSS: %s %x.%x.%04x (devno %04x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , do_assign, cssid, ssid, schid, devno);
        }
    }
}

static inline void trace_css_io_interrupt(int cssid, int ssid, int schid, uint32_t intparm, uint8_t isc, const char * conditional)
{
    if (true) {
        if (trace_event_get_state(TRACE_CSS_IO_INTERRUPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:css_io_interrupt " "CSS: I/O interrupt on sch %x.%x.%04x (intparm %08x, isc %x) %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cssid, ssid, schid, intparm, isc, conditional);
        }
    }
}

static inline void trace_css_adapter_interrupt(uint8_t isc)
{
    if (true) {
        if (trace_event_get_state(TRACE_CSS_ADAPTER_INTERRUPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:css_adapter_interrupt " "CSS: adapter I/O interrupt (isc %x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , isc);
        }
    }
}

static inline void trace_virtio_ccw_interpret_ccw(int cssid, int ssid, int schid, int cmd_code)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_CCW_INTERPRET_CCW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_ccw_interpret_ccw " "VIRTIO-CCW: %x.%x.%04x: interpret command %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cssid, ssid, schid, cmd_code);
        }
    }
}

static inline void trace_virtio_ccw_new_device(int cssid, int ssid, int schid, int devno, const char * devno_mode)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_CCW_NEW_DEVICE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_ccw_new_device " "VIRTIO-CCW: add subchannel %x.%x.%04x, devno %04x (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cssid, ssid, schid, devno, devno_mode);
        }
    }
}

static inline void trace_virtio_ccw_set_ind(uint64_t ind_loc, uint8_t ind_old, uint8_t ind_new)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRTIO_CCW_SET_IND)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virtio_ccw_set_ind " "VIRTIO-CCW: indicator at %" PRIu64 ": %x->%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ind_loc, ind_old, ind_new);
        }
    }
}

static inline void trace_vfio_intx_interrupt(const char * name, char line)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_INTX_INTERRUPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_intx_interrupt " " (%s) Pin %c" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, line);
        }
    }
}

static inline void trace_vfio_intx_eoi(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_INTX_EOI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_intx_eoi " " (%s) EOI" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_intx_enable_kvm(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_INTX_ENABLE_KVM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_intx_enable_kvm " " (%s) KVM INTx accel enabled" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_intx_disable_kvm(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_INTX_DISABLE_KVM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_intx_disable_kvm " " (%s) KVM INTx accel disabled" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_intx_update(const char * name, int new_irq, int target_irq)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_INTX_UPDATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_intx_update " " (%s) IRQ moved %d -> %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, new_irq, target_irq);
        }
    }
}

static inline void trace_vfio_intx_enable(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_INTX_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_intx_enable " " (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_intx_disable(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_INTX_DISABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_intx_disable " " (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_msi_interrupt(const char * name, int index, uint64_t addr, int data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSI_INTERRUPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msi_interrupt " " (%s) vector %d 0x%"PRIx64"/0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index, addr, data);
        }
    }
}

static inline void trace_vfio_msix_vector_do_use(const char * name, int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSIX_VECTOR_DO_USE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msix_vector_do_use " " (%s) vector %d used" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index);
        }
    }
}

static inline void trace_vfio_msix_vector_release(const char * name, int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSIX_VECTOR_RELEASE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msix_vector_release " " (%s) vector %d released" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index);
        }
    }
}

static inline void trace_vfio_msix_enable(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSIX_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msix_enable " " (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_msix_pba_disable(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSIX_PBA_DISABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msix_pba_disable " " (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_msix_pba_enable(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSIX_PBA_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msix_pba_enable " " (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_msix_disable(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSIX_DISABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msix_disable " " (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_msix_fixup(const char * name, int bar, uint64_t start, uint64_t end)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSIX_FIXUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msix_fixup " " (%s) MSI-X region %d mmap fixup [0x%"PRIx64" - 0x%"PRIx64"]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, bar, start, end);
        }
    }
}

static inline void trace_vfio_msi_enable(const char * name, int nr_vectors)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSI_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msi_enable " " (%s) Enabled %d MSI vectors" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, nr_vectors);
        }
    }
}

static inline void trace_vfio_msi_disable(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSI_DISABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msi_disable " " (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_pci_load_rom(const char * name, unsigned long size, unsigned long offset, unsigned long flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_LOAD_ROM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_load_rom " "Device %s ROM:\n  size: 0x%lx, offset: 0x%lx, flags: 0x%lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, size, offset, flags);
        }
    }
}

static inline void trace_vfio_rom_read(const char * name, uint64_t addr, int size, uint64_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_ROM_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_rom_read " " (%s, 0x%"PRIx64", 0x%x) = 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, addr, size, data);
        }
    }
}

static inline void trace_vfio_pci_size_rom(const char * name, int size)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_SIZE_ROM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_size_rom " "%s ROM size 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, size);
        }
    }
}

static inline void trace_vfio_vga_write(uint64_t addr, uint64_t data, int size)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_VGA_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_vga_write " " (0x%"PRIx64", 0x%"PRIx64", %d)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, data, size);
        }
    }
}

static inline void trace_vfio_vga_read(uint64_t addr, int size, uint64_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_VGA_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_vga_read " " (0x%"PRIx64", %d) = 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , addr, size, data);
        }
    }
}

static inline void trace_vfio_pci_read_config(const char * name, int addr, int len, int val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_READ_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_read_config " " (%s, @0x%x, len=0x%x) %x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, addr, len, val);
        }
    }
}

static inline void trace_vfio_pci_write_config(const char * name, int addr, int val, int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_WRITE_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_write_config " " (%s, @0x%x, 0x%x, len=0x%x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, addr, val, len);
        }
    }
}

static inline void trace_vfio_msi_setup(const char * name, int pos)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSI_SETUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msi_setup " "%s PCI MSI CAP @0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, pos);
        }
    }
}

static inline void trace_vfio_msix_early_setup(const char * name, int pos, int table_bar, int offset, int entries)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_MSIX_EARLY_SETUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_msix_early_setup " "%s PCI MSI-X CAP @0x%x, BAR %d, offset 0x%x, entries %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, pos, table_bar, offset, entries);
        }
    }
}

static inline void trace_vfio_check_pcie_flr(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_CHECK_PCIE_FLR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_check_pcie_flr " "%s Supports FLR via PCIe cap" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_check_pm_reset(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_CHECK_PM_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_check_pm_reset " "%s Supports PM reset" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_check_af_flr(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_CHECK_AF_FLR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_check_af_flr " "%s Supports FLR via AF cap" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_pci_hot_reset(const char * name, const char * type)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_HOT_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_hot_reset " " (%s) %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, type);
        }
    }
}

static inline void trace_vfio_pci_hot_reset_has_dep_devices(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_HOT_RESET_HAS_DEP_DEVICES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_hot_reset_has_dep_devices " "%s: hot reset dependent devices:" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_pci_hot_reset_dep_devices(int domain, int bus, int slot, int function, int group_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_HOT_RESET_DEP_DEVICES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_hot_reset_dep_devices " "\t%04x:%02x:%02x.%x group %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , domain, bus, slot, function, group_id);
        }
    }
}

static inline void trace_vfio_pci_hot_reset_result(const char * name, const char * result)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_HOT_RESET_RESULT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_hot_reset_result " "%s hot reset: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, result);
        }
    }
}

static inline void trace_vfio_populate_device_config(const char * name, unsigned long size, unsigned long offset, unsigned long flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_POPULATE_DEVICE_CONFIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_populate_device_config " "Device %s config:\n  size: 0x%lx, offset: 0x%lx, flags: 0x%lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, size, offset, flags);
        }
    }
}

static inline void trace_vfio_populate_device_get_irq_info_failure(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_POPULATE_DEVICE_GET_IRQ_INFO_FAILURE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_populate_device_get_irq_info_failure " "VFIO_DEVICE_GET_IRQ_INFO failure: %m" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_vfio_initfn(const char * name, int group_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_INITFN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_initfn " " (%s) group %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, group_id);
        }
    }
}

static inline void trace_vfio_add_ext_cap_dropped(const char * name, uint16_t cap, uint16_t offset)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_ADD_EXT_CAP_DROPPED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_add_ext_cap_dropped " "%s %x@%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, cap, offset);
        }
    }
}

static inline void trace_vfio_pci_reset(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_reset " " (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_pci_reset_flr(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_RESET_FLR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_reset_flr " "%s FLR/VFIO_DEVICE_RESET" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_pci_reset_pm(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_RESET_PM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_reset_pm " "%s PCI PM Reset" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_pci_emulated_vendor_id(const char * name, uint16_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_EMULATED_VENDOR_ID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_emulated_vendor_id " "%s %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, val);
        }
    }
}

static inline void trace_vfio_pci_emulated_device_id(const char * name, uint16_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_EMULATED_DEVICE_ID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_emulated_device_id " "%s %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, val);
        }
    }
}

static inline void trace_vfio_pci_emulated_sub_vendor_id(const char * name, uint16_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_EMULATED_SUB_VENDOR_ID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_emulated_sub_vendor_id " "%s %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, val);
        }
    }
}

static inline void trace_vfio_pci_emulated_sub_device_id(const char * name, uint16_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_EMULATED_SUB_DEVICE_ID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_emulated_sub_device_id " "%s %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, val);
        }
    }
}

static inline void trace_vfio_quirk_rom_blacklisted(const char * name, uint16_t vid, uint16_t did)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_ROM_BLACKLISTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_rom_blacklisted " "%s %04x:%04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, vid, did);
        }
    }
}

static inline void trace_vfio_quirk_generic_window_address_write(const char * name, const char * region_name, uint64_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_GENERIC_WINDOW_ADDRESS_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_generic_window_address_write " "%s %s 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, region_name, data);
        }
    }
}

static inline void trace_vfio_quirk_generic_window_data_read(const char * name, const char * region_name, uint64_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_GENERIC_WINDOW_DATA_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_generic_window_data_read " "%s %s 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, region_name, data);
        }
    }
}

static inline void trace_vfio_quirk_generic_window_data_write(const char * name, const char * region_name, uint64_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_GENERIC_WINDOW_DATA_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_generic_window_data_write " "%s %s 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, region_name, data);
        }
    }
}

static inline void trace_vfio_quirk_generic_mirror_read(const char * name, const char * region_name, uint64_t addr, uint64_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_GENERIC_MIRROR_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_generic_mirror_read " "%s %s 0x%"PRIx64": 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, region_name, addr, data);
        }
    }
}

static inline void trace_vfio_quirk_generic_mirror_write(const char * name, const char * region_name, uint64_t addr, uint64_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_GENERIC_MIRROR_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_generic_mirror_write " "%s %s 0x%"PRIx64": 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, region_name, addr, data);
        }
    }
}

static inline void trace_vfio_quirk_ati_3c3_read(const char * name, uint64_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_ATI_3C3_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_ati_3c3_read " "%s 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, data);
        }
    }
}

static inline void trace_vfio_quirk_ati_3c3_probe(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_ATI_3C3_PROBE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_ati_3c3_probe " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_ati_bar4_probe(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_ATI_BAR4_PROBE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_ati_bar4_probe " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_ati_bar2_probe(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_ATI_BAR2_PROBE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_ati_bar2_probe " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_nvidia_3d0_state(const char * name, const char * state)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_NVIDIA_3D0_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_nvidia_3d0_state " "%s %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, state);
        }
    }
}

static inline void trace_vfio_quirk_nvidia_3d0_read(const char * name, uint8_t offset, unsigned size, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_NVIDIA_3D0_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_nvidia_3d0_read " " (%s, @0x%x, len=0x%x) %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, offset, size, val);
        }
    }
}

static inline void trace_vfio_quirk_nvidia_3d0_write(const char * name, uint8_t offset, uint64_t data, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_NVIDIA_3D0_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_nvidia_3d0_write " "(%s, @0x%x, 0x%"PRIx64", len=0x%x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, offset, data, size);
        }
    }
}

static inline void trace_vfio_quirk_nvidia_3d0_probe(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_NVIDIA_3D0_PROBE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_nvidia_3d0_probe " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_nvidia_bar5_state(const char * name, const char * state)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_NVIDIA_BAR5_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_nvidia_bar5_state " "%s %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, state);
        }
    }
}

static inline void trace_vfio_quirk_nvidia_bar5_probe(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_NVIDIA_BAR5_PROBE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_nvidia_bar5_probe " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_nvidia_bar0_msi_ack(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_NVIDIA_BAR0_MSI_ACK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_nvidia_bar0_msi_ack " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_nvidia_bar0_probe(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_NVIDIA_BAR0_PROBE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_nvidia_bar0_probe " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_rtl8168_fake_latch(const char * name, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_RTL8168_FAKE_LATCH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_rtl8168_fake_latch " "%s 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, val);
        }
    }
}

static inline void trace_vfio_quirk_rtl8168_msix_write(const char * name, uint16_t offset, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_RTL8168_MSIX_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_rtl8168_msix_write " "%s MSI-X table write[0x%x]: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, offset, val);
        }
    }
}

static inline void trace_vfio_quirk_rtl8168_msix_read(const char * name, uint16_t offset, uint64_t val)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_RTL8168_MSIX_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_rtl8168_msix_read " "%s MSI-X table read[0x%x]: 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, offset, val);
        }
    }
}

static inline void trace_vfio_quirk_rtl8168_probe(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_RTL8168_PROBE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_rtl8168_probe " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_ati_bonaire_reset_skipped(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_ATI_BONAIRE_RESET_SKIPPED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_ati_bonaire_reset_skipped " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_ati_bonaire_reset_no_smc(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_ATI_BONAIRE_RESET_NO_SMC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_ati_bonaire_reset_no_smc " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_ati_bonaire_reset_timeout(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_ATI_BONAIRE_RESET_TIMEOUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_ati_bonaire_reset_timeout " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_ati_bonaire_reset_done(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_ATI_BONAIRE_RESET_DONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_ati_bonaire_reset_done " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_quirk_ati_bonaire_reset(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_QUIRK_ATI_BONAIRE_RESET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_quirk_ati_bonaire_reset " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_pci_igd_bar4_write(const char * name, uint32_t index, uint32_t data, uint32_t base)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_IGD_BAR4_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_igd_bar4_write " "%s [%03x] %08x -> %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index, data, base);
        }
    }
}

static inline void trace_vfio_pci_igd_bdsm_enabled(const char * name, int size)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_IGD_BDSM_ENABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_igd_bdsm_enabled " "%s %dMB" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, size);
        }
    }
}

static inline void trace_vfio_pci_igd_opregion_enabled(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_IGD_OPREGION_ENABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_igd_opregion_enabled " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_pci_igd_host_bridge_enabled(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_IGD_HOST_BRIDGE_ENABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_igd_host_bridge_enabled " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_pci_igd_lpc_bridge_enabled(const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PCI_IGD_LPC_BRIDGE_ENABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_pci_igd_lpc_bridge_enabled " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name);
        }
    }
}

static inline void trace_vfio_region_write(const char * name, int index, uint64_t addr, uint64_t data, unsigned size)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_REGION_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_region_write " " (%s:region%d+0x%"PRIx64", 0x%"PRIx64 ", %d)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index, addr, data, size);
        }
    }
}

static inline void trace_vfio_region_read(char * name, int index, uint64_t addr, unsigned size, uint64_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_REGION_READ)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_region_read " " (%s:region%d+0x%"PRIx64", %d) = 0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index, addr, size, data);
        }
    }
}

static inline void trace_vfio_iommu_map_notify(uint64_t iova_start, uint64_t iova_end)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_IOMMU_MAP_NOTIFY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_iommu_map_notify " "iommu map @ %"PRIx64" - %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , iova_start, iova_end);
        }
    }
}

static inline void trace_vfio_listener_region_add_skip(uint64_t start, uint64_t end)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_LISTENER_REGION_ADD_SKIP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_listener_region_add_skip " "SKIPPING region_add %"PRIx64" - %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start, end);
        }
    }
}

static inline void trace_vfio_listener_region_add_iommu(uint64_t start, uint64_t end)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_LISTENER_REGION_ADD_IOMMU)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_listener_region_add_iommu " "region_add [iommu] %"PRIx64" - %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start, end);
        }
    }
}

static inline void trace_vfio_listener_region_add_ram(uint64_t iova_start, uint64_t iova_end, void * vaddr)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_LISTENER_REGION_ADD_RAM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_listener_region_add_ram " "region_add [ram] %"PRIx64" - %"PRIx64" [%p]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , iova_start, iova_end, vaddr);
        }
    }
}

static inline void trace_vfio_listener_region_del_skip(uint64_t start, uint64_t end)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_LISTENER_REGION_DEL_SKIP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_listener_region_del_skip " "SKIPPING region_del %"PRIx64" - %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start, end);
        }
    }
}

static inline void trace_vfio_listener_region_del(uint64_t start, uint64_t end)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_LISTENER_REGION_DEL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_listener_region_del " "region_del %"PRIx64" - %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start, end);
        }
    }
}

static inline void trace_vfio_disconnect_container(int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_DISCONNECT_CONTAINER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_disconnect_container " "close container->fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fd);
        }
    }
}

static inline void trace_vfio_put_group(int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PUT_GROUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_put_group " "close group->fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fd);
        }
    }
}

static inline void trace_vfio_get_device(const char * name, unsigned int flags, unsigned int num_regions, unsigned int num_irqs)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_GET_DEVICE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_get_device " "Device %s flags: %u, regions: %u, irqs: %u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, flags, num_regions, num_irqs);
        }
    }
}

static inline void trace_vfio_put_base_device(int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PUT_BASE_DEVICE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_put_base_device " "close vdev->fd=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , fd);
        }
    }
}

static inline void trace_vfio_region_setup(const char * dev, int index, const char * name, unsigned long flags, unsigned long offset, unsigned long size)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_REGION_SETUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_region_setup " "Device %s, region %d \"%s\", flags: %lx, offset: %lx, size: %lx" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dev, index, name, flags, offset, size);
        }
    }
}

static inline void trace_vfio_region_mmap_fault(const char * name, int index, unsigned long offset, unsigned long size, int fault)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_REGION_MMAP_FAULT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_region_mmap_fault " "Region %s mmaps[%d], [%lx - %lx], fault: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index, offset, size, fault);
        }
    }
}

static inline void trace_vfio_region_mmap(const char * name, unsigned long offset, unsigned long end)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_REGION_MMAP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_region_mmap " "Region %s [%lx - %lx]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, offset, end);
        }
    }
}

static inline void trace_vfio_region_exit(const char * name, int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_REGION_EXIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_region_exit " "Device %s, region %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index);
        }
    }
}

static inline void trace_vfio_region_finalize(const char * name, int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_REGION_FINALIZE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_region_finalize " "Device %s, region %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index);
        }
    }
}

static inline void trace_vfio_region_mmaps_set_enabled(const char * name, bool enabled)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_REGION_MMAPS_SET_ENABLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_region_mmaps_set_enabled " "Region %s mmaps enabled: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, enabled);
        }
    }
}

static inline void trace_vfio_region_sparse_mmap_header(const char * name, int index, int nr_areas)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_REGION_SPARSE_MMAP_HEADER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_region_sparse_mmap_header " "Device %s region %d: %d sparse mmap entries" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index, nr_areas);
        }
    }
}

static inline void trace_vfio_region_sparse_mmap_entry(int i, unsigned long start, unsigned long end)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_REGION_SPARSE_MMAP_ENTRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_region_sparse_mmap_entry " "sparse entry %d [0x%lx - 0x%lx]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , i, start, end);
        }
    }
}

static inline void trace_vfio_get_dev_region(const char * name, int index, uint32_t type, uint32_t subtype)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_GET_DEV_REGION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_get_dev_region " "%s index %d, %08x/%0x8" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, index, type, subtype);
        }
    }
}

static inline void trace_vfio_platform_base_device_init(char * name, int groupid)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PLATFORM_BASE_DEVICE_INIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_platform_base_device_init " "%s belongs to group #%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, groupid);
        }
    }
}

static inline void trace_vfio_platform_realize(char * name, char * compat)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PLATFORM_REALIZE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_platform_realize " "vfio device %s, compat = %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , name, compat);
        }
    }
}

static inline void trace_vfio_platform_eoi(int pin, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PLATFORM_EOI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_platform_eoi " "EOI IRQ pin %d (fd=%d)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pin, fd);
        }
    }
}

static inline void trace_vfio_platform_intp_mmap_enable(int pin)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PLATFORM_INTP_MMAP_ENABLE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_platform_intp_mmap_enable " "IRQ #%d still active, stay in slow path" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pin);
        }
    }
}

static inline void trace_vfio_platform_intp_interrupt(int pin, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PLATFORM_INTP_INTERRUPT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_platform_intp_interrupt " "Inject IRQ #%d (fd = %d)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pin, fd);
        }
    }
}

static inline void trace_vfio_platform_intp_inject_pending_lockheld(int pin, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PLATFORM_INTP_INJECT_PENDING_LOCKHELD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_platform_intp_inject_pending_lockheld " "Inject pending IRQ #%d (fd = %d)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pin, fd);
        }
    }
}

static inline void trace_vfio_platform_populate_interrupts(int pin, int count, int flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PLATFORM_POPULATE_INTERRUPTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_platform_populate_interrupts " "- IRQ index %d: count %d, flags=0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pin, count, flags);
        }
    }
}

static inline void trace_vfio_intp_interrupt_set_pending(int index)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_INTP_INTERRUPT_SET_PENDING)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_intp_interrupt_set_pending " "irq %d is set PENDING" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index);
        }
    }
}

static inline void trace_vfio_platform_start_level_irqfd_injection(int index, int fd, int resamplefd)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PLATFORM_START_LEVEL_IRQFD_INJECTION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_platform_start_level_irqfd_injection " "IRQ index=%d, fd = %d, resamplefd = %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, fd, resamplefd);
        }
    }
}

static inline void trace_vfio_platform_start_edge_irqfd_injection(int index, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PLATFORM_START_EDGE_IRQFD_INJECTION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_platform_start_edge_irqfd_injection " "IRQ index=%d, fd = %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , index, fd);
        }
    }
}

static inline void trace_vfio_prereg_listener_region_add_skip(uint64_t start, uint64_t end)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PREREG_LISTENER_REGION_ADD_SKIP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_prereg_listener_region_add_skip " "%"PRIx64" - %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start, end);
        }
    }
}

static inline void trace_vfio_prereg_listener_region_del_skip(uint64_t start, uint64_t end)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PREREG_LISTENER_REGION_DEL_SKIP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_prereg_listener_region_del_skip " "%"PRIx64" - %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , start, end);
        }
    }
}

static inline void trace_vfio_prereg_register(uint64_t va, uint64_t size, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PREREG_REGISTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_prereg_register " "va=%"PRIx64" size=%"PRIx64" ret=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , va, size, ret);
        }
    }
}

static inline void trace_vfio_prereg_unregister(uint64_t va, uint64_t size, int ret)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_PREREG_UNREGISTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_prereg_unregister " "va=%"PRIx64" size=%"PRIx64" ret=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , va, size, ret);
        }
    }
}

static inline void trace_vfio_spapr_create_window(int ps, uint64_t ws, uint64_t off)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_SPAPR_CREATE_WINDOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_spapr_create_window " "pageshift=0x%x winsize=0x%"PRIx64" offset=0x%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ps, ws, off);
        }
    }
}

static inline void trace_vfio_spapr_remove_window(uint64_t off)
{
    if (true) {
        if (trace_event_get_state(TRACE_VFIO_SPAPR_REMOVE_WINDOW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vfio_spapr_remove_window " "offset=%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , off);
        }
    }
}

static inline void trace_mhp_acpi_invalid_slot_selected(uint32_t slot)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_INVALID_SLOT_SELECTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_invalid_slot_selected " "0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot);
        }
    }
}

static inline void trace_mhp_acpi_ejecting_invalid_slot(uint32_t slot)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_EJECTING_INVALID_SLOT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_ejecting_invalid_slot " "0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot);
        }
    }
}

static inline void trace_mhp_acpi_read_addr_lo(uint32_t slot, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_READ_ADDR_LO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_read_addr_lo " "slot[0x%"PRIx32"] addr lo: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot, addr);
        }
    }
}

static inline void trace_mhp_acpi_read_addr_hi(uint32_t slot, uint32_t addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_READ_ADDR_HI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_read_addr_hi " "slot[0x%"PRIx32"] addr hi: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot, addr);
        }
    }
}

static inline void trace_mhp_acpi_read_size_lo(uint32_t slot, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_READ_SIZE_LO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_read_size_lo " "slot[0x%"PRIx32"] size lo: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot, size);
        }
    }
}

static inline void trace_mhp_acpi_read_size_hi(uint32_t slot, uint32_t size)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_READ_SIZE_HI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_read_size_hi " "slot[0x%"PRIx32"] size hi: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot, size);
        }
    }
}

static inline void trace_mhp_acpi_read_pxm(uint32_t slot, uint32_t pxm)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_READ_PXM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_read_pxm " "slot[0x%"PRIx32"] proximity: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot, pxm);
        }
    }
}

static inline void trace_mhp_acpi_read_flags(uint32_t slot, uint32_t flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_READ_FLAGS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_read_flags " "slot[0x%"PRIx32"] flags: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot, flags);
        }
    }
}

static inline void trace_mhp_acpi_write_slot(uint32_t slot)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_WRITE_SLOT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_write_slot " "set active slot: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot);
        }
    }
}

static inline void trace_mhp_acpi_write_ost_ev(uint32_t slot, uint32_t ev)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_WRITE_OST_EV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_write_ost_ev " "slot[0x%"PRIx32"] OST EVENT: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot, ev);
        }
    }
}

static inline void trace_mhp_acpi_write_ost_status(uint32_t slot, uint32_t st)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_WRITE_OST_STATUS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_write_ost_status " "slot[0x%"PRIx32"] OST STATUS: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot, st);
        }
    }
}

static inline void trace_mhp_acpi_clear_insert_evt(uint32_t slot)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_CLEAR_INSERT_EVT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_clear_insert_evt " "slot[0x%"PRIx32"] clear insert event" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot);
        }
    }
}

static inline void trace_mhp_acpi_clear_remove_evt(uint32_t slot)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_CLEAR_REMOVE_EVT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_clear_remove_evt " "slot[0x%"PRIx32"] clear remove event" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot);
        }
    }
}

static inline void trace_mhp_acpi_pc_dimm_deleted(uint32_t slot)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_PC_DIMM_DELETED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_pc_dimm_deleted " "slot[0x%"PRIx32"] pc-dimm deleted" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot);
        }
    }
}

static inline void trace_mhp_acpi_pc_dimm_delete_failed(uint32_t slot)
{
    if (true) {
        if (trace_event_get_state(TRACE_MHP_ACPI_PC_DIMM_DELETE_FAILED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mhp_acpi_pc_dimm_delete_failed " "slot[0x%"PRIx32"] pc-dimm delete failed" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot);
        }
    }
}

static inline void trace_cpuhp_acpi_invalid_idx_selected(uint32_t idx)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_INVALID_IDX_SELECTED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_invalid_idx_selected " "0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx);
        }
    }
}

static inline void trace_cpuhp_acpi_read_flags(uint32_t idx, uint8_t flags)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_READ_FLAGS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_read_flags " "idx[0x%"PRIx32"] flags: 0x%"PRIx8 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx, flags);
        }
    }
}

static inline void trace_cpuhp_acpi_write_idx(uint32_t idx)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_WRITE_IDX)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_write_idx " "set active cpu idx: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx);
        }
    }
}

static inline void trace_cpuhp_acpi_write_cmd(uint32_t idx, uint8_t cmd)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_WRITE_CMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_write_cmd " "idx[0x%"PRIx32"] cmd: 0x%"PRIx8 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx, cmd);
        }
    }
}

static inline void trace_cpuhp_acpi_read_cmd_data(uint32_t idx, uint32_t data)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_READ_CMD_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_read_cmd_data " "idx[0x%"PRIx32"] data: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx, data);
        }
    }
}

static inline void trace_cpuhp_acpi_cpu_has_events(uint32_t idx, bool ins, bool rm)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_CPU_HAS_EVENTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_cpu_has_events " "idx[0x%"PRIx32"] inserting: %d, removing: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx, ins, rm);
        }
    }
}

static inline void trace_cpuhp_acpi_clear_inserting_evt(uint32_t idx)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_CLEAR_INSERTING_EVT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_clear_inserting_evt " "idx[0x%"PRIx32"]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx);
        }
    }
}

static inline void trace_cpuhp_acpi_clear_remove_evt(uint32_t idx)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_CLEAR_REMOVE_EVT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_clear_remove_evt " "idx[0x%"PRIx32"]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx);
        }
    }
}

static inline void trace_cpuhp_acpi_ejecting_invalid_cpu(uint32_t idx)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_EJECTING_INVALID_CPU)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_ejecting_invalid_cpu " "0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx);
        }
    }
}

static inline void trace_cpuhp_acpi_ejecting_cpu(uint32_t idx)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_EJECTING_CPU)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_ejecting_cpu " "0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , idx);
        }
    }
}

static inline void trace_cpuhp_acpi_write_ost_ev(uint32_t slot, uint32_t ev)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_WRITE_OST_EV)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_write_ost_ev " "idx[0x%"PRIx32"] OST EVENT: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot, ev);
        }
    }
}

static inline void trace_cpuhp_acpi_write_ost_status(uint32_t slot, uint32_t st)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPUHP_ACPI_WRITE_OST_STATUS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpuhp_acpi_write_ost_status " "idx[0x%"PRIx32"] OST STATUS: 0x%"PRIx32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , slot, st);
        }
    }
}

static inline void trace_virt_acpi_setup(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_VIRT_ACPI_SETUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:virt_acpi_setup " "No fw cfg or ACPI disabled. Bailing out." "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_alpha_pci_iack_write(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALPHA_PCI_IACK_WRITE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alpha_pci_iack_write " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_console_gfx_new(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_CONSOLE_GFX_NEW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:console_gfx_new " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_console_putchar_csi(int esc_param0, int esc_param1, int ch, int nb_esc_params)
{
    if (true) {
        if (trace_event_get_state(TRACE_CONSOLE_PUTCHAR_CSI)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:console_putchar_csi " "escape sequence CSI%d;%d%c, %d parameters" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , esc_param0, esc_param1, ch, nb_esc_params);
        }
    }
}

static inline void trace_console_putchar_unhandled(int ch)
{
    if (true) {
        if (trace_event_get_state(TRACE_CONSOLE_PUTCHAR_UNHANDLED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:console_putchar_unhandled " "unhandled escape character '%c'" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , ch);
        }
    }
}

static inline void trace_console_txt_new(int w, int h)
{
    if (true) {
        if (trace_event_get_state(TRACE_CONSOLE_TXT_NEW)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:console_txt_new " "%dx%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , w, h);
        }
    }
}

static inline void trace_console_select(int nr)
{
    if (true) {
        if (trace_event_get_state(TRACE_CONSOLE_SELECT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:console_select " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , nr);
        }
    }
}

static inline void trace_console_refresh(int interval)
{
    if (true) {
        if (trace_event_get_state(TRACE_CONSOLE_REFRESH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:console_refresh " "interval %d ms" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , interval);
        }
    }
}

static inline void trace_displaysurface_create(void * display_surface, int w, int h)
{
    if (true) {
        if (trace_event_get_state(TRACE_DISPLAYSURFACE_CREATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:displaysurface_create " "surface=%p, %dx%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , display_surface, w, h);
        }
    }
}

static inline void trace_displaysurface_create_from(void * display_surface, int w, int h, uint32_t format)
{
    if (true) {
        if (trace_event_get_state(TRACE_DISPLAYSURFACE_CREATE_FROM)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:displaysurface_create_from " "surface=%p, %dx%d, format 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , display_surface, w, h, format);
        }
    }
}

static inline void trace_displaysurface_create_pixman(void * display_surface)
{
    if (true) {
        if (trace_event_get_state(TRACE_DISPLAYSURFACE_CREATE_PIXMAN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:displaysurface_create_pixman " "surface=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , display_surface);
        }
    }
}

static inline void trace_displaysurface_free(void * display_surface)
{
    if (true) {
        if (trace_event_get_state(TRACE_DISPLAYSURFACE_FREE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:displaysurface_free " "surface=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , display_surface);
        }
    }
}

static inline void trace_displaychangelistener_register(void * dcl, const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_DISPLAYCHANGELISTENER_REGISTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:displaychangelistener_register " "%p [ %s ]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dcl, name);
        }
    }
}

static inline void trace_displaychangelistener_unregister(void * dcl, const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_DISPLAYCHANGELISTENER_UNREGISTER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:displaychangelistener_unregister " "%p [ %s ]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , dcl, name);
        }
    }
}

static inline void trace_ppm_save(const char * filename, void * display_surface)
{
    if (true) {
        if (trace_event_get_state(TRACE_PPM_SAVE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ppm_save " "%s surface=%p" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , filename, display_surface);
        }
    }
}

static inline void trace_gd_switch(const char * tab, int width, int height)
{
    if (true) {
        if (trace_event_get_state(TRACE_GD_SWITCH)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gd_switch " "tab=%s, width=%d, height=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tab, width, height);
        }
    }
}

static inline void trace_gd_update(const char * tab, int x, int y, int w, int h)
{
    if (true) {
        if (trace_event_get_state(TRACE_GD_UPDATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gd_update " "tab=%s, x=%d, y=%d, w=%d, h=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tab, x, y, w, h);
        }
    }
}

static inline void trace_gd_key_event(const char * tab, int gdk_keycode, int qemu_keycode, const char * action)
{
    if (true) {
        if (trace_event_get_state(TRACE_GD_KEY_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gd_key_event " "tab=%s, translated GDK keycode %d to QEMU keycode %d (%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tab, gdk_keycode, qemu_keycode, action);
        }
    }
}

static inline void trace_gd_grab(const char * tab, const char * device, const char * reason)
{
    if (true) {
        if (trace_event_get_state(TRACE_GD_GRAB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gd_grab " "tab=%s, dev=%s, reason=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tab, device, reason);
        }
    }
}

static inline void trace_gd_ungrab(const char * tab, const char * device)
{
    if (true) {
        if (trace_event_get_state(TRACE_GD_UNGRAB)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:gd_ungrab " "tab=%s, dev=%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tab, device);
        }
    }
}

static inline void trace_vnc_key_guest_leds(bool caps, bool num, bool scroll)
{
    if (true) {
        if (trace_event_get_state(TRACE_VNC_KEY_GUEST_LEDS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vnc_key_guest_leds " "caps %d, num %d, scroll %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , caps, num, scroll);
        }
    }
}

static inline void trace_vnc_key_map_init(const char * layout)
{
    if (true) {
        if (trace_event_get_state(TRACE_VNC_KEY_MAP_INIT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vnc_key_map_init " "%s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , layout);
        }
    }
}

static inline void trace_vnc_key_event_ext(bool down, int sym, int keycode, const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VNC_KEY_EVENT_EXT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vnc_key_event_ext " "down %d, sym 0x%x, keycode 0x%x [%s]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , down, sym, keycode, name);
        }
    }
}

static inline void trace_vnc_key_event_map(bool down, int sym, int keycode, const char * name)
{
    if (true) {
        if (trace_event_get_state(TRACE_VNC_KEY_EVENT_MAP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vnc_key_event_map " "down %d, sym 0x%x -> keycode 0x%x [%s]" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , down, sym, keycode, name);
        }
    }
}

static inline void trace_vnc_key_sync_numlock(bool on)
{
    if (true) {
        if (trace_event_get_state(TRACE_VNC_KEY_SYNC_NUMLOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vnc_key_sync_numlock " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , on);
        }
    }
}

static inline void trace_vnc_key_sync_capslock(bool on)
{
    if (true) {
        if (trace_event_get_state(TRACE_VNC_KEY_SYNC_CAPSLOCK)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vnc_key_sync_capslock " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , on);
        }
    }
}

static inline void trace_input_event_key_number(int conidx, int number, const char * qcode, bool down)
{
    if (true) {
        if (trace_event_get_state(TRACE_INPUT_EVENT_KEY_NUMBER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:input_event_key_number " "con %d, key number 0x%x [%s], down %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , conidx, number, qcode, down);
        }
    }
}

static inline void trace_input_event_key_qcode(int conidx, const char * qcode, bool down)
{
    if (true) {
        if (trace_event_get_state(TRACE_INPUT_EVENT_KEY_QCODE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:input_event_key_qcode " "con %d, key qcode %s, down %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , conidx, qcode, down);
        }
    }
}

static inline void trace_input_event_btn(int conidx, const char * btn, bool down)
{
    if (true) {
        if (trace_event_get_state(TRACE_INPUT_EVENT_BTN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:input_event_btn " "con %d, button %s, down %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , conidx, btn, down);
        }
    }
}

static inline void trace_input_event_rel(int conidx, const char * axis, int value)
{
    if (true) {
        if (trace_event_get_state(TRACE_INPUT_EVENT_REL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:input_event_rel " "con %d, axis %s, value %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , conidx, axis, value);
        }
    }
}

static inline void trace_input_event_abs(int conidx, const char * axis, int value)
{
    if (true) {
        if (trace_event_get_state(TRACE_INPUT_EVENT_ABS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:input_event_abs " "con %d, axis %s, value 0x%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , conidx, axis, value);
        }
    }
}

static inline void trace_input_event_sync(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_INPUT_EVENT_SYNC)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:input_event_sync " "" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_input_mouse_mode(int absolute)
{
    if (true) {
        if (trace_event_get_state(TRACE_INPUT_MOUSE_MODE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:input_mouse_mode " "absolute %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , absolute);
        }
    }
}

static inline void trace_qemu_spice_add_memslot(int qid, uint32_t slot_id, unsigned long virt_start, unsigned long virt_end, int async)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SPICE_ADD_MEMSLOT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_spice_add_memslot " "%d %u: host virt 0x%lx - 0x%lx async=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, slot_id, virt_start, virt_end, async);
        }
    }
}

static inline void trace_qemu_spice_del_memslot(int qid, uint32_t gid, uint32_t slot_id)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SPICE_DEL_MEMSLOT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_spice_del_memslot " "%d gid=%u sid=%u" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, gid, slot_id);
        }
    }
}

static inline void trace_qemu_spice_create_primary_surface(int qid, uint32_t sid, void * surface, int async)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SPICE_CREATE_PRIMARY_SURFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_spice_create_primary_surface " "%d sid=%u surface=%p async=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, sid, surface, async);
        }
    }
}

static inline void trace_qemu_spice_destroy_primary_surface(int qid, uint32_t sid, int async)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SPICE_DESTROY_PRIMARY_SURFACE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_spice_destroy_primary_surface " "%d sid=%u async=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid, sid, async);
        }
    }
}

static inline void trace_qemu_spice_wakeup(uint32_t qid)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SPICE_WAKEUP)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_spice_wakeup " "%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , qid);
        }
    }
}

static inline void trace_qemu_spice_create_update(uint32_t left, uint32_t right, uint32_t top, uint32_t bottom)
{
    if (true) {
        if (trace_event_get_state(TRACE_QEMU_SPICE_CREATE_UPDATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:qemu_spice_create_update " "lr %d -> %d,  tb -> %d -> %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , left, right, top, bottom);
        }
    }
}

static inline void trace_alsa_revents(int revents)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALSA_REVENTS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alsa_revents " "revents = %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , revents);
        }
    }
}

static inline void trace_alsa_pollout(int i, int fd)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALSA_POLLOUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alsa_pollout " "i = %d fd = %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , i, fd);
        }
    }
}

static inline void trace_alsa_set_handler(int events, int index, int fd, int err)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALSA_SET_HANDLER)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alsa_set_handler " "events=%#x index=%d fd=%d err=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , events, index, fd, err);
        }
    }
}

static inline void trace_alsa_wrote_zero(int len)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALSA_WROTE_ZERO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alsa_wrote_zero " "Failed to write %d frames (wrote zero)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , len);
        }
    }
}

static inline void trace_alsa_read_zero(long len)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALSA_READ_ZERO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alsa_read_zero " "Failed to read %ld frames (read zero)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , len);
        }
    }
}

static inline void trace_alsa_xrun_out(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALSA_XRUN_OUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alsa_xrun_out " "Recovering from playback xrun" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_alsa_xrun_in(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALSA_XRUN_IN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alsa_xrun_in " "Recovering from capture xrun" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_alsa_resume_out(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALSA_RESUME_OUT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alsa_resume_out " "Resuming suspended output stream" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_alsa_resume_in(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALSA_RESUME_IN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alsa_resume_in " "Resuming suspended input stream" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_alsa_no_frames(int state)
{
    if (true) {
        if (trace_event_get_state(TRACE_ALSA_NO_FRAMES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:alsa_no_frames " "No frames available and ALSA state is %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , state);
        }
    }
}

static inline void trace_oss_version(int version)
{
    if (true) {
        if (trace_event_get_state(TRACE_OSS_VERSION)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:oss_version " "OSS version = %#x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , version);
        }
    }
}

static inline void trace_oss_invalid_available_size(int size, int bufsize)
{
    if (true) {
        if (trace_event_get_state(TRACE_OSS_INVALID_AVAILABLE_SIZE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:oss_invalid_available_size " "Invalid available size, size=%d bufsize=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , size, bufsize);
        }
    }
}

static inline void trace_vhost_user_event(const char * chr, int event)
{
    if (true) {
        if (trace_event_get_state(TRACE_VHOST_USER_EVENT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:vhost_user_event " "chr: %s got event: %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , chr, event);
        }
    }
}

static inline void trace_kvm_x86_fixup_msi_error(uint32_t gsi)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_X86_FIXUP_MSI_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_x86_fixup_msi_error " "VT-d failed to remap interrupt for GSI %" PRIu32 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , gsi);
        }
    }
}

static inline void trace_kvm_x86_add_msi_route(int virq)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_X86_ADD_MSI_ROUTE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_x86_add_msi_route " "Adding route entry for virq %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , virq);
        }
    }
}

static inline void trace_kvm_x86_remove_msi_route(int virq)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_X86_REMOVE_MSI_ROUTE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_x86_remove_msi_route " "Removing route entry for virq %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , virq);
        }
    }
}

static inline void trace_kvm_x86_update_msi_routes(int num)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_X86_UPDATE_MSI_ROUTES)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_x86_update_msi_routes " "Updated %d MSI routes" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , num);
        }
    }
}

static inline void trace_mmu_helper_dfault(uint64_t address, uint64_t context, int mmu_idx, uint32_t tl)
{
    if (true) {
        if (trace_event_get_state(TRACE_MMU_HELPER_DFAULT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mmu_helper_dfault " "DFAULT at %"PRIx64" context %"PRIx64" mmu_idx=%d tl=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , address, context, mmu_idx, tl);
        }
    }
}

static inline void trace_mmu_helper_dprot(uint64_t address, uint64_t context, int mmu_idx, uint32_t tl)
{
    if (true) {
        if (trace_event_get_state(TRACE_MMU_HELPER_DPROT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mmu_helper_dprot " "DPROT at %"PRIx64" context %"PRIx64" mmu_idx=%d tl=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , address, context, mmu_idx, tl);
        }
    }
}

static inline void trace_mmu_helper_dmiss(uint64_t address, uint64_t context)
{
    if (true) {
        if (trace_event_get_state(TRACE_MMU_HELPER_DMISS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mmu_helper_dmiss " "DMISS at %"PRIx64" context %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , address, context);
        }
    }
}

static inline void trace_mmu_helper_tfault(uint64_t address, uint64_t context)
{
    if (true) {
        if (trace_event_get_state(TRACE_MMU_HELPER_TFAULT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mmu_helper_tfault " "TFAULT at %"PRIx64" context %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , address, context);
        }
    }
}

static inline void trace_mmu_helper_tmiss(uint64_t address, uint64_t context)
{
    if (true) {
        if (trace_event_get_state(TRACE_MMU_HELPER_TMISS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mmu_helper_tmiss " "TMISS at %"PRIx64" context %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , address, context);
        }
    }
}

static inline void trace_mmu_helper_get_phys_addr_code(uint32_t tl, int mmu_idx, uint64_t prim_context, uint64_t sec_context, uint64_t address)
{
    if (true) {
        if (trace_event_get_state(TRACE_MMU_HELPER_GET_PHYS_ADDR_CODE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mmu_helper_get_phys_addr_code " "tl=%d mmu_idx=%d primary context=%"PRIx64" secondary context=%"PRIx64" address=%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tl, mmu_idx, prim_context, sec_context, address);
        }
    }
}

static inline void trace_mmu_helper_get_phys_addr_data(uint32_t tl, int mmu_idx, uint64_t prim_context, uint64_t sec_context, uint64_t address)
{
    if (true) {
        if (trace_event_get_state(TRACE_MMU_HELPER_GET_PHYS_ADDR_DATA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mmu_helper_get_phys_addr_data " "tl=%d mmu_idx=%d primary context=%"PRIx64" secondary context=%"PRIx64" address=%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tl, mmu_idx, prim_context, sec_context, address);
        }
    }
}

static inline void trace_mmu_helper_mmu_fault(uint64_t address, uint64_t paddr, int mmu_idx, uint32_t tl, uint64_t prim_context, uint64_t sec_context)
{
    if (true) {
        if (trace_event_get_state(TRACE_MMU_HELPER_MMU_FAULT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:mmu_helper_mmu_fault " "Translate at %"PRIx64" -> %"PRIx64", mmu_idx=%d tl=%d primary context=%"PRIx64" secondary context=%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , address, paddr, mmu_idx, tl, prim_context, sec_context);
        }
    }
}

static inline void trace_int_helper_set_softint(uint32_t softint)
{
    if (true) {
        if (trace_event_get_state(TRACE_INT_HELPER_SET_SOFTINT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:int_helper_set_softint " "new %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , softint);
        }
    }
}

static inline void trace_int_helper_clear_softint(uint32_t softint)
{
    if (true) {
        if (trace_event_get_state(TRACE_INT_HELPER_CLEAR_SOFTINT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:int_helper_clear_softint " "new %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , softint);
        }
    }
}

static inline void trace_int_helper_write_softint(uint32_t softint)
{
    if (true) {
        if (trace_event_get_state(TRACE_INT_HELPER_WRITE_SOFTINT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:int_helper_write_softint " "new %08x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , softint);
        }
    }
}

static inline void trace_int_helper_icache_freeze(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_INT_HELPER_ICACHE_FREEZE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:int_helper_icache_freeze " "Instruction cache: freeze" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_int_helper_dcache_freeze(void)
{
    if (true) {
        if (trace_event_get_state(TRACE_INT_HELPER_DCACHE_FREEZE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:int_helper_dcache_freeze " "Data cache: freeze" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          );
        }
    }
}

static inline void trace_win_helper_gregset_error(uint32_t pstate)
{
    if (true) {
        if (trace_event_get_state(TRACE_WIN_HELPER_GREGSET_ERROR)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:win_helper_gregset_error " "ERROR in get_gregset: active pstate bits=%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pstate);
        }
    }
}

static inline void trace_win_helper_switch_pstate(uint32_t pstate_regs, uint32_t new_pstate_regs)
{
    if (true) {
        if (trace_event_get_state(TRACE_WIN_HELPER_SWITCH_PSTATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:win_helper_switch_pstate " "change_pstate: switching regs old=%x new=%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , pstate_regs, new_pstate_regs);
        }
    }
}

static inline void trace_win_helper_no_switch_pstate(uint32_t new_pstate_regs)
{
    if (true) {
        if (trace_event_get_state(TRACE_WIN_HELPER_NO_SWITCH_PSTATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:win_helper_no_switch_pstate " "change_pstate: regs new=%x (unchanged)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , new_pstate_regs);
        }
    }
}

static inline void trace_win_helper_wrpil(uint32_t psrpil, uint32_t new_pil)
{
    if (true) {
        if (trace_event_get_state(TRACE_WIN_HELPER_WRPIL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:win_helper_wrpil " "old=%x new=%x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , psrpil, new_pil);
        }
    }
}

static inline void trace_win_helper_done(uint32_t tl)
{
    if (true) {
        if (trace_event_get_state(TRACE_WIN_HELPER_DONE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:win_helper_done " "tl=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tl);
        }
    }
}

static inline void trace_win_helper_retry(uint32_t tl)
{
    if (true) {
        if (trace_event_get_state(TRACE_WIN_HELPER_RETRY)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:win_helper_retry " "tl=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , tl);
        }
    }
}

static inline void trace_get_skeys_nonzero(int rc)
{
    if (true) {
        if (trace_event_get_state(TRACE_GET_SKEYS_NONZERO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:get_skeys_nonzero " "SKEY: Call to get_skeys unexpectedly returned %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rc);
        }
    }
}

static inline void trace_set_skeys_nonzero(int rc)
{
    if (true) {
        if (trace_event_get_state(TRACE_SET_SKEYS_NONZERO)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:set_skeys_nonzero " "SKEY: Call to set_skeys unexpectedly returned %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rc);
        }
    }
}

static inline void trace_ioinst(const char * insn)
{
    if (true) {
        if (trace_event_get_state(TRACE_IOINST)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ioinst " "IOINST: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , insn);
        }
    }
}

static inline void trace_ioinst_sch_id(const char * insn, int cssid, int ssid, int schid)
{
    if (true) {
        if (trace_event_get_state(TRACE_IOINST_SCH_ID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ioinst_sch_id " "IOINST: %s (%x.%x.%04x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , insn, cssid, ssid, schid);
        }
    }
}

static inline void trace_ioinst_chp_id(const char * insn, int cssid, int chpid)
{
    if (true) {
        if (trace_event_get_state(TRACE_IOINST_CHP_ID)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ioinst_chp_id " "IOINST: %s (%x.%02x)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , insn, cssid, chpid);
        }
    }
}

static inline void trace_ioinst_chsc_cmd(uint16_t cmd, uint16_t len)
{
    if (true) {
        if (trace_event_get_state(TRACE_IOINST_CHSC_CMD)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:ioinst_chsc_cmd " "IOINST: chsc command %04x, len %04x" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cmd, len);
        }
    }
}

static inline void trace_kvm_enable_cmma(int rc)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_ENABLE_CMMA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_enable_cmma " "CMMA: enabling with result code %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rc);
        }
    }
}

static inline void trace_kvm_clear_cmma(int rc)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_CLEAR_CMMA)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_clear_cmma " "CMMA: clearing with result code %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , rc);
        }
    }
}

static inline void trace_kvm_failed_cpu_state_set(int cpu_index, uint8_t state, const char * msg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_FAILED_CPU_STATE_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_failed_cpu_state_set " "Warning: Unable to set cpu %d state %" PRIu8 " to KVM: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, state, msg);
        }
    }
}

static inline void trace_kvm_sigp_finished(uint8_t order, int cpu_index, int dst_index, int cc)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_SIGP_FINISHED)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_sigp_finished " "SIGP: Finished order %u on cpu %d -> cpu %d with cc=%d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , order, cpu_index, dst_index, cc);
        }
    }
}

static inline void trace_cpu_set_state(int cpu_index, uint8_t state)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_SET_STATE)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_set_state " "setting cpu %d state to %" PRIu8 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index, state);
        }
    }
}

static inline void trace_cpu_halt(int cpu_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_HALT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_halt " "halting cpu %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index);
        }
    }
}

static inline void trace_cpu_unhalt(int cpu_index)
{
    if (true) {
        if (trace_event_get_state(TRACE_CPU_UNHALT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:cpu_unhalt " "unhalting cpu %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , cpu_index);
        }
    }
}

static inline void trace_kvm_failed_spr_set(int str, const char * msg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_FAILED_SPR_SET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_failed_spr_set " "Warning: Unable to set SPR %d to KVM: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , str, msg);
        }
    }
}

static inline void trace_kvm_failed_spr_get(int str, const char * msg)
{
    if (true) {
        if (trace_event_get_state(TRACE_KVM_FAILED_SPR_GET)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:kvm_failed_spr_get " "Warning: Unable to retrieve SPR %d from KVM: %s" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , str, msg);
        }
    }
}

static inline void trace_object_dynamic_cast_assert(const char * type, const char * target, const char * file, int line, const char * func)
{
    if (true) {
        if (trace_event_get_state(TRACE_OBJECT_DYNAMIC_CAST_ASSERT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:object_dynamic_cast_assert " "%s->%s (%s:%d:%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , type, target, file, line, func);
        }
    }
}

static inline void trace_object_class_dynamic_cast_assert(const char * type, const char * target, const char * file, int line, const char * func)
{
    if (true) {
        if (trace_event_get_state(TRACE_OBJECT_CLASS_DYNAMIC_CAST_ASSERT)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:object_class_dynamic_cast_assert " "%s->%s (%s:%d:%s)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , type, target, file, line, func);
        }
    }
}

static inline void trace_user_setup_frame(void * env, uint64_t frame_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USER_SETUP_FRAME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:user_setup_frame " "env=%p frame_addr=%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , env, frame_addr);
        }
    }
}

static inline void trace_user_setup_rt_frame(void * env, uint64_t frame_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USER_SETUP_RT_FRAME)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:user_setup_rt_frame " "env=%p frame_addr=%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , env, frame_addr);
        }
    }
}

static inline void trace_user_do_rt_sigreturn(void * env, uint64_t frame_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USER_DO_RT_SIGRETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:user_do_rt_sigreturn " "env=%p frame_addr=%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , env, frame_addr);
        }
    }
}

static inline void trace_user_do_sigreturn(void * env, uint64_t frame_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USER_DO_SIGRETURN)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:user_do_sigreturn " "env=%p frame_addr=%"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , env, frame_addr);
        }
    }
}

static inline void trace_user_force_sig(void * env, int target_sig, int host_sig)
{
    if (true) {
        if (trace_event_get_state(TRACE_USER_FORCE_SIG)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:user_force_sig " "env=%p signal %d (host %d)" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , env, target_sig, host_sig);
        }
    }
}

static inline void trace_user_handle_signal(void * env, int target_sig)
{
    if (true) {
        if (trace_event_get_state(TRACE_USER_HANDLE_SIGNAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:user_handle_signal " "env=%p signal %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , env, target_sig);
        }
    }
}

static inline void trace_user_host_signal(void * env, int host_sig, int target_sig)
{
    if (true) {
        if (trace_event_get_state(TRACE_USER_HOST_SIGNAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:user_host_signal " "env=%p signal %d (target %d(" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , env, host_sig, target_sig);
        }
    }
}

static inline void trace_user_queue_signal(void * env, int target_sig)
{
    if (true) {
        if (trace_event_get_state(TRACE_USER_QUEUE_SIGNAL)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:user_queue_signal " "env=%p signal %d" "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , env, target_sig);
        }
    }
}

static inline void trace_user_s390x_restore_sigregs(void * env, uint64_t sc_psw_addr, uint64_t env_psw_addr)
{
    if (true) {
        if (trace_event_get_state(TRACE_USER_S390X_RESTORE_SIGREGS)) {
            struct timeval _now;
            gettimeofday(&_now, NULL);
            qemu_log_mask(LOG_TRACE, "%d@%zd.%06zd:user_s390x_restore_sigregs " "env=%p frame psw.addr %"PRIx64 " current psw.addr %"PRIx64 "\n",
                          getpid(),
                          (size_t)_now.tv_sec, (size_t)_now.tv_usec
                          , env, sc_psw_addr, env_psw_addr);
        }
    }
}
#endif /* TRACE__GENERATED_TRACERS_H */
