#line 1 "numpy/core/src/umath/loops_umath_fp.dispatch.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/*@targets
 ** $maxopt baseline avx512_skx
 */
#include "numpy/npy_math.h"
#include "simd/simd.h"
#include "loops_utils.h"
#include "loops.h"
#include "npy_svml.h"
#include "fast_loop_macros.h"

#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
#line 16
#line 20
static void
simd_exp2_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_exp2f16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_log2_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 1
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 1);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 1);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_log2f16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_log10_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 1
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 1);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 1);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_log10f16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_expm1_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 1
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 1);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 1);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_expm1f16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_log1p_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_log1pf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_cbrt_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_cbrtf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_tan_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_tanf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_asin_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_asinf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_acos_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_acosf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_atan_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_atanf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_sinh_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_sinhf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_cosh_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_coshf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_asinh_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_asinhf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_acosh_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 1
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 1);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 1);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_acoshf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_atanh_f32(const npyv_lanetype_f32 *src, npy_intp ssrc,
                        npyv_lanetype_f32 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f32;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f32 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f32(src, len, 0);
            } else {
                x = npyv_loadn_till_f32(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f32(src, len);
            } else {
                x = npyv_loadn_tillz_f32(src, ssrc, len);
            }
        #endif
        npyv_f32 out = __svml_atanhf16(x);
        if (sdst == 1) {
            npyv_store_till_f32(dst, len, out);
        } else {
            npyv_storen_till_f32(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}


#line 16
#line 20
static void
simd_exp2_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_exp28(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_log2_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 1
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 1);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 1);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_log28(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_log10_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 1
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 1);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 1);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_log108(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_expm1_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 1
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 1);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 1);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_expm18(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_log1p_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_log1p8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_cbrt_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_cbrt8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_tan_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_tan8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_asin_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_asin8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_acos_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_acos8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_atan_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_atan8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_sinh_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_sinh8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_cosh_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_cosh8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_asinh_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_asinh8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_acosh_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 1
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 1);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 1);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_acosh8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 20
static void
simd_atanh_f64(const npyv_lanetype_f64 *src, npy_intp ssrc,
                        npyv_lanetype_f64 *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        #if 0
            if (ssrc == 1) {
                x = npyv_load_till_f64(src, len, 0);
            } else {
                x = npyv_loadn_till_f64(src, ssrc, len, 0);
            }
        #else
            if (ssrc == 1) {
                x = npyv_load_tillz_f64(src, len);
            } else {
                x = npyv_loadn_tillz_f64(src, ssrc, len);
            }
        #endif
        npyv_f64 out = __svml_atanh8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}



#line 55
static void
simd_sin_f64(const double *src, npy_intp ssrc,
                      double *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        if (ssrc == 1) {
            x = npyv_load_tillz_f64(src, len);
        } else {
            x = npyv_loadn_tillz_f64(src, ssrc, len);
        }
        npyv_f64 out = __svml_sin8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#line 55
static void
simd_cos_f64(const double *src, npy_intp ssrc,
                      double *dst, npy_intp sdst, npy_intp len)
{
    const int vstep = npyv_nlanes_f64;
    for (; len > 0; len -= vstep, src += ssrc*vstep, dst += sdst*vstep) {
        npyv_f64 x;
        if (ssrc == 1) {
            x = npyv_load_tillz_f64(src, len);
        } else {
            x = npyv_loadn_tillz_f64(src, ssrc, len);
        }
        npyv_f64 out = __svml_cos8(x);
        if (sdst == 1) {
            npyv_store_till_f64(dst, len, out);
        } else {
            npyv_storen_till_f64(dst, sdst, len, out);
        }
    }
    npyv_cleanup();
}

#endif

#line 85
#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_exp2)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_exp2_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_exp2(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_log2)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_log2_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_log2(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_log10)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_log10_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_log10(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_expm1)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_expm1_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_expm1(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_log1p)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_log1p_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_log1p(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_cbrt)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_cbrt_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_cbrt(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_tan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_tan_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_tan(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_arcsin)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_asin_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_asin(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_arccos)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_acos_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_acos(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_arctan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_atan_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_atan(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_sinh)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_sinh_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_sinh(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_cosh)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_cosh_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_cosh(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_arcsinh)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_asinh_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_asinh(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_arccosh)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_acosh_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_acosh(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_arctanh)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_double *src = (npy_double*)args[0];
          npy_double *dst = (npy_double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_atanh_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_atanh(in1);
    }
}


#line 85
#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_exp2)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_exp2_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_exp2f(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_log2)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_log2_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_log2f(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_log10)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_log10_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_log10f(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_expm1)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_expm1_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_expm1f(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_log1p)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_log1p_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_log1pf(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_cbrt)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_cbrt_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_cbrtf(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_tan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_tan_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_tanf(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_arcsin)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_asin_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_asinf(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_arccos)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_acos_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_acosf(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_arctan)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_atan_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_atanf(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_sinh)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_sinh_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_sinhf(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_cosh)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_cosh_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_coshf(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_arcsinh)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_asinh_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_asinhf(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_arccosh)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_acosh_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_acoshf(in1);
    }
}

#line 89
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(FLOAT_arctanh)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const npy_float *src = (npy_float*)args[0];
          npy_float *dst = (npy_float*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f32(ssrc) &&
        npyv_storable_stride_f32(sdst)) {
        simd_atanh_f32(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *(npy_float *)op1 = npy_atanhf(in1);
    }
}



#line 118
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_sin)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const double *src = (double*)args[0];
          double *dst = (double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_sin_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_sin(in1);
    }
}

#line 118
NPY_NO_EXPORT void NPY_CPU_DISPATCH_CURFX(DOUBLE_cos)
(char **args, npy_intp const *dimensions, npy_intp const *steps, void *NPY_UNUSED(data))
{
#if NPY_SIMD && defined(NPY_HAVE_AVX512_SKX) && defined(NPY_CAN_LINK_SVML)
    const double *src = (double*)args[0];
          double *dst = (double*)args[1];
    const int lsize = sizeof(src[0]);
    const npy_intp ssrc = steps[0] / lsize;
    const npy_intp sdst = steps[1] / lsize;
    const npy_intp len = dimensions[0];
    assert(len <= 1 || (steps[0] % lsize == 0 && steps[1] % lsize == 0));
    if (!is_mem_overlap(src, steps[0], dst, steps[1], len) &&
        npyv_loadable_stride_f64(ssrc) &&
        npyv_storable_stride_f64(sdst)) {
        simd_cos_f64(src, ssrc, dst, sdst, len);
        return;
    }
#endif
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *(npy_double *)op1 = npy_cos(in1);
    }
}


